/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib;

import org.spongepowered.asm.lib.AnnotationVisitor;
import org.spongepowered.asm.lib.ByteVector;
import org.spongepowered.asm.lib.ClassWriter;
import org.spongepowered.asm.lib.Item;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.TypePath;

final class AnnotationWriter
extends AnnotationVisitor {
    private final ClassWriter cw;
    private int size;
    private final boolean named;
    private final ByteVector bv;
    private final ByteVector parent;
    private final int offset;
    AnnotationWriter next;
    AnnotationWriter prev;

    AnnotationWriter(ClassWriter classWriter, boolean bl, ByteVector byteVector, ByteVector byteVector2, int n) {
        super(0x6C01F595 ^ 0x6C04F595);
        this.cw = classWriter;
        this.named = bl;
        this.bv = byteVector;
        this.parent = byteVector2;
        this.offset = n;
    }

    public void visit(String string, Object object) {
        this.size += 0x6E767523 ^ 0x6E767522;
        if (this.named) {
            this.bv.putShort(this.cw.newUTF8(string));
        }
        if (object instanceof String) {
            this.bv.put12(0x9A6D3CA5 ^ 0x9A6D3CD6, this.cw.newUTF8((String)object));
        } else if (object instanceof Byte) {
            this.bv.put12(0xFD0BF7E2 ^ 0xFD0BF7A0, this.cw.newInteger((int)((Byte)object).byteValue()).index);
        } else if (object instanceof Boolean) {
            int n = ((Boolean)object).booleanValue() ? 0xA90EC0C ^ 0xA90EC0D : 0xD72A6422 ^ 0xD72A6422;
            this.bv.put12(0xB47058CD ^ 0xB4705897, this.cw.newInteger((int)n).index);
        } else if (object instanceof Character) {
            this.bv.put12(0x1EF21F23 ^ 0x1EF21F60, this.cw.newInteger((int)((Character)object).charValue()).index);
        } else if (object instanceof Short) {
            this.bv.put12(0xBBA8E335 ^ 0xBBA8E366, this.cw.newInteger((int)((Short)object).shortValue()).index);
        } else if (object instanceof Type) {
            this.bv.put12(0xA93F58A1 ^ 0xA93F58C2, this.cw.newUTF8(((Type)object).getDescriptor()));
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            this.bv.put12(0x6BA131E6 ^ 0x6BA131BD, byArray.length);
            for (int i = 0xDEEF93DF ^ 0xDEEF93DF; i < byArray.length; ++i) {
                this.bv.put12(0x2142EBEF ^ 0x2142EBAD, this.cw.newInteger((int)byArray[i]).index);
            }
        } else if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            this.bv.put12(0xB154EEFF ^ 0xB154EEA4, blArray.length);
            for (int i = 0x98A1574A ^ 0x98A1574A; i < blArray.length; ++i) {
                this.bv.put12(0xA122FB98 ^ 0xA122FBC2, this.cw.newInteger((int)(blArray[i] ? 0x73D6DD4D ^ 0x73D6DD4C : 0xE8915A6B ^ 0xE8915A6B)).index);
            }
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            this.bv.put12(0x1096F7D0 ^ 0x1096F78B, sArray.length);
            for (int i = 0x4FD8E280 ^ 0x4FD8E280; i < sArray.length; ++i) {
                this.bv.put12(0x2C888E23 ^ 0x2C888E70, this.cw.newInteger((int)sArray[i]).index);
            }
        } else if (object instanceof char[]) {
            char[] cArray = (char[])object;
            this.bv.put12(0xD16D5069 ^ 0xD16D5032, cArray.length);
            for (int i = 0x8E17275D ^ 0x8E17275D; i < cArray.length; ++i) {
                this.bv.put12(0xDF338FCC ^ 0xDF338F8F, this.cw.newInteger((int)cArray[i]).index);
            }
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            this.bv.put12(0x185FB2DF ^ 0x185FB284, nArray.length);
            for (int i = 0x3E7B989D ^ 0x3E7B989D; i < nArray.length; ++i) {
                this.bv.put12(0x2F4C7EF3 ^ 0x2F4C7EBA, this.cw.newInteger((int)nArray[i]).index);
            }
        } else if (object instanceof long[]) {
            long[] lArray = (long[])object;
            this.bv.put12(0xFEE3F430 ^ 0xFEE3F46B, lArray.length);
            for (int i = 0x71729F85 ^ 0x71729F85; i < lArray.length; ++i) {
                this.bv.put12(0xE2CDDF31 ^ 0xE2CDDF7B, this.cw.newLong((long)lArray[i]).index);
            }
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            this.bv.put12(0xD212E419 ^ 0xD212E442, fArray.length);
            for (int i = 0x8238E91A ^ 0x8238E91A; i < fArray.length; ++i) {
                this.bv.put12(0x2787C045 ^ 0x2787C003, this.cw.newFloat((float)fArray[i]).index);
            }
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            this.bv.put12(0x525A3298 ^ 0x525A32C3, dArray.length);
            for (int i = 0x78A431ED ^ 0x78A431ED; i < dArray.length; ++i) {
                this.bv.put12(0x82BC27B0 ^ 0x82BC27F4, this.cw.newDouble((double)dArray[i]).index);
            }
        } else {
            Item item = this.cw.newConstItem(object);
            this.bv.put12(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("<\ua7f5\ua4fb\ua058\ua923\u7d5c\u8e6e\u2459\u8b04").charAt(item.type), item.index);
        }
    }

    public void visitEnum(String string, String string2, String string3) {
        this.size += 0x53B43172 ^ 0x53B43173;
        if (this.named) {
            this.bv.putShort(this.cw.newUTF8(string));
        }
        this.bv.put12(0xED15CB6C ^ 0xED15CB09, this.cw.newUTF8(string2)).putShort(this.cw.newUTF8(string3));
    }

    public AnnotationVisitor visitAnnotation(String string, String string2) {
        this.size += 0x3E5DEF40 ^ 0x3E5DEF41;
        if (this.named) {
            this.bv.putShort(this.cw.newUTF8(string));
        }
        this.bv.put12(0x69D19305 ^ 0x69D19345, this.cw.newUTF8(string2)).putShort(0xE8590994 ^ 0xE8590994);
        return new AnnotationWriter(this.cw, (0x14A3CD8E ^ 0x14A3CD8F) != 0, this.bv, this.bv, this.bv.length - (0x9DF314FB ^ 0x9DF314F9));
    }

    public AnnotationVisitor visitArray(String string) {
        this.size += 0x6CAC6AE7 ^ 0x6CAC6AE6;
        if (this.named) {
            this.bv.putShort(this.cw.newUTF8(string));
        }
        this.bv.put12(0x2281FB38 ^ 0x2281FB63, 0x6A203766 ^ 0x6A203766);
        return new AnnotationWriter(this.cw, (0x973E84EA ^ 0x973E84EA) != 0, this.bv, this.bv, this.bv.length - (0xE839AB3A ^ 0xE839AB38));
    }

    public void visitEnd() {
        if (this.parent != null) {
            byte[] byArray = this.parent.data;
            byArray[this.offset] = (byte)(this.size >>> (0x285CF049 ^ 0x285CF041));
            byArray[this.offset + (0x85362941 ^ 0x85362940)] = (byte)this.size;
        }
    }

    int getSize() {
        int n = 0x930A4ABD ^ 0x930A4ABD;
        AnnotationWriter annotationWriter = this;
        while (annotationWriter != null) {
            n += annotationWriter.bv.length;
            annotationWriter = annotationWriter.next;
        }
        return n;
    }

    void put(ByteVector byteVector) {
        int n = 0xD752704D ^ 0xD752704D;
        int n2 = 0xEFB593DF ^ 0xEFB593DD;
        AnnotationWriter annotationWriter = this;
        AnnotationWriter annotationWriter2 = null;
        while (annotationWriter != null) {
            ++n;
            n2 += annotationWriter.bv.length;
            annotationWriter.visitEnd();
            annotationWriter.prev = annotationWriter2;
            annotationWriter2 = annotationWriter;
            annotationWriter = annotationWriter.next;
        }
        byteVector.putInt(n2);
        byteVector.putShort(n);
        annotationWriter = annotationWriter2;
        while (annotationWriter != null) {
            byteVector.putByteArray(annotationWriter.bv.data, 0xF0AFBCD5 ^ 0xF0AFBCD5, annotationWriter.bv.length);
            annotationWriter = annotationWriter.prev;
        }
    }

    static void put(AnnotationWriter[] annotationWriterArray, int n, ByteVector byteVector) {
        int n2;
        int n3 = (0x1AD3DDB8 ^ 0x1AD3DDB9) + (0xA6D49E2B ^ 0xA6D49E29) * (annotationWriterArray.length - n);
        for (n2 = n; n2 < annotationWriterArray.length; ++n2) {
            n3 += annotationWriterArray[n2] == null ? 0x8005A978 ^ 0x8005A978 : annotationWriterArray[n2].getSize();
        }
        byteVector.putInt(n3).putByte(annotationWriterArray.length - n);
        for (n2 = n; n2 < annotationWriterArray.length; ++n2) {
            AnnotationWriter annotationWriter = annotationWriterArray[n2];
            AnnotationWriter annotationWriter2 = null;
            int n4 = 0x536814CA ^ 0x536814CA;
            while (annotationWriter != null) {
                ++n4;
                annotationWriter.visitEnd();
                annotationWriter.prev = annotationWriter2;
                annotationWriter2 = annotationWriter;
                annotationWriter = annotationWriter.next;
            }
            byteVector.putShort(n4);
            annotationWriter = annotationWriter2;
            while (annotationWriter != null) {
                byteVector.putByteArray(annotationWriter.bv.data, 0xD5D46EEF ^ 0xD5D46EEF, annotationWriter.bv.length);
                annotationWriter = annotationWriter.prev;
            }
        }
    }

    static void putTarget(int n, TypePath typePath, ByteVector byteVector) {
        switch (n >>> (0xA9DBB231 ^ 0xA9DBB229)) {
            case 0: 
            case 1: 
            case 22: {
                byteVector.putShort(n >>> (0x2D506980 ^ 0x2D506990));
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                byteVector.putByte(n >>> (0x28EC5AA9 ^ 0x28EC5AB1));
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                byteVector.putInt(n);
                break;
            }
            default: {
                byteVector.put12(n >>> (0x9FCD88B5 ^ 0x9FCD88AD), (n & (0xD2B594D8 ^ 0xD24A6BD8)) >> (0x3C04710E ^ 0x3C047106));
            }
        }
        if (typePath == null) {
            byteVector.putByte(0x4B0B809E ^ 0x4B0B809E);
        } else {
            int n2 = typePath.b[typePath.offset] * (0x78552155 ^ 0x78552157) + (0x87F1B4E8 ^ 0x87F1B4E9);
            byteVector.putByteArray(typePath.b, typePath.offset, n2);
        }
    }
}

