/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib;

import java.io.IOException;
import java.io.InputStream;
import org.spongepowered.asm.lib.AnnotationVisitor;
import org.spongepowered.asm.lib.Attribute;
import org.spongepowered.asm.lib.ByteVector;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.ClassWriter;
import org.spongepowered.asm.lib.Context;
import org.spongepowered.asm.lib.FieldVisitor;
import org.spongepowered.asm.lib.Handle;
import org.spongepowered.asm.lib.Item;
import org.spongepowered.asm.lib.Label;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.MethodWriter;
import org.spongepowered.asm.lib.Opcodes;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.TypePath;

public class ClassReader {
    static final boolean SIGNATURES = true;
    static final boolean ANNOTATIONS = true;
    static final boolean FRAMES = true;
    static final boolean WRITER = true;
    static final boolean RESIZE = true;
    public static final int SKIP_CODE = 1;
    public static final int SKIP_DEBUG = 2;
    public static final int SKIP_FRAMES = 4;
    public static final int EXPAND_FRAMES = 8;
    static final int EXPAND_ASM_INSNS = 256;
    public final byte[] b;
    private final int[] items;
    private final String[] strings;
    private final int maxStringLength;
    public final int header;

    public ClassReader(byte[] byArray) {
        this(byArray, 0xE801B3BA ^ 0xE801B3BA, byArray.length);
    }

    public ClassReader(byte[] byArray, int n, int n2) {
        this.b = byArray;
        if (this.readShort(n + (0xBB8044C0 ^ 0xBB8044C6)) > (0x51BB0D9C ^ 0x51BB0DA8)) {
            throw new IllegalArgumentException();
        }
        this.items = new int[this.readUnsignedShort(n + (0x8E80B140 ^ 0x8E80B148))];
        int n3 = this.items.length;
        this.strings = new String[n3];
        int n4 = 0x7A44974F ^ 0x7A44974F;
        int n5 = n + (0x7673AB7A ^ 0x7673AB70);
        for (int i = 0x19A4B447 ^ 0x19A4B446; i < n3; ++i) {
            int n6;
            this.items[i] = n5 + (0x7DFE3A68 ^ 0x7DFE3A69);
            switch (byArray[n5]) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    n6 = 0xCF9EFB9F ^ 0xCF9EFB9A;
                    break;
                }
                case 5: 
                case 6: {
                    n6 = 0x239E10EE ^ 0x239E10E7;
                    ++i;
                    break;
                }
                case 1: {
                    n6 = (0x6DB84CA0 ^ 0x6DB84CA3) + this.readUnsignedShort(n5 + (0xFF2848D ^ 0xFF2848C));
                    if (n6 <= n4) break;
                    n4 = n6;
                    break;
                }
                case 15: {
                    n6 = 0xB7F435A7 ^ 0xB7F435A3;
                    break;
                }
                default: {
                    n6 = 0x19B742EC ^ 0x19B742EF;
                }
            }
            n5 += n6;
        }
        this.maxStringLength = n4;
        this.header = n5;
    }

    public int getAccess() {
        return this.readUnsignedShort(this.header);
    }

    public String getClassName() {
        return this.readClass(this.header + (0x25B947B4 ^ 0x25B947B6), new char[this.maxStringLength]);
    }

    public String getSuperName() {
        return this.readClass(this.header + (0xFD2977A8 ^ 0xFD2977AC), new char[this.maxStringLength]);
    }

    public String[] getInterfaces() {
        int n = this.header + (0x8A3B93F ^ 0x8A3B939);
        int n2 = this.readUnsignedShort(n);
        String[] stringArray = new String[n2];
        if (n2 > 0) {
            char[] cArray = new char[this.maxStringLength];
            for (int i = 0x9953BC38 ^ 0x9953BC38; i < n2; ++i) {
                stringArray[i] = this.readClass(n += 2, cArray);
            }
        }
        return stringArray;
    }

    void copyPool(ClassWriter classWriter) {
        int n;
        char[] cArray = new char[this.maxStringLength];
        int n2 = this.items.length;
        Item[] itemArray = new Item[n2];
        for (n = 0x1E0220B4 ^ 0x1E0220B5; n < n2; ++n) {
            int n3;
            int n4 = this.items[n];
            byte by = this.b[n4 - (0xB6F879FB ^ 0xB6F879FA)];
            Item item = new Item(n);
            switch (by) {
                case 9: 
                case 10: 
                case 11: {
                    int n5 = this.items[this.readUnsignedShort(n4 + (0xC82D43A2 ^ 0xC82D43A0))];
                    item.set(by, this.readClass(n4, cArray), this.readUTF8(n5, cArray), this.readUTF8(n5 + (0x81027470 ^ 0x81027472), cArray));
                    break;
                }
                case 3: {
                    item.set(this.readInt(n4));
                    break;
                }
                case 4: {
                    item.set(Float.intBitsToFloat(this.readInt(n4)));
                    break;
                }
                case 12: {
                    item.set(by, this.readUTF8(n4, cArray), this.readUTF8(n4 + (0x922B5CFD ^ 0x922B5CFF), cArray), null);
                    break;
                }
                case 5: {
                    item.set(this.readLong(n4));
                    ++n;
                    break;
                }
                case 6: {
                    item.set(Double.longBitsToDouble(this.readLong(n4)));
                    ++n;
                    break;
                }
                case 1: {
                    String string = this.strings[n];
                    if (string == null) {
                        n4 = this.items[n];
                        string = this.strings[n] = this.readUTF(n4 + (0x81292342 ^ 0x81292340), this.readUnsignedShort(n4), cArray);
                    }
                    item.set(by, string, null, null);
                    break;
                }
                case 15: {
                    n3 = this.items[this.readUnsignedShort(n4 + (0x39C6B1EA ^ 0x39C6B1EB))];
                    int n5 = this.items[this.readUnsignedShort(n3 + (0x50EA21F3 ^ 0x50EA21F1))];
                    item.set((0x1A502A ^ 0x1A503E) + this.readByte(n4), this.readClass(n3, cArray), this.readUTF8(n5, cArray), this.readUTF8(n5 + (0x7E17ADED ^ 0x7E17ADEF), cArray));
                    break;
                }
                case 18: {
                    if (classWriter.bootstrapMethods == null) {
                        this.copyBootstrapMethods(classWriter, itemArray, cArray);
                    }
                    int n5 = this.items[this.readUnsignedShort(n4 + (0xDE7B0029 ^ 0xDE7B002B))];
                    item.set(this.readUTF8(n5, cArray), this.readUTF8(n5 + (0x52DB2A93 ^ 0x52DB2A91), cArray), this.readUnsignedShort(n4));
                    break;
                }
                default: {
                    item.set(by, this.readUTF8(n4, cArray), null, null);
                }
            }
            n3 = item.hashCode % itemArray.length;
            item.next = itemArray[n3];
            itemArray[n3] = item;
        }
        n = this.items[0x6DEFF368 ^ 0x6DEFF369] - (0x5294C379 ^ 0x5294C378);
        classWriter.pool.putByteArray(this.b, n, this.header - n);
        classWriter.items = itemArray;
        classWriter.threshold = (int)(0.75 * (double)n2);
        classWriter.index = n2;
    }

    private void copyBootstrapMethods(ClassWriter classWriter, Item[] itemArray, char[] cArray) {
        int n;
        int n2;
        int n3 = this.getAttributes();
        int n4 = 0x3EEEDA88 ^ 0x3EEEDA88;
        for (n2 = this.readUnsignedShort(n3); n2 > 0; --n2) {
            String string = this.readUTF8(n3 + (0x6C8DE3E5 ^ 0x6C8DE3E7), cArray);
            if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("P\ua7e9\ua4ba\ua065\ua916\u7d62\u8e58\u247b\u8b27\u345aw\ua7f2\ua4bd\ua07e\ua901\u7d65").equals(string)) {
                n4 = 0x99912B91 ^ 0x99912B90;
                break;
            }
            n3 += (0x9B27AE11 ^ 0x9B27AE17) + this.readInt(n3 + (0x4B6BB737 ^ 0x4B6BB733));
        }
        if (n4 == 0) {
            return;
        }
        n2 = this.readUnsignedShort(n3 + (0xBCEC7060 ^ 0xBCEC7068));
        int n5 = n3 + (0xA51ECBCB ^ 0xA51ECBC1);
        for (n = 0x33B9FBBF ^ 0x33B9FBBF; n < n2; ++n) {
            int n6 = n5 - n3 - (0xFEE9159A ^ 0xFEE91590);
            int n7 = this.readConst(this.readUnsignedShort(n5), cArray).hashCode();
            for (int i = this.readUnsignedShort(n5 + (0x7D88B593 ^ 0x7D88B591)); i > 0; --i) {
                n7 ^= this.readConst(this.readUnsignedShort(n5 + (0x4F8F3AA6 ^ 0x4F8F3AA2)), cArray).hashCode();
                n5 += 2;
            }
            n5 += 4;
            Item item = new Item(n);
            item.set(n6, n7 & (0x5EBCF132 ^ 0x21430ECD));
            int n8 = item.hashCode % itemArray.length;
            item.next = itemArray[n8];
            itemArray[n8] = item;
        }
        n = this.readInt(n3 + (0xF9382785 ^ 0xF9382781));
        ByteVector byteVector = new ByteVector(n + (0x545338FD ^ 0x545338C3));
        byteVector.putByteArray(this.b, n3 + (0x701ABCAC ^ 0x701ABCA6), n - (0x87DAF78C ^ 0x87DAF78E));
        classWriter.bootstrapMethodsCount = n2;
        classWriter.bootstrapMethods = byteVector;
    }

    public ClassReader(InputStream inputStream) throws IOException {
        this(ClassReader.readClass(inputStream, (0x59441AA3 ^ 0x59441AA3) != 0));
    }

    public ClassReader(String string) throws IOException {
        this(ClassReader.readClass(ClassLoader.getSystemResourceAsStream(string.replace((char)(0xEF28791B ^ 0xEF287935), (char)(0x4FBF3EF2 ^ 0x4FBF3EDD)) + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("<\ua7e5\ua4b9\ua070\ua916\u7d65")), (0x7AEC7D9F ^ 0x7AEC7D9E) != 0));
    }

    private static byte[] readClass(InputStream inputStream, boolean bl) throws IOException {
        if (inputStream == null) {
            throw new IOException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7ea\ua4b4\ua062\ua916\u7d36\u8e44\u2475\u8b23\u3437t\ua7e9\ua4a0\ua07f\ua901"));
        }
        try {
            byte[] byArray = new byte[inputStream.available()];
            int n = 0x2412A0C8 ^ 0x2412A0C8;
            while (true) {
                byte[] byArray2;
                int n2 = inputStream.read(byArray, n, byArray.length - n);
                if (n2 == (0x52EBC016 ^ 0xAD143FE9)) {
                    byte[] byArray3;
                    if (n < byArray.length) {
                        byArray3 = new byte[n];
                        System.arraycopy(byArray, 0x88B0AAE2 ^ 0x88B0AAE2, byArray3, 0xB1A966F1 ^ 0xB1A966F1, n);
                        byArray = byArray3;
                    }
                    byArray3 = byArray;
                    return byArray3;
                }
                if ((n += n2) != byArray.length) continue;
                int n3 = inputStream.read();
                if (n3 < 0) {
                    byArray2 = byArray;
                    return byArray2;
                }
                byArray2 = new byte[byArray.length + (0x3332399C ^ 0x33323A74)];
                System.arraycopy(byArray, 0x1DBC9EB7 ^ 0x1DBC9EB7, byArray2, 0x3F7328A2 ^ 0x3F7328A2, n);
                byArray2[n++] = (byte)n3;
                byArray = byArray2;
            }
        }
        finally {
            if (bl) {
                inputStream.close();
            }
        }
    }

    public void accept(ClassVisitor classVisitor, int n) {
        this.accept(classVisitor, new Attribute[0xF240ABE1 ^ 0xF240ABE1], n);
    }

    public void accept(ClassVisitor classVisitor, Attribute[] attributeArray, int n) {
        int n2;
        int n3 = this.header;
        char[] cArray = new char[this.maxStringLength];
        Context context = new Context();
        context.attrs = attributeArray;
        context.flags = n;
        context.buffer = cArray;
        int n4 = this.readUnsignedShort(n3);
        String string = this.readClass(n3 + (0x5B159040 ^ 0x5B159042), cArray);
        String string2 = this.readClass(n3 + (0xA4CD36A7 ^ 0xA4CD36A3), cArray);
        String[] stringArray = new String[this.readUnsignedShort(n3 + (0xAB647EBF ^ 0xAB647EB9))];
        n3 += 8;
        for (int i = 0x2370E408 ^ 0x2370E408; i < stringArray.length; ++i) {
            stringArray[i] = this.readClass(n3, cArray);
            n3 += 2;
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        int n5 = 0xD8E2BBF2 ^ 0xD8E2BBF2;
        int n6 = 0x378E6DA9 ^ 0x378E6DA9;
        int n7 = 0x454AE8C7 ^ 0x454AE8C7;
        int n8 = 0xC805E841 ^ 0xC805E841;
        int n9 = 0x116908B2 ^ 0x116908B2;
        Attribute attribute = null;
        n3 = this.getAttributes();
        for (n2 = this.readUnsignedShort(n3); n2 > 0; --n2) {
            String string9 = this.readUTF8(n3 + (0x70D6CD39 ^ 0x70D6CD3B), cArray);
            if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7e9\ua4a0\ua063\ua906\u7d73\u8e6c\u2473\u8b3b\u3472").equals(string9)) {
                string4 = this.readUTF8(n3 + (0x449957C0 ^ 0x449957C8), cArray);
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4bb\ua074\ua917\u7d55\u8e46\u247b\u8b24\u3464w\ua7f5").equals(string9)) {
                n9 = n3 + (0x297B4AAD ^ 0x297B4AA5);
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("W\ua7e8\ua4b6\ua07d\ua90a\u7d65\u8e43\u2474\u8b30\u345aw\ua7f2\ua4bd\ua07e\ua901").equals(string9)) {
                string6 = this.readClass(n3 + (0xA7929ECF ^ 0xA7929EC7), cArray);
                int n10 = this.readUnsignedShort(n3 + (0x1ADF4E2D ^ 0x1ADF4E27));
                if (n10 != 0) {
                    string7 = this.readUTF8(this.items[n10], cArray);
                    string8 = this.readUTF8(this.items[n10] + (0x2D306B71 ^ 0x2D306B73), cArray);
                }
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7ef\ua4b2\ua07f\ua904\u7d62\u8e5f\u2468\u8b32").equals(string9)) {
                string3 = this.readUTF8(n3 + (0x43AEC672 ^ 0x43AEC67A), cArray);
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7f3\ua4bb\ua065\ua90c\u7d7b\u8e4f\u244c\u8b3e\u3464{\ua7e4\ua4b9\ua074\ua924\u7d78\u8e44\u2475\u8b23\u3476f\ua7ef\ua4ba\ua07f\ua916").equals(string9)) {
                n5 = n3 + (0xB1C0D04B ^ 0xB1C0D043);
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7f3\ua4bb\ua065\ua90c\u7d7b\u8e4f\u244c\u8b3e\u3464{\ua7e4\ua4b9\ua074\ua931\u7d6f\u8e5a\u247f\u8b16\u3479|\ua7e9\ua4a1\ua070\ua911\u7d7f\u8e45\u2474\u8b24").equals(string9)) {
                n7 = n3 + (0x714522FF ^ 0x714522F7);
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("V\ua7e3\ua4a5\ua063\ua900\u7d75\u8e4b\u246e\u8b32\u3473").equals(string9)) {
                n4 |= 0x17CF3372 ^ 0x17CD3372;
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7ff\ua4bb\ua065\ua90d\u7d73\u8e5e\u2473\u8b34").equals(string9)) {
                n4 |= 0x99100DAC ^ 0x99141DAC;
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7e9\ua4a0\ua063\ua906\u7d73\u8e6e\u247f\u8b35\u3462u\ua7c3\ua4ad\ua065\ua900\u7d78\u8e59\u2473\u8b38\u3479").equals(string9)) {
                int n11 = this.readInt(n3 + (0xAE60FB2A ^ 0xAE60FB2E));
                string5 = this.readUTF(n3 + (0xD9EB84F ^ 0xD9EB847), n11, new char[n11]);
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7f3\ua4bb\ua065\ua90c\u7d7b\u8e4f\u2453\u8b39\u3461{\ua7f5\ua4bc\ua073\ua909\u7d73\u8e6b\u2474\u8b39\u3478f\ua7e7\ua4a1\ua078\ua90a\u7d78\u8e59").equals(string9)) {
                n6 = n3 + (0x7FA977CA ^ 0x7FA977C2);
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7f3\ua4bb\ua065\ua90c\u7d7b\u8e4f\u2453\u8b39\u3461{\ua7f5\ua4bc\ua073\ua909\u7d73\u8e7e\u2463\u8b27\u3472S\ua7e8\ua4bb\ua07e\ua911\u7d77\u8e5e\u2473\u8b38\u3479a").equals(string9)) {
                n8 = n3 + (0x251C7679 ^ 0x251C7671);
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("P\ua7e9\ua4ba\ua065\ua916\u7d62\u8e58\u247b\u8b27\u345aw\ua7f2\ua4bd\ua07e\ua901\u7d65").equals(string9)) {
                int[] nArray = new int[this.readUnsignedShort(n3 + (0x42FEB22B ^ 0x42FEB223))];
                int n12 = n3 + (0x68D386FB ^ 0x68D386F1);
                for (int i = 0x8CAB90D6 ^ 0x8CAB90D6; i < nArray.length; ++i) {
                    nArray[i] = n12;
                    n12 += (0xC727DC2E ^ 0xC727DC2C) + this.readUnsignedShort(n12 + (0xDC557341 ^ 0xDC557343)) << (0x94C1FB9D ^ 0x94C1FB9C);
                }
                context.bootstrapMethods = nArray;
            } else {
                Attribute attribute2 = this.readAttribute(attributeArray, string9, n3 + (0xB838D975 ^ 0xB838D97D), this.readInt(n3 + (0xB68D4E17 ^ 0xB68D4E13)), cArray, 0xAD0DD60 ^ 0xF52F229F, null);
                if (attribute2 != null) {
                    attribute2.next = attribute;
                    attribute = attribute2;
                }
            }
            n3 += (0x88117135 ^ 0x88117133) + this.readInt(n3 + (0xDF8247E ^ 0xDF8247A));
        }
        classVisitor.visit(this.readInt(this.items[0x618B578 ^ 0x618B579] - (0xCA44DC45 ^ 0xCA44DC42)), n4, string, string3, string2, stringArray);
        if ((n & (0xC430D486 ^ 0xC430D484)) == 0 && (string4 != null || string5 != null)) {
            classVisitor.visitSource(string4, string5);
        }
        if (string6 != null) {
            classVisitor.visitOuterClass(string6, string7, string8);
        }
        if (n5 != 0) {
            int n13 = n5 + (0x26D4F489 ^ 0x26D4F48B);
            for (n2 = this.readUnsignedShort(n5); n2 > 0; --n2) {
                n13 = this.readAnnotationValues(n13 + (0xDD0927F3 ^ 0xDD0927F1), cArray, (0xB60D3C87 ^ 0xB60D3C86) != 0, classVisitor.visitAnnotation(this.readUTF8(n13, cArray), (0x617EB6D6 ^ 0x617EB6D7) != 0));
            }
        }
        if (n6 != 0) {
            int n14 = n6 + (0x16DFC39 ^ 0x16DFC3B);
            for (n2 = this.readUnsignedShort(n6); n2 > 0; --n2) {
                n14 = this.readAnnotationValues(n14 + (0xBDDDA4F0 ^ 0xBDDDA4F2), cArray, (0xDCF8469F ^ 0xDCF8469E) != 0, classVisitor.visitAnnotation(this.readUTF8(n14, cArray), (0xB6491502 ^ 0xB6491502) != 0));
            }
        }
        if (n7 != 0) {
            int n15 = n7 + (0x4FD9D900 ^ 0x4FD9D902);
            for (n2 = this.readUnsignedShort(n7); n2 > 0; --n2) {
                n15 = this.readAnnotationTarget(context, n15);
                n15 = this.readAnnotationValues(n15 + (0x603BFB2C ^ 0x603BFB2E), cArray, (0xEE6E1267 ^ 0xEE6E1266) != 0, classVisitor.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(n15, cArray), (0x3FA9A806 ^ 0x3FA9A807) != 0));
            }
        }
        if (n8 != 0) {
            int n16 = n8 + (0xBE5911F9 ^ 0xBE5911FB);
            for (n2 = this.readUnsignedShort(n8); n2 > 0; --n2) {
                n16 = this.readAnnotationTarget(context, n16);
                n16 = this.readAnnotationValues(n16 + (0x35D2C5A3 ^ 0x35D2C5A1), cArray, (0x17825979 ^ 0x17825978) != 0, classVisitor.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(n16, cArray), (0x660948B1 ^ 0x660948B1) != 0));
            }
        }
        while (attribute != null) {
            Attribute attribute3 = attribute.next;
            attribute.next = null;
            classVisitor.visitAttribute(attribute);
            attribute = attribute3;
        }
        if (n9 != 0) {
            n2 = n9 + (0x45C6BA3F ^ 0x45C6BA3D);
            for (int i = this.readUnsignedShort(n9); i > 0; --i) {
                classVisitor.visitInnerClass(this.readClass(n2, cArray), this.readClass(n2 + (0x9CB5B8E8 ^ 0x9CB5B8EA), cArray), this.readUTF8(n2 + (0x689A2EC1 ^ 0x689A2EC5), cArray), this.readUnsignedShort(n2 + (0x616EEE ^ 0x616EE8)));
                n2 += 8;
            }
        }
        n3 = this.header + (0x102EDA5A ^ 0x102EDA50) + (0xD37EFE09 ^ 0xD37EFE0B) * stringArray.length;
        for (n2 = this.readUnsignedShort(n3 - (0xB9D3D996 ^ 0xB9D3D994)); n2 > 0; --n2) {
            n3 = this.readField(classVisitor, context, n3);
        }
        for (n2 = this.readUnsignedShort((n3 += 2) - (0x55B175A9 ^ 0x55B175AB)); n2 > 0; --n2) {
            n3 = this.readMethod(classVisitor, context, n3);
        }
        classVisitor.visitEnd();
    }

    private int readField(ClassVisitor classVisitor, Context context, int n) {
        int n2;
        char[] cArray = context.buffer;
        int n3 = this.readUnsignedShort(n);
        String string = this.readUTF8(n + (0xAD628CCF ^ 0xAD628CCD), cArray);
        String string2 = this.readUTF8(n + (0xA2FD1FBB ^ 0xA2FD1FBF), cArray);
        n += 6;
        String string3 = null;
        int n4 = 0xEA53E6BE ^ 0xEA53E6BE;
        int n5 = 0xFBA7FF93 ^ 0xFBA7FF93;
        int n6 = 0xE8E57DC8 ^ 0xE8E57DC8;
        int n7 = 0xA6A8405F ^ 0xA6A8405F;
        Object object = null;
        Attribute attribute = null;
        for (int i = this.readUnsignedShort(n); i > 0; --i) {
            String string4 = this.readUTF8(n + (0xF3757CA4 ^ 0xF3757CA6), cArray);
            if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e9\ua4bb\ua062\ua911\u7d77\u8e44\u246e\u8b01\u3476~\ua7f3\ua4b0").equals(string4)) {
                n2 = this.readUnsignedShort(n + (0x98BBAD53 ^ 0x98BBAD5B));
                object = n2 == 0 ? null : this.readConst(n2, cArray);
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7ef\ua4b2\ua07f\ua904\u7d62\u8e5f\u2468\u8b32").equals(string4)) {
                string3 = this.readUTF8(n + (0x55037B66 ^ 0x55037B6E), cArray);
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("V\ua7e3\ua4a5\ua063\ua900\u7d75\u8e4b\u246e\u8b32\u3473").equals(string4)) {
                n3 |= 0xB11EAB17 ^ 0xB11CAB17;
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7ff\ua4bb\ua065\ua90d\u7d73\u8e5e\u2473\u8b34").equals(string4)) {
                n3 |= 0x1C06B18 ^ 0x1C47B18;
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7f3\ua4bb\ua065\ua90c\u7d7b\u8e4f\u244c\u8b3e\u3464{\ua7e4\ua4b9\ua074\ua924\u7d78\u8e44\u2475\u8b23\u3476f\ua7ef\ua4ba\ua07f\ua916").equals(string4)) {
                n4 = n + (0xE13C5352 ^ 0xE13C535A);
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7f3\ua4bb\ua065\ua90c\u7d7b\u8e4f\u244c\u8b3e\u3464{\ua7e4\ua4b9\ua074\ua931\u7d6f\u8e5a\u247f\u8b16\u3479|\ua7e9\ua4a1\ua070\ua911\u7d7f\u8e45\u2474\u8b24").equals(string4)) {
                n6 = n + (0xA6CFDB26 ^ 0xA6CFDB2E);
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7f3\ua4bb\ua065\ua90c\u7d7b\u8e4f\u2453\u8b39\u3461{\ua7f5\ua4bc\ua073\ua909\u7d73\u8e6b\u2474\u8b39\u3478f\ua7e7\ua4a1\ua078\ua90a\u7d78\u8e59").equals(string4)) {
                n5 = n + (0x2D51261E ^ 0x2D512616);
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7f3\ua4bb\ua065\ua90c\u7d7b\u8e4f\u2453\u8b39\u3461{\ua7f5\ua4bc\ua073\ua909\u7d73\u8e7e\u2463\u8b27\u3472S\ua7e8\ua4bb\ua07e\ua911\u7d77\u8e5e\u2473\u8b38\u3479a").equals(string4)) {
                n7 = n + (0x7A6F581C ^ 0x7A6F5814);
            } else {
                Attribute attribute2 = this.readAttribute(context.attrs, string4, n + (0x8D05FA70 ^ 0x8D05FA78), this.readInt(n + (0xA1C59799 ^ 0xA1C5979D)), cArray, 0x30019050 ^ 0xCFFE6FAF, null);
                if (attribute2 != null) {
                    attribute2.next = attribute;
                    attribute = attribute2;
                }
            }
            n += (0x1F8F2B23 ^ 0x1F8F2B25) + this.readInt(n + (0xF8579BDF ^ 0xF8579BDB));
        }
        n += 2;
        FieldVisitor fieldVisitor = classVisitor.visitField(n3, string, string2, string3, object);
        if (fieldVisitor == null) {
            return n;
        }
        if (n4 != 0) {
            n2 = n4 + (0x4C882510 ^ 0x4C882512);
            for (int i = this.readUnsignedShort(n4); i > 0; --i) {
                n2 = this.readAnnotationValues(n2 + (0xBDB14064 ^ 0xBDB14066), cArray, (0xEEE19CA6 ^ 0xEEE19CA7) != 0, fieldVisitor.visitAnnotation(this.readUTF8(n2, cArray), (0xA2471B35 ^ 0xA2471B34) != 0));
            }
        }
        if (n5 != 0) {
            n2 = n5 + (0xD41BD1B9 ^ 0xD41BD1BB);
            for (int i = this.readUnsignedShort(n5); i > 0; --i) {
                n2 = this.readAnnotationValues(n2 + (0x300DC26 ^ 0x300DC24), cArray, (0xDE2CBA93 ^ 0xDE2CBA92) != 0, fieldVisitor.visitAnnotation(this.readUTF8(n2, cArray), (0xBAC9BBB8 ^ 0xBAC9BBB8) != 0));
            }
        }
        if (n6 != 0) {
            n2 = n6 + (0x3DAA7836 ^ 0x3DAA7834);
            for (int i = this.readUnsignedShort(n6); i > 0; --i) {
                n2 = this.readAnnotationTarget(context, n2);
                n2 = this.readAnnotationValues(n2 + (0xA9F36A62 ^ 0xA9F36A60), cArray, (0x4FB85EE9 ^ 0x4FB85EE8) != 0, fieldVisitor.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(n2, cArray), (0xFCAF0837 ^ 0xFCAF0836) != 0));
            }
        }
        if (n7 != 0) {
            n2 = n7 + (0x51D66045 ^ 0x51D66047);
            for (int i = this.readUnsignedShort(n7); i > 0; --i) {
                n2 = this.readAnnotationTarget(context, n2);
                n2 = this.readAnnotationValues(n2 + (0x7F24A075 ^ 0x7F24A077), cArray, (0xD5A7BA83 ^ 0xD5A7BA82) != 0, fieldVisitor.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(n2, cArray), (0xA9595882 ^ 0xA9595882) != 0));
            }
        }
        while (attribute != null) {
            Attribute attribute3 = attribute.next;
            attribute.next = null;
            fieldVisitor.visitAttribute(attribute);
            attribute = attribute3;
        }
        fieldVisitor.visitEnd();
        return n;
    }

    private int readMethod(ClassVisitor classVisitor, Context context, int n) {
        int n2;
        Object object;
        char[] cArray = context.buffer;
        context.access = this.readUnsignedShort(n);
        context.name = this.readUTF8(n + (0xF0DEBF3D ^ 0xF0DEBF3F), cArray);
        context.desc = this.readUTF8(n + (0x398B32FF ^ 0x398B32FB), cArray);
        n += 6;
        int n3 = 0x353AFB8A ^ 0x353AFB8A;
        int n4 = 0x9D5ADA7F ^ 0x9D5ADA7F;
        String[] stringArray = null;
        String string = null;
        int n5 = 0x234B45CE ^ 0x234B45CE;
        int n6 = 0xDF43ECCD ^ 0xDF43ECCD;
        int n7 = 0x80480144 ^ 0x80480144;
        int n8 = 0xA2537259 ^ 0xA2537259;
        int n9 = 0xF193ED5A ^ 0xF193ED5A;
        int n10 = 0x867A7D98 ^ 0x867A7D98;
        int n11 = 0xDB82F5F4 ^ 0xDB82F5F4;
        int n12 = 0x9FA26075 ^ 0x9FA26075;
        int n13 = n;
        Attribute attribute = null;
        for (int i = this.readUnsignedShort(n); i > 0; --i) {
            object = this.readUTF8(n + (0x67A01B64 ^ 0x67A01B66), cArray);
            if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e9\ua4b1\ua074").equals(object)) {
                if ((context.flags & (0xF9FEA7E9 ^ 0xF9FEA7E8)) == 0) {
                    n3 = n + (0x6C5B94FF ^ 0x6C5B94F7);
                }
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("W\ua7fe\ua4b6\ua074\ua915\u7d62\u8e43\u2475\u8b39\u3464").equals(object)) {
                stringArray = new String[this.readUnsignedShort(n + (0x10FCFECE ^ 0x10FCFEC6))];
                n4 = n + (0xFB8048F5 ^ 0xFB8048FF);
                for (n2 = 0xE4B9129B ^ 0xE4B9129B; n2 < stringArray.length; ++n2) {
                    stringArray[n2] = this.readClass(n4, cArray);
                    n4 += 2;
                }
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7ef\ua4b2\ua07f\ua904\u7d62\u8e5f\u2468\u8b32").equals(object)) {
                string = this.readUTF8(n + (0x1D82B009 ^ 0x1D82B001), cArray);
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("V\ua7e3\ua4a5\ua063\ua900\u7d75\u8e4b\u246e\u8b32\u3473").equals(object)) {
                context.access |= 0x3E7C8E67 ^ 0x3E7E8E67;
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7f3\ua4bb\ua065\ua90c\u7d7b\u8e4f\u244c\u8b3e\u3464{\ua7e4\ua4b9\ua074\ua924\u7d78\u8e44\u2475\u8b23\u3476f\ua7ef\ua4ba\ua07f\ua916").equals(object)) {
                n6 = n + (0xC28F48D6 ^ 0xC28F48DE);
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7f3\ua4bb\ua065\ua90c\u7d7b\u8e4f\u244c\u8b3e\u3464{\ua7e4\ua4b9\ua074\ua931\u7d6f\u8e5a\u247f\u8b16\u3479|\ua7e9\ua4a1\ua070\ua911\u7d7f\u8e45\u2474\u8b24").equals(object)) {
                n8 = n + (0x39DA2410 ^ 0x39DA2418);
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("S\ua7e8\ua4bb\ua07e\ua911\u7d77\u8e5e\u2473\u8b38\u3479V\ua7e3\ua4b3\ua070\ua910\u7d7a\u8e5e").equals(object)) {
                n10 = n + (0x66E57935 ^ 0x66E5793D);
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7ff\ua4bb\ua065\ua90d\u7d73\u8e5e\u2473\u8b34").equals(object)) {
                context.access |= 0xC92404AC ^ 0xC92014AC;
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7f3\ua4bb\ua065\ua90c\u7d7b\u8e4f\u2453\u8b39\u3461{\ua7f5\ua4bc\ua073\ua909\u7d73\u8e6b\u2474\u8b39\u3478f\ua7e7\ua4a1\ua078\ua90a\u7d78\u8e59").equals(object)) {
                n7 = n + (0x96F495F ^ 0x96F4957);
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7f3\ua4bb\ua065\ua90c\u7d7b\u8e4f\u2453\u8b39\u3461{\ua7f5\ua4bc\ua073\ua909\u7d73\u8e7e\u2463\u8b27\u3472S\ua7e8\ua4bb\ua07e\ua911\u7d77\u8e5e\u2473\u8b38\u3479a").equals(object)) {
                n9 = n + (0x9303427F ^ 0x93034277);
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7f3\ua4bb\ua065\ua90c\u7d7b\u8e4f\u244c\u8b3e\u3464{\ua7e4\ua4b9\ua074\ua935\u7d77\u8e58\u247b\u8b3a\u3472f\ua7e3\ua4a7\ua050\ua90b\u7d78\u8e45\u246e\u8b36\u3463{\ua7e9\ua4bb\ua062").equals(object)) {
                n11 = n + (0x6067DF92 ^ 0x6067DF9A);
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7f3\ua4bb\ua065\ua90c\u7d7b\u8e4f\u2453\u8b39\u3461{\ua7f5\ua4bc\ua073\ua909\u7d73\u8e7a\u247b\u8b25\u3476\u007f\ua7e3\ua4a1\ua074\ua917\u7d57\u8e44\u2474\u8b38\u3463s\ua7f2\ua4bc\ua07e\ua90b\u7d65").equals(object)) {
                n12 = n + (0x37ADC5EC ^ 0x37ADC5E4);
            } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("_\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e7a\u247b\u8b25\u3476\u007f\ua7e3\ua4a1\ua074\ua917\u7d65").equals(object)) {
                n5 = n + (0x67ECE658 ^ 0x67ECE650);
            } else {
                Attribute attribute2 = this.readAttribute(context.attrs, (String)object, n + (0xFD59BD69 ^ 0xFD59BD61), this.readInt(n + (0xF4805527 ^ 0xF4805523)), cArray, 0xF44B0C65 ^ 0xBB4F39A, null);
                if (attribute2 != null) {
                    attribute2.next = attribute;
                    attribute = attribute2;
                }
            }
            n += (0x92CE32E1 ^ 0x92CE32E7) + this.readInt(n + (0x56210CBC ^ 0x56210CB8));
        }
        n += 2;
        MethodVisitor methodVisitor = classVisitor.visitMethod(context.access, context.name, context.desc, string, stringArray);
        if (methodVisitor == null) {
            return n;
        }
        if (methodVisitor instanceof MethodWriter) {
            object = (MethodWriter)methodVisitor;
            if (((MethodWriter)object).cw.cr == this && string == ((MethodWriter)object).signature) {
                n2 = 0xDB88229C ^ 0xDB88229C;
                if (stringArray == null) {
                    n2 = ((MethodWriter)object).exceptionCount == 0 ? 0x110E5498 ^ 0x110E5499 : 0xF5661B8E ^ 0xF5661B8E;
                } else if (stringArray.length == ((MethodWriter)object).exceptionCount) {
                    n2 = 0x80C13D7E ^ 0x80C13D7F;
                    for (int i = stringArray.length - (0x255ED474 ^ 0x255ED475); i >= 0; --i) {
                        if (((MethodWriter)object).exceptions[i] == this.readUnsignedShort(n4 -= 2)) continue;
                        n2 = 0x8B8E5F05 ^ 0x8B8E5F05;
                        break;
                    }
                }
                if (n2 != 0) {
                    ((MethodWriter)object).classReaderOffset = n13;
                    ((MethodWriter)object).classReaderLength = n - n13;
                    return n;
                }
            }
        }
        if (n5 != 0) {
            int n14 = this.b[n5] & (0x1A8A8263 ^ 0x1A8A829C);
            n2 = n5 + (0xA5BD8369 ^ 0xA5BD8368);
            while (n14 > 0) {
                methodVisitor.visitParameter(this.readUTF8(n2, cArray), this.readUnsignedShort(n2 + (0xB15742D2 ^ 0xB15742D0)));
                --n14;
                n2 += 0x9894ABF2 ^ 0x9894ABF6;
            }
        }
        if (n10 != 0) {
            AnnotationVisitor annotationVisitor = methodVisitor.visitAnnotationDefault();
            this.readAnnotationValue(n10, cArray, null, annotationVisitor);
            if (annotationVisitor != null) {
                annotationVisitor.visitEnd();
            }
        }
        if (n6 != 0) {
            n2 = n6 + (0xEE9C85B1 ^ 0xEE9C85B3);
            for (int i = this.readUnsignedShort(n6); i > 0; --i) {
                n2 = this.readAnnotationValues(n2 + (0xF4600EA6 ^ 0xF4600EA4), cArray, (0x5E03E034 ^ 0x5E03E035) != 0, methodVisitor.visitAnnotation(this.readUTF8(n2, cArray), (0xD14447F6 ^ 0xD14447F7) != 0));
            }
        }
        if (n7 != 0) {
            n2 = n7 + (0x2F72EDE ^ 0x2F72EDC);
            for (int i = this.readUnsignedShort(n7); i > 0; --i) {
                n2 = this.readAnnotationValues(n2 + (0xD2216A55 ^ 0xD2216A57), cArray, (0x7B9F89BD ^ 0x7B9F89BC) != 0, methodVisitor.visitAnnotation(this.readUTF8(n2, cArray), (0x3DEB2CF2 ^ 0x3DEB2CF2) != 0));
            }
        }
        if (n8 != 0) {
            n2 = n8 + (0x64EDBBA ^ 0x64EDBB8);
            for (int i = this.readUnsignedShort(n8); i > 0; --i) {
                n2 = this.readAnnotationTarget(context, n2);
                n2 = this.readAnnotationValues(n2 + (0x866074C3 ^ 0x866074C1), cArray, (0xF92F076D ^ 0xF92F076C) != 0, methodVisitor.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(n2, cArray), (0x75C1CBF6 ^ 0x75C1CBF7) != 0));
            }
        }
        if (n9 != 0) {
            n2 = n9 + (0x1591D87A ^ 0x1591D878);
            for (int i = this.readUnsignedShort(n9); i > 0; --i) {
                n2 = this.readAnnotationTarget(context, n2);
                n2 = this.readAnnotationValues(n2 + (0xD6165889 ^ 0xD616588B), cArray, (0x75AE19B8 ^ 0x75AE19B9) != 0, methodVisitor.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(n2, cArray), (0xFDBF9A2C ^ 0xFDBF9A2C) != 0));
            }
        }
        if (n11 != 0) {
            this.readParameterAnnotations(methodVisitor, context, n11, (0xF7D81CE8 ^ 0xF7D81CE9) != 0);
        }
        if (n12 != 0) {
            this.readParameterAnnotations(methodVisitor, context, n12, (0x80916347 ^ 0x80916347) != 0);
        }
        while (attribute != null) {
            Attribute attribute3 = attribute.next;
            attribute.next = null;
            methodVisitor.visitAttribute(attribute);
            attribute = attribute3;
        }
        if (n3 != 0) {
            methodVisitor.visitCode();
            this.readCode(methodVisitor, context, n3);
        }
        methodVisitor.visitEnd();
        return n;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void readCode(MethodVisitor var1_1, Context var2_2, int var3_3) {
        var4_4 = this.b;
        var5_5 = var2_2.buffer;
        var6_6 = this.readUnsignedShort(var3_3);
        var7_7 = this.readUnsignedShort(var3_3 + (-960544267 ^ -960544265));
        var8_8 = this.readInt(var3_3 + (-258723298 ^ -258723302));
        var9_9 = var3_3 += 8;
        var10_10 = var3_3 + var8_8;
        var2_2.labels = new Label[var8_8 + (1538492431 ^ 1538492429)];
        var11_11 = var2_2.labels;
        this.readLabel(var8_8 + (354663425 ^ 354663424), var11_11);
        block31: while (var3_3 < var10_10) {
            var12_12 = var3_3 - var9_9;
            var13_14 = var4_4[var3_3] & (1808998982 ^ 1808999097);
            switch (ClassWriter.TYPE[var13_14]) {
                case 0: 
                case 4: {
                    ++var3_3;
                    continue block31;
                }
                case 9: {
                    this.readLabel(var12_12 + this.readShort(var3_3 + (1581936160 ^ 1581936161)), var11_11);
                    var3_3 += 3;
                    continue block31;
                }
                case 18: {
                    this.readLabel(var12_12 + this.readUnsignedShort(var3_3 + (-699185848 ^ -699185847)), var11_11);
                    var3_3 += 3;
                    continue block31;
                }
                case 10: {
                    this.readLabel(var12_12 + this.readInt(var3_3 + (1959553799 ^ 1959553798)), var11_11);
                    var3_3 += 5;
                    continue block31;
                }
                case 17: {
                    var13_14 = var4_4[var3_3 + (-248187736 ^ -248187735)] & (-1056603667 ^ -1056603886);
                    if (var13_14 == (-471315785 ^ -471315917)) {
                        var3_3 += 6;
                        continue block31;
                    }
                    var3_3 += 4;
                    continue block31;
                }
                case 14: {
                    var3_3 = var3_3 + (1152152467 ^ 1152152471) - (var12_12 & (-702180650 ^ -702180651));
                    this.readLabel(var12_12 + this.readInt(var3_3), var11_11);
                    for (var14_18 = this.readInt(var3_3 + (209312662 ^ 209312670)) - this.readInt(var3_3 + (1562528805 ^ 1562528801)) + (1746318128 ^ 1746318129); var14_18 > 0; --var14_18) {
                        this.readLabel(var12_12 + this.readInt(var3_3 + (-1027188156 ^ -1027188152)), var11_11);
                        var3_3 += 4;
                    }
                    var3_3 += 12;
                    continue block31;
                }
                case 15: {
                    var3_3 = var3_3 + (-1113174157 ^ -1113174153) - (var12_12 & (-226835696 ^ -226835693));
                    this.readLabel(var12_12 + this.readInt(var3_3), var11_11);
                    for (var14_18 = this.readInt(var3_3 + (-1192160119 ^ -1192160115)); var14_18 > 0; --var14_18) {
                        this.readLabel(var12_12 + this.readInt(var3_3 + (-1448544168 ^ -1448544172)), var11_11);
                        var3_3 += 8;
                    }
                    var3_3 += 8;
                    continue block31;
                }
                case 1: 
                case 3: 
                case 11: {
                    var3_3 += 2;
                    continue block31;
                }
                case 2: 
                case 5: 
                case 6: 
                case 12: 
                case 13: {
                    var3_3 += 3;
                    continue block31;
                }
                case 7: 
                case 8: {
                    var3_3 += 5;
                    continue block31;
                }
            }
            var3_3 += 4;
        }
        for (var12_12 = this.readUnsignedShort(var3_3); var12_12 > 0; --var12_12) {
            var13_16 = this.readLabel(this.readUnsignedShort(var3_3 + (-1491754313 ^ -1491754315)), var11_11);
            var14_20 = this.readLabel(this.readUnsignedShort(var3_3 + (-1476646020 ^ -1476646024)), var11_11);
            var15_22 = this.readLabel(this.readUnsignedShort(var3_3 + (1028724880 ^ 1028724886)), var11_11);
            var16_24 = this.readUTF8(this.items[this.readUnsignedShort(var3_3 + (1137474609 ^ 1137474617))], var5_5);
            var1_1.visitTryCatchBlock(var13_16, var14_20, var15_22, var16_24);
            var3_3 += 8;
        }
        var3_3 += 2;
        var12_13 = null;
        var13_17 = null;
        var14_21 = -863097974 ^ -863097974;
        var15_23 = -402080611 ^ -402080611;
        var16_25 = 95821535 ^ -95821536;
        var17_26 = -1014704536 ^ 1014704535;
        var18_27 = -573047756 ^ -573047756;
        var19_28 = 1466326071 ^ 1466326071;
        var20_29 = 234246771 ^ 234246770;
        var21_30 = (var2_2.flags & (917374228 ^ 917374236)) != 0 ? -643002788 ^ -643002787 : 116239233 ^ 116239233;
        var22_31 = 1575669914 ^ 1575669914;
        var23_32 = 1622713367 ^ 1622713367;
        var24_33 = -1006731373 ^ -1006731373;
        var25_34 = null;
        var26_35 = null;
        for (var27_36 = this.readUnsignedShort(var3_3); var27_36 > 0; --var27_36) {
            block109: {
                block113: {
                    block112: {
                        block111: {
                            block110: {
                                block108: {
                                    var28_37 = this.readUTF8(var3_3 + (1903094221 ^ 1903094223), var5_5);
                                    if (!\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^\ua7e9\ua4b6\ua070\ua909\u7d40\u8e4b\u2468\u8b3e\u3476p\ua7ea\ua4b0\ua045\ua904\u7d74\u8e46\u247f").equals(var28_37)) break block108;
                                    if ((var2_2.flags & (-1361392052 ^ -1361392050)) == 0) {
                                        var18_27 = var3_3 + (-1035509156 ^ -1035509164);
                                        var30_51 = var3_3;
                                        for (var29_44 = this.readUnsignedShort(var3_3 + (-456591995 ^ -456591987)); var29_44 > 0; --var29_44) {
                                            var31_55 = this.readUnsignedShort(var30_51 + (429003312 ^ 429003322));
                                            if (var11_11[var31_55] == null) {
                                                this.readLabel((int)var31_55, (Label[])var11_11).status |= -1167364153 ^ -1167364154;
                                            }
                                            if (var11_11[var31_55 += this.readUnsignedShort(var30_51 + (1436503754 ^ 1436503750))] == null) {
                                                this.readLabel((int)var31_55, (Label[])var11_11).status |= 816358952 ^ 816358953;
                                            }
                                            var30_51 += 10;
                                        }
                                    }
                                    break block109;
                                }
                                if (!\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^\ua7e9\ua4b6\ua070\ua909\u7d40\u8e4b\u2468\u8b3e\u3476p\ua7ea\ua4b0\ua045\ua91c\u7d66\u8e4f\u244e\u8b36\u3475~\ua7e3").equals(var28_37)) break block110;
                                var19_28 = var3_3 + (-1140821816 ^ -1140821824);
                                break block109;
                            }
                            if (!\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^\ua7ef\ua4bb\ua074\ua92b\u7d63\u8e47\u2478\u8b32\u3465F\ua7e7\ua4b7\ua07d\ua900").equals(var28_37)) break block111;
                            if ((var2_2.flags & (1804146023 ^ 1804146021)) == 0) {
                                var30_51 = var3_3;
                                for (var29_44 = this.readUnsignedShort(var3_3 + (-1227416287 ^ -1227416279)); var29_44 > 0; --var29_44) {
                                    var31_55 = this.readUnsignedShort(var30_51 + (1873020759 ^ 1873020765));
                                    if (var11_11[var31_55] == null) {
                                        this.readLabel((int)var31_55, (Label[])var11_11).status |= 1552887707 ^ 1552887706;
                                    }
                                    var32_65 = var11_11[var31_55];
                                    while (var32_65.line > 0) {
                                        if (var32_65.next == null) {
                                            var32_65.next = new Label();
                                        }
                                        var32_65 = var32_65.next;
                                    }
                                    var32_65.line = this.readUnsignedShort(var30_51 + (1428409976 ^ 1428409972));
                                    var30_51 += 4;
                                }
                            }
                            break block109;
                        }
                        if (!\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7f3\ua4bb\ua065\ua90c\u7d7b\u8e4f\u244c\u8b3e\u3464{\ua7e4\ua4b9\ua074\ua931\u7d6f\u8e5a\u247f\u8b16\u3479|\ua7e9\ua4a1\ua070\ua911\u7d7f\u8e45\u2474\u8b24").equals(var28_37)) break block112;
                        var12_13 = this.readTypeAnnotations(var1_1, var2_2, var3_3 + (1577771998 ^ 1577771990), (boolean)(1870576775 ^ 1870576774));
                        if (var12_13.length == 0) ** GOTO lbl252
                        if (this.readByte(var12_13[-1598737507 ^ -1598737507]) < (1214350847 ^ 1214350780)) {
lbl252:
                            // 2 sources

                            v0 = -1720193733 ^ 1720193732;
                        } else {
                            v0 = this.readUnsignedShort(var12_13[-1490518006 ^ -1490518006] + (1903159184 ^ 1903159185));
                        }
                        var16_25 = v0;
                        break block109;
                    }
                    if (!\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7f3\ua4bb\ua065\ua90c\u7d7b\u8e4f\u2453\u8b39\u3461{\ua7f5\ua4bc\ua073\ua909\u7d73\u8e7e\u2463\u8b27\u3472S\ua7e8\ua4bb\ua07e\ua911\u7d77\u8e5e\u2473\u8b38\u3479a").equals(var28_37)) break block113;
                    var13_17 = this.readTypeAnnotations(var1_1, var2_2, var3_3 + (-637362888 ^ -637362896), (boolean)(1978595894 ^ 1978595894));
                    if (var13_17.length == 0) ** GOTO lbl272
                    if (this.readByte(var13_17[-944320664 ^ -944320664]) < (677656446 ^ 677656381)) {
lbl272:
                        // 2 sources

                        v1 = 1977848811 ^ -1977848812;
                    } else {
                        v1 = this.readUnsignedShort(var13_17[1596703606 ^ 1596703606] + (-1771583685 ^ -1771583686));
                    }
                    var17_26 = v1;
                    break block109;
                }
                if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7f2\ua4b4\ua072\ua90e\u7d5b\u8e4b\u246a\u8b03\u3476p\ua7ea\ua4b0").equals(var28_37)) {
                    if ((var2_2.flags & (-1169861974 ^ -1169861970)) == 0) {
                        var22_31 = var3_3 + (-113213204 ^ -113213210);
                        var23_32 = this.readInt(var3_3 + (908616813 ^ 908616809));
                        var24_33 = this.readUnsignedShort(var3_3 + (-1498384031 ^ -1498384023));
                    }
                } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7f2\ua4b4\ua072\ua90e\u7d5b\u8e4b\u246a").equals(var28_37)) {
                    if ((var2_2.flags & (-1353053350 ^ -1353053346)) == 0) {
                        var20_29 = 460756775 ^ 460756775;
                        var22_31 = var3_3 + (2037954257 ^ 2037954267);
                        var23_32 = this.readInt(var3_3 + (1785586373 ^ 1785586369));
                        var24_33 = this.readUnsignedShort(var3_3 + (1925974738 ^ 1925974746));
                    }
                } else {
                    for (var29_44 = -1193746170 ^ -1193746170; var29_44 < var2_2.attrs.length; ++var29_44) {
                        if (!var2_2.attrs[var29_44].type.equals(var28_37)) continue;
                        var30_52 = var2_2.attrs[var29_44].read(this, var3_3 + (1124731028 ^ 1124731036), this.readInt(var3_3 + (-1146948943 ^ -1146948939)), var5_5, var9_9 - (-117675323 ^ -117675315), var11_11);
                        if (var30_52 == null) continue;
                        var30_52.next = var26_35;
                        var26_35 = var30_52;
                    }
                }
            }
            var3_3 += (1977732149 ^ 1977732147) + this.readInt(var3_3 + (1592694376 ^ 1592694380));
        }
        var3_3 += 2;
        if (var22_31 != 0) {
            var25_34 = var2_2;
            var25_34.offset = -174121105 ^ 174121104;
            var25_34.mode = 253951482 ^ 253951482;
            var25_34.localCount = 1471666059 ^ 1471666059;
            var25_34.localDiff = 406785492 ^ 406785492;
            var25_34.stackCount = -357796497 ^ -357796497;
            var25_34.local = new Object[var7_7];
            var25_34.stack = new Object[var6_6];
            if (var21_30) {
                this.getImplicitFrame(var2_2);
            }
            var27_36 = var22_31;
            while (true) {
                if (var27_36 >= var22_31 + var23_32 - (1257713811 ^ 1257713809)) break;
                if (var4_4[var27_36] == (2083167427 ^ 2083167435)) {
                    var28_38 = this.readUnsignedShort(var27_36 + (779976601 ^ 779976600));
                    if (var28_38 >= 0 && var28_38 < var8_8) {
                        if ((var4_4[var9_9 + var28_38] & (2132028220 ^ 2132028355)) == (388153 ^ 388226)) {
                            this.readLabel(var28_38, var11_11);
                        }
                    }
                }
                ++var27_36;
            }
        }
        if ((var2_2.flags & (136657751 ^ 136657495)) != 0) {
            var1_1.visitFrame(849371128 ^ -849371129, var7_7, null, 683784357 ^ 683784357, null);
        }
        var27_36 = (var2_2.flags & (42774386 ^ 42774130)) == 0 ? 73150526 ^ -73150495 : 1125660296 ^ 1125660296;
        var3_3 = var9_9;
        while (var3_3 < var10_10) {
            var28_39 = var3_3 - var9_9;
            var29_46 = var11_11[var28_39];
            if (var29_46 != null) {
                var30_53 = var29_46.next;
                var29_46.next = null;
                var1_1.visitLabel(var29_46);
                if ((var2_2.flags & (1573749292 ^ 1573749294)) == 0 && var29_46.line > 0) {
                    var1_1.visitLineNumber(var29_46.line, var29_46);
                    while (var30_53 != null) {
                        var1_1.visitLineNumber(var30_53.line, var29_46);
                        var30_53 = var30_53.next;
                    }
                }
            }
            while (var25_34 != null) {
                if (var25_34.offset != var28_39) {
                    if (var25_34.offset != (1036978739 ^ -1036978740)) break;
                }
                if (var25_34.offset != (1136203690 ^ -1136203691)) {
                    if (!var20_29 || var21_30) {
                        var1_1.visitFrame(-1984740711 ^ 1984740710, var25_34.localCount, var25_34.local, var25_34.stackCount, var25_34.stack);
                    } else {
                        var1_1.visitFrame(var25_34.mode, var25_34.localDiff, var25_34.local, var25_34.stackCount, var25_34.stack);
                    }
                }
                if (var24_33 > 0) {
                    var22_31 = this.readFrame(var22_31, var20_29, (boolean)var21_30, var25_34);
                    --var24_33;
                    continue;
                }
                var25_34 = null;
            }
            var30_54 = var4_4[var3_3] & (-1030153700 ^ -1030153501);
            switch (ClassWriter.TYPE[var30_54]) {
                case 0: {
                    var1_1.visitInsn(var30_54);
                    ++var3_3;
                    break;
                }
                case 4: {
                    if (var30_54 > (2138506769 ^ 2138506791)) {
                        var30_54 -= 59;
                        var1_1.visitVarInsn((-1391990868 ^ -1391990886) + (var30_54 >> (1614686831 ^ 1614686829)), var30_54 & (694915768 ^ 694915771));
                    } else {
                        var30_54 -= 26;
                        var1_1.visitVarInsn((112646181 ^ 112646192) + (var30_54 >> (1383073609 ^ 1383073611)), var30_54 & (498649665 ^ 498649666));
                    }
                    ++var3_3;
                    break;
                }
                case 9: {
                    var1_1.visitJumpInsn(var30_54, var11_11[var28_39 + this.readShort(var3_3 + (-2135607174 ^ -2135607173))]);
                    var3_3 += 3;
                    break;
                }
                case 10: {
                    var1_1.visitJumpInsn(var30_54 + var27_36, var11_11[var28_39 + this.readInt(var3_3 + (450422861 ^ 450422860))]);
                    var3_3 += 5;
                    break;
                }
                case 18: {
                    var30_54 = var30_54 < (-685661570 ^ -685661532) ? var30_54 - (-1998033723 ^ -1998033676) : var30_54 - (-86459974 ^ -86459986);
                    var31_57 = var11_11[var28_39 + this.readUnsignedShort(var3_3 + (-1513226034 ^ -1513226033))];
                    if (var30_54 == (650330319 ^ 650330216)) ** GOTO lbl475
                    if (var30_54 != (1802967352 ^ 1802967440)) ** GOTO lbl477
lbl475:
                    // 2 sources

                    var1_1.visitJumpInsn(var30_54 + (1172346730 ^ 1172346699), var31_57);
                    ** GOTO lbl496
lbl477:
                    // 1 sources

                    var30_54 = var30_54 <= (1853491035 ^ 1853491197) ? (var30_54 + (-1771590317 ^ -1771590318) ^ (1311806434 ^ 1311806435)) - (-666178110 ^ -666178109) : var30_54 ^ (-1324215529 ^ -1324215530);
                    var32_67 = new Label();
                    var1_1.visitJumpInsn(var30_54, var32_67);
                    var1_1.visitJumpInsn(-373881712 ^ -373881768, var31_57);
                    var1_1.visitLabel(var32_67);
                    if (var22_31 == 0) ** GOTO lbl496
                    if (var25_34 == null) ** GOTO lbl495
                    if (var25_34.offset == var28_39 + (1581454074 ^ 1581454073)) ** GOTO lbl496
lbl495:
                    // 2 sources

                    var1_1.visitFrame(1863897010 ^ 1863896754, -1465889280 ^ -1465889280, null, 1569561128 ^ 1569561128, null);
lbl496:
                    // 4 sources

                    var3_3 += 3;
                    break;
                }
                case 17: {
                    var30_54 = var4_4[var3_3 + (718869873 ^ 718869872)] & (622944153 ^ 622944102);
                    if (var30_54 == (-813379392 ^ -813379516)) {
                        var1_1.visitIincInsn(this.readUnsignedShort(var3_3 + (2018415489 ^ 2018415491)), this.readShort(var3_3 + (-1255132612 ^ -1255132616)));
                        var3_3 += 6;
                        break;
                    }
                    var1_1.visitVarInsn(var30_54, this.readUnsignedShort(var3_3 + (843195832 ^ 843195834)));
                    var3_3 += 4;
                    break;
                }
                case 14: {
                    var3_3 = var3_3 + (2048869065 ^ 2048869069) - (var28_39 & (1258724846 ^ 1258724845));
                    var31_58 = var28_39 + this.readInt(var3_3);
                    var32_68 = this.readInt(var3_3 + (1348697475 ^ 1348697479));
                    var33_73 = this.readInt(var3_3 + (671222058 ^ 671222050));
                    var34_78 = new Label[var33_73 - var32_68 + (1475321964 ^ 1475321965)];
                    var3_3 += 12;
                    for (var35_83 = -526813325 ^ -526813325; var35_83 < var34_78.length; ++var35_83) {
                        var34_78[var35_83] = var11_11[var28_39 + this.readInt(var3_3)];
                        var3_3 += 4;
                    }
                    var1_1.visitTableSwitchInsn(var32_68, var33_73, var11_11[var31_58], var34_78);
                    break;
                }
                case 15: {
                    var3_3 = var3_3 + (-292936394 ^ -292936398) - (var28_39 & (-253160516 ^ -253160513));
                    var31_59 = var28_39 + this.readInt(var3_3);
                    var32_69 = this.readInt(var3_3 + (-1323322662 ^ -1323322658));
                    var33_74 = new int[var32_69];
                    var34_79 = new Label[var32_69];
                    var3_3 += 8;
                    for (var35_84 = 1316449366 ^ 1316449366; var35_84 < var32_69; ++var35_84) {
                        var33_74[var35_84] = this.readInt(var3_3);
                        var34_79[var35_84] = var11_11[var28_39 + this.readInt(var3_3 + (-1995878983 ^ -1995878979))];
                        var3_3 += 8;
                    }
                    var1_1.visitLookupSwitchInsn(var11_11[var31_59], var33_74, var34_79);
                    break;
                }
                case 3: {
                    var1_1.visitVarInsn(var30_54, var4_4[var3_3 + (-980429239 ^ -980429240)] & (210478511 ^ 210478416));
                    var3_3 += 2;
                    break;
                }
                case 1: {
                    var1_1.visitIntInsn(var30_54, var4_4[var3_3 + (-1605723346 ^ -1605723345)]);
                    var3_3 += 2;
                    break;
                }
                case 2: {
                    var1_1.visitIntInsn(var30_54, this.readShort(var3_3 + (944208763 ^ 944208762)));
                    var3_3 += 3;
                    break;
                }
                case 11: {
                    var1_1.visitLdcInsn(this.readConst(var4_4[var3_3 + (-72871486 ^ -72871485)] & (-815067438 ^ -815067603), var5_5));
                    var3_3 += 2;
                    break;
                }
                case 12: {
                    var1_1.visitLdcInsn(this.readConst(this.readUnsignedShort(var3_3 + (-784487565 ^ -784487566)), var5_5));
                    var3_3 += 3;
                    break;
                }
                case 6: 
                case 7: {
                    var31_60 = this.items[this.readUnsignedShort(var3_3 + (1941010740 ^ 1941010741))];
                    var32_70 = var4_4[var31_60 - (1006086589 ^ 1006086588)] == (-1860619926 ^ -1860619935) ? 2037705743 ^ 2037705742 : 548354179 ^ 548354179;
                    var33_75 = this.readClass(var31_60, var5_5);
                    var31_60 = this.items[this.readUnsignedShort(var31_60 + (-909156648 ^ -909156646))];
                    var34_80 = this.readUTF8(var31_60, var5_5);
                    var35_85 = this.readUTF8(var31_60 + (-15580707 ^ -15580705), var5_5);
                    if (var30_54 < (2021834287 ^ 2021834393)) {
                        var1_1.visitFieldInsn(var30_54, var33_75, var34_80, var35_85);
                    } else {
                        var1_1.visitMethodInsn(var30_54, var33_75, var34_80, var35_85, (boolean)var32_70);
                    }
                    if (var30_54 == (-544135164 ^ -544134979)) {
                        var3_3 += 5;
                        break;
                    }
                    var3_3 += 3;
                    break;
                }
                case 8: {
                    var31_61 = this.items[this.readUnsignedShort(var3_3 + (426887406 ^ 426887407))];
                    var32_71 = var2_2.bootstrapMethods[this.readUnsignedShort(var31_61)];
                    var33_76 = (Handle)this.readConst(this.readUnsignedShort(var32_71), var5_5);
                    var34_81 = this.readUnsignedShort(var32_71 + (600606480 ^ 600606482));
                    var35_86 = new Object[var34_81];
                    var32_71 += 4;
                    for (var36_88 = 1308624608 ^ 1308624608; var36_88 < var34_81; ++var36_88) {
                        var35_86[var36_88] = this.readConst(this.readUnsignedShort(var32_71), var5_5);
                        var32_71 += 2;
                    }
                    var31_61 = this.items[this.readUnsignedShort(var31_61 + (-934858681 ^ -934858683))];
                    var36_87 = this.readUTF8(var31_61, var5_5);
                    var37_89 = this.readUTF8(var31_61 + (1510055701 ^ 1510055703), var5_5);
                    var1_1.visitInvokeDynamicInsn(var36_87, var37_89, var33_76, var35_86);
                    var3_3 += 5;
                    break;
                }
                case 5: {
                    var1_1.visitTypeInsn(var30_54, this.readClass(var3_3 + (-587062595 ^ -587062596), var5_5));
                    var3_3 += 3;
                    break;
                }
                case 13: {
                    var1_1.visitIincInsn(var4_4[var3_3 + (-745208870 ^ -745208869)] & (-1805804974 ^ -1805804883), var4_4[var3_3 + (-1110293089 ^ -1110293091)]);
                    var3_3 += 3;
                    break;
                }
                default: {
                    var1_1.visitMultiANewArrayInsn(this.readClass(var3_3 + (2092502055 ^ 2092502054), var5_5), var4_4[var3_3 + (-511352638 ^ -511352639)] & (-1356294471 ^ -1356294586));
                    var3_3 += 4;
                }
            }
            while (var12_13 != null && var14_21 < var12_13.length && var16_25 <= var28_39) {
                if (var16_25 == var28_39) {
                    var31_62 = this.readAnnotationTarget(var2_2, var12_13[var14_21]);
                    this.readAnnotationValues(var31_62 + (-2067777304 ^ -2067777302), var5_5, (boolean)(-162785343 ^ -162785344), var1_1.visitInsnAnnotation(var2_2.typeRef, var2_2.typePath, this.readUTF8(var31_62, var5_5), (boolean)(-656325028 ^ -656325027)));
                }
                if (++var14_21 >= var12_13.length) ** GOTO lbl699
                if (this.readByte(var12_13[var14_21]) < (1892601198 ^ 1892601133)) {
lbl699:
                    // 2 sources

                    v2 = -1503592174 ^ 1503592173;
                } else {
                    v2 = this.readUnsignedShort(var12_13[var14_21] + (1984752067 ^ 1984752066));
                }
                var16_25 = v2;
            }
            while (var13_17 != null && var15_23 < var13_17.length && var17_26 <= var28_39) {
                if (var17_26 == var28_39) {
                    var31_63 = this.readAnnotationTarget(var2_2, var13_17[var15_23]);
                    this.readAnnotationValues(var31_63 + (1617274725 ^ 1617274727), var5_5, (boolean)(-1611519522 ^ -1611519521), var1_1.visitInsnAnnotation(var2_2.typeRef, var2_2.typePath, this.readUTF8(var31_63, var5_5), (boolean)(1504605598 ^ 1504605598)));
                }
                if (++var15_23 >= var13_17.length) ** GOTO lbl721
                if (this.readByte(var13_17[var15_23]) < (-1717072914 ^ -1717072979)) {
lbl721:
                    // 2 sources

                    v3 = 654768754 ^ -654768755;
                } else {
                    v3 = this.readUnsignedShort(var13_17[var15_23] + (862639988 ^ 862639989));
                }
                var17_26 = v3;
            }
        }
        if (var11_11[var8_8] != null) {
            var1_1.visitLabel(var11_11[var8_8]);
        }
        if ((var2_2.flags & (583680012 ^ 583680014)) == 0 && var18_27 != 0) {
            var28_40 = null;
            if (var19_28 != 0) {
                var3_3 = var19_28 + (-1825725236 ^ -1825725234);
                var28_40 = new int[this.readUnsignedShort(var19_28) * (-160404773 ^ -160404776)];
                var29_47 = var28_40.length;
                while (var29_47 > 0) {
                    var28_40[--var29_47] = var3_3 + (104898451 ^ 104898453);
                    var28_40[--var29_47] = this.readUnsignedShort(var3_3 + (-997971690 ^ -997971682));
                    var28_40[--var29_47] = this.readUnsignedShort(var3_3);
                    var3_3 += 10;
                }
            }
            var3_3 = var18_27 + (-1443547467 ^ -1443547465);
            for (var29_48 = this.readUnsignedShort(var18_27); var29_48 > 0; --var29_48) {
                var30_51 = this.readUnsignedShort(var3_3);
                var31_64 = this.readUnsignedShort(var3_3 + (-1303023086 ^ -1303023088));
                var32_72 = this.readUnsignedShort(var3_3 + (398654507 ^ 398654499));
                var33_77 = null;
                if (var28_40 != null) {
                    for (var34_82 = 1463489452 ^ 1463489452; var34_82 < var28_40.length; var34_82 += 3) {
                        if (var28_40[var34_82] != var30_51) continue;
                        if (var28_40[var34_82 + (1936749482 ^ 1936749483)] != var32_72) continue;
                        var33_77 = this.readUTF8(var28_40[var34_82 + (1836770451 ^ 1836770449)], var5_5);
                        break;
                    }
                }
                var1_1.visitLocalVariable(this.readUTF8(var3_3 + (1567184049 ^ 1567184053), var5_5), this.readUTF8(var3_3 + (358573692 ^ 358573690), var5_5), var33_77, var11_11[var30_51], var11_11[var30_51 + var31_64], var32_72);
                var3_3 += 10;
            }
        }
        if (var12_13 != null) {
            for (var28_41 = 762141719 ^ 762141719; var28_41 < var12_13.length; ++var28_41) {
                if (this.readByte(var12_13[var28_41]) >> (-1914574819 ^ -1914574820) != (1749463277 ^ 1749463245)) continue;
                var29_49 = this.readAnnotationTarget(var2_2, var12_13[var28_41]);
                var29_49 = this.readAnnotationValues(var29_49 + (-1742684210 ^ -1742684212), var5_5, (boolean)(61296441 ^ 61296440), var1_1.visitLocalVariableAnnotation(var2_2.typeRef, var2_2.typePath, var2_2.start, var2_2.end, var2_2.index, this.readUTF8(var29_49, var5_5), (boolean)(1376174839 ^ 1376174838)));
            }
        }
        if (var13_17 != null) {
            for (var28_42 = 1204869143 ^ 1204869143; var28_42 < var13_17.length; ++var28_42) {
                if (this.readByte(var13_17[var28_42]) >> (-1501147907 ^ -1501147908) != (1805273089 ^ 1805273121)) continue;
                var29_50 = this.readAnnotationTarget(var2_2, var13_17[var28_42]);
                var29_50 = this.readAnnotationValues(var29_50 + (-168681509 ^ -168681511), var5_5, (boolean)(40038093 ^ 40038092), var1_1.visitLocalVariableAnnotation(var2_2.typeRef, var2_2.typePath, var2_2.start, var2_2.end, var2_2.index, this.readUTF8(var29_50, var5_5), (boolean)(-1226397174 ^ -1226397174)));
            }
        }
        while (var26_35 != null) {
            var28_43 = var26_35.next;
            var26_35.next = null;
            var1_1.visitAttribute(var26_35);
            var26_35 = var28_43;
        }
        var1_1.visitMaxs(var6_6, var7_7);
    }

    private int[] readTypeAnnotations(MethodVisitor methodVisitor, Context context, int n, boolean bl) {
        char[] cArray = context.buffer;
        int[] nArray = new int[this.readUnsignedShort(n)];
        n += 2;
        for (int i = 0x192E19D8 ^ 0x192E19D8; i < nArray.length; ++i) {
            int n2;
            nArray[i] = n;
            int n3 = this.readInt(n);
            switch (n3 >>> (0x1FB9C321 ^ 0x1FB9C339)) {
                case 0: 
                case 1: 
                case 22: {
                    n += 2;
                    break;
                }
                case 19: 
                case 20: 
                case 21: {
                    ++n;
                    break;
                }
                case 64: 
                case 65: {
                    for (n2 = this.readUnsignedShort(n + (0x5B1DA79 ^ 0x5B1DA78)); n2 > 0; --n2) {
                        int n4 = this.readUnsignedShort(n + (0xDD39C6D7 ^ 0xDD39C6D4));
                        int n5 = this.readUnsignedShort(n + (0x7BD20A9A ^ 0x7BD20A9F));
                        this.readLabel(n4, context.labels);
                        this.readLabel(n4 + n5, context.labels);
                        n += 6;
                    }
                    n += 3;
                    break;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: {
                    n += 4;
                    break;
                }
                default: {
                    n += 3;
                }
            }
            n2 = this.readByte(n);
            if (n3 >>> (0x7B6D0F3A ^ 0x7B6D0F22) == (0x708FA94D ^ 0x708FA90F)) {
                TypePath typePath = n2 == 0 ? null : new TypePath(this.b, n);
                n += (0xD82779EA ^ 0xD82779EB) + (0xE2DC60B2 ^ 0xE2DC60B0) * n2;
                n = this.readAnnotationValues(n + (0x43B9FD61 ^ 0x43B9FD63), cArray, (0xD625FCBC ^ 0xD625FCBD) != 0, methodVisitor.visitTryCatchAnnotation(n3, typePath, this.readUTF8(n, cArray), bl));
                continue;
            }
            n = this.readAnnotationValues(n + (0x3E868191 ^ 0x3E868192) + (0xC5C330F1 ^ 0xC5C330F3) * n2, cArray, (0x76C10BE ^ 0x76C10BF) != 0, null);
        }
        return nArray;
    }

    private int readAnnotationTarget(Context context, int n) {
        int n2;
        int n3 = this.readInt(n);
        switch (n3 >>> (0x50C7BE63 ^ 0x50C7BE7B)) {
            case 0: 
            case 1: 
            case 22: {
                n3 &= 0x4A5BE82B ^ 0xB5A4E82B;
                n += 2;
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                n3 &= 0xDED8583F ^ 0x21D8583F;
                ++n;
                break;
            }
            case 64: 
            case 65: {
                n3 &= 0x1DFC2961 ^ 0xE2FC2961;
                n2 = this.readUnsignedShort(n + (0x66286642 ^ 0x66286643));
                context.start = new Label[n2];
                context.end = new Label[n2];
                context.index = new int[n2];
                n += 3;
                for (int i = 0x34601165 ^ 0x34601165; i < n2; ++i) {
                    int n4 = this.readUnsignedShort(n);
                    int n5 = this.readUnsignedShort(n + (0xE493CAA6 ^ 0xE493CAA4));
                    context.start[i] = this.readLabel(n4, context.labels);
                    context.end[i] = this.readLabel(n4 + n5, context.labels);
                    context.index[i] = this.readUnsignedShort(n + (0x3AB6FDD ^ 0x3AB6FD9));
                    n += 6;
                }
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                n3 &= 0x9ECC7126 ^ 0x61CC71D9;
                n += 4;
                break;
            }
            default: {
                n3 &= n3 >>> (0xB2402FD7 ^ 0xB2402FCF) < (0xF842B781 ^ 0xF842B7C2) ? 0x4FE23D88 ^ 0xB01DC288 : 0xCB035D30 ^ 0x34035D30;
                n += 3;
            }
        }
        n2 = this.readByte(n);
        context.typeRef = n3;
        context.typePath = n2 == 0 ? null : new TypePath(this.b, n);
        return n + (0x8D048888 ^ 0x8D048889) + (0xD765B867 ^ 0xD765B865) * n2;
    }

    private void readParameterAnnotations(MethodVisitor methodVisitor, Context context, int n, boolean bl) {
        AnnotationVisitor annotationVisitor;
        int n2;
        int n3 = n++;
        int n4 = this.b[n3] & (0x87C356D3 ^ 0x87C3562C);
        int n5 = Type.getArgumentTypes(context.desc).length - n4;
        for (n2 = 0xC146B7B9 ^ 0xC146B7B9; n2 < n5; ++n2) {
            annotationVisitor = methodVisitor.visitParameterAnnotation(n2, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^\ua7ec\ua4b4\ua067\ua904\u7d39\u8e46\u247b\u8b39\u3470=\ua7d5\ua4ac\ua07f\ua911\u7d7e\u8e4f\u246e\u8b3e\u3474)"), (0x9E4ADF86 ^ 0x9E4ADF86) != 0);
            if (annotationVisitor == null) continue;
            annotationVisitor.visitEnd();
        }
        char[] cArray = context.buffer;
        while (n2 < n4 + n5) {
            int n6 = this.readUnsignedShort(n);
            n += 2;
            while (n6 > 0) {
                annotationVisitor = methodVisitor.visitParameterAnnotation(n2, this.readUTF8(n, cArray), bl);
                n = this.readAnnotationValues(n + (0xE8EDB4CD ^ 0xE8EDB4CF), cArray, (0x6DE4026D ^ 0x6DE4026C) != 0, annotationVisitor);
                --n6;
            }
            ++n2;
        }
    }

    private int readAnnotationValues(int n, char[] cArray, boolean bl, AnnotationVisitor annotationVisitor) {
        int n2 = this.readUnsignedShort(n);
        n += 2;
        if (bl) {
            while (n2 > 0) {
                n = this.readAnnotationValue(n + (0xC8109DF4 ^ 0xC8109DF6), cArray, this.readUTF8(n, cArray), annotationVisitor);
                --n2;
            }
        } else {
            while (n2 > 0) {
                n = this.readAnnotationValue(n, cArray, null, annotationVisitor);
                --n2;
            }
        }
        if (annotationVisitor != null) {
            annotationVisitor.visitEnd();
        }
        return n;
    }

    private int readAnnotationValue(int n, char[] cArray, String string, AnnotationVisitor annotationVisitor) {
        if (annotationVisitor == null) {
            switch (this.b[n] & (0x976B45EF ^ 0x976B4510)) {
                case 101: {
                    return n + (0x157B1D51 ^ 0x157B1D54);
                }
                case 64: {
                    return this.readAnnotationValues(n + (0xDE2CA884 ^ 0xDE2CA887), cArray, (0xD25165C ^ 0xD25165D) != 0, null);
                }
                case 91: {
                    return this.readAnnotationValues(n + (0xAA7ACB08 ^ 0xAA7ACB09), cArray, (0x2DA16FC7 ^ 0x2DA16FC7) != 0, null);
                }
            }
            return n + (0x855768B ^ 0x8557688);
        }
        int n2 = n++;
        block5 : switch (this.b[n2] & (0xB5BF77B5 ^ 0xB5BF774A)) {
            case 68: 
            case 70: 
            case 73: 
            case 74: {
                annotationVisitor.visit(string, this.readConst(this.readUnsignedShort(n), cArray));
                n += 2;
                break;
            }
            case 66: {
                annotationVisitor.visit(string, (byte)this.readInt(this.items[this.readUnsignedShort(n)]));
                n += 2;
                break;
            }
            case 90: {
                annotationVisitor.visit(string, this.readInt(this.items[this.readUnsignedShort(n)]) == 0 ? Boolean.FALSE : Boolean.TRUE);
                n += 2;
                break;
            }
            case 83: {
                annotationVisitor.visit(string, (short)this.readInt(this.items[this.readUnsignedShort(n)]));
                n += 2;
                break;
            }
            case 67: {
                annotationVisitor.visit(string, Character.valueOf((char)this.readInt(this.items[this.readUnsignedShort(n)])));
                n += 2;
                break;
            }
            case 115: {
                annotationVisitor.visit(string, this.readUTF8(n, cArray));
                n += 2;
                break;
            }
            case 101: {
                annotationVisitor.visitEnum(string, this.readUTF8(n, cArray), this.readUTF8(n + (0x8CB32E2 ^ 0x8CB32E0), cArray));
                n += 4;
                break;
            }
            case 99: {
                annotationVisitor.visit(string, Type.getType(this.readUTF8(n, cArray)));
                n += 2;
                break;
            }
            case 64: {
                n = this.readAnnotationValues(n + (0x9396F4E6 ^ 0x9396F4E4), cArray, (0x2E0FE8BF ^ 0x2E0FE8BE) != 0, annotationVisitor.visitAnnotation(string, this.readUTF8(n, cArray)));
                break;
            }
            case 91: {
                int n3 = this.readUnsignedShort(n);
                n += 2;
                if (n3 == 0) {
                    return this.readAnnotationValues(n - (0x467C8EA4 ^ 0x467C8EA6), cArray, (0x167FE544 ^ 0x167FE544) != 0, annotationVisitor.visitArray(string));
                }
                int n4 = n++;
                switch (this.b[n4] & (0xA1AF33E7 ^ 0xA1AF3318)) {
                    case 66: {
                        byte[] byArray = new byte[n3];
                        for (int i = 0x2BD3D228 ^ 0x2BD3D228; i < n3; ++i) {
                            byArray[i] = (byte)this.readInt(this.items[this.readUnsignedShort(n)]);
                            n += 3;
                        }
                        annotationVisitor.visit(string, byArray);
                        --n;
                        break block5;
                    }
                    case 90: {
                        boolean[] blArray = new boolean[n3];
                        for (int i = 0x178F61B2 ^ 0x178F61B2; i < n3; ++i) {
                            blArray[i] = this.readInt(this.items[this.readUnsignedShort(n)]) != 0 ? 0xBD713CFC ^ 0xBD713CFD : 0xD06C52D0 ^ 0xD06C52D0;
                            n += 3;
                        }
                        annotationVisitor.visit(string, blArray);
                        --n;
                        break block5;
                    }
                    case 83: {
                        short[] sArray = new short[n3];
                        for (int i = 0xEA41B5B4 ^ 0xEA41B5B4; i < n3; ++i) {
                            sArray[i] = (short)this.readInt(this.items[this.readUnsignedShort(n)]);
                            n += 3;
                        }
                        annotationVisitor.visit(string, sArray);
                        --n;
                        break block5;
                    }
                    case 67: {
                        char[] cArray2 = new char[n3];
                        for (int i = 0xFF022961 ^ 0xFF022961; i < n3; ++i) {
                            cArray2[i] = (char)this.readInt(this.items[this.readUnsignedShort(n)]);
                            n += 3;
                        }
                        annotationVisitor.visit(string, cArray2);
                        --n;
                        break block5;
                    }
                    case 73: {
                        int[] nArray = new int[n3];
                        for (int i = 0x86FED64E ^ 0x86FED64E; i < n3; ++i) {
                            nArray[i] = this.readInt(this.items[this.readUnsignedShort(n)]);
                            n += 3;
                        }
                        annotationVisitor.visit(string, nArray);
                        --n;
                        break block5;
                    }
                    case 74: {
                        long[] lArray = new long[n3];
                        for (int i = 0x231DED63 ^ 0x231DED63; i < n3; ++i) {
                            lArray[i] = this.readLong(this.items[this.readUnsignedShort(n)]);
                            n += 3;
                        }
                        annotationVisitor.visit(string, lArray);
                        --n;
                        break block5;
                    }
                    case 70: {
                        float[] fArray = new float[n3];
                        for (int i = 0xF88E9A5E ^ 0xF88E9A5E; i < n3; ++i) {
                            fArray[i] = Float.intBitsToFloat(this.readInt(this.items[this.readUnsignedShort(n)]));
                            n += 3;
                        }
                        annotationVisitor.visit(string, fArray);
                        --n;
                        break block5;
                    }
                    case 68: {
                        double[] dArray = new double[n3];
                        for (int i = 0x144FE19C ^ 0x144FE19C; i < n3; ++i) {
                            dArray[i] = Double.longBitsToDouble(this.readLong(this.items[this.readUnsignedShort(n)]));
                            n += 3;
                        }
                        annotationVisitor.visit(string, dArray);
                        --n;
                        break block5;
                    }
                }
                n = this.readAnnotationValues(n - (0xD5585566 ^ 0xD5585565), cArray, (0x411CCC44 ^ 0x411CCC44) != 0, annotationVisitor.visitArray(string));
            }
        }
        return n;
    }

    private void getImplicitFrame(Context context) {
        String string = context.desc;
        Object[] objectArray = context.local;
        int n = 0xFB003B3 ^ 0xFB003B3;
        if ((context.access & (0x9F6E7091 ^ 0x9F6E7099)) == 0) {
            if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(context.name)) {
                objectArray[n++] = Opcodes.UNINITIALIZED_THIS;
            } else {
                int n2 = n++;
                objectArray[n2] = this.readClass(this.header + (0xF4356A97 ^ 0xF4356A95), context.buffer);
            }
        }
        int n3 = 0x88D0C65B ^ 0x88D0C65A;
        block8: while (true) {
            int n4 = n3;
            switch (string.charAt(n3++)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    objectArray[n++] = Opcodes.INTEGER;
                    continue block8;
                }
                case 'F': {
                    objectArray[n++] = Opcodes.FLOAT;
                    continue block8;
                }
                case 'J': {
                    objectArray[n++] = Opcodes.LONG;
                    continue block8;
                }
                case 'D': {
                    objectArray[n++] = Opcodes.DOUBLE;
                    continue block8;
                }
                case '[': {
                    while (true) {
                        if (string.charAt(n3) != (0xAC7556EF ^ 0xAC7556B4)) break;
                        ++n3;
                    }
                    if (string.charAt(n3) == (0x95FA0BF2 ^ 0x95FA0BBE)) {
                        ++n3;
                        while (true) {
                            if (string.charAt(n3) == (0x43BB7FB1 ^ 0x43BB7F8A)) break;
                            ++n3;
                        }
                    }
                    objectArray[n++] = string.substring(n4, ++n3);
                    continue block8;
                }
                case 'L': {
                    while (true) {
                        if (string.charAt(n3) == (0x2E916416 ^ 0x2E91642D)) break;
                        ++n3;
                    }
                    int n5 = n++;
                    objectArray[n5] = string.substring(n4 + (0x6C4DC7D9 ^ 0x6C4DC7D8), n3++);
                    continue block8;
                }
            }
            break;
        }
        context.localCount = n;
    }

    /*
     * Unable to fully structure code
     */
    private int readFrame(int var1_1, boolean var2_2, boolean var3_3, Context var4_4) {
        block12: {
            block14: {
                block13: {
                    block11: {
                        var5_5 = var4_4.buffer;
                        var6_6 = var4_4.labels;
                        if (var2_2) {
                            v0 = var1_1++;
                            var7_7 = this.b[v0] & (-94665183 ^ -94664994);
                        } else {
                            var7_7 = -1207057898 ^ -1207057687;
                            var4_4.offset = -912620031 ^ 912620030;
                        }
                        var4_4.localDiff = -86224560 ^ -86224560;
                        if (var7_7 >= (1722496743 ^ 1722496679)) break block11;
                        var8_8 = var7_7;
                        var4_4.mode = -1091899418 ^ -1091899419;
                        var4_4.stackCount = 1890804991 ^ 1890804991;
                        break block12;
                    }
                    if (var7_7 >= (1913594520 ^ 1913594392)) break block13;
                    var8_8 = var7_7 - (-1289220344 ^ -1289220280);
                    var1_1 = this.readFrameType(var4_4.stack, -1657917437 ^ -1657917437, var1_1, var5_5, var6_6);
                    var4_4.mode = 305656818 ^ 305656822;
                    var4_4.stackCount = 1528980258 ^ 1528980259;
                    break block12;
                }
                var8_8 = this.readUnsignedShort(var1_1);
                var1_1 += 2;
                if (var7_7 != (-672048815 ^ -672048730)) break block14;
                var1_1 = this.readFrameType(var4_4.stack, 1885906317 ^ 1885906317, var1_1, var5_5, var6_6);
                var4_4.mode = -1646036972 ^ -1646036976;
                var4_4.stackCount = -1771981425 ^ -1771981426;
                break block12;
            }
            if (var7_7 < (-697957290 ^ -697957202)) ** GOTO lbl-1000
            if (var7_7 < (1220129730 ^ 1220129593)) {
                var4_4.mode = -840730390 ^ -840730392;
                var4_4.localDiff = (-788015000 ^ -788014957) - var7_7;
                var4_4.localCount -= var4_4.localDiff;
                var4_4.stackCount = 1198988510 ^ 1198988510;
            } else if (var7_7 == (1522376294 ^ 1522376349)) {
                var4_4.mode = -190154870 ^ -190154871;
                var4_4.stackCount = 1435271639 ^ 1435271639;
            } else if (var7_7 < (541593017 ^ 541592902)) {
                var9_9 = var3_3 ? var4_4.localCount : 1782556516 ^ 1782556516;
                for (var10_11 = var7_7 - (109545926 ^ 109545789); var10_11 > 0; --var10_11) {
                    var1_1 = this.readFrameType(var4_4.local, var9_9++, var1_1, var5_5, var6_6);
                }
                var4_4.mode = -1113920588 ^ -1113920587;
                var4_4.localDiff = var7_7 - (69542844 ^ 69542727);
                var4_4.localCount += var4_4.localDiff;
                var4_4.stackCount = 463175891 ^ 463175891;
            } else {
                var4_4.mode = 2013604729 ^ 2013604729;
                var9_10 = this.readUnsignedShort(var1_1);
                var1_1 += 2;
                var4_4.localDiff = var9_10;
                var4_4.localCount = var9_10;
                var10_12 = -412006833 ^ -412006833;
                while (var9_10 > 0) {
                    var1_1 = this.readFrameType(var4_4.local, var10_12++, var1_1, var5_5, var6_6);
                    --var9_10;
                }
                var9_10 = this.readUnsignedShort(var1_1);
                var1_1 += 2;
                var4_4.stackCount = var9_10;
                var10_12 = 1460616176 ^ 1460616176;
                while (var9_10 > 0) {
                    var1_1 = this.readFrameType(var4_4.stack, var10_12++, var1_1, var5_5, var6_6);
                    --var9_10;
                }
            }
        }
        var4_4.offset += var8_8 + (1304672819 ^ 1304672818);
        this.readLabel(var4_4.offset, var6_6);
        return var1_1;
    }

    private int readFrameType(Object[] objectArray, int n, int n2, char[] cArray, Label[] labelArray) {
        int n3 = n2++;
        int n4 = this.b[n3] & (0x874AF92A ^ 0x874AF9D5);
        switch (n4) {
            case 0: {
                objectArray[n] = Opcodes.TOP;
                break;
            }
            case 1: {
                objectArray[n] = Opcodes.INTEGER;
                break;
            }
            case 2: {
                objectArray[n] = Opcodes.FLOAT;
                break;
            }
            case 3: {
                objectArray[n] = Opcodes.DOUBLE;
                break;
            }
            case 4: {
                objectArray[n] = Opcodes.LONG;
                break;
            }
            case 5: {
                objectArray[n] = Opcodes.NULL;
                break;
            }
            case 6: {
                objectArray[n] = Opcodes.UNINITIALIZED_THIS;
                break;
            }
            case 7: {
                objectArray[n] = this.readClass(n2, cArray);
                n2 += 2;
                break;
            }
            default: {
                objectArray[n] = this.readLabel(this.readUnsignedShort(n2), labelArray);
                n2 += 2;
            }
        }
        return n2;
    }

    protected Label readLabel(int n, Label[] labelArray) {
        if (labelArray[n] == null) {
            labelArray[n] = new Label();
        }
        return labelArray[n];
    }

    private int getAttributes() {
        int n;
        int n2;
        int n3 = this.header + (0xCB2C60FD ^ 0xCB2C60F5) + this.readUnsignedShort(this.header + (0xC9049971 ^ 0xC9049977)) * (0xF3D829F8 ^ 0xF3D829FA);
        for (n2 = this.readUnsignedShort(n3); n2 > 0; --n2) {
            for (n = this.readUnsignedShort(n3 + (0x7E3190C5 ^ 0x7E3190CD)); n > 0; --n) {
                n3 += (0x75EFFFA6 ^ 0x75EFFFA0) + this.readInt(n3 + (0xC49CD43B ^ 0xC49CD437));
            }
            n3 += 8;
        }
        for (n2 = this.readUnsignedShort(n3 += 2); n2 > 0; --n2) {
            for (n = this.readUnsignedShort(n3 + (0xE1289C9 ^ 0xE1289C1)); n > 0; --n) {
                n3 += (0x5DAF351C ^ 0x5DAF351A) + this.readInt(n3 + (0x798A99A7 ^ 0x798A99AB));
            }
            n3 += 8;
        }
        return n3 + (0x1BEE5581 ^ 0x1BEE5583);
    }

    private Attribute readAttribute(Attribute[] attributeArray, String string, int n, int n2, char[] cArray, int n3, Label[] labelArray) {
        for (int i = 0x67763732 ^ 0x67763732; i < attributeArray.length; ++i) {
            if (!attributeArray[i].type.equals(string)) continue;
            return attributeArray[i].read(this, n, n2, cArray, n3, labelArray);
        }
        return new Attribute(string).read(this, n, n2, null, 0x678CA436 ^ 0x98735BC9, null);
    }

    public int getItemCount() {
        return this.items.length;
    }

    public int getItem(int n) {
        return this.items[n];
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public int readByte(int n) {
        return this.b[n] & (0x695EC14B ^ 0x695EC1B4);
    }

    public int readUnsignedShort(int n) {
        byte[] byArray = this.b;
        return (byArray[n] & (0x94DFAE96 ^ 0x94DFAE69)) << (0x62101FE8 ^ 0x62101FE0) | byArray[n + (0x607BD336 ^ 0x607BD337)] & (0x18DE1A9B ^ 0x18DE1A64);
    }

    public short readShort(int n) {
        byte[] byArray = this.b;
        return (short)((byArray[n] & (0x6329198B ^ 0x63291974)) << (0x259C7D34 ^ 0x259C7D3C) | byArray[n + (0xED38CC64 ^ 0xED38CC65)] & (0x598163C5 ^ 0x5981633A));
    }

    public int readInt(int n) {
        byte[] byArray = this.b;
        return (byArray[n] & (0x8D28BF6F ^ 0x8D28BF90)) << (0x78520844 ^ 0x7852085C) | (byArray[n + (0xA498D131 ^ 0xA498D130)] & (0xE5D48DE2 ^ 0xE5D48D1D)) << (0x9C4B94CD ^ 0x9C4B94DD) | (byArray[n + (0x2C160DB9 ^ 0x2C160DBB)] & (0x15C8B514 ^ 0x15C8B5EB)) << (0x74E80115 ^ 0x74E8011D) | byArray[n + (0x1D15600D ^ 0x1D15600E)] & (0xFFD8E8E ^ 0xFFD8E71);
    }

    public long readLong(int n) {
        long l = this.readInt(n);
        long l2 = (long)this.readInt(n + (0xC8711570 ^ 0xC8711574)) & (0xD01DA917ADF8C7B8L ^ 0xD01DA91752073847L);
        return l << (0xC0585696 ^ 0xC05856B6) | l2;
    }

    public String readUTF8(int n, char[] cArray) {
        int n2 = this.readUnsignedShort(n);
        if (n == 0 || n2 == 0) {
            return null;
        }
        String string = this.strings[n2];
        if (string != null) {
            return string;
        }
        n = this.items[n2];
        this.strings[n2] = this.readUTF(n + (0x4F4F3DB9 ^ 0x4F4F3DBB), this.readUnsignedShort(n), cArray);
        return this.strings[n2];
    }

    private String readUTF(int n, int n2, char[] cArray) {
        int n3 = n + n2;
        byte[] byArray = this.b;
        int n4 = 0x8A04A915 ^ 0x8A04A915;
        int n5 = 0x8C6A659E ^ 0x8C6A659E;
        int n6 = 0x43369038 ^ 0x43369038;
        while (n < n3) {
            int n7 = byArray[n++];
            switch (n5) {
                case 0: {
                    if ((n7 &= 0xDC924C80 ^ 0xDC924C7F) < (0xC62C1689 ^ 0xC62C1609)) {
                        cArray[n4++] = (char)n7;
                        break;
                    }
                    if (n7 < (0x665312F7 ^ 0x66531217)) {
                        if (n7 > (0xD53E31EC ^ 0xD53E3153)) {
                            n6 = (char)(n7 & (0xF6B459ED ^ 0xF6B459F2));
                            n5 = 0x9D829A73 ^ 0x9D829A72;
                            break;
                        }
                    }
                    n6 = (char)(n7 & (0xBB38D872 ^ 0xBB38D87D));
                    n5 = 0xF1630A57 ^ 0xF1630A55;
                    break;
                }
                case 1: {
                    int n8 = n4++;
                    cArray[n8] = (char)(n6 << (0x6822D41C ^ 0x6822D41A) | n7 & (0xCB4A7426 ^ 0xCB4A7419));
                    n5 = 0x99ACAC25 ^ 0x99ACAC25;
                    break;
                }
                case 2: {
                    n6 = (char)(n6 << (0x7FB80B8 ^ 0x7FB80BE) | n7 & (0x528F7FE8 ^ 0x528F7FD7));
                    n5 = 0xB9D67A18 ^ 0xB9D67A19;
                }
            }
        }
        return new String(cArray, 0x20DBEBAD ^ 0x20DBEBAD, n4);
    }

    public String readClass(int n, char[] cArray) {
        return this.readUTF8(this.items[this.readUnsignedShort(n)], cArray);
    }

    public Object readConst(int n, char[] cArray) {
        int n2 = this.items[n];
        switch (this.b[n2 - (0xAAE15DB1 ^ 0xAAE15DB0)]) {
            case 3: {
                return this.readInt(n2);
            }
            case 4: {
                return Float.valueOf(Float.intBitsToFloat(this.readInt(n2)));
            }
            case 5: {
                return this.readLong(n2);
            }
            case 6: {
                return Double.longBitsToDouble(this.readLong(n2));
            }
            case 7: {
                return Type.getObjectType(this.readUTF8(n2, cArray));
            }
            case 8: {
                return this.readUTF8(n2, cArray);
            }
            case 16: {
                return Type.getMethodType(this.readUTF8(n2, cArray));
            }
        }
        int n3 = this.readByte(n2);
        int[] nArray = this.items;
        int n4 = nArray[this.readUnsignedShort(n2 + (0xF2698A2E ^ 0xF2698A2F))];
        int n5 = this.b[n4 - (0xA3A9F39A ^ 0xA3A9F39B)] == (0x22F6933A ^ 0x22F69331) ? 0x3C1F53D3 ^ 0x3C1F53D2 : 0x895F90B4 ^ 0x895F90B4;
        String string = this.readClass(n4, cArray);
        n4 = nArray[this.readUnsignedShort(n4 + (0x4B6E01EB ^ 0x4B6E01E9))];
        String string2 = this.readUTF8(n4, cArray);
        String string3 = this.readUTF8(n4 + (0xE49E9C8C ^ 0xE49E9C8E), cArray);
        return new Handle(n3, string, string2, string3, n5 != 0);
    }
}

