/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib;

final class Item {
    int index;
    int type;
    int intVal;
    long longVal;
    String strVal1;
    String strVal2;
    String strVal3;
    int hashCode;
    Item next;

    Item() {
    }

    Item(int n) {
        this.index = n;
    }

    Item(int n, Item item) {
        this.index = n;
        this.type = item.type;
        this.intVal = item.intVal;
        this.longVal = item.longVal;
        this.strVal1 = item.strVal1;
        this.strVal2 = item.strVal2;
        this.strVal3 = item.strVal3;
        this.hashCode = item.hashCode;
    }

    void set(int n) {
        this.type = 0x81B36A19 ^ 0x81B36A1A;
        this.intVal = n;
        this.hashCode = (0x5B060F6 ^ 0x7A4F9F09) & this.type + n;
    }

    void set(long l) {
        this.type = 0x8608763 ^ 0x8608766;
        this.longVal = l;
        this.hashCode = (0x5B124747 ^ 0x24EDB8B8) & this.type + (int)l;
    }

    void set(float f) {
        this.type = 0x68CA5C64 ^ 0x68CA5C60;
        this.intVal = Float.floatToRawIntBits(f);
        this.hashCode = (0x1531BBCD ^ 0x6ACE4432) & this.type + (int)f;
    }

    void set(double d) {
        this.type = 0x62D6C5F6 ^ 0x62D6C5F0;
        this.longVal = Double.doubleToRawLongBits(d);
        this.hashCode = (0x233F15EA ^ 0x5CC0EA15) & this.type + (int)d;
    }

    void set(int n, String string, String string2, String string3) {
        this.type = n;
        this.strVal1 = string;
        this.strVal2 = string2;
        this.strVal3 = string3;
        switch (n) {
            case 7: {
                this.intVal = 0x20FA80EA ^ 0x20FA80EA;
            }
            case 1: 
            case 8: 
            case 16: 
            case 30: {
                this.hashCode = (0xADBF5521 ^ 0xD240AADE) & n + string.hashCode();
                return;
            }
            case 12: {
                this.hashCode = (0xE95AD332 ^ 0x96A52CCD) & n + string.hashCode() * string2.hashCode();
                return;
            }
        }
        this.hashCode = (0x4D4DBA73 ^ 0x32B2458C) & n + string.hashCode() * string2.hashCode() * string3.hashCode();
    }

    void set(String string, String string2, int n) {
        this.type = 0xF018916F ^ 0xF018917D;
        this.longVal = n;
        this.strVal1 = string;
        this.strVal2 = string2;
        this.hashCode = (0x6F2B3074 ^ 0x10D4CF8B) & (0xEE483EAC ^ 0xEE483EBE) + n * this.strVal1.hashCode() * this.strVal2.hashCode();
    }

    void set(int n, int n2) {
        this.type = 0x3A59FE6E ^ 0x3A59FE4F;
        this.intVal = n;
        this.hashCode = n2;
    }

    boolean isEqualTo(Item item) {
        switch (this.type) {
            case 1: 
            case 7: 
            case 8: 
            case 16: 
            case 30: {
                return item.strVal1.equals(this.strVal1);
            }
            case 5: 
            case 6: 
            case 32: {
                return (item.longVal == this.longVal ? 0xAB33265D ^ 0xAB33265C : 0x1D94E55 ^ 0x1D94E55) != 0;
            }
            case 3: 
            case 4: {
                return (item.intVal == this.intVal ? 0x6DF91392 ^ 0x6DF91393 : 0xF08D371F ^ 0xF08D371F) != 0;
            }
            case 31: {
                return (item.intVal == this.intVal && item.strVal1.equals(this.strVal1) ? 0x8496DD78 ^ 0x8496DD79 : 0x1E983B96 ^ 0x1E983B96) != 0;
            }
            case 12: {
                return (item.strVal1.equals(this.strVal1) && item.strVal2.equals(this.strVal2) ? 0x56930FEF ^ 0x56930FEE : 0xFA24E7BB ^ 0xFA24E7BB) != 0;
            }
            case 18: {
                return (item.longVal == this.longVal && item.strVal1.equals(this.strVal1) && item.strVal2.equals(this.strVal2) ? 0x5E7266C ^ 0x5E7266D : 0xCD090716 ^ 0xCD090716) != 0;
            }
        }
        return (item.strVal1.equals(this.strVal1) && item.strVal2.equals(this.strVal2) && item.strVal3.equals(this.strVal3) ? 0x3D87B07B ^ 0x3D87B07A : 0x8975E704 ^ 0x8975E704) != 0;
    }
}

