/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib;

import org.spongepowered.asm.lib.ByteVector;

public class TypePath {
    public static final int ARRAY_ELEMENT = 0;
    public static final int INNER_TYPE = 1;
    public static final int WILDCARD_BOUND = 2;
    public static final int TYPE_ARGUMENT = 3;
    byte[] b;
    int offset;

    TypePath(byte[] byArray, int n) {
        this.b = byArray;
        this.offset = n;
    }

    public int getLength() {
        return this.b[this.offset];
    }

    public int getStep(int n) {
        return this.b[this.offset + (0x4FFD6588 ^ 0x4FFD658A) * n + (0xFD3135C7 ^ 0xFD3135C6)];
    }

    public int getStepArgument(int n) {
        return this.b[this.offset + (0x376524C8 ^ 0x376524CA) * n + (0x9DB5FBAB ^ 0x9DB5FBA9)];
    }

    public static TypePath fromString(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.length();
        ByteVector byteVector = new ByteVector(n);
        byteVector.putByte(0xD46408CA ^ 0xD46408CA);
        int n2 = 0xE713E5FE ^ 0xE713E5FE;
        while (n2 < n) {
            char c = string.charAt(n2++);
            if (c == (0x11BA8956 ^ 0x11BA890D)) {
                byteVector.put11(0x6181C0D3 ^ 0x6181C0D3, 0xF5128A40 ^ 0xF5128A40);
                continue;
            }
            if (c == (0x6C3B673C ^ 0x6C3B6712)) {
                byteVector.put11(0xA147083 ^ 0xA147082, 0xEF5CE7E0 ^ 0xEF5CE7E0);
                continue;
            }
            if (c == (0x3D6CAB98 ^ 0x3D6CABB2)) {
                byteVector.put11(0x764B0077 ^ 0x764B0075, 0x1A3FBB1D ^ 0x1A3FBB1D);
                continue;
            }
            if (c < (0x60343196 ^ 0x603431A6)) continue;
            if (c > (0x64D339FF ^ 0x64D339C6)) continue;
            int n3 = c - (0xE8E2E803 ^ 0xE8E2E833);
            while (n2 < n) {
                c = string.charAt(n2);
                if (c < (0x91F58E78 ^ 0x91F58E48)) break;
                if (c > (0x358D171 ^ 0x358D148)) break;
                n3 = n3 * (0x369E1A23 ^ 0x369E1A29) + c - (0x8E0F6182 ^ 0x8E0F61B2);
                ++n2;
            }
            if (n2 < n) {
                if (string.charAt(n2) == (0xE8507398 ^ 0xE85073A3)) {
                    ++n2;
                }
            }
            byteVector.put11(0xFE314AC5 ^ 0xFE314AC6, n3);
        }
        byteVector.data[0x7095B1EB ^ 0x7095B1EB] = (byte)(byteVector.length / (0x8D9F65A3 ^ 0x8D9F65A1));
        return new TypePath(byteVector.data, 0xC783DFEE ^ 0xC783DFEE);
    }

    public String toString() {
        int n = this.getLength();
        StringBuilder stringBuilder = new StringBuilder(n * (0xA7BD3FE2 ^ 0xA7BD3FE0));
        block6: for (int i = 0xD807CB49 ^ 0xD807CB49; i < n; ++i) {
            switch (this.getStep(i)) {
                case 0: {
                    stringBuilder.append((char)(0xF11663D ^ 0xF116666));
                    continue block6;
                }
                case 1: {
                    stringBuilder.append((char)(0x1B3D08AF ^ 0x1B3D0881));
                    continue block6;
                }
                case 2: {
                    stringBuilder.append((char)(0x91C57B96 ^ 0x91C57BBC));
                    continue block6;
                }
                case 3: {
                    stringBuilder.append(this.getStepArgument(i)).append((char)(0x10512F5C ^ 0x10512F67));
                    continue block6;
                }
                default: {
                    stringBuilder.append((char)(0xDAEACF67 ^ 0xDAEACF38));
                }
            }
        }
        return stringBuilder.toString();
    }
}

