/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.signature;

import org.spongepowered.asm.lib.signature.SignatureVisitor;

public class SignatureWriter
extends SignatureVisitor {
    private final StringBuilder buf = new StringBuilder();
    private boolean hasFormals;
    private boolean hasParameters;
    private int argumentStack;

    public SignatureWriter() {
        super(0xE4102152 ^ 0xE4152152);
    }

    public void visitFormalTypeParameter(String string) {
        if (!this.hasFormals) {
            this.hasFormals = 0xB8BF96D0 ^ 0xB8BF96D1;
            this.buf.append((char)(0x92101E7D ^ 0x92101E41));
        }
        this.buf.append(string);
        this.buf.append((char)(0x48DA6B94 ^ 0x48DA6BAE));
    }

    public SignatureVisitor visitClassBound() {
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        this.buf.append((char)(0xE9F6576E ^ 0xE9F65754));
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        this.endFormals();
        return this;
    }

    public SignatureVisitor visitInterface() {
        return this;
    }

    public SignatureVisitor visitParameterType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.hasParameters = 0xAA0C4271 ^ 0xAA0C4270;
            this.buf.append((char)(0x4BDF2588 ^ 0x4BDF25A0));
        }
        return this;
    }

    public SignatureVisitor visitReturnType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.buf.append((char)(0x1B5D2A7C ^ 0x1B5D2A54));
        }
        this.buf.append((char)(0x49CEFFA4 ^ 0x49CEFF8D));
        return this;
    }

    public SignatureVisitor visitExceptionType() {
        this.buf.append((char)(0x2C328305 ^ 0x2C32835B));
        return this;
    }

    public void visitBaseType(char c) {
        this.buf.append(c);
    }

    public void visitTypeVariable(String string) {
        this.buf.append((char)(0xA31D0C5A ^ 0xA31D0C0E));
        this.buf.append(string);
        this.buf.append((char)(0xA59C9D0A ^ 0xA59C9D31));
    }

    public SignatureVisitor visitArrayType() {
        this.buf.append((char)(0xE8BEA75 ^ 0xE8BEA2E));
        return this;
    }

    public void visitClassType(String string) {
        this.buf.append((char)(0x80B6D417 ^ 0x80B6D45B));
        this.buf.append(string);
        this.argumentStack *= 0xCECC9E1D ^ 0xCECC9E1F;
    }

    public void visitInnerClassType(String string) {
        this.endArguments();
        this.buf.append((char)(0xC3A5E817 ^ 0xC3A5E839));
        this.buf.append(string);
        this.argumentStack *= 0x3B21E9BF ^ 0x3B21E9BD;
    }

    public void visitTypeArgument() {
        if (this.argumentStack % (0xEE385086 ^ 0xEE385084) == 0) {
            this.argumentStack += 0x7B3939F4 ^ 0x7B3939F5;
            this.buf.append((char)(0x64BA30D9 ^ 0x64BA30E5));
        }
        this.buf.append((char)(0xC55329D5 ^ 0xC55329FF));
    }

    public SignatureVisitor visitTypeArgument(char c) {
        if (this.argumentStack % (0x3CDE9997 ^ 0x3CDE9995) == 0) {
            this.argumentStack += 0xF13996A ^ 0xF13996B;
            this.buf.append((char)(0x2F15DB75 ^ 0x2F15DB49));
        }
        if (c != (0x3C048C9A ^ 0x3C048CA7)) {
            this.buf.append(c);
        }
        return this;
    }

    public void visitEnd() {
        this.endArguments();
        this.buf.append((char)(0x3443C8EB ^ 0x3443C8D0));
    }

    public String toString() {
        return this.buf.toString();
    }

    private void endFormals() {
        if (this.hasFormals) {
            this.hasFormals = 0xDCB1ADE8 ^ 0xDCB1ADE8;
            this.buf.append((char)(0xABC95CD3 ^ 0xABC95CED));
        }
    }

    private void endArguments() {
        if (this.argumentStack % (0xC7238AA7 ^ 0xC7238AA5) != 0) {
            this.buf.append((char)(0xE0E924F9 ^ 0xE0E924C7));
        }
        this.argumentStack /= 0x2BDE9627 ^ 0x2BDE9625;
    }
}

