/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameNode
extends AbstractInsnNode {
    public int type;
    public List<Object> local;
    public List<Object> stack;

    private FrameNode() {
        super(0x4AF09A01 ^ 0xB50F65FE);
    }

    public FrameNode(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        super(0x172EA282 ^ 0xE8D15D7D);
        this.type = n;
        switch (n) {
            case -1: 
            case 0: {
                this.local = FrameNode.asList(n2, objectArray);
                this.stack = FrameNode.asList(n3, objectArray2);
                break;
            }
            case 1: {
                this.local = FrameNode.asList(n2, objectArray);
                break;
            }
            case 2: {
                this.local = Arrays.asList(new Object[n2]);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.stack = FrameNode.asList(0xE6743DC7 ^ 0xE6743DC6, objectArray2);
            }
        }
    }

    @Override
    public int getType() {
        return 0x7FB369B2 ^ 0x7FB369BC;
    }

    @Override
    public void accept(MethodVisitor methodVisitor) {
        switch (this.type) {
            case -1: 
            case 0: {
                methodVisitor.visitFrame(this.type, this.local.size(), FrameNode.asArray(this.local), this.stack.size(), FrameNode.asArray(this.stack));
                break;
            }
            case 1: {
                methodVisitor.visitFrame(this.type, this.local.size(), FrameNode.asArray(this.local), 0x64AC8BF1 ^ 0x64AC8BF1, null);
                break;
            }
            case 2: {
                methodVisitor.visitFrame(this.type, this.local.size(), null, 0x91EFBD3F ^ 0x91EFBD3F, null);
                break;
            }
            case 3: {
                methodVisitor.visitFrame(this.type, 0x1B6EFCAF ^ 0x1B6EFCAF, null, 0x200A8E96 ^ 0x200A8E96, null);
                break;
            }
            case 4: {
                methodVisitor.visitFrame(this.type, 0xBE276BA4 ^ 0xBE276BA4, null, 0xD94B7C85 ^ 0xD94B7C84, FrameNode.asArray(this.stack));
            }
        }
    }

    @Override
    public AbstractInsnNode clone(Map<LabelNode, LabelNode> map) {
        Object object;
        int n;
        FrameNode frameNode = new FrameNode();
        frameNode.type = this.type;
        if (this.local != null) {
            frameNode.local = new ArrayList<Object>();
            for (n = 0x432D6CBC ^ 0x432D6CBC; n < this.local.size(); ++n) {
                object = this.local.get(n);
                if (object instanceof LabelNode) {
                    object = map.get(object);
                }
                frameNode.local.add(object);
            }
        }
        if (this.stack != null) {
            frameNode.stack = new ArrayList<Object>();
            for (n = 0xE67E34E6 ^ 0xE67E34E6; n < this.stack.size(); ++n) {
                object = this.stack.get(n);
                if (object instanceof LabelNode) {
                    object = map.get(object);
                }
                frameNode.stack.add(object);
            }
        }
        return frameNode;
    }

    private static List<Object> asList(int n, Object[] objectArray) {
        return Arrays.asList(objectArray).subList(0xE0313698 ^ 0xE0313698, n);
    }

    private static Object[] asArray(List<Object> list) {
        Object[] objectArray = new Object[list.size()];
        for (int i = 0x7EE3FD92 ^ 0x7EE3FD92; i < objectArray.length; ++i) {
            Object object = list.get(i);
            if (object instanceof LabelNode) {
                object = ((LabelNode)object).getLabel();
            }
            objectArray[i] = object;
        }
        return objectArray;
    }
}

