/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.spongepowered.asm.lib.AnnotationVisitor;
import org.spongepowered.asm.lib.Attribute;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.Handle;
import org.spongepowered.asm.lib.Label;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.TypePath;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FrameNode;
import org.spongepowered.asm.lib.tree.IincInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.IntInsnNode;
import org.spongepowered.asm.lib.tree.InvokeDynamicInsnNode;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.LineNumberNode;
import org.spongepowered.asm.lib.tree.LocalVariableAnnotationNode;
import org.spongepowered.asm.lib.tree.LocalVariableNode;
import org.spongepowered.asm.lib.tree.LookupSwitchInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MultiANewArrayInsnNode;
import org.spongepowered.asm.lib.tree.ParameterNode;
import org.spongepowered.asm.lib.tree.TableSwitchInsnNode;
import org.spongepowered.asm.lib.tree.TryCatchBlockNode;
import org.spongepowered.asm.lib.tree.TypeAnnotationNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;

public class MethodNode
extends MethodVisitor {
    public int access;
    public String name;
    public String desc;
    public String signature;
    public List<String> exceptions;
    public List<ParameterNode> parameters;
    public List<AnnotationNode> visibleAnnotations;
    public List<AnnotationNode> invisibleAnnotations;
    public List<TypeAnnotationNode> visibleTypeAnnotations;
    public List<TypeAnnotationNode> invisibleTypeAnnotations;
    public List<Attribute> attrs;
    public Object annotationDefault;
    public List<AnnotationNode>[] visibleParameterAnnotations;
    public List<AnnotationNode>[] invisibleParameterAnnotations;
    public InsnList instructions;
    public List<TryCatchBlockNode> tryCatchBlocks;
    public int maxStack;
    public int maxLocals;
    public List<LocalVariableNode> localVariables;
    public List<LocalVariableAnnotationNode> visibleLocalVariableAnnotations;
    public List<LocalVariableAnnotationNode> invisibleLocalVariableAnnotations;
    private boolean visited;

    public MethodNode() {
        this(0x9F36ED9B ^ 0x9F33ED9B);
        if (this.getClass() != MethodNode.class) {
            throw new IllegalStateException();
        }
    }

    public MethodNode(int n) {
        super(n);
        this.instructions = new InsnList();
    }

    public MethodNode(int n, String string, String string2, String string3, String[] stringArray) {
        this(0xEE571D56 ^ 0xEE521D56, n, string, string2, string3, stringArray);
        if (this.getClass() != MethodNode.class) {
            throw new IllegalStateException();
        }
    }

    public MethodNode(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        super(n);
        int n3;
        this.access = n2;
        this.name = string;
        this.desc = string2;
        this.signature = string3;
        this.exceptions = new ArrayList<String>(stringArray == null ? 0x46B05540 ^ 0x46B05540 : stringArray.length);
        int n4 = (n2 & (0xF780D979 ^ 0xF780DD79)) != 0 ? 0x6F06A6CC ^ 0x6F06A6CD : (n3 = 0xC33A9AB4 ^ 0xC33A9AB4);
        if (n3 == 0) {
            this.localVariables = new ArrayList<LocalVariableNode>(0xEA00AD93 ^ 0xEA00AD96);
        }
        this.tryCatchBlocks = new ArrayList<TryCatchBlockNode>();
        if (stringArray != null) {
            this.exceptions.addAll(Arrays.asList(stringArray));
        }
        this.instructions = new InsnList();
    }

    public void visitParameter(String string, int n) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParameterNode>(0xD3F68433 ^ 0xD3F68436);
        }
        this.parameters.add(new ParameterNode(string, n));
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return new AnnotationNode((List<Object>)new ArrayList<Object>(0xF2F789B2 ^ 0xF2F789B2){

            @Override
            public boolean add(Object object) {
                MethodNode.this.annotationDefault = object;
                return super.add(object);
            }
        });
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        AnnotationNode annotationNode = new AnnotationNode(string);
        if (bl) {
            if (this.visibleAnnotations == null) {
                this.visibleAnnotations = new ArrayList<AnnotationNode>(0xDB4C5397 ^ 0xDB4C5396);
            }
            this.visibleAnnotations.add(annotationNode);
        } else {
            if (this.invisibleAnnotations == null) {
                this.invisibleAnnotations = new ArrayList<AnnotationNode>(0x264D02FD ^ 0x264D02FC);
            }
            this.invisibleAnnotations.add(annotationNode);
        }
        return annotationNode;
    }

    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        TypeAnnotationNode typeAnnotationNode = new TypeAnnotationNode(n, typePath, string);
        if (bl) {
            if (this.visibleTypeAnnotations == null) {
                this.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0x90348A4D ^ 0x90348A4C);
            }
            this.visibleTypeAnnotations.add(typeAnnotationNode);
        } else {
            if (this.invisibleTypeAnnotations == null) {
                this.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0xAFE7EDFC ^ 0xAFE7EDFD);
            }
            this.invisibleTypeAnnotations.add(typeAnnotationNode);
        }
        return typeAnnotationNode;
    }

    public AnnotationVisitor visitParameterAnnotation(int n, String string, boolean bl) {
        AnnotationNode annotationNode = new AnnotationNode(string);
        if (bl) {
            if (this.visibleParameterAnnotations == null) {
                int n2 = Type.getArgumentTypes(this.desc).length;
                this.visibleParameterAnnotations = new List[n2];
            }
            if (this.visibleParameterAnnotations[n] == null) {
                this.visibleParameterAnnotations[n] = new ArrayList<AnnotationNode>(0xB5FC1BBD ^ 0xB5FC1BBC);
            }
            this.visibleParameterAnnotations[n].add(annotationNode);
        } else {
            if (this.invisibleParameterAnnotations == null) {
                int n3 = Type.getArgumentTypes(this.desc).length;
                this.invisibleParameterAnnotations = new List[n3];
            }
            if (this.invisibleParameterAnnotations[n] == null) {
                this.invisibleParameterAnnotations[n] = new ArrayList<AnnotationNode>(0xCAFFAA31 ^ 0xCAFFAA30);
            }
            this.invisibleParameterAnnotations[n].add(annotationNode);
        }
        return annotationNode;
    }

    public void visitAttribute(Attribute attribute) {
        if (this.attrs == null) {
            this.attrs = new ArrayList<Attribute>(0x35716FCE ^ 0x35716FCF);
        }
        this.attrs.add(attribute);
    }

    public void visitCode() {
    }

    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        this.instructions.add(new FrameNode(n, n2, objectArray == null ? null : this.getLabelNodes(objectArray), n3, objectArray2 == null ? null : this.getLabelNodes(objectArray2)));
    }

    public void visitInsn(int n) {
        this.instructions.add(new InsnNode(n));
    }

    public void visitIntInsn(int n, int n2) {
        this.instructions.add(new IntInsnNode(n, n2));
    }

    public void visitVarInsn(int n, int n2) {
        this.instructions.add(new VarInsnNode(n, n2));
    }

    public void visitTypeInsn(int n, String string) {
        this.instructions.add(new TypeInsnNode(n, string));
    }

    public void visitFieldInsn(int n, String string, String string2, String string3) {
        this.instructions.add(new FieldInsnNode(n, string, string2, string3));
    }

    @Deprecated
    public void visitMethodInsn(int n, String string, String string2, String string3) {
        if (this.api >= (0x6BE3686F ^ 0x6BE6686F)) {
            super.visitMethodInsn(n, string, string2, string3);
            return;
        }
        this.instructions.add(new MethodInsnNode(n, string, string2, string3));
    }

    public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
        if (this.api < (0x7D8D011E ^ 0x7D88011E)) {
            super.visitMethodInsn(n, string, string2, string3, bl);
            return;
        }
        this.instructions.add(new MethodInsnNode(n, string, string2, string3, bl));
    }

    public void visitInvokeDynamicInsn(String string, String string2, Handle handle, Object ... objectArray) {
        this.instructions.add(new InvokeDynamicInsnNode(string, string2, handle, objectArray));
    }

    public void visitJumpInsn(int n, Label label) {
        this.instructions.add(new JumpInsnNode(n, this.getLabelNode(label)));
    }

    public void visitLabel(Label label) {
        this.instructions.add(this.getLabelNode(label));
    }

    public void visitLdcInsn(Object object) {
        this.instructions.add(new LdcInsnNode(object));
    }

    public void visitIincInsn(int n, int n2) {
        this.instructions.add(new IincInsnNode(n, n2));
    }

    public void visitTableSwitchInsn(int n, int n2, Label label, Label ... labelArray) {
        this.instructions.add(new TableSwitchInsnNode(n, n2, this.getLabelNode(label), this.getLabelNodes(labelArray)));
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.instructions.add(new LookupSwitchInsnNode(this.getLabelNode(label), nArray, this.getLabelNodes(labelArray)));
    }

    public void visitMultiANewArrayInsn(String string, int n) {
        this.instructions.add(new MultiANewArrayInsnNode(string, n));
    }

    public AnnotationVisitor visitInsnAnnotation(int n, TypePath typePath, String string, boolean bl) {
        AbstractInsnNode abstractInsnNode = this.instructions.getLast();
        while (true) {
            if (abstractInsnNode.getOpcode() != (0xFC579EEE ^ 0x3A86111)) break;
            abstractInsnNode = abstractInsnNode.getPrevious();
        }
        TypeAnnotationNode typeAnnotationNode = new TypeAnnotationNode(n, typePath, string);
        if (bl) {
            if (abstractInsnNode.visibleTypeAnnotations == null) {
                abstractInsnNode.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0x4FE1F419 ^ 0x4FE1F418);
            }
            abstractInsnNode.visibleTypeAnnotations.add(typeAnnotationNode);
        } else {
            if (abstractInsnNode.invisibleTypeAnnotations == null) {
                abstractInsnNode.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0xC47F1175 ^ 0xC47F1174);
            }
            abstractInsnNode.invisibleTypeAnnotations.add(typeAnnotationNode);
        }
        return typeAnnotationNode;
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.tryCatchBlocks.add(new TryCatchBlockNode(this.getLabelNode(label), this.getLabelNode(label2), this.getLabelNode(label3), string));
    }

    public AnnotationVisitor visitTryCatchAnnotation(int n, TypePath typePath, String string, boolean bl) {
        TryCatchBlockNode tryCatchBlockNode = this.tryCatchBlocks.get((n & (0x244A1D2C ^ 0x24B5E22C)) >> (0x6D81E343 ^ 0x6D81E34B));
        TypeAnnotationNode typeAnnotationNode = new TypeAnnotationNode(n, typePath, string);
        if (bl) {
            if (tryCatchBlockNode.visibleTypeAnnotations == null) {
                tryCatchBlockNode.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0xBB54E5F3 ^ 0xBB54E5F2);
            }
            tryCatchBlockNode.visibleTypeAnnotations.add(typeAnnotationNode);
        } else {
            if (tryCatchBlockNode.invisibleTypeAnnotations == null) {
                tryCatchBlockNode.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0x9F7FFAE0 ^ 0x9F7FFAE1);
            }
            tryCatchBlockNode.invisibleTypeAnnotations.add(typeAnnotationNode);
        }
        return typeAnnotationNode;
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        this.localVariables.add(new LocalVariableNode(string, string2, string3, this.getLabelNode(label), this.getLabelNode(label2), n));
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int n, TypePath typePath, Label[] labelArray, Label[] labelArray2, int[] nArray, String string, boolean bl) {
        LocalVariableAnnotationNode localVariableAnnotationNode = new LocalVariableAnnotationNode(n, typePath, this.getLabelNodes(labelArray), this.getLabelNodes(labelArray2), nArray, string);
        if (bl) {
            if (this.visibleLocalVariableAnnotations == null) {
                this.visibleLocalVariableAnnotations = new ArrayList<LocalVariableAnnotationNode>(0xEEB72D12 ^ 0xEEB72D13);
            }
            this.visibleLocalVariableAnnotations.add(localVariableAnnotationNode);
        } else {
            if (this.invisibleLocalVariableAnnotations == null) {
                this.invisibleLocalVariableAnnotations = new ArrayList<LocalVariableAnnotationNode>(0x11D32C59 ^ 0x11D32C58);
            }
            this.invisibleLocalVariableAnnotations.add(localVariableAnnotationNode);
        }
        return localVariableAnnotationNode;
    }

    public void visitLineNumber(int n, Label label) {
        this.instructions.add(new LineNumberNode(n, this.getLabelNode(label)));
    }

    public void visitMaxs(int n, int n2) {
        this.maxStack = n;
        this.maxLocals = n2;
    }

    public void visitEnd() {
    }

    protected LabelNode getLabelNode(Label label) {
        if (!(label.info instanceof LabelNode)) {
            label.info = new LabelNode();
        }
        return (LabelNode)label.info;
    }

    private LabelNode[] getLabelNodes(Label[] labelArray) {
        LabelNode[] labelNodeArray = new LabelNode[labelArray.length];
        for (int i = 0x4CD8635B ^ 0x4CD8635B; i < labelArray.length; ++i) {
            labelNodeArray[i] = this.getLabelNode(labelArray[i]);
        }
        return labelNodeArray;
    }

    private Object[] getLabelNodes(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0xF38A1795 ^ 0xF38A1795; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof Label) {
                object = this.getLabelNode((Label)object);
            }
            objectArray2[i] = object;
        }
        return objectArray2;
    }

    public void check(int n) {
        if (n == (0x411AC044 ^ 0x411EC044)) {
            Object object;
            int n2;
            if (this.visibleTypeAnnotations != null && this.visibleTypeAnnotations.size() > 0) {
                throw new RuntimeException();
            }
            if (this.invisibleTypeAnnotations != null && this.invisibleTypeAnnotations.size() > 0) {
                throw new RuntimeException();
            }
            int n3 = this.tryCatchBlocks == null ? 0xEBB7157 ^ 0xEBB7157 : this.tryCatchBlocks.size();
            for (n2 = 0x9CDD761B ^ 0x9CDD761B; n2 < n3; ++n2) {
                object = this.tryCatchBlocks.get(n2);
                if (((TryCatchBlockNode)object).visibleTypeAnnotations != null && ((TryCatchBlockNode)object).visibleTypeAnnotations.size() > 0) {
                    throw new RuntimeException();
                }
                if (((TryCatchBlockNode)object).invisibleTypeAnnotations == null || ((TryCatchBlockNode)object).invisibleTypeAnnotations.size() <= 0) continue;
                throw new RuntimeException();
            }
            for (n2 = 0xAF863C39 ^ 0xAF863C39; n2 < this.instructions.size(); ++n2) {
                object = this.instructions.get(n2);
                if (((AbstractInsnNode)object).visibleTypeAnnotations != null && ((AbstractInsnNode)object).visibleTypeAnnotations.size() > 0) {
                    throw new RuntimeException();
                }
                if (((AbstractInsnNode)object).invisibleTypeAnnotations != null && ((AbstractInsnNode)object).invisibleTypeAnnotations.size() > 0) {
                    throw new RuntimeException();
                }
                if (!(object instanceof MethodInsnNode)) continue;
                int n4 = ((MethodInsnNode)object).itf;
                if (n4 == (((AbstractInsnNode)object).opcode == (0x5A3EF023 ^ 0x5A3EF09A) ? 0x32F2A0A8 ^ 0x32F2A0A9 : 0x62273CFD ^ 0x62273CFD)) continue;
                throw new RuntimeException();
            }
            if (this.visibleLocalVariableAnnotations != null && this.visibleLocalVariableAnnotations.size() > 0) {
                throw new RuntimeException();
            }
            if (this.invisibleLocalVariableAnnotations != null && this.invisibleLocalVariableAnnotations.size() > 0) {
                throw new RuntimeException();
            }
        }
    }

    public void accept(ClassVisitor classVisitor) {
        String[] stringArray = new String[this.exceptions.size()];
        this.exceptions.toArray(stringArray);
        MethodVisitor methodVisitor = classVisitor.visitMethod(this.access, this.name, this.desc, this.signature, stringArray);
        if (methodVisitor != null) {
            this.accept(methodVisitor);
        }
    }

    public void accept(MethodVisitor methodVisitor) {
        AnnotationNode annotationNode;
        int n;
        List<AnnotationNode> list;
        int n2;
        int n3 = this.parameters == null ? 0xB1F32836 ^ 0xB1F32836 : this.parameters.size();
        for (n2 = 0x1D42B885 ^ 0x1D42B885; n2 < n3; ++n2) {
            list = this.parameters.get(n2);
            methodVisitor.visitParameter(((ParameterNode)((Object)list)).name, ((ParameterNode)((Object)list)).access);
        }
        if (this.annotationDefault != null) {
            list = methodVisitor.visitAnnotationDefault();
            AnnotationNode.accept((AnnotationVisitor)((Object)list), null, this.annotationDefault);
            if (list != null) {
                ((AnnotationVisitor)((Object)list)).visitEnd();
            }
        }
        n3 = this.visibleAnnotations == null ? 0x5F3B463B ^ 0x5F3B463B : this.visibleAnnotations.size();
        for (n2 = 0x4B7E1C99 ^ 0x4B7E1C99; n2 < n3; ++n2) {
            list = this.visibleAnnotations.get(n2);
            ((AnnotationNode)((Object)list)).accept(methodVisitor.visitAnnotation(((AnnotationNode)((Object)list)).desc, (0xBC59B917 ^ 0xBC59B916) != 0));
        }
        n3 = this.invisibleAnnotations == null ? 0xD3BE8585 ^ 0xD3BE8585 : this.invisibleAnnotations.size();
        for (n2 = 0x801AA87C ^ 0x801AA87C; n2 < n3; ++n2) {
            list = this.invisibleAnnotations.get(n2);
            ((AnnotationNode)((Object)list)).accept(methodVisitor.visitAnnotation(((AnnotationNode)((Object)list)).desc, (0x419730E9 ^ 0x419730E9) != 0));
        }
        n3 = this.visibleTypeAnnotations == null ? 0xA53D3234 ^ 0xA53D3234 : this.visibleTypeAnnotations.size();
        for (n2 = 0x472348D0 ^ 0x472348D0; n2 < n3; ++n2) {
            list = this.visibleTypeAnnotations.get(n2);
            ((AnnotationNode)((Object)list)).accept(methodVisitor.visitTypeAnnotation(((TypeAnnotationNode)((Object)list)).typeRef, ((TypeAnnotationNode)((Object)list)).typePath, ((TypeAnnotationNode)((Object)list)).desc, (0x544A6314 ^ 0x544A6315) != 0));
        }
        n3 = this.invisibleTypeAnnotations == null ? 0x465B5B9 ^ 0x465B5B9 : this.invisibleTypeAnnotations.size();
        for (n2 = 0x69FB84A3 ^ 0x69FB84A3; n2 < n3; ++n2) {
            list = this.invisibleTypeAnnotations.get(n2);
            ((AnnotationNode)((Object)list)).accept(methodVisitor.visitTypeAnnotation(((TypeAnnotationNode)((Object)list)).typeRef, ((TypeAnnotationNode)((Object)list)).typePath, ((TypeAnnotationNode)((Object)list)).desc, (0xD5855E63 ^ 0xD5855E63) != 0));
        }
        n3 = this.visibleParameterAnnotations == null ? 0x57EA7A10 ^ 0x57EA7A10 : this.visibleParameterAnnotations.length;
        for (n2 = 0xA63695D9 ^ 0xA63695D9; n2 < n3; ++n2) {
            list = this.visibleParameterAnnotations[n2];
            if (list == null) continue;
            for (n = 0xA3DB511E ^ 0xA3DB511E; n < list.size(); ++n) {
                annotationNode = list.get(n);
                annotationNode.accept(methodVisitor.visitParameterAnnotation(n2, annotationNode.desc, (0x404A704C ^ 0x404A704D) != 0));
            }
        }
        n3 = this.invisibleParameterAnnotations == null ? 0x39E3B175 ^ 0x39E3B175 : this.invisibleParameterAnnotations.length;
        for (n2 = 0xF8310DFC ^ 0xF8310DFC; n2 < n3; ++n2) {
            list = this.invisibleParameterAnnotations[n2];
            if (list == null) continue;
            for (n = 0xECAB3780 ^ 0xECAB3780; n < list.size(); ++n) {
                annotationNode = list.get(n);
                annotationNode.accept(methodVisitor.visitParameterAnnotation(n2, annotationNode.desc, (0x7A4878E2 ^ 0x7A4878E2) != 0));
            }
        }
        if (this.visited) {
            this.instructions.resetLabels();
        }
        n3 = this.attrs == null ? 0x61792C53 ^ 0x61792C53 : this.attrs.size();
        for (n2 = 0x7DCCE611 ^ 0x7DCCE611; n2 < n3; ++n2) {
            methodVisitor.visitAttribute(this.attrs.get(n2));
        }
        if (this.instructions.size() > 0) {
            methodVisitor.visitCode();
            n3 = this.tryCatchBlocks == null ? 0xB5F81106 ^ 0xB5F81106 : this.tryCatchBlocks.size();
            for (n2 = 0x8B6A002D ^ 0x8B6A002D; n2 < n3; ++n2) {
                this.tryCatchBlocks.get(n2).updateIndex(n2);
                this.tryCatchBlocks.get(n2).accept(methodVisitor);
            }
            this.instructions.accept(methodVisitor);
            n3 = this.localVariables == null ? 0x2643551B ^ 0x2643551B : this.localVariables.size();
            for (n2 = 0x7DC8B7FF ^ 0x7DC8B7FF; n2 < n3; ++n2) {
                this.localVariables.get(n2).accept(methodVisitor);
            }
            n3 = this.visibleLocalVariableAnnotations == null ? 0x8596703B ^ 0x8596703B : this.visibleLocalVariableAnnotations.size();
            for (n2 = 0xD8A994E6 ^ 0xD8A994E6; n2 < n3; ++n2) {
                this.visibleLocalVariableAnnotations.get(n2).accept(methodVisitor, (0x6563DC9A ^ 0x6563DC9B) != 0);
            }
            n3 = this.invisibleLocalVariableAnnotations == null ? 0xC2089792 ^ 0xC2089792 : this.invisibleLocalVariableAnnotations.size();
            for (n2 = 0x43879126 ^ 0x43879126; n2 < n3; ++n2) {
                this.invisibleLocalVariableAnnotations.get(n2).accept(methodVisitor, (0x379DB970 ^ 0x379DB970) != 0);
            }
            methodVisitor.visitMaxs(this.maxStack, this.maxLocals);
            this.visited = 0x51DF1065 ^ 0x51DF1064;
        }
        methodVisitor.visitEnd();
    }
}

