/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree.analysis;

import java.util.List;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.analysis.AnalyzerException;
import org.spongepowered.asm.lib.tree.analysis.BasicValue;
import org.spongepowered.asm.lib.tree.analysis.BasicVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleVerifier
extends BasicVerifier {
    private final Type currentClass;
    private final Type currentSuperClass;
    private final List<Type> currentClassInterfaces;
    private final boolean isInterface;
    private ClassLoader loader = this.getClass().getClassLoader();

    public SimpleVerifier() {
        this(null, null, (0x9F6C2BA2 ^ 0x9F6C2BA2) != 0);
    }

    public SimpleVerifier(Type type, Type type2, boolean bl) {
        this(type, type2, null, bl);
    }

    public SimpleVerifier(Type type, Type type2, List<Type> list, boolean bl) {
        this(0x104546D0 ^ 0x104046D0, type, type2, list, bl);
    }

    protected SimpleVerifier(int n, Type type, Type type2, List<Type> list, boolean bl) {
        super(n);
        this.currentClass = type;
        this.currentSuperClass = type2;
        this.currentClassInterfaces = list;
        this.isInterface = bl;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    @Override
    public BasicValue newValue(Type type) {
        BasicValue basicValue;
        int n;
        if (type == null) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        int n2 = type.getSort() == (0xBA9EBB14 ^ 0xBA9EBB1D) ? 0xD03B9A9E ^ 0xD03B9A9F : (n = 0xFFB3FF88 ^ 0xFFB3FF88);
        if (n != 0) {
            switch (type.getElementType().getSort()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return new BasicValue(type);
                }
            }
        }
        if (BasicValue.REFERENCE_VALUE.equals(basicValue = super.newValue(type))) {
            if (n != 0) {
                basicValue = this.newValue(type.getElementType());
                String string = basicValue.getType().getDescriptor();
                for (int i = 0x3CF72E48 ^ 0x3CF72E48; i < type.getDimensions(); ++i) {
                    string = (char)(0x9446BB8D ^ 0x9446BBD6) + string;
                }
                basicValue = new BasicValue(Type.getType(string));
            } else {
                basicValue = new BasicValue(type);
            }
        }
        return basicValue;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean isArrayValue(BasicValue basicValue) {
        int n;
        block2: {
            block3: {
                Type type = basicValue.getType();
                if (type == null) break block2;
                if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^\ua7e8\ua4a0\ua07d\ua909\u7d2d").equals(type.getDescriptor())) break block3;
                if (type.getSort() != (0x6961C83C ^ 0x6961C835)) break block2;
            }
            n = 0x5245F034 ^ 0x5245F035;
            return n != 0;
        }
        n = 0x6F496F24 ^ 0x6F496F24;
        return n != 0;
    }

    @Override
    protected BasicValue getElementValue(BasicValue basicValue) throws AnalyzerException {
        Type type = basicValue.getType();
        if (type != null) {
            if (type.getSort() == (0xA9058A7D ^ 0xA9058A74)) {
                return this.newValue(Type.getType(type.getDescriptor().substring(0x7C798E3B ^ 0x7C798E3A)));
            }
            if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^\ua7e8\ua4a0\ua07d\ua909\u7d2d").equals(type.getDescriptor())) {
                return basicValue;
            }
        }
        throw new Error(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a1\ua074\ua917\u7d78\u8e4b\u2476\u8b77\u3472`\ua7f4\ua4ba\ua063"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isSubTypeOf(BasicValue basicValue, BasicValue basicValue2) {
        Type type = basicValue2.getType();
        Type type2 = basicValue.getType();
        switch (type.getSort()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return type2.equals(type);
            }
            case 9: 
            case 10: {
                if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^\ua7e8\ua4a0\ua07d\ua909\u7d2d").equals(type2.getDescriptor())) {
                    return (0xAE047F14 ^ 0xAE047F15) != 0;
                }
                if (type2.getSort() == (0xB2FBC3E3 ^ 0xB2FBC3E9)) return this.isAssignableFrom(type, type2);
                if (type2.getSort() != (0xDABC8E4D ^ 0xDABC8E44)) return (0x58AD9233 ^ 0x58AD9233) != 0;
                return this.isAssignableFrom(type, type2);
            }
        }
        throw new Error(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a1\ua074\ua917\u7d78\u8e4b\u2476\u8b77\u3472`\ua7f4\ua4ba\ua063"));
    }

    @Override
    public BasicValue merge(BasicValue basicValue, BasicValue basicValue2) {
        block8: {
            block9: {
                Type type;
                Type type2;
                block11: {
                    block10: {
                        if (basicValue.equals(basicValue2)) break block8;
                        type2 = basicValue.getType();
                        type = basicValue2.getType();
                        if (type2 == null) break block9;
                        if (type2.getSort() == (0x5B03D8A7 ^ 0x5B03D8AD)) break block10;
                        if (type2.getSort() != (0xE675CFE5 ^ 0xE675CFEC)) break block9;
                    }
                    if (type == null) break block9;
                    if (type.getSort() == (0xB3C8E9C3 ^ 0xB3C8E9C9)) break block11;
                    if (type.getSort() != (0xAB3DAD43 ^ 0xAB3DAD4A)) break block9;
                }
                if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^\ua7e8\ua4a0\ua07d\ua909\u7d2d").equals(type2.getDescriptor())) {
                    return basicValue2;
                }
                if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^\ua7e8\ua4a0\ua07d\ua909\u7d2d").equals(type.getDescriptor())) {
                    return basicValue;
                }
                if (this.isAssignableFrom(type2, type)) {
                    return basicValue;
                }
                if (this.isAssignableFrom(type, type2)) {
                    return basicValue2;
                }
                do {
                    if (type2 != null && !this.isInterface(type2)) continue;
                    return BasicValue.REFERENCE_VALUE;
                } while (!this.isAssignableFrom(type2 = this.getSuperClass(type2), type));
                return this.newValue(type2);
            }
            return BasicValue.UNINITIALIZED_VALUE;
        }
        return basicValue;
    }

    protected boolean isInterface(Type type) {
        if (this.currentClass != null && type.equals(this.currentClass)) {
            return this.isInterface;
        }
        return this.getClass(type).isInterface();
    }

    protected Type getSuperClass(Type type) {
        if (this.currentClass != null && type.equals(this.currentClass)) {
            return this.currentSuperClass;
        }
        Class<?> clazz = this.getClass(type).getSuperclass();
        return clazz == null ? null : Type.getType(clazz);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected boolean isAssignableFrom(Type type, Type type2) {
        void var3_4;
        if (type.equals(type2)) {
            return (0xB71B34F7 ^ 0xB71B34F6) != 0;
        }
        if (this.currentClass != null && type.equals(this.currentClass)) {
            int n;
            if (this.getSuperClass(type2) == null) {
                return (0xCD56E9F9 ^ 0xCD56E9F9) != 0;
            }
            if (!this.isInterface) return this.isAssignableFrom(type, this.getSuperClass(type2));
            if (type2.getSort() != (0x4E9B9EEF ^ 0x4E9B9EE5)) {
                if (type2.getSort() != (0x1A1647C ^ 0x1A16475)) {
                    n = 0xC3FC77E8 ^ 0xC3FC77E8;
                    return n != 0;
                }
            }
            n = 0xE75C8120 ^ 0xE75C8121;
            return n != 0;
        }
        if (this.currentClass != null && type2.equals(this.currentClass)) {
            if (this.isAssignableFrom(type, this.currentSuperClass)) {
                return (0x3816E3D4 ^ 0x3816E3D5) != 0;
            }
        } else {
            void var3_7;
            Class<?> clazz = this.getClass(type);
            if (!clazz.isInterface()) return var3_7.isAssignableFrom(this.getClass(type2));
            return var3_7.isAssignableFrom(this.getClass(type2));
        }
        if (this.currentClassInterfaces == null) return (0xBA197B9 ^ 0xBA197B9) != 0;
        int n = 0xCAC80979 ^ 0xCAC80979;
        while (var3_4 < this.currentClassInterfaces.size()) {
            Type type3 = this.currentClassInterfaces.get((int)var3_4);
            if (this.isAssignableFrom(type, type3)) {
                return (0xB0D0C8D ^ 0xB0D0C8C) != 0;
            }
            ++var3_4;
        }
        return (0xBA197B9 ^ 0xBA197B9) != 0;
    }

    protected Class<?> getClass(Type type) {
        try {
            if (type.getSort() == (0x5BC922A8 ^ 0x5BC922A1)) {
                return Class.forName(type.getDescriptor().replace((char)(0xED6BFA5C ^ 0xED6BFA73), (char)(0x8D977293 ^ 0x8D9772BD)), (0x93E52B78 ^ 0x93E52B78) != 0, this.loader);
            }
            return Class.forName(type.getClassName(), (0x1B10803D ^ 0x1B10803D) != 0, this.loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException.toString());
        }
    }
}

