/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.util;

import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.spongepowered.asm.lib.AnnotationVisitor;
import org.spongepowered.asm.lib.Attribute;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.FieldVisitor;
import org.spongepowered.asm.lib.Label;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.TypePath;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.analysis.Analyzer;
import org.spongepowered.asm.lib.tree.analysis.BasicValue;
import org.spongepowered.asm.lib.tree.analysis.Frame;
import org.spongepowered.asm.lib.tree.analysis.SimpleVerifier;
import org.spongepowered.asm.lib.util.CheckAnnotationAdapter;
import org.spongepowered.asm.lib.util.CheckFieldAdapter;
import org.spongepowered.asm.lib.util.CheckMethodAdapter;
import org.spongepowered.asm.lib.util.Textifier;
import org.spongepowered.asm.lib.util.TraceMethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckClassAdapter
extends ClassVisitor {
    private int version;
    private boolean start;
    private boolean source;
    private boolean outer;
    private boolean end;
    private Map<Label, Integer> labels = new HashMap<Label, Integer>();
    private boolean checkDataFlow;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != (0x75CF0F38 ^ 0x75CF0F39)) {
            System.err.println(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("D\ua7e3\ua4a7\ua078\ua903\u7d7f\u8e4f\u2469\u8b77\u3463z\ua7e3\ua4f5\ua076\ua90c\u7d60\u8e4f\u2474\u8b77\u3474~\ua7e7\ua4a6\ua062\ua94b"));
            System.err.println(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("G\ua7f5\ua4b4\ua076\ua900\u7d2c\u8e0a\u2459\u8b3f\u3472q\ua7ed\ua496\ua07d\ua904\u7d65\u8e59\u245b\u8b33\u3476b\ua7f2\ua4b0\ua063\ua945\u7d2a\u8e4c\u246f\u8b3b\u347bk\ua7a6\ua4a4\ua064\ua904\u7d7a\u8e43\u247c\u8b3e\u3472v\ua7a6\ua4b6\ua07d\ua904\u7d65\u8e59\u243a\u8b39\u3476\u007f\ua7e3\ua4f5\ua07e\ua917\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4b3\ua078\ua909\u7d73\u8e0a\u2474\u8b36\u347aw\ua7b8"));
            return;
        }
        ClassReader classReader = stringArray[0x38F152DC ^ 0x38F152DC].endsWith(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("<\ua7e5\ua4b9\ua070\ua916\u7d65")) ? new ClassReader(new FileInputStream(stringArray[0x6AD43616 ^ 0x6AD43616])) : new ClassReader(stringArray[0xE1026F4E ^ 0xE1026F4E]);
        CheckClassAdapter.verify(classReader, (0x5095FFB9 ^ 0x5095FFB9) != 0, new PrintWriter(System.err));
    }

    public static void verify(ClassReader classReader, ClassLoader classLoader, boolean bl, PrintWriter printWriter) {
        ClassNode classNode = new ClassNode();
        classReader.accept(new CheckClassAdapter(classNode, (0xF886F0DA ^ 0xF886F0DA) != 0), 0xB5CF12FB ^ 0xB5CF12F9);
        Type type = classNode.superName == null ? null : Type.getObjectType(classNode.superName);
        List<MethodNode> list = classNode.methods;
        ArrayList<Type> arrayList = new ArrayList<Type>();
        Iterator<String> iterator = classNode.interfaces.iterator();
        while (iterator.hasNext()) {
            arrayList.add(Type.getObjectType(iterator.next()));
        }
        for (int i = 0x2A653868 ^ 0x2A653868; i < list.size(); ++i) {
            MethodNode methodNode = list.get(i);
            SimpleVerifier simpleVerifier = new SimpleVerifier(Type.getObjectType(classNode.name), type, arrayList, ((classNode.access & (0x107D7ED7 ^ 0x107D7CD7)) != 0 ? 0x7F4E0276 ^ 0x7F4E0277 : 0xC4156E87 ^ 0xC4156E87) != 0);
            Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(simpleVerifier);
            if (classLoader != null) {
                simpleVerifier.setClassLoader(classLoader);
            }
            try {
                analyzer.analyze(classNode.name, methodNode);
                if (!bl) {
                    continue;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(printWriter);
            }
            CheckClassAdapter.printAnalyzerResult(methodNode, analyzer, printWriter);
        }
        printWriter.flush();
    }

    public static void verify(ClassReader classReader, boolean bl, PrintWriter printWriter) {
        CheckClassAdapter.verify(classReader, null, bl, printWriter);
    }

    static void printAnalyzerResult(MethodNode methodNode, Analyzer<BasicValue> analyzer, PrintWriter printWriter) {
        int n;
        Frame<BasicValue>[] frameArray = analyzer.getFrames();
        Textifier textifier = new Textifier();
        TraceMethodVisitor traceMethodVisitor = new TraceMethodVisitor(textifier);
        printWriter.println(methodNode.name + methodNode.desc);
        for (n = 0x1A17D7E6 ^ 0x1A17D7E6; n < methodNode.instructions.size(); ++n) {
            methodNode.instructions.get(n).accept(traceMethodVisitor);
            StringBuilder stringBuilder = new StringBuilder();
            Frame<BasicValue> frame = frameArray[n];
            if (frame == null) {
                stringBuilder.append((char)(0x8D3B55C6 ^ 0x8D3B55F9));
            } else {
                int n2;
                for (n2 = 0x54867BA9 ^ 0x54867BA9; n2 < frame.getLocals(); ++n2) {
                    stringBuilder.append(CheckClassAdapter.getShortName(frame.getLocal(n2).toString())).append((char)(0x5660D2BD ^ 0x5660D29D));
                }
                stringBuilder.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7bc\ua4f5"));
                for (n2 = 0x7C655E3E ^ 0x7C655E3E; n2 < frame.getStackSize(); ++n2) {
                    stringBuilder.append(CheckClassAdapter.getShortName(frame.getStack(n2).toString())).append((char)(0x5A031813 ^ 0x5A031833));
                }
            }
            while (true) {
                if (stringBuilder.length() >= methodNode.maxStack + methodNode.maxLocals + (0xB3E36E66 ^ 0xB3E36E67)) break;
                stringBuilder.append((char)(0xF94D28FB ^ 0xF94D28DB));
            }
            printWriter.print(Integer.toString(n + (0xCC7FD5F6 ^ 0xCC7E5356)).substring(0x97954D61 ^ 0x97954D60));
            printWriter.print(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2") + stringBuilder + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7bc\ua4f5") + textifier.text.get(textifier.text.size() - (0x92FE065E ^ 0x92FE065F)));
        }
        for (n = 0x65C9E367 ^ 0x65C9E367; n < methodNode.tryCatchBlocks.size(); ++n) {
            methodNode.tryCatchBlocks.get(n).accept(traceMethodVisitor);
            printWriter.print(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2") + textifier.text.get(textifier.text.size() - (0xEE164FBC ^ 0xEE164FBD)));
        }
        printWriter.println();
    }

    private static String getShortName(String string) {
        int n = string.lastIndexOf(0x28317A9 ^ 0x2831786);
        int n2 = string.length();
        if (string.charAt(n2 - (0x4782BB4B ^ 0x4782BB4A)) == (0x18F8E477 ^ 0x18F8E44C)) {
            --n2;
        }
        return n == (0xEBFAB36F ^ 0x14054C90) ? string : string.substring(n + (0xEBF11E37 ^ 0xEBF11E36), n2);
    }

    public CheckClassAdapter(ClassVisitor classVisitor) {
        this(classVisitor, (0x18C05EF6 ^ 0x18C05EF7) != 0);
    }

    public CheckClassAdapter(ClassVisitor classVisitor, boolean bl) {
        this(0x7469F9CA ^ 0x746CF9CA, classVisitor, bl);
        if (this.getClass() != CheckClassAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckClassAdapter(int n, ClassVisitor classVisitor, boolean bl) {
        super(n, classVisitor);
        this.checkDataFlow = bl;
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        if (this.start) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("d\ua7ef\ua4a6\ua078\ua911\u7d36\u8e47\u246f\u8b24\u34632\ua7e4\ua4b0\ua031\ua906\u7d77\u8e46\u2476\u8b32\u34732\ua7e9\ua4bb\ua07d\ua91c\u7d36\u8e45\u2474\u8b34\u3472"));
        }
        this.start = 0x763FE420 ^ 0x763FE421;
        this.checkState();
        CheckClassAdapter.checkAccess(n2, 0xBAB0D886 ^ 0xBAB6AEB7);
        if (string == null || !string.endsWith(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("b\ua7e7\ua4b6\ua07a\ua904\u7d71\u8e4f\u2437\u8b3e\u3479t\ua7e9"))) {
            CheckMethodAdapter.checkInternalName(string, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("q\ua7ea\ua4b4\ua062\ua916\u7d36\u8e44\u247b\u8b3a\u3472"));
        }
        if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62").equals(string)) {
            if (string3 != null) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F\ua7ee\ua4b0\ua031\ua916\u7d63\u8e5a\u247f\u8b25\u3437q\ua7ea\ua4b4\ua062\ua916\u7d36\u8e44\u247b\u8b3a\u34722\ua7e9\ua4b3\ua031\ua911\u7d7e\u8e4f\u243a\u8b18\u3475x\ua7e3\ua4b6\ua065\ua945\u7d75\u8e46\u247b\u8b24\u34642\ua7eb\ua4a0\ua062\ua911\u7d36\u8e48\u247f\u8b77\u3430|\ua7f3\ua4b9\ua07d\ua942"));
            }
        } else {
            CheckMethodAdapter.checkInternalName(string3, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a\ua7f3\ua4a5\ua074\ua917\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4bb\ua070\ua908\u7d73"));
        }
        if (string2 != null) {
            CheckClassAdapter.checkClassSignature(string2);
        }
        if ((n2 & (0x4814C74C ^ 0x4814C54C)) != 0 && !\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62").equals(string3)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F\ua7ee\ua4b0\ua031\ua916\u7d63\u8e5a\u247f\u8b25\u3437q\ua7ea\ua4b4\ua062\ua916\u7d36\u8e44\u247b\u8b3a\u34722\ua7e9\ua4b3\ua031\ua90c\u7d78\u8e5e\u247f\u8b25\u3471s\ua7e5\ua4b0\ua062\ua945\u7d7b\u8e5f\u2469\u8b23\u3437p\ua7e3\ua4f5\ua036\ua90f\u7d77\u8e5c\u247b\u8b78\u347bs\ua7e8\ua4b2\ua03e\ua92a\u7d74\u8e40\u247f\u8b34\u34635"));
        }
        if (stringArray != null) {
            for (int i = 0x20AB7822 ^ 0x20AB7822; i < stringArray.length; ++i) {
                CheckMethodAdapter.checkInternalName(stringArray[i], \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("{\ua7e8\ua4a1\ua074\ua917\u7d70\u8e4b\u2479\u8b32\u3437|\ua7e7\ua4b8\ua074\ua945\u7d77\u8e5e\u243a\u8b3e\u3479v\ua7e3\ua4ad\ua031") + i);
            }
        }
        this.version = n;
        super.visit(n, n2, string, string2, string3, stringArray);
    }

    @Override
    public void visitSource(String string, String string2) {
        this.checkState();
        if (this.source) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("d\ua7ef\ua4a6\ua078\ua911\u7d45\u8e45\u246f\u8b25\u3474w\ua7a6\ua4b6\ua070\ua90b\u7d36\u8e48\u247f\u8b77\u3474s\ua7ea\ua4b9\ua074\ua901\u7d36\u8e45\u2474\u8b3b\u346e2\ua7e9\ua4bb\ua072\ua900\u7d38"));
        }
        this.source = 0xCB9CE93 ^ 0xCB9CE92;
        super.visitSource(string, string2);
    }

    @Override
    public void visitOuterClass(String string, String string2, String string3) {
        this.checkState();
        if (this.outer) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("d\ua7ef\ua4a6\ua078\ua911\u7d59\u8e5f\u246e\u8b32\u3465Q\ua7ea\ua4b4\ua062\ua916\u7d36\u8e49\u247b\u8b39\u3437p\ua7e3\ua4f5\ua072\ua904\u7d7a\u8e46\u247f\u8b33\u3437}\ua7e8\ua4b9\ua068\ua945\u7d79\u8e44\u2479\u8b32\u3439"));
        }
        this.outer = 0xB395412D ^ 0xB395412C;
        if (string == null) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b38\u3462f\ua7e3\ua4a7\ua031\ua906\u7d7a\u8e4b\u2469\u8b24\u3437}\ua7f1\ua4bb\ua074\ua917"));
        }
        if (string3 != null) {
            CheckMethodAdapter.checkMethodDesc(string3);
        }
        super.visitOuterClass(string, string2, string3);
    }

    @Override
    public void visitInnerClass(String string, String string2, String string3, int n) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(string, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("q\ua7ea\ua4b4\ua062\ua916\u7d36\u8e44\u247b\u8b3a\u3472"));
        if (string2 != null) {
            CheckMethodAdapter.checkInternalName(string2, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("}\ua7f3\ua4a1\ua074\ua917\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4bb\ua070\ua908\u7d73"));
        }
        if (string3 != null) {
            int n2;
            for (n2 = 0x147C7411 ^ 0x147C7411; n2 < string3.length() && Character.isDigit(string3.charAt(n2)); ++n2) {
            }
            if (n2 == 0 || n2 < string3.length()) {
                CheckMethodAdapter.checkIdentifier(string3, n2, 0xEF6225E8 ^ 0x109DDA17, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("{\ua7e8\ua4bb\ua074\ua917\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4bb\ua070\ua908\u7d73"));
            }
        }
        CheckClassAdapter.checkAccess(n, 0x295194DA ^ 0x2951E2C5);
        super.visitInnerClass(string, string2, string3, n);
    }

    @Override
    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        this.checkState();
        CheckClassAdapter.checkAccess(n, 0x68AB17F9 ^ 0x68AD4726);
        CheckMethodAdapter.checkUnqualifiedName(this.version, string, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("t\ua7ef\ua4b0\ua07d\ua901\u7d36\u8e44\u247b\u8b3a\u3472"));
        CheckMethodAdapter.checkDesc(string2, (0x2FCCA48F ^ 0x2FCCA48F) != 0);
        if (string3 != null) {
            CheckClassAdapter.checkFieldSignature(string3);
        }
        if (object != null) {
            CheckMethodAdapter.checkConstant(object);
        }
        FieldVisitor fieldVisitor = super.visitField(n, string, string2, string3, object);
        return new CheckFieldAdapter(fieldVisitor);
    }

    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        this.checkState();
        CheckClassAdapter.checkAccess(n, 0xAF81F693 ^ 0xAF87EB6C);
        if (!\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(string) && !\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(".\ua7e5\ua4b9\ua078\ua90b\u7d7f\u8e5e\u2424").equals(string)) {
            CheckMethodAdapter.checkMethodIdentifier(this.version, string, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2474\u8b36\u347aw"));
        }
        CheckMethodAdapter.checkMethodDesc(string2);
        if (string3 != null) {
            CheckClassAdapter.checkMethodSignature(string3);
        }
        if (stringArray != null) {
            for (int i = 0x8516F82F ^ 0x8516F82F; i < stringArray.length; ++i) {
                CheckMethodAdapter.checkInternalName(stringArray[i], \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("w\ua7fe\ua4b6\ua074\ua915\u7d62\u8e43\u2475\u8b39\u3437|\ua7e7\ua4b8\ua074\ua945\u7d77\u8e5e\u243a\u8b3e\u3479v\ua7e3\ua4ad\ua031") + i);
            }
        }
        CheckMethodAdapter checkMethodAdapter = this.checkDataFlow ? new CheckMethodAdapter(n, string, string2, super.visitMethod(n, string, string2, string3, stringArray), this.labels) : new CheckMethodAdapter(super.visitMethod(n, string, string2, string3, stringArray), this.labels);
        checkMethodAdapter.version = this.version;
        return checkMethodAdapter;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        this.checkState();
        CheckMethodAdapter.checkDesc(string, (0x3B71AB63 ^ 0x3B71AB63) != 0);
        return new CheckAnnotationAdapter(super.visitAnnotation(string, bl));
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        this.checkState();
        int n2 = n >>> (0xA3D3FBAD ^ 0xA3D3FBB5);
        if (n2 != 0) {
            if (n2 != (0x1E25DA73 ^ 0x1E25DA62)) {
                if (n2 != (0x86E29854 ^ 0x86E29844)) {
                    throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u346eb\ua7e3\ua4f5\ua063\ua900\u7d70\u8e4f\u2468\u8b32\u3479q\ua7e3\ua4f5\ua062\ua90a\u7d64\u8e5e\u243a\u8b67\u346f") + Integer.toHexString(n2));
                }
            }
        }
        CheckClassAdapter.checkTypeRefAndPath(n, typePath);
        CheckMethodAdapter.checkDesc(string, (0x337756C9 ^ 0x337756C9) != 0);
        return new CheckAnnotationAdapter(super.visitTypeAnnotation(n, typePath, string, bl));
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.checkState();
        if (attribute == null) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b36\u3463f\ua7f4\ua4bc\ua073\ua910\u7d62\u8e4f\u243a\u8b7f\u347ag\ua7f5\ua4a1\ua031\ua90b\u7d79\u8e5e\u243a\u8b35\u34722\ua7e8\ua4a0\ua07d\ua909\u7d3f"));
        }
        super.visitAttribute(attribute);
    }

    @Override
    public void visitEnd() {
        this.checkState();
        this.end = 0x45EFD5A3 ^ 0x45EFD5A2;
        super.visitEnd();
    }

    private void checkState() {
        if (!this.start) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u246c\u8b3e\u3464{\ua7f2\ua4f5\ua07c\ua900\u7d7b\u8e48\u247f\u8b25\u3437p\ua7e3\ua4b3\ua07e\ua917\u7d73\u8e0a\u246c\u8b3e\u3464{\ua7f2\ua4f5\ua079\ua904\u7d65\u8e0a\u2478\u8b32\u3472|\ua7a6\ua4b6\ua070\ua909\u7d7a\u8e4f\u247e\u8b79"));
        }
        if (this.end) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u246c\u8b3e\u3464{\ua7f2\ua4f5\ua07c\ua900\u7d7b\u8e48\u247f\u8b25\u3437s\ua7e0\ua4a1\ua074\ua917\u7d36\u8e5c\u2473\u8b24\u347ef\ua7c3\ua4bb\ua075\ua945\u7d7e\u8e4b\u2469\u8b77\u3475w\ua7e3\ua4bb\ua031\ua906\u7d77\u8e46\u2476\u8b32\u3473<"));
        }
    }

    static void checkAccess(int n, int n2) {
        if ((n & (n2 ^ (0xBB5EBEED ^ 0x44A14112))) != 0) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b36\u3474q\ua7e3\ua4a6\ua062\ua945\u7d70\u8e46\u247b\u8b30\u3464(\ua7a6") + n);
        }
        int n3 = (n & (0x10F2D01D ^ 0x10F2D01C)) == 0 ? 0x9FABA9BE ^ 0x9FABA9BE : 0x3813AFDC ^ 0x3813AFDD;
        int n4 = (n & (0x2DECDA43 ^ 0x2DECDA41)) == 0 ? 0x3353AD46 ^ 0x3353AD46 : 0x40BCF0E1 ^ 0x40BCF0E0;
        int n5 = (n & (0x9E9CAD35 ^ 0x9E9CAD31)) == 0 ? 0x7D93A8B4 ^ 0x7D93A8B4 : 0xE808FD6B ^ 0xE808FD6A;
        if (n3 + n4 + n5 > (0xF212C7B0 ^ 0xF212C7B1)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("b\ua7f3\ua4b7\ua07d\ua90c\u7d75\u8e0a\u246a\u8b25\u347ed\ua7e7\ua4a1\ua074\ua945\u7d77\u8e44\u247e\u8b77\u3467`\ua7e9\ua4a1\ua074\ua906\u7d62\u8e4f\u247e\u8b77\u3476`\ua7e3\ua4f5\ua07c\ua910\u7d62\u8e5f\u247b\u8b3b\u347bk\ua7a6\ua4b0\ua069\ua906\u7d7a\u8e5f\u2469\u8b3e\u3461w\ua7bc\ua4f5") + n);
        }
        int n6 = (n & (0xA19D8AB0 ^ 0xA19D8AA0)) == 0 ? 0xB94452D ^ 0xB94452D : 0x38E8C950 ^ 0x38E8C951;
        int n7 = (n & (0xE7E4848B ^ 0xE7E4808B)) == 0 ? 0xCF1614A9 ^ 0xCF1614A9 : 0x3907782F ^ 0x3907782E;
        if (n6 + n7 > (0x6F8F109A ^ 0x6F8F109B)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("t\ua7ef\ua4bb\ua070\ua909\u7d36\u8e4b\u2474\u8b33\u3437s\ua7e4\ua4a6\ua065\ua917\u7d77\u8e49\u246e\u8b77\u3476`\ua7e3\ua4f5\ua07c\ua910\u7d62\u8e5f\u247b\u8b3b\u347bk\ua7a6\ua4b0\ua069\ua906\u7d7a\u8e5f\u2469\u8b3e\u3461w\ua7bc\ua4f5") + n);
        }
    }

    public static void checkClassSignature(String string) {
        int n = 0x335CCD18 ^ 0x335CCD18;
        if (CheckClassAdapter.getChar(string, 0xDA56E41F ^ 0xDA56E41F) == (0x68D56F8A ^ 0x68D56FB6)) {
            n = CheckClassAdapter.checkFormalTypeParameters(string, n);
        }
        n = CheckClassAdapter.checkClassTypeSignature(string, n);
        while (true) {
            if (CheckClassAdapter.getChar(string, n) != (0x6FF36F27 ^ 0x6FF36F6B)) break;
            n = CheckClassAdapter.checkClassTypeSignature(string, n);
        }
        if (n != string.length()) {
            throw new IllegalArgumentException(string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("(\ua7a6\ua4b0\ua063\ua917\u7d79\u8e58\u243a\u8b36\u34632\ua7ef\ua4bb\ua075\ua900\u7d6e\u8e0a") + n);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void checkMethodSignature(String string) {
        int n = 0xFE4142F8 ^ 0xFE4142F8;
        if (CheckClassAdapter.getChar(string, 0x7838427F ^ 0x7838427F) == (0xFAB72691 ^ 0xFAB726AD)) {
            n = CheckClassAdapter.checkFormalTypeParameters(string, n);
        }
        n = CheckClassAdapter.checkChar((char)(0xECA6592 ^ 0xECA65BA), string, n);
        while (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("H\ua7c5\ua497\ua042\ua92c\u7d50\u8e60\u245e\u8b1b\u344cF").indexOf(CheckClassAdapter.getChar(string, n)) != (0x90382E7F ^ 0x6FC7D180)) {
            n = CheckClassAdapter.checkTypeSignature(string, n);
        }
        n = CheckClassAdapter.checkChar((char)(0xF8E94900 ^ 0xF8E94929), string, n);
        n = CheckClassAdapter.getChar(string, n) == (0x6C4D73FF ^ 0x6C4D73A9) ? ++n : CheckClassAdapter.checkTypeSignature(string, n);
        while (CheckClassAdapter.getChar(string, n) == (0xB1AE11AB ^ 0xB1AE11F5)) {
            if (CheckClassAdapter.getChar(string, ++n) == (0x6085CB4A ^ 0x6085CB06)) {
                n = CheckClassAdapter.checkClassTypeSignature(string, n);
                continue;
            }
            n = CheckClassAdapter.checkTypeVariableSignature(string, n);
        }
        if (n != string.length()) {
            throw new IllegalArgumentException(string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("(\ua7a6\ua4b0\ua063\ua917\u7d79\u8e58\u243a\u8b36\u34632\ua7ef\ua4bb\ua075\ua900\u7d6e\u8e0a") + n);
        }
    }

    public static void checkFieldSignature(String string) {
        int n = CheckClassAdapter.checkFieldTypeSignature(string, 0x964450A0 ^ 0x964450A0);
        if (n != string.length()) {
            throw new IllegalArgumentException(string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("(\ua7a6\ua4b0\ua063\ua917\u7d79\u8e58\u243a\u8b36\u34632\ua7ef\ua4bb\ua075\ua900\u7d6e\u8e0a") + n);
        }
    }

    static void checkTypeRefAndPath(int n, TypePath typePath) {
        int n2 = 0x5EEDD115 ^ 0x5EEDD115;
        switch (n >>> (0x5EB535B3 ^ 0x5EB535AB)) {
            case 0: 
            case 1: 
            case 22: {
                n2 = 0xC5022777 ^ 0x3AFD2777;
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                n2 = 0x70BD5CA7 ^ 0x8FBD5CA7;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 66: {
                n2 = 0xC6151EDF ^ 0x39EAE1DF;
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                n2 = 0xE06DDC51 ^ 0x1F6DDCAE;
                break;
            }
            default: {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u346eb\ua7e3\ua4f5\ua063\ua900\u7d70\u8e4f\u2468\u8b32\u3479q\ua7e3\ua4f5\ua062\ua90a\u7d64\u8e5e\u243a\u8b67\u346f") + Integer.toHexString(n >>> (0xE3585EBC ^ 0xE3585EA4)));
            }
        }
        if ((n & (n2 ^ (0xD8B3A6F2 ^ 0x274C590D))) != 0) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u346eb\ua7e3\ua4f5\ua063\ua900\u7d70\u8e4f\u2468\u8b32\u3479q\ua7e3\ua4f5\ua021\ua91d") + Integer.toHexString(n));
        }
        if (typePath != null) {
            for (int i = 0x732B58FF ^ 0x732B58FF; i < typePath.getLength(); ++i) {
                int n3 = typePath.getStep(i);
                if (n3 != 0) {
                    if (n3 != (0xD7B84034 ^ 0xD7B84035)) {
                        if (n3 != (0xF4245E53 ^ 0xF4245E50)) {
                            if (n3 != (0x37E25963 ^ 0x37E25961)) {
                                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u346eb\ua7e3\ua4f5\ua061\ua904\u7d62\u8e42\u243a\u8b24\u3463w\ua7f6\ua4f5") + i + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ef\ua4bb\ua031") + typePath);
                            }
                        }
                    }
                }
                if (n3 == (0x8958DD32 ^ 0x8958DD31) || typePath.getStepArgument(i) == 0) continue;
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u346eb\ua7e3\ua4f5\ua061\ua904\u7d62\u8e42\u243a\u8b24\u3463w\ua7f6\ua4f5\ua070\ua917\u7d71\u8e5f\u2477\u8b32\u3479f\ua7a6\ua4b3\ua07e\ua917\u7d36\u8e59\u246e\u8b32\u34672") + i + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ef\ua4bb\ua031") + typePath);
            }
        }
    }

    private static int checkFormalTypeParameters(String string, int n) {
        n = CheckClassAdapter.checkChar((char)(0x79DF3022 ^ 0x79DF301E), string, n);
        n = CheckClassAdapter.checkFormalTypeParameter(string, n);
        while (true) {
            if (CheckClassAdapter.getChar(string, n) == (0x68A68727 ^ 0x68A68719)) break;
            n = CheckClassAdapter.checkFormalTypeParameter(string, n);
        }
        return n + (0x8B4A06B2 ^ 0x8B4A06B3);
    }

    private static int checkFormalTypeParameter(String string, int n) {
        n = CheckClassAdapter.checkIdentifier(string, n);
        n = CheckClassAdapter.checkChar((char)(0xA38CCEE0 ^ 0xA38CCEDA), string, n);
        if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^\ua7dd\ua481").indexOf(CheckClassAdapter.getChar(string, n)) != (0x8D075316 ^ 0x72F8ACE9)) {
            n = CheckClassAdapter.checkFieldTypeSignature(string, n);
        }
        while (true) {
            if (CheckClassAdapter.getChar(string, n) != (0x7B004940 ^ 0x7B00497A)) break;
            n = CheckClassAdapter.checkFieldTypeSignature(string, n + (0xFB8B50D6 ^ 0xFB8B50D7));
        }
        return n;
    }

    private static int checkFieldTypeSignature(String string, int n) {
        switch (CheckClassAdapter.getChar(string, n)) {
            case 'L': {
                return CheckClassAdapter.checkClassTypeSignature(string, n);
            }
            case '[': {
                return CheckClassAdapter.checkTypeSignature(string, n + (0xD63A944D ^ 0xD63A944C));
            }
        }
        return CheckClassAdapter.checkTypeVariableSignature(string, n);
    }

    private static int checkClassTypeSignature(String string, int n) {
        n = CheckClassAdapter.checkChar((char)(0x84022363 ^ 0x8402232F), string, n);
        n = CheckClassAdapter.checkIdentifier(string, n);
        while (true) {
            if (CheckClassAdapter.getChar(string, n) != (0xB65DEACD ^ 0xB65DEAE2)) break;
            n = CheckClassAdapter.checkIdentifier(string, n + (0x1BCC3A57 ^ 0x1BCC3A56));
        }
        if (CheckClassAdapter.getChar(string, n) == (0xE9D396A3 ^ 0xE9D3969F)) {
            n = CheckClassAdapter.checkTypeArguments(string, n);
        }
        while (true) {
            if (CheckClassAdapter.getChar(string, n) != (0x6C51AC3 ^ 0x6C51AED)) break;
            n = CheckClassAdapter.checkIdentifier(string, n + (0x6B1E6781 ^ 0x6B1E6780));
            if (CheckClassAdapter.getChar(string, n) != (0x348F369F ^ 0x348F36A3)) continue;
            n = CheckClassAdapter.checkTypeArguments(string, n);
        }
        return CheckClassAdapter.checkChar((char)(0xAE55CA20 ^ 0xAE55CA1B), string, n);
    }

    private static int checkTypeArguments(String string, int n) {
        n = CheckClassAdapter.checkChar((char)(0x95481116 ^ 0x9548112A), string, n);
        n = CheckClassAdapter.checkTypeArgument(string, n);
        while (true) {
            if (CheckClassAdapter.getChar(string, n) == (0xAA26F70D ^ 0xAA26F733)) break;
            n = CheckClassAdapter.checkTypeArgument(string, n);
        }
        return n + (0xEFFC0F48 ^ 0xEFFC0F49);
    }

    private static int checkTypeArgument(String string, int n) {
        block5: {
            block4: {
                char c = CheckClassAdapter.getChar(string, n);
                if (c == (0xBE4FB3EA ^ 0xBE4FB3C0)) {
                    return n + (0xFF464121 ^ 0xFF464120);
                }
                if (c == (0x35EF3177 ^ 0x35EF315C)) break block4;
                if (c != (0x186EFCC4 ^ 0x186EFCE9)) break block5;
            }
            ++n;
        }
        return CheckClassAdapter.checkFieldTypeSignature(string, n);
    }

    private static int checkTypeVariableSignature(String string, int n) {
        n = CheckClassAdapter.checkChar((char)(0x3196FB16 ^ 0x3196FB42), string, n);
        n = CheckClassAdapter.checkIdentifier(string, n);
        return CheckClassAdapter.checkChar((char)(0x3F51B3E4 ^ 0x3F51B3DF), string, n);
    }

    private static int checkTypeSignature(String string, int n) {
        switch (CheckClassAdapter.getChar(string, n)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return n + (0x652BC1BD ^ 0x652BC1BC);
            }
        }
        return CheckClassAdapter.checkFieldTypeSignature(string, n);
    }

    private static int checkIdentifier(String string, int n) {
        if (!Character.isJavaIdentifierStart(CheckClassAdapter.getChar(string, n))) {
            throw new IllegalArgumentException(string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("(\ua7a6\ua4bc\ua075\ua900\u7d78\u8e5e\u2473\u8b31\u347ew\ua7f4\ua4f5\ua074\ua91d\u7d66\u8e4f\u2479\u8b23\u3472v\ua7a6\ua4b4\ua065\ua945\u7d7f\u8e44\u247e\u8b32\u346f2") + n);
        }
        ++n;
        while (Character.isJavaIdentifierPart(CheckClassAdapter.getChar(string, n))) {
            ++n;
        }
        return n;
    }

    private static int checkChar(char c, String string, int n) {
        if (CheckClassAdapter.getChar(string, n) == c) {
            return n + (0x56F1FD76 ^ 0x56F1FD77);
        }
        throw new IllegalArgumentException(string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("(\ua7a6\ua4f2") + c + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("5\ua7a6\ua4b0\ua069\ua915\u7d73\u8e49\u246e\u8b32\u34732\ua7e7\ua4a1\ua031\ua90c\u7d78\u8e4e\u247f\u8b2f\u3437") + n);
    }

    private static char getChar(String string, int n) {
        return (char)(n < string.length() ? string.charAt(n) : 0x2C20D426 ^ 0x2C20D426);
    }
}

