/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spongepowered.asm.lib.AnnotationVisitor;
import org.spongepowered.asm.lib.Attribute;
import org.spongepowered.asm.lib.Handle;
import org.spongepowered.asm.lib.Label;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Opcodes;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.TypePath;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.analysis.Analyzer;
import org.spongepowered.asm.lib.tree.analysis.BasicValue;
import org.spongepowered.asm.lib.tree.analysis.BasicVerifier;
import org.spongepowered.asm.lib.util.CheckAnnotationAdapter;
import org.spongepowered.asm.lib.util.CheckClassAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckMethodAdapter
extends MethodVisitor {
    public int version;
    private int access;
    private boolean startCode;
    private boolean endCode;
    private boolean endMethod;
    private int insnCount;
    private final Map<Label, Integer> labels;
    private Set<Label> usedLabels;
    private int expandedFrames;
    private int compressedFrames;
    private int lastFrame = 0x60A1313D ^ 0x9F5ECEC2;
    private List<Label> handlers;
    private static final int[] TYPE;
    private static Field labelStatusField;

    public CheckMethodAdapter(MethodVisitor methodVisitor) {
        this(methodVisitor, new HashMap<Label, Integer>());
    }

    public CheckMethodAdapter(MethodVisitor methodVisitor, Map<Label, Integer> map) {
        this(0x637D9FB6 ^ 0x63789FB6, methodVisitor, map);
        if (this.getClass() != CheckMethodAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckMethodAdapter(int n, MethodVisitor methodVisitor, Map<Label, Integer> map) {
        super(n, methodVisitor);
        this.labels = map;
        this.usedLabels = new HashSet<Label>();
        this.handlers = new ArrayList<Label>();
    }

    public CheckMethodAdapter(int n, String string, String string2, final MethodVisitor methodVisitor, Map<Label, Integer> map) {
        this(new MethodNode(0x5D2A19F1 ^ 0x5D2F19F1, n, string, string2, null, null){

            public void visitEnd() {
                Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(new BasicVerifier());
                try {
                    analyzer.analyze(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("v\ua7f3\ua4b8\ua07c\ua91c"), this);
                }
                catch (Exception exception) {
                    if (exception instanceof IndexOutOfBoundsException && this.maxLocals == 0 && this.maxStack == 0) {
                        throw new RuntimeException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("V\ua7e7\ua4a1\ua070\ua945\u7d70\u8e46\u2475\u8b20\u3437q\ua7ee\ua4b0\ua072\ua90e\u7d7f\u8e44\u247d\u8b77\u3478b\ua7f2\ua4bc\ua07e\ua90b\u7d36\u8e58\u247f\u8b26\u3462{\ua7f4\ua4b0\ua062\ua945\u7d60\u8e4b\u2476\u8b3e\u3473>\ua7a6\ua4bb\ua07e\ua90b\u7d36\u8e50\u247f\u8b25\u34782\ua7eb\ua4b4\ua069\ua929\u7d79\u8e49\u247b\u8b3b\u34642\ua7e7\ua4bb\ua075\ua945\u7d7b\u8e4b\u2462\u8b04\u3463s\ua7e5\ua4be\ua031\ua913\u7d77\u8e46\u246f\u8b32\u3464<"));
                    }
                    exception.printStackTrace();
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter((Writer)stringWriter, (0xB262DB00 ^ 0xB262DB01) != 0);
                    CheckClassAdapter.printAnalyzerResult(this, analyzer, printWriter);
                    printWriter.close();
                    throw new RuntimeException(exception.getMessage() + (char)(0x8C1F4BEE ^ 0x8C1F4BCE) + stringWriter.toString());
                }
                this.accept(methodVisitor);
            }
        }, map);
        this.access = n;
    }

    @Override
    public void visitParameter(String string, int n) {
        if (string != null) {
            CheckMethodAdapter.checkUnqualifiedName(this.version, string, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("|\ua7e7\ua4b8\ua074"));
        }
        CheckClassAdapter.checkAccess(n, 0x65F2B16D ^ 0x65F2217D);
        super.visitParameter(string, n);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        this.checkEndMethod();
        CheckMethodAdapter.checkDesc(string, (0xBA681C8C ^ 0xBA681C8C) != 0);
        return new CheckAnnotationAdapter(super.visitAnnotation(string, bl));
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        this.checkEndMethod();
        int n2 = n >>> (0x371BCC9 ^ 0x371BCD1);
        if (n2 != (0xC675E19C ^ 0xC675E19D)) {
            if (n2 != (0x7F08B16 ^ 0x7F08B04)) {
                if (n2 != (0xBD2D7310 ^ 0xBD2D7304)) {
                    if (n2 != (0xFD86F0DD ^ 0xFD86F0C8)) {
                        if (n2 != (0xF4BEB33C ^ 0xF4BEB32A)) {
                            if (n2 != (0xA1672D90 ^ 0xA1672D87)) {
                                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u346eb\ua7e3\ua4f5\ua063\ua900\u7d70\u8e4f\u2468\u8b32\u3479q\ua7e3\ua4f5\ua062\ua90a\u7d64\u8e5e\u243a\u8b67\u346f") + Integer.toHexString(n2));
                            }
                        }
                    }
                }
            }
        }
        CheckClassAdapter.checkTypeRefAndPath(n, typePath);
        CheckMethodAdapter.checkDesc(string, (0xBC8F3D5D ^ 0xBC8F3D5D) != 0);
        return new CheckAnnotationAdapter(super.visitTypeAnnotation(n, typePath, string, bl));
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        this.checkEndMethod();
        return new CheckAnnotationAdapter(super.visitAnnotationDefault(), (0xC539AC1 ^ 0xC539AC1) != 0);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int n, String string, boolean bl) {
        this.checkEndMethod();
        CheckMethodAdapter.checkDesc(string, (0x68E6F886 ^ 0x68E6F886) != 0);
        return new CheckAnnotationAdapter(super.visitParameterAnnotation(n, string, bl));
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.checkEndMethod();
        if (attribute == null) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b36\u3463f\ua7f4\ua4bc\ua073\ua910\u7d62\u8e4f\u243a\u8b7f\u347ag\ua7f5\ua4a1\ua031\ua90b\u7d79\u8e5e\u243a\u8b35\u34722\ua7e8\ua4a0\ua07d\ua909\u7d3f"));
        }
        super.visitAttribute(attribute);
    }

    @Override
    public void visitCode() {
        if ((this.access & (0x391414EE ^ 0x391410EE)) != 0) {
            throw new RuntimeException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("S\ua7e4\ua4a6\ua065\ua917\u7d77\u8e49\u246e\u8b77\u347aw\ua7f2\ua4bd\ua07e\ua901\u7d65\u8e0a\u2479\u8b36\u3479|\ua7e9\ua4a1\ua031\ua90d\u7d77\u8e5c\u247f\u8b77\u3474}\ua7e2\ua4b0"));
        }
        this.startCode = 0x2868818C ^ 0x2868818D;
        super.visitCode();
    }

    @Override
    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        int n4;
        int n5;
        int n6;
        if (this.insnCount == this.lastFrame) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("S\ua7f2\ua4f5\ua07c\ua90a\u7d65\u8e5e\u243a\u8b38\u3479w\ua7a6\ua4b3\ua063\ua904\u7d7b\u8e4f\u243a\u8b34\u3476|\ua7a6\ua4b7\ua074\ua945\u7d60\u8e43\u2469\u8b3e\u3463w\ua7e2\ua4f5\ua070\ua911\u7d36\u8e4b\u243a\u8b30\u347ed\ua7e3\ua4bb\ua031\ua906\u7d79\u8e4e\u247f\u8b77\u347b}\ua7e5\ua4b4\ua065\ua90c\u7d79\u8e44\u2434"));
        }
        this.lastFrame = this.insnCount;
        switch (n) {
            case -1: 
            case 0: {
                n6 = 0xD7E8C8C4 ^ 0xA817373B;
                n5 = 0x1F758A93 ^ 0x608A756C;
                break;
            }
            case 3: {
                n6 = 0xBE0A3BF7 ^ 0xBE0A3BF7;
                n5 = 0x32E5E0B2 ^ 0x32E5E0B2;
                break;
            }
            case 4: {
                n6 = 0xCEDAFB1E ^ 0xCEDAFB1E;
                n5 = 0x11A25D2F ^ 0x11A25D2E;
                break;
            }
            case 1: 
            case 2: {
                n6 = 0xC2CBA4F7 ^ 0xC2CBA4F4;
                n5 = 0x1CA13D7C ^ 0x1CA13D7C;
                break;
            }
            default: {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b31\u3465s\ua7eb\ua4b0\ua031\ua911\u7d6f\u8e5a\u247f\u8b77") + n);
            }
        }
        if (n2 > n6) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b39\u345b}\ua7e5\ua4b4\ua07d\ua958") + n2 + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e0\ua4ba\ua063\ua945\u7d70\u8e58\u247b\u8b3a\u34722\ua7f2\ua4ac\ua061\ua900\u7d36") + n);
        }
        if (n3 > n5) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b39\u3444f\ua7e7\ua4b6\ua07a\ua958") + n3 + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e0\ua4ba\ua063\ua945\u7d70\u8e58\u247b\u8b3a\u34722\ua7f2\ua4ac\ua061\ua900\u7d36") + n);
        }
        if (n != (0xA646CF0E ^ 0xA646CF0C)) {
            if (n2 > 0 && (objectArray == null || objectArray.length < n2)) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("S\ua7f4\ua4a7\ua070\ua91c\u7d36\u8e46\u2475\u8b34\u3476~\ua7dd\ua488\ua031\ua90c\u7d65\u8e0a\u2469\u8b3f\u3478`\ua7f2\ua4b0\ua063\ua945\u7d62\u8e42\u247b\u8b39\u3437|\ua7ca\ua4ba\ua072\ua904\u7d7a"));
            }
            for (n4 = 0x4410F4E7 ^ 0x4410F4E7; n4 < n2; ++n4) {
                this.checkFrameValue(objectArray[n4]);
            }
        }
        if (n3 > 0 && (objectArray2 == null || objectArray2.length < n3)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("S\ua7f4\ua4a7\ua070\ua91c\u7d36\u8e59\u246e\u8b36\u3474y\ua7dd\ua488\ua031\ua90c\u7d65\u8e0a\u2469\u8b3f\u3478`\ua7f2\ua4b0\ua063\ua945\u7d62\u8e42\u247b\u8b39\u3437|\ua7d5\ua4a1\ua070\ua906\u7d7d"));
        }
        for (n4 = 0x8118DD11 ^ 0x8118DD11; n4 < n3; ++n4) {
            this.checkFrameValue(objectArray2[n4]);
        }
        if (n == (0x5C00D742 ^ 0xA3FF28BD)) {
            this.expandedFrames += 0x7B7B07F9 ^ 0x7B7B07F8;
        } else {
            this.compressedFrames += 0xAA078FC9 ^ 0xAA078FC8;
        }
        if (this.expandedFrames > 0 && this.compressedFrames > 0) {
            throw new RuntimeException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("W\ua7fe\ua4a5\ua070\ua90b\u7d72\u8e4f\u247e\u8b77\u3476|\ua7e2\ua4f5\ua072\ua90a\u7d7b\u8e5a\u2468\u8b32\u3464a\ua7e3\ua4b1\ua031\ua903\u7d64\u8e4b\u2477\u8b32\u34642\ua7eb\ua4a0\ua062\ua911\u7d36\u8e44\u2475\u8b23\u3437p\ua7e3\ua4f5\ua07c\ua90c\u7d6e\u8e4f\u247e\u8b79"));
        }
        super.visitFrame(n, n2, objectArray, n3, objectArray2);
    }

    @Override
    public void visitInsn(int n) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 0x7047BEFE ^ 0x7047BEFE);
        super.visitInsn(n);
        this.insnCount += 0xD5F22156 ^ 0xD5F22157;
    }

    @Override
    public void visitIntInsn(int n, int n2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 0x87567710 ^ 0x87567711);
        switch (n) {
            case 16: {
                CheckMethodAdapter.checkSignedByte(n2, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b38\u3467w\ua7f4\ua4b4\ua07f\ua901"));
                break;
            }
            case 17: {
                CheckMethodAdapter.checkSignedShort(n2, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b38\u3467w\ua7f4\ua4b4\ua07f\ua901"));
                break;
            }
            default: {
                if (n2 >= (0xBCE01B77 ^ 0xBCE01B73)) {
                    if (n2 <= (0x3D2EEF98 ^ 0x3D2EEF93)) break;
                }
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b38\u3467w\ua7f4\ua4b4\ua07f\ua901\u7d36\u8e02\u2477\u8b22\u3464f\ua7a6\ua4b7\ua074\ua945\u7d77\u8e44\u243a\u8b36\u3465`\ua7e7\ua4ac\ua031\ua911\u7d6f\u8e5a\u247f\u8b77\u3474}\ua7e2\ua4b0\ua031\ua931\u7d49\u8e04\u2434\u8b79\u343e(\ua7a6") + n2);
            }
        }
        super.visitIntInsn(n, n2);
        this.insnCount += 0xE16C1C82 ^ 0xE16C1C83;
    }

    @Override
    public void visitVarInsn(int n, int n2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 0x37480DCD ^ 0x37480DCF);
        CheckMethodAdapter.checkUnsignedShort(n2, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b21\u3476`\ua7ef\ua4b4\ua073\ua909\u7d73\u8e0a\u2473\u8b39\u3473w\ua7fe"));
        super.visitVarInsn(n, n2);
        this.insnCount += 0x9083B1C7 ^ 0x9083B1C6;
    }

    @Override
    public void visitTypeInsn(int n, String string) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 0x8200A61E ^ 0x8200A61D);
        CheckMethodAdapter.checkInternalName(string, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("f\ua7ff\ua4a5\ua074"));
        if (n == (0xB96B842A ^ 0xB96B8491)) {
            if (string.charAt(0xFF9E8C36 ^ 0xFF9E8C36) == (0xDEC2058D ^ 0xDEC205D6)) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\\\ua7c3\ua482\ua031\ua906\u7d77\u8e44\u2474\u8b38\u34632\ua7e4\ua4b0\ua031\ua910\u7d65\u8e4f\u247e\u8b77\u3463}\ua7a6\ua4b6\ua063\ua900\u7d77\u8e5e\u247f\u8b77\u3476`\ua7f4\ua4b4\ua068\ua916\u7d2c\u8e0a") + string);
            }
        }
        super.visitTypeInsn(n, string);
        this.insnCount += 0x5B4B8FA6 ^ 0x5B4B8FA7;
    }

    @Override
    public void visitFieldInsn(int n, String string, String string2, String string3) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 0xE99391DA ^ 0xE99391DE);
        CheckMethodAdapter.checkInternalName(string, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("}\ua7f1\ua4bb\ua074\ua917"));
        CheckMethodAdapter.checkUnqualifiedName(this.version, string2, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("|\ua7e7\ua4b8\ua074"));
        CheckMethodAdapter.checkDesc(string3, (0x939EC883 ^ 0x939EC883) != 0);
        super.visitFieldInsn(n, string, string2, string3);
        this.insnCount += 0xF10F62F4 ^ 0xF10F62F5;
    }

    @Override
    @Deprecated
    public void visitMethodInsn(int n, String string, String string2, String string3) {
        if (this.api >= (0xCF4E8D7D ^ 0xCF4B8D7D)) {
            super.visitMethodInsn(n, string, string2, string3);
            return;
        }
        this.doVisitMethodInsn(n, string, string2, string3, (n == (0x94602F7E ^ 0x94602FC7) ? 0xB65E457C ^ 0xB65E457D : 0xC5E7A194 ^ 0xC5E7A194) != 0);
    }

    @Override
    public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
        if (this.api < (0xC932040 ^ 0xC962040)) {
            super.visitMethodInsn(n, string, string2, string3, bl);
            return;
        }
        this.doVisitMethodInsn(n, string, string2, string3, bl);
    }

    private void doVisitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 0x77FDB2CD ^ 0x77FDB2C8);
        if (n != (0x7953B91E ^ 0x7953B9A9) || !\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(string2)) {
            CheckMethodAdapter.checkMethodIdentifier(this.version, string2, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("|\ua7e7\ua4b8\ua074"));
        }
        CheckMethodAdapter.checkInternalName(string, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("}\ua7f1\ua4bb\ua074\ua917"));
        CheckMethodAdapter.checkMethodDesc(string3);
        if (n == (0x3CB6A2C8 ^ 0x3CB6A27E) && bl) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7c8\ua483\ua05e\ua92e\u7d53\u8e7c\u2453\u8b05\u3443G\ua7c7\ua499\ua031\ua906\u7d77\u8e44\u243d\u8b23\u3437p\ua7e3\ua4f5\ua064\ua916\u7d73\u8e4e\u243a\u8b20\u347ef\ua7ee\ua4f5\ua078\ua90b\u7d62\u8e4f\u2468\u8b31\u3476q\ua7e3\ua4a6"));
        }
        if (n == (0xB48B6D67 ^ 0xB48B6DDE) && !bl) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7c8\ua483\ua05e\ua92e\u7d53\u8e63\u2454\u8b03\u3452@\ua7c0\ua494\ua052\ua920\u7d36\u8e49\u247b\u8b39\u3430f\ua7a6\ua4b7\ua074\ua945\u7d63\u8e59\u247f\u8b33\u3437e\ua7ef\ua4a1\ua079\ua945\u7d75\u8e46\u247b\u8b24\u3464w\ua7f5"));
        }
        if (n == (0xBF287551 ^ 0xBF2875E6) && bl) {
            if ((this.version & (0xE9BD5185 ^ 0xE9BDAE7A)) < (0x94BCD255 ^ 0x94BCD261)) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7c8\ua483\ua05e\ua92e\u7d53\u8e79\u244a\u8b12\u3454[\ua7c7\ua499\ua031\ua906\u7d77\u8e44\u243d\u8b23\u3437p\ua7e3\ua4f5\ua064\ua916\u7d73\u8e4e\u243a\u8b20\u347ef\ua7ee\ua4f5\ua078\ua90b\u7d62\u8e4f\u2468\u8b31\u3476q\ua7e3\ua4a6\ua031\ua915\u7d64\u8e43\u2475\u8b25\u3437f\ua7e9\ua4f5\ua05b\ua904\u7d60\u8e4b\u243a\u8b6f"));
            }
        }
        if (this.mv != null) {
            this.mv.visitMethodInsn(n, string, string2, string3, bl);
        }
        this.insnCount += 0x5CC8FEFC ^ 0x5CC8FEFD;
    }

    @Override
    public void visitInvokeDynamicInsn(String string, String string2, Handle handle, Object ... objectArray) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkMethodIdentifier(this.version, string, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("|\ua7e7\ua4b8\ua074"));
        CheckMethodAdapter.checkMethodDesc(string2);
        if (handle.getTag() != (0xBFD24A11 ^ 0xBFD24A17)) {
            if (handle.getTag() != (0x6BE6F413 ^ 0x6BE6F41B)) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("{\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b3f\u3476|\ua7e2\ua4b9\ua074\ua945\u7d62\u8e4b\u247d\u8b77") + handle.getTag());
            }
        }
        for (int i = 0xA5C8D4CE ^ 0xA5C8D4CE; i < objectArray.length; ++i) {
            this.checkLDCConstant(objectArray[i]);
        }
        super.visitInvokeDynamicInsn(string, string2, handle, objectArray);
        this.insnCount += 0x3E71E5E4 ^ 0x3E71E5E5;
    }

    @Override
    public void visitJumpInsn(int n, Label label) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 0x3741499 ^ 0x374149F);
        this.checkLabel(label, (0xFD8E59C0 ^ 0xFD8E59C0) != 0, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("~\ua7e7\ua4b7\ua074\ua909"));
        CheckMethodAdapter.checkNonDebugLabel(label);
        super.visitJumpInsn(n, label);
        this.usedLabels.add(label);
        this.insnCount += 0xEBC0FF4C ^ 0xEBC0FF4D;
    }

    @Override
    public void visitLabel(Label label) {
        this.checkStartCode();
        this.checkEndCode();
        this.checkLabel(label, (0xC25B9A82 ^ 0xC25B9A82) != 0, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("~\ua7e7\ua4b7\ua074\ua909"));
        if (this.labels.get(label) != null) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("S\ua7ea\ua4a7\ua074\ua904\u7d72\u8e53\u243a\u8b21\u347ea\ua7ef\ua4a1\ua074\ua901\u7d36\u8e46\u247b\u8b35\u3472~"));
        }
        this.labels.put(label, this.insnCount);
        super.visitLabel(label);
    }

    @Override
    public void visitLdcInsn(Object object) {
        this.checkStartCode();
        this.checkEndCode();
        this.checkLDCConstant(object);
        super.visitLdcInsn(object);
        this.insnCount += 0xED7350A1 ^ 0xED7350A0;
    }

    @Override
    public void visitIincInsn(int n, int n2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnsignedShort(n, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b21\u3476`\ua7ef\ua4b4\ua073\ua909\u7d73\u8e0a\u2473\u8b39\u3473w\ua7fe"));
        CheckMethodAdapter.checkSignedShort(n2, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b3e\u3479q\ua7f4\ua4b0\ua07c\ua900\u7d78\u8e5e"));
        super.visitIincInsn(n, n2);
        this.insnCount += 0xA4A9451C ^ 0xA4A9451D;
    }

    @Override
    public void visitTableSwitchInsn(int n, int n2, Label label, Label ... labelArray) {
        int n3;
        block7: {
            block6: {
                this.checkStartCode();
                this.checkEndCode();
                if (n2 < n) {
                    throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("_\ua7e7\ua4ad\ua031\ua958\u7d36") + n2 + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7eb\ua4a0\ua062\ua911\u7d36\u8e48\u247f\u8b77\u3470`\ua7e3\ua4b4\ua065\ua900\u7d64\u8e0a\u246e\u8b3f\u3476|\ua7a6\ua4ba\ua063\ua945\u7d73\u8e5b\u246f\u8b36\u347b2\ua7f2\ua4ba\ua031\ua908\u7d7f\u8e44\u243a\u8b6a\u3437") + n);
                }
                this.checkLabel(label, (0xE8842B0F ^ 0xE8842B0F) != 0, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("v\ua7e3\ua4b3\ua070\ua910\u7d7a\u8e5e\u243a\u8b3b\u3476p\ua7e3\ua4b9"));
                CheckMethodAdapter.checkNonDebugLabel(label);
                if (labelArray == null) break block6;
                if (labelArray.length == n2 - n + (0xF63ECEDE ^ 0xF63ECEDF)) break block7;
            }
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F\ua7ee\ua4b0\ua063\ua900\u7d36\u8e47\u246f\u8b24\u34632\ua7e4\ua4b0\ua031\ua908\u7d77\u8e52\u243a\u8b7a\u3437\u007f\ua7ef\ua4bb\ua031\ua94e\u7d36\u8e1b\u243a\u8b3b\u3476p\ua7e3\ua4b9\ua062"));
        }
        for (n3 = 0x6B65C3D ^ 0x6B65C3D; n3 < labelArray.length; ++n3) {
            this.checkLabel(labelArray[n3], (0x5B0B39F3 ^ 0x5B0B39F3) != 0, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("~\ua7e7\ua4b7\ua074\ua909\u7d36\u8e4b\u246e\u8b77\u347e|\ua7e2\ua4b0\ua069\ua945") + n3);
            CheckMethodAdapter.checkNonDebugLabel(labelArray[n3]);
        }
        super.visitTableSwitchInsn(n, n2, label, labelArray);
        for (n3 = 0x1C1A88A6 ^ 0x1C1A88A6; n3 < labelArray.length; ++n3) {
            this.usedLabels.add(labelArray[n3]);
        }
        this.insnCount += 0x18D41757 ^ 0x18D41756;
    }

    @Override
    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        int n;
        this.checkEndCode();
        this.checkStartCode();
        this.checkLabel(label, (0xEB2BF227 ^ 0xEB2BF227) != 0, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("v\ua7e3\ua4b3\ua070\ua910\u7d7a\u8e5e\u243a\u8b3b\u3476p\ua7e3\ua4b9"));
        CheckMethodAdapter.checkNonDebugLabel(label);
        if (nArray == null || labelArray == null || nArray.length != labelArray.length) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F\ua7ee\ua4b0\ua063\ua900\u7d36\u8e47\u246f\u8b24\u34632\ua7e4\ua4b0\ua031\ua911\u7d7e\u8e4f\u243a\u8b24\u3476\u007f\ua7e3\ua4f5\ua07f\ua910\u7d7b\u8e48\u247f\u8b25\u3437}\ua7e0\ua4f5\ua07a\ua900\u7d6f\u8e59\u243a\u8b36\u3479v\ua7a6\ua4b9\ua070\ua907\u7d73\u8e46\u2469"));
        }
        for (n = 0x3584A356 ^ 0x3584A356; n < labelArray.length; ++n) {
            this.checkLabel(labelArray[n], (0x64130FFF ^ 0x64130FFF) != 0, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("~\ua7e7\ua4b7\ua074\ua909\u7d36\u8e4b\u246e\u8b77\u347e|\ua7e2\ua4b0\ua069\ua945") + n);
            CheckMethodAdapter.checkNonDebugLabel(labelArray[n]);
        }
        super.visitLookupSwitchInsn(label, nArray, labelArray);
        this.usedLabels.add(label);
        for (n = 0xE7C46FB5 ^ 0xE7C46FB5; n < labelArray.length; ++n) {
            this.usedLabels.add(labelArray[n]);
        }
        this.insnCount += 0xE80D6E28 ^ 0xE80D6E29;
    }

    @Override
    public void visitMultiANewArrayInsn(String string, int n) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkDesc(string, (0xC2B9CDAB ^ 0xC2B9CDAB) != 0);
        if (string.charAt(0xB7C87D49 ^ 0xB7C87D49) != (0x223D0810 ^ 0x223D084B)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b33\u3472a\ua7e5\ua4a7\ua078\ua915\u7d62\u8e45\u2468\u8b77\u343f\u007f\ua7f3\ua4a6\ua065\ua945\u7d74\u8e4f\u243a\u8b36\u34792\ua7e7\ua4a7\ua063\ua904\u7d6f\u8e0a\u246e\u8b2e\u3467w\ua7a6\ua4b1\ua074\ua916\u7d75\u8e58\u2473\u8b27\u3463}\ua7f4\ua4fc\ua02b\ua945") + string);
        }
        if (n < (0xD50D045E ^ 0xD50D045F)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b33\u347e\u007f\ua7e3\ua4bb\ua062\ua90c\u7d79\u8e44\u2469\u8b77\u343f\u007f\ua7f3\ua4a6\ua065\ua945\u7d74\u8e4f\u243a\u8b30\u3465w\ua7e7\ua4a1\ua074\ua917\u7d36\u8e5e\u2472\u8b36\u34792\ua7b6\ua4fc\ua02b\ua945") + n);
        }
        if (n > string.lastIndexOf(0x3E8C2CE1 ^ 0x3E8C2CBA) + (0x1D5B6ECE ^ 0x1D5B6ECF)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b33\u347e\u007f\ua7e3\ua4bb\ua062\ua90c\u7d79\u8e44\u2469\u8b77\u343f\u007f\ua7f3\ua4a6\ua065\ua945\u7d78\u8e45\u246e\u8b77\u3475w\ua7a6\ua4b2\ua063\ua900\u7d77\u8e5e\u247f\u8b25\u3437f\ua7ee\ua4b4\ua07f\ua945\u7d72\u8e43\u2477\u8b24\u343fv\ua7e3\ua4a6\ua072\ua94c\u7d3f\u8e10\u243a") + n);
        }
        super.visitMultiANewArrayInsn(string, n);
        this.insnCount += 0xDF69EBA4 ^ 0xDF69EBA5;
    }

    @Override
    public AnnotationVisitor visitInsnAnnotation(int n, TypePath typePath, String string, boolean bl) {
        this.checkStartCode();
        this.checkEndCode();
        int n2 = n >>> (0x80EF0798 ^ 0x80EF0780);
        if (n2 != (0x50E89EC9 ^ 0x50E89E8A)) {
            if (n2 != (0x461FD22E ^ 0x461FD26A)) {
                if (n2 != (0xCD32B8CC ^ 0xCD32B889)) {
                    if (n2 != (0xAD90B5C3 ^ 0xAD90B585)) {
                        if (n2 != (0xDB5BE2AC ^ 0xDB5BE2EB)) {
                            if (n2 != (0x74BF2993 ^ 0x74BF29DB)) {
                                if (n2 != (0x43D6DC4C ^ 0x43D6DC05)) {
                                    if (n2 != (0x516C03F6 ^ 0x516C03BC)) {
                                        if (n2 != (0x712B1719 ^ 0x712B1752)) {
                                            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u346eb\ua7e3\ua4f5\ua063\ua900\u7d70\u8e4f\u2468\u8b32\u3479q\ua7e3\ua4f5\ua062\ua90a\u7d64\u8e5e\u243a\u8b67\u346f") + Integer.toHexString(n2));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        CheckClassAdapter.checkTypeRefAndPath(n, typePath);
        CheckMethodAdapter.checkDesc(string, (0xCC2ACC40 ^ 0xCC2ACC40) != 0);
        return new CheckAnnotationAdapter(super.visitInsnAnnotation(n, typePath, string, bl));
    }

    @Override
    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.checkStartCode();
        this.checkEndCode();
        this.checkLabel(label, (0xD1F1AD6A ^ 0xD1F1AD6A) != 0, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a\ua7f2\ua4b4\ua063\ua911\u7d36\u8e46\u247b\u8b35\u3472~"));
        this.checkLabel(label2, (0xB6B176DD ^ 0xB6B176DD) != 0, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("w\ua7e8\ua4b1\ua031\ua909\u7d77\u8e48\u247f\u8b3b"));
        this.checkLabel(label3, (0x89C6A99A ^ 0x89C6A99A) != 0, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("z\ua7e7\ua4bb\ua075\ua909\u7d73\u8e58\u243a\u8b3b\u3476p\ua7e3\ua4b9"));
        CheckMethodAdapter.checkNonDebugLabel(label);
        CheckMethodAdapter.checkNonDebugLabel(label2);
        CheckMethodAdapter.checkNonDebugLabel(label3);
        if (this.labels.get(label) != null || this.labels.get(label2) != null || this.labels.get(label3) != null) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F\ua7f4\ua4ac\ua031\ua906\u7d77\u8e5e\u2479\u8b3f\u3437p\ua7ea\ua4ba\ua072\ua90e\u7d65\u8e0a\u2477\u8b22\u3464f\ua7a6\ua4b7\ua074\ua945\u7d60\u8e43\u2469\u8b3e\u3463w\ua7e2\ua4f5\ua073\ua900\u7d70\u8e45\u2468\u8b32\u3437f\ua7ee\ua4b0\ua078\ua917\u7d36\u8e46\u247b\u8b35\u3472~\ua7f5"));
        }
        if (string != null) {
            CheckMethodAdapter.checkInternalName(string, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("f\ua7ff\ua4a5\ua074"));
        }
        super.visitTryCatchBlock(label, label2, label3, string);
        this.handlers.add(label);
        this.handlers.add(label2);
    }

    @Override
    public AnnotationVisitor visitTryCatchAnnotation(int n, TypePath typePath, String string, boolean bl) {
        this.checkStartCode();
        this.checkEndCode();
        int n2 = n >>> (0x3B5FF261 ^ 0x3B5FF279);
        if (n2 != (0xF159CCD3 ^ 0xF159CC91)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u346eb\ua7e3\ua4f5\ua063\ua900\u7d70\u8e4f\u2468\u8b32\u3479q\ua7e3\ua4f5\ua062\ua90a\u7d64\u8e5e\u243a\u8b67\u346f") + Integer.toHexString(n2));
        }
        CheckClassAdapter.checkTypeRefAndPath(n, typePath);
        CheckMethodAdapter.checkDesc(string, (0x716B9CA9 ^ 0x716B9CA9) != 0);
        return new CheckAnnotationAdapter(super.visitTryCatchAnnotation(n, typePath, string, bl));
    }

    @Override
    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnqualifiedName(this.version, string, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("|\ua7e7\ua4b8\ua074"));
        CheckMethodAdapter.checkDesc(string2, (0xF64246F4 ^ 0xF64246F4) != 0);
        this.checkLabel(label, (0x197350D9 ^ 0x197350D8) != 0, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a\ua7f2\ua4b4\ua063\ua911\u7d36\u8e46\u247b\u8b35\u3472~"));
        this.checkLabel(label2, (0x3CE344A7 ^ 0x3CE344A6) != 0, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("w\ua7e8\ua4b1\ua031\ua909\u7d77\u8e48\u247f\u8b3b"));
        CheckMethodAdapter.checkUnsignedShort(n, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b21\u3476`\ua7ef\ua4b4\ua073\ua909\u7d73\u8e0a\u2473\u8b39\u3473w\ua7fe"));
        int n2 = this.labels.get(label);
        int n3 = this.labels.get(label2);
        if (n3 < n2) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b24\u3463s\ua7f4\ua4a1\ua031\ua904\u7d78\u8e4e\u243a\u8b32\u3479v\ua7a6\ua4b9\ua070\ua907\u7d73\u8e46\u2469\u8b77\u343fw\ua7e8\ua4b1\ua031\ua908\u7d63\u8e59\u246e\u8b77\u3475w\ua7a6\ua4b2\ua063\ua900\u7d77\u8e5e\u247f\u8b25\u3437f\ua7ee\ua4b4\ua07f\ua945\u7d65\u8e5e\u247b\u8b25\u3463;"));
        }
        super.visitLocalVariable(string, string2, string3, label, label2, n);
    }

    @Override
    public AnnotationVisitor visitLocalVariableAnnotation(int n, TypePath typePath, Label[] labelArray, Label[] labelArray2, int[] nArray, String string, boolean bl) {
        this.checkStartCode();
        this.checkEndCode();
        int n2 = n >>> (0x6E207422 ^ 0x6E20743A);
        if (n2 != (0x8F45993F ^ 0x8F45997F)) {
            if (n2 != (0x1624C20C ^ 0x1624C24D)) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u346eb\ua7e3\ua4f5\ua063\ua900\u7d70\u8e4f\u2468\u8b32\u3479q\ua7e3\ua4f5\ua062\ua90a\u7d64\u8e5e\u243a\u8b67\u346f") + Integer.toHexString(n2));
            }
        }
        CheckClassAdapter.checkTypeRefAndPath(n, typePath);
        CheckMethodAdapter.checkDesc(string, (0x2BE1B815 ^ 0x2BE1B815) != 0);
        if (labelArray == null || labelArray2 == null || nArray == null || labelArray2.length != labelArray.length || nArray.length != labelArray.length) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b24\u3463s\ua7f4\ua4a1\ua03d\ua945\u7d73\u8e44\u247e\u8b77\u3476|\ua7e2\ua4f5\ua078\ua90b\u7d72\u8e4f\u2462\u8b77\u3476`\ua7f4\ua4b4\ua068\ua916\u7d36\u8e02\u2477\u8b22\u3464f\ua7a6\ua4b7\ua074\ua945\u7d78\u8e45\u2474\u8b77\u3479g\ua7ea\ua4b9\ua031\ua904\u7d78\u8e4e\u243a\u8b38\u34712\ua7ef\ua4b1\ua074\ua90b\u7d62\u8e43\u2479\u8b36\u347b2\ua7ea\ua4b0\ua07f\ua902\u7d62\u8e42"));
        }
        for (int i = 0x8CC0F9A2 ^ 0x8CC0F9A2; i < labelArray.length; ++i) {
            this.checkLabel(labelArray[i], (0xC18A7007 ^ 0xC18A7006) != 0, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a\ua7f2\ua4b4\ua063\ua911\u7d36\u8e46\u247b\u8b35\u3472~"));
            this.checkLabel(labelArray2[i], (0x191A21BB ^ 0x191A21BA) != 0, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("w\ua7e8\ua4b1\ua031\ua909\u7d77\u8e48\u247f\u8b3b"));
            CheckMethodAdapter.checkUnsignedShort(nArray[i], \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b21\u3476`\ua7ef\ua4b4\ua073\ua909\u7d73\u8e0a\u2473\u8b39\u3473w\ua7fe"));
            int n3 = this.labels.get(labelArray[i]);
            int n4 = this.labels.get(labelArray2[i]);
            if (n4 >= n3) continue;
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b24\u3463s\ua7f4\ua4a1\ua031\ua904\u7d78\u8e4e\u243a\u8b32\u3479v\ua7a6\ua4b9\ua070\ua907\u7d73\u8e46\u2469\u8b77\u343fw\ua7e8\ua4b1\ua031\ua908\u7d63\u8e59\u246e\u8b77\u3475w\ua7a6\ua4b2\ua063\ua900\u7d77\u8e5e\u247f\u8b25\u3437f\ua7ee\ua4b4\ua07f\ua945\u7d65\u8e5e\u247b\u8b25\u3463;"));
        }
        return super.visitLocalVariableAnnotation(n, typePath, labelArray, labelArray2, nArray, string, bl);
    }

    @Override
    public void visitLineNumber(int n, Label label) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnsignedShort(n, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b3b\u347e|\ua7e3\ua4f5\ua07f\ua910\u7d7b\u8e48\u247f\u8b25"));
        this.checkLabel(label, (0xAA5FA5AC ^ 0xAA5FA5AD) != 0, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a\ua7f2\ua4b4\ua063\ua911\u7d36\u8e46\u247b\u8b35\u3472~"));
        super.visitLineNumber(n, label);
    }

    @Override
    public void visitMaxs(int n, int n2) {
        this.checkStartCode();
        this.checkEndCode();
        this.endCode = 0xE8D0FA02 ^ 0xE8D0FA03;
        for (Label object : this.usedLabels) {
            if (this.labels.get(object) != null) continue;
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("G\ua7e8\ua4b1\ua074\ua903\u7d7f\u8e44\u247f\u8b33\u3437~\ua7e7\ua4b7\ua074\ua909\u7d36\u8e5f\u2469\u8b32\u3473"));
        }
        int n3 = 0x23D9E3FA ^ 0x23D9E3FA;
        while (n3 < this.handlers.size()) {
            Integer n4 = this.labels.get(this.handlers.get(n3++));
            Integer n5 = this.labels.get(this.handlers.get(n3++));
            if (n4 == null || n5 == null) {
                throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("G\ua7e8\ua4b1\ua074\ua903\u7d7f\u8e44\u247f\u8b33\u3437f\ua7f4\ua4ac\ua031\ua906\u7d77\u8e5e\u2479\u8b3f\u3437p\ua7ea\ua4ba\ua072\ua90e\u7d36\u8e46\u247b\u8b35\u3472~\ua7f5"));
            }
            if (n5 > n4) continue;
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("W\ua7eb\ua4a1\ua068\ua945\u7d62\u8e58\u2463\u8b77\u3474s\ua7f2\ua4b6\ua079\ua945\u7d74\u8e46\u2475\u8b34\u347c2\ua7ee\ua4b4\ua07f\ua901\u7d7a\u8e4f\u2468\u8b77\u3465s\ua7e8\ua4b2\ua074"));
        }
        CheckMethodAdapter.checkUnsignedShort(n, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b3a\u3476j\ua7a6\ua4a6\ua065\ua904\u7d75\u8e41"));
        CheckMethodAdapter.checkUnsignedShort(n2, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b3a\u3476j\ua7a6\ua4b9\ua07e\ua906\u7d77\u8e46\u2469"));
        super.visitMaxs(n, n2);
    }

    @Override
    public void visitEnd() {
        this.checkEndMethod();
        this.endMethod = 0xA63C7EDB ^ 0xA63C7EDA;
        super.visitEnd();
    }

    void checkStartCode() {
        if (!this.startCode) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u246c\u8b3e\u3464{\ua7f2\ua4f5\ua078\ua90b\u7d65\u8e5e\u2468\u8b22\u3474f\ua7ef\ua4ba\ua07f\ua916\u7d36\u8e48\u247f\u8b31\u3478`\ua7e3\ua4f5\ua067\ua90c\u7d65\u8e43\u246e\u8b14\u3478v\ua7e3\ua4f5\ua079\ua904\u7d65\u8e0a\u2478\u8b32\u3472|\ua7a6\ua4b6\ua070\ua909\u7d7a\u8e4f\u247e\u8b79"));
        }
    }

    void checkEndCode() {
        if (this.endCode) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u246c\u8b3e\u3464{\ua7f2\ua4f5\ua078\ua90b\u7d65\u8e5e\u2468\u8b22\u3474f\ua7ef\ua4ba\ua07f\ua916\u7d36\u8e4b\u247c\u8b23\u3472`\ua7a6\ua4a3\ua078\ua916\u7d7f\u8e5e\u2457\u8b36\u346fa\ua7a6\ua4bd\ua070\ua916\u7d36\u8e48\u247f\u8b32\u34792\ua7e5\ua4b4\ua07d\ua909\u7d73\u8e4e\u2434"));
        }
    }

    void checkEndMethod() {
        if (this.endMethod) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u246c\u8b3e\u3464{\ua7f2\ua4f5\ua074\ua909\u7d73\u8e47\u247f\u8b39\u3463a\ua7a6\ua4b4\ua077\ua911\u7d73\u8e58\u243a\u8b21\u347ea\ua7ef\ua4a1\ua054\ua90b\u7d72\u8e0a\u2472\u8b36\u34642\ua7e4\ua4b0\ua074\ua90b\u7d36\u8e49\u247b\u8b3b\u347bw\ua7e2\ua4fb"));
        }
    }

    void checkFrameValue(Object object) {
        if (object == Opcodes.TOP || object == Opcodes.INTEGER || object == Opcodes.FLOAT || object == Opcodes.LONG || object == Opcodes.DOUBLE || object == Opcodes.NULL || object == Opcodes.UNINITIALIZED_THIS) {
            return;
        }
        if (object instanceof String) {
            CheckMethodAdapter.checkInternalName((String)object, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b24\u3463s\ua7e5\ua4be\ua031\ua903\u7d64\u8e4b\u2477\u8b32\u3437d\ua7e7\ua4b9\ua064\ua900"));
            return;
        }
        if (!(object instanceof Label)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b24\u3463s\ua7e5\ua4be\ua031\ua903\u7d64\u8e4b\u2477\u8b32\u3437d\ua7e7\ua4b9\ua064\ua900\u7d2c\u8e0a") + object);
        }
        this.usedLabels.add((Label)object);
    }

    static void checkOpcode(int n, int n2) {
        block3: {
            block2: {
                if (n < 0) break block2;
                if (n <= (0x2BDB7594 ^ 0x2BDB7553) && TYPE[n] == n2) break block3;
            }
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b38\u3467q\ua7e9\ua4b1\ua074\ua95f\u7d36") + n);
        }
    }

    static void checkSignedByte(int n, String string) {
        block3: {
            block2: {
                if (n < (0x66426DD6 ^ 0x99BD9256)) break block2;
                if (n <= (0x97088E0B ^ 0x97088E74)) break block3;
            }
            throw new IllegalArgumentException(string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ae\ua4b8\ua064\ua916\u7d62\u8e0a\u2478\u8b32\u3437s\ua7a6\ua4a6\ua078\ua902\u7d78\u8e4f\u247e\u8b77\u3475k\ua7f2\ua4b0\ua038\ua95f\u7d36") + n);
        }
    }

    static void checkSignedShort(int n, String string) {
        block3: {
            block2: {
                if (n < (0xC191FF03 ^ 0x3E6E7F03)) break block2;
                if (n <= (0x8510574D ^ 0x851028B2)) break block3;
            }
            throw new IllegalArgumentException(string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ae\ua4b8\ua064\ua916\u7d62\u8e0a\u2478\u8b32\u3437s\ua7a6\ua4a6\ua078\ua902\u7d78\u8e4f\u247e\u8b77\u3464z\ua7e9\ua4a7\ua065\ua94c\u7d2c\u8e0a") + n);
        }
    }

    static void checkUnsignedShort(int n, String string) {
        block3: {
            block2: {
                if (n < 0) break block2;
                if (n <= (0x79DC39C4 ^ 0x79DCC63B)) break block3;
            }
            throw new IllegalArgumentException(string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ae\ua4b8\ua064\ua916\u7d62\u8e0a\u2478\u8b32\u3437s\ua7e8\ua4f5\ua064\ua90b\u7d65\u8e43\u247d\u8b39\u3472v\ua7a6\ua4a6\ua079\ua90a\u7d64\u8e5e\u2433\u8b6d\u3437") + n);
        }
    }

    static void checkConstant(Object object) {
        if (!(object instanceof Integer || object instanceof Float || object instanceof Long || object instanceof Double || object instanceof String)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b34\u3478|\ua7f5\ua4a1\ua070\ua90b\u7d62\u8e10\u243a") + object);
        }
    }

    void checkLDCConstant(Object object) {
        block12: {
            block13: {
                int n;
                block14: {
                    block11: {
                        if (!(object instanceof Type)) break block11;
                        int n2 = ((Type)object).getSort();
                        if (n2 != (0x78D097E1 ^ 0x78D097EB)) {
                            if (n2 != (0x89E6C692 ^ 0x89E6C69B)) {
                                if (n2 != (0xC528B42A ^ 0xC528B421)) {
                                    throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b1b\u3453Q\ua7a6\ua4b6\ua07e\ua90b\u7d65\u8e5e\u247b\u8b39\u34632\ua7f0\ua4b4\ua07d\ua910\u7d73"));
                                }
                            }
                        }
                        if (n2 != (0xF9ED3719 ^ 0xF9ED3712)) {
                            if ((this.version & (0x52EDEF8B ^ 0x52ED1074)) < (0x981B76AA ^ 0x981B769B)) {
                                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("~\ua7e2\ua4b6\ua031\ua90a\u7d70\u8e0a\u247b\u8b77\u3474}\ua7e8\ua4a6\ua065\ua904\u7d78\u8e5e\u243a\u8b34\u347bs\ua7f5\ua4a6\ua031\ua917\u7d73\u8e5b\u246f\u8b3e\u3465w\ua7f5\ua4f5\ua070\ua911\u7d36\u8e46\u247f\u8b36\u3464f\ua7a6\ua4a3\ua074\ua917\u7d65\u8e43\u2475\u8b39\u3437#\ua7a8\ua4e0"));
                            }
                        }
                        if (n2 == (0x84832728 ^ 0x84832723)) {
                            if ((this.version & (0xFC1183EE ^ 0xFC117C11)) < (0x16DA26A3 ^ 0x16DA2690)) {
                                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("~\ua7e2\ua4b6\ua031\ua90a\u7d70\u8e0a\u247b\u8b77\u347aw\ua7f2\ua4bd\ua07e\ua901\u7d36\u8e5e\u2463\u8b27\u34722\ua7f4\ua4b0\ua060\ua910\u7d7f\u8e58\u247f\u8b24\u3437s\ua7f2\ua4f5\ua07d\ua900\u7d77\u8e59\u246e\u8b77\u3461w\ua7f4\ua4a6\ua078\ua90a\u7d78\u8e0a\u242b\u8b79\u3420"));
                            }
                        }
                        break block12;
                    }
                    if (!(object instanceof Handle)) break block13;
                    if ((this.version & (0xA57E98B7 ^ 0xA57E6748)) < (0x55F183C7 ^ 0x55F183F4)) {
                        throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("~\ua7e2\ua4b6\ua031\ua90a\u7d70\u8e0a\u247b\u8b77\u347fs\ua7e8\ua4b1\ua07d\ua900\u7d36\u8e58\u247f\u8b26\u3462{\ua7f4\ua4b0\ua062\ua945\u7d77\u8e5e\u243a\u8b3b\u3472s\ua7f5\ua4a1\ua031\ua913\u7d73\u8e58\u2469\u8b3e\u3478|\ua7a6\ua4e4\ua03f\ua952"));
                    }
                    n = ((Handle)object).getTag();
                    if (n < (0x4A9FADF4 ^ 0x4A9FADF5)) break block14;
                    if (n <= (0x8622CE34 ^ 0x8622CE3D)) break block12;
                }
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("{\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b3f\u3476|\ua7e2\ua4b9\ua074\ua945\u7d62\u8e4b\u247d\u8b77") + n);
            }
            CheckMethodAdapter.checkConstant(object);
        }
    }

    static void checkUnqualifiedName(int n, String string, String string2) {
        if ((n & (0x27C405F1 ^ 0x27C4FA0E)) < (0xA010A0FC ^ 0xA010A0CD)) {
            CheckMethodAdapter.checkIdentifier(string, string2);
        } else {
            for (int i = 0xA14A7479 ^ 0xA14A7479; i < string.length(); ++i) {
                if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("<\ua7bd\ua48e\ua03e").indexOf(string.charAt(i)) == (0x2A00BB06 ^ 0xD5FF44F9)) continue;
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a") + string2 + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ae\ua4b8\ua064\ua916\u7d62\u8e0a\u2478\u8b32\u3437s\ua7a6\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b22\u3479c\ua7f3\ua4b4\ua07d\ua90c\u7d70\u8e43\u247f\u8b33\u3437|\ua7e7\ua4b8\ua074\ua94c\u7d2c\u8e0a") + string);
            }
        }
    }

    static void checkIdentifier(String string, String string2) {
        CheckMethodAdapter.checkIdentifier(string, 0xA7EE8FA ^ 0xA7EE8FA, 0xFC7C92B1 ^ 0x3836D4E, string2);
    }

    static void checkIdentifier(String string, int n, int n2, String string2) {
        block6: {
            block5: {
                if (string == null) break block5;
                if (!(n2 == (0x9561CEF1 ^ 0x6A9E310E) ? string.length() <= n : n2 <= n)) break block6;
            }
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a") + string2 + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ae\ua4b8\ua064\ua916\u7d62\u8e0a\u2474\u8b38\u34632\ua7e4\ua4b0\ua031\ua90b\u7d63\u8e46\u2476\u8b77\u3478`\ua7a6\ua4b0\ua07c\ua915\u7d62\u8e53\u2433"));
        }
        if (!Character.isJavaIdentifierStart(string.charAt(n))) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a") + string2 + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ae\ua4b8\ua064\ua916\u7d62\u8e0a\u2478\u8b32\u3437s\ua7a6\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b1d\u3476d\ua7e7\ua4f5\ua078\ua901\u7d73\u8e44\u246e\u8b3e\u3471{\ua7e3\ua4a7\ua038\ua95f\u7d36") + string);
        }
        int n3 = n2 == (0xE7F57AF4 ^ 0x180A850B) ? string.length() : n2;
        for (int i = n + (0xA272493D ^ 0xA272493C); i < n3; ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a") + string2 + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ae\ua4b8\ua064\ua916\u7d62\u8e0a\u2478\u8b32\u3437s\ua7a6\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b1d\u3476d\ua7e7\ua4f5\ua078\ua901\u7d73\u8e44\u246e\u8b3e\u3471{\ua7e3\ua4a7\ua038\ua95f\u7d36") + string);
        }
    }

    static void checkMethodIdentifier(int n, String string, String string2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a") + string2 + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ae\ua4b8\ua064\ua916\u7d62\u8e0a\u2474\u8b38\u34632\ua7e4\ua4b0\ua031\ua90b\u7d63\u8e46\u2476\u8b77\u3478`\ua7a6\ua4b0\ua07c\ua915\u7d62\u8e53\u2433"));
        }
        if ((n & (0x3A16249C ^ 0x3A16DB63)) >= (0xEF11EDD9 ^ 0xEF11EDE8)) {
            for (int i = 0x5CBE30C ^ 0x5CBE30C; i < string.length(); ++i) {
                if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("<\ua7bd\ua48e\ua03e\ua959\u7d28").indexOf(string.charAt(i)) == (0x1B7F53F4 ^ 0xE480AC0B)) continue;
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a") + string2 + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ae\ua4b8\ua064\ua916\u7d62\u8e0a\u2478\u8b32\u3437s\ua7a6\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b22\u3479c\ua7f3\ua4b4\ua07d\ua90c\u7d70\u8e43\u247f\u8b33\u3437|\ua7e7\ua4b8\ua074\ua94c\u7d2c\u8e0a") + string);
            }
            return;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0xFDBE191B ^ 0xFDBE191B))) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a") + string2 + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ae\ua4b8\ua064\ua916\u7d62\u8e0a\u2478\u8b32\u3437s\ua7a6\ua4f2\ua02d\ua90c\u7d78\u8e43\u246e\u8b69\u3430>\ua7a6\ua4f2\ua02d\ua906\u7d7a\u8e43\u2474\u8b3e\u3463,\ua7a1\ua4f5\ua07e\ua917\u7d36\u8e4b\u243a\u8b21\u3476~\ua7ef\ua4b1\ua031\ua92f\u7d77\u8e5c\u247b\u8b77\u347ev\ua7e3\ua4bb\ua065\ua90c\u7d70\u8e43\u247f\u8b25\u343e(\ua7a6") + string);
        }
        for (int i = 0x5B71B73B ^ 0x5B71B73A; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a") + string2 + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ae\ua4b8\ua064\ua916\u7d62\u8e0a\u2478\u8b32\u34375\ua7ba\ua4bc\ua07f\ua90c\u7d62\u8e14\u243d\u8b77\u3478`\ua7a6\ua4f2\ua02d\ua906\u7d7a\u8e43\u2474\u8b3e\u3463,\ua7a1\ua4f5\ua07e\ua917\u7d36\u8e4b\u243a\u8b21\u3476~\ua7ef\ua4b1\ua031\ua92f\u7d77\u8e5c\u247b\u8b77\u347ev\ua7e3\ua4bb\ua065\ua90c\u7d70\u8e43\u247f\u8b25\u343e(\ua7a6") + string);
        }
    }

    static void checkInternalName(String string, String string2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a") + string2 + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ae\ua4b8\ua064\ua916\u7d62\u8e0a\u2474\u8b38\u34632\ua7e4\ua4b0\ua031\ua90b\u7d63\u8e46\u2476\u8b77\u3478`\ua7a6\ua4b0\ua07c\ua915\u7d62\u8e53\u2433"));
        }
        if (string.charAt(0x6C27E591 ^ 0x6C27E591) == (0xD1BEC380 ^ 0xD1BEC3DB)) {
            CheckMethodAdapter.checkDesc(string, (0x18806705 ^ 0x18806705) != 0);
        } else {
            CheckMethodAdapter.checkInternalName(string, 0xEFC75B54 ^ 0xEFC75B54, 0x8D98CC65 ^ 0x7267339A, string2);
        }
    }

    static void checkInternalName(String string, int n, int n2, String string2) {
        int n3 = n2 == (0x6DAAF4C ^ 0xF92550B3) ? string.length() : n2;
        try {
            int n4;
            int n5 = n;
            do {
                n4 = string.indexOf(0x53C6DAC ^ 0x53C6D83, n5 + (0x9D026610 ^ 0x9D026611));
                if (n4 == (0xA8337939 ^ 0x57CC86C6) || n4 > n3) {
                    n4 = n3;
                }
                CheckMethodAdapter.checkIdentifier(string, n5, n4, null);
                n5 = n4 + (0xF4F85137 ^ 0xF4F85136);
            } while (n4 != n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a") + string2 + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ae\ua4b8\ua064\ua916\u7d62\u8e0a\u2478\u8b32\u3437s\ua7a6\ua4b3\ua064\ua909\u7d7a\u8e53\u243a\u8b26\u3462s\ua7ea\ua4bc\ua077\ua90c\u7d73\u8e4e\u243a\u8b34\u347bs\ua7f5\ua4a6\ua031\ua90b\u7d77\u8e47\u247f\u8b77\u347e|\ua7a6\ua4bc\ua07f\ua911\u7d73\u8e58\u2474\u8b36\u347b2\ua7e0\ua4ba\ua063\ua908\u7d3f\u8e10\u243a") + string);
        }
    }

    static void checkDesc(String string, boolean bl) {
        int n = CheckMethodAdapter.checkDesc(string, 0xE983F3B1 ^ 0xE983F3B1, bl);
        if (n != string.length()) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b33\u3472a\ua7e5\ua4a7\ua078\ua915\u7d62\u8e45\u2468\u8b6d\u3437") + string);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int checkDesc(String string, int n, boolean bl) {
        if (string == null || n >= string.length()) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u346eb\ua7e3\ua4f5\ua075\ua900\u7d65\u8e49\u2468\u8b3e\u3467f\ua7e9\ua4a7\ua031\ua94d\u7d7b\u8e5f\u2469\u8b23\u3437|\ua7e9\ua4a1\ua031\ua907\u7d73\u8e0a\u2474\u8b22\u347b~\ua7a6\ua4ba\ua063\ua945\u7d73\u8e47\u246a\u8b23\u346e;"));
        }
        switch (string.charAt(n)) {
            case 'V': {
                if (!bl) throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b33\u3472a\ua7e5\ua4a7\ua078\ua915\u7d62\u8e45\u2468\u8b6d\u3437") + string);
                return n + (0x18F75A71 ^ 0x18F75A70);
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return n + (0x8365C117 ^ 0x8365C116);
            }
            case '[': {
                int n2;
                for (n2 = n + (0xD0A88073 ^ 0xD0A88072); n2 < string.length(); ++n2) {
                    if (string.charAt(n2) != (0x3CC0EF0A ^ 0x3CC0EF51)) break;
                }
                if (n2 >= string.length()) throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b33\u3472a\ua7e5\ua4a7\ua078\ua915\u7d62\u8e45\u2468\u8b6d\u3437") + string);
                return CheckMethodAdapter.checkDesc(string, n2, (0x9D622A7B ^ 0x9D622A7B) != 0);
            }
            case 'L': {
                int n3 = string.indexOf(0x19D7C4DA ^ 0x19D7C4E1, n);
                if (n3 == (0x55899FCD ^ 0xAA766032)) throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b33\u3472a\ua7e5\ua4a7\ua078\ua915\u7d62\u8e45\u2468\u8b6d\u3437") + string);
                if (n3 - n < (0x625F0523 ^ 0x625F0521)) {
                    throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b33\u3472a\ua7e5\ua4a7\ua078\ua915\u7d62\u8e45\u2468\u8b6d\u3437") + string);
                }
                try {
                    CheckMethodAdapter.checkInternalName(string, n + (0x42EC90A0 ^ 0x42EC90A1), n3, null);
                    return n3 + (0x3CD9C500 ^ 0x3CD9C501);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b33\u3472a\ua7e5\ua4a7\ua078\ua915\u7d62\u8e45\u2468\u8b6d\u3437") + string);
                }
            }
        }
        throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b33\u3472a\ua7e5\ua4a7\ua078\ua915\u7d62\u8e45\u2468\u8b6d\u3437") + string);
    }

    static void checkMethodDesc(String string) {
        block9: {
            block8: {
                if (string == null || string.length() == 0) {
                    throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b3a\u3472f\ua7ee\ua4ba\ua075\ua945\u7d72\u8e4f\u2469\u8b34\u3465{\ua7f6\ua4a1\ua07e\ua917\u7d36\u8e02\u2477\u8b22\u3464f\ua7a6\ua4bb\ua07e\ua911\u7d36\u8e48\u247f\u8b77\u3479g\ua7ea\ua4b9\ua031\ua90a\u7d64\u8e0a\u247f\u8b3a\u3467f\ua7ff\ua4fc"));
                }
                if (string.charAt(0xE94607D6 ^ 0xE94607D6) != (0xC8A7D8D7 ^ 0xC8A7D8FF)) break block8;
                if (string.length() >= (0x4DF1EAEA ^ 0x4DF1EAE9)) break block9;
            }
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b33\u3472a\ua7e5\ua4a7\ua078\ua915\u7d62\u8e45\u2468\u8b6d\u3437") + string);
        }
        int n = 0xD9DA1CD4 ^ 0xD9DA1CD5;
        if (string.charAt(n) != (0x5DE15A14 ^ 0x5DE15A3D)) {
            do {
                if (string.charAt(n) == (0xD667E34B ^ 0xD667E31D)) {
                    throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b33\u3472a\ua7e5\ua4a7\ua078\ua915\u7d62\u8e45\u2468\u8b6d\u3437") + string);
                }
                if ((n = CheckMethodAdapter.checkDesc(string, n, (0x9A49FEF6 ^ 0x9A49FEF6) != 0)) >= string.length()) break;
            } while (string.charAt(n) != (0xEFD6E320 ^ 0xEFD6E309));
        }
        if ((n = CheckMethodAdapter.checkDesc(string, n + (0x595DFF37 ^ 0x595DFF36), (0xB49335DB ^ 0xB49335DA) != 0)) != string.length()) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b33\u3472a\ua7e5\ua4a7\ua078\ua915\u7d62\u8e45\u2468\u8b6d\u3437") + string);
        }
    }

    void checkLabel(Label label, boolean bl, String string) {
        if (label == null) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a") + string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ae\ua4b8\ua064\ua916\u7d62\u8e0a\u2474\u8b38\u34632\ua7e4\ua4b0\ua031\ua90b\u7d63\u8e46\u2476\u8b7e"));
        }
        if (bl && this.labels.get(label) == null) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a") + string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ae\ua4b8\ua064\ua916\u7d62\u8e0a\u2478\u8b32\u3437d\ua7ef\ua4a6\ua078\ua911\u7d73\u8e4e\u243a\u8b31\u347e`\ua7f5\ua4a1\ua038"));
        }
    }

    private static void checkNonDebugLabel(Label label) {
        Field field = CheckMethodAdapter.getLabelStatusField();
        int n = 0x27CE3554 ^ 0x27CE3554;
        try {
            n = field == null ? 0x7D665567 ^ 0x7D665567 : (Integer)field.get(label);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a1\ua074\ua917\u7d78\u8e4b\u2476\u8b77\u3472`\ua7f4\ua4ba\ua063"));
        }
        if ((n & (0x21654B95 ^ 0x21654B94)) != 0) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^\ua7e7\ua4b7\ua074\ua909\u7d65\u8e0a\u246f\u8b24\u3472v\ua7a6\ua4b3\ua07e\ua917\u7d36\u8e4e\u247f\u8b35\u3462u\ua7a6\ua4bc\ua07f\ua903\u7d79\u8e0a\u2479\u8b36\u3479|\ua7e9\ua4a1\ua031\ua907\u7d73\u8e0a\u2468\u8b32\u3462a\ua7e3\ua4b1\ua031\ua903\u7d79\u8e58\u243a\u8b34\u3478|\ua7f2\ua4a7\ua07e\ua909\u7d36\u8e4c\u2476\u8b38\u3460"));
        }
    }

    private static Field getLabelStatusField() {
        if (labelStatusField == null && (labelStatusField = CheckMethodAdapter.getLabelField(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("s"))) == null) {
            labelStatusField = CheckMethodAdapter.getLabelField(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a\ua7f2\ua4b4\ua065\ua910\u7d65"));
        }
        return labelStatusField;
    }

    private static Field getLabelField(String string) {
        try {
            Field field = Label.class.getDeclaredField(string);
            field.setAccessible((0x7727FC4D ^ 0x7727FC4C) != 0);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    static {
        String string = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("P\ua7c4\ua497\ua053\ua927\u7d54\u8e68\u2458\u8b15\u3455P\ua7c4\ua497\ua053\ua927\u7d54\u8e69\u2459\u8b1e\u3456S\ua7c2\ua491\ua055\ua921\u7d52\u8e6b\u245b\u8b16\u3456S\ua7c7\ua494\ua050\ua924\u7d57\u8e6b\u245b\u8b16\u3456S\ua7c7\ua494\ua050\ua924\u7d57\u8e68\u2458\u8b15\u3455P\ua7c4\ua497\ua053\ua921\u7d52\u8e6e\u245e\u8b13\u3456S\ua7c7\ua494\ua050\ua924\u7d57\u8e6b\u245b\u8b16\u3456S\ua7c7\ua494\ua050\ua924\u7d57\u8e6b\u245b\u8b16\u3455P\ua7c4\ua497\ua053\ua927\u7d54\u8e68\u2458\u8b15\u3455P\ua7c4\ua497\ua053\ua927\u7d54\u8e68\u2458\u8b15\u3455P\ua7c4\ua497\ua053\ua927\u7d54\u8e68\u2458\u8b15\u3455P\ua7c4\ua497\ua053\ua927\u7d54\u8e68\u2458\u8b15\u3455P\ua7c4\ua497\ua053\ua927\u7d54\u8e68\u2458\u8b15\u3455P\ua7c4\ua49f\ua053\ua927\u7d54\u8e68\u2458\u8b15\u3455P\ua7c4\ua497\ua053\ua927\u7d54\u8e68\u2458\u8b15\u3455P\ua7c4\ua497\ua059\ua92d\u7d5e\u8e62\u2452\u8b1f\u345fZ\ua7ce\ua49d\ua059\ua92d\u7d5e\u8e62\u2452\u8b1f\u3453Y\ua7ca\ua497\ua053\ua927\u7d54\u8e68\u2458\u8b11\u3451T\ua7c0\ua492\ua056\ua922\u7d51\u8e6b\u245f\u8b14\u3452P\ua7c4\ua490\ua054\ua927\u7d54\u8e6b\u2457\u8b1f\u345fS\ua7c7");
        TYPE = new int[string.length()];
        for (int i = 0x6335F2B ^ 0x6335F2B; i < TYPE.length; ++i) {
            CheckMethodAdapter.TYPE[i] = string.charAt(i) - (0xECDF52BA ^ 0xECDF52FB) - (0xF8F5AD49 ^ 0xF8F5AD48);
        }
    }
}

