/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.util;

import org.spongepowered.asm.lib.signature.SignatureVisitor;

public final class TraceSignatureVisitor
extends SignatureVisitor {
    private final StringBuilder declaration;
    private boolean isInterface;
    private boolean seenFormalParameter;
    private boolean seenInterfaceBound;
    private boolean seenParameter;
    private boolean seenInterface;
    private StringBuilder returnType;
    private StringBuilder exceptions;
    private int argumentStack;
    private int arrayStack;
    private String separator = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("");

    public TraceSignatureVisitor(int n) {
        super(0xB6B286E6 ^ 0xB6B786E6);
        this.isInterface = (n & (0x13FAC0D4 ^ 0x13FAC2D4)) != 0 ? 0xF01614DD ^ 0xF01614DC : 0x9010B05 ^ 0x9010B05;
        this.declaration = new StringBuilder();
    }

    private TraceSignatureVisitor(StringBuilder stringBuilder) {
        super(0x1CADB166 ^ 0x1CA8B166);
        this.declaration = stringBuilder;
    }

    public void visitFormalTypeParameter(String string) {
        this.declaration.append(this.seenFormalParameter ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(">\ua7a6") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(".")).append(string);
        this.seenFormalParameter = 0xCEC0DB0E ^ 0xCEC0DB0F;
        this.seenInterfaceBound = 0x5BC7DDE0 ^ 0x5BC7DDE0;
    }

    public SignatureVisitor visitClassBound() {
        this.separator = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e3\ua4ad\ua065\ua900\u7d78\u8e4e\u2469\u8b77");
        this.startType();
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        this.separator = this.seenInterfaceBound ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(">\ua7a6") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e3\ua4ad\ua065\ua900\u7d78\u8e4e\u2469\u8b77");
        this.seenInterfaceBound = 0x3B5C6801 ^ 0x3B5C6800;
        this.startType();
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        this.endFormals();
        this.separator = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e3\ua4ad\ua065\ua900\u7d78\u8e4e\u2469\u8b77");
        this.startType();
        return this;
    }

    public SignatureVisitor visitInterface() {
        this.separator = this.seenInterface ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(">\ua7a6") : (this.isInterface ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e3\ua4ad\ua065\ua900\u7d78\u8e4e\u2469\u8b77") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ef\ua4b8\ua061\ua909\u7d73\u8e47\u247f\u8b39\u3463a\ua7a6"));
        this.seenInterface = 0x3A4F1AA8 ^ 0x3A4F1AA9;
        this.startType();
        return this;
    }

    public SignatureVisitor visitParameterType() {
        this.endFormals();
        if (this.seenParameter) {
            this.declaration.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(">\ua7a6"));
        } else {
            this.seenParameter = 0x8E27D3C7 ^ 0x8E27D3C6;
            this.declaration.append((char)(0x14546C8B ^ 0x14546CA3));
        }
        this.startType();
        return this;
    }

    public SignatureVisitor visitReturnType() {
        this.endFormals();
        if (this.seenParameter) {
            this.seenParameter = 0x22DE1BAB ^ 0x22DE1BAB;
        } else {
            this.declaration.append((char)(0x71F8385F ^ 0x71F83877));
        }
        this.declaration.append((char)(0x9A4604BB ^ 0x9A460492));
        this.returnType = new StringBuilder();
        return new TraceSignatureVisitor(this.returnType);
    }

    public SignatureVisitor visitExceptionType() {
        if (this.exceptions == null) {
            this.exceptions = new StringBuilder();
        } else {
            this.exceptions.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(">\ua7a6"));
        }
        return new TraceSignatureVisitor(this.exceptions);
    }

    public void visitBaseType(char c) {
        switch (c) {
            case 'V': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("d\ua7e9\ua4bc\ua075"));
                break;
            }
            case 'B': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("p\ua7ff\ua4a1\ua074"));
                break;
            }
            case 'J': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("~\ua7e9\ua4bb\ua076"));
                break;
            }
            case 'Z': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("p\ua7e9\ua4ba\ua07d\ua900\u7d77\u8e44"));
                break;
            }
            case 'I': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("{\ua7e8\ua4a1"));
                break;
            }
            case 'S': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a\ua7ee\ua4ba\ua063\ua911"));
                break;
            }
            case 'C': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("q\ua7ee\ua4b4\ua063"));
                break;
            }
            case 'F': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("t\ua7ea\ua4ba\ua070\ua911"));
                break;
            }
            default: {
                this.declaration.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("v\ua7e9\ua4a0\ua073\ua909\u7d73"));
            }
        }
        this.endType();
    }

    public void visitTypeVariable(String string) {
        this.declaration.append(string);
        this.endType();
    }

    public SignatureVisitor visitArrayType() {
        this.startType();
        this.arrayStack |= 0x796C6A30 ^ 0x796C6A31;
        return this;
    }

    public void visitClassType(String string) {
        if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62").equals(string)) {
            int n;
            int n2 = this.argumentStack % (0x448B7079 ^ 0x448B707B) != 0 || this.seenParameter ? 0xC84F087D ^ 0xC84F087C : (n = 0x9BD98101 ^ 0x9BD98101);
            if (n != 0) {
                this.declaration.append(this.separator).append(string.replace((char)(0xD2FB14D2 ^ 0xD2FB14FD), (char)(0x6C1B814F ^ 0x6C1B8161)));
            }
        } else {
            this.declaration.append(this.separator).append(string.replace((char)(0xE0D90947 ^ 0xE0D90968), (char)(0x5869B925 ^ 0x5869B90B)));
        }
        this.separator = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("");
        this.argumentStack *= 0x77C24FCD ^ 0x77C24FCF;
    }

    public void visitInnerClassType(String string) {
        if (this.argumentStack % (0xF8233339 ^ 0xF823333B) != 0) {
            this.declaration.append((char)(0x27FC5288 ^ 0x27FC52B6));
        }
        this.argumentStack /= 0x295F2F57 ^ 0x295F2F55;
        this.declaration.append((char)(0x3EA4FD76 ^ 0x3EA4FD58));
        this.declaration.append(this.separator).append(string.replace((char)(0x79A730AF ^ 0x79A73080), (char)(0xF3C34CF7 ^ 0xF3C34CD9)));
        this.separator = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("");
        this.argumentStack *= 0x1E3359AA ^ 0x1E3359A8;
    }

    public void visitTypeArgument() {
        if (this.argumentStack % (0xB8101FFB ^ 0xB8101FF9) == 0) {
            this.argumentStack += 0x56014C0E ^ 0x56014C0F;
            this.declaration.append((char)(0x3FB24596 ^ 0x3FB245AA));
        } else {
            this.declaration.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(">\ua7a6"));
        }
        this.declaration.append((char)(0xEA741D68 ^ 0xEA741D57));
    }

    public SignatureVisitor visitTypeArgument(char c) {
        if (this.argumentStack % (0xB42C7420 ^ 0xB42C7422) == 0) {
            this.argumentStack += 0x26FFB367 ^ 0x26FFB366;
            this.declaration.append((char)(0xDAE89C8B ^ 0xDAE89CB7));
        } else {
            this.declaration.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(">\ua7a6"));
        }
        if (c == (0xAB29870F ^ 0xAB298724)) {
            this.declaration.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("-\ua7a6\ua4b0\ua069\ua911\u7d73\u8e44\u247e\u8b24\u3437"));
        } else if (c == (0x902AD9BE ^ 0x902AD993)) {
            this.declaration.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("-\ua7a6\ua4a6\ua064\ua915\u7d73\u8e58\u243a"));
        }
        this.startType();
        return this;
    }

    public void visitEnd() {
        if (this.argumentStack % (0xDC40642C ^ 0xDC40642E) != 0) {
            this.declaration.append((char)(0xA7574D31 ^ 0xA7574D0F));
        }
        this.argumentStack /= 0x2A022FA1 ^ 0x2A022FA3;
        this.endType();
    }

    public String getDeclaration() {
        return this.declaration.toString();
    }

    public String getReturnType() {
        return this.returnType == null ? null : this.returnType.toString();
    }

    public String getExceptions() {
        return this.exceptions == null ? null : this.exceptions.toString();
    }

    private void endFormals() {
        if (this.seenFormalParameter) {
            this.declaration.append((char)(0x5C4CEE68 ^ 0x5C4CEE56));
            this.seenFormalParameter = 0x119C297C ^ 0x119C297C;
        }
    }

    private void startType() {
        this.arrayStack *= 0x9B406005 ^ 0x9B406007;
    }

    private void endType() {
        if (this.arrayStack % (0xCDCFAE5B ^ 0xCDCFAE59) == 0) {
            this.arrayStack /= 0xE36033E5 ^ 0xE36033E7;
        } else {
            while (true) {
                if (this.arrayStack % (0xC29CD328 ^ 0xC29CD32A) == 0) break;
                this.arrayStack /= 0x9D88DB48 ^ 0x9D88DB4A;
                this.declaration.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("I\ua7db"));
            }
        }
    }
}

