/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.spongepowered.asm.launch.GlobalProperties;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.extensibility.IEnvironmentTokenProvider;
import org.spongepowered.asm.mixin.throwables.MixinException;
import org.spongepowered.asm.mixin.transformer.MixinTransformer;
import org.spongepowered.asm.obfuscation.RemapperChain;
import org.spongepowered.asm.service.ILegacyClassTransformer;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.ITransformer;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.ITokenProvider;
import org.spongepowered.asm.util.JavaVersion;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.asm.util.perf.Profiler;

public final class MixinEnvironment
implements ITokenProvider {
    private static final Set<String> excludeTransformers;
    private static MixinEnvironment currentEnvironment;
    private static Phase currentPhase;
    private static CompatibilityLevel compatibility;
    private static boolean showHeader;
    private static final Logger logger;
    private static final Profiler profiler;
    private final IMixinService service;
    private final Phase phase;
    private final String configsKey;
    private final boolean[] options;
    private final Set<String> tokenProviderClasses = new HashSet<String>();
    private final List<TokenProviderWrapper> tokenProviders = new ArrayList<TokenProviderWrapper>();
    private final Map<String, Integer> internalTokens = new HashMap<String, Integer>();
    private final RemapperChain remappers = new RemapperChain();
    private Side side;
    private List<ILegacyClassTransformer> transformers;
    private String obfuscationContext = null;

    MixinEnvironment(Phase phase) {
        this.service = MixinService.getService();
        this.phase = phase;
        this.configsKey = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b\u7d38\u8e49\u2475\u8b39\u3471{\ua7e1\ua4a6\ua03f") + this.phase.name.toLowerCase();
        String string = this.getVersion();
        if (string == null || !\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\"\ua7a8\ua4e2\ua03f\ua954\u7d27").equals(string)) {
            throw new MixinException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("W\ua7e8\ua4a3\ua078\ua917\u7d79\u8e44\u2477\u8b32\u3479f\ua7a6\ua4b6\ua07e\ua90b\u7d70\u8e46\u2473\u8b34\u3463>\ua7a6\ua4b8\ua078\ua916\u7d7b\u8e4b\u246e\u8b34\u347fw\ua7e2\ua4f5\ua067\ua900\u7d64\u8e59\u2473\u8b38\u3479a\ua7a6\ua4ba\ua063\ua945\u7d6f\u8e45\u246f\u8b77\u3473{\ua7e2\ua4bb\ua036\ua911\u7d36\u8e49\u247b\u8b3b\u347b2\ua7cb\ua4bc\ua069\ua90c\u7d78\u8e68\u2475\u8b38\u3463a\ua7f2\ua4a7\ua070\ua915\u7d38\u8e43\u2474\u8b3e\u3463:\ua7af"));
        }
        this.service.checkEnv(this);
        this.options = new boolean[Option.values().length];
        Option[] optionArray = Option.values();
        int n = optionArray.length;
        for (int i = 0x61CE7E2D ^ 0x61CE7E2D; i < n; ++i) {
            Option option = optionArray[i];
            this.options[option.ordinal()] = option.getBooleanValue();
        }
        if (showHeader) {
            showHeader = 0xC4A20027 ^ 0xC4A20027;
            this.printHeader(string);
        }
    }

    private void printHeader(Object object) {
        String string = this.getCodeSource();
        String string2 = this.service.getName();
        Side side = this.getSide();
        Object[] objectArray = new Object[0x1384F4D6 ^ 0x1384F4D2];
        objectArray[0xE2D6CEB1 ^ 0xE2D6CEB1] = object;
        objectArray[0x267620BC ^ 0x267620BD] = string;
        objectArray[0x64380420 ^ 0x64380422] = string2;
        objectArray[0x4395437E ^ 0x4395437D] = side;
        logger.info(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7f6\ua4ba\ua07f\ua902\u7d73\u8e7a\u2475\u8b20\u3472`\ua7e3\ua4b1\ua031\ua928\u7d5f\u8e72\u2453\u8b19\u3437A\ua7f3\ua4b7\ua062\ua91c\u7d65\u8e5e\u247f\u8b3a\u3437D\ua7e3\ua4a7\ua062\ua90c\u7d79\u8e44\u2427\u8b2c\u346a2\ua7d5\ua4ba\ua064\ua917\u7d75\u8e4f\u2427\u8b2c\u346a2\ua7d5\ua4b0\ua063\ua913\u7d7f\u8e49\u247f\u8b6a\u346co\ua7a6\ua490\ua07f\ua913\u7d2b\u8e51\u2467"), objectArray);
        boolean bl = this.getOption(Option.DEBUG_VERBOSE);
        if (bl || this.getOption(Option.DEBUG_EXPORT) || this.getOption(Option.DEBUG_PROFILER)) {
            PrettyPrinter prettyPrinter = new PrettyPrinter(0x2140BB81 ^ 0x2140BBA1);
            Object[] objectArray2 = new Object[0xFBACE4A7 ^ 0xFBACE4A6];
            objectArray2[0x71C35A41 ^ 0x71C35A41] = bl ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ae\ua483\ua074\ua917\u7d74\u8e45\u2469\u8b32\u3437v\ua7e3\ua4b7\ua064\ua902\u7d71\u8e43\u2474\u8b30\u3437w\ua7e8\ua4b4\ua073\ua909\u7d73\u8e4e\u2433") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("");
            prettyPrinter.add(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7f6\ua4ba\ua07f\ua902\u7d73\u8e7a\u2475\u8b20\u3472`\ua7e3\ua4b1\ua031\ua928\u7d5f\u8e72\u2453\u8b19\u3432a"), objectArray2).centre().hr();
            prettyPrinter.kv(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e9\ua4b1\ua074\ua945\u7d65\u8e45\u246f\u8b25\u3474w"), string);
            prettyPrinter.kv(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a1\ua074\ua917\u7d78\u8e4b\u2476\u8b77\u3441w\ua7f4\ua4a6\ua078\ua90a\u7d78"), object);
            prettyPrinter.kv(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("X\ua7e7\ua4a3\ua070\ua945\u7d2e\u8e0a\u2449\u8b22\u3467b\ua7e9\ua4a7\ua065\ua900\u7d72"), CompatibilityLevel.JAVA_8.isSupported()).hr();
            prettyPrinter.kv(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7e3\ua4a7\ua067\ua90c\u7d75\u8e4f\u243a\u8b19\u3476\u007f\ua7e3"), string2);
            prettyPrinter.kv(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7e3\ua4a7\ua067\ua90c\u7d75\u8e4f\u243a\u8b14\u347bs\ua7f5\ua4a6"), this.service.getClass().getName()).hr();
            Option[] optionArray = Option.values();
            int n = optionArray.length;
            for (int i = 0xA4D4BCC ^ 0xA4D4BCC; i < n; ++i) {
                Option option = optionArray[i];
                StringBuilder stringBuilder = new StringBuilder();
                for (int j = 0x543714E9 ^ 0x543714E9; j < option.depth; ++j) {
                    stringBuilder.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("?\ua7a6"));
                }
                Object[] objectArray3 = new Object[0x15583866 ^ 0x15583864];
                objectArray3[0xD703C46E ^ 0xD703C46E] = stringBuilder;
                objectArray3[0x65F01A50 ^ 0x65F01A51] = option;
                prettyPrinter.kv(option.property, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4e9\ua034\ua916\u7d28"), objectArray3);
            }
            prettyPrinter.hr().kv(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("V\ua7e3\ua4a1\ua074\ua906\u7d62\u8e4f\u247e\u8b77\u3444{\ua7e2\ua4b0"), (Object)side);
            prettyPrinter.print(System.err);
        }
    }

    private String getCodeSource() {
        try {
            return this.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
        }
        catch (Throwable throwable) {
            return \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("G\ua7e8\ua4be\ua07f\ua90a\u7d61\u8e44");
        }
    }

    public Phase getPhase() {
        return this.phase;
    }

    @Deprecated
    public List<String> getMixinConfigs() {
        ArrayList arrayList = (ArrayList)GlobalProperties.get(this.configsKey);
        if (arrayList == null) {
            arrayList = new ArrayList();
            GlobalProperties.put(this.configsKey, arrayList);
        }
        return arrayList;
    }

    @Deprecated
    public MixinEnvironment addConfiguration(String string) {
        logger.warn(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("_\ua7ef\ua4ad\ua078\ua90b\u7d53\u8e44\u246c\u8b3e\u3465}\ua7e8\ua4b8\ua074\ua90b\u7d62\u8e10\u2420\u8b36\u3473v\ua7c5\ua4ba\ua07f\ua903\u7d7f\u8e4d\u246f\u8b25\u3476f\ua7ef\ua4ba\ua07f\ua945\u7d7f\u8e59\u243a\u8b33\u3472b\ua7f4\ua4b0\ua072\ua904\u7d62\u8e4f\u247e\u8b77\u3476|\ua7e2\ua4f5\ua066\ua90c\u7d7a\u8e46\u243a\u8b35\u34722\ua7f4\ua4b0\ua07c\ua90a\u7d60\u8e4f\u247e\u8b79\u3437G\ua7f5\ua4b0\ua031\ua928\u7d7f\u8e52\u2473\u8b39\u3464(\ua7bc\ua4b4\ua075\ua901\u7d55\u8e45\u2474\u8b31\u347eu\ua7f3\ua4a7\ua070\ua911\u7d7f\u8e45\u2474\u8b77\u347e|\ua7f5\ua4a1\ua074\ua904\u7d72\u8e0b"));
        Mixins.addConfiguration(string, this);
        return this;
    }

    void registerConfig(String string) {
        List<String> list = this.getMixinConfigs();
        if (!list.contains(string)) {
            list.add(string);
        }
    }

    @Deprecated
    public MixinEnvironment registerErrorHandlerClass(String string) {
        Mixins.registerErrorHandlerClass(string);
        return this;
    }

    public MixinEnvironment registerTokenProviderClass(String string) {
        if (!this.tokenProviderClasses.contains(string)) {
            try {
                Class<?> clazz = this.service.getClassProvider().findClass(string, (0x3A2C78BE ^ 0x3A2C78BF) != 0);
                IEnvironmentTokenProvider iEnvironmentTokenProvider = (IEnvironmentTokenProvider)clazz.newInstance();
                this.registerTokenProvider(iEnvironmentTokenProvider);
            }
            catch (Throwable throwable) {
                logger.error(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("W\ua7f4\ua4a7\ua07e\ua917\u7d36\u8e43\u2474\u8b24\u3463s\ua7e8\ua4a1\ua078\ua904\u7d62\u8e43\u2474\u8b30\u3437") + string, throwable);
            }
        }
        return this;
    }

    public MixinEnvironment registerTokenProvider(IEnvironmentTokenProvider iEnvironmentTokenProvider) {
        if (iEnvironmentTokenProvider != null && !this.tokenProviderClasses.contains(iEnvironmentTokenProvider.getClass().getName())) {
            String string = iEnvironmentTokenProvider.getClass().getName();
            TokenProviderWrapper tokenProviderWrapper = new TokenProviderWrapper(iEnvironmentTokenProvider, this);
            Object[] objectArray = new Object[0x1A1A3F68 ^ 0x1A1A3F6A];
            objectArray[0xA600B736 ^ 0xA600B736] = string;
            objectArray[0xEE88C130 ^ 0xEE88C131] = this;
            logger.info(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("S\ua7e2\ua4b1\ua078\ua90b\u7d71\u8e0a\u2474\u8b32\u34602\ua7f2\ua4ba\ua07a\ua900\u7d78\u8e0a\u246a\u8b25\u3478d\ua7ef\ua4b1\ua074\ua917\u7d36\u8e51\u2467\u8b77\u3463}\ua7a6\ua4ae\ua06c"), objectArray);
            this.tokenProviders.add(tokenProviderWrapper);
            this.tokenProviderClasses.add(string);
            Collections.sort(this.tokenProviders);
        }
        return this;
    }

    @Override
    public Integer getToken(String string) {
        string = string.toUpperCase();
        for (TokenProviderWrapper tokenProviderWrapper : this.tokenProviders) {
            Integer n = tokenProviderWrapper.getToken(string);
            if (n == null) continue;
            return n;
        }
        return this.internalTokens.get(string);
    }

    @Deprecated
    public Set<String> getErrorHandlerClasses() {
        return Mixins.getErrorHandlerClasses();
    }

    public Object getActiveTransformer() {
        return GlobalProperties.get(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b\u7d38\u8e5e\u2468\u8b36\u3479a\ua7e0\ua4ba\ua063\ua908\u7d73\u8e58"));
    }

    public void setActiveTransformer(ITransformer iTransformer) {
        if (iTransformer != null) {
            GlobalProperties.put(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b\u7d38\u8e5e\u2468\u8b36\u3479a\ua7e0\ua4ba\ua063\ua908\u7d73\u8e58"), iTransformer);
        }
    }

    public MixinEnvironment setSide(Side side) {
        if (side != null && this.getSide() == Side.UNKNOWN && side != Side.UNKNOWN) {
            this.side = side;
        }
        return this;
    }

    public Side getSide() {
        if (this.side == null) {
            Side[] sideArray = Side.values();
            int n = sideArray.length;
            for (int i = 0xB8F53F31 ^ 0xB8F53F31; i < n; ++i) {
                Side side = sideArray[i];
                if (!side.detect()) continue;
                this.side = side;
                break;
            }
        }
        return this.side != null ? this.side : Side.UNKNOWN;
    }

    public String getVersion() {
        return (String)GlobalProperties.get(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b\u7d38\u8e43\u2474\u8b3e\u3463{\ua7e7\ua4b9\ua078\ua916\u7d73\u8e4e"));
    }

    public boolean getOption(Option option) {
        return this.options[option.ordinal()];
    }

    public void setOption(Option option, boolean bl) {
        this.options[option.ordinal()] = bl;
    }

    public String getOptionValue(Option option) {
        return option.getStringValue();
    }

    public <E extends Enum<E>> E getOption(Option option, E e) {
        return option.getEnumValue(e);
    }

    public void setObfuscationContext(String string) {
        this.obfuscationContext = string;
    }

    public String getObfuscationContext() {
        return this.obfuscationContext;
    }

    public String getRefmapObfuscationContext() {
        String string = Option.OBFUSCATION_TYPE.getStringValue();
        if (string != null) {
            return string;
        }
        return this.obfuscationContext;
    }

    public RemapperChain getRemappers() {
        return this.remappers;
    }

    public void audit() {
        Object object = this.getActiveTransformer();
        if (object instanceof MixinTransformer) {
            MixinTransformer mixinTransformer = (MixinTransformer)object;
            mixinTransformer.audit(this);
        }
    }

    public List<ILegacyClassTransformer> getTransformers() {
        if (this.transformers == null) {
            this.buildTransformerDelegationList();
        }
        return Collections.unmodifiableList(this.transformers);
    }

    public void addTransformerExclusion(String string) {
        excludeTransformers.add(string);
        this.transformers = null;
    }

    private void buildTransformerDelegationList() {
        logger.debug(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7e3\ua4b7\ua064\ua90c\u7d7a\u8e4e\u2473\u8b39\u34702\ua7f2\ua4a7\ua070\ua90b\u7d65\u8e4c\u2475\u8b25\u347aw\ua7f4\ua4f5\ua075\ua900\u7d7a\u8e4f\u247d\u8b36\u3463{\ua7e9\ua4bb\ua031\ua909\u7d7f\u8e59\u246e\u8b6d"));
        this.transformers = new ArrayList<ILegacyClassTransformer>();
        for (ITransformer iTransformer : this.service.getTransformers()) {
            if (!(iTransformer instanceof ILegacyClassTransformer)) continue;
            ILegacyClassTransformer iLegacyClassTransformer = (ILegacyClassTransformer)iTransformer;
            String string = iLegacyClassTransformer.getName();
            int n = 0x3F7663E ^ 0x3F7663F;
            for (String string2 : excludeTransformers) {
                if (!string.contains(string2)) continue;
                n = 0x13BAA430 ^ 0x13BAA430;
                break;
            }
            if (n != 0 && !iLegacyClassTransformer.isDelegationExcluded()) {
                Object[] objectArray = new Object[0x5C0A6272 ^ 0x5C0A6273];
                objectArray[0xF59DA94A ^ 0xF59DA94A] = string;
                logger.debug(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7a6\ua494\ua075\ua901\u7d7f\u8e44\u247d\u8b6d\u34372\ua7a6\ua4f5\ua06a\ua918"), objectArray);
                this.transformers.add(iLegacyClassTransformer);
                continue;
            }
            Object[] objectArray = new Object[0x128012E3 ^ 0x128012E2];
            objectArray[0xA86546F ^ 0xA86546F] = string;
            logger.debug(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7a6\ua490\ua069\ua906\u7d7a\u8e5f\u247e\u8b3e\u3479u\ua7bc\ua4f5\ua06a\ua918"), objectArray);
        }
        Object[] objectArray = new Object[0x55D9A477 ^ 0x55D9A476];
        objectArray[0x48D25702 ^ 0x48D25702] = this.transformers.size();
        logger.debug(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F\ua7f4\ua4b4\ua07f\ua916\u7d70\u8e45\u2468\u8b3a\u3472`\ua7a6\ua4b1\ua074\ua909\u7d73\u8e4d\u247b\u8b23\u347e}\ua7e8\ua4f5\ua07d\ua90c\u7d65\u8e5e\u243a\u8b34\u3465w\ua7e7\ua4a1\ua074\ua901\u7d36\u8e5d\u2473\u8b23\u347f2\ua7fd\ua4a8\ua031\ua900\u7d78\u8e5e\u2468\u8b3e\u3472a"), objectArray);
    }

    public String toString() {
        Object[] objectArray = new Object[0x1FC4E6CA ^ 0x1FC4E6C8];
        objectArray[0x2D463577 ^ 0x2D463577] = this.getClass().getSimpleName();
        objectArray[0x793C5AEA ^ 0x793C5AEB] = this.phase;
        return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua48e\ua034\ua916\u7d4b"), objectArray);
    }

    private static Phase getCurrentPhase() {
        if (currentPhase == Phase.NOT_INITIALISED) {
            MixinEnvironment.init(Phase.PREINIT);
        }
        return currentPhase;
    }

    public static void init(Phase phase) {
        if (currentPhase == Phase.NOT_INITIALISED) {
            currentPhase = phase;
            MixinEnvironment mixinEnvironment = MixinEnvironment.getEnvironment(phase);
            MixinEnvironment.getProfiler().setActive(mixinEnvironment.getOption(Option.DEBUG_PROFILER));
            MixinLogWatcher.begin();
        }
    }

    public static MixinEnvironment getEnvironment(Phase phase) {
        if (phase == null) {
            return Phase.DEFAULT.getEnvironment();
        }
        return phase.getEnvironment();
    }

    public static MixinEnvironment getDefaultEnvironment() {
        return MixinEnvironment.getEnvironment(Phase.DEFAULT);
    }

    public static MixinEnvironment getCurrentEnvironment() {
        if (currentEnvironment == null) {
            currentEnvironment = MixinEnvironment.getEnvironment(MixinEnvironment.getCurrentPhase());
        }
        return currentEnvironment;
    }

    public static CompatibilityLevel getCompatibilityLevel() {
        return compatibility;
    }

    @Deprecated
    public static void setCompatibilityLevel(CompatibilityLevel compatibilityLevel) throws IllegalArgumentException {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (!\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("}\ua7f4\ua4b2\ua03f\ua916\u7d66\u8e45\u2474\u8b30\u3472b\ua7e9\ua4a2\ua074\ua917\u7d73\u8e4e\u2434\u8b36\u3464\u007f\ua7a8\ua4b8\ua078\ua91d\u7d7f\u8e44\u2434\u8b23\u3465s\ua7e8\ua4a6\ua077\ua90a\u7d64\u8e47\u247f\u8b25\u3439_\ua7ef\ua4ad\ua078\ua90b\u7d55\u8e45\u2474\u8b31\u347eu").equals(stackTraceElementArray[0xC0E954B1 ^ 0xC0E954B3].getClassName())) {
            logger.warn(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("_\ua7ef\ua4ad\ua078\ua90b\u7d53\u8e44\u246c\u8b3e\u3465}\ua7e8\ua4b8\ua074\ua90b\u7d62\u8e10\u2420\u8b24\u3472f\ua7c5\ua4ba\ua07c\ua915\u7d77\u8e5e\u2473\u8b35\u347e~\ua7ef\ua4a1\ua068\ua929\u7d73\u8e5c\u247f\u8b3b\u3437{\ua7f5\ua4f5\ua075\ua900\u7d66\u8e58\u247f\u8b34\u3476f\ua7e3\ua4b1\ua031\ua904\u7d78\u8e4e\u243a\u8b20\u347e~\ua7ea\ua4f5\ua073\ua900\u7d36\u8e58\u247f\u8b3a\u3478d\ua7e3\ua4b1\ua03f\ua945\u7d45\u8e4f\u246e\u8b77\u347bw\ua7f0\ua4b0\ua07d\ua945\u7d60\u8e43\u247b\u8b77\u3474}\ua7e8\ua4b3\ua078\ua902\u7d36\u8e43\u2474\u8b24\u3463w\ua7e7\ua4b1\ua030"));
        }
        if (compatibilityLevel != compatibility && compatibilityLevel.isAtLeast(compatibility)) {
            if (!compatibilityLevel.isSupported()) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F\ua7ee\ua4b0\ua031\ua917\u7d73\u8e5b\u246f\u8b32\u3464f\ua7e3\ua4b1\ua031\ua906\u7d79\u8e47\u246a\u8b36\u3463{\ua7e4\ua4bc\ua07d\ua90c\u7d62\u8e53\u243a\u8b3b\u3472d\ua7e3\ua4b9\ua031") + (Object)((Object)compatibilityLevel) + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e5\ua4ba\ua064\ua909\u7d72\u8e0a\u2474\u8b38\u34632\ua7e4\ua4b0\ua031\ua916\u7d73\u8e5e\u2434\u8b77\u345bw\ua7f0\ua4b0\ua07d\ua945\u7d7f\u8e59\u243a\u8b39\u3478f\ua7a6\ua4a6\ua064\ua915\u7d66\u8e45\u2468\u8b23\u3472v"));
            }
            compatibility = compatibilityLevel;
            Object[] objectArray = new Object[0x350A4B16 ^ 0x350A4B17];
            objectArray[0x982AB681 ^ 0x982AB681] = compatibilityLevel;
            logger.info(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e9\ua4b8\ua061\ua904\u7d62\u8e43\u2478\u8b3e\u347b{\ua7f2\ua4ac\ua031\ua909\u7d73\u8e5c\u247f\u8b3b\u3437a\ua7e3\ua4a1\ua031\ua911\u7d79\u8e0a\u2461\u8b2a"), objectArray);
        }
    }

    public static Profiler getProfiler() {
        return profiler;
    }

    static void gotoPhase(Phase phase) {
        if (phase == null || phase.ordinal < 0) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u247d\u8b38\u3437f\ua7e9\ua4f5\ua065\ua90d\u7d73\u8e0a\u2469\u8b27\u3472q\ua7ef\ua4b3\ua078\ua900\u7d72\u8e0a\u246a\u8b3f\u3476a\ua7e3\ua4f9\ua031\ua915\u7d7e\u8e4b\u2469\u8b32\u3437{\ua7f5\ua4f5\ua07f\ua910\u7d7a\u8e46\u243a\u8b38\u34652\ua7ef\ua4bb\ua067\ua904\u7d7a\u8e43\u247e"));
        }
        if (phase.ordinal > MixinEnvironment.getCurrentPhase().ordinal) {
            MixinService.getService().beginPhase();
        }
        if (phase == Phase.DEFAULT) {
            MixinLogWatcher.end();
        }
        currentPhase = phase;
        currentEnvironment = MixinEnvironment.getEnvironment(MixinEnvironment.getCurrentPhase());
    }

    static {
        Object[] objectArray = new String[0xCBDB22B9 ^ 0xCBDB22BD];
        objectArray[0x3103B27A ^ 0x3103B27A] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("|\ua7e3\ua4a1\ua03f\ua908\u7d7f\u8e44\u247f\u8b34\u3465s\ua7e0\ua4a1\ua077\ua90a\u7d64\u8e4d\u247f\u8b79\u3471\u007f\ua7ea\ua4fb\ua072\ua90a\u7d7b\u8e47\u2475\u8b39\u3439s\ua7f5\ua4b8\ua03f\ua911\u7d64\u8e4b\u2474\u8b24\u3471}\ua7f4\ua4b8\ua074\ua917\u7d65\u8e04\u245f\u8b21\u3472|\ua7f2\ua486\ua064\ua907\u7d65\u8e49\u2468\u8b3e\u3467f\ua7ef\ua4ba\ua07f\ua931\u7d64\u8e4b\u2474\u8b24\u3471}\ua7f4\ua4b8\ua074\ua917");
        objectArray[0x4BACD3A3 ^ 0x4BACD3A2] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("q\ua7f6\ua4a2\ua03f\ua908\u7d79\u8e4e\u2469\u8b79\u3471\u007f\ua7ea\ua4fb\ua072\ua90a\u7d7b\u8e47\u2475\u8b39\u3439s\ua7f5\ua4b8\ua03f\ua911\u7d64\u8e4b\u2474\u8b24\u3471}\ua7f4\ua4b8\ua074\ua917\u7d65\u8e04\u245f\u8b21\u3472|\ua7f2\ua486\ua064\ua907\u7d65\u8e49\u2468\u8b3e\u3467f\ua7ef\ua4ba\ua07f\ua931\u7d64\u8e4b\u2474\u8b24\u3471}\ua7f4\ua4b8\ua074\ua917");
        objectArray[0x59D7D1F ^ 0x59D7D1D] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("|\ua7e3\ua4a1\ua03f\ua908\u7d7f\u8e44\u247f\u8b34\u3465s\ua7e0\ua4a1\ua077\ua90a\u7d64\u8e4d\u247f\u8b79\u3471\u007f\ua7ea\ua4fb\ua072\ua90a\u7d7b\u8e47\u2475\u8b39\u3439s\ua7f5\ua4b8\ua03f\ua911\u7d64\u8e4b\u2474\u8b24\u3471}\ua7f4\ua4b8\ua074\ua917\u7d65\u8e04\u244e\u8b32\u3465\u007f\ua7ef\ua4bb\ua070\ua909\u7d42\u8e58\u247b\u8b39\u3464t\ua7e9\ua4a7\ua07c\ua900\u7d64");
        objectArray[0x27BC23E5 ^ 0x27BC23E6] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("q\ua7f6\ua4a2\ua03f\ua908\u7d79\u8e4e\u2469\u8b79\u3471\u007f\ua7ea\ua4fb\ua072\ua90a\u7d7b\u8e47\u2475\u8b39\u3439s\ua7f5\ua4b8\ua03f\ua911\u7d64\u8e4b\u2474\u8b24\u3471}\ua7f4\ua4b8\ua074\ua917\u7d65\u8e04\u244e\u8b32\u3465\u007f\ua7ef\ua4bb\ua070\ua909\u7d42\u8e58\u247b\u8b39\u3464t\ua7e9\ua4a7\ua07c\ua900\u7d64");
        excludeTransformers = Sets.newHashSet((Object[])objectArray);
        currentPhase = Phase.NOT_INITIALISED;
        compatibility = Option.DEFAULT_COMPATIBILITY_LEVEL.getEnumValue(CompatibilityLevel.JAVA_6);
        showHeader = 0x3FCD9A3A ^ 0x3FCD9A3B;
        logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b"));
        profiler = new Profiler();
    }

    static class MixinLogWatcher {
        static MixinAppender appender = new MixinAppender();
        static org.apache.logging.log4j.core.Logger log;
        static Level oldLevel;

        MixinLogWatcher() {
        }

        static void begin() {
            Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("T\ua7cb\ua499"));
            if (!(logger instanceof org.apache.logging.log4j.core.Logger)) {
                return;
            }
            log = (org.apache.logging.log4j.core.Logger)logger;
            oldLevel = log.getLevel();
            appender.start();
            log.addAppender((Appender)appender);
            log.setLevel(Level.ALL);
        }

        static void end() {
            if (log != null) {
                log.removeAppender((Appender)appender);
            }
        }

        static {
            oldLevel = null;
        }

        static class MixinAppender
        extends AbstractAppender {
            MixinAppender() {
                super(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("_\ua7ef\ua4ad\ua078\ua90b\u7d5a\u8e45\u247d\u8b00\u3476f\ua7e5\ua4bd\ua074\ua917\u7d57\u8e5a\u246a\u8b32\u3479v\ua7e3\ua4a7"), null, null);
            }

            public void append(LogEvent logEvent) {
                if (logEvent.getLevel() != Level.DEBUG || !\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("D\ua7e7\ua4b9\ua078\ua901\u7d77\u8e5e\u2473\u8b39\u34702\ua7eb\ua4bc\ua07f\ua900\u7d75\u8e58\u247b\u8b31\u3463").equals(logEvent.getMessage().getFormattedMessage())) {
                    return;
                }
                MixinEnvironment.gotoPhase(Phase.INIT);
                if (log.getLevel() == Level.ALL) {
                    log.setLevel(oldLevel);
                }
            }
        }
    }

    static class TokenProviderWrapper
    implements Comparable<TokenProviderWrapper> {
        private static int nextOrder = 0x57EB81FF ^ 0x57EB81FF;
        private final int priority;
        private final int order;
        private final IEnvironmentTokenProvider provider;
        private final MixinEnvironment environment;

        public TokenProviderWrapper(IEnvironmentTokenProvider iEnvironmentTokenProvider, MixinEnvironment mixinEnvironment) {
            this.provider = iEnvironmentTokenProvider;
            this.environment = mixinEnvironment;
            int n = nextOrder;
            nextOrder = n + (0xA305727D ^ 0xA305727C);
            this.order = n;
            this.priority = iEnvironmentTokenProvider.getPriority();
        }

        @Override
        public int compareTo(TokenProviderWrapper tokenProviderWrapper) {
            if (tokenProviderWrapper == null) {
                return 0x78A0E329 ^ 0x78A0E329;
            }
            if (tokenProviderWrapper.priority == this.priority) {
                return tokenProviderWrapper.order - this.order;
            }
            return tokenProviderWrapper.priority - this.priority;
        }

        public IEnvironmentTokenProvider getProvider() {
            return this.provider;
        }

        Integer getToken(String string) {
            return this.provider.getToken(string, this.environment);
        }
    }

    public static class CompatibilityLevel
    extends Enum<CompatibilityLevel> {
        public static final /* enum */ CompatibilityLevel JAVA_6 = new CompatibilityLevel(0xA3D82A51 ^ 0xA3D82A57, 0x27E53BFA ^ 0x27E53BC8, (0x7C00AB27 ^ 0x7C00AB27) != 0);
        public static final /* enum */ CompatibilityLevel JAVA_7 = new CompatibilityLevel(0xE80331FD ^ 0xE80331FA, 0x186557D2 ^ 0x186557E1, (0x8BE442F8 ^ 0x8BE442F8) != 0){

            @Override
            boolean isSupported() {
                return (JavaVersion.current() >= 1.7 ? 0x9A896B29 ^ 0x9A896B28 : 0x5E712D0F ^ 0x5E712D0F) != 0;
            }
        };
        public static final /* enum */ CompatibilityLevel JAVA_8 = new CompatibilityLevel(0xA418D8F6 ^ 0xA418D8FE, 0xFD1894E0 ^ 0xFD1894D4, (0xFA396A30 ^ 0xFA396A31) != 0){

            @Override
            boolean isSupported() {
                return (JavaVersion.current() >= 1.8 ? 0x612B59A0 ^ 0x612B59A1 : 0x1AFD9A6F ^ 0x1AFD9A6F) != 0;
            }
        };
        public static final /* enum */ CompatibilityLevel JAVA_9 = new CompatibilityLevel(0xD37831DA ^ 0xD37831D3, 0x8B5EFBBB ^ 0x8B5EFB8E, (0x3B128F5C ^ 0x3B128F5D) != 0){

            @Override
            boolean isSupported() {
                return (0x364A3975 ^ 0x364A3975) != 0;
            }
        };
        private static final int CLASS_V1_9 = 53;
        private final int ver;
        private final int classVersion;
        private final boolean supportsMethodsInInterfaces;
        private CompatibilityLevel maxCompatibleLevel;
        private static final /* synthetic */ CompatibilityLevel[] $VALUES;

        public static CompatibilityLevel[] values() {
            return (CompatibilityLevel[])$VALUES.clone();
        }

        public static CompatibilityLevel valueOf(String string) {
            return Enum.valueOf(CompatibilityLevel.class, string);
        }

        private CompatibilityLevel(int n2, int n3, boolean bl) {
            this.ver = n2;
            this.classVersion = n3;
            this.supportsMethodsInInterfaces = bl;
        }

        private void setMaxCompatibleLevel(CompatibilityLevel compatibilityLevel) {
            this.maxCompatibleLevel = compatibilityLevel;
        }

        boolean isSupported() {
            return (0x9E1AE465 ^ 0x9E1AE464) != 0;
        }

        public int classVersion() {
            return this.classVersion;
        }

        public boolean supportsMethodsInInterfaces() {
            return this.supportsMethodsInInterfaces;
        }

        public boolean isAtLeast(CompatibilityLevel compatibilityLevel) {
            return (compatibilityLevel == null || this.ver >= compatibilityLevel.ver ? 0x4233609E ^ 0x4233609F : 0x3D7D5453 ^ 0x3D7D5453) != 0;
        }

        public boolean canElevateTo(CompatibilityLevel compatibilityLevel) {
            if (compatibilityLevel == null || this.maxCompatibleLevel == null) {
                return (0x45B44F0C ^ 0x45B44F0D) != 0;
            }
            return (compatibilityLevel.ver <= this.maxCompatibleLevel.ver ? 0xAD7A2841 ^ 0xAD7A2840 : 0x473090BA ^ 0x473090BA) != 0;
        }

        public boolean canSupport(CompatibilityLevel compatibilityLevel) {
            if (compatibilityLevel == null) {
                return (0x4725AC5B ^ 0x4725AC5A) != 0;
            }
            return compatibilityLevel.canElevateTo(this);
        }

        static {
            CompatibilityLevel[] compatibilityLevelArray = new CompatibilityLevel[0xE0BEC37D ^ 0xE0BEC379];
            compatibilityLevelArray[0x2B3E36A7 ^ 0x2B3E36A7] = JAVA_6;
            compatibilityLevelArray[0x6D46C823 ^ 0x6D46C822] = JAVA_7;
            compatibilityLevelArray[0x6969787E ^ 0x6969787C] = JAVA_8;
            compatibilityLevelArray[0xBB6FE415 ^ 0xBB6FE416] = JAVA_9;
            $VALUES = compatibilityLevelArray;
        }
    }

    public static final class Option
    extends Enum<Option> {
        public static final /* enum */ Option DEBUG_ALL = new Option(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("v\ua7e3\ua4b7\ua064\ua902"));
        public static final /* enum */ Option DEBUG_EXPORT = new Option(DEBUG_ALL, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("w\ua7fe\ua4a5\ua07e\ua917\u7d62"));
        public static final /* enum */ Option DEBUG_EXPORT_FILTER = new Option(DEBUG_EXPORT, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("t\ua7ef\ua4b9\ua065\ua900\u7d64"), (0xE89AF84A ^ 0xE89AF84A) != 0);
        public static final /* enum */ Option DEBUG_EXPORT_DECOMPILE = new Option(DEBUG_EXPORT, Inherit.ALLOW_OVERRIDE, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("v\ua7e3\ua4b6\ua07e\ua908\u7d66\u8e43\u2476\u8b32"));
        public static final /* enum */ Option DEBUG_EXPORT_DECOMPILE_THREADED = new Option(DEBUG_EXPORT_DECOMPILE, Inherit.ALLOW_OVERRIDE, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("s\ua7f5\ua4ac\ua07f\ua906"));
        public static final /* enum */ Option DEBUG_EXPORT_DECOMPILE_MERGESIGNATURES = new Option(DEBUG_EXPORT_DECOMPILE, Inherit.ALLOW_OVERRIDE, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7e3\ua4a7\ua076\ua900\u7d51\u8e4f\u2474\u8b32\u3465{\ua7e5\ua486\ua078\ua902\u7d78\u8e4b\u246e\u8b22\u3465w\ua7f5"));
        public static final /* enum */ Option DEBUG_VERIFY = new Option(DEBUG_ALL, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("d\ua7e3\ua4a7\ua078\ua903\u7d6f"));
        public static final /* enum */ Option DEBUG_VERBOSE = new Option(DEBUG_ALL, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("d\ua7e3\ua4a7\ua073\ua90a\u7d65\u8e4f"));
        public static final /* enum */ Option DEBUG_INJECTORS = new Option(DEBUG_ALL, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("q\ua7e9\ua4a0\ua07f\ua911\u7d5f\u8e44\u2470\u8b32\u3474f\ua7ef\ua4ba\ua07f\ua916"));
        public static final /* enum */ Option DEBUG_STRICT = new Option(DEBUG_ALL, Inherit.INDEPENDENT, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a\ua7f2\ua4a7\ua078\ua906\u7d62"));
        public static final /* enum */ Option DEBUG_UNIQUE = new Option(DEBUG_STRICT, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("g\ua7e8\ua4bc\ua060\ua910\u7d73"));
        public static final /* enum */ Option DEBUG_TARGETS = new Option(DEBUG_STRICT, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("f\ua7e7\ua4a7\ua076\ua900\u7d62\u8e59"));
        public static final /* enum */ Option DEBUG_PROFILER = new Option(DEBUG_ALL, Inherit.ALLOW_OVERRIDE, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("b\ua7f4\ua4ba\ua077\ua90c\u7d7a\u8e4f\u2468"));
        public static final /* enum */ Option DUMP_TARGET_ON_FAILURE = new Option(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("v\ua7f3\ua4b8\ua061\ua931\u7d77\u8e58\u247d\u8b32\u3463]\ua7e8\ua493\ua070\ua90c\u7d7a\u8e5f\u2468\u8b32"));
        public static final /* enum */ Option CHECK_ALL = new Option(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("q\ua7ee\ua4b0\ua072\ua90e\u7d65"));
        public static final /* enum */ Option CHECK_IMPLEMENTS = new Option(CHECK_ALL, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("{\ua7e8\ua4a1\ua074\ua917\u7d70\u8e4b\u2479\u8b32\u3464"));
        public static final /* enum */ Option CHECK_IMPLEMENTS_STRICT = new Option(CHECK_IMPLEMENTS, Inherit.ALLOW_OVERRIDE, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a\ua7f2\ua4a7\ua078\ua906\u7d62"));
        public static final /* enum */ Option IGNORE_CONSTRAINTS = new Option(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("{\ua7e1\ua4bb\ua07e\ua917\u7d73\u8e69\u2475\u8b39\u3464f\ua7f4\ua4b4\ua078\ua90b\u7d62\u8e59"));
        public static final /* enum */ Option HOT_SWAP = new Option(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("z\ua7e9\ua4a1\ua042\ua912\u7d77\u8e5a"));
        public static final /* enum */ Option ENVIRONMENT = new Option(Inherit.ALWAYS_FALSE, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("w\ua7e8\ua4a3"));
        public static final /* enum */ Option OBFUSCATION_TYPE = new Option(ENVIRONMENT, Inherit.ALWAYS_FALSE, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("}\ua7e4\ua4b3"));
        public static final /* enum */ Option DISABLE_REFMAP = new Option(ENVIRONMENT, Inherit.INDEPENDENT, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("v\ua7ef\ua4a6\ua070\ua907\u7d7a\u8e4f\u2448\u8b32\u3471_\ua7e7\ua4a5"));
        public static final /* enum */ Option REFMAP_REMAP = new Option(ENVIRONMENT, Inherit.INDEPENDENT, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("`\ua7e3\ua4b8\ua070\ua915\u7d44\u8e4f\u247c\u8b1a\u3476b"));
        public static final /* enum */ Option REFMAP_REMAP_RESOURCE = new Option(ENVIRONMENT, Inherit.INDEPENDENT, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("`\ua7e3\ua4b3\ua05c\ua904\u7d66\u8e78\u247f\u8b3a\u3476b\ua7f6\ua4bc\ua07f\ua902\u7d50\u8e43\u2476\u8b32"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(""));
        public static final /* enum */ Option REFMAP_REMAP_SOURCE_ENV = new Option(ENVIRONMENT, Inherit.INDEPENDENT, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("`\ua7e3\ua4b3\ua05c\ua904\u7d66\u8e78\u247f\u8b3a\u3476b\ua7f6\ua4bc\ua07f\ua902\u7d53\u8e44\u246c"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a\ua7e3\ua4b4\ua063\ua902\u7d73"));
        public static final /* enum */ Option REFMAP_REMAP_ALLOW_PERMISSIVE = new Option(ENVIRONMENT, Inherit.INDEPENDENT, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("s\ua7ea\ua4b9\ua07e\ua912\u7d46\u8e4f\u2468\u8b3a\u347ea\ua7f5\ua4bc\ua067\ua900\u7d5b\u8e4b\u246e\u8b34\u347f"), (0x8437EBA3 ^ 0x8437EBA2) != 0, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("f\ua7f4\ua4a0\ua074"));
        public static final /* enum */ Option IGNORE_REQUIRED = new Option(ENVIRONMENT, Inherit.INDEPENDENT, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("{\ua7e1\ua4bb\ua07e\ua917\u7d73\u8e78\u247f\u8b26\u3462{\ua7f4\ua4b0\ua075"));
        public static final /* enum */ Option DEFAULT_COMPATIBILITY_LEVEL = new Option(ENVIRONMENT, Inherit.INDEPENDENT, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("q\ua7e9\ua4b8\ua061\ua904\u7d62\u8e66\u247f\u8b21\u3472~"));
        public static final /* enum */ Option SHIFT_BY_VIOLATION_BEHAVIOUR = new Option(ENVIRONMENT, Inherit.INDEPENDENT, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a\ua7ee\ua4bc\ua077\ua911\u7d54\u8e53\u244c\u8b3e\u3478~\ua7e7\ua4a1\ua078\ua90a\u7d78"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("e\ua7e7\ua4a7\ua07f"));
        public static final /* enum */ Option INITIALISER_INJECTION_MODE = new Option(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("{\ua7e8\ua4bc\ua065\ua90c\u7d77\u8e46\u2473\u8b24\u3472`\ua7cf\ua4bb\ua07b\ua900\u7d75\u8e5e\u2473\u8b38\u3479_\ua7e9\ua4b1\ua074"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("v\ua7e3\ua4b3\ua070\ua910\u7d7a\u8e5e"));
        private static final String PREFIX = "mixin";
        final Option parent;
        final Inherit inheritance;
        final String property;
        final String defaultValue;
        final boolean isFlag;
        final int depth;
        private static final /* synthetic */ Option[] $VALUES;

        public static Option[] values() {
            return (Option[])$VALUES.clone();
        }

        public static Option valueOf(String string) {
            return Enum.valueOf(Option.class, string);
        }

        private Option(String string2) {
            this(null, string2, (0x236C2C60 ^ 0x236C2C61) != 0);
        }

        private Option(Inherit inherit, String string2) {
            this(null, inherit, string2, (0xE1CB4FFF ^ 0xE1CB4FFE) != 0);
        }

        private Option(String string2, boolean bl) {
            this(null, string2, bl);
        }

        private Option(String string2, String string3) {
            this(null, Inherit.INDEPENDENT, string2, (0x420A5263 ^ 0x420A5263) != 0, string3);
        }

        private Option(Option option, String string2) {
            this(option, Inherit.INHERIT, string2, (0x72004B99 ^ 0x72004B98) != 0);
        }

        private Option(Option option, Inherit inherit, String string2) {
            this(option, inherit, string2, (0xF4C50176 ^ 0xF4C50177) != 0);
        }

        private Option(Option option, String string2, boolean bl) {
            this(option, Inherit.INHERIT, string2, bl, null);
        }

        private Option(Option option, Inherit inherit, String string2, boolean bl) {
            this(option, inherit, string2, bl, null);
        }

        private Option(Option option, String string2, String string3) {
            this(option, Inherit.INHERIT, string2, (0xCEA157E ^ 0xCEA157E) != 0, string3);
        }

        private Option(Option option, Inherit inherit, String string2, String string3) {
            this(option, inherit, string2, (0x5EA0F4CD ^ 0x5EA0F4CD) != 0, string3);
        }

        private Option(Option option, Inherit inherit, String string2, boolean bl, String string3) {
            this.parent = option;
            this.inheritance = inherit;
            this.property = (option != null ? option.property : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b")) + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("<") + string2;
            this.defaultValue = string3;
            this.isFlag = bl;
            int n2 = 0x3DEB13FF ^ 0x3DEB13FF;
            while (option != null) {
                option = option.parent;
                ++n2;
            }
            this.depth = n2;
        }

        Option getParent() {
            return this.parent;
        }

        String getProperty() {
            return this.property;
        }

        public String toString() {
            return this.isFlag ? String.valueOf(this.getBooleanValue()) : this.getStringValue();
        }

        private boolean getLocalBooleanValue(boolean bl) {
            return Boolean.parseBoolean(System.getProperty(this.property, Boolean.toString(bl)));
        }

        private boolean getInheritedBooleanValue() {
            return (this.parent != null && this.parent.getBooleanValue() ? 0x82C62B6 ^ 0x82C62B7 : 0x4FCA27C6 ^ 0x4FCA27C6) != 0;
        }

        final boolean getBooleanValue() {
            if (this.inheritance == Inherit.ALWAYS_FALSE) {
                return (0xBC0BBA83 ^ 0xBC0BBA83) != 0;
            }
            boolean bl = this.getLocalBooleanValue((0x4CF75051 ^ 0x4CF75051) != 0);
            if (this.inheritance == Inherit.INDEPENDENT) {
                return bl;
            }
            int n = bl || this.getInheritedBooleanValue() ? 0x8B03A341 ^ 0x8B03A340 : 0x212682CB ^ 0x212682CB;
            return (this.inheritance == Inherit.INHERIT ? n : this.getLocalBooleanValue(n != 0)) != 0;
        }

        final String getStringValue() {
            return this.inheritance == Inherit.INDEPENDENT || this.parent == null || this.parent.getBooleanValue() ? System.getProperty(this.property, this.defaultValue) : this.defaultValue;
        }

        <E extends Enum<E>> E getEnumValue(E e) {
            String string = System.getProperty(this.property, e.name());
            try {
                return (E)Enum.valueOf(e.getClass(), string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return e;
            }
        }

        static {
            Option[] optionArray = new Option[0xC400BCD5 ^ 0xC400BCCB];
            optionArray[0x56CB8305 ^ 0x56CB8305] = DEBUG_ALL;
            optionArray[0xBA389D85 ^ 0xBA389D84] = DEBUG_EXPORT;
            optionArray[0xD8A31401 ^ 0xD8A31403] = DEBUG_EXPORT_FILTER;
            optionArray[0xDC64BAD ^ 0xDC64BAE] = DEBUG_EXPORT_DECOMPILE;
            optionArray[0x44BE5F2D ^ 0x44BE5F29] = DEBUG_EXPORT_DECOMPILE_THREADED;
            optionArray[0xB9CA613B ^ 0xB9CA613E] = DEBUG_EXPORT_DECOMPILE_MERGESIGNATURES;
            optionArray[0x87C80457 ^ 0x87C80451] = DEBUG_VERIFY;
            optionArray[0x689345B3 ^ 0x689345B4] = DEBUG_VERBOSE;
            optionArray[0xE7200DE0 ^ 0xE7200DE8] = DEBUG_INJECTORS;
            optionArray[0xD15AB0F1 ^ 0xD15AB0F8] = DEBUG_STRICT;
            optionArray[0xBFDF22D4 ^ 0xBFDF22DE] = DEBUG_UNIQUE;
            optionArray[0x36C56999 ^ 0x36C56992] = DEBUG_TARGETS;
            optionArray[0xAB219FA8 ^ 0xAB219FA4] = DEBUG_PROFILER;
            optionArray[0xB9540295 ^ 0xB9540298] = DUMP_TARGET_ON_FAILURE;
            optionArray[0x833BC041 ^ 0x833BC04F] = CHECK_ALL;
            optionArray[0x776647FC ^ 0x776647F3] = CHECK_IMPLEMENTS;
            optionArray[0x5C329EEC ^ 0x5C329EFC] = CHECK_IMPLEMENTS_STRICT;
            optionArray[0x87D28171 ^ 0x87D28160] = IGNORE_CONSTRAINTS;
            optionArray[0x48B9A4DC ^ 0x48B9A4CE] = HOT_SWAP;
            optionArray[0xE00C4398 ^ 0xE00C438B] = ENVIRONMENT;
            optionArray[0x4D1417F8 ^ 0x4D1417EC] = OBFUSCATION_TYPE;
            optionArray[0xC428A987 ^ 0xC428A992] = DISABLE_REFMAP;
            optionArray[0x29C86049 ^ 0x29C8605F] = REFMAP_REMAP;
            optionArray[0x7D534C49 ^ 0x7D534C5E] = REFMAP_REMAP_RESOURCE;
            optionArray[0x106CBA95 ^ 0x106CBA8D] = REFMAP_REMAP_SOURCE_ENV;
            optionArray[0x82A9245B ^ 0x82A92442] = REFMAP_REMAP_ALLOW_PERMISSIVE;
            optionArray[0xF961F284 ^ 0xF961F29E] = IGNORE_REQUIRED;
            optionArray[0x604C742A ^ 0x604C7431] = DEFAULT_COMPATIBILITY_LEVEL;
            optionArray[0x9E6FAE46 ^ 0x9E6FAE5A] = SHIFT_BY_VIOLATION_BEHAVIOUR;
            optionArray[0x300A2B27 ^ 0x300A2B3A] = INITIALISER_INJECTION_MODE;
            $VALUES = optionArray;
        }

        private static final class Inherit
        extends Enum<Inherit> {
            public static final /* enum */ Inherit INHERIT = new Inherit();
            public static final /* enum */ Inherit ALLOW_OVERRIDE = new Inherit();
            public static final /* enum */ Inherit INDEPENDENT = new Inherit();
            public static final /* enum */ Inherit ALWAYS_FALSE = new Inherit();
            private static final /* synthetic */ Inherit[] $VALUES;

            public static Inherit[] values() {
                return (Inherit[])$VALUES.clone();
            }

            public static Inherit valueOf(String string) {
                return Enum.valueOf(Inherit.class, string);
            }

            static {
                Inherit[] inheritArray = new Inherit[0xB9891BA ^ 0xB9891BE];
                inheritArray[0x663C4B90 ^ 0x663C4B90] = INHERIT;
                inheritArray[0x4FAC49FD ^ 0x4FAC49FC] = ALLOW_OVERRIDE;
                inheritArray[0xD1871658 ^ 0xD187165A] = INDEPENDENT;
                inheritArray[0x16D3170A ^ 0x16D31709] = ALWAYS_FALSE;
                $VALUES = inheritArray;
            }
        }
    }

    public static abstract class Side
    extends Enum<Side> {
        public static final /* enum */ Side UNKNOWN = new Side(){

            @Override
            protected boolean detect() {
                return (0xD1CE153D ^ 0xD1CE153D) != 0;
            }
        };
        public static final /* enum */ Side CLIENT = new Side(){

            @Override
            protected boolean detect() {
                String string = MixinService.getService().getSideName();
                return \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7ca\ua49c\ua054\ua92b\u7d42").equals(string);
            }
        };
        public static final /* enum */ Side SERVER = new Side(){

            @Override
            protected boolean detect() {
                String string = MixinService.getService().getSideName();
                return (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7c3\ua487\ua047\ua920\u7d44").equals(string) || \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("V\ua7c3\ua491\ua058\ua926\u7d57\u8e7e\u245f\u8b13\u3444W\ua7d4\ua483\ua054\ua937").equals(string) ? 0x36B4B1C2 ^ 0x36B4B1C3 : 0x92084954 ^ 0x92084954) != 0;
            }
        };
        private static final /* synthetic */ Side[] $VALUES;

        public static Side[] values() {
            return (Side[])$VALUES.clone();
        }

        public static Side valueOf(String string) {
            return Enum.valueOf(Side.class, string);
        }

        protected abstract boolean detect();

        static {
            Side[] sideArray = new Side[0x206FD3BA ^ 0x206FD3B9];
            sideArray[0x5DFB49F2 ^ 0x5DFB49F2] = UNKNOWN;
            sideArray[0x1AC8DA ^ 0x1AC8DB] = CLIENT;
            sideArray[0x121B7334 ^ 0x121B7336] = SERVER;
            $VALUES = sideArray;
        }
    }

    public static final class Phase {
        static final Phase NOT_INITIALISED = new Phase(0x2724DE7D ^ 0xD8DB2182, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\\\ua7c9\ua481\ua04e\ua92c\u7d58\u8e63\u244e\u8b1e\u3456^\ua7cf\ua486\ua054\ua921"));
        public static final Phase PREINIT = new Phase(0x413AD808 ^ 0x413AD808, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("B\ua7d4\ua490\ua058\ua92b\u7d5f\u8e7e"));
        public static final Phase INIT = new Phase(0x2CEEC09B ^ 0x2CEEC09A, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7c8\ua49c\ua045"));
        public static final Phase DEFAULT = new Phase(0x5CD195EB ^ 0x5CD195E9, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("V\ua7c3\ua493\ua050\ua930\u7d5a\u8e7e"));
        static final List<Phase> phases = ImmutableList.of((Object)PREINIT, (Object)INIT, (Object)DEFAULT);
        final int ordinal;
        final String name;
        private MixinEnvironment environment;

        private Phase(int n, String string) {
            this.ordinal = n;
            this.name = string;
        }

        public String toString() {
            return this.name;
        }

        public static Phase forName(String string) {
            for (Phase phase : phases) {
                if (!phase.name.equals(string)) continue;
                return phase;
            }
            return null;
        }

        MixinEnvironment getEnvironment() {
            if (this.ordinal < 0) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u247b\u8b34\u3474w\ua7f5\ua4a6\ua031\ua911\u7d7e\u8e4f\u243a\u8b19\u3458F\ua7d9\ua49c\ua05f\ua92c\u7d42\u8e63\u245b\u8b1b\u345eA\ua7c3\ua491\ua031\ua900\u7d78\u8e5c\u2473\u8b25\u3478|\ua7eb\ua4b0\ua07f\ua911"));
            }
            if (this.environment == null) {
                this.environment = new MixinEnvironment(this);
            }
            return this.environment;
        }
    }
}

