/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.gen;

import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.gen.AccessorGenerator;
import org.spongepowered.asm.mixin.gen.AccessorInfo;
import org.spongepowered.asm.util.Bytecode;

public class AccessorGeneratorMethodProxy
extends AccessorGenerator {
    private final MethodNode targetMethod;
    private final Type[] argTypes;
    private final Type returnType;
    private final boolean isInstanceMethod;

    public AccessorGeneratorMethodProxy(AccessorInfo accessorInfo) {
        super(accessorInfo);
        this.targetMethod = accessorInfo.getTargetMethod();
        this.argTypes = accessorInfo.getArgTypes();
        this.returnType = accessorInfo.getReturnType();
        this.isInstanceMethod = !Bytecode.hasFlag(this.targetMethod, 0xA8E086A2 ^ 0xA8E086AA) ? 0xE332C73E ^ 0xE332C73F : 0x294E6C90 ^ 0x294E6C90;
    }

    @Override
    public MethodNode generate() {
        int n = Bytecode.getArgsSize(this.argTypes) + this.returnType.getSize() + (this.isInstanceMethod ? 0xE60DCBD9 ^ 0xE60DCBD8 : 0x10636D97 ^ 0x10636D97);
        MethodNode methodNode = this.createMethod(n, n);
        if (this.isInstanceMethod) {
            methodNode.instructions.add(new VarInsnNode(0x48CA7A51 ^ 0x48CA7A48, 0x1DEB7B91 ^ 0x1DEB7B91));
        }
        Bytecode.loadArgs(this.argTypes, methodNode.instructions, this.isInstanceMethod ? 0x659828D2 ^ 0x659828D3 : 0xEEDA0B42 ^ 0xEEDA0B42);
        boolean bl = Bytecode.hasFlag(this.targetMethod, 0x80AAA24B ^ 0x80AAA249);
        int n2 = this.isInstanceMethod ? (bl ? 0xB1DC21E4 ^ 0xB1DC2153 : 0xE9D880AD ^ 0xE9D8801B) : 0x8BC53439 ^ 0x8BC53481;
        methodNode.instructions.add(new MethodInsnNode(n2, this.info.getClassNode().name, this.targetMethod.name, this.targetMethod.desc, (0xFAF297D1 ^ 0xFAF297D1) != 0));
        methodNode.instructions.add(new InsnNode(this.returnType.getOpcode(0xA0D9E70C ^ 0xA0D9E7A0)));
        return methodNode;
    }
}

