/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.gen;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.AccessorGenerator;
import org.spongepowered.asm.mixin.gen.AccessorGeneratorFieldGetter;
import org.spongepowered.asm.mixin.gen.AccessorGeneratorFieldSetter;
import org.spongepowered.asm.mixin.gen.AccessorGeneratorMethodProxy;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.gen.InvokerInfo;
import org.spongepowered.asm.mixin.gen.throwables.InvalidAccessorException;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.struct.SpecialMethodInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;

public class AccessorInfo
extends SpecialMethodInfo {
    protected static final Pattern PATTERN_ACCESSOR = Pattern.compile(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("L\ua7ae\ua4b2\ua074\ua911\u7d6a\u8e59\u247f\u8b23\u346b{\ua7f5\ua4a9\ua078\ua90b\u7d60\u8e45\u2471\u8b32\u346bq\ua7e7\ua4b9\ua07d\ua94c\u7d3e\u8e02\u2441\u8b16\u343aH\ua7db\ua4fc\ua039\ua94b\u7d3c\u8e15\u2433\u8b7e\u343fM\ua7da\ua4f1\ua07c\ua901\u7d38\u8e00\u2433\u8b68\u3433"));
    protected final Type[] argTypes;
    protected final Type returnType;
    protected final AccessorType type;
    private final Type targetFieldType;
    protected final MemberInfo target;
    protected FieldNode targetField;
    protected MethodNode targetMethod;

    public AccessorInfo(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        this(mixinTargetContext, methodNode, Accessor.class);
    }

    protected AccessorInfo(MixinTargetContext mixinTargetContext, MethodNode methodNode, Class<? extends Annotation> clazz) {
        super(mixinTargetContext, methodNode, Annotations.getVisible(methodNode, clazz));
        this.argTypes = Type.getArgumentTypes(methodNode.desc);
        this.returnType = Type.getReturnType(methodNode.desc);
        this.type = this.initType();
        this.targetFieldType = this.initTargetFieldType();
        this.target = this.initTarget();
    }

    protected AccessorType initType() {
        if (this.returnType.equals(Type.VOID_TYPE)) {
            return AccessorType.FIELD_SETTER;
        }
        return AccessorType.FIELD_GETTER;
    }

    protected Type initTargetFieldType() {
        switch (1.$SwitchMap$org$spongepowered$asm$mixin$gen$AccessorInfo$AccessorType[this.type.ordinal()]) {
            case 1: {
                if (this.argTypes.length > 0) {
                    throw new InvalidAccessorException((IMixinContext)this.mixin, this + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7eb\ua4a0\ua062\ua911\u7d36\u8e5e\u247b\u8b3c\u34722\ua7e3\ua4ad\ua070\ua906\u7d62\u8e46\u2463\u8b77\u34272\ua7e7\ua4a7\ua076\ua910\u7d7b\u8e4f\u2474\u8b23\u3464>\ua7a6\ua4b3\ua07e\ua910\u7d78\u8e4e\u243a") + this.argTypes.length);
                }
                return this.returnType;
            }
            case 2: {
                if (this.argTypes.length != (0x25117245 ^ 0x25117244)) {
                    throw new InvalidAccessorException((IMixinContext)this.mixin, this + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7eb\ua4a0\ua062\ua911\u7d36\u8e5e\u247b\u8b3c\u34722\ua7e3\ua4ad\ua070\ua906\u7d62\u8e46\u2463\u8b77\u34262\ua7e7\ua4a7\ua076\ua910\u7d7b\u8e4f\u2474\u8b23\u343b2\ua7e0\ua4ba\ua064\ua90b\u7d72\u8e0a") + this.argTypes.length);
                }
                return this.argTypes[0x3BCB7F80 ^ 0x3BCB7F80];
            }
        }
        throw new InvalidAccessorException((IMixinContext)this.mixin, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e9\ua4b8\ua061\ua910\u7d62\u8e4f\u247e\u8b77\u3462|\ua7f5\ua4a0\ua061\ua915\u7d79\u8e58\u246e\u8b32\u34732\ua7e7\ua4b6\ua072\ua900\u7d65\u8e59\u2475\u8b25\u3437f\ua7ff\ua4a5\ua074\ua945") + (Object)((Object)this.type) + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e0\ua4ba\ua063\ua945") + this);
    }

    protected MemberInfo initTarget() {
        MemberInfo memberInfo = new MemberInfo(this.getTargetName(), null, this.targetFieldType.getDescriptor());
        this.annotation.visit(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("f\ua7e7\ua4a7\ua076\ua900\u7d62"), memberInfo.toString());
        return memberInfo;
    }

    protected String getTargetName() {
        String string = (String)Annotations.getValue(this.annotation);
        if (Strings.isNullOrEmpty((String)string)) {
            String string2 = this.inflectTarget();
            if (string2 == null) {
                throw new InvalidAccessorException((IMixinContext)this.mixin, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("T\ua7e7\ua4bc\ua07d\ua900\u7d72\u8e0a\u246e\u8b38\u3437{\ua7e8\ua4b3\ua07d\ua900\u7d75\u8e5e\u243a\u8b23\u3476`\ua7e1\ua4b0\ua065\ua945\u7d78\u8e4b\u2477\u8b32\u3437t\ua7e9\ua4a7\ua031") + this + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(">\ua7a6\ua4a6\ua064\ua915\u7d66\u8e45\u2468\u8b23\u3472v\ua7a6\ua4a5\ua063\ua900\u7d70\u8e43\u2462\u8b32\u3464(\ua7a6\ua48e\ua076\ua900\u7d62\u8e06\u243a\u8b24\u3472f\ua7aa\ua4f5\ua078\ua916\u7d4b"));
            }
            return string2;
        }
        return MemberInfo.parse((String)string, (IMixinContext)this.mixin).name;
    }

    protected String inflectTarget() {
        return AccessorInfo.inflectTarget(this.method.name, this.type, this.toString(), this.mixin, this.mixin.getEnvironment().getOption(MixinEnvironment.Option.DEBUG_VERBOSE));
    }

    public static String inflectTarget(String string, AccessorType accessorType, String string2, IMixinContext iMixinContext, boolean bl) {
        Matcher matcher = PATTERN_ACCESSOR.matcher(string);
        if (matcher.matches()) {
            String string3 = matcher.group(0x7771515A ^ 0x7771515B);
            String string4 = matcher.group(0x32A62296 ^ 0x32A62295);
            String string5 = matcher.group(0x3BBDB1C9 ^ 0x3BBDB1CD);
            Object[] objectArray = new Object[0x8EEE81AC ^ 0x8EEE81AE];
            objectArray[0x289B2DB ^ 0x289B2DB] = AccessorInfo.toLowerCase(string4, (!AccessorInfo.isUpperCase(string5) ? 0xC363A744 ^ 0xC363A745 : 0xB6671A45 ^ 0xB6671A45) != 0);
            objectArray[0xD8FFAB61 ^ 0xD8FFAB60] = string5;
            String string6 = String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f0\ua062"), objectArray);
            if (!accessorType.isExpectedPrefix(string3) && bl) {
                Object[] objectArray2 = new Object[0x4407F5F1 ^ 0x4407F5F2];
                objectArray2[0x24DF89B1 ^ 0x24DF89B1] = string2;
                objectArray2[0x3876385F ^ 0x3876385E] = string3;
                objectArray2[0x37819435 ^ 0x37819437] = accessorType.getExpectedPrefixes();
                LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b")).warn(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("G\ua7e8\ua4b0\ua069\ua915\u7d73\u8e49\u246e\u8b32\u34732\ua7f6\ua4a7\ua074\ua903\u7d7f\u8e52\u243a\u8b31\u3478`\ua7a6\ua4ae\ua06c\ua949\u7d36\u8e4c\u2475\u8b22\u3479v\ua7a6\ua48e\ua06a\ua918\u7d4b\u8e0a\u247f\u8b2f\u3467w\ua7e5\ua4a1\ua078\ua90b\u7d71\u8e0a\u2461\u8b2a"), objectArray2);
            }
            return MemberInfo.parse((String)string6, (IMixinContext)iMixinContext).name;
        }
        return null;
    }

    public final MemberInfo getTarget() {
        return this.target;
    }

    public final Type getTargetFieldType() {
        return this.targetFieldType;
    }

    public final FieldNode getTargetField() {
        return this.targetField;
    }

    public final MethodNode getTargetMethod() {
        return this.targetMethod;
    }

    public final Type getReturnType() {
        return this.returnType;
    }

    public final Type[] getArgTypes() {
        return this.argTypes;
    }

    public String toString() {
        Object[] objectArray = new Object[0x373C3578 ^ 0x373C357D];
        objectArray[0xE1DC5E3F ^ 0xE1DC5E3F] = this.mixin.toString();
        objectArray[0xEC77A3D4 ^ 0xEC77A3D5] = Bytecode.getSimpleName(this.annotation);
        objectArray[0x990A804F ^ 0x990A804D] = this.type.toString();
        objectArray[0x3CAA7772 ^ 0x3CAA7771] = this.method.name;
        objectArray[0xF6EC42C ^ 0xF6EC428] = this.method.desc;
        return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f8\ua02f\ua925\u7d33\u8e59\u2441\u8b72\u3464O\ua7bc\ua4ef\ua034\ua916\u7d33\u8e59"), objectArray);
    }

    public void locate() {
        this.targetField = this.findTargetField();
    }

    public MethodNode generate() {
        MethodNode methodNode = this.type.getGenerator(this).generate();
        Bytecode.mergeAnnotations(this.method, methodNode);
        return methodNode;
    }

    private FieldNode findTargetField() {
        return this.findTarget(this.classNode.fields);
    }

    protected <TNode> TNode findTarget(List<TNode> list) {
        TNode TNode = null;
        ArrayList<TNode> arrayList = new ArrayList<TNode>();
        for (TNode TNode2 : list) {
            String string;
            String string2 = AccessorInfo.getNodeDesc(TNode2);
            if (string2 == null || !string2.equals(this.target.desc) || (string = AccessorInfo.getNodeName(TNode2)) == null) continue;
            if (string.equals(this.target.name)) {
                TNode = TNode2;
            }
            if (!string.equalsIgnoreCase(this.target.name)) continue;
            arrayList.add(TNode2);
        }
        if (TNode != null) {
            if (arrayList.size() > (0x8DA506A6 ^ 0x8DA506A7)) {
                Object[] objectArray = new Object[0x6C0F1310 ^ 0x6C0F1312];
                objectArray[0xAF9E7E54 ^ 0xAF9E7E54] = this;
                objectArray[0x8BE4125C ^ 0x8BE4125D] = this.target;
                LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b")).debug(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("i\ua7fb\ua4f5\ua077\ua90a\u7d63\u8e44\u247e\u8b77\u3476|\ua7a6\ua4b0\ua069\ua904\u7d75\u8e5e\u243a\u8b3a\u3476f\ua7e5\ua4bd\ua031\ua903\u7d79\u8e58\u243a\u8b2c\u346a2\ua7e4\ua4a0\ua065\ua945\u7d79\u8e5e\u2472\u8b32\u34652\ua7e5\ua4b4\ua07f\ua901\u7d7f\u8e4e\u247b\u8b23\u3472a\ua7a6\ua4a2\ua074\ua917\u7d73\u8e0a\u247c\u8b38\u3462|\ua7e2\ua4f4"), objectArray);
            }
            return TNode;
        }
        if (arrayList.size() == (0x6502949B ^ 0x6502949A)) {
            return (TNode)arrayList.get(0x5C29BB88 ^ 0x5C29BB88);
        }
        String string = arrayList.size() == 0 ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\\\ua7e9") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("_\ua7f3\ua4b9\ua065\ua90c\u7d66\u8e46\u247f");
        throw new InvalidAccessorException(this, (String)string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e5\ua4b4\ua07f\ua901\u7d7f\u8e4e\u247b\u8b23\u3472a\ua7a6\ua4a2\ua074\ua917\u7d73\u8e0a\u247c\u8b38\u3462|\ua7e2\ua4f5\ua07c\ua904\u7d62\u8e49\u2472\u8b3e\u3479u\ua7a6") + this.target + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ef\ua4bb\ua031") + this.classNode.name + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e0\ua4ba\ua063\ua945") + this);
    }

    private static <TNode> String getNodeDesc(TNode TNode) {
        return TNode instanceof MethodNode ? ((MethodNode)TNode).desc : (TNode instanceof FieldNode ? ((FieldNode)TNode).desc : null);
    }

    private static <TNode> String getNodeName(TNode TNode) {
        return TNode instanceof MethodNode ? ((MethodNode)TNode).name : (TNode instanceof FieldNode ? ((FieldNode)TNode).name : null);
    }

    public static AccessorInfo of(MixinTargetContext mixinTargetContext, MethodNode methodNode, Class<? extends Annotation> clazz) {
        if (clazz == Accessor.class) {
            return new AccessorInfo(mixinTargetContext, methodNode);
        }
        if (clazz == Invoker.class) {
            return new InvokerInfo(mixinTargetContext, methodNode);
        }
        throw new InvalidAccessorException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e9\ua4a0\ua07d\ua901\u7d36\u8e44\u2475\u8b23\u3437b\ua7e7\ua4a7\ua062\ua900\u7d36\u8e4b\u2479\u8b34\u3472a\ua7f5\ua4ba\ua063\ua945\u7d70\u8e45\u2468\u8b77\u3462|\ua7ed\ua4bb\ua07e\ua912\u7d78\u8e0a\u246e\u8b2e\u3467w\ua7a6") + clazz.getName());
    }

    private static String toLowerCase(String string, boolean bl) {
        return bl ? string.toLowerCase() : string;
    }

    private static boolean isUpperCase(String string) {
        return string.toUpperCase().equals(string);
    }

    public static abstract class AccessorType
    extends Enum<AccessorType> {
        public static final /* enum */ AccessorType FIELD_GETTER = new AccessorType((Set)ImmutableSet.of((Object)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("u\ua7e3\ua4a1"), (Object)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("{\ua7f5"))){

            @Override
            AccessorGenerator getGenerator(AccessorInfo accessorInfo) {
                return new AccessorGeneratorFieldGetter(accessorInfo);
            }
        };
        public static final /* enum */ AccessorType FIELD_SETTER = new AccessorType((Set)ImmutableSet.of((Object)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a\ua7e3\ua4a1"))){

            @Override
            AccessorGenerator getGenerator(AccessorInfo accessorInfo) {
                return new AccessorGeneratorFieldSetter(accessorInfo);
            }
        };
        public static final /* enum */ AccessorType METHOD_PROXY = new AccessorType((Set)ImmutableSet.of((Object)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("q\ua7e7\ua4b9\ua07d"), (Object)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("{\ua7e8\ua4a3\ua07e\ua90e\u7d73"))){

            @Override
            AccessorGenerator getGenerator(AccessorInfo accessorInfo) {
                return new AccessorGeneratorMethodProxy(accessorInfo);
            }
        };
        private final Set<String> expectedPrefixes;
        private static final /* synthetic */ AccessorType[] $VALUES;

        public static AccessorType[] values() {
            return (AccessorType[])$VALUES.clone();
        }

        public static AccessorType valueOf(String string) {
            return Enum.valueOf(AccessorType.class, string);
        }

        private AccessorType(Set<String> set) {
            this.expectedPrefixes = set;
        }

        public boolean isExpectedPrefix(String string) {
            return this.expectedPrefixes.contains(string);
        }

        public String getExpectedPrefixes() {
            return this.expectedPrefixes.toString();
        }

        abstract AccessorGenerator getGenerator(AccessorInfo var1);

        static {
            AccessorType[] accessorTypeArray = new AccessorType[0x1A9FB7B9 ^ 0x1A9FB7BA];
            accessorTypeArray[0xB7E12950 ^ 0xB7E12950] = FIELD_GETTER;
            accessorTypeArray[0xA9D19EBB ^ 0xA9D19EBA] = FIELD_SETTER;
            accessorTypeArray[0x68EE8F13 ^ 0x68EE8F11] = METHOD_PROXY;
            $VALUES = accessorTypeArray;
        }
    }
}

