/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.code;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.code.InjectorTarget;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.util.Bytecode;

public abstract class Injector {
    protected static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    protected InjectionInfo info;
    protected final ClassNode classNode;
    protected final MethodNode methodNode;
    protected final Type[] methodArgs;
    protected final Type returnType;
    protected final boolean isStatic;

    public Injector(InjectionInfo injectionInfo) {
        this(injectionInfo.getClassNode(), injectionInfo.getMethod());
        this.info = injectionInfo;
    }

    private Injector(ClassNode classNode, MethodNode methodNode) {
        this.classNode = classNode;
        this.methodNode = methodNode;
        this.methodArgs = Type.getArgumentTypes(this.methodNode.desc);
        this.returnType = Type.getReturnType(this.methodNode.desc);
        this.isStatic = Bytecode.methodIsStatic(this.methodNode);
    }

    public String toString() {
        Object[] objectArray = new Object[0x77F5537 ^ 0x77F5535];
        objectArray[0xF194774C ^ 0xF194774C] = this.classNode.name;
        objectArray[0x7E0DBCF4 ^ 0x7E0DBCF5] = this.methodNode.name;
        return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4ef\ua02b\ua940\u7d65"), objectArray);
    }

    public final List<InjectionNodes.InjectionNode> find(InjectorTarget injectorTarget, List<InjectionPoint> list) {
        this.sanityCheck(injectorTarget.getTarget(), list);
        ArrayList<InjectionNodes.InjectionNode> arrayList = new ArrayList<InjectionNodes.InjectionNode>();
        for (TargetNode targetNode : this.findTargetNodes(injectorTarget, list)) {
            this.addTargetNode(injectorTarget.getTarget(), arrayList, targetNode.insn, targetNode.nominators);
        }
        return arrayList;
    }

    protected void addTargetNode(Target target, List<InjectionNodes.InjectionNode> list, AbstractInsnNode abstractInsnNode, Set<InjectionPoint> set) {
        list.add(target.addInjectionNode(abstractInsnNode));
    }

    public final void inject(Target target, List<InjectionNodes.InjectionNode> list) {
        for (InjectionNodes.InjectionNode injectionNode : list) {
            if (injectionNode.isRemoved()) {
                if (!this.info.getContext().getOption(MixinEnvironment.Option.DEBUG_VERBOSE)) continue;
                Object[] objectArray = new Object[0xA729B31C ^ 0xA729B31E];
                objectArray[0xF2D0290E ^ 0xF2D0290E] = this.info;
                objectArray[0xED80ED4C ^ 0xED80ED4D] = target;
                logger.warn(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2474\u8b38\u3473w\ua7a6\ua4b3\ua07e\ua917\u7d36\u8e51\u2467\u8b77\u3460s\ua7f5\ua4f5\ua063\ua900\u7d7b\u8e45\u246c\u8b32\u34732\ua7e4\ua4ac\ua031\ua904\u7d36\u8e5a\u2468\u8b32\u3461{\ua7e9\ua4a0\ua062\ua945\u7d7f\u8e44\u2470\u8b32\u3474f\ua7e9\ua4a7\ua031\ua90c\u7d78\u8e0a\u2461\u8b2a"), objectArray);
                continue;
            }
            this.inject(target, injectionNode);
        }
        for (InjectionNodes.InjectionNode injectionNode : list) {
            this.postInject(target, injectionNode);
        }
    }

    private Collection<TargetNode> findTargetNodes(InjectorTarget injectorTarget, List<InjectionPoint> list) {
        IMixinContext iMixinContext = this.info.getContext();
        MethodNode methodNode = injectorTarget.getMethod();
        TreeMap<Integer, TargetNode> treeMap = new TreeMap<Integer, TargetNode>();
        ArrayList<AbstractInsnNode> arrayList = new ArrayList<AbstractInsnNode>(0x842F6E25 ^ 0x842F6E05);
        for (InjectionPoint injectionPoint : list) {
            arrayList.clear();
            if (injectorTarget.isMerged() && !iMixinContext.getClassName().equals(injectorTarget.getMergedBy()) && !injectionPoint.checkPriority(injectorTarget.getMergedPriority(), iMixinContext.getPriority())) {
                Object[] objectArray = new Object[0xF377151E ^ 0xF3771518];
                objectArray[0xAAC4D372 ^ 0xAAC4D372] = injectionPoint;
                objectArray[0xA0048C12 ^ 0xA0048C13] = this;
                objectArray[0x91BCA8ED ^ 0x91BCA8EF] = iMixinContext.getPriority();
                objectArray[0xA15CEBF9 ^ 0xA15CEBFA] = injectorTarget;
                objectArray[0xC3AFF634 ^ 0xC3AFF630] = injectorTarget.getMergedBy();
                objectArray[0x1610B8FB ^ 0x1610B8FE] = injectorTarget.getMergedPriority();
                throw new InvalidInjectionException(this.info, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f5\ua07e\ua90b\u7d36\u8e0f\u2469\u8b77\u3460{\ua7f2\ua4bd\ua031\ua915\u7d64\u8e43\u2475\u8b25\u347ef\ua7ff\ua4f5\ua034\ua901\u7d36\u8e49\u247b\u8b39\u3479}\ua7f2\ua4f5\ua078\ua90b\u7d7c\u8e4f\u2479\u8b23\u3437{\ua7e8\ua4a1\ua07e\ua945\u7d33\u8e59\u243a\u8b3a\u3472`\ua7e1\ua4b0\ua075\ua945\u7d74\u8e53\u243a\u8b72\u34642\ua7f1\ua4bc\ua065\ua90d\u7d36\u8e5a\u2468\u8b3e\u3478`\ua7ef\ua4a1\ua068\ua945\u7d33\u8e4e"), objectArray));
            }
            if (!this.findTargetNodes(methodNode, injectionPoint, injectorTarget.getSlice(injectionPoint), arrayList)) continue;
            for (AbstractInsnNode abstractInsnNode : arrayList) {
                Integer n = methodNode.instructions.indexOf(abstractInsnNode);
                TargetNode targetNode = (TargetNode)treeMap.get(n);
                if (targetNode == null) {
                    targetNode = new TargetNode(abstractInsnNode);
                    treeMap.put(n, targetNode);
                }
                targetNode.nominators.add(injectionPoint);
            }
        }
        return treeMap.values();
    }

    protected boolean findTargetNodes(MethodNode methodNode, InjectionPoint injectionPoint, InsnList insnList, Collection<AbstractInsnNode> collection) {
        return injectionPoint.find(methodNode.desc, insnList, collection);
    }

    protected void sanityCheck(Target target, List<InjectionPoint> list) {
        if (target.classNode != this.classNode) {
            throw new InvalidInjectionException(this.info, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2479\u8b3b\u3476a\ua7f5\ua4f5\ua075\ua90a\u7d73\u8e59\u243a\u8b39\u3478f\ua7a6\ua4b8\ua070\ua911\u7d75\u8e42\u243a\u8b3e\u3479x\ua7e3\ua4b6\ua065\ua90a\u7d64\u8e0a\u2479\u8b3b\u3476a\ua7f5\ua4f5\ua078\ua90b\u7d36") + this);
        }
    }

    protected abstract void inject(Target var1, InjectionNodes.InjectionNode var2);

    protected void postInject(Target target, InjectionNodes.InjectionNode injectionNode) {
    }

    protected AbstractInsnNode invokeHandler(InsnList insnList) {
        return this.invokeHandler(insnList, this.methodNode);
    }

    protected AbstractInsnNode invokeHandler(InsnList insnList, MethodNode methodNode) {
        int n;
        int n2 = (methodNode.access & (0xA53C86C2 ^ 0xA53C86C0)) != 0 ? 0xC37DCABD ^ 0xC37DCABC : (n = 0x2FA04F0C ^ 0x2FA04F0C);
        int n3 = this.isStatic ? 0x8AE25962 ^ 0x8AE259DA : (n != 0 ? 0xDC4F5E9E ^ 0xDC4F5E29 : 0xB1B49247 ^ 0xB1B492F1);
        MethodInsnNode methodInsnNode = new MethodInsnNode(n3, this.classNode.name, methodNode.name, methodNode.desc, (0x86F4E73 ^ 0x86F4E73) != 0);
        insnList.add(methodInsnNode);
        this.info.addCallbackInvocation(methodNode);
        return methodInsnNode;
    }

    protected void throwException(InsnList insnList, String string, String string2) {
        insnList.add(new TypeInsnNode(0xCEDBD375 ^ 0xCEDBD3CE, string));
        insnList.add(new InsnNode(0x2DB776B6 ^ 0x2DB776EF));
        insnList.add(new LdcInsnNode(string2));
        insnList.add(new MethodInsnNode(0xDBDEB4ED ^ 0xDBDEB45A, string, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(".\ua7ef\ua4bb\ua078\ua911\u7d28"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(":\ua7ca\ua4bf\ua070\ua913\u7d77\u8e05\u2476\u8b36\u3479u\ua7a9\ua486\ua065\ua917\u7d7f\u8e44\u247d\u8b6c\u343eD"), (0x55FBBAD7 ^ 0x55FBBAD7) != 0));
        insnList.add(new InsnNode(0x4FADCCE3 ^ 0x4FADCC5C));
    }

    public static boolean canCoerce(Type type, Type type2) {
        if (type.getSort() == (0xEB986514 ^ 0xEB98651E)) {
            if (type2.getSort() == (0x345C7917 ^ 0x345C791D)) {
                return Injector.canCoerce(ClassInfo.forType(type), ClassInfo.forType(type2));
            }
        }
        return Injector.canCoerce(type.getDescriptor(), type2.getDescriptor());
    }

    public static boolean canCoerce(String string, String string2) {
        block3: {
            block2: {
                if (string.length() > (0x58A12BB ^ 0x58A12BA)) break block2;
                if (string2.length() <= (0xE7A1E9B4 ^ 0xE7A1E9B5)) break block3;
            }
            return (0x7706FED ^ 0x7706FED) != 0;
        }
        return Injector.canCoerce(string.charAt(0x763B4564 ^ 0x763B4564), string2.charAt(0x7C171F6B ^ 0x7C171F6B));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean canCoerce(char c, char c2) {
        int n;
        if (c2 == (0x6328139C ^ 0x632813D5)) {
            if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7c4\ua486\ua052\ua93f").indexOf(c) > (0x1BA54052 ^ 0xE45ABFAD)) {
                n = 0x6F4D4D89 ^ 0x6F4D4D88;
                return n != 0;
            }
        }
        n = 0xEA828443 ^ 0xEA828443;
        return n != 0;
    }

    private static boolean canCoerce(ClassInfo classInfo, ClassInfo classInfo2) {
        return (classInfo != null && classInfo2 != null && (classInfo2 == classInfo || classInfo2.hasSuperClass(classInfo)) ? 0x26203CAD ^ 0x26203CAC : 0x5DD4A682 ^ 0x5DD4A682) != 0;
    }

    public static final class TargetNode {
        final AbstractInsnNode insn;
        final Set<InjectionPoint> nominators = new HashSet<InjectionPoint>();

        TargetNode(AbstractInsnNode abstractInsnNode) {
            this.insn = abstractInsnNode;
        }

        public AbstractInsnNode getNode() {
            return this.insn;
        }

        public Set<InjectionPoint> getNominators() {
            return Collections.unmodifiableSet(this.nominators);
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != TargetNode.class) {
                return (0x1996B92A ^ 0x1996B92A) != 0;
            }
            return (((TargetNode)object).insn == this.insn ? 0x1E77A963 ^ 0x1E77A962 : 0x3ABFF7C4 ^ 0x3ABFF7C4) != 0;
        }

        public int hashCode() {
            return this.insn.hashCode();
        }
    }
}

