/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.invoke.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.analysis.Analyzer;
import org.spongepowered.asm.lib.tree.analysis.AnalyzerException;
import org.spongepowered.asm.lib.tree.analysis.BasicInterpreter;
import org.spongepowered.asm.lib.tree.analysis.BasicValue;
import org.spongepowered.asm.lib.tree.analysis.Frame;
import org.spongepowered.asm.lib.tree.analysis.Interpreter;
import org.spongepowered.asm.mixin.injection.struct.Target;

public class InsnFinder {
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b"));

    public AbstractInsnNode findPopInsn(Target target, AbstractInsnNode abstractInsnNode) {
        try {
            new PopAnalyzer(abstractInsnNode).analyze(target.classNode.name, target.method);
        }
        catch (AnalyzerException analyzerException) {
            if (analyzerException.getCause() instanceof AnalysisResultException) {
                return ((AnalysisResultException)analyzerException.getCause()).getResult();
            }
            logger.catching((Throwable)analyzerException);
        }
        return null;
    }

    static class PopAnalyzer
    extends Analyzer<BasicValue> {
        protected final AbstractInsnNode node;

        public PopAnalyzer(AbstractInsnNode abstractInsnNode) {
            super(new BasicInterpreter());
            this.node = abstractInsnNode;
        }

        @Override
        protected Frame<BasicValue> newFrame(int n, int n2) {
            return new PopFrame(n, n2);
        }

        class PopFrame
        extends Frame<BasicValue> {
            private AbstractInsnNode current;
            private AnalyzerState state;
            private int depth;

            public PopFrame(int n, int n2) {
                super(n, n2);
                this.state = AnalyzerState.SEARCH;
                this.depth = 0x4866421A ^ 0x4866421A;
            }

            @Override
            public void execute(AbstractInsnNode abstractInsnNode, Interpreter<BasicValue> interpreter) throws AnalyzerException {
                this.current = abstractInsnNode;
                super.execute(abstractInsnNode, interpreter);
            }

            @Override
            public void push(BasicValue basicValue) throws IndexOutOfBoundsException {
                if (this.current == PopAnalyzer.this.node && this.state == AnalyzerState.SEARCH) {
                    this.state = AnalyzerState.ANALYSE;
                    this.depth += 0xBB88701B ^ 0xBB88701A;
                } else if (this.state == AnalyzerState.ANALYSE) {
                    this.depth += 0xEA54B64F ^ 0xEA54B64E;
                }
                super.push(basicValue);
            }

            @Override
            public BasicValue pop() throws IndexOutOfBoundsException {
                if (this.state == AnalyzerState.ANALYSE) {
                    if ((this.depth -= 0x4320FB20 ^ 0x4320FB21) == 0) {
                        this.state = AnalyzerState.COMPLETE;
                        throw new AnalysisResultException(this.current);
                    }
                }
                return (BasicValue)super.pop();
            }
        }
    }

    static final class AnalyzerState
    extends Enum<AnalyzerState> {
        public static final /* enum */ AnalyzerState SEARCH = new AnalyzerState();
        public static final /* enum */ AnalyzerState ANALYSE = new AnalyzerState();
        public static final /* enum */ AnalyzerState COMPLETE = new AnalyzerState();
        private static final /* synthetic */ AnalyzerState[] $VALUES;

        public static AnalyzerState[] values() {
            return (AnalyzerState[])$VALUES.clone();
        }

        public static AnalyzerState valueOf(String string) {
            return Enum.valueOf(AnalyzerState.class, string);
        }

        static {
            AnalyzerState[] analyzerStateArray = new AnalyzerState[0xE1CC62E5 ^ 0xE1CC62E6];
            analyzerStateArray[0x799049E4 ^ 0x799049E4] = SEARCH;
            analyzerStateArray[0xB9272B5D ^ 0xB9272B5C] = ANALYSE;
            analyzerStateArray[0x9F7E0734 ^ 0x9F7E0736] = COMPLETE;
            $VALUES = analyzerStateArray;
        }
    }

    static class AnalysisResultException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private AbstractInsnNode result;

        public AnalysisResultException(AbstractInsnNode abstractInsnNode) {
            this.result = abstractInsnNode;
        }

        public AbstractInsnNode getResult() {
            return this.result;
        }
    }
}

