/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.modify;

import java.util.Collection;
import java.util.ListIterator;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.modify.ModifyVariableInjector;
import org.spongepowered.asm.mixin.injection.struct.InjectionPointData;
import org.spongepowered.asm.mixin.injection.struct.Target;

@InjectionPoint.AtCode(value="LOAD")
public class BeforeLoadLocal
extends ModifyVariableInjector.ContextualInjectionPoint {
    private final Type returnType;
    private final LocalVariableDiscriminator discriminator;
    private final int opcode;
    private final int ordinal;
    private boolean opcodeAfter;

    protected BeforeLoadLocal(InjectionPointData injectionPointData) {
        this(injectionPointData, 0xF99BCB19 ^ 0xF99BCB0C, (0x824B599B ^ 0x824B599B) != 0);
    }

    protected BeforeLoadLocal(InjectionPointData injectionPointData, int n, boolean bl) {
        super(injectionPointData.getContext());
        this.returnType = injectionPointData.getMethodReturnType();
        this.discriminator = injectionPointData.getLocalVariableDiscriminator();
        this.opcode = injectionPointData.getOpcode(this.returnType.getOpcode(n));
        this.ordinal = injectionPointData.getOrdinal();
        this.opcodeAfter = bl;
    }

    @Override
    boolean find(Target target, Collection<AbstractInsnNode> collection) {
        SearchState searchState = new SearchState(this.ordinal, this.discriminator.printLVT());
        ListIterator<AbstractInsnNode> listIterator = target.method.instructions.iterator();
        while (listIterator.hasNext()) {
            int n;
            AbstractInsnNode abstractInsnNode = listIterator.next();
            if (searchState.isPendingCheck()) {
                n = this.discriminator.findLocal(this.returnType, this.discriminator.isArgsOnly(), target, abstractInsnNode);
                searchState.check(collection, abstractInsnNode, n);
                continue;
            }
            if (!(abstractInsnNode instanceof VarInsnNode) || abstractInsnNode.getOpcode() != this.opcode) continue;
            if (this.ordinal != (0xADAEB0DE ^ 0x52514F21) && searchState.success()) continue;
            searchState.register((VarInsnNode)abstractInsnNode);
            if (this.opcodeAfter) {
                searchState.setPendingCheck();
                continue;
            }
            n = this.discriminator.findLocal(this.returnType, this.discriminator.isArgsOnly(), target, abstractInsnNode);
            searchState.check(collection, abstractInsnNode, n);
        }
        return searchState.success();
    }

    static class SearchState {
        private final boolean print;
        private final int targetOrdinal;
        private int ordinal = 0x226D1632 ^ 0x226D1632;
        private boolean pendingCheck = 0xD30FDF93 ^ 0xD30FDF93;
        private boolean found = 0x93015197 ^ 0x93015197;
        private VarInsnNode varNode;

        SearchState(int n, boolean bl) {
            this.targetOrdinal = n;
            this.print = bl;
        }

        boolean success() {
            return this.found;
        }

        boolean isPendingCheck() {
            return this.pendingCheck;
        }

        void setPendingCheck() {
            this.pendingCheck = 0x77DECD87 ^ 0x77DECD86;
        }

        void register(VarInsnNode varInsnNode) {
            this.varNode = varInsnNode;
        }

        void check(Collection<AbstractInsnNode> collection, AbstractInsnNode abstractInsnNode, int n) {
            this.pendingCheck = 0xF6491D6C ^ 0xF6491D6C;
            if (n != this.varNode.var) {
                if (n > (0x57F448CD ^ 0xA80BB733) || !this.print) {
                    return;
                }
            }
            if (this.targetOrdinal == (0xA774AADA ^ 0x588B5525) || this.targetOrdinal == this.ordinal) {
                collection.add(abstractInsnNode);
                this.found = 0xFB90D3D2 ^ 0xFB90D3D3;
            }
            this.ordinal += 0x852A4815 ^ 0x852A4814;
            this.varNode = null;
        }
    }
}

