/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.points;

import java.util.Collection;
import java.util.ListIterator;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.points.BeforeInvoke;
import org.spongepowered.asm.mixin.injection.struct.InjectionPointData;
import org.spongepowered.asm.util.Bytecode;

@InjectionPoint.AtCode(value="FIELD")
public class BeforeFieldAccess
extends BeforeInvoke {
    private static final String ARRAY_GET = "get";
    private static final String ARRAY_SET = "set";
    private static final String ARRAY_LENGTH = "length";
    public static final int ARRAY_SEARCH_FUZZ_DEFAULT = 8;
    private final int opcode;
    private final int arrOpcode;
    private final int fuzzFactor;

    public BeforeFieldAccess(InjectionPointData injectionPointData) {
        super(injectionPointData);
        int[] nArray = new int[0xC039783B ^ 0xC039783E];
        nArray[0xF2F37413 ^ 0xF2F37413] = 0x1E47952E ^ 0x1E47959A;
        nArray[0x9FC2515B ^ 0x9FC2515A] = 0x83B29C7B ^ 0x83B29CCE;
        nArray[0xC2DD627E ^ 0xC2DD627C] = 0xBC1BD65D ^ 0xBC1BD6EF;
        nArray[0x3C7E5FFF ^ 0x3C7E5FFC] = 0x9F7C957E ^ 0x9F7C95CD;
        nArray[0xB19A572 ^ 0xB19A576] = 0xBD55BC30 ^ 0x42AA43CF;
        this.opcode = injectionPointData.getOpcode(0xF4EEE52B ^ 0xB111AD4, nArray);
        String string = injectionPointData.get(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("s\ua7f4\ua4a7\ua070\ua91c"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(""));
        this.arrOpcode = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("u\ua7e3\ua4a1").equalsIgnoreCase(string) ? 0xF3FE8EB0 ^ 0xF3FE8E9E : (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a\ua7e3\ua4a1").equalsIgnoreCase(string) ? 0x47CFCB95 ^ 0x47CFCBDA : (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("~\ua7e3\ua4bb\ua076\ua911\u7d7e").equalsIgnoreCase(string) ? 0x1B0F1AFC ^ 0x1B0F1A42 : 0x6BEA3442 ^ 0x6BEA3442));
        this.fuzzFactor = Math.min(Math.max(injectionPointData.get(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("t\ua7f3\ua4af\ua06b"), 0x6A546C23 ^ 0x6A546C2B), 0x46A940E8 ^ 0x46A940E9), 0xE2EDD59B ^ 0xE2EDD5BB);
    }

    public int getFuzzFactor() {
        return this.fuzzFactor;
    }

    public int getArrayOpcode() {
        return this.arrOpcode;
    }

    private int getArrayOpcode(String string) {
        if (this.arrOpcode != (0xA6FDA229 ^ 0xA6FDA297)) {
            return Type.getType(string).getElementType().getOpcode(this.arrOpcode);
        }
        return this.arrOpcode;
    }

    @Override
    protected boolean matchesInsn(AbstractInsnNode abstractInsnNode) {
        block6: {
            block7: {
                if (!(abstractInsnNode instanceof FieldInsnNode)) break block6;
                if (((FieldInsnNode)abstractInsnNode).getOpcode() == this.opcode) break block7;
                if (this.opcode != (0x3CD6349 ^ 0xFC329CB6)) break block6;
            }
            if (this.arrOpcode == 0) {
                return (0xF1938576 ^ 0xF1938577) != 0;
            }
            if (abstractInsnNode.getOpcode() != (0xFB925BCB ^ 0xFB925B79)) {
                if (abstractInsnNode.getOpcode() != (0xD51D336D ^ 0xD51D33D9)) {
                    return (0xA4B3B34F ^ 0xA4B3B34F) != 0;
                }
            }
            return (Type.getType(((FieldInsnNode)abstractInsnNode).desc).getSort() == (0x42EAA0FD ^ 0x42EAA0F4) ? 0x3CD53BA3 ^ 0x3CD53BA2 : 0x453D2512 ^ 0x453D2512) != 0;
        }
        return (0x3062D426 ^ 0x3062D426) != 0;
    }

    @Override
    protected boolean addInsn(InsnList insnList, Collection<AbstractInsnNode> collection, AbstractInsnNode abstractInsnNode) {
        if (this.arrOpcode > 0) {
            FieldInsnNode fieldInsnNode = (FieldInsnNode)abstractInsnNode;
            int n = this.getArrayOpcode(fieldInsnNode.desc);
            Object[] objectArray = new Object[0x3F555D1E ^ 0x3F555D1D];
            objectArray[0xCFF6756A ^ 0xCFF6756A] = this.className;
            objectArray[0xBF26643A ^ 0xBF26643B] = Bytecode.getOpcodeName(n);
            objectArray[0xC850D771 ^ 0xC850D773] = this.fuzzFactor;
            this.log(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("i\ua7fb\ua4f5\ua02f\ua945\u7d28\u8e0a\u2424\u8b77\u34292\ua7f5\ua4b0\ua070\ua917\u7d75\u8e42\u2473\u8b39\u34702\ua7e0\ua4ba\ua063\ua945\u7d77\u8e58\u2468\u8b36\u346e2\ua7e7\ua4b6\ua072\ua900\u7d65\u8e59\u243a\u8b38\u3467q\ua7e9\ua4b1\ua074\ua945\u7d6d\u8e57\u243a\u8b31\u3462h\ua7fc\ua4e8\ua06a\ua918"), objectArray);
            if (BeforeFieldAccess.findArrayNode(insnList, fieldInsnNode, n, this.fuzzFactor) == null) {
                Object[] objectArray2 = new Object[0xCE29E795 ^ 0xCE29E794];
                objectArray2[0x507D5231 ^ 0x507D5231] = this.className;
                this.log(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("i\ua7fb\ua4f5\ua02f\ua945\u7d28\u8e0a\u2424\u8b77\u34292\ua7b8\ua4f5\ua077\ua904\u7d7f\u8e46\u247f\u8b33\u3437f\ua7e9\ua4f5\ua07d\ua90a\u7d75\u8e4b\u246e\u8b32\u3437\u007f\ua7e7\ua4a1\ua072\ua90d\u7d7f\u8e44\u247d\u8b77\u347e|\ua7f5\ua4bb"), objectArray2);
                return (0x61E0A35B ^ 0x61E0A35B) != 0;
            }
        }
        Object[] objectArray = new Object[0x91537BD8 ^ 0x91537BD9];
        objectArray[0xF4ADBFC ^ 0xF4ADBFC] = this.className;
        this.log(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("i\ua7fb\ua4f5\ua02f\ua945\u7d28\u8e0a\u2424\u8b77\u34292\ua7b8\ua4f5\ua070\ua901\u7d72\u8e43\u2474\u8b30\u3437\u007f\ua7e7\ua4a1\ua072\ua90d\u7d7f\u8e44\u247d\u8b77\u347e|\ua7f5\ua4bb"), objectArray);
        return super.addInsn(insnList, collection, abstractInsnNode);
    }

    public static AbstractInsnNode findArrayNode(InsnList insnList, FieldInsnNode fieldInsnNode, int n, int n2) {
        int n3 = 0xC207442C ^ 0xC207442C;
        ListIterator<AbstractInsnNode> listIterator = insnList.iterator(insnList.indexOf(fieldInsnNode) + (0xB7E4B144 ^ 0xB7E4B145));
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (abstractInsnNode.getOpcode() == n) {
                return abstractInsnNode;
            }
            if (abstractInsnNode.getOpcode() == (0xB430A31E ^ 0xB430A3A0) && n3 == 0) {
                return null;
            }
            if (abstractInsnNode instanceof FieldInsnNode) {
                FieldInsnNode fieldInsnNode2 = (FieldInsnNode)abstractInsnNode;
                if (fieldInsnNode2.desc.equals(fieldInsnNode.desc) && fieldInsnNode2.name.equals(fieldInsnNode.name) && fieldInsnNode2.owner.equals(fieldInsnNode.owner)) {
                    return null;
                }
            }
            if (n3++ <= n2) continue;
            return null;
        }
        return null;
    }
}

