/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import com.google.common.base.Strings;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.code.ISliceContext;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.code.InjectorTarget;
import org.spongepowered.asm.mixin.injection.code.MethodSlice;
import org.spongepowered.asm.mixin.injection.code.MethodSlices;
import org.spongepowered.asm.mixin.injection.struct.CallbackInjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.InjectorGroupInfo;
import org.spongepowered.asm.mixin.injection.struct.InvalidMemberDescriptorException;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;
import org.spongepowered.asm.mixin.injection.struct.ModifyArgInjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.ModifyArgsInjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.ModifyConstantInjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.ModifyVariableInjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.RedirectInjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.injection.throwables.InjectionError;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.struct.SpecialMethodInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;

public abstract class InjectionInfo
extends SpecialMethodInfo
implements ISliceContext {
    protected final boolean isStatic;
    protected final Deque<MethodNode> targets = new ArrayDeque<MethodNode>();
    protected final MethodSlices slices;
    protected final String atKey;
    protected final List<InjectionPoint> injectionPoints = new ArrayList<InjectionPoint>();
    protected final Map<Target, List<InjectionNodes.InjectionNode>> targetNodes = new LinkedHashMap<Target, List<InjectionNodes.InjectionNode>>();
    protected Injector injector;
    protected InjectorGroupInfo group;
    private final List<MethodNode> injectedMethods = new ArrayList<MethodNode>(0xC7C9F2B9 ^ 0xC7C9F2B9);
    private int expectedCallbackCount = 0xDCD0C1CD ^ 0xDCD0C1CC;
    private int requiredCallbackCount = 0x8B7F668A ^ 0x8B7F668A;
    private int maxCallbackCount = 0x6315BA4C ^ 0x1CEA45B3;
    private int injectedCallbackCount = 0xD8019E83 ^ 0xD8019E83;

    protected InjectionInfo(MixinTargetContext mixinTargetContext, MethodNode methodNode, AnnotationNode annotationNode) {
        this(mixinTargetContext, methodNode, annotationNode, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("s\ua7f2"));
    }

    protected InjectionInfo(MixinTargetContext mixinTargetContext, MethodNode methodNode, AnnotationNode annotationNode, String string) {
        super(mixinTargetContext, methodNode, annotationNode);
        this.isStatic = Bytecode.methodIsStatic(methodNode);
        this.slices = MethodSlices.parse(this);
        this.atKey = string;
        this.readAnnotation();
    }

    protected void readAnnotation() {
        if (this.annotation == null) {
            return;
        }
        String string = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("R") + Bytecode.getSimpleName(this.annotation);
        List<AnnotationNode> list = this.readInjectionPoints(string);
        this.findMethods(this.parseTargets(string), string);
        this.parseInjectionPoints(list);
        this.parseRequirements();
        this.injector = this.parseInjector(this.annotation);
    }

    protected Set<MemberInfo> parseTargets(String string) {
        List<String> list = Annotations.getValue(this.annotation, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72"), (0xE76C24A0 ^ 0xE76C24A0) != 0);
        if (list == null) {
            Object[] objectArray = new Object[0xD710A69A ^ 0xD710A698];
            objectArray[0x4725F5FE ^ 0x4725F5FE] = string;
            objectArray[0x9FEBB64D ^ 0x9FEBB64C] = this.method.name;
            throw new InvalidInjectionException(this, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f5\ua070\ua90b\u7d78\u8e45\u246e\u8b36\u3463{\ua7e9\ua4bb\ua031\ua90a\u7d78\u8e0a\u243f\u8b24\u3437{\ua7f5\ua4f5\ua07c\ua90c\u7d65\u8e59\u2473\u8b39\u34702\ua7eb\ua4b0\ua065\ua90d\u7d79\u8e4e\u243a\u8b39\u3476\u007f\ua7e3"), objectArray));
        }
        LinkedHashSet<MemberInfo> linkedHashSet = new LinkedHashSet<MemberInfo>();
        for (String string2 : list) {
            try {
                MemberInfo memberInfo = MemberInfo.parseAndValidate(string2, this.mixin);
                if (memberInfo.owner != null && !memberInfo.owner.equals(this.mixin.getTargetClassRef())) {
                    Object[] objectArray = new Object[0x40370F16 ^ 0x40370F15];
                    objectArray[0x8C59D71C ^ 0x8C59D71C] = string;
                    objectArray[0xD914279A ^ 0xD914279B] = this.method.name;
                    objectArray[0x60DFE93E ^ 0x60DFE93C] = memberInfo.owner;
                    throw new InvalidInjectionException(this, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f5\ua070\ua90b\u7d78\u8e45\u246e\u8b36\u3463{\ua7e9\ua4bb\ua031\ua90a\u7d78\u8e0a\u243f\u8b24\u3437a\ua7f6\ua4b0\ua072\ua90c\u7d70\u8e43\u247f\u8b24\u3437s\ua7a6\ua4a1\ua070\ua917\u7d71\u8e4f\u246e\u8b77\u3474~\ua7e7\ua4a6\ua062\ua945\u7d31\u8e0f\u2469\u8b70\u343b2\ua7f1\ua4bd\ua078\ua906\u7d7e\u8e0a\u2473\u8b24\u3437|\ua7e9\ua4a1\ua031\ua916\u7d63\u8e5a\u246a\u8b38\u3465f\ua7e3\ua4b1"), objectArray));
                }
                linkedHashSet.add(memberInfo);
            }
            catch (InvalidMemberDescriptorException invalidMemberDescriptorException) {
                Object[] objectArray = new Object[0x74A04374 ^ 0x74A04370];
                objectArray[0x43F0D5D ^ 0x43F0D5D] = string;
                objectArray[0xBAF172D7 ^ 0xBAF172D6] = this.method.name;
                objectArray[0x8680EAD7 ^ 0x8680EAD5] = string2;
                objectArray[0x2B73F9FC ^ 0x2B73F9FF] = this.mixin.getReferenceMapper().getStatus();
                throw new InvalidInjectionException(this, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f5\ua070\ua90b\u7d78\u8e45\u246e\u8b36\u3463{\ua7e9\ua4bb\ua031\ua90a\u7d78\u8e0a\u243f\u8b24\u343b2\ua7ee\ua4b4\ua062\ua945\u7d7f\u8e44\u246c\u8b36\u347b{\ua7e2\ua4f5\ua065\ua904\u7d64\u8e4d\u247f\u8b23\u3437v\ua7e3\ua4a6\ua072\ua917\u7d7f\u8e5a\u246e\u8b38\u3465(\ua7a6\ua4f7\ua034\ua916\u7d34\u8e04\u243a\u8b72\u3464"), objectArray));
            }
        }
        return linkedHashSet;
    }

    protected List<AnnotationNode> readInjectionPoints(String string) {
        List<AnnotationNode> list = Annotations.getValue(this.annotation, this.atKey, (0xC86C64FE ^ 0xC86C64FE) != 0);
        if (list == null) {
            Object[] objectArray = new Object[0xA93A0049 ^ 0xA93A004A];
            objectArray[0xB83DBEFC ^ 0xB83DBEFC] = string;
            objectArray[0x56FA5B57 ^ 0x56FA5B56] = this.method.name;
            objectArray[0x776A8F74 ^ 0x776A8F76] = this.atKey;
            throw new InvalidInjectionException(this, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f5\ua070\ua90b\u7d78\u8e45\u246e\u8b36\u3463{\ua7e9\ua4bb\ua031\ua90a\u7d78\u8e0a\u243f\u8b24\u3437{\ua7f5\ua4f5\ua07c\ua90c\u7d65\u8e59\u2473\u8b39\u34702\ua7a1\ua4f0\ua062\ua942\u7d36\u8e5c\u247b\u8b3b\u3462w\ua7ae\ua4a6\ua038"), objectArray));
        }
        return list;
    }

    protected void parseInjectionPoints(List<AnnotationNode> list) {
        this.injectionPoints.addAll(InjectionPoint.parse((IMixinContext)this.mixin, this.method, this.annotation, list));
    }

    /*
     * Unable to fully structure code
     */
    protected void parseRequirements() {
        this.group = this.mixin.getInjectorGroups().parseGroup(this.method, this.mixin.getDefaultInjectorGroup()).add(this);
        var1_1 = (Integer)Annotations.getValue(this.annotation, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("w\ua7fe\ua4a5\ua074\ua906\u7d62"));
        if (var1_1 != null) {
            this.expectedCallbackCount = var1_1;
        }
        if ((var2_2 = (Integer)Annotations.getValue(this.annotation, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("`\ua7e3\ua4a4\ua064\ua90c\u7d64\u8e4f"))) == null) ** GOTO lbl-1000
        if (var2_2 > (74266087 ^ -74266088)) {
            this.requiredCallbackCount = var2_2;
        } else if (this.group.isDefault()) {
            this.requiredCallbackCount = this.mixin.getDefaultRequiredInjections();
        }
        var3_3 = (Integer)Annotations.getValue(this.annotation, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("s\ua7ea\ua4b9\ua07e\ua912"));
        if (var3_3 != null) {
            this.maxCallbackCount = Math.max(Math.max(this.requiredCallbackCount, -1261389063 ^ -1261389064), var3_3);
        }
    }

    protected abstract Injector parseInjector(AnnotationNode var1);

    public boolean isValid() {
        return (this.targets.size() > 0 && this.injectionPoints.size() > 0 ? 0x29D005E8 ^ 0x29D005E9 : 0x3ADA940E ^ 0x3ADA940E) != 0;
    }

    public void prepare() {
        this.targetNodes.clear();
        for (MethodNode methodNode : this.targets) {
            Target target = this.mixin.getTargetMethod(methodNode);
            InjectorTarget injectorTarget = new InjectorTarget(this, target);
            this.targetNodes.put(target, this.injector.find(injectorTarget, this.injectionPoints));
            injectorTarget.dispose();
        }
    }

    public void inject() {
        for (Map.Entry<Target, List<InjectionNodes.InjectionNode>> entry : this.targetNodes.entrySet()) {
            this.injector.inject(entry.getKey(), entry.getValue());
        }
        this.targets.clear();
    }

    public void postInject() {
        for (MethodNode object2 : this.injectedMethods) {
            this.classNode.methods.add(object2);
        }
        String string = this.getDescription();
        String string2 = this.mixin.getReferenceMapper().getStatus();
        String string3 = this.getDynamicInfo();
        if (this.mixin.getEnvironment().getOption(MixinEnvironment.Option.DEBUG_INJECTORS) && this.injectedCallbackCount < this.expectedCallbackCount) {
            Object[] objectArray = new Object[0xEC59DE54 ^ 0xEC59DE5C];
            objectArray[0x9FA62ED1 ^ 0x9FA62ED1] = string;
            objectArray[0x824AF9C7 ^ 0x824AF9C6] = this.method.name;
            objectArray[0xDBBC939F ^ 0xDBBC939D] = this.method.desc;
            objectArray[0x32A2828E ^ 0x32A2828D] = this.mixin;
            objectArray[0xEFDCB8F0 ^ 0xEFDCB8F4] = this.expectedCallbackCount;
            objectArray[0x3EE4B70C ^ 0x3EE4B709] = this.injectedCallbackCount;
            objectArray[0xF1F7BFCE ^ 0xF1F7BFC8] = string2;
            objectArray[0x9AABEBF0 ^ 0x9AABEBF7] = string3;
            throw new InvalidInjectionException(this, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4bf\ua074\ua906\u7d62\u8e43\u2475\u8b39\u3437d\ua7e7\ua4b9\ua078\ua901\u7d77\u8e5e\u2473\u8b38\u34792\ua7e0\ua4b4\ua078\ua909\u7d73\u8e4e\u2420\u8b77\u3432a\ua7a6\ua4f0\ua062\ua940\u7d65\u8e0a\u2473\u8b39\u34377\ua7f5\ua4f5\ua074\ua91d\u7d66\u8e4f\u2479\u8b23\u3472v\ua7a6\ua4f0\ua075\ua945\u7d7f\u8e44\u246c\u8b38\u3474s\ua7f2\ua4bc\ua07e\ua90b\u7d3e\u8e59\u2433\u8b77\u3475g\ua7f2\ua4f5\ua034\ua901\u7d36\u8e59\u246f\u8b34\u3474w\ua7e3\ua4b1\ua074\ua901\u7d38\u8e0a\u243f\u8b24\u3432a"), objectArray));
        }
        if (this.injectedCallbackCount < this.requiredCallbackCount) {
            Object[] objectArray = new Object[0x394210FB ^ 0x394210F3];
            objectArray[0x56E2F145 ^ 0x56E2F145] = string;
            objectArray[0xB4A56281 ^ 0xB4A56280] = this.method.name;
            objectArray[0x2B286E7C ^ 0x2B286E7E] = this.method.desc;
            objectArray[0xBBA03D53 ^ 0xBBA03D50] = this.mixin;
            objectArray[0x253555FD ^ 0x253555F9] = this.injectedCallbackCount;
            objectArray[0x70295C4 ^ 0x70295C1] = this.requiredCallbackCount;
            objectArray[0x2E908788 ^ 0x2E90878E] = string2;
            objectArray[0x91E4D671 ^ 0x91E4D676] = string3;
            throw new InjectionError(String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7f4\ua4bc\ua065\ua90c\u7d75\u8e4b\u2476\u8b77\u347e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b77\u3471s\ua7ef\ua4b9\ua064\ua917\u7d73\u8e10\u243a\u8b72\u34642\ua7a3\ua4a6\ua034\ua916\u7d36\u8e43\u2474\u8b77\u3432a\ua7a6\ua4b3\ua070\ua90c\u7d7a\u8e4f\u247e\u8b77\u347e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b77\u3474z\ua7e3\ua4b6\ua07a\ua949\u7d36\u8e02\u243f\u8b33\u34387\ua7e2\ua4fc\ua031\ua916\u7d63\u8e49\u2479\u8b32\u3472v\ua7e3\ua4b1\ua03f\ua945\u7d33\u8e59\u243f\u8b24"), objectArray));
        }
        if (this.injectedCallbackCount > this.maxCallbackCount) {
            Object[] objectArray = new Object[0xF322EC1C ^ 0xF322EC1B];
            objectArray[0x211111B8 ^ 0x211111B8] = string;
            objectArray[0x156784DF ^ 0x156784DE] = this.method.name;
            objectArray[0x71752195 ^ 0x71752197] = this.method.desc;
            objectArray[0x39D72E6E ^ 0x39D72E6D] = this.mixin;
            objectArray[0xC7FACC37 ^ 0xC7FACC33] = this.injectedCallbackCount;
            objectArray[0x5CCCAF9B ^ 0x5CCCAF9E] = this.maxCallbackCount;
            objectArray[0xB0BD269C ^ 0xB0BD269A] = string3;
            throw new InjectionError(String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7f4\ua4bc\ua065\ua90c\u7d75\u8e4b\u2476\u8b77\u347e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b77\u3471s\ua7ef\ua4b9\ua064\ua917\u7d73\u8e10\u243a\u8b72\u34642\ua7a3\ua4a6\ua034\ua916\u7d36\u8e43\u2474\u8b77\u3432a\ua7a6\ua4b3\ua070\ua90c\u7d7a\u8e4f\u247e\u8b77\u347e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b77\u3474z\ua7e3\ua4b6\ua07a\ua949\u7d36\u8e0f\u247e\u8b77\u3464g\ua7e5\ua4b6\ua074\ua900\u7d72\u8e4f\u247e\u8b77\u3478t\ua7a6\ua4f0\ua075\ua945\u7d77\u8e46\u2476\u8b38\u3460w\ua7e2\ua4fb\ua034\ua916"), objectArray));
        }
    }

    public void notifyInjected(Target target) {
    }

    protected String getDescription() {
        return \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e7\ua4b9\ua07d\ua907\u7d77\u8e49\u2471\u8b77\u347aw\ua7f2\ua4bd\ua07e\ua901");
    }

    public String toString() {
        return InjectionInfo.describeInjector(this.mixin, this.annotation, this.method);
    }

    public Collection<MethodNode> getTargets() {
        return this.targets;
    }

    @Override
    public MethodSlice getSlice(String string) {
        return this.slices.get(this.getSliceId(string));
    }

    public String getSliceId(String string) {
        return \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("");
    }

    public int getInjectedCallbackCount() {
        return this.injectedCallbackCount;
    }

    public MethodNode addMethod(int n, String string, String string2) {
        MethodNode methodNode = new MethodNode(0x8EAB01B0 ^ 0x8EAE01B0, n | 0x1DB2218E ^ 0x1DB2318E, string, string2, null, null);
        this.injectedMethods.add(methodNode);
        return methodNode;
    }

    public void addCallbackInvocation(MethodNode methodNode) {
        this.injectedCallbackCount += 0xFD6F764A ^ 0xFD6F764B;
    }

    private void findMethods(Set<MemberInfo> set, String string) {
        this.targets.clear();
        int n = this.mixin.getEnvironment().getOption(MixinEnvironment.Option.REFMAP_REMAP) ? 0xAFEA7C36 ^ 0xAFEA7C34 : 0xB2A4DD4F ^ 0xB2A4DD4E;
        block0: for (MemberInfo memberInfo : set) {
            int n2 = 0xA0E33326 ^ 0xA0E33326;
            for (int i = 0xDE03DE0A ^ 0xDE03DE0A; i < n; ++i) {
                if (n2 >= (0xAADD3794 ^ 0xAADD3795)) continue block0;
                int n3 = 0x3C1C607E ^ 0x3C1C607E;
                for (MethodNode methodNode : this.classNode.methods) {
                    int n4;
                    if (!memberInfo.matches(methodNode.name, methodNode.desc, n3)) continue;
                    int n5 = Annotations.getVisible(methodNode, MixinMerged.class) != null ? 0xC65A6091 ^ 0xC65A6090 : (n4 = 0x5BF9C563 ^ 0x5BF9C563);
                    if (memberInfo.matchAll && (Bytecode.methodIsStatic(methodNode) != this.isStatic || methodNode == this.method || n4 != 0)) continue;
                    this.checkTarget(methodNode);
                    this.targets.add(methodNode);
                    ++n3;
                    ++n2;
                }
                memberInfo = memberInfo.transform(null);
            }
        }
        if (this.targets.size() == 0) {
            Object[] objectArray = new Object[0x853710B2 ^ 0x853710B4];
            objectArray[0x1652B68A ^ 0x1652B68A] = string;
            objectArray[0x2904B611 ^ 0x2904B610] = this.method.name;
            objectArray[0xD9D16685 ^ 0xD9D16687] = InjectionInfo.namesOf(set);
            objectArray[0xE49DD2E9 ^ 0xE49DD2EA] = this.mixin.getTarget();
            objectArray[0x7AE014EC ^ 0x7AE014E8] = this.mixin.getReferenceMapper().getStatus();
            objectArray[0x3F7247AA ^ 0x3F7247AF] = this.getDynamicInfo();
            throw new InvalidInjectionException(this, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f5\ua070\ua90b\u7d78\u8e45\u246e\u8b36\u3463{\ua7e9\ua4bb\ua031\ua90a\u7d78\u8e0a\u243f\u8b24\u3437q\ua7e9\ua4a0\ua07d\ua901\u7d36\u8e44\u2475\u8b23\u3437t\ua7ef\ua4bb\ua075\ua945\u7d77\u8e44\u2463\u8b77\u3463s\ua7f4\ua4b2\ua074\ua911\u7d65\u8e0a\u2477\u8b36\u3463q\ua7ee\ua4bc\ua07f\ua902\u7d36\u8e0f\u2469\u8b77\u347e|\ua7a6\ua4a1\ua079\ua900\u7d36\u8e5e\u247b\u8b25\u3470w\ua7f2\ua4f5\ua072\ua909\u7d77\u8e59\u2469\u8b77\u3432a\ua7a8\ua4f5\ua034\ua916\u7d33\u8e59"), objectArray));
        }
    }

    private void checkTarget(MethodNode methodNode) {
        AnnotationNode annotationNode = Annotations.getVisible(methodNode, MixinMerged.class);
        if (annotationNode == null) {
            return;
        }
        if (Annotations.getVisible(methodNode, Final.class) != null) {
            Object[] objectArray = new Object[0xB9B0C88 ^ 0xB9B0C8D];
            objectArray[0xACCA4995 ^ 0xACCA4995] = this;
            objectArray[0x397F2F24 ^ 0x397F2F25] = this.classNode.name;
            objectArray[0x1EA34217 ^ 0x1EA34215] = methodNode.name;
            objectArray[0x38839268 ^ 0x3883926B] = methodNode.desc;
            objectArray[0x7544412 ^ 0x7544416] = Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b"));
            throw new InvalidInjectionException(this, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f5\ua072\ua904\u7d78\u8e44\u2475\u8b23\u3437{\ua7e8\ua4bf\ua074\ua906\u7d62\u8e0a\u2473\u8b39\u3463}\ua7a6\ua495\ua057\ua90c\u7d78\u8e4b\u2476\u8b77\u347aw\ua7f2\ua4bd\ua07e\ua901\u7d36\u8e0f\u2469\u8b6d\u342d7\ua7f5\ua4f0\ua062\ua945\u7d7b\u8e4f\u2468\u8b30\u3472v\ua7a6\ua4b7\ua068\ua945\u7d33\u8e59"), objectArray));
        }
    }

    protected String getDynamicInfo() {
        String string;
        AnnotationNode annotationNode = Annotations.getInvisible(this.method, Dynamic.class);
        String string2 = Strings.nullToEmpty((String)((String)Annotations.getValue(annotationNode)));
        Type type = (Type)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b"));
        if (type != null) {
            Object[] objectArray = new Object[0xBFBDEE00 ^ 0xBFBDEE02];
            objectArray[0x6A0BACAE ^ 0x6A0BACAE] = type.getClassName();
            objectArray[0x26B73108 ^ 0x26B73109] = string2;
            string2 = String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("i\ua7a3\ua4a6\ua06c\ua945\u7d33\u8e59"), objectArray).trim();
        }
        if (string2.length() > 0) {
            Object[] objectArray = new Object[0xCCEF950A ^ 0xCCEF950B];
            objectArray[0xE176B00D ^ 0xE176B00D] = string2;
            string = String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7cb\ua4b0\ua065\ua90d\u7d79\u8e4e\u243a\u8b3e\u34642\ua7c6\ua491\ua068\ua90b\u7d77\u8e47\u2473\u8b34\u343f7\ua7f5\ua4fc"), objectArray);
        } else {
            string = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("");
        }
        return string;
    }

    public static InjectionInfo parse(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        AnnotationNode annotationNode = InjectionInfo.getInjectorAnnotation(mixinTargetContext.getMixin(), methodNode);
        if (annotationNode == null) {
            return null;
        }
        if (annotationNode.desc.endsWith(Inject.class.getSimpleName() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(")"))) {
            return new CallbackInjectionInfo(mixinTargetContext, methodNode, annotationNode);
        }
        if (annotationNode.desc.endsWith(ModifyArg.class.getSimpleName() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(")"))) {
            return new ModifyArgInjectionInfo(mixinTargetContext, methodNode, annotationNode);
        }
        if (annotationNode.desc.endsWith(ModifyArgs.class.getSimpleName() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(")"))) {
            return new ModifyArgsInjectionInfo(mixinTargetContext, methodNode, annotationNode);
        }
        if (annotationNode.desc.endsWith(Redirect.class.getSimpleName() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(")"))) {
            return new RedirectInjectionInfo(mixinTargetContext, methodNode, annotationNode);
        }
        if (annotationNode.desc.endsWith(ModifyVariable.class.getSimpleName() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(")"))) {
            return new ModifyVariableInjectionInfo(mixinTargetContext, methodNode, annotationNode);
        }
        if (annotationNode.desc.endsWith(ModifyConstant.class.getSimpleName() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(")"))) {
            return new ModifyConstantInjectionInfo(mixinTargetContext, methodNode, annotationNode);
        }
        return null;
    }

    public static AnnotationNode getInjectorAnnotation(IMixinInfo iMixinInfo, MethodNode methodNode) {
        AnnotationNode annotationNode = null;
        try {
            Class[] classArray = new Class[0xE0BE2AC0 ^ 0xE0BE2AC6];
            classArray[0xD88BC718 ^ 0xD88BC718] = Inject.class;
            classArray[0x4ECF4099 ^ 0x4ECF4098] = ModifyArg.class;
            classArray[0x400E814D ^ 0x400E814F] = ModifyArgs.class;
            classArray[0xE1524343 ^ 0xE1524340] = Redirect.class;
            classArray[0xC234EB24 ^ 0xC234EB20] = ModifyVariable.class;
            classArray[0xB5658274 ^ 0xB5658271] = ModifyConstant.class;
            annotationNode = Annotations.getSingleVisible(methodNode, classArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray = new Object[0x3B28D365 ^ 0x3B28D366];
            objectArray[0x559A93C3 ^ 0x559A93C3] = methodNode.name;
            objectArray[0x8C83A934 ^ 0x8C83A935] = iMixinInfo.getClassName();
            objectArray[0x1F6CE345 ^ 0x1F6CE347] = illegalArgumentException.getMessage();
            throw new InvalidMixinException(iMixinInfo, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("W\ua7f4\ua4a7\ua07e\ua917\u7d36\u8e5a\u247b\u8b25\u3464{\ua7e8\ua4b2\ua031\ua904\u7d78\u8e44\u2475\u8b23\u3476f\ua7ef\ua4ba\ua07f\ua916\u7d36\u8e45\u2474\u8b77\u3432a\ua7a6\ua4bc\ua07f\ua945\u7d33\u8e59\u2420\u8b77\u3432a"), objectArray));
        }
        return annotationNode;
    }

    public static String getInjectorPrefix(AnnotationNode annotationNode) {
        if (annotationNode != null) {
            if (annotationNode.desc.endsWith(ModifyArg.class.getSimpleName() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(")"))) {
                return \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7e9\ua4b1\ua078\ua903\u7d6f");
            }
            if (annotationNode.desc.endsWith(ModifyArgs.class.getSimpleName() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(")"))) {
                return \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("s\ua7f4\ua4b2\ua062");
            }
            if (annotationNode.desc.endsWith(Redirect.class.getSimpleName() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(")"))) {
                return \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("`\ua7e3\ua4b1\ua078\ua917\u7d73\u8e49\u246e");
            }
            if (annotationNode.desc.endsWith(ModifyVariable.class.getSimpleName() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(")"))) {
                return \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("~\ua7e9\ua4b6\ua070\ua909\u7d60\u8e4b\u2468");
            }
            if (annotationNode.desc.endsWith(ModifyConstant.class.getSimpleName() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(")"))) {
                return \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("q\ua7e9\ua4bb\ua062\ua911\u7d77\u8e44\u246e");
            }
        }
        return \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("z\ua7e7\ua4bb\ua075\ua909\u7d73\u8e58");
    }

    static String describeInjector(IMixinContext iMixinContext, AnnotationNode annotationNode, MethodNode methodNode) {
        Object[] objectArray = new Object[0x2C152D34 ^ 0x2C152D30];
        objectArray[0x2F71F30C ^ 0x2F71F30C] = iMixinContext.toString();
        objectArray[0xC32A7F0D ^ 0xC32A7F0C] = Bytecode.getSimpleName(annotationNode);
        objectArray[0x88F52310 ^ 0x88F52312] = methodNode.name;
        objectArray[0x6510629F ^ 0x6510629C] = methodNode.desc;
        return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f8\ua02f\ua925\u7d33\u8e59\u2420\u8b6d\u3432a\ua7a3\ua4a6"), objectArray);
    }

    private static String namesOf(Collection<MemberInfo> collection) {
        int n = 0x3AF08125 ^ 0x3AF08125;
        int n2 = collection.size();
        StringBuilder stringBuilder = new StringBuilder();
        for (MemberInfo memberInfo : collection) {
            if (n > 0) {
                if (n == n2 - (0x93BE1AF2 ^ 0x93BE1AF3)) {
                    stringBuilder.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e9\ua4a7\ua031"));
                } else {
                    stringBuilder.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(">\ua7a6"));
                }
            }
            stringBuilder.append((char)(0x4D786CF1 ^ 0x4D786CD6)).append(memberInfo.name).append((char)(0x55AFAFC ^ 0x55AFADB));
            ++n;
        }
        return stringBuilder.toString();
    }
}

