/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.util.Bytecode;

public class InjectionNodes
extends ArrayList<InjectionNode> {
    private static final long serialVersionUID = 1L;

    public InjectionNode add(AbstractInsnNode abstractInsnNode) {
        InjectionNode injectionNode = this.get(abstractInsnNode);
        if (injectionNode == null) {
            injectionNode = new InjectionNode(abstractInsnNode);
            this.add(injectionNode);
        }
        return injectionNode;
    }

    public InjectionNode get(AbstractInsnNode abstractInsnNode) {
        for (InjectionNode injectionNode : this) {
            if (!injectionNode.matches(abstractInsnNode)) continue;
            return injectionNode;
        }
        return null;
    }

    public boolean contains(AbstractInsnNode abstractInsnNode) {
        return (this.get(abstractInsnNode) != null ? 0x42E5626 ^ 0x42E5627 : 0x8AF474F9 ^ 0x8AF474F9) != 0;
    }

    public void replace(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2) {
        InjectionNode injectionNode = this.get(abstractInsnNode);
        if (injectionNode != null) {
            injectionNode.replace(abstractInsnNode2);
        }
    }

    public void remove(AbstractInsnNode abstractInsnNode) {
        InjectionNode injectionNode = this.get(abstractInsnNode);
        if (injectionNode != null) {
            injectionNode.remove();
        }
    }

    public static class InjectionNode
    implements Comparable<InjectionNode> {
        private static int nextId = 0xFC9F9D55 ^ 0xFC9F9D55;
        private final int id;
        private final AbstractInsnNode originalTarget;
        private AbstractInsnNode currentTarget;
        private Map<String, Object> decorations;

        public InjectionNode(AbstractInsnNode abstractInsnNode) {
            this.currentTarget = this.originalTarget = abstractInsnNode;
            int n = nextId;
            nextId = n + (0x55629AF0 ^ 0x55629AF1);
            this.id = n;
        }

        public int getId() {
            return this.id;
        }

        public AbstractInsnNode getOriginalTarget() {
            return this.originalTarget;
        }

        public AbstractInsnNode getCurrentTarget() {
            return this.currentTarget;
        }

        public InjectionNode replace(AbstractInsnNode abstractInsnNode) {
            this.currentTarget = abstractInsnNode;
            return this;
        }

        public InjectionNode remove() {
            this.currentTarget = null;
            return this;
        }

        public boolean matches(AbstractInsnNode abstractInsnNode) {
            return (this.originalTarget == abstractInsnNode || this.currentTarget == abstractInsnNode ? 0xD7FB6B3A ^ 0xD7FB6B3B : 0x60C22DC6 ^ 0x60C22DC6) != 0;
        }

        public boolean isReplaced() {
            return (this.originalTarget != this.currentTarget ? 0x1BE82D96 ^ 0x1BE82D97 : 0x498D2E1B ^ 0x498D2E1B) != 0;
        }

        public boolean isRemoved() {
            return (this.currentTarget == null ? 0x53AD0475 ^ 0x53AD0474 : 0x15FD2704 ^ 0x15FD2704) != 0;
        }

        public <V> InjectionNode decorate(String string, V v) {
            if (this.decorations == null) {
                this.decorations = new HashMap<String, Object>();
            }
            this.decorations.put(string, v);
            return this;
        }

        public boolean hasDecoration(String string) {
            return (this.decorations != null && this.decorations.get(string) != null ? 0x5D4892AC ^ 0x5D4892AD : 0x9F97A4D7 ^ 0x9F97A4D7) != 0;
        }

        public <V> V getDecoration(String string) {
            return (V)(this.decorations == null ? null : this.decorations.get(string));
        }

        @Override
        public int compareTo(InjectionNode injectionNode) {
            return injectionNode == null ? 0x773B6090 ^ 0x8C49F6F : this.hashCode() - injectionNode.hashCode();
        }

        public String toString() {
            Object[] objectArray = new Object[0x711BB99F ^ 0x711BB99E];
            objectArray[0x8552614E ^ 0x8552614E] = Bytecode.describeNode(this.currentTarget).replaceAll(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("N\ua7f5\ua4fe"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2"));
            return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4bf\ua074\ua906\u7d62\u8e43\u2475\u8b39\u3459}\ua7e2\ua4b0\ua04a\ua940\u7d65\u8e77"), objectArray);
        }
    }
}

