/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.mixin.injection.struct.InvalidMemberDescriptorException;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.refmap.IReferenceMapper;
import org.spongepowered.asm.mixin.throwables.MixinException;
import org.spongepowered.asm.obfuscation.mapping.IMapping;
import org.spongepowered.asm.obfuscation.mapping.common.MappingField;
import org.spongepowered.asm.obfuscation.mapping.common.MappingMethod;
import org.spongepowered.asm.util.SignaturePrinter;

public final class MemberInfo {
    public final String owner;
    public final String name;
    public final String desc;
    public final boolean matchAll;
    private final boolean forceField;
    private final String unparsed;

    public MemberInfo(String string, boolean bl) {
        this(string, null, null, bl);
    }

    public MemberInfo(String string, String string2, boolean bl) {
        this(string, string2, null, bl);
    }

    public MemberInfo(String string, String string2, String string3) {
        this(string, string2, string3, (0x8F9E7880 ^ 0x8F9E7880) != 0);
    }

    public MemberInfo(String string, String string2, String string3, boolean bl) {
        this(string, string2, string3, bl, null);
    }

    public MemberInfo(String string, String string2, String string3, boolean bl, String string4) {
        if (string2 != null && string2.contains(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("<"))) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("S\ua7f2\ua4a1\ua074\ua908\u7d66\u8e5e\u243a\u8b23\u34782\ua7ef\ua4bb\ua062\ua911\u7d77\u8e44\u2479\u8b32\u3437s\ua7a6\ua498\ua074\ua908\u7d74\u8e4f\u2468\u8b1e\u3479t\ua7e9\ua4f5\ua066\ua90c\u7d62\u8e42\u243a\u8b36\u34792\ua7ef\ua4bb\ua067\ua904\u7d7a\u8e43\u247e\u8b77\u3478e\ua7e8\ua4b0\ua063\ua945\u7d70\u8e45\u2468\u8b3a\u3476f"));
        }
        this.owner = string2;
        this.name = string;
        this.desc = string3;
        this.matchAll = bl;
        this.forceField = 0x1D34EC65 ^ 0x1D34EC65;
        this.unparsed = string4;
    }

    public MemberInfo(AbstractInsnNode abstractInsnNode) {
        this.matchAll = 0x776F3025 ^ 0x776F3025;
        this.forceField = 0xB7F6E21D ^ 0xB7F6E21D;
        this.unparsed = null;
        if (abstractInsnNode instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            this.owner = methodInsnNode.owner;
            this.name = methodInsnNode.name;
            this.desc = methodInsnNode.desc;
        } else if (abstractInsnNode instanceof FieldInsnNode) {
            FieldInsnNode fieldInsnNode = (FieldInsnNode)abstractInsnNode;
            this.owner = fieldInsnNode.owner;
            this.name = fieldInsnNode.name;
            this.desc = fieldInsnNode.desc;
        } else {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("{\ua7e8\ua4a6\ua07f\ua945\u7d7b\u8e5f\u2469\u8b23\u3437p\ua7e3\ua4f5\ua070\ua90b\u7d36\u8e43\u2474\u8b24\u3463s\ua7e8\ua4b6\ua074\ua945\u7d79\u8e4c\u243a\u8b1a\u3472f\ua7ee\ua4ba\ua075\ua92c\u7d78\u8e59\u2474\u8b19\u3478v\ua7e3\ua4f5\ua07e\ua917\u7d36\u8e6c\u2473\u8b32\u347bv\ua7cf\ua4bb\ua062\ua90b\u7d58\u8e45\u247e\u8b32"));
        }
    }

    public MemberInfo(IMapping<?> iMapping) {
        this.owner = iMapping.getOwner();
        this.name = iMapping.getSimpleName();
        this.desc = iMapping.getDesc();
        this.matchAll = 0x85FCC858 ^ 0x85FCC858;
        this.forceField = iMapping.getType() == IMapping.Type.FIELD ? 0xF2303E3C ^ 0xF2303E3D : 0x790CFA0 ^ 0x790CFA0;
        this.unparsed = null;
    }

    private MemberInfo(MemberInfo memberInfo, MappingMethod mappingMethod, boolean bl) {
        this.owner = bl ? mappingMethod.getOwner() : memberInfo.owner;
        this.name = mappingMethod.getSimpleName();
        this.desc = mappingMethod.getDesc();
        this.matchAll = memberInfo.matchAll;
        this.forceField = 0x79AA8AFB ^ 0x79AA8AFB;
        this.unparsed = null;
    }

    private MemberInfo(MemberInfo memberInfo, String string) {
        this.owner = string;
        this.name = memberInfo.name;
        this.desc = memberInfo.desc;
        this.matchAll = memberInfo.matchAll;
        this.forceField = memberInfo.forceField;
        this.unparsed = null;
    }

    public String toString() {
        String string;
        String string2 = this.owner != null ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^") + this.owner + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(")") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("");
        String string3 = this.name != null ? this.name : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("");
        String string4 = this.matchAll ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("8") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("");
        String string5 = string = this.desc != null ? this.desc : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("");
        String string6 = string.startsWith(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(":")) ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("") : (this.desc != null ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("(") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(""));
        return string2 + string3 + string4 + string6 + string;
    }

    @Deprecated
    public String toSrg() {
        if (!this.isFullyQualified()) {
            throw new MixinException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2479\u8b38\u3479d\ua7e3\ua4a7\ua065\ua945\u7d63\u8e44\u246b\u8b22\u3476~\ua7ef\ua4b3\ua078\ua900\u7d72\u8e0a\u2468\u8b32\u3471w\ua7f4\ua4b0\ua07f\ua906\u7d73\u8e0a\u246e\u8b38\u3437A\ua7d4\ua492\ua031\ua908\u7d77\u8e5a\u246a\u8b3e\u3479u"));
        }
        if (this.desc.startsWith(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(":"))) {
            return this.owner + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("=") + this.name + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2") + this.desc;
        }
        return this.owner + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("=") + this.name;
    }

    public String toDescriptor() {
        if (this.desc == null) {
            return \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("");
        }
        return new SignaturePrinter(this).setFullyQualified((0xC358AC7E ^ 0xC358AC7F) != 0).toDescriptor();
    }

    public String toCtorType() {
        if (this.unparsed == null) {
            return null;
        }
        String string = this.getReturnType();
        if (string != null) {
            return string;
        }
        if (this.owner != null) {
            return this.owner;
        }
        if (this.name != null && this.desc == null) {
            return this.name;
        }
        return this.desc != null ? this.desc : this.unparsed;
    }

    public String toCtorDesc() {
        if (this.desc != null && this.desc.startsWith(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(":"))) {
            if (this.desc.indexOf(0x296D16B9 ^ 0x296D1690) > (0x843F47D8 ^ 0x7BC0B827)) {
                return this.desc.substring(0x60A6FC46 ^ 0x60A6FC46, this.desc.indexOf(0x66822A66 ^ 0x66822A4F) + (0x5CA011A6 ^ 0x5CA011A7)) + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("D");
            }
        }
        return null;
    }

    public String getReturnType() {
        block5: {
            block4: {
                if (this.desc == null) break block4;
                if (this.desc.indexOf(0x8758F5DC ^ 0x8758F5F5) == (0xEA46CDD0 ^ 0x15B9322F)) break block4;
                if (this.desc.indexOf(0xC19F019C ^ 0xC19F01B4) == 0) break block5;
            }
            return null;
        }
        String string = this.desc.substring(this.desc.indexOf(0xC94CF6CC ^ 0xC94CF6E5) + (0x860D3351 ^ 0x860D3350));
        if (string.startsWith(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^")) && string.endsWith(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(")"))) {
            return string.substring(0xEFDE1A2E ^ 0xEFDE1A2F, string.length() - (0xB956CE8C ^ 0xB956CE8D));
        }
        return string;
    }

    public IMapping<?> asMapping() {
        return this.isField() ? this.asFieldMapping() : this.asMethodMapping();
    }

    public MappingMethod asMethodMapping() {
        if (!this.isFullyQualified()) {
            throw new MixinException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2479\u8b38\u3479d\ua7e3\ua4a7\ua065\ua945\u7d63\u8e44\u246b\u8b22\u3476~\ua7ef\ua4b3\ua078\ua900\u7d72\u8e0a\u2468\u8b32\u3471w\ua7f4\ua4b0\ua07f\ua906\u7d73\u8e0a") + this + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7f2\ua4ba\ua031\ua928\u7d73\u8e5e\u2472\u8b38\u3473_\ua7e7\ua4a5\ua061\ua90c\u7d78\u8e4d"));
        }
        if (this.isField()) {
            throw new MixinException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2479\u8b38\u3479d\ua7e3\ua4a7\ua065\ua945\u7d77\u8e0a\u2474\u8b38\u3479?\ua7eb\ua4b0\ua065\ua90d\u7d79\u8e4e\u243a\u8b25\u3472t\ua7e3\ua4a7\ua074\ua90b\u7d75\u8e4f\u243a") + this + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7f2\ua4ba\ua031\ua928\u7d73\u8e5e\u2472\u8b38\u3473_\ua7e7\ua4a5\ua061\ua90c\u7d78\u8e4d"));
        }
        return new MappingMethod(this.owner, this.name, this.desc);
    }

    public MappingField asFieldMapping() {
        if (!this.isField()) {
            throw new MixinException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2479\u8b38\u3479d\ua7e3\ua4a7\ua065\ua945\u7d78\u8e45\u2474\u8b7a\u3471{\ua7e3\ua4b9\ua075\ua945\u7d64\u8e4f\u247c\u8b32\u3465w\ua7e8\ua4b6\ua074\ua945") + this + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7f2\ua4ba\ua031\ua923\u7d7f\u8e4f\u2476\u8b33\u345as\ua7f6\ua4a5\ua078\ua90b\u7d71"));
        }
        return new MappingField(this.owner, this.name, this.desc);
    }

    public boolean isFullyQualified() {
        return (this.owner != null && this.name != null && this.desc != null ? 0x410557FA ^ 0x410557FB : 0x110F21AB ^ 0x110F21AB) != 0;
    }

    public boolean isField() {
        return (this.forceField || this.desc != null && !this.desc.startsWith(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(":")) ? 0x3B4ADC4E ^ 0x3B4ADC4F : 0x1B2D5AFA ^ 0x1B2D5AFA) != 0;
    }

    public boolean isConstructor() {
        return \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(this.name);
    }

    public boolean isClassInitialiser() {
        return \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(".\ua7e5\ua4b9\ua078\ua90b\u7d7f\u8e5e\u2424").equals(this.name);
    }

    public boolean isInitialiser() {
        return (this.isConstructor() || this.isClassInitialiser() ? 0x9C294E3E ^ 0x9C294E3F : 0x760D3B8A ^ 0x760D3B8A) != 0;
    }

    public MemberInfo validate() throws InvalidMemberDescriptorException {
        if (this.owner != null) {
            if (!this.owner.matches(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(":\ua7b9\ua4bc\ua038\ua93b\u7d4d\u8e76\u246d\u8b0b\u3467i\ua7d5\ua4b6\ua06c\ua94a\u7d4b\u8e01\u243e"))) {
                throw new InvalidMemberDescriptorException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b38\u3460|\ua7e3\ua4a7\ua02b\ua945") + this.owner);
            }
            if (this.unparsed != null) {
                if (this.unparsed.lastIndexOf(0x51AE2230 ^ 0x51AE221E) > 0 && this.owner.startsWith(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^"))) {
                    throw new InvalidMemberDescriptorException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("_\ua7e7\ua4b9\ua077\ua90a\u7d64\u8e47\u247f\u8b33\u3437}\ua7f1\ua4bb\ua074\ua917\u7d2c\u8e0a") + this.owner + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7cf\ua4b3\ua031\ua91c\u7d79\u8e5f\u243a\u8b36\u3465w\ua7a6\ua4a6\ua074\ua900\u7d7f\u8e44\u247d\u8b77\u3463z\ua7ef\ua4a6\ua031\ua908\u7d73\u8e59\u2469\u8b36\u3470w\ua7a6\ua4a0\ua07f\ua900\u7d6e\u8e5a\u247f\u8b34\u3463w\ua7e2\ua4b9\ua068\ua945\u7d77\u8e44\u247e\u8b77\u3463z\ua7e3\ua4f5\ua07e\ua912\u7d78\u8e4f\u2468\u8b77\u3476b\ua7f6\ua4b0\ua070\ua917\u7d65\u8e0a\u246e\u8b38\u3437p\ua7e3\ua4f5\ua072\ua90a\u7d64\u8e58\u247f\u8b34\u3463>\ua7a6\ua4a7\ua074\ua915\u7d7a\u8e4b\u2479\u8b32\u3437f\ua7ee\ua4b0\ua031\ua90a\u7d61\u8e44\u247f\u8b25\u3437v\ua7e3\ua4a6\ua072\ua917\u7d7f\u8e5a\u246e\u8b38\u34652\ua7f1\ua4bc\ua065\ua90d\u7d36\u8e4c\u2475\u8b25\u347as\ua7ea\ua4f5\ua065\ua91c\u7d66\u8e4f\u243a\u8b1b") + this.owner + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(")\ua7a6\ua4a1\ua07e\ua945\u7d65\u8e5f\u246a\u8b27\u3465w\ua7f5\ua4a6\ua031\ua911\u7d7e\u8e43\u2469\u8b77\u3472`\ua7f4\ua4ba\ua063"));
                }
            }
        }
        if (this.name != null && !this.name.matches(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(":\ua7b9\ua4bc\ua038\ua93b\u7d2a\u8e15\u2441\u8b0b\u3460N\ua7f6\ua4ae\ua042\ua906\u7d6b\u8e77\u2431\u8b69\u34286"))) {
            throw new InvalidMemberDescriptorException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b39\u3476\u007f\ua7e3\ua4ef\ua031") + this.name);
        }
        if (this.desc != null) {
            if (!this.desc.matches(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("L\ua7ae\ua489\ua039\ua93e\u7d4a\u8e5d\u2446\u8b27\u346cA\ua7e5\ua4a8\ua04d\ua93e\u7d39\u8e11\u2447\u8b7d\u344b;\ua7af\ua4ea\ua04d\ua93e\u7d3c\u8e71\u2446\u8b20\u344bb\ua7fd\ua486\ua072\ua918\u7d39\u8e11\u2447\u8b7c\u3433"))) {
                throw new InvalidMemberDescriptorException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b33\u3472a\ua7e5\ua4a7\ua078\ua915\u7d62\u8e45\u2468\u8b6d\u3437") + this.desc);
            }
            if (this.isField()) {
                if (!this.desc.equals(Type.getType(this.desc).getDescriptor())) {
                    throw new InvalidMemberDescriptorException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b31\u347ew\ua7ea\ua4b1\ua031\ua911\u7d6f\u8e5a\u247f\u8b77\u347e|\ua7a6\ua4b1\ua074\ua916\u7d75\u8e58\u2473\u8b27\u3463}\ua7f4\ua4ef\ua031") + this.desc);
                }
            } else {
                try {
                    Type.getArgumentTypes(this.desc);
                }
                catch (Exception exception) {
                    throw new InvalidMemberDescriptorException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b33\u3472a\ua7e5\ua4a7\ua078\ua915\u7d62\u8e45\u2468\u8b6d\u3437") + this.desc);
                }
                String string = this.desc.substring(this.desc.indexOf(0xA7A3778B ^ 0xA7A377A2) + (0x46DF8809 ^ 0x46DF8808));
                try {
                    Type type = Type.getType(string);
                    if (!string.equals(type.getDescriptor())) {
                        throw new InvalidMemberDescriptorException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b25\u3472f\ua7f3\ua4a7\ua07f\ua945\u7d62\u8e53\u246a\u8b32\u34370") + string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("0\ua7a6\ua4bc\ua07f\ua945\u7d72\u8e4f\u2469\u8b34\u3465{\ua7f6\ua4a1\ua07e\ua917\u7d2c\u8e0a") + this.desc);
                    }
                }
                catch (Exception exception) {
                    throw new InvalidMemberDescriptorException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b25\u3472f\ua7f3\ua4a7\ua07f\ua945\u7d62\u8e53\u246a\u8b32\u34370") + string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("0\ua7a6\ua4bc\ua07f\ua945\u7d72\u8e4f\u2469\u8b34\u3465{\ua7f6\ua4a1\ua07e\ua917\u7d2c\u8e0a") + this.desc);
                }
            }
        }
        return this;
    }

    public boolean matches(String string, String string2, String string3) {
        return this.matches(string, string2, string3, 0x9AB4BA92 ^ 0x9AB4BA92);
    }

    public boolean matches(String string, String string2, String string3, int n) {
        if (this.desc != null && string3 != null && !this.desc.equals(string3)) {
            return (0x5BF8C0EE ^ 0x5BF8C0EE) != 0;
        }
        if (this.name != null && string2 != null && !this.name.equals(string2)) {
            return (0x4E6FCFA8 ^ 0x4E6FCFA8) != 0;
        }
        if (this.owner != null && string != null && !this.owner.equals(string)) {
            return (0xB7774B93 ^ 0xB7774B93) != 0;
        }
        return (n == 0 || this.matchAll ? 0x75E4BEB2 ^ 0x75E4BEB3 : 0xEC047C8B ^ 0xEC047C8B) != 0;
    }

    public boolean matches(String string, String string2) {
        return this.matches(string, string2, 0x55D969BD ^ 0x55D969BD);
    }

    public boolean matches(String string, String string2, int n) {
        return ((this.name == null || this.name.equals(string)) && (this.desc == null || string2 != null && string2.equals(this.desc)) && (n == 0 || this.matchAll) ? 0x94025942 ^ 0x94025943 : 0x71B80D27 ^ 0x71B80D27) != 0;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != MemberInfo.class) {
            return (0xEB91D3E6 ^ 0xEB91D3E6) != 0;
        }
        MemberInfo memberInfo = (MemberInfo)object;
        return (this.matchAll == memberInfo.matchAll && this.forceField == memberInfo.forceField && Objects.equal((Object)this.owner, (Object)memberInfo.owner) && Objects.equal((Object)this.name, (Object)memberInfo.name) && Objects.equal((Object)this.desc, (Object)memberInfo.desc) ? 0x6BD7753E ^ 0x6BD7753F : 0xE1F0B496 ^ 0xE1F0B496) != 0;
    }

    public int hashCode() {
        Object[] objectArray = new Object[0x4152AB6D ^ 0x4152AB69];
        objectArray[0x616ECE18 ^ 0x616ECE18] = this.matchAll;
        objectArray[0xCA336A17 ^ 0xCA336A16] = this.owner;
        objectArray[0x104C1E09 ^ 0x104C1E0B] = this.name;
        objectArray[0x5471E760 ^ 0x5471E763] = this.desc;
        return Objects.hashCode((Object[])objectArray);
    }

    public MemberInfo move(String string) {
        if (string == null && this.owner == null || string != null && string.equals(this.owner)) {
            return this;
        }
        return new MemberInfo(this, string);
    }

    public MemberInfo transform(String string) {
        if (string == null && this.desc == null || string != null && string.equals(this.desc)) {
            return this;
        }
        return new MemberInfo(this.name, this.owner, string, this.matchAll);
    }

    public MemberInfo remapUsing(MappingMethod mappingMethod, boolean bl) {
        return new MemberInfo(this, mappingMethod, bl);
    }

    public static MemberInfo parseAndValidate(String string) throws InvalidMemberDescriptorException {
        return MemberInfo.parse(string, null, null).validate();
    }

    public static MemberInfo parseAndValidate(String string, IMixinContext iMixinContext) throws InvalidMemberDescriptorException {
        return MemberInfo.parse(string, iMixinContext.getReferenceMapper(), iMixinContext.getClassRef()).validate();
    }

    public static MemberInfo parse(String string) {
        return MemberInfo.parse(string, null, null);
    }

    public static MemberInfo parse(String string, IMixinContext iMixinContext) {
        return MemberInfo.parse(string, iMixinContext.getReferenceMapper(), iMixinContext.getClassRef());
    }

    private static MemberInfo parse(String string, IReferenceMapper iReferenceMapper, String string2) {
        boolean bl;
        String string3;
        String string4;
        String string5;
        block14: {
            block13: {
                string5 = null;
                string4 = null;
                string3 = Strings.nullToEmpty((String)string).replaceAll(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("N\ua7f5"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(""));
                if (iReferenceMapper != null) {
                    string3 = iReferenceMapper.remap(string2, string3);
                }
                int n = string3.lastIndexOf(0x714366E2 ^ 0x714366CC);
                int n2 = string3.indexOf(0x292422B7 ^ 0x2924228C);
                if (n > (0x677E62B3 ^ 0x98819D4C)) {
                    string4 = string3.substring(0xD99F882E ^ 0xD99F882E, n).replace((char)(0xB0BF7082 ^ 0xB0BF70AC), (char)(0x5EACB64 ^ 0x5EACB4B));
                    string3 = string3.substring(n + (0xB1AC4CDA ^ 0xB1AC4CDB));
                } else if (n2 > (0xF8F0B257 ^ 0x70F4DA8) && string3.startsWith(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^"))) {
                    string4 = string3.substring(0xDBBF38A7 ^ 0xDBBF38A6, n2).replace((char)(0x368FC8DC ^ 0x368FC8F2), (char)(0x52BE5166 ^ 0x52BE5149));
                    string3 = string3.substring(n2 + (0x448BE713 ^ 0x448BE712));
                }
                int n3 = string3.indexOf(0xFEE33DF7 ^ 0xFEE33DDF);
                int n4 = string3.indexOf(0x162F30A9 ^ 0x162F3093);
                if (n3 > (0x2983CAA2 ^ 0xD67C355D)) {
                    string5 = string3.substring(n3);
                    string3 = string3.substring(0x1705593F ^ 0x1705593F, n3);
                } else if (n4 > (0x9C480D5D ^ 0x63B7F2A2)) {
                    string5 = string3.substring(n4 + (0x5FAC3F92 ^ 0x5FAC3F93));
                    string3 = string3.substring(0x7D183095 ^ 0x7D183095, n4);
                }
                if (string3.indexOf(0xD04CD1A6 ^ 0xD04CD189) > (0xA1E5158 ^ 0xF5E1AEA7)) break block13;
                if (string3.indexOf(0xEFE77649 ^ 0xEFE77667) <= (0x78B46C8B ^ 0x874B9374)) break block14;
            }
            if (string4 == null) {
                string4 = string3;
                string3 = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("");
            }
        }
        if (bl = string3.endsWith(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("8"))) {
            string3 = string3.substring(0xE5E22A8A ^ 0xE5E22A8A, string3.length() - (0x172733A2 ^ 0x172733A3));
        }
        if (string3.isEmpty()) {
            string3 = null;
        }
        return new MemberInfo(string3, string4, string5, bl, string);
    }

    public static MemberInfo fromMapping(IMapping<?> iMapping) {
        return new MemberInfo(iMapping);
    }
}

