/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.struct;

import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTransformerError;
import org.spongepowered.asm.util.Bytecode;

public abstract class MemberRef {
    private static final int[] H_OPCODES;

    public abstract boolean isField();

    public abstract int getOpcode();

    public abstract void setOpcode(int var1);

    public abstract String getOwner();

    public abstract void setOwner(String var1);

    public abstract String getName();

    public abstract void setName(String var1);

    public abstract String getDesc();

    public abstract void setDesc(String var1);

    public String toString() {
        String string = Bytecode.getOpcodeName(this.getOpcode());
        Object[] objectArray = new Object[0xA3FD8A38 ^ 0xA3FD8A3D];
        objectArray[0xDAAB972E ^ 0xDAAB972E] = string;
        objectArray[0x5084943F ^ 0x5084943E] = this.getOwner();
        objectArray[0x774E726D ^ 0x774E726F] = this.getName();
        objectArray[0x215C6866 ^ 0x215C6865] = this.isField() ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("(") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("");
        objectArray[0x58BC6DCF ^ 0x58BC6DCB] = this.getDesc();
        return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f5\ua077\ua90a\u7d64\u8e0a\u243f\u8b24\u34397\ua7f5\ua4f0\ua062\ua940\u7d65"), objectArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof MemberRef)) {
            return (0x186AAF4B ^ 0x186AAF4B) != 0;
        }
        MemberRef memberRef = (MemberRef)object;
        return (this.getOpcode() == memberRef.getOpcode() && this.getOwner().equals(memberRef.getOwner()) && this.getName().equals(memberRef.getName()) && this.getDesc().equals(memberRef.getDesc()) ? 0x1EB03C6D ^ 0x1EB03C6C : 0xA1D68998 ^ 0xA1D68998) != 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    static int opcodeFromTag(int n) {
        return n >= 0 && n < H_OPCODES.length ? H_OPCODES[n] : 0xD6CD2430 ^ 0xD6CD2430;
    }

    static int tagFromOpcode(int n) {
        for (int i = 0x70685CE4 ^ 0x70685CE5; i < H_OPCODES.length; ++i) {
            if (H_OPCODES[i] != n) continue;
            return i;
        }
        return 0xDE6C4FBE ^ 0xDE6C4FBE;
    }

    static {
        int[] nArray = new int[0x35B648D1 ^ 0x35B648DB];
        nArray[0x5C02AEC4 ^ 0x5C02AEC4] = 0x856110BF ^ 0x856110BF;
        nArray[0x2B48D3AC ^ 0x2B48D3AD] = 0x715F0529 ^ 0x715F059D;
        nArray[0x34595C8D ^ 0x34595C8F] = 0xFDE0DCAB ^ 0xFDE0DC19;
        nArray[0xA0534270 ^ 0xA0534273] = 0x7F9A8899 ^ 0x7F9A882C;
        nArray[0x5E3CA1A1 ^ 0x5E3CA1A5] = 0x239F64B2 ^ 0x239F6401;
        nArray[0x5B336088 ^ 0x5B33608D] = 0xF774FB58 ^ 0xF774FBEE;
        nArray[0x76F836D6 ^ 0x76F836D0] = 0x269878C8 ^ 0x26987870;
        nArray[0x27CE4AA6 ^ 0x27CE4AA1] = 0xA9D90B47 ^ 0xA9D90BF0;
        nArray[0xB0FE8E9E ^ 0xB0FE8E96] = 0xFFFBC2B6 ^ 0xFFFBC201;
        nArray[0x75ABE21B ^ 0x75ABE212] = 0xCD583931 ^ 0xCD583988;
        H_OPCODES = nArray;
    }

    public static final class Handle
    extends MemberRef {
        private org.spongepowered.asm.lib.Handle handle;

        public Handle(org.spongepowered.asm.lib.Handle handle) {
            this.handle = handle;
        }

        public org.spongepowered.asm.lib.Handle getMethodHandle() {
            return this.handle;
        }

        @Override
        public boolean isField() {
            switch (this.handle.getTag()) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return (0x1B4AC8D4 ^ 0x1B4AC8D4) != 0;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return (0xA9F5C0B7 ^ 0xA9F5C0B6) != 0;
                }
            }
            throw new MixinTransformerError(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u3476u\ua7a6") + this.handle.getTag() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e0\ua4ba\ua063\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a6\ua4bd\ua070\ua90b\u7d72\u8e46\u247f\u8b77") + this.handle + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("<"));
        }

        @Override
        public int getOpcode() {
            int n = MemberRef.opcodeFromTag(this.handle.getTag());
            if (n == 0) {
                throw new MixinTransformerError(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u3476u\ua7a6") + this.handle.getTag() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e0\ua4ba\ua063\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a6\ua4bd\ua070\ua90b\u7d72\u8e46\u247f\u8b77") + this.handle + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("<"));
            }
            return n;
        }

        @Override
        public void setOpcode(int n) {
            int n2 = MemberRef.tagFromOpcode(n);
            if (n2 == 0) {
                throw new MixinTransformerError(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b38\u3467q\ua7e9\ua4b1\ua074\ua945") + Bytecode.getOpcodeName(n) + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e0\ua4ba\ua063\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a6\ua4bd\ua070\ua90b\u7d72\u8e46\u247f\u8b77") + this.handle + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("<"));
            }
            int n3 = n2 == (0xC3497BA7 ^ 0xC3497BAE) ? 0x973BE0D1 ^ 0x973BE0D0 : 0x590987F0 ^ 0x590987F0;
            this.handle = new org.spongepowered.asm.lib.Handle(n2, this.handle.getOwner(), this.handle.getName(), this.handle.getDesc(), n3 != 0);
        }

        @Override
        public String getOwner() {
            return this.handle.getOwner();
        }

        @Override
        public void setOwner(String string) {
            int n = this.handle.getTag() == (0x83CE03DE ^ 0x83CE03D7) ? 0xCA0854BB ^ 0xCA0854BA : 0xD2E64E9D ^ 0xD2E64E9D;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), string, this.handle.getName(), this.handle.getDesc(), n != 0);
        }

        @Override
        public String getName() {
            return this.handle.getName();
        }

        @Override
        public void setName(String string) {
            int n = this.handle.getTag() == (0x2D72C778 ^ 0x2D72C771) ? 0xFE8A9939 ^ 0xFE8A9938 : 0x521B45EA ^ 0x521B45EA;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), this.handle.getOwner(), string, this.handle.getDesc(), n != 0);
        }

        @Override
        public String getDesc() {
            return this.handle.getDesc();
        }

        @Override
        public void setDesc(String string) {
            int n = this.handle.getTag() == (0x15ADE15F ^ 0x15ADE156) ? 0xCD02EC55 ^ 0xCD02EC54 : 0x3E8998C5 ^ 0x3E8998C5;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), this.handle.getOwner(), this.handle.getName(), string, n != 0);
        }
    }

    public static final class Field
    extends MemberRef {
        private static final int OPCODES = 183;
        public final FieldInsnNode insn;

        public Field(FieldInsnNode fieldInsnNode) {
            this.insn = fieldInsnNode;
        }

        @Override
        public boolean isField() {
            return (0x53864DB7 ^ 0x53864DB6) != 0;
        }

        @Override
        public int getOpcode() {
            return this.insn.getOpcode();
        }

        @Override
        public void setOpcode(int n) {
            if ((n & (0xCD8C2B1F ^ 0xCD8C2BA8)) == 0) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b38\u3467q\ua7e9\ua4b1\ua074\ua945\u7d70\u8e45\u2468\u8b77\u3471{\ua7e3\ua4b9\ua075\ua945\u7d7f\u8e44\u2469\u8b23\u3465g\ua7e5\ua4a1\ua078\ua90a\u7d78\u8e10\u243a\u8b67\u346f") + Integer.toHexString(n));
            }
            this.insn.setOpcode(n);
        }

        @Override
        public String getOwner() {
            return this.insn.owner;
        }

        @Override
        public void setOwner(String string) {
            this.insn.owner = string;
        }

        @Override
        public String getName() {
            return this.insn.name;
        }

        @Override
        public void setName(String string) {
            this.insn.name = string;
        }

        @Override
        public String getDesc() {
            return this.insn.desc;
        }

        @Override
        public void setDesc(String string) {
            this.insn.desc = string;
        }
    }

    public static final class Method
    extends MemberRef {
        private static final int OPCODES = 191;
        public final MethodInsnNode insn;

        public Method(MethodInsnNode methodInsnNode) {
            this.insn = methodInsnNode;
        }

        @Override
        public boolean isField() {
            return (0xC82E1C2F ^ 0xC82E1C2F) != 0;
        }

        @Override
        public int getOpcode() {
            return this.insn.getOpcode();
        }

        @Override
        public void setOpcode(int n) {
            if ((n & (0xA6B40C4D ^ 0xA6B40CF2)) == 0) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b38\u3467q\ua7e9\ua4b1\ua074\ua945\u7d70\u8e45\u2468\u8b77\u347aw\ua7f2\ua4bd\ua07e\ua901\u7d36\u8e43\u2474\u8b24\u3463`\ua7f3\ua4b6\ua065\ua90c\u7d79\u8e44\u2420\u8b77\u3427j") + Integer.toHexString(n));
            }
            this.insn.setOpcode(n);
        }

        @Override
        public String getOwner() {
            return this.insn.owner;
        }

        @Override
        public void setOwner(String string) {
            this.insn.owner = string;
        }

        @Override
        public String getName() {
            return this.insn.name;
        }

        @Override
        public void setName(String string) {
            this.insn.name = string;
        }

        @Override
        public String getDesc() {
            return this.insn.desc;
        }

        @Override
        public void setDesc(String string) {
            this.insn.desc = string;
        }
    }
}

