/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.struct.MemberRef;
import org.spongepowered.asm.mixin.transformer.ClassInfo;

abstract class ClassContext {
    private final Set<ClassInfo.Method> upgradedMethods = new HashSet<ClassInfo.Method>();

    ClassContext() {
    }

    abstract String getClassRef();

    abstract ClassNode getClassNode();

    abstract ClassInfo getClassInfo();

    void addUpgradedMethod(MethodNode methodNode) {
        ClassInfo.Method method = this.getClassInfo().findMethod(methodNode);
        if (method == null) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("_\ua7e3\ua4a1\ua070\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a6\ua4b3\ua07e\ua917\u7d36") + methodNode.name + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e8\ua4ba\ua065\ua945\u7d7a\u8e45\u2479\u8b36\u3463w\ua7e2\ua4f5\ua078\ua90b\u7d36") + this);
        }
        this.upgradedMethods.add(method);
    }

    protected void upgradeMethods() {
        for (MethodNode methodNode : this.getClassNode().methods) {
            this.upgradeMethod(methodNode);
        }
    }

    private void upgradeMethod(MethodNode methodNode) {
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            MemberRef.Method method;
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (!(abstractInsnNode instanceof MethodInsnNode) || !((MemberRef)(method = new MemberRef.Method((MethodInsnNode)abstractInsnNode))).getOwner().equals(this.getClassRef())) continue;
            ClassInfo.Method method2 = this.getClassInfo().findMethod(((MemberRef)method).getName(), ((MemberRef)method).getDesc(), 0x92CABFCE ^ 0x92CABFC4);
            this.upgradeMethodRef(methodNode, method, method2);
        }
    }

    protected void upgradeMethodRef(MethodNode methodNode, MemberRef memberRef, ClassInfo.Method method) {
        if (memberRef.getOpcode() != (0x4DFE62BE ^ 0x4DFE6209)) {
            return;
        }
        if (this.upgradedMethods.contains(method)) {
            memberRef.setOpcode(0xE03E2A56 ^ 0xE03E2AE0);
        }
    }
}

