/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.FrameNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.transformer.MethodMapper;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.ClassSignature;
import org.spongepowered.asm.util.perf.Profiler;

public final class ClassInfo {
    public static final int INCLUDE_PRIVATE = 2;
    public static final int INCLUDE_STATIC = 8;
    public static final int INCLUDE_ALL = 10;
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    private static final Profiler profiler = MixinEnvironment.getProfiler();
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private static final Map<String, ClassInfo> cache = new HashMap<String, ClassInfo>();
    private static final ClassInfo OBJECT = new ClassInfo();
    private final String name;
    private final String superName;
    private final String outerName;
    private final boolean isProbablyStatic;
    private final Set<String> interfaces;
    private final Set<Method> methods;
    private final Set<Field> fields;
    private final Set<MixinInfo> mixins = new HashSet<MixinInfo>();
    private final Map<ClassInfo, ClassInfo> correspondingTypes = new HashMap<ClassInfo, ClassInfo>();
    private final MixinInfo mixin;
    private final MethodMapper methodMapper;
    private final boolean isMixin;
    private final boolean isInterface;
    private final int access;
    private ClassInfo superClass;
    private ClassInfo outerClass;
    private ClassSignature signature;

    private ClassInfo() {
        this.name = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62");
        this.superName = null;
        this.outerName = null;
        this.isProbablyStatic = 0x48E6B8F ^ 0x48E6B8E;
        Object[] objectArray = new Method[0x8C605944 ^ 0x8C605941];
        objectArray[0xDAF1FBA3 ^ 0xDAF1FBA3] = new Method(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("|\ua7e9\ua4a1\ua078\ua903\u7d6f\u8e6b\u2476\u8b3b"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(":\ua7af\ua483"));
        objectArray[0xA9B73082 ^ 0xA9B73083] = new Method(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("e\ua7e7\ua4bc\ua065"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(":\ua7cc\ua4fc\ua047"));
        objectArray[0xEA6882E6 ^ 0xEA6882E4] = new Method(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("e\ua7e7\ua4bc\ua065"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(":\ua7cc\ua49c\ua038\ua933"));
        objectArray[0xEE23AE93 ^ 0xEE23AE90] = new Method(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("e\ua7e7\ua4bc\ua065"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(":\ua7af\ua483"));
        objectArray[0xDEC7C630 ^ 0xDEC7C634] = new Method(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("t\ua7ef\ua4bb\ua070\ua909\u7d7f\u8e50\u247f"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(":\ua7af\ua483"));
        this.methods = ImmutableSet.of((Object)new Method(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("u\ua7e3\ua4a1\ua052\ua909\u7d77\u8e59\u2469"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(":\ua7af\ua499\ua07b\ua904\u7d60\u8e4b\u2435\u8b3b\u3476|\ua7e1\ua4fa\ua052\ua909\u7d77\u8e59\u2469\u8b6c")), (Object)new Method(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("z\ua7e7\ua4a6\ua079\ua926\u7d79\u8e4e\u247f"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(":\ua7af\ua49c")), (Object)new Method(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("w\ua7f7\ua4a0\ua070\ua909\u7d65"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(":\ua7ca\ua4bf\ua070\ua913\u7d77\u8e05\u2476\u8b36\u3479u\ua7a9\ua49a\ua073\ua90f\u7d73\u8e49\u246e\u8b6c\u343eH")), (Object)new Method(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("q\ua7ea\ua4ba\ua07f\ua900"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(":\ua7af\ua499\ua07b\ua904\u7d60\u8e4b\u2435\u8b3b\u3476|\ua7e1\ua4fa\ua05e\ua907\u7d7c\u8e4f\u2479\u8b23\u342c")), (Object)new Method(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("f\ua7e9\ua486\ua065\ua917\u7d7f\u8e44\u247d"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(":\ua7af\ua499\ua07b\ua904\u7d60\u8e4b\u2435\u8b3b\u3476|\ua7e1\ua4fa\ua042\ua911\u7d64\u8e43\u2474\u8b30\u342c")), (Object)new Method(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("|\ua7e9\ua4a1\ua078\ua903\u7d6f"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(":\ua7af\ua483")), (Object[])objectArray);
        this.fields = Collections.emptySet();
        this.isInterface = 0xA09AB1E5 ^ 0xA09AB1E5;
        this.interfaces = Collections.emptySet();
        this.access = 0xE988132F ^ 0xE988132E;
        this.isMixin = 0x67464C63 ^ 0x67464C63;
        this.mixin = null;
        this.methodMapper = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private ClassInfo(ClassNode classNode) {
        Profiler.Section section = profiler.begin(0x2600DE0B ^ 0x2600DE0A, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("q\ua7ea\ua4b4\ua062\ua916\u7d38\u8e47\u247f\u8b23\u3476"));
        try {
            void var4_7;
            this.name = classNode.name;
            this.superName = classNode.superName != null ? classNode.superName : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62");
            this.methods = new HashSet<Method>();
            this.fields = new HashSet<Field>();
            this.isInterface = (classNode.access & (0x72C7B6EB ^ 0x72C7B4EB)) != 0 ? 0xF3335DD0 ^ 0xF3335DD1 : 0xCC6035DC ^ 0xCC6035DC;
            this.interfaces = new HashSet<String>();
            this.access = classNode.access;
            this.isMixin = classNode instanceof MixinInfo.MixinClassNode;
            this.mixin = this.isMixin ? ((MixinInfo.MixinClassNode)classNode).getMixin() : null;
            this.interfaces.addAll(classNode.interfaces);
            for (MethodNode object2 : classNode.methods) {
                this.addMethod(object2, this.isMixin);
            }
            int n = 0x250FB9D ^ 0x250FB9C;
            String string = classNode.outerClass;
            for (FieldNode fieldNode : classNode.fields) {
                if ((fieldNode.access & (0x3BEA995C ^ 0x3BEA895C)) != 0 && fieldNode.name.startsWith(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("f\ua7ee\ua4bc\ua062\ua941"))) {
                    String string2;
                    n = 0xE8C17DD6 ^ 0xE8C17DD6;
                    if (var4_7 == null && (string2 = fieldNode.desc) != null && string2.startsWith(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^"))) {
                        String string3 = string2.substring(0xA9CDBEFB ^ 0xA9CDBEFA, string2.length() - (0x871C6F6F ^ 0x871C6F6E));
                    }
                }
                this.fields.add(new Field(fieldNode, this.isMixin));
            }
            this.isProbablyStatic = n;
            this.outerName = var4_7;
            this.methodMapper = new MethodMapper(MixinEnvironment.getCurrentEnvironment(), this);
            this.signature = ClassSignature.ofLazy(classNode);
        }
        finally {
            section.end();
        }
    }

    void addInterface(String string) {
        this.interfaces.add(string);
        this.getSignature().addInterface(string);
    }

    void addMethod(MethodNode methodNode) {
        this.addMethod(methodNode, (0xBEF7E09C ^ 0xBEF7E09D) != 0);
    }

    private void addMethod(MethodNode methodNode, boolean bl) {
        if (!methodNode.name.startsWith(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("."))) {
            this.methods.add(new Method(methodNode, bl));
        }
    }

    void addMixin(MixinInfo mixinInfo) {
        if (this.isMixin) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u247b\u8b33\u34732\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u243a") + this.name + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e0\ua4ba\ua063\ua945") + mixinInfo.getClassName() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e4\ua4b0\ua072\ua904\u7d63\u8e59\u247f\u8b77\u3463z\ua7e3\ua4f5\ua065\ua904\u7d64\u8e4d\u247f\u8b23\u3437{\ua7f5\ua4f5\ua070\ua945\u7d7b\u8e43\u2462\u8b3e\u3479"));
        }
        this.mixins.add(mixinInfo);
    }

    public Set<MixinInfo> getMixins() {
        return Collections.unmodifiableSet(this.mixins);
    }

    public boolean isMixin() {
        return this.isMixin;
    }

    public boolean isPublic() {
        return ((this.access & (0x3532E3C3 ^ 0x3532E3C2)) != 0 ? 0x1018BA52 ^ 0x1018BA53 : 0x38726A3 ^ 0x38726A3) != 0;
    }

    public boolean isAbstract() {
        return ((this.access & (0x17CAA39B ^ 0x17CAA79B)) != 0 ? 0xD4D7A018 ^ 0xD4D7A019 : 0x49AC2434 ^ 0x49AC2434) != 0;
    }

    public boolean isSynthetic() {
        return ((this.access & (0x33515A00 ^ 0x33514A00)) != 0 ? 0x8DFDFDBA ^ 0x8DFDFDBB : 0x1D4F45DB ^ 0x1D4F45DB) != 0;
    }

    public boolean isProbablyStatic() {
        return this.isProbablyStatic;
    }

    public boolean isInner() {
        return (this.outerName != null ? 0x4B70A36F ^ 0x4B70A36E : 0x1EDE9582 ^ 0x1EDE9582) != 0;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public Set<String> getInterfaces() {
        return Collections.unmodifiableSet(this.interfaces);
    }

    public String toString() {
        return this.name;
    }

    public MethodMapper getMethodMapper() {
        return this.methodMapper;
    }

    public int getAccess() {
        return this.access;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.name.replace((char)(0x3A08E31 ^ 0x3A08E1E), (char)(0x4AAE1B31 ^ 0x4AAE1B1F));
    }

    public String getSuperName() {
        return this.superName;
    }

    public ClassInfo getSuperClass() {
        if (this.superClass == null && this.superName != null) {
            this.superClass = ClassInfo.forName(this.superName);
        }
        return this.superClass;
    }

    public String getOuterName() {
        return this.outerName;
    }

    public ClassInfo getOuterClass() {
        if (this.outerClass == null && this.outerName != null) {
            this.outerClass = ClassInfo.forName(this.outerName);
        }
        return this.outerClass;
    }

    public ClassSignature getSignature() {
        return this.signature.wake();
    }

    List<ClassInfo> getTargets() {
        if (this.mixin != null) {
            ArrayList<ClassInfo> arrayList = new ArrayList<ClassInfo>();
            arrayList.add(this);
            arrayList.addAll(this.mixin.getTargets());
            return arrayList;
        }
        return ImmutableList.of((Object)this);
    }

    public Set<Method> getMethods() {
        return Collections.unmodifiableSet(this.methods);
    }

    public Set<Method> getInterfaceMethods(boolean bl) {
        HashSet<Method> hashSet = new HashSet<Method>();
        if (!this.isInterface) {
            for (ClassInfo classInfo = this.addMethodsRecursive(hashSet, bl); classInfo != null && classInfo != OBJECT; classInfo = classInfo.addMethodsRecursive(hashSet, bl)) {
            }
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            if (((Method)iterator.next()).isAbstract()) continue;
            iterator.remove();
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private ClassInfo addMethodsRecursive(Set<Method> set, boolean bl) {
        if (this.isInterface) {
            for (Method object : this.methods) {
                if (!object.isAbstract()) {
                    set.remove(object);
                }
                set.add(object);
            }
        } else if (!this.isMixin && bl) {
            for (MixinInfo mixinInfo : this.mixins) {
                mixinInfo.getClassInfo().addMethodsRecursive(set, bl);
            }
        }
        for (String string : this.interfaces) {
            ClassInfo.forName(string).addMethodsRecursive(set, bl);
        }
        return this.getSuperClass();
    }

    public boolean hasSuperClass(String string) {
        return this.hasSuperClass(string, Traversal.NONE);
    }

    public boolean hasSuperClass(String string, Traversal traversal) {
        if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62").equals(string)) {
            return (0x9C3779DA ^ 0x9C3779DB) != 0;
        }
        return (this.findSuperClass(string, traversal) != null ? 0x37A64B79 ^ 0x37A64B78 : 0x9682EFD0 ^ 0x9682EFD0) != 0;
    }

    public boolean hasSuperClass(ClassInfo classInfo) {
        return this.hasSuperClass(classInfo, Traversal.NONE, (0xB81EBAAE ^ 0xB81EBAAE) != 0);
    }

    public boolean hasSuperClass(ClassInfo classInfo, Traversal traversal) {
        return this.hasSuperClass(classInfo, traversal, (0x3533DD71 ^ 0x3533DD71) != 0);
    }

    public boolean hasSuperClass(ClassInfo classInfo, Traversal traversal, boolean bl) {
        if (OBJECT == classInfo) {
            return (0x3E0D145B ^ 0x3E0D145A) != 0;
        }
        return (this.findSuperClass(classInfo.name, traversal, bl) != null ? 0x2A2F964B ^ 0x2A2F964A : 0x1306510E ^ 0x1306510E) != 0;
    }

    public ClassInfo findSuperClass(String string) {
        return this.findSuperClass(string, Traversal.NONE);
    }

    public ClassInfo findSuperClass(String string, Traversal traversal) {
        return this.findSuperClass(string, traversal, (0x924464AB ^ 0x924464AB) != 0, new HashSet<String>());
    }

    public ClassInfo findSuperClass(String string, Traversal traversal, boolean bl) {
        if (ClassInfo.OBJECT.name.equals(string)) {
            return null;
        }
        return this.findSuperClass(string, traversal, bl, new HashSet<String>());
    }

    private ClassInfo findSuperClass(String string, Traversal traversal, boolean bl, Set<String> set) {
        Object object;
        Iterator<MixinInfo> iterator;
        ClassInfo classInfo = this.getSuperClass();
        if (classInfo != null) {
            iterator = classInfo.getTargets().iterator();
            while (iterator.hasNext()) {
                ClassInfo object2 = (ClassInfo)iterator.next();
                if (string.equals(object2.getName())) {
                    return classInfo;
                }
                object = object2.findSuperClass(string, traversal.next(), bl, set);
                if (object == null) continue;
                return object;
            }
        }
        if (bl && (iterator = this.findInterface(string)) != null) {
            return iterator;
        }
        if (traversal.canTraverse()) {
            for (MixinInfo mixinInfo : this.mixins) {
                object = mixinInfo.getClassName();
                if (set.contains(object)) continue;
                set.add((String)object);
                ClassInfo classInfo2 = mixinInfo.getClassInfo();
                if (string.equals(classInfo2.getName())) {
                    return classInfo2;
                }
                ClassInfo classInfo3 = classInfo2.findSuperClass(string, Traversal.ALL, bl, set);
                if (classInfo3 == null) continue;
                return classInfo3;
            }
        }
        return null;
    }

    private ClassInfo findInterface(String string) {
        for (String string2 : this.getInterfaces()) {
            ClassInfo classInfo = ClassInfo.forName(string2);
            if (string.equals(string2)) {
                return classInfo;
            }
            ClassInfo classInfo2 = classInfo.findInterface(string);
            if (classInfo2 == null) continue;
            return classInfo2;
        }
        return null;
    }

    ClassInfo findCorrespondingType(ClassInfo classInfo) {
        if (classInfo == null || !classInfo.isMixin || this.isMixin) {
            return null;
        }
        ClassInfo classInfo2 = this.correspondingTypes.get(classInfo);
        if (classInfo2 == null) {
            classInfo2 = this.findSuperTypeForMixin(classInfo);
            this.correspondingTypes.put(classInfo, classInfo2);
        }
        return classInfo2;
    }

    private ClassInfo findSuperTypeForMixin(ClassInfo classInfo) {
        for (ClassInfo classInfo2 = this; classInfo2 != null && classInfo2 != OBJECT; classInfo2 = classInfo2.getSuperClass()) {
            for (MixinInfo mixinInfo : classInfo2.mixins) {
                if (!mixinInfo.getClassInfo().equals(classInfo)) continue;
                return classInfo2;
            }
        }
        return null;
    }

    public boolean hasMixinInHierarchy() {
        if (!this.isMixin) {
            return (0xCA762A6F ^ 0xCA762A6F) != 0;
        }
        for (ClassInfo classInfo = this.getSuperClass(); classInfo != null && classInfo != OBJECT; classInfo = classInfo.getSuperClass()) {
            if (!classInfo.isMixin) continue;
            return (0x43A5CD7D ^ 0x43A5CD7C) != 0;
        }
        return (0x5B6CD564 ^ 0x5B6CD564) != 0;
    }

    public boolean hasMixinTargetInHierarchy() {
        if (this.isMixin) {
            return (0xE4232011 ^ 0xE4232011) != 0;
        }
        for (ClassInfo classInfo = this.getSuperClass(); classInfo != null && classInfo != OBJECT; classInfo = classInfo.getSuperClass()) {
            if (classInfo.mixins.size() <= 0) continue;
            return (0x6E0B3F98 ^ 0x6E0B3F99) != 0;
        }
        return (0x1ED6022B ^ 0x1ED6022B) != 0;
    }

    public Method findMethodInHierarchy(MethodNode methodNode, SearchType searchType) {
        return this.findMethodInHierarchy(methodNode.name, methodNode.desc, searchType, Traversal.NONE);
    }

    public Method findMethodInHierarchy(MethodNode methodNode, SearchType searchType, int n) {
        return this.findMethodInHierarchy(methodNode.name, methodNode.desc, searchType, Traversal.NONE, n);
    }

    public Method findMethodInHierarchy(MethodInsnNode methodInsnNode, SearchType searchType) {
        return this.findMethodInHierarchy(methodInsnNode.name, methodInsnNode.desc, searchType, Traversal.NONE);
    }

    public Method findMethodInHierarchy(MethodInsnNode methodInsnNode, SearchType searchType, int n) {
        return this.findMethodInHierarchy(methodInsnNode.name, methodInsnNode.desc, searchType, Traversal.NONE, n);
    }

    public Method findMethodInHierarchy(String string, String string2, SearchType searchType) {
        return this.findMethodInHierarchy(string, string2, searchType, Traversal.NONE);
    }

    public Method findMethodInHierarchy(String string, String string2, SearchType searchType, Traversal traversal) {
        return this.findMethodInHierarchy(string, string2, searchType, traversal, 0x71B9D0E5 ^ 0x71B9D0E5);
    }

    public Method findMethodInHierarchy(String string, String string2, SearchType searchType, Traversal traversal, int n) {
        return (Method)this.findInHierarchy(string, string2, searchType, traversal, n, Member.Type.METHOD);
    }

    public Field findFieldInHierarchy(FieldNode fieldNode, SearchType searchType) {
        return this.findFieldInHierarchy(fieldNode.name, fieldNode.desc, searchType, Traversal.NONE);
    }

    public Field findFieldInHierarchy(FieldNode fieldNode, SearchType searchType, int n) {
        return this.findFieldInHierarchy(fieldNode.name, fieldNode.desc, searchType, Traversal.NONE, n);
    }

    public Field findFieldInHierarchy(FieldInsnNode fieldInsnNode, SearchType searchType) {
        return this.findFieldInHierarchy(fieldInsnNode.name, fieldInsnNode.desc, searchType, Traversal.NONE);
    }

    public Field findFieldInHierarchy(FieldInsnNode fieldInsnNode, SearchType searchType, int n) {
        return this.findFieldInHierarchy(fieldInsnNode.name, fieldInsnNode.desc, searchType, Traversal.NONE, n);
    }

    public Field findFieldInHierarchy(String string, String string2, SearchType searchType) {
        return this.findFieldInHierarchy(string, string2, searchType, Traversal.NONE);
    }

    public Field findFieldInHierarchy(String string, String string2, SearchType searchType, Traversal traversal) {
        return this.findFieldInHierarchy(string, string2, searchType, traversal, 0x4462A427 ^ 0x4462A427);
    }

    public Field findFieldInHierarchy(String string, String string2, SearchType searchType, Traversal traversal, int n) {
        return (Field)this.findInHierarchy(string, string2, searchType, traversal, n, Member.Type.FIELD);
    }

    private <M extends Member> M findInHierarchy(String string, String string2, SearchType searchType, Traversal traversal, int n, Member.Type type) {
        ClassInfo classInfo;
        ClassInfo classInfo2;
        if (searchType == SearchType.ALL_CLASSES) {
            classInfo2 = this.findMember(string, string2, n, type);
            if (classInfo2 != null) {
                return (M)classInfo2;
            }
            if (traversal.canTraverse()) {
                for (MixinInfo object : this.mixins) {
                    classInfo = object.getClassInfo().findMember(string, string2, n, type);
                    if (classInfo == null) continue;
                    return (M)this.cloneMember(classInfo);
                }
            }
        }
        if ((classInfo2 = this.getSuperClass()) != null) {
            for (ClassInfo classInfo3 : classInfo2.getTargets()) {
                classInfo = classInfo3.findInHierarchy(string, string2, SearchType.ALL_CLASSES, traversal.next(), n & (0xAAE2FCD7 ^ 0x551D032A), type);
                if (classInfo == null) continue;
                return (M)classInfo;
            }
        }
        if (type == Member.Type.METHOD && (this.isInterface || MixinEnvironment.getCompatibilityLevel().supportsMethodsInInterfaces())) {
            for (String string3 : this.interfaces) {
                classInfo = ClassInfo.forName(string3);
                if (classInfo == null) {
                    Object[] objectArray = new Object[0x5E152DA1 ^ 0x5E152DA3];
                    objectArray[0x7BD676A2 ^ 0x7BD676A2] = string3;
                    objectArray[0xA0572E6D ^ 0xA0572E6C] = this.name;
                    logger.debug(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("T\ua7e7\ua4bc\ua07d\ua900\u7d72\u8e0a\u246e\u8b38\u3437`\ua7e3\ua4a6\ua07e\ua909\u7d60\u8e4f\u243a\u8b33\u3472q\ua7ea\ua4b4\ua063\ua900\u7d72\u8e0a\u2473\u8b39\u3463w\ua7f4\ua4b3\ua070\ua906\u7d73\u8e0a\u2461\u8b2a\u3437}\ua7e8\ua4f5\ua06a\ua918"), objectArray);
                    continue;
                }
                M m = classInfo.findInHierarchy(string, string2, SearchType.ALL_CLASSES, traversal.next(), n & (0xB833657D ^ 0x47CC9A80), type);
                if (m == null) continue;
                return (M)(this.isInterface ? m : new InterfaceMethod((Member)m));
            }
        }
        return null;
    }

    private <M extends Member> M cloneMember(M m) {
        if (m instanceof Method) {
            return (M)new Method(m);
        }
        return (M)new Field(m);
    }

    public Method findMethod(MethodNode methodNode) {
        return this.findMethod(methodNode.name, methodNode.desc, methodNode.access);
    }

    public Method findMethod(MethodNode methodNode, int n) {
        return this.findMethod(methodNode.name, methodNode.desc, n);
    }

    public Method findMethod(MethodInsnNode methodInsnNode) {
        return this.findMethod(methodInsnNode.name, methodInsnNode.desc, 0x2D888EBD ^ 0x2D888EBD);
    }

    public Method findMethod(MethodInsnNode methodInsnNode, int n) {
        return this.findMethod(methodInsnNode.name, methodInsnNode.desc, n);
    }

    public Method findMethod(String string, String string2, int n) {
        return (Method)this.findMember(string, string2, n, Member.Type.METHOD);
    }

    public Field findField(FieldNode fieldNode) {
        return this.findField(fieldNode.name, fieldNode.desc, fieldNode.access);
    }

    public Field findField(FieldInsnNode fieldInsnNode, int n) {
        return this.findField(fieldInsnNode.name, fieldInsnNode.desc, n);
    }

    public Field findField(String string, String string2, int n) {
        return (Field)this.findMember(string, string2, n, Member.Type.FIELD);
    }

    private <M extends Member> M findMember(String string, String string2, int n, Member.Type type) {
        Set<Member> set = type == Member.Type.METHOD ? this.methods : this.fields;
        for (Member member : set) {
            if (!member.equals(string, string2) || !member.matchesFlags(n)) continue;
            return (M)member;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClassInfo)) {
            return (0xFE2C038A ^ 0xFE2C038A) != 0;
        }
        return ((ClassInfo)object).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    static ClassInfo fromClassNode(ClassNode classNode) {
        ClassInfo classInfo = cache.get(classNode.name);
        if (classInfo == null) {
            classInfo = new ClassInfo(classNode);
            cache.put(classNode.name, classInfo);
        }
        return classInfo;
    }

    public static ClassInfo forName(String string) {
        ClassInfo classInfo = cache.get(string = string.replace((char)(0x95C298FC ^ 0x95C298D2), (char)(0x9E755C59 ^ 0x9E755C76)));
        if (classInfo == null) {
            try {
                ClassNode classNode = MixinService.getService().getBytecodeProvider().getClassNode(string);
                classInfo = new ClassInfo(classNode);
            }
            catch (Exception exception) {
                logger.catching(Level.TRACE, (Throwable)exception);
                Object[] objectArray = new Object[0x440C8158 ^ 0x440C815B];
                objectArray[0xE4595F5B ^ 0xE4595F5B] = string;
                objectArray[0x15D47E79 ^ 0x15D47E78] = exception.getClass().getName();
                objectArray[0xD4D09BA7 ^ 0xD4D09BA5] = exception.getMessage();
                logger.warn(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("W\ua7f4\ua4a7\ua07e\ua917\u7d36\u8e46\u2475\u8b36\u3473{\ua7e8\ua4b2\ua031\ua906\u7d7a\u8e4b\u2469\u8b24\u342d2\ua7fd\ua4a8\ua031\ua94d\u7d6d\u8e57\u2420\u8b77\u346co\ua7af"), objectArray);
            }
            cache.put(string, classInfo);
            Object[] objectArray = new Object[0x79CA1FB ^ 0x79CA1FA];
            objectArray[0x88D81961 ^ 0x88D81961] = string;
            logger.trace(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("S\ua7e2\ua4b1\ua074\ua901\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4b8\ua074\ua911\u7d77\u8e4e\u247b\u8b23\u34762\ua7e0\ua4ba\ua063\ua945\u7d6d\u8e57\u243a\u8b23\u34782\ua7eb\ua4b0\ua065\ua904\u7d72\u8e4b\u246e\u8b36\u3437q\ua7e7\ua4b6\ua079\ua900"), objectArray);
        }
        return classInfo;
    }

    public static ClassInfo forType(Type type) {
        if (type.getSort() == (0x14C58D01 ^ 0x14C58D08)) {
            return ClassInfo.forType(type.getElementType());
        }
        if (type.getSort() < (0x4E5B3428 ^ 0x4E5B3421)) {
            return null;
        }
        return ClassInfo.forName(type.getClassName().replace((char)(0xCCB58121 ^ 0xCCB5810F), (char)(0x4C507814 ^ 0x4C50783B)));
    }

    public static ClassInfo getCommonSuperClass(String string, String string2) {
        if (string == null || string2 == null) {
            return OBJECT;
        }
        return ClassInfo.getCommonSuperClass(ClassInfo.forName(string), ClassInfo.forName(string2));
    }

    public static ClassInfo getCommonSuperClass(Type type, Type type2) {
        block3: {
            block2: {
                if (type == null || type2 == null) break block2;
                if (type.getSort() != (0x27751944 ^ 0x2775194E)) break block2;
                if (type2.getSort() == (0xD324D122 ^ 0xD324D128)) break block3;
            }
            return OBJECT;
        }
        return ClassInfo.getCommonSuperClass(ClassInfo.forType(type), ClassInfo.forType(type2));
    }

    private static ClassInfo getCommonSuperClass(ClassInfo classInfo, ClassInfo classInfo2) {
        return ClassInfo.getCommonSuperClass(classInfo, classInfo2, (0x39F89E5E ^ 0x39F89E5E) != 0);
    }

    public static ClassInfo getCommonSuperClassOrInterface(String string, String string2) {
        if (string == null || string2 == null) {
            return OBJECT;
        }
        return ClassInfo.getCommonSuperClassOrInterface(ClassInfo.forName(string), ClassInfo.forName(string2));
    }

    public static ClassInfo getCommonSuperClassOrInterface(Type type, Type type2) {
        block3: {
            block2: {
                if (type == null || type2 == null) break block2;
                if (type.getSort() != (0xF54FB349 ^ 0xF54FB343)) break block2;
                if (type2.getSort() == (0x689EF4EC ^ 0x689EF4E6)) break block3;
            }
            return OBJECT;
        }
        return ClassInfo.getCommonSuperClassOrInterface(ClassInfo.forType(type), ClassInfo.forType(type2));
    }

    public static ClassInfo getCommonSuperClassOrInterface(ClassInfo classInfo, ClassInfo classInfo2) {
        return ClassInfo.getCommonSuperClass(classInfo, classInfo2, (0x5645CD6F ^ 0x5645CD6E) != 0);
    }

    private static ClassInfo getCommonSuperClass(ClassInfo classInfo, ClassInfo classInfo2, boolean bl) {
        if (classInfo.hasSuperClass(classInfo2, Traversal.NONE, bl)) {
            return classInfo2;
        }
        if (classInfo2.hasSuperClass(classInfo, Traversal.NONE, bl)) {
            return classInfo;
        }
        if (classInfo.isInterface() || classInfo2.isInterface()) {
            return OBJECT;
        }
        do {
            if ((classInfo = classInfo.getSuperClass()) != null) continue;
            return OBJECT;
        } while (!classInfo2.hasSuperClass(classInfo, Traversal.NONE, bl));
        return classInfo;
    }

    static {
        cache.put(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62"), OBJECT);
    }

    class Field
    extends Member {
        public Field(Member member) {
            super(member);
        }

        public Field(FieldNode fieldNode) {
            this(fieldNode, (0xEA7C11A6 ^ 0xEA7C11A6) != 0);
        }

        public Field(FieldNode fieldNode, boolean bl) {
            super(Member.Type.FIELD, fieldNode.name, fieldNode.desc, fieldNode.access, bl);
            this.setUnique((Annotations.getVisible(fieldNode, Unique.class) != null ? 0x46802B04 ^ 0x46802B05 : 0xAE7EE5D1 ^ 0xAE7EE5D1) != 0);
            if (Annotations.getVisible(fieldNode, Shadow.class) != null) {
                int n;
                int n2 = Annotations.getVisible(fieldNode, Final.class) != null ? 0xC173EEBE ^ 0xC173EEBF : (n = 0x59FDD4DF ^ 0x59FDD4DF);
                int n3 = Annotations.getVisible(fieldNode, Mutable.class) != null ? 0x7AB148EE ^ 0x7AB148EF : 0x43028F2D ^ 0x43028F2D;
                this.setDecoratedFinal(n != 0, n3 != 0);
            }
        }

        public Field(String string, String string2, int n) {
            super(Member.Type.FIELD, string, string2, n, (0xD92EB78D ^ 0xD92EB78D) != 0);
        }

        public Field(String string, String string2, int n, boolean bl) {
            super(Member.Type.FIELD, string, string2, n, bl);
        }

        @Override
        public ClassInfo getOwner() {
            return ClassInfo.this;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Field)) {
                return (0xFBB0E217 ^ 0xFBB0E217) != 0;
            }
            return super.equals(object);
        }

        @Override
        protected String getDisplayFormat() {
            return \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4ef\ua034\ua916");
        }
    }

    public class InterfaceMethod
    extends Method {
        private final ClassInfo owner;

        public InterfaceMethod(Member member) {
            super(member);
            this.owner = member.getOwner();
        }

        @Override
        public ClassInfo getOwner() {
            return this.owner;
        }

        @Override
        public ClassInfo getImplementor() {
            return ClassInfo.this;
        }
    }

    public class Method
    extends Member {
        private final List<FrameData> frames;
        private boolean isAccessor;

        public Method(Member member) {
            super(member);
            this.frames = member instanceof Method ? ((Method)member).frames : null;
        }

        public Method(MethodNode methodNode) {
            this(methodNode, (0x5A8DF03B ^ 0x5A8DF03B) != 0);
            this.setUnique((Annotations.getVisible(methodNode, Unique.class) != null ? 0xE6DB6624 ^ 0xE6DB6625 : 0xF603FBEC ^ 0xF603FBEC) != 0);
            Class[] classArray = new Class[0x5D690150 ^ 0x5D690152];
            classArray[0x8CA94C9C ^ 0x8CA94C9C] = Accessor.class;
            classArray[0x56952E3D ^ 0x56952E3C] = Invoker.class;
            this.isAccessor = Annotations.getSingleVisible(methodNode, classArray) != null ? 0xF55E9D56 ^ 0xF55E9D57 : 0xA60500B1 ^ 0xA60500B1;
        }

        public Method(MethodNode methodNode, boolean bl) {
            super(Member.Type.METHOD, methodNode.name, methodNode.desc, methodNode.access, bl);
            this.frames = this.gatherFrames(methodNode);
            this.setUnique((Annotations.getVisible(methodNode, Unique.class) != null ? 0xB3820895 ^ 0xB3820894 : 0x953B8BFC ^ 0x953B8BFC) != 0);
            Class[] classArray = new Class[0xECBEFEAA ^ 0xECBEFEA8];
            classArray[0x8D4A9988 ^ 0x8D4A9988] = Accessor.class;
            classArray[0xC914258A ^ 0xC914258B] = Invoker.class;
            this.isAccessor = Annotations.getSingleVisible(methodNode, classArray) != null ? 0x2DB3E6F3 ^ 0x2DB3E6F2 : 0x97ABB514 ^ 0x97ABB514;
        }

        public Method(String string, String string2) {
            super(Member.Type.METHOD, string, string2, 0xFBA13FAF ^ 0xFBA13FAE, (0xCFC454E1 ^ 0xCFC454E1) != 0);
            this.frames = null;
        }

        public Method(String string, String string2, int n) {
            super(Member.Type.METHOD, string, string2, n, (0xEE59BBD2 ^ 0xEE59BBD2) != 0);
            this.frames = null;
        }

        public Method(String string, String string2, int n, boolean bl) {
            super(Member.Type.METHOD, string, string2, n, bl);
            this.frames = null;
        }

        private List<FrameData> gatherFrames(MethodNode methodNode) {
            ArrayList<FrameData> arrayList = new ArrayList<FrameData>();
            ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
            while (listIterator.hasNext()) {
                AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
                if (!(abstractInsnNode instanceof FrameNode)) continue;
                arrayList.add(new FrameData(methodNode.instructions.indexOf(abstractInsnNode), (FrameNode)abstractInsnNode));
            }
            return arrayList;
        }

        public List<FrameData> getFrames() {
            return this.frames;
        }

        @Override
        public ClassInfo getOwner() {
            return ClassInfo.this;
        }

        public boolean isAccessor() {
            return this.isAccessor;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Method)) {
                return (0xEDA388F3 ^ 0xEDA388F3) != 0;
            }
            return super.equals(object);
        }
    }

    static abstract class Member {
        private final Type type;
        private final String memberName;
        private final String memberDesc;
        private final boolean isInjected;
        private final int modifiers;
        private String currentName;
        private String currentDesc;
        private boolean decoratedFinal;
        private boolean decoratedMutable;
        private boolean unique;

        protected Member(Member member) {
            this(member.type, member.memberName, member.memberDesc, member.modifiers, member.isInjected);
            this.currentName = member.currentName;
            this.currentDesc = member.currentDesc;
            this.unique = member.unique;
        }

        protected Member(Type type, String string, String string2, int n) {
            this(type, string, string2, n, (0x175344D0 ^ 0x175344D0) != 0);
        }

        protected Member(Type type, String string, String string2, int n, boolean bl) {
            this.type = type;
            this.memberName = string;
            this.memberDesc = string2;
            this.isInjected = bl;
            this.currentName = string;
            this.currentDesc = string2;
            this.modifiers = n;
        }

        public String getOriginalName() {
            return this.memberName;
        }

        public String getName() {
            return this.currentName;
        }

        public String getOriginalDesc() {
            return this.memberDesc;
        }

        public String getDesc() {
            return this.currentDesc;
        }

        public boolean isInjected() {
            return this.isInjected;
        }

        public boolean isRenamed() {
            return (!this.currentName.equals(this.memberName) ? 0xEFF6F28B ^ 0xEFF6F28A : 0x5A04F81F ^ 0x5A04F81F) != 0;
        }

        public boolean isRemapped() {
            return (!this.currentDesc.equals(this.memberDesc) ? 0x94332F3A ^ 0x94332F3B : 0x30B2E685 ^ 0x30B2E685) != 0;
        }

        public boolean isPrivate() {
            return ((this.modifiers & (0xB35EADFA ^ 0xB35EADF8)) != 0 ? 0x705F6610 ^ 0x705F6611 : 0x2187BAC ^ 0x2187BAC) != 0;
        }

        public boolean isStatic() {
            return ((this.modifiers & (0x1C0C3A35 ^ 0x1C0C3A3D)) != 0 ? 0xA2597DB ^ 0xA2597DA : 0xE2EE2D55 ^ 0xE2EE2D55) != 0;
        }

        public boolean isAbstract() {
            return ((this.modifiers & (0xAB8D13D1 ^ 0xAB8D17D1)) != 0 ? 0x7F010217 ^ 0x7F010216 : 0x6923A8F1 ^ 0x6923A8F1) != 0;
        }

        public boolean isFinal() {
            return ((this.modifiers & (0x62D42BD0 ^ 0x62D42BC0)) != 0 ? 0x144A3955 ^ 0x144A3954 : 0x7A4721DD ^ 0x7A4721DD) != 0;
        }

        public boolean isSynthetic() {
            return ((this.modifiers & (0x57084795 ^ 0x57085795)) != 0 ? 0x687EDD91 ^ 0x687EDD90 : 0xE62F6B7D ^ 0xE62F6B7D) != 0;
        }

        public boolean isUnique() {
            return this.unique;
        }

        public void setUnique(boolean bl) {
            this.unique = bl;
        }

        public boolean isDecoratedFinal() {
            return this.decoratedFinal;
        }

        public boolean isDecoratedMutable() {
            return this.decoratedMutable;
        }

        public void setDecoratedFinal(boolean bl, boolean bl2) {
            this.decoratedFinal = bl;
            this.decoratedMutable = bl2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean matchesFlags(int n) {
            int n2;
            if (((this.modifiers ^ (0x47C507 ^ 0xFFB83AF8) | n & (0x3A3309DC ^ 0x3A3309DE)) & (0xAE1E0791 ^ 0xAE1E0793)) != 0) {
                if (((this.modifiers ^ (0x1FDB0E81 ^ 0xE024F17E) | n & (0xD11D4E09 ^ 0xD11D4E01)) & (0x919261C ^ 0x9192614)) != 0) {
                    n2 = 0xA48AB2A6 ^ 0xA48AB2A7;
                    return n2 != 0;
                }
            }
            n2 = 0x37BC13B6 ^ 0x37BC13B6;
            return n2 != 0;
        }

        public abstract ClassInfo getOwner();

        public ClassInfo getImplementor() {
            return this.getOwner();
        }

        public int getAccess() {
            return this.modifiers;
        }

        public String renameTo(String string) {
            this.currentName = string;
            return string;
        }

        public String remapTo(String string) {
            this.currentDesc = string;
            return string;
        }

        public boolean equals(String string, String string2) {
            return ((this.memberName.equals(string) || this.currentName.equals(string)) && (this.memberDesc.equals(string2) || this.currentDesc.equals(string2)) ? 0x8B17F2FD ^ 0x8B17F2FC : 0x85DFA462 ^ 0x85DFA462) != 0;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Member)) {
                return (0x8D030709 ^ 0x8D030709) != 0;
            }
            Member member = (Member)object;
            return ((member.memberName.equals(this.memberName) || member.currentName.equals(this.currentName)) && (member.memberDesc.equals(this.memberDesc) || member.currentDesc.equals(this.currentDesc)) ? 0x15478E26 ^ 0x15478E27 : 0xB386ED16 ^ 0xB386ED16) != 0;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            Object[] objectArray = new Object[0x40A47A36 ^ 0x40A47A34];
            objectArray[0xBC3DB4CD ^ 0xBC3DB4CD] = this.memberName;
            objectArray[0xF16010BF ^ 0xF16010BE] = this.memberDesc;
            return String.format(this.getDisplayFormat(), objectArray);
        }

        protected String getDisplayFormat() {
            return \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f0\ua062");
        }

        static final class Type
        extends Enum<Type> {
            public static final /* enum */ Type METHOD = new Type();
            public static final /* enum */ Type FIELD = new Type();
            private static final /* synthetic */ Type[] $VALUES;

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String string) {
                return Enum.valueOf(Type.class, string);
            }

            static {
                Type[] typeArray = new Type[0x1DCE1140 ^ 0x1DCE1142];
                typeArray[0x12CE6C7 ^ 0x12CE6C7] = METHOD;
                typeArray[0x3E129C21 ^ 0x3E129C20] = FIELD;
                $VALUES = typeArray;
            }
        }
    }

    public static class FrameData {
        private static final String[] FRAMETYPES;
        public final int index;
        public final int type;
        public final int locals;

        FrameData(int n, int n2, int n3) {
            this.index = n;
            this.type = n2;
            this.locals = n3;
        }

        FrameData(int n, FrameNode frameNode) {
            this.index = n;
            this.type = frameNode.type;
            this.locals = frameNode.local != null ? frameNode.local.size() : 0x214DC36B ^ 0x214DC36B;
        }

        public String toString() {
            Object[] objectArray = new Object[0xD2CB9D6C ^ 0xD2CB9D6F];
            objectArray[0x9B465757 ^ 0x9B465757] = this.index;
            objectArray[0x703E8F79 ^ 0x703E8F78] = FRAMETYPES[this.type + (0x29615949 ^ 0x29615948)];
            objectArray[0xA5D37BE1 ^ 0xA5D37BE3] = this.locals;
            return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("T\ua7f4\ua4b4\ua07c\ua900\u7d52\u8e4b\u246e\u8b36\u344c{\ua7e8\ua4b1\ua074\ua91d\u7d2b\u8e0f\u247e\u8b7b\u3437f\ua7ff\ua4a5\ua074\ua958\u7d33\u8e59\u2436\u8b77\u347b}\ua7e5\ua4b4\ua07d\ua916\u7d2b\u8e0f\u247e\u8b0a"), objectArray);
        }

        static {
            String[] stringArray = new String[0x64240EF5 ^ 0x64240EF3];
            stringArray[0x2B84E1DE ^ 0x2B84E1DE] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\\\ua7c3\ua482");
            stringArray[0x3E780FC6 ^ 0x3E780FC7] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("T\ua7d3\ua499\ua05d");
            stringArray[0xBBE326DC ^ 0xBBE326DE] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("S\ua7d6\ua485\ua054\ua92b\u7d52");
            stringArray[0x39A14650 ^ 0x39A14653] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7ce\ua49a\ua041");
            stringArray[0x39A468C6 ^ 0x39A468C2] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7c7\ua498\ua054");
            stringArray[0x2D5F689A ^ 0x2D5F689F] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7c7\ua498\ua054\ua954");
            FRAMETYPES = stringArray;
        }
    }

    public static final class Traversal
    extends Enum<Traversal> {
        public static final /* enum */ Traversal NONE = new Traversal(null, (0xA72B0591 ^ 0xA72B0591) != 0, SearchType.SUPER_CLASSES_ONLY);
        public static final /* enum */ Traversal ALL = new Traversal(null, (0x217E14FC ^ 0x217E14FD) != 0, SearchType.ALL_CLASSES);
        public static final /* enum */ Traversal IMMEDIATE = new Traversal(NONE, (0x7A964C95 ^ 0x7A964C94) != 0, SearchType.SUPER_CLASSES_ONLY);
        public static final /* enum */ Traversal SUPER = new Traversal(ALL, (0x15A3415E ^ 0x15A3415E) != 0, SearchType.SUPER_CLASSES_ONLY);
        private final Traversal next;
        private final boolean traverse;
        private final SearchType searchType;
        private static final /* synthetic */ Traversal[] $VALUES;

        public static Traversal[] values() {
            return (Traversal[])$VALUES.clone();
        }

        public static Traversal valueOf(String string) {
            return Enum.valueOf(Traversal.class, string);
        }

        private Traversal(Traversal traversal, boolean bl, SearchType searchType) {
            this.next = traversal != null ? traversal : this;
            this.traverse = bl;
            this.searchType = searchType;
        }

        public Traversal next() {
            return this.next;
        }

        public boolean canTraverse() {
            return this.traverse;
        }

        public SearchType getSearchType() {
            return this.searchType;
        }

        static {
            Traversal[] traversalArray = new Traversal[0x4B0C4DAB ^ 0x4B0C4DAF];
            traversalArray[0xB2FA0DC9 ^ 0xB2FA0DC9] = NONE;
            traversalArray[0x31A016F4 ^ 0x31A016F5] = ALL;
            traversalArray[0x97AE11A7 ^ 0x97AE11A5] = IMMEDIATE;
            traversalArray[0x7A5A5FF6 ^ 0x7A5A5FF5] = SUPER;
            $VALUES = traversalArray;
        }
    }

    public static final class SearchType
    extends Enum<SearchType> {
        public static final /* enum */ SearchType ALL_CLASSES = new SearchType();
        public static final /* enum */ SearchType SUPER_CLASSES_ONLY = new SearchType();
        private static final /* synthetic */ SearchType[] $VALUES;

        public static SearchType[] values() {
            return (SearchType[])$VALUES.clone();
        }

        public static SearchType valueOf(String string) {
            return Enum.valueOf(SearchType.class, string);
        }

        static {
            SearchType[] searchTypeArray = new SearchType[0x19070CA5 ^ 0x19070CA7];
            searchTypeArray[0x5583F31A ^ 0x5583F31A] = ALL_CLASSES;
            searchTypeArray[0x92B6A073 ^ 0x92B6A072] = SUPER_CLASSES_ONLY;
            $VALUES = searchTypeArray;
        }
    }
}

