/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.util.Counter;

public class MethodMapper {
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    private static final List<String> classes = new ArrayList<String>();
    private static final Map<String, Counter> methods = new HashMap<String, Counter>();
    private final ClassInfo info;

    public MethodMapper(MixinEnvironment mixinEnvironment, ClassInfo classInfo) {
        this.info = classInfo;
    }

    public ClassInfo getClassInfo() {
        return this.info;
    }

    public void remapHandlerMethod(MixinInfo mixinInfo, MethodNode methodNode, ClassInfo.Method method) {
        if (!(methodNode instanceof MixinInfo.MixinMethodNode) || !((MixinInfo.MixinMethodNode)methodNode).isInjector()) {
            return;
        }
        if (method.isUnique()) {
            Object[] objectArray = new Object[0xE955F620 ^ 0xE955F622];
            objectArray[0xE71131D7 ^ 0xE71131D7] = method;
            objectArray[0x3B9D9DC4 ^ 0x3B9D9DC5] = mixinInfo;
            logger.warn(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7e3\ua4b1\ua064\ua90b\u7d72\u8e4b\u2474\u8b23\u3437R\ua7d3\ua4bb\ua078\ua914\u7d63\u8e4f\u243a\u8b38\u34792\ua7ef\ua4bb\ua07b\ua900\u7d75\u8e5e\u2475\u8b25\u3437\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2461\u8b2a\u3437{\ua7e8\ua4f5\ua06a\ua918\u7d38\u8e0a\u2453\u8b39\u347dw\ua7e5\ua4a1\ua07e\ua917\u7d65\u8e0a\u247b\u8b25\u34722\ua7ef\ua4b8\ua061\ua909\u7d7f\u8e49\u2473\u8b23\u347bk\ua7a6\ua4a0\ua07f\ua90c\u7d67\u8e5f\u247f"), objectArray);
        }
        if (method.isRenamed()) {
            methodNode.name = method.getName();
            return;
        }
        String string = this.getHandlerName((MixinInfo.MixinMethodNode)methodNode);
        methodNode.name = method.renameTo(string);
    }

    public String getHandlerName(MixinInfo.MixinMethodNode mixinMethodNode) {
        String string = InjectionInfo.getInjectorPrefix(mixinMethodNode.getInjectorAnnotation());
        String string2 = MethodMapper.getClassUID(mixinMethodNode.getOwner().getClassRef());
        String string3 = MethodMapper.getMethodUID(mixinMethodNode.name, mixinMethodNode.desc, (!mixinMethodNode.isSurrogate() ? 0xAA5C1932 ^ 0xAA5C1933 : 0x84EDBB0D ^ 0x84EDBB0D) != 0);
        Object[] objectArray = new Object[0xF2AEC93B ^ 0xF2AEC93F];
        objectArray[0xF0FCF118 ^ 0xF0FCF118] = string;
        objectArray[0x4FC4F9E3 ^ 0x4FC4F9E2] = mixinMethodNode.name;
        objectArray[0xA3CA4B69 ^ 0xA3CA4B6B] = string2;
        objectArray[0xD4A8BD37 ^ 0xD4A8BD34] = string3;
        return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f1\ua034\ua916\u7d32\u8e0f\u2469\u8b72\u3464"), objectArray);
    }

    private static String getClassUID(String string) {
        int n = classes.indexOf(string);
        if (n < 0) {
            n = classes.size();
            classes.add(string);
        }
        return MethodMapper.finagle(n);
    }

    private static String getMethodUID(String string, String string2, boolean bl) {
        Object[] objectArray = new Object[0x4A0B818D ^ 0x4A0B818F];
        objectArray[0xC84D45EC ^ 0xC84D45EC] = string;
        objectArray[0x8A0556FA ^ 0x8A0556FB] = string2;
        String string3 = String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f0\ua062"), objectArray);
        Counter counter = methods.get(string3);
        if (counter == null) {
            counter = new Counter();
            methods.put(string3, counter);
        } else if (bl) {
            counter.value += 0x764D1C42 ^ 0x764D1C43;
        }
        Object[] objectArray2 = new Object[0x63385481 ^ 0x63385480];
        objectArray2[0xCD40BC43 ^ 0xCD40BC43] = counter.value;
        return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7b6\ua4e6\ua069"), objectArray2);
    }

    private static String finagle(int n) {
        String string = Integer.toHexString(n);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0x9C0D24EA ^ 0x9C0D24EA; i < string.length(); ++i) {
            char c = string.charAt(i);
            c = (char)(c + (c < (0xD9BBB6FE ^ 0xD9BBB6C4) ? 0x6DD05B54 ^ 0x6DD05B65 : 0x84C0FB90 ^ 0x84C0FB9A));
            stringBuilder.append(c);
        }
        return Strings.padStart((String)stringBuilder.toString(), (int)(0xDCA56F34 ^ 0xDCA56F37), (char)(0x7708F6F0 ^ 0x7708F68A));
    }
}

