/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.Label;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.signature.SignatureReader;
import org.spongepowered.asm.lib.signature.SignatureVisitor;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LineNumberNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.ext.extensions.ExtensionClassExporter;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;
import org.spongepowered.asm.mixin.transformer.meta.MixinRenamed;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.ConstraintParser;
import org.spongepowered.asm.util.perf.Profiler;
import org.spongepowered.asm.util.throwables.ConstraintViolationException;
import org.spongepowered.asm.util.throwables.InvalidConstraintException;

class MixinApplicatorStandard {
    protected static final List<Class<? extends Annotation>> CONSTRAINED_ANNOTATIONS = ImmutableList.of(Overwrite.class, Inject.class, ModifyArg.class, ModifyArgs.class, Redirect.class, ModifyVariable.class, ModifyConstant.class);
    protected static final int[] INITIALISER_OPCODE_BLACKLIST;
    protected final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    protected final TargetClassContext context;
    protected final String targetName;
    protected final ClassNode targetClass;
    protected final Profiler profiler = MixinEnvironment.getProfiler();
    protected final boolean mergeSignatures;

    MixinApplicatorStandard(TargetClassContext targetClassContext) {
        this.context = targetClassContext;
        this.targetName = targetClassContext.getClassName();
        this.targetClass = targetClassContext.getClassNode();
        ExtensionClassExporter extensionClassExporter = (ExtensionClassExporter)targetClassContext.getExtensions().getExtension(ExtensionClassExporter.class);
        this.mergeSignatures = extensionClassExporter.isDecompilerActive() && MixinEnvironment.getCurrentEnvironment().getOption(MixinEnvironment.Option.DEBUG_EXPORT_DECOMPILE_MERGESIGNATURES) ? 0x4F96140 ^ 0x4F96141 : 0xF40087D8 ^ 0xF40087D8;
    }

    void apply(SortedSet<MixinInfo> sortedSet) {
        ArrayList<MixinTargetContext> arrayList = new ArrayList<MixinTargetContext>();
        for (MixinInfo object2 : sortedSet) {
            Object[] objectArray = new Object[0x27112C32 ^ 0x27112C31];
            objectArray[0x2ACED261 ^ 0x2ACED261] = object2.getName();
            objectArray[0xC20F93FC ^ 0xC20F93FD] = object2.getParent();
            objectArray[0x3AF90E75 ^ 0x3AF90E77] = this.targetName;
            this.logger.log(object2.getLoggingLevel(), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("_\ua7ef\ua4ad\ua078\ua90b\u7d71\u8e0a\u2461\u8b2a\u3437t\ua7f4\ua4ba\ua07c\ua945\u7d6d\u8e57\u243a\u8b3e\u3479f\ua7e9\ua4f5\ua06a\ua918"), objectArray);
            arrayList.add(object2.createContextFor(this.context));
        }
        Object object = null;
        try {
            for (MixinTargetContext mixinTargetContext : arrayList) {
                object = mixinTargetContext;
                ((MixinTargetContext)object).preApply(this.targetName, this.targetClass);
            }
            ApplicatorPass[] exception = ApplicatorPass.values();
            int n = exception.length;
            for (int i = 0x133E0194 ^ 0x133E0194; i < n; ++i) {
                ApplicatorPass applicatorPass = exception[i];
                String[] stringArray = new String[0x183097FB ^ 0x183097F9];
                stringArray[0x54755497 ^ 0x54755497] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("b\ua7e7\ua4a6\ua062");
                stringArray[0x7AFCA91A ^ 0x7AFCA91B] = applicatorPass.name().toLowerCase();
                Profiler.Section section = this.profiler.begin(stringArray);
                for (MixinTargetContext mixinTargetContext : arrayList) {
                    object = mixinTargetContext;
                    this.applyMixin((MixinTargetContext)object, applicatorPass);
                }
                section.end();
            }
            for (MixinTargetContext mixinTargetContext : arrayList) {
                object = mixinTargetContext;
                ((MixinTargetContext)object).postApply(this.targetName, this.targetClass);
            }
        }
        catch (InvalidMixinException invalidMixinException) {
            throw invalidMixinException;
        }
        catch (Exception exception) {
            throw new InvalidMixinException((IMixinContext)object, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("G\ua7e8\ua4b0\ua069\ua915\u7d73\u8e49\u246e\u8b32\u3473w\ua7e2\ua4f5") + exception.getClass().getSimpleName() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7f1\ua4bd\ua078\ua909\u7d65\u8e5e\u243a\u8b36\u3467b\ua7ea\ua4ac\ua078\ua90b\u7d71\u8e0a\u246e\u8b3f\u34722\ua7eb\ua4bc\ua069\ua90c\u7d78\u8e0a\u2479\u8b3b\u3476a\ua7f5\ua4ef\ua031") + exception.getMessage(), (Throwable)exception);
        }
        this.applySourceMap(this.context);
        this.context.processDebugTasks();
    }

    protected final void applyMixin(MixinTargetContext mixinTargetContext, ApplicatorPass applicatorPass) {
        switch (1.$SwitchMap$org$spongepowered$asm$mixin$transformer$MixinApplicatorStandard$ApplicatorPass[applicatorPass.ordinal()]) {
            case 1: {
                this.applySignature(mixinTargetContext);
                this.applyInterfaces(mixinTargetContext);
                this.applyAttributes(mixinTargetContext);
                this.applyAnnotations(mixinTargetContext);
                this.applyFields(mixinTargetContext);
                this.applyMethods(mixinTargetContext);
                this.applyInitialisers(mixinTargetContext);
                break;
            }
            case 2: {
                this.prepareInjections(mixinTargetContext);
                break;
            }
            case 3: {
                this.applyAccessors(mixinTargetContext);
                this.applyInjections(mixinTargetContext);
                break;
            }
            default: {
                throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b27\u3476a\ua7f5\ua4f5\ua062\ua915\u7d73\u8e49\u2473\u8b31\u347ew\ua7e2\ua4f5") + (Object)((Object)applicatorPass));
            }
        }
    }

    protected void applySignature(MixinTargetContext mixinTargetContext) {
        if (this.mergeSignatures) {
            this.context.mergeSignature(mixinTargetContext.getSignature());
        }
    }

    protected void applyInterfaces(MixinTargetContext mixinTargetContext) {
        for (String string : mixinTargetContext.getInterfaces()) {
            if (this.targetClass.interfaces.contains(string)) continue;
            this.targetClass.interfaces.add(string);
            mixinTargetContext.getTargetClassInfo().addInterface(string);
        }
    }

    protected void applyAttributes(MixinTargetContext mixinTargetContext) {
        if (mixinTargetContext.shouldSetSourceFile()) {
            this.targetClass.sourceFile = mixinTargetContext.getSourceFile();
        }
        this.targetClass.version = Math.max(this.targetClass.version, mixinTargetContext.getMinRequiredClassVersion());
    }

    protected void applyAnnotations(MixinTargetContext mixinTargetContext) {
        ClassNode classNode = mixinTargetContext.getClassNode();
        Bytecode.mergeAnnotations(classNode, this.targetClass);
    }

    protected void applyFields(MixinTargetContext mixinTargetContext) {
        this.mergeShadowFields(mixinTargetContext);
        this.mergeNewFields(mixinTargetContext);
    }

    protected void mergeShadowFields(MixinTargetContext mixinTargetContext) {
        for (Map.Entry<FieldNode, ClassInfo.Field> entry : mixinTargetContext.getShadowFields()) {
            FieldNode fieldNode = entry.getKey();
            FieldNode fieldNode2 = this.findTargetField(fieldNode);
            if (fieldNode2 == null) continue;
            Bytecode.mergeAnnotations(fieldNode, fieldNode2);
            if (!entry.getValue().isDecoratedMutable()) continue;
            if (Bytecode.hasFlag(fieldNode2, 0x48D6B366 ^ 0x48D6B364)) continue;
            fieldNode2.access &= 0x9EB23FE6 ^ 0x614DC009;
        }
    }

    protected void mergeNewFields(MixinTargetContext mixinTargetContext) {
        for (FieldNode fieldNode : mixinTargetContext.getFields()) {
            FieldNode fieldNode2 = this.findTargetField(fieldNode);
            if (fieldNode2 != null) continue;
            this.targetClass.fields.add(fieldNode);
            if (fieldNode.signature == null) continue;
            if (this.mergeSignatures) {
                SignatureVisitor signatureVisitor = mixinTargetContext.getSignature().getRemapper();
                new SignatureReader(fieldNode.signature).accept(signatureVisitor);
                fieldNode.signature = signatureVisitor.toString();
                continue;
            }
            fieldNode.signature = null;
        }
    }

    protected void applyMethods(MixinTargetContext mixinTargetContext) {
        for (MethodNode methodNode : mixinTargetContext.getShadowMethods()) {
            this.applyShadowMethod(mixinTargetContext, methodNode);
        }
        for (MethodNode methodNode : mixinTargetContext.getMethods()) {
            this.applyNormalMethod(mixinTargetContext, methodNode);
        }
    }

    protected void applyShadowMethod(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        MethodNode methodNode2 = this.findTargetMethod(methodNode);
        if (methodNode2 != null) {
            Bytecode.mergeAnnotations(methodNode, methodNode2);
        }
    }

    protected void applyNormalMethod(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        mixinTargetContext.transformMethod(methodNode);
        if (!methodNode.name.startsWith(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("."))) {
            this.checkMethodVisibility(mixinTargetContext, methodNode);
            this.checkMethodConstraints(mixinTargetContext, methodNode);
            this.mergeMethod(mixinTargetContext, methodNode);
        } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(".\ua7e5\ua4b9\ua078\ua90b\u7d7f\u8e5e\u2424").equals(methodNode.name)) {
            this.appendInsns(mixinTargetContext, methodNode);
        }
    }

    protected void mergeMethod(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        Object object;
        int n = Annotations.getVisible(methodNode, Overwrite.class) != null ? 0xF7827D50 ^ 0xF7827D51 : 0xCAC96393 ^ 0xCAC96393;
        MethodNode methodNode2 = this.findTargetMethod(methodNode);
        if (methodNode2 != null) {
            if (this.isAlreadyMerged(mixinTargetContext, methodNode, n != 0, methodNode2)) {
                return;
            }
            object = Annotations.getInvisible(methodNode, Intrinsic.class);
            if (object != null) {
                if (this.mergeIntrinsic(mixinTargetContext, methodNode, n != 0, methodNode2, (AnnotationNode)object)) {
                    mixinTargetContext.getTarget().methodMerged(methodNode);
                    return;
                }
            } else {
                if (mixinTargetContext.requireOverwriteAnnotations() && !n) {
                    Object[] objectArray = new Object[0x40AF9C06 ^ 0x40AF9C02];
                    objectArray[0x4AD288C ^ 0x4AD288C] = methodNode.name;
                    objectArray[0xE060B83C ^ 0xE060B83D] = methodNode.desc;
                    objectArray[0x3C9AE751 ^ 0x3C9AE753] = mixinTargetContext;
                    objectArray[0x34FFB722 ^ 0x34FFB721] = mixinTargetContext.getTarget().getClassName();
                    throw new InvalidMixinException((IMixinContext)mixinTargetContext, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f0\ua062\ua945\u7d7f\u8e44\u243a\u8b72\u34642\ua7e5\ua4b4\ua07f\ua90b\u7d79\u8e5e\u243a\u8b38\u3461w\ua7f4\ua4a2\ua063\ua90c\u7d62\u8e4f\u243a\u8b3a\u3472f\ua7ee\ua4ba\ua075\ua945\u7d7f\u8e44\u243a\u8b72\u34642\ua7e4\ua4b0\ua072\ua904\u7d63\u8e59\u247f\u8b77\u3457]\ua7f0\ua4b0\ua063\ua912\u7d64\u8e43\u246e\u8b32\u3437{\ua7f5\ua4f5\ua063\ua900\u7d67\u8e5f\u2473\u8b25\u3472v\ua7a6\ua4b7\ua068\ua945\u7d62\u8e42\u247f\u8b77\u3467s\ua7f4\ua4b0\ua07f\ua911\u7d36\u8e49\u2475\u8b39\u3471{\ua7e1\ua4a0\ua063\ua904\u7d62\u8e43\u2475\u8b39"), objectArray));
                }
                this.targetClass.methods.remove(methodNode2);
            }
        } else if (n) {
            Object[] objectArray = new Object[0xDD1D9D66 ^ 0xDD1D9D64];
            objectArray[0xAFC48066 ^ 0xAFC48066] = methodNode.name;
            objectArray[0x88BD3A84 ^ 0x88BD3A85] = mixinTargetContext.getTargetClassRef();
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("]\ua7f0\ua4b0\ua063\ua912\u7d64\u8e43\u246e\u8b32\u3437f\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2438\u8b72\u34640\ua7a6\ua4a2\ua070\ua916\u7d36\u8e44\u2475\u8b23\u3437~\ua7e9\ua4b6\ua070\ua911\u7d73\u8e4e\u243a\u8b3e\u34792\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u243a\u8b34\u347bs\ua7f5\ua4a6\ua031\ua940\u7d65"), objectArray));
        }
        this.targetClass.methods.add(methodNode);
        mixinTargetContext.methodMerged(methodNode);
        if (methodNode.signature != null) {
            if (this.mergeSignatures) {
                object = mixinTargetContext.getSignature().getRemapper();
                new SignatureReader(methodNode.signature).accept((SignatureVisitor)object);
                methodNode.signature = object.toString();
            } else {
                methodNode.signature = null;
            }
        }
    }

    protected boolean isAlreadyMerged(MixinTargetContext mixinTargetContext, MethodNode methodNode, boolean bl, MethodNode methodNode2) {
        AnnotationNode annotationNode = Annotations.getVisible(methodNode2, MixinMerged.class);
        if (annotationNode == null) {
            if (Annotations.getVisible(methodNode2, Final.class) != null) {
                Object[] objectArray = new Object[0xFC9BB6EB ^ 0xFC9BB6E9];
                objectArray[0x7577969A ^ 0x7577969A] = methodNode.name;
                objectArray[0xD24A7A96 ^ 0xD24A7A97] = mixinTargetContext;
                this.logger.warn(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("]\ua7f0\ua4b0\ua063\ua912\u7d64\u8e43\u246e\u8b32\u3437b\ua7f4\ua4ba\ua079\ua90c\u7d74\u8e43\u246e\u8b32\u34732\ua7e0\ua4ba\ua063\ua945\u7d56\u8e6c\u2473\u8b39\u3476~\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u346co\ua7a6\ua4bc\ua07f\ua945\u7d6d\u8e57\u2434\u8b77\u3444y\ua7ef\ua4a5\ua061\ua90c\u7d78\u8e4d\u243a\u8b3a\u3472f\ua7ee\ua4ba\ua075\ua94b"), objectArray);
                return (0xF34181D5 ^ 0xF34181D4) != 0;
            }
            return (0xE9D1CA4A ^ 0xE9D1CA4A) != 0;
        }
        String string = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a\ua7e3\ua4a6\ua062\ua90c\u7d79\u8e44\u2453\u8b33"));
        if (!this.context.getSessionId().equals(string)) {
            throw new ClassFormatError(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b17\u345a{\ua7fe\ua4bc\ua07f\ua928\u7d73\u8e58\u247d\u8b32\u34732\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e4b\u246e\u8b3e\u3478|\ua7a6\ua4b3\ua07e\ua910\u7d78\u8e4e\u243a\u8b3e\u3479") + mixinTargetContext + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e7\ua4a1\ua031") + methodNode.name + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ef\ua4bb\ua031") + this.targetClass.name);
        }
        if (Bytecode.hasFlag(methodNode2, 0xD1156F6A ^ 0xD1157F2A)) {
            if (Bytecode.hasFlag(methodNode, 0x17EAE665 ^ 0x17EAF625)) {
                if (mixinTargetContext.getEnvironment().getOption(MixinEnvironment.Option.DEBUG_VERBOSE)) {
                    Object[] objectArray = new Object[0xE7118EFA ^ 0xE7118EF8];
                    objectArray[0x68037148 ^ 0x68037148] = methodNode.name;
                    objectArray[0x50A5EBF2 ^ 0x50A5EBF3] = mixinTargetContext;
                    this.logger.warn(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7ff\ua4bb\ua065\ua90d\u7d73\u8e5e\u2473\u8b34\u3437p\ua7f4\ua4bc\ua075\ua902\u7d73\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua906\u7d7a\u8e4b\u2469\u8b3f\u3437t\ua7e9\ua4a7\ua031\ua91e\u7d6b\u8e0a\u2473\u8b39\u3437i\ua7fb"), objectArray);
                }
                return (0xF76E9172 ^ 0xF76E9173) != 0;
            }
        }
        String string2 = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b"));
        int n = (Integer)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("b\ua7f4\ua4bc\ua07e\ua917\u7d7f\u8e5e\u2463"));
        if (n >= mixinTargetContext.getPriority() && !string2.equals(mixinTargetContext.getClassName())) {
            Object[] objectArray = new Object[0x654AD01A ^ 0x654AD019];
            objectArray[0x66B56D85 ^ 0x66B56D85] = methodNode.name;
            objectArray[0x540AAD65 ^ 0x540AAD64] = mixinTargetContext;
            objectArray[0xFFF80CD6 ^ 0xFFF80CD4] = string2;
            this.logger.warn(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("_\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2475\u8b21\u3472`\ua7f1\ua4a7\ua078\ua911\u7d73\u8e0a\u2479\u8b38\u3479t\ua7ea\ua4bc\ua072\ua911\u7d36\u8e4c\u2475\u8b25\u3437i\ua7fb\ua4f5\ua078\ua90b\u7d36\u8e51\u2467\u8b7b\u3437b\ua7f4\ua4b0\ua067\ua90c\u7d79\u8e5f\u2469\u8b3b\u346e2\ua7f1\ua4a7\ua078\ua911\u7d62\u8e4f\u2474\u8b77\u3475k\ua7a6\ua4ae\ua06c\ua94b\u7d36\u8e79\u2471\u8b3e\u3467b\ua7ef\ua4bb\ua076\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a8"), objectArray);
            return (0xF38FABD1 ^ 0xF38FABD0) != 0;
        }
        if (Annotations.getVisible(methodNode2, Final.class) != null) {
            Object[] objectArray = new Object[0xBE95BDE3 ^ 0xBE95BDE0];
            objectArray[0xEDFA0DA6 ^ 0xEDFA0DA6] = methodNode.name;
            objectArray[0x28479CC1 ^ 0x28479CC0] = mixinTargetContext;
            objectArray[0x57C52B48 ^ 0x57C52B4A] = string2;
            this.logger.warn(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("_\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2475\u8b21\u3472`\ua7f1\ua4a7\ua078\ua911\u7d73\u8e0a\u2479\u8b38\u3479t\ua7ea\ua4bc\ua072\ua911\u7d36\u8e4c\u2475\u8b25\u3437R\ua7c0\ua4bc\ua07f\ua904\u7d7a\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua91e\u7d6b\u8e0a\u2473\u8b39\u3437i\ua7fb\ua4f5\ua075\ua900\u7d75\u8e46\u247b\u8b25\u3472v\ua7a6\ua4b7\ua068\ua945\u7d6d\u8e57\u2434\u8b77\u3444y\ua7ef\ua4a5\ua061\ua90c\u7d78\u8e4d\u243a\u8b3a\u3472f\ua7ee\ua4ba\ua075\ua94b"), objectArray);
            return (0x9892BDA ^ 0x9892BDB) != 0;
        }
        return (0x8612FB ^ 0x8612FB) != 0;
    }

    protected boolean mergeIntrinsic(MixinTargetContext mixinTargetContext, MethodNode methodNode, boolean bl, MethodNode methodNode2, AnnotationNode annotationNode) {
        AnnotationNode annotationNode2;
        if (bl) {
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("R\ua7cf\ua4bb\ua065\ua917\u7d7f\u8e44\u2469\u8b3e\u34742\ua7ef\ua4a6\ua031\ua90b\u7d79\u8e5e\u243a\u8b34\u3478\u007f\ua7f6\ua4b4\ua065\ua90c\u7d74\u8e46\u247f\u8b77\u3460{\ua7f2\ua4bd\ua031\ua925\u7d59\u8e5c\u247f\u8b25\u3460`\ua7ef\ua4a1\ua074\ua949\u7d36\u8e58\u247f\u8b3a\u3478d\ua7e3\ua4f5\ua07e\ua90b\u7d73\u8e0a\u2475\u8b31\u3437f\ua7ee\ua4b0\ua062\ua900\u7d36\u8e4b\u2474\u8b39\u3478f\ua7e7\ua4a1\ua078\ua90a\u7d78\u8e59\u243a\u8b38\u34792") + methodNode.name + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ef\ua4bb\ua031") + mixinTargetContext);
        }
        String string = methodNode.name + methodNode.desc;
        if (Bytecode.hasFlag(methodNode, 0xB3A919B1 ^ 0xB3A919B9)) {
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("R\ua7cf\ua4bb\ua065\ua917\u7d7f\u8e44\u2469\u8b3e\u34742\ua7eb\ua4b0\ua065\ua90d\u7d79\u8e4e\u243a\u8b34\u3476|\ua7e8\ua4ba\ua065\ua945\u7d74\u8e4f\u243a\u8b24\u3463s\ua7f2\ua4bc\ua072\ua949\u7d36\u8e4c\u2475\u8b22\u3479v\ua7a6") + string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ef\ua4bb\ua031") + mixinTargetContext);
        }
        if (!(Bytecode.hasFlag(methodNode, 0x3A22E00F ^ 0x3A22F00F) || (annotationNode2 = Annotations.getVisible(methodNode, MixinRenamed.class)) != null && Annotations.getValue(annotationNode2, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("{\ua7f5\ua49c\ua07f\ua911\u7d73\u8e58\u247c\u8b36\u3474w\ua7cb\ua4b0\ua07c\ua907\u7d73\u8e58"), Boolean.FALSE).booleanValue())) {
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("R\ua7cf\ua4bb\ua065\ua917\u7d7f\u8e44\u2469\u8b3e\u34742\ua7eb\ua4b0\ua065\ua90d\u7d79\u8e4e\u243a\u8b3a\u3462a\ua7f2\ua4f5\ua073\ua900\u7d36\u8e5a\u2468\u8b32\u3471{\ua7fe\ua4b0\ua075\ua945\u7d7f\u8e44\u246e\u8b32\u3465t\ua7e7\ua4b6\ua074\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7aa\ua4f5\ua07f\ua90a\u7d36\u8e58\u247f\u8b39\u3476\u007f\ua7e3\ua4f5\ua074\ua90b\u7d75\u8e45\u246f\u8b39\u3463w\ua7f4\ua4b0\ua075\ua945\u7d79\u8e44\u243a") + string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ef\ua4bb\ua031") + mixinTargetContext);
        }
        if (!Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("v\ua7ef\ua4a6\ua061\ua909\u7d77\u8e49\u247f"), Boolean.FALSE).booleanValue()) {
            Object[] objectArray = new Object[0xB92B1379 ^ 0xB92B137B];
            objectArray[0x5A3C1C55 ^ 0x5A3C1C55] = string;
            objectArray[0xB5C70368 ^ 0xB5C70369] = mixinTargetContext.getTargetClassRef();
            this.logger.log(mixinTargetContext.getLoggingLevel(), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7ed\ua4bc\ua061\ua915\u7d7f\u8e44\u247d\u8b77\u345e|\ua7f2\ua4a7\ua078\ua90b\u7d65\u8e43\u2479\u8b77\u347a{\ua7fe\ua4bc\ua07f\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a6\ua4ae\ua06c\ua945\u7d70\u8e45\u2468\u8b77\u346co"), objectArray);
            return (0x78D78AA5 ^ 0x78D78AA4) != 0;
        }
        this.displaceIntrinsic(mixinTargetContext, methodNode, methodNode2);
        return (0x5C23988F ^ 0x5C23988F) != 0;
    }

    protected void displaceIntrinsic(MixinTargetContext mixinTargetContext, MethodNode methodNode, MethodNode methodNode2) {
        String string = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("b\ua7f4\ua4ba\ua069\ua91c\u7d3d") + methodNode2.name;
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (!(abstractInsnNode instanceof MethodInsnNode)) continue;
            if (abstractInsnNode.getOpcode() == (0x6F3029E3 ^ 0x6F30295B)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            if (!methodInsnNode.owner.equals(this.targetClass.name) || !methodInsnNode.name.equals(methodNode2.name) || !methodInsnNode.desc.equals(methodNode2.desc)) continue;
            methodInsnNode.name = string;
        }
        methodNode2.name = string;
    }

    protected final void appendInsns(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        if (Type.getReturnType(methodNode.desc) != Type.VOID_TYPE) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("S\ua7f2\ua4a1\ua074\ua908\u7d66\u8e5e\u247f\u8b33\u3437f\ua7e9\ua4f5\ua07c\ua900\u7d64\u8e4d\u247f\u8b77\u347e|\ua7f5\ua4bb\ua062\ua945\u7d70\u8e58\u2475\u8b3a\u3437s\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u3460z\ua7ef\ua4b6\ua079\ua945\u7d72\u8e45\u247f\u8b24\u3437|\ua7e9\ua4a1\ua031\ua917\u7d73\u8e5e\u246f\u8b25\u34792\ua7f0\ua4ba\ua078\ua901"));
        }
        MethodNode methodNode2 = this.findTargetMethod(methodNode);
        if (methodNode2 != null) {
            AbstractInsnNode abstractInsnNode = Bytecode.findInsn(methodNode2, 0x8663F113 ^ 0x8663F1A2);
            if (abstractInsnNode != null) {
                ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
                while (listIterator.hasNext()) {
                    AbstractInsnNode abstractInsnNode2 = (AbstractInsnNode)listIterator.next();
                    if (abstractInsnNode2 instanceof LineNumberNode) continue;
                    if (abstractInsnNode2.getOpcode() == (0x23014355 ^ 0x230143E4)) continue;
                    methodNode2.instructions.insertBefore(abstractInsnNode, abstractInsnNode2);
                }
                methodNode2.maxLocals = Math.max(methodNode2.maxLocals, methodNode.maxLocals);
                methodNode2.maxStack = Math.max(methodNode2.maxStack, methodNode.maxStack);
            }
            return;
        }
        this.targetClass.methods.add(methodNode);
    }

    protected void applyInitialisers(MixinTargetContext mixinTargetContext) {
        MethodNode methodNode = this.getConstructor(mixinTargetContext);
        if (methodNode == null) {
            return;
        }
        Deque<AbstractInsnNode> deque = this.getInitialiser(mixinTargetContext, methodNode);
        if (deque == null || deque.size() == 0) {
            return;
        }
        for (MethodNode methodNode2 : this.targetClass.methods) {
            if (!\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode2.name)) continue;
            methodNode2.maxStack = Math.max(methodNode2.maxStack, methodNode.maxStack);
            this.injectInitialiser(mixinTargetContext, methodNode2, deque);
        }
    }

    protected MethodNode getConstructor(MixinTargetContext mixinTargetContext) {
        MethodNode methodNode = null;
        for (MethodNode methodNode2 : mixinTargetContext.getMethods()) {
            if (!\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode2.name) || !Bytecode.methodHasLineNumbers(methodNode2)) continue;
            if (methodNode == null) {
                methodNode = methodNode2;
                continue;
            }
            Object[] objectArray = new Object[0xC66241A9 ^ 0xC66241AB];
            objectArray[0x5FEEE827 ^ 0x5FEEE827] = mixinTargetContext;
            objectArray[0x689037A5 ^ 0x689037A4] = methodNode.desc;
            this.logger.warn(String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u347fs\ua7f5\ua4f5\ua07c\ua910\u7d7a\u8e5e\u2473\u8b27\u347bw\ua7a6\ua4b6\ua07e\ua90b\u7d65\u8e5e\u2468\u8b22\u3474f\ua7e9\ua4a7\ua062\ua949\u7d36\u8e0f\u2469\u8b77\u3460s\ua7f5\ua4f5\ua062\ua900\u7d7a\u8e4f\u2479\u8b23\u3472v\ua78c"), objectArray));
        }
        return methodNode;
    }

    private Range getConstructorRange(MethodNode methodNode) {
        int n = 0x1A8F0479 ^ 0x1A8F0479;
        AbstractInsnNode abstractInsnNode = null;
        int n2 = 0x2AD28DAC ^ 0x2AD28DAC;
        int n3 = 0x5D17476D ^ 0x5D17476D;
        int n4 = 0x406D7310 ^ 0x406D7310;
        int n5 = 0x6CABF896 ^ 0x93540769;
        Object object = methodNode.instructions.iterator();
        while (object.hasNext()) {
            AbstractInsnNode abstractInsnNode2 = (AbstractInsnNode)object.next();
            if (abstractInsnNode2 instanceof LineNumberNode) {
                n2 = ((LineNumberNode)abstractInsnNode2).line;
                n = 0x787D1AF2 ^ 0x787D1AF3;
                continue;
            }
            if (abstractInsnNode2 instanceof MethodInsnNode) {
                if (abstractInsnNode2.getOpcode() != (0x56554875 ^ 0x565548C2) || !\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(((MethodInsnNode)abstractInsnNode2).name)) continue;
                if (n5 != (0xC4189D61 ^ 0x3BE7629E)) continue;
                n5 = methodNode.instructions.indexOf(abstractInsnNode2);
                n3 = n2;
                continue;
            }
            if (abstractInsnNode2.getOpcode() == (0xA68618DA ^ 0xA686186F)) {
                n = 0xEED8E8FB ^ 0xEED8E8FB;
                continue;
            }
            if (abstractInsnNode2.getOpcode() != (0xE9DA292D ^ 0xE9DA299C)) continue;
            if (n != 0) {
                n4 = n2;
                continue;
            }
            n4 = n3;
            abstractInsnNode = abstractInsnNode2;
        }
        if (abstractInsnNode != null) {
            object = new LabelNode(new Label());
            methodNode.instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)object);
            methodNode.instructions.insertBefore(abstractInsnNode, new LineNumberNode(n3, (LabelNode)object));
        }
        return new Range(n3, n4, n5);
    }

    protected final Deque<AbstractInsnNode> getInitialiser(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        Range range = this.getConstructorRange(methodNode);
        if (!range.isValid()) {
            return null;
        }
        int n = 0x48935A99 ^ 0x48935A99;
        ArrayDeque<AbstractInsnNode> arrayDeque = new ArrayDeque<AbstractInsnNode>();
        int n2 = 0x472EC2B ^ 0x472EC2B;
        int n3 = 0xAB6742A0 ^ 0x5498BD5F;
        LabelNode labelNode = null;
        Object object = methodNode.instructions.iterator(range.marker);
        while (object.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)object.next();
            if (abstractInsnNode instanceof LineNumberNode) {
                n = ((LineNumberNode)abstractInsnNode).line;
                AbstractInsnNode abstractInsnNode2 = methodNode.instructions.get(methodNode.instructions.indexOf(abstractInsnNode) + (0xFEDFCC3D ^ 0xFEDFCC3C));
                if (n == range.end) {
                    if (abstractInsnNode2.getOpcode() != (0xD6A30979 ^ 0xD6A309C8)) {
                        n2 = 0x8BCCAAC0 ^ 0x8BCCAAC1;
                        n3 = 0x88648BE4 ^ 0x88648B55;
                        continue;
                    }
                }
                n2 = range.excludes(n) ? 1 : 0;
                n3 = 0x1E5AC66A ^ 0xE1A53995;
                continue;
            }
            if (n2 == 0) continue;
            if (labelNode != null) {
                arrayDeque.add(labelNode);
                labelNode = null;
            }
            if (abstractInsnNode instanceof LabelNode) {
                labelNode = (LabelNode)abstractInsnNode;
                continue;
            }
            int n4 = abstractInsnNode.getOpcode();
            if (n4 == n3) {
                n3 = 0xCC69CE85 ^ 0x3396317A;
                continue;
            }
            int[] nArray = INITIALISER_OPCODE_BLACKLIST;
            int n5 = nArray.length;
            for (int i = 0x8E996267 ^ 0x8E996267; i < n5; ++i) {
                int n6 = nArray[i];
                if (n4 != n6) continue;
                throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2472\u8b36\u3479v\ua7ea\ua4b0\ua031") + Bytecode.getOpcodeName(n4) + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e9\ua4a5\ua072\ua90a\u7d72\u8e4f\u243a\u8b7f\u3427j") + Integer.toHexString(n4).toUpperCase() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(";\ua7a6\ua4bc\ua07f\ua945\u7d75\u8e46\u247b\u8b24\u34642\ua7ef\ua4bb\ua078\ua911\u7d7f\u8e4b\u2476\u8b3e\u3464w\ua7f4"));
            }
            arrayDeque.add(abstractInsnNode);
        }
        object = (AbstractInsnNode)arrayDeque.peekLast();
        if (object != null) {
            if (((AbstractInsnNode)object).getOpcode() != (0x3260D0AB ^ 0x3260D01E)) {
                throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e9\ua4a0\ua07d\ua901\u7d36\u8e44\u2475\u8b23\u3437b\ua7e7\ua4a7\ua062\ua900\u7d36\u8e43\u2474\u8b3e\u3463{\ua7e7\ua4b9\ua078\ua916\u7d73\u8e58\u2436\u8b77\u3472j\ua7f6\ua4b0\ua072\ua911\u7d73\u8e4e\u243a\u8b67\u346fP\ua7b3\ua4f9\ua031\ua903\u7d79\u8e5f\u2474\u8b33\u3437\"\ua7fe") + Integer.toHexString(((AbstractInsnNode)object).getOpcode()) + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ef\ua4bb\ua031") + mixinTargetContext);
            }
        }
        return arrayDeque;
    }

    protected final void injectInitialiser(MixinTargetContext mixinTargetContext, MethodNode methodNode, Deque<AbstractInsnNode> deque) {
        Map<LabelNode, LabelNode> map = Bytecode.cloneLabels(methodNode.instructions);
        AbstractInsnNode abstractInsnNode = this.findInitialiserInjectionPoint(mixinTargetContext, methodNode, deque);
        if (abstractInsnNode == null) {
            Object[] objectArray = new Object[0x3474DF2D ^ 0x3474DF2C];
            objectArray[0x26F608DD ^ 0x26F608DD] = methodNode.desc;
            this.logger.warn(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("T\ua7e7\ua4bc\ua07d\ua900\u7d72\u8e0a\u246e\u8b38\u3437~\ua7e9\ua4b6\ua070\ua911\u7d73\u8e0a\u2473\u8b39\u347ef\ua7ef\ua4b4\ua07d\ua90c\u7d65\u8e4f\u2468\u8b77\u347e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b77\u3467}\ua7ef\ua4bb\ua065\ua945\u7d7f\u8e44\u243a\u8b6b\u347e|\ua7ef\ua4a1\ua02f\ua91e\u7d6b\u8e06\u243a\u8b3e\u3479{\ua7f2\ua4bc\ua070\ua909\u7d7f\u8e59\u247f\u8b25\u3437e\ua7e7\ua4a6\ua031\ua90b\u7d79\u8e5e\u243a\u8b3a\u347ej\ua7e3\ua4b1\ua031\ua90c\u7d78\u8e04"), objectArray);
            return;
        }
        for (AbstractInsnNode abstractInsnNode2 : deque) {
            if (abstractInsnNode2 instanceof LabelNode) continue;
            if (abstractInsnNode2 instanceof JumpInsnNode) {
                throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("G\ua7e8\ua4a6\ua064\ua915\u7d66\u8e45\u2468\u8b23\u3472v\ua7a6\ua49f\ua044\ua928\u7d46\u8e0a\u2475\u8b27\u3474}\ua7e2\ua4b0\ua031\ua90c\u7d78\u8e0a\u2473\u8b39\u347ef\ua7ef\ua4b4\ua07d\ua90c\u7d65\u8e4f\u2468\u8b77\u347e|\ua7a6") + mixinTargetContext);
            }
            AbstractInsnNode abstractInsnNode3 = abstractInsnNode2.clone(map);
            methodNode.instructions.insert(abstractInsnNode, abstractInsnNode3);
            abstractInsnNode = abstractInsnNode3;
        }
    }

    protected AbstractInsnNode findInitialiserInjectionPoint(MixinTargetContext mixinTargetContext, MethodNode methodNode, Deque<AbstractInsnNode> deque) {
        HashSet<String> hashSet = new HashSet<String>();
        for (AbstractInsnNode object2 : deque) {
            if (object2.getOpcode() != (0x8B49C2BF ^ 0x8B49C20A)) continue;
            hashSet.add(MixinApplicatorStandard.fieldKey((FieldInsnNode)object2));
        }
        Object object3 = this.getInitialiserInjectionMode(mixinTargetContext.getEnvironment());
        String string = mixinTargetContext.getTargetClassInfo().getName();
        String string2 = mixinTargetContext.getTargetClassInfo().getSuperName();
        AbstractInsnNode abstractInsnNode = null;
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            String string3;
            AbstractInsnNode abstractInsnNode2 = (AbstractInsnNode)listIterator.next();
            if (abstractInsnNode2.getOpcode() == (0x7B425811 ^ 0x7B4258A6) && \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(((MethodInsnNode)abstractInsnNode2).name)) {
                string3 = ((MethodInsnNode)abstractInsnNode2).owner;
                if (!string3.equals(string) && !string3.equals(string2)) continue;
                abstractInsnNode = abstractInsnNode2;
                if (object3 != InitialiserInjectionMode.SAFE) continue;
                break;
            }
            if (abstractInsnNode2.getOpcode() != (0x8BA78D3B ^ 0x8BA78D8E) || object3 != InitialiserInjectionMode.DEFAULT || !hashSet.contains(string3 = MixinApplicatorStandard.fieldKey((FieldInsnNode)abstractInsnNode2))) continue;
            abstractInsnNode = abstractInsnNode2;
        }
        return abstractInsnNode;
    }

    private InitialiserInjectionMode getInitialiserInjectionMode(MixinEnvironment mixinEnvironment) {
        String string = mixinEnvironment.getOptionValue(MixinEnvironment.Option.INITIALISER_INJECTION_MODE);
        if (string == null) {
            return InitialiserInjectionMode.DEFAULT;
        }
        try {
            return InitialiserInjectionMode.valueOf(string.toUpperCase());
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[0xCD174657 ^ 0xCD174656];
            objectArray[0x43DCCD2E ^ 0x43DCCD2E] = string;
            this.logger.warn(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e9\ua4a0\ua07d\ua901\u7d36\u8e44\u2475\u8b23\u3437b\ua7e7\ua4a7\ua062\ua900\u7d36\u8e5f\u2474\u8b32\u346fb\ua7e3\ua4b6\ua065\ua900\u7d72\u8e0a\u246c\u8b36\u347bg\ua7e3\ua4f5\ua033\ua91e\u7d6b\u8e08\u243a\u8b31\u3478`\ua7a6\ua4b8\ua078\ua91d\u7d7f\u8e44\u2434\u8b3e\u3479{\ua7f2\ua4bc\ua070\ua909\u7d7f\u8e59\u247f\u8b25\u345e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b1a\u3478v\ua7e3\ua4f9\ua031\ua917\u7d73\u8e5c\u247f\u8b25\u3463{\ua7e8\ua4b2\ua031\ua911\u7d79\u8e0a\u245e\u8b12\u3451S\ua7d3\ua499\ua045"), objectArray);
            return InitialiserInjectionMode.DEFAULT;
        }
    }

    private static String fieldKey(FieldInsnNode fieldInsnNode) {
        Object[] objectArray = new Object[0x925C7920 ^ 0x925C7922];
        objectArray[0x4E048483 ^ 0x4E048483] = fieldInsnNode.desc;
        objectArray[0x32EB1EA9 ^ 0x32EB1EA8] = fieldInsnNode.name;
        return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4ef\ua034\ua916"), objectArray);
    }

    protected void prepareInjections(MixinTargetContext mixinTargetContext) {
        mixinTargetContext.prepareInjections();
    }

    protected void applyInjections(MixinTargetContext mixinTargetContext) {
        mixinTargetContext.applyInjections();
    }

    protected void applyAccessors(MixinTargetContext mixinTargetContext) {
        List<MethodNode> list = mixinTargetContext.generateAccessors();
        for (MethodNode methodNode : list) {
            if (methodNode.name.startsWith(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("."))) continue;
            this.mergeMethod(mixinTargetContext, methodNode);
        }
    }

    protected void checkMethodVisibility(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        if (Bytecode.hasFlag(methodNode, 0x8AB956EE ^ 0x8AB956E6)) {
            if (!Bytecode.hasFlag(methodNode, 0x234892C8 ^ 0x234892CA)) {
                if (!Bytecode.hasFlag(methodNode, 0x61562739 ^ 0x61563739) && Annotations.getVisible(methodNode, Overwrite.class) == null) {
                    Object[] objectArray = new Object[0x9E16EF77 ^ 0x9E16EF75];
                    objectArray[0x6D8D66AA ^ 0x6D8D66AA] = mixinTargetContext;
                    objectArray[0x4ABA20E5 ^ 0x4ABA20E4] = methodNode;
                    throw new InvalidMixinException((IMixinContext)mixinTargetContext, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474}\ua7e8\ua4a1\ua070\ua90c\u7d78\u8e59\u243a\u8b39\u3478|\ua7ab\ua4a5\ua063\ua90c\u7d60\u8e4b\u246e\u8b32\u3437a\ua7f2\ua4b4\ua065\ua90c\u7d75\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua940\u7d65"), objectArray));
                }
            }
        }
    }

    protected void applySourceMap(TargetClassContext targetClassContext) {
        this.targetClass.sourceDebug = targetClassContext.getSourceMap().toString();
    }

    protected void checkMethodConstraints(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        for (Class<? extends Annotation> clazz : CONSTRAINED_ANNOTATIONS) {
            AnnotationNode annotationNode = Annotations.getVisible(methodNode, clazz);
            if (annotationNode == null) continue;
            this.checkConstraints(mixinTargetContext, methodNode, annotationNode);
        }
    }

    protected final void checkConstraints(MixinTargetContext mixinTargetContext, MethodNode methodNode, AnnotationNode annotationNode) {
        try {
            ConstraintParser.Constraint constraint = ConstraintParser.parse(annotationNode);
            try {
                constraint.check(mixinTargetContext.getEnvironment());
            }
            catch (ConstraintViolationException constraintViolationException) {
                Object[] objectArray = new Object[0xC639798A ^ 0xC6397989];
                objectArray[0xA55FE0D6 ^ 0xA55FE0D6] = constraintViolationException.getMessage();
                objectArray[0x3268D929 ^ 0x3268D928] = methodNode;
                objectArray[0x51BF1ECC ^ 0x51BF1ECE] = mixinTargetContext;
                String string = String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e9\ua4bb\ua062\ua911\u7d64\u8e4b\u2473\u8b39\u34632\ua7f0\ua4bc\ua07e\ua909\u7d77\u8e5e\u2473\u8b38\u3479(\ua7a6\ua4f0\ua062\ua945\u7d79\u8e44\u243a\u8b72\u34642\ua7ef\ua4bb\ua031\ua940\u7d65"), objectArray);
                this.logger.warn(string);
                if (!mixinTargetContext.getEnvironment().getOption(MixinEnvironment.Option.IGNORE_CONSTRAINTS)) {
                    throw new InvalidMixinException(mixinTargetContext, string, (Throwable)constraintViolationException);
                }
            }
        }
        catch (InvalidConstraintException invalidConstraintException) {
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, invalidConstraintException.getMessage());
        }
    }

    protected final MethodNode findTargetMethod(MethodNode methodNode) {
        for (MethodNode methodNode2 : this.targetClass.methods) {
            if (!methodNode2.name.equals(methodNode.name) || !methodNode2.desc.equals(methodNode.desc)) continue;
            return methodNode2;
        }
        return null;
    }

    protected final FieldNode findTargetField(FieldNode fieldNode) {
        for (FieldNode fieldNode2 : this.targetClass.fields) {
            if (!fieldNode2.name.equals(fieldNode.name)) continue;
            return fieldNode2;
        }
        return null;
    }

    static {
        int[] nArray = new int[0x172920F2 ^ 0x172920E8];
        nArray[0xF0C01CF ^ 0xF0C01CF] = 0x9BD1211D ^ 0x9BD121AC;
        nArray[0xDD39411A ^ 0xDD39411B] = 0x4371A59B ^ 0x4371A58E;
        nArray[0xF668DB59 ^ 0xF668DB5B] = 0xF7DC3EBC ^ 0xF7DC3EAA;
        nArray[0x9DDFD252 ^ 0x9DDFD251] = 0x1613F9B1 ^ 0x1613F9A6;
        nArray[0xFC113D54 ^ 0xFC113D50] = 0xDC38A1D6 ^ 0xDC38A1CE;
        nArray[0xF62C5491 ^ 0xF62C5494] = 0xC0CF9A0B ^ 0xC0CF9A25;
        nArray[0xA1D8DF80 ^ 0xA1D8DF86] = 0xC06A4E5E ^ 0xC06A4E71;
        nArray[0x4C302844 ^ 0x4C302843] = 0x2A779DD ^ 0x2A779ED;
        nArray[0x9E72A234 ^ 0x9E72A23C] = 0x489D3D17 ^ 0x489D3D26;
        nArray[0xD7DF37F2 ^ 0xD7DF37FB] = 0x79783075 ^ 0x79783047;
        nArray[0x98B08CAD ^ 0x98B08CA7] = 0x64D0D52A ^ 0x64D0D519;
        nArray[0x4E9A11F4 ^ 0x4E9A11FF] = 0xB79CB315 ^ 0xB79CB321;
        nArray[0x9126292D ^ 0x91262921] = 0x104802C1 ^ 0x104802F4;
        nArray[0x6D6C4A20 ^ 0x6D6C4A2D] = 0x4A3DC12 ^ 0x4A3DC24;
        nArray[0xB4C76262 ^ 0xB4C7626C] = 0xB724E98E ^ 0xB724E9B9;
        nArray[0x797F2F0C ^ 0x797F2F03] = 0x9E64313C ^ 0x9E643104;
        nArray[0xF9E2BDA3 ^ 0xF9E2BDB3] = 0x2AA7B526 ^ 0x2AA7B51F;
        nArray[0x47C15F89 ^ 0x47C15F98] = 0xEE079FAC ^ 0xEE079F96;
        nArray[0x70611871 ^ 0x70611863] = 0xD6F4B814 ^ 0xD6F4B85B;
        nArray[0xB291E51B ^ 0xB291E508] = 0x894D5EAF ^ 0x894D5EFF;
        nArray[0xA8E4989B ^ 0xA8E4988F] = 0xCC62BF6F ^ 0xCC62BF3E;
        nArray[0x3CD33932 ^ 0x3CD33927] = 0x8790FF6F ^ 0x8790FF3D;
        nArray[0x4971DD49 ^ 0x4971DD5F] = 0x30004958 ^ 0x3000490B;
        nArray[0x470A97B ^ 0x470A96C] = 0xC14DEDA7 ^ 0xC14DEDF3;
        nArray[0x6A0CDF8D ^ 0x6A0CDF95] = 0x44EC122F ^ 0x44EC127A;
        nArray[0x9B694DC4 ^ 0x9B694DDD] = 0xF16750F3 ^ 0xF16750A5;
        INITIALISER_OPCODE_BLACKLIST = nArray;
    }

    class Range {
        final int start;
        final int end;
        final int marker;

        Range(int n, int n2, int n3) {
            this.start = n;
            this.end = n2;
            this.marker = n3;
        }

        boolean isValid() {
            return (this.start != 0 && this.end != 0 && this.end >= this.start ? 0x1BCEFCF2 ^ 0x1BCEFCF3 : 0x8DCC5279 ^ 0x8DCC5279) != 0;
        }

        boolean contains(int n) {
            return (n >= this.start && n <= this.end ? 0x3535E163 ^ 0x3535E162 : 0xF6C63EF1 ^ 0xF6C63EF1) != 0;
        }

        boolean excludes(int n) {
            return (n < this.start || n > this.end ? 0x180CD542 ^ 0x180CD543 : 0xEDABAC4F ^ 0xEDABAC4F) != 0;
        }

        public String toString() {
            Object[] objectArray = new Object[0x42DE828C ^ 0x42DE8288];
            objectArray[0x75E8F6DE ^ 0x75E8F6DE] = this.start;
            objectArray[0xD9BD66C4 ^ 0xD9BD66C5] = this.end;
            objectArray[0xC20FD37 ^ 0xC20FD35] = this.marker;
            objectArray[0x66C47E47 ^ 0x66C47E44] = this.isValid();
            return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7e7\ua4bb\ua076\ua900\u7d4d\u8e0f\u247e\u8b7a\u3432v\ua7aa\ua4f0\ua075\ua949\u7d60\u8e4b\u2476\u8b3e\u3473/\ua7a3\ua4a6\ua038"), objectArray);
        }
    }

    static final class InitialiserInjectionMode
    extends Enum<InitialiserInjectionMode> {
        public static final /* enum */ InitialiserInjectionMode DEFAULT = new InitialiserInjectionMode();
        public static final /* enum */ InitialiserInjectionMode SAFE = new InitialiserInjectionMode();
        private static final /* synthetic */ InitialiserInjectionMode[] $VALUES;

        public static InitialiserInjectionMode[] values() {
            return (InitialiserInjectionMode[])$VALUES.clone();
        }

        public static InitialiserInjectionMode valueOf(String string) {
            return Enum.valueOf(InitialiserInjectionMode.class, string);
        }

        static {
            InitialiserInjectionMode[] initialiserInjectionModeArray = new InitialiserInjectionMode[0x90910204 ^ 0x90910206];
            initialiserInjectionModeArray[0xD742310B ^ 0xD742310B] = DEFAULT;
            initialiserInjectionModeArray[0x60A6E633 ^ 0x60A6E632] = SAFE;
            $VALUES = initialiserInjectionModeArray;
        }
    }

    static final class ApplicatorPass
    extends Enum<ApplicatorPass> {
        public static final /* enum */ ApplicatorPass MAIN = new ApplicatorPass();
        public static final /* enum */ ApplicatorPass PREINJECT = new ApplicatorPass();
        public static final /* enum */ ApplicatorPass INJECT = new ApplicatorPass();
        private static final /* synthetic */ ApplicatorPass[] $VALUES;

        public static ApplicatorPass[] values() {
            return (ApplicatorPass[])$VALUES.clone();
        }

        public static ApplicatorPass valueOf(String string) {
            return Enum.valueOf(ApplicatorPass.class, string);
        }

        static {
            ApplicatorPass[] applicatorPassArray = new ApplicatorPass[0xCE2CACDA ^ 0xCE2CACD9];
            applicatorPassArray[0x6A6E4919 ^ 0x6A6E4919] = MAIN;
            applicatorPassArray[0x9E7A7FFF ^ 0x9E7A7FFE] = PREINJECT;
            applicatorPassArray[0x601C2921 ^ 0x601C2923] = INJECT;
            $VALUES = applicatorPassArray;
        }
    }
}

