/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.InnerClassNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.Surrogate;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.InterfaceInfo;
import org.spongepowered.asm.mixin.transformer.MixinConfig;
import org.spongepowered.asm.mixin.transformer.MixinPreProcessorAccessor;
import org.spongepowered.asm.mixin.transformer.MixinPreProcessorInterface;
import org.spongepowered.asm.mixin.transformer.MixinPreProcessorStandard;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.mixin.transformer.throwables.MixinReloadException;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTargetAlreadyLoadedException;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.perf.Profiler;

class MixinInfo
implements Comparable<MixinInfo>,
IMixinInfo {
    private static final IMixinService classLoaderUtil = MixinService.getService();
    static int mixinOrder = 0x614D62AB ^ 0x614D62AB;
    private final transient Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    private final transient Profiler profiler = MixinEnvironment.getProfiler();
    private final transient MixinConfig parent;
    private final String name;
    private final String className;
    private final int priority;
    private final boolean virtual;
    private final List<ClassInfo> targetClasses;
    private final List<String> targetClassNames;
    private final transient int order;
    private final transient IMixinService service;
    private final transient IMixinConfigPlugin plugin;
    private final transient MixinEnvironment.Phase phase;
    private final transient ClassInfo info;
    private final transient SubType type;
    private final transient boolean strict;
    private transient State pendingState;
    private transient State state;

    MixinInfo(IMixinService iMixinService, MixinConfig mixinConfig, String string, boolean bl, IMixinConfigPlugin iMixinConfigPlugin, boolean bl2) {
        int n = mixinOrder;
        mixinOrder = n + (0xF8425FDF ^ 0xF8425FDE);
        this.order = n;
        this.service = iMixinService;
        this.parent = mixinConfig;
        this.name = string;
        this.className = mixinConfig.getMixinPackage() + string;
        this.plugin = iMixinConfigPlugin;
        this.phase = mixinConfig.getEnvironment().getPhase();
        this.strict = mixinConfig.getEnvironment().getOption(MixinEnvironment.Option.DEBUG_TARGETS);
        try {
            byte[] byArray = this.loadMixinClass(this.className, bl);
            this.pendingState = new State(byArray);
            this.info = this.pendingState.getClassInfo();
            this.type = SubType.getTypeFor(this);
        }
        catch (InvalidMixinException invalidMixinException) {
            throw invalidMixinException;
        }
        catch (Exception exception) {
            throw new InvalidMixinException((IMixinInfo)this, (Throwable)exception);
        }
        if (!this.type.isLoadable()) {
            classLoaderUtil.registerInvalidClass(this.className);
        }
        try {
            this.priority = this.readPriority(this.pendingState.getClassNode());
            this.virtual = this.readPseudo(this.pendingState.getClassNode());
            this.targetClasses = this.readTargetClasses(this.pendingState.getClassNode(), bl2);
            this.targetClassNames = Collections.unmodifiableList(Lists.transform(this.targetClasses, (Function)Functions.toStringFunction()));
        }
        catch (InvalidMixinException invalidMixinException) {
            throw invalidMixinException;
        }
        catch (Exception exception) {
            throw new InvalidMixinException((IMixinInfo)this, (Throwable)exception);
        }
    }

    void validate() {
        if (this.pendingState == null) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\\\ua7e9\ua4f5\ua061\ua900\u7d78\u8e4e\u2473\u8b39\u34702\ua7f0\ua4b4\ua07d\ua90c\u7d72\u8e4b\u246e\u8b3e\u3478|\ua7a6\ua4a6\ua065\ua904\u7d62\u8e4f\u243a\u8b31\u3478`\ua7a6") + this);
        }
        try {
            this.pendingState.validate(this.type, this.targetClasses);
            this.state = this.pendingState;
        }
        finally {
            this.pendingState = null;
        }
    }

    protected List<ClassInfo> readTargetClasses(MixinClassNode mixinClassNode, boolean bl) {
        if (mixinClassNode == null) {
            return Collections.emptyList();
        }
        AnnotationNode annotationNode = Annotations.getInvisible(mixinClassNode, Mixin.class);
        if (annotationNode == null) {
            Object[] objectArray = new Object[0x179F932 ^ 0x179F933];
            objectArray[0xE404CD45 ^ 0xE404CD45] = this.className;
            throw new InvalidMixinException((IMixinInfo)this, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F\ua7ee\ua4b0\ua031\ua908\u7d7f\u8e52\u2473\u8b39\u34375\ua7a3\ua4a6\ua036\ua945\u7d7f\u8e59\u243a\u8b3a\u347ea\ua7f5\ua4bc\ua07f\ua902\u7d36\u8e4b\u2474\u8b77\u3457_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e4b\u2474\u8b39\u3478f\ua7e7\ua4a1\ua078\ua90a\u7d78"), objectArray));
        }
        ArrayList<ClassInfo> arrayList = new ArrayList<ClassInfo>();
        List list = (List)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("d\ua7e7\ua4b9\ua064\ua900"));
        List list2 = (List)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("f\ua7e7\ua4a7\ua076\ua900\u7d62\u8e59"));
        if (list != null) {
            this.readTargets(arrayList, Lists.transform((List)list, (Function)new Function<Type, String>(){

                public String apply(Type type) {
                    return type.getClassName();
                }
            }), bl, (0x66B1D231 ^ 0x66B1D231) != 0);
        }
        if (list2 != null) {
            this.readTargets(arrayList, Lists.transform((List)list2, (Function)new Function<String, String>(){

                public String apply(String string) {
                    return MixinInfo.this.getParent().remapClassName(MixinInfo.this.getClassRef(), string);
                }
            }), bl, (0xFD76CB43 ^ 0xFD76CB42) != 0);
        }
        return arrayList;
    }

    private void readTargets(Collection<ClassInfo> collection, Collection<String> collection2, boolean bl, boolean bl2) {
        for (String string : collection2) {
            Object object;
            String string2 = string.replace((char)(0x575B48C0 ^ 0x575B48EF), (char)(0xBB96F7E0 ^ 0xBB96F7CE));
            if (classLoaderUtil.isClassLoaded(string2) && !this.isReloading()) {
                Object[] objectArray = new Object[0x31E94B53 ^ 0x31E94B51];
                objectArray[0x90186BCB ^ 0x90186BCB] = this;
                objectArray[0x3DDF1C63 ^ 0x3DDF1C62] = string2;
                object = String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7f4\ua4bc\ua065\ua90c\u7d75\u8e4b\u2476\u8b77\u3467`\ua7e9\ua4b7\ua07d\ua900\u7d7b\u8e10\u243a\u8b72\u34642\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u243a\u8b72\u34642\ua7f1\ua4b4\ua062\ua945\u7d77\u8e46\u2468\u8b32\u3476v\ua7ff\ua4f5\ua065\ua917\u7d77\u8e44\u2469\u8b31\u3478`\ua7eb\ua4b0\ua075\ua94b"), objectArray);
                if (this.parent.isRequired()) {
                    throw new MixinTargetAlreadyLoadedException((IMixinInfo)this, (String)object, string2);
                }
                this.logger.error((String)object);
            }
            if (!this.shouldApplyMixin(bl, string2) || (object = this.getTarget(string2, bl2)) == null || collection.contains(object)) continue;
            collection.add((ClassInfo)object);
            ((ClassInfo)object).addMixin(this);
        }
    }

    private boolean shouldApplyMixin(boolean bl, String string) {
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("b\ua7ea\ua4a0\ua076\ua90c\u7d78"));
        int n = this.plugin == null || bl || this.plugin.shouldApplyMixin(string, this.className) ? 0x8854782 ^ 0x8854783 : 0x40C83DA ^ 0x40C83DA;
        section.end();
        return n != 0;
    }

    private ClassInfo getTarget(String string, boolean bl) throws InvalidMixinException {
        ClassInfo classInfo = ClassInfo.forName(string);
        if (classInfo == null) {
            if (this.isVirtual()) {
                Object[] objectArray = new Object[0x1696077C ^ 0x1696077E];
                objectArray[0x3E9F7BBE ^ 0x3E9F7BBE] = string;
                objectArray[0x3A80146D ^ 0x3A80146C] = this;
                this.logger.debug(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7ed\ua4bc\ua061\ua915\u7d7f\u8e44\u247d\u8b77\u3461{\ua7f4\ua4a1\ua064\ua904\u7d7a\u8e0a\u246e\u8b36\u3465u\ua7e3\ua4a1\ua031\ua91e\u7d6b\u8e0a\u247c\u8b38\u34652\ua7fd\ua4a8"), objectArray);
            } else {
                Object[] objectArray = new Object[0xD5F82A1A ^ 0xD5F82A18];
                objectArray[0xAFD25E1F ^ 0xAFD25E1F] = string;
                objectArray[0xFB408439 ^ 0xFB408438] = this;
                this.handleTargetError(String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("R\ua7cb\ua4bc\ua069\ua90c\u7d78\u8e0a\u246e\u8b36\u3465u\ua7e3\ua4a1\ua031\ua940\u7d65\u8e0a\u246d\u8b36\u34642\ua7e8\ua4ba\ua065\ua945\u7d70\u8e45\u246f\u8b39\u34732\ua7a3\ua4a6"), objectArray));
            }
            return null;
        }
        this.type.validateTarget(string, classInfo);
        if (bl && classInfo.isPublic() && !this.isVirtual()) {
            Object[] objectArray = new Object[0x91E5A7D1 ^ 0x91E5A7D3];
            objectArray[0xDD1589F9 ^ 0xDD1589F9] = string;
            objectArray[0x7BAAA929 ^ 0x7BAAA928] = this;
            this.handleTargetError(String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("R\ua7cb\ua4bc\ua069\ua90c\u7d78\u8e0a\u246e\u8b36\u3465u\ua7e3\ua4a1\ua031\ua940\u7d65\u8e0a\u2473\u8b24\u3437b\ua7f3\ua4b7\ua07d\ua90c\u7d75\u8e0a\u2473\u8b39\u34377\ua7f5\ua4f5\ua070\ua90b\u7d72\u8e0a\u2469\u8b3f\u3478g\ua7ea\ua4b1\ua031\ua907\u7d73\u8e0a\u2469\u8b27\u3472q\ua7ef\ua4b3\ua078\ua900\u7d72\u8e0a\u2473\u8b39\u3437d\ua7e7\ua4b9\ua064\ua900"), objectArray));
        }
        return classInfo;
    }

    private void handleTargetError(String string) {
        if (this.strict) {
            this.logger.error(string);
            throw new InvalidMixinException((IMixinInfo)this, string);
        }
        this.logger.warn(string);
    }

    protected int readPriority(ClassNode classNode) {
        if (classNode == null) {
            return this.parent.getDefaultMixinPriority();
        }
        AnnotationNode annotationNode = Annotations.getInvisible(classNode, Mixin.class);
        if (annotationNode == null) {
            Object[] objectArray = new Object[0xD9DD0050 ^ 0xD9DD0051];
            objectArray[0xC24DC046 ^ 0xC24DC046] = this.className;
            throw new InvalidMixinException((IMixinInfo)this, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F\ua7ee\ua4b0\ua031\ua908\u7d7f\u8e52\u2473\u8b39\u34375\ua7a3\ua4a6\ua036\ua945\u7d7f\u8e59\u243a\u8b3a\u347ea\ua7f5\ua4bc\ua07f\ua902\u7d36\u8e4b\u2474\u8b77\u3457_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e4b\u2474\u8b39\u3478f\ua7e7\ua4a1\ua078\ua90a\u7d78"), objectArray));
        }
        Integer n = (Integer)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("b\ua7f4\ua4bc\ua07e\ua917\u7d7f\u8e5e\u2463"));
        return n == null ? this.parent.getDefaultMixinPriority() : n.intValue();
    }

    protected boolean readPseudo(ClassNode classNode) {
        return (Annotations.getInvisible(classNode, Pseudo.class) != null ? 0x349B5A34 ^ 0x349B5A35 : 0xA167D86D ^ 0xA167D86D) != 0;
    }

    private boolean isReloading() {
        return this.pendingState instanceof Reloaded;
    }

    private State getState() {
        return this.state != null ? this.state : this.pendingState;
    }

    ClassInfo getClassInfo() {
        return this.info;
    }

    @Override
    public IMixinConfig getConfig() {
        return this.parent;
    }

    MixinConfig getParent() {
        return this.parent;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getClassRef() {
        return this.getClassInfo().getName();
    }

    @Override
    public byte[] getClassBytes() {
        return this.getState().getClassBytes();
    }

    @Override
    public boolean isDetachedSuper() {
        return this.getState().isDetachedSuper();
    }

    public boolean isUnique() {
        return this.getState().isUnique();
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean isAccessor() {
        return this.type instanceof SubType.Accessor;
    }

    public boolean isLoadable() {
        return this.type.isLoadable();
    }

    public Level getLoggingLevel() {
        return this.parent.getLoggingLevel();
    }

    @Override
    public MixinEnvironment.Phase getPhase() {
        return this.phase;
    }

    @Override
    public MixinClassNode getClassNode(int n) {
        return this.getState().createClassNode(n);
    }

    @Override
    public List<String> getTargetClasses() {
        return this.targetClassNames;
    }

    List<InterfaceInfo> getSoftImplements() {
        return Collections.unmodifiableList(this.getState().getSoftImplements());
    }

    Set<String> getSyntheticInnerClasses() {
        return Collections.unmodifiableSet(this.getState().getSyntheticInnerClasses());
    }

    Set<String> getInnerClasses() {
        return Collections.unmodifiableSet(this.getState().getInnerClasses());
    }

    List<ClassInfo> getTargets() {
        return Collections.unmodifiableList(this.targetClasses);
    }

    Set<String> getInterfaces() {
        return this.getState().getInterfaces();
    }

    MixinTargetContext createContextFor(TargetClassContext targetClassContext) {
        MixinClassNode mixinClassNode = this.getClassNode(0x81AF374A ^ 0x81AF3742);
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("b\ua7f4\ua4b0"));
        MixinTargetContext mixinTargetContext = this.type.createPreProcessor(mixinClassNode).prepare().createContextFor(targetClassContext);
        section.end();
        return mixinTargetContext;
    }

    private byte[] loadMixinClass(String string, boolean bl) throws ClassNotFoundException {
        byte[] byArray = null;
        try {
            String string2;
            if (bl && (string2 = this.service.getClassRestrictions(string)).length() > 0) {
                Object[] objectArray = new Object[0x40EB629F ^ 0x40EB629C];
                objectArray[0x5F1EF653 ^ 0x5F1EF653] = string2;
                objectArray[0x5F9C7B0D ^ 0x5F9C7B0C] = this;
                objectArray[0x6A08D169 ^ 0x6A08D16B] = string;
                this.logger.error(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7ea\ua4b4\ua062\ua916\u7d7a\u8e45\u247b\u8b33\u3472`\ua7a6\ua4a7\ua074\ua916\u7d62\u8e58\u2473\u8b34\u3463{\ua7e9\ua4bb\ua062\ua945\u7d4d\u8e51\u2467\u8b0a\u3437w\ua7e8\ua4b6\ua07e\ua910\u7d78\u8e5e\u247f\u8b25\u3472v\ua7a6\ua4b9\ua07e\ua904\u7d72\u8e43\u2474\u8b30\u3437i\ua7fb\ua4f9\ua031\ua90b\u7d77\u8e47\u247f\u8b6d\u3437i\ua7fb"), objectArray);
            }
            byArray = this.service.getBytecodeProvider().getClassBytes(string, bl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray = new Object[0x388BFBE5 ^ 0x388BFBE4];
            objectArray[0x150E657 ^ 0x150E657] = string;
            throw new ClassNotFoundException(String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F\ua7ee\ua4b0\ua031\ua916\u7d66\u8e4f\u2479\u8b3e\u3471{\ua7e3\ua4b1\ua031\ua908\u7d7f\u8e52\u2473\u8b39\u34375\ua7a3\ua4a6\ua036\ua945\u7d61\u8e4b\u2469\u8b77\u3479}\ua7f2\ua4f5\ua077\ua90a\u7d63\u8e44\u247e"), objectArray));
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[0xEFB5A10A ^ 0xEFB5A10B];
            objectArray[0xD2FC5C79 ^ 0xD2FC5C79] = string;
            this.logger.warn(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("T\ua7e7\ua4bc\ua07d\ua900\u7d72\u8e0a\u246e\u8b38\u3437~\ua7e9\ua4b4\ua075\ua945\u7d7b\u8e43\u2462\u8b3e\u34792\ua7fd\ua4a8\ua03d\ua945\u7d62\u8e42\u247f\u8b77\u3464b\ua7e3\ua4b6\ua078\ua903\u7d7f\u8e4f\u247e\u8b77\u347a{\ua7fe\ua4bc\ua07f\ua945\u7d61\u8e43\u2476\u8b3b\u3437|\ua7e9\ua4a1\ua031\ua907\u7d73\u8e0a\u247b\u8b27\u3467~\ua7ef\ua4b0\ua075"), objectArray);
            throw new InvalidMixinException(this, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("S\ua7e8\ua4f5\ua074\ua917\u7d64\u8e45\u2468\u8b77\u3460s\ua7f5\ua4f5\ua074\ua90b\u7d75\u8e45\u246f\u8b39\u3463w\ua7f4\ua4b0\ua075\ua945\u7d61\u8e42\u2473\u8b3b\u3464f\ua7a6\ua4b9\ua07e\ua904\u7d72\u8e43\u2474\u8b30\u3437f\ua7ee\ua4b0\ua031\ua908\u7d7f\u8e52\u2473\u8b39\u3437q\ua7ea\ua4b4\ua062\ua916"), (Throwable)iOException);
        }
        return byArray;
    }

    void reloadMixin(byte[] byArray) {
        if (this.pendingState != null) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2468\u8b32\u347b}\ua7e7\ua4b1\ua031\ua908\u7d7f\u8e52\u2473\u8b39\u3437e\ua7ee\ua4bc\ua07d\ua900\u7d36\u8e43\u246e\u8b77\u347ea\ua7a6\ua4bc\ua07f\ua90c\u7d62\u8e43\u247b\u8b3b\u347ea\ua7ef\ua4bb\ua076"));
        }
        this.pendingState = new Reloaded(this.state, byArray);
        this.validate();
    }

    @Override
    public int compareTo(MixinInfo mixinInfo) {
        if (mixinInfo == null) {
            return 0xFDCB32AB ^ 0xFDCB32AB;
        }
        if (mixinInfo.priority == this.priority) {
            return this.order - mixinInfo.order;
        }
        return this.priority - mixinInfo.priority;
    }

    public void preApply(String string, ClassNode classNode) {
        if (this.plugin != null) {
            Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("b\ua7ea\ua4a0\ua076\ua90c\u7d78"));
            this.plugin.preApply(string, classNode, this.className, this);
            section.end();
        }
    }

    public void postApply(String string, ClassNode classNode) {
        if (this.plugin != null) {
            Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("b\ua7ea\ua4a0\ua076\ua90c\u7d78"));
            this.plugin.postApply(string, classNode, this.className, this);
            section.end();
        }
        this.parent.postApply(string, classNode);
    }

    public String toString() {
        Object[] objectArray = new Object[0xB81D7DBB ^ 0xB81D7DB9];
        objectArray[0x9BF1DC28 ^ 0x9BF1DC28] = this.parent.getName();
        objectArray[0x5BBF88D3 ^ 0x5BBF88D2] = this.name;
        return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4ef\ua034\ua916"), objectArray);
    }

    static abstract class SubType {
        protected final MixinInfo mixin;
        protected final String annotationType;
        protected final boolean targetMustBeInterface;
        protected boolean detached;

        SubType(MixinInfo mixinInfo, String string, boolean bl) {
            this.mixin = mixinInfo;
            this.annotationType = string;
            this.targetMustBeInterface = bl;
        }

        Collection<String> getInterfaces() {
            return Collections.emptyList();
        }

        boolean isDetachedSuper() {
            return this.detached;
        }

        boolean isLoadable() {
            return (0xA8A345A5 ^ 0xA8A345A5) != 0;
        }

        void validateTarget(String string, ClassInfo classInfo) {
            boolean bl = classInfo.isInterface();
            if (bl != this.targetMustBeInterface) {
                String string2 = bl ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("|\ua7e9\ua4a1\ua031");
                throw new InvalidMixinException((IMixinInfo)this.mixin, this.annotationType + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u243a\u8b23\u346eb\ua7e3\ua4f5\ua07c\ua90c\u7d65\u8e47\u247b\u8b23\u3474z\ua7bc\ua4f5") + string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ef\ua4a6\ua031") + string2 + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("s\ua7e8\ua4f5\ua078\ua90b\u7d62\u8e4f\u2468\u8b31\u3476q\ua7e3\ua4f5\ua078\ua90b\u7d36") + this);
            }
        }

        abstract void validate(State var1, List<ClassInfo> var2);

        abstract MixinPreProcessorStandard createPreProcessor(MixinClassNode var1);

        static SubType getTypeFor(MixinInfo mixinInfo) {
            if (!mixinInfo.getClassInfo().isInterface()) {
                return new Standard(mixinInfo);
            }
            int n = 0x7B992681 ^ 0x7B992681;
            for (ClassInfo.Method method : mixinInfo.getClassInfo().getMethods()) {
                n |= !method.isAccessor() ? 0x68B2F6D8 ^ 0x68B2F6D9 : 0x7C44C1A7 ^ 0x7C44C1A7;
            }
            if (n != 0) {
                return new Interface(mixinInfo);
            }
            return new Accessor(mixinInfo);
        }

        static class Accessor
        extends SubType {
            private final Collection<String> interfaces = new ArrayList<String>();

            Accessor(MixinInfo mixinInfo) {
                super(mixinInfo, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("R\ua7cb\ua4bc\ua069\ua90c\u7d78"), (0xD48B0EF3 ^ 0xD48B0EF3) != 0);
                this.interfaces.add(mixinInfo.getClassRef());
            }

            @Override
            boolean isLoadable() {
                return (0x966A918B ^ 0x966A918A) != 0;
            }

            @Override
            Collection<String> getInterfaces() {
                return this.interfaces;
            }

            @Override
            void validateTarget(String string, ClassInfo classInfo) {
                boolean bl = classInfo.isInterface();
                if (bl && !MixinEnvironment.getCompatibilityLevel().supportsMethodsInInterfaces()) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("S\ua7e5\ua4b6\ua074\ua916\u7d65\u8e45\u2468\u8b77\u347a{\ua7fe\ua4bc\ua07f\ua945\u7d62\u8e4b\u2468\u8b30\u3472f\ua7f2\ua4bc\ua07f\ua902\u7d36\u8e4b\u2474\u8b77\u347e|\ua7f2\ua4b0\ua063\ua903\u7d77\u8e49\u247f\u8b77\u347ea\ua7a6\ua4bb\ua07e\ua911\u7d36\u8e59\u246f\u8b27\u3467}\ua7f4\ua4a1\ua074\ua901\u7d36\u8e43\u2474\u8b77\u3474g\ua7f4\ua4a7\ua074\ua90b\u7d62\u8e0a\u247f\u8b39\u3461{\ua7f4\ua4ba\ua07c\ua90b\u7d7b\u8e4f\u2474\u8b23"));
                }
            }

            @Override
            void validate(State state, List<ClassInfo> list) {
                MixinClassNode mixinClassNode = state.getClassNode();
                if (!\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62").equals(mixinClassNode.superName)) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7f3\ua4a5\ua074\ua917\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4ba\ua077\ua945") + this + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ef\ua4a6\ua031\ua90c\u7d78\u8e5c\u247b\u8b3b\u347ev\ua7aa\ua4f5\ua077\ua90a\u7d63\u8e44\u247e\u8b77") + mixinClassNode.superName.replace((char)(0xEA203C9A ^ 0xEA203CB5), (char)(0x18D6AFE6 ^ 0x18D6AFC8)));
                }
            }

            @Override
            MixinPreProcessorStandard createPreProcessor(MixinClassNode mixinClassNode) {
                return new MixinPreProcessorAccessor(this.mixin, mixinClassNode);
            }
        }

        static class Interface
        extends SubType {
            Interface(MixinInfo mixinInfo) {
                super(mixinInfo, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("R\ua7cb\ua4bc\ua069\ua90c\u7d78"), (0xB2C3C62A ^ 0xB2C3C62B) != 0);
            }

            @Override
            void validate(State state, List<ClassInfo> list) {
                if (!MixinEnvironment.getCompatibilityLevel().supportsMethodsInInterfaces()) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a1\ua074\ua917\u7d70\u8e4b\u2479\u8b32\u3437\u007f\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e44\u2475\u8b23\u3437a\ua7f3\ua4a5\ua061\ua90a\u7d64\u8e5e\u247f\u8b33\u3437{\ua7e8\ua4f5\ua072\ua910\u7d64\u8e58\u247f\u8b39\u34632\ua7e3\ua4bb\ua067\ua90c\u7d64\u8e45\u2477\u8b39\u347aw\ua7e8\ua4a1"));
                }
                MixinClassNode mixinClassNode = state.getClassNode();
                if (!\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62").equals(mixinClassNode.superName)) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7f3\ua4a5\ua074\ua917\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4ba\ua077\ua945") + this + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ef\ua4a6\ua031\ua90c\u7d78\u8e5c\u247b\u8b3b\u347ev\ua7aa\ua4f5\ua077\ua90a\u7d63\u8e44\u247e\u8b77") + mixinClassNode.superName.replace((char)(0xDB7B6389 ^ 0xDB7B63A6), (char)(0x7FDA8D62 ^ 0x7FDA8D4C)));
                }
            }

            @Override
            MixinPreProcessorStandard createPreProcessor(MixinClassNode mixinClassNode) {
                return new MixinPreProcessorInterface(this.mixin, mixinClassNode);
            }
        }

        static class Standard
        extends SubType {
            Standard(MixinInfo mixinInfo) {
                super(mixinInfo, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("R\ua7cb\ua4bc\ua069\ua90c\u7d78"), (0x834C72B7 ^ 0x834C72B7) != 0);
            }

            @Override
            void validate(State state, List<ClassInfo> list) {
                MixinClassNode mixinClassNode = state.getClassNode();
                for (ClassInfo classInfo : list) {
                    if (mixinClassNode.superName.equals(classInfo.getSuperName())) continue;
                    if (!classInfo.hasSuperClass(mixinClassNode.superName, ClassInfo.Traversal.SUPER)) {
                        ClassInfo classInfo2 = ClassInfo.forName(mixinClassNode.superName);
                        if (classInfo2.isMixin()) {
                            for (ClassInfo classInfo3 : classInfo2.getTargets()) {
                                if (!list.contains(classInfo3)) continue;
                                throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b3f\u347ew\ua7f4\ua4b4\ua063\ua906\u7d7e\u8e53\u243a\u8b33\u3472f\ua7e3\ua4b6\ua065\ua900\u7d72\u8e04\u243a\u8b13\u3472`\ua7ef\ua4a3\ua074\ua901\u7d36\u8e47\u2473\u8b2f\u347e|\ua7a6") + this + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u2469\u8b77\u3463z\ua7e3\ua4f5\ua062\ua904\u7d7b\u8e4f\u243a\u8b34\u347bs\ua7f5\ua4a6\ua031") + classInfo3.getClassName() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e7\ua4a6\ua031\ua90c\u7d62\u8e59\u243a\u8b24\u3462b\ua7e3\ua4a7\ua072\ua909\u7d77\u8e59\u2469\u8b77") + classInfo2.getClassName());
                            }
                        }
                        throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7f3\ua4a5\ua074\ua917\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4f2") + mixinClassNode.superName.replace((char)(0x8885FC87 ^ 0x8885FCA8), (char)(0x3FB1DFEC ^ 0x3FB1DFC2)) + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("5\ua7a6\ua4ba\ua077\ua945") + this.mixin.getName() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7f1\ua4b4\ua062\ua945\u7d78\u8e45\u246e\u8b77\u3471}\ua7f3\ua4bb\ua075\ua945\u7d7f\u8e44\u243a\u8b23\u347fw\ua7a6\ua4bd\ua078\ua900\u7d64\u8e4b\u2468\u8b34\u347fk\ua7a6\ua4ba\ua077\ua945\u7d62\u8e4b\u2468\u8b30\u3472f\ua7a6\ua4b6\ua07d\ua904\u7d65\u8e59\u243a\u8b70") + classInfo + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("5"));
                    }
                    this.detached = 0x950926B0 ^ 0x950926B1;
                }
            }

            @Override
            MixinPreProcessorStandard createPreProcessor(MixinClassNode mixinClassNode) {
                return new MixinPreProcessorStandard(this.mixin, mixinClassNode);
            }
        }
    }

    class Reloaded
    extends State {
        private final State previous;

        Reloaded(State state, byte[] byArray) {
            super(byArray, state.getClassInfo());
            this.previous = state;
        }

        @Override
        protected void validateChanges(SubType subType, List<ClassInfo> list) {
            if (!this.syntheticInnerClasses.equals(this.previous.syntheticInnerClasses)) {
                throw new MixinReloadException(MixinInfo.this, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2479\u8b3f\u3476|\ua7e1\ua4b0\ua031\ua90c\u7d78\u8e44\u247f\u8b25\u3437q\ua7ea\ua4b4\ua062\ua916\u7d73\u8e59"));
            }
            if (!this.interfaces.equals(this.previous.interfaces)) {
                throw new MixinReloadException(MixinInfo.this, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2479\u8b3f\u3476|\ua7e1\ua4b0\ua031\ua90c\u7d78\u8e5e\u247f\u8b25\u3471s\ua7e5\ua4b0\ua062"));
            }
            if (!new HashSet(this.softImplements).equals(new HashSet<InterfaceInfo>(this.previous.softImplements))) {
                throw new MixinReloadException(MixinInfo.this, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2479\u8b3f\u3476|\ua7e1\ua4b0\ua031\ua916\u7d79\u8e4c\u246e\u8b77\u347e|\ua7f2\ua4b0\ua063\ua903\u7d77\u8e49\u247f\u8b24"));
            }
            List<ClassInfo> list2 = MixinInfo.this.readTargetClasses(this.classNode, (0x56780F0 ^ 0x56780F1) != 0);
            if (!new HashSet<ClassInfo>(list2).equals(new HashSet<ClassInfo>(list))) {
                throw new MixinReloadException(MixinInfo.this, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2479\u8b3f\u3476|\ua7e1\ua4b0\ua031\ua911\u7d77\u8e58\u247d\u8b32\u34632\ua7e5\ua4b9\ua070\ua916\u7d65\u8e4f\u2469"));
            }
            int n = MixinInfo.this.readPriority(this.classNode);
            if (n != MixinInfo.this.getPriority()) {
                throw new MixinReloadException(MixinInfo.this, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2479\u8b3f\u3476|\ua7e1\ua4b0\ua031\ua908\u7d7f\u8e52\u2473\u8b39\u3437b\ua7f4\ua4bc\ua07e\ua917\u7d7f\u8e5e\u2463"));
            }
        }
    }

    class State {
        private byte[] mixinBytes;
        private final ClassInfo classInfo;
        private boolean detachedSuper;
        private boolean unique;
        protected final Set<String> interfaces = new HashSet<String>();
        protected final List<InterfaceInfo> softImplements = new ArrayList<InterfaceInfo>();
        protected final Set<String> syntheticInnerClasses = new HashSet<String>();
        protected final Set<String> innerClasses = new HashSet<String>();
        protected MixinClassNode classNode;

        State(byte[] byArray) {
            this(byArray, null);
        }

        State(byte[] byArray, ClassInfo classInfo) {
            this.mixinBytes = byArray;
            this.connect();
            this.classInfo = classInfo != null ? classInfo : ClassInfo.fromClassNode(this.getClassNode());
        }

        private void connect() {
            this.classNode = this.createClassNode(0xF9689893 ^ 0xF9689893);
        }

        private void complete() {
            this.classNode = null;
        }

        ClassInfo getClassInfo() {
            return this.classInfo;
        }

        byte[] getClassBytes() {
            return this.mixinBytes;
        }

        MixinClassNode getClassNode() {
            return this.classNode;
        }

        boolean isDetachedSuper() {
            return this.detachedSuper;
        }

        boolean isUnique() {
            return this.unique;
        }

        List<? extends InterfaceInfo> getSoftImplements() {
            return this.softImplements;
        }

        Set<String> getSyntheticInnerClasses() {
            return this.syntheticInnerClasses;
        }

        Set<String> getInnerClasses() {
            return this.innerClasses;
        }

        Set<String> getInterfaces() {
            return this.interfaces;
        }

        MixinClassNode createClassNode(int n) {
            MixinClassNode mixinClassNode = new MixinClassNode(MixinInfo.this);
            ClassReader classReader = new ClassReader(this.mixinBytes);
            classReader.accept(mixinClassNode, n);
            return mixinClassNode;
        }

        void validate(SubType subType, List<ClassInfo> list) {
            MixinPreProcessorStandard mixinPreProcessorStandard = subType.createPreProcessor(this.getClassNode()).prepare();
            for (ClassInfo classInfo : list) {
                mixinPreProcessorStandard.conform(classInfo);
            }
            subType.validate(this, list);
            this.detachedSuper = subType.isDetachedSuper();
            this.unique = Annotations.getVisible(this.getClassNode(), Unique.class) != null ? 0xE9280FCE ^ 0xE9280FCF : 0x9879A585 ^ 0x9879A585;
            this.validateInner();
            this.validateClassVersion();
            this.validateRemappables(list);
            this.readImplementations(subType);
            this.readInnerClasses();
            this.validateChanges(subType, list);
            this.complete();
        }

        private void validateInner() {
            if (!this.classInfo.isProbablyStatic()) {
                throw new InvalidMixinException((IMixinInfo)MixinInfo.this, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4bb\ua074\ua917\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4b8\ua078\ua91d\u7d7f\u8e44\u243a\u8b3a\u3462a\ua7f2\ua4f5\ua073\ua900\u7d36\u8e4e\u247f\u8b34\u347bs\ua7f4\ua4b0\ua075\ua945\u7d65\u8e5e\u247b\u8b23\u347eq"));
            }
        }

        private void validateClassVersion() {
            if (this.classNode.version > MixinEnvironment.getCompatibilityLevel().classVersion()) {
                String string = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("<");
                MixinEnvironment.CompatibilityLevel[] compatibilityLevelArray = MixinEnvironment.CompatibilityLevel.values();
                int n = compatibilityLevelArray.length;
                for (int i = 0xC255358F ^ 0xC255358F; i < n; ++i) {
                    MixinEnvironment.CompatibilityLevel compatibilityLevel = compatibilityLevelArray[i];
                    if (compatibilityLevel.classVersion() < this.classNode.version) continue;
                    Object[] objectArray = new Object[0xA4D41855 ^ 0xA4D41854];
                    objectArray[0x2FBEA210 ^ 0x2FBEA210] = compatibilityLevel.name();
                    string = String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("<\ua7a6\ua498\ua078\ua91d\u7d7f\u8e44\u243a\u8b25\u3472c\ua7f3\ua4bc\ua063\ua900\u7d65\u8e0a\u2479\u8b38\u347ab\ua7e7\ua4a1\ua078\ua907\u7d7f\u8e46\u2473\u8b23\u346e2\ua7ea\ua4b0\ua067\ua900\u7d7a\u8e0a\u243f\u8b24\u3437}\ua7f4\ua4f5\ua070\ua907\u7d79\u8e5c\u247f\u8b79"), objectArray);
                }
                throw new InvalidMixinException((IMixinInfo)MixinInfo.this, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("G\ua7e8\ua4a6\ua064\ua915\u7d66\u8e45\u2468\u8b23\u3472v\ua7a6\ua4b8\ua078\ua91d\u7d7f\u8e44\u243a\u8b34\u347bs\ua7f5\ua4a6\ua031\ua913\u7d73\u8e58\u2469\u8b3e\u3478|\ua7a6") + this.classNode.version + string);
            }
        }

        private void validateRemappables(List<ClassInfo> list) {
            if (list.size() > (0x12221C4D ^ 0x12221C4C)) {
                for (Object object : this.classNode.fields) {
                    this.validateRemappable(Shadow.class, ((FieldNode)object).name, Annotations.getVisible((FieldNode)object, Shadow.class));
                }
                for (Object object : this.classNode.methods) {
                    this.validateRemappable(Shadow.class, ((MethodNode)object).name, Annotations.getVisible((MethodNode)object, Shadow.class));
                    AnnotationNode annotationNode = Annotations.getVisible((MethodNode)object, Overwrite.class);
                    if (annotationNode == null) continue;
                    if ((((MethodNode)object).access & (0x4906D2A2 ^ 0x4906D2AA)) != 0) {
                        if ((((MethodNode)object).access & (0xA21EAD09 ^ 0xA21EAD08)) != 0) continue;
                    }
                    throw new InvalidMixinException((IMixinInfo)MixinInfo.this, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("T\ua7e9\ua4a0\ua07f\ua901\u7d36\u8e6a\u2455\u8b21\u3472`\ua7f1\ua4a7\ua078\ua911\u7d73\u8e0a\u247b\u8b39\u3479}\ua7f2\ua4b4\ua065\ua90c\u7d79\u8e44\u243a\u8b38\u34792") + ((MethodNode)object).name + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ef\ua4bb\ua031") + MixinInfo.this);
                }
            }
        }

        private void validateRemappable(Class<Shadow> clazz, String string, AnnotationNode annotationNode) {
            if (annotationNode != null && Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("`\ua7e3\ua4b8\ua070\ua915"), Boolean.TRUE).booleanValue()) {
                throw new InvalidMixinException((IMixinInfo)MixinInfo.this, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("T\ua7e9\ua4a0\ua07f\ua901\u7d36\u8e4b\u243a\u8b25\u3472\u007f\ua7e7\ua4a5\ua061\ua904\u7d74\u8e46\u247f\u8b77\u3457") + clazz.getSimpleName() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e4b\u246e\u8b3e\u3478|\ua7a6\ua4ba\ua07f\ua945") + string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ef\ua4bb\ua031") + this);
            }
        }

        void readImplementations(SubType subType) {
            this.interfaces.addAll(this.classNode.interfaces);
            this.interfaces.addAll(subType.getInterfaces());
            AnnotationNode annotationNode = Annotations.getInvisible(this.classNode, Implements.class);
            if (annotationNode == null) {
                return;
            }
            List list = (List)Annotations.getValue(annotationNode);
            if (list == null) {
                return;
            }
            for (AnnotationNode annotationNode2 : list) {
                InterfaceInfo interfaceInfo = InterfaceInfo.fromAnnotation(MixinInfo.this, annotationNode2);
                this.softImplements.add(interfaceInfo);
                this.interfaces.add(interfaceInfo.getInternalName());
                if (this instanceof Reloaded) continue;
                this.classInfo.addInterface(interfaceInfo.getInternalName());
            }
        }

        void readInnerClasses() {
            for (InnerClassNode innerClassNode : this.classNode.innerClasses) {
                ClassInfo classInfo = ClassInfo.forName(innerClassNode.name);
                if ((innerClassNode.outerName == null || !innerClassNode.outerName.equals(this.classInfo.getName())) && !innerClassNode.name.startsWith(this.classNode.name + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("6"))) continue;
                if (classInfo.isProbablyStatic() && classInfo.isSynthetic()) {
                    this.syntheticInnerClasses.add(innerClassNode.name);
                    continue;
                }
                this.innerClasses.add(innerClassNode.name);
            }
        }

        protected void validateChanges(SubType subType, List<ClassInfo> list) {
            subType.createPreProcessor(this.classNode).prepare();
        }
    }

    class MixinClassNode
    extends ClassNode {
        public final List<MixinMethodNode> mixinMethods;

        public MixinClassNode(MixinInfo mixinInfo2) {
            this(0xED1DB78E ^ 0xED18B78E);
        }

        public MixinClassNode(int n) {
            super(n);
            this.mixinMethods = this.methods;
        }

        public MixinInfo getMixin() {
            return MixinInfo.this;
        }

        @Override
        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            MixinMethodNode mixinMethodNode = new MixinMethodNode(n, string, string2, string3, stringArray);
            this.methods.add(mixinMethodNode);
            return mixinMethodNode;
        }
    }

    class MixinMethodNode
    extends MethodNode {
        private final String originalName;

        public MixinMethodNode(int n, String string, String string2, String string3, String[] stringArray) {
            super(0xC66D3B7E ^ 0xC6683B7E, n, string, string2, string3, stringArray);
            this.originalName = string;
        }

        public String toString() {
            Object[] objectArray = new Object[0xF36D50F7 ^ 0xF36D50F5];
            objectArray[0xC9DC63F0 ^ 0xC9DC63F0] = this.originalName;
            objectArray[0x8DA5F49E ^ 0x8DA5F49F] = this.desc;
            return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f0\ua062"), objectArray);
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public boolean isInjector() {
            return (this.getInjectorAnnotation() != null || this.isSurrogate() ? 0xFCD7B1ED ^ 0xFCD7B1EC : 0xF236AE02 ^ 0xF236AE02) != 0;
        }

        public boolean isSurrogate() {
            return (this.getVisibleAnnotation(Surrogate.class) != null ? 0x86EAFFD8 ^ 0x86EAFFD9 : 0xF087CEFA ^ 0xF087CEFA) != 0;
        }

        public boolean isSynthetic() {
            return Bytecode.hasFlag(this, 0xF69929CD ^ 0xF69939CD);
        }

        public AnnotationNode getVisibleAnnotation(Class<? extends Annotation> clazz) {
            return Annotations.getVisible(this, clazz);
        }

        public AnnotationNode getInjectorAnnotation() {
            return InjectionInfo.getInjectorAnnotation(MixinInfo.this, this);
        }

        public IMixinInfo getOwner() {
            return MixinInfo.this;
        }
    }
}

