/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.FieldVisitor;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinConfig;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTransformerError;
import org.spongepowered.asm.transformers.MixinClassWriter;
import org.spongepowered.asm.transformers.TreeTransformer;
import org.spongepowered.asm.util.Bytecode;

class MixinPostProcessor
extends TreeTransformer
implements MixinConfig.IListener {
    private final Set<String> syntheticInnerClasses = new HashSet<String>();
    private final Map<String, MixinInfo> accessorMixins = new HashMap<String, MixinInfo>();
    private final Set<String> loadable = new HashSet<String>();

    MixinPostProcessor() {
    }

    @Override
    public void onInit(MixinInfo mixinInfo) {
        for (String string : mixinInfo.getSyntheticInnerClasses()) {
            this.registerSyntheticInner(string.replace((char)(0xABDC5752 ^ 0xABDC577D), (char)(0x19733726 ^ 0x19733708)));
        }
    }

    @Override
    public void onPrepare(MixinInfo mixinInfo) {
        String string = mixinInfo.getClassName();
        if (mixinInfo.isLoadable()) {
            this.registerLoadable(string);
        }
        if (mixinInfo.isAccessor()) {
            this.registerAccessor(mixinInfo);
        }
    }

    void registerSyntheticInner(String string) {
        this.syntheticInnerClasses.add(string);
    }

    void registerLoadable(String string) {
        this.loadable.add(string);
    }

    void registerAccessor(MixinInfo mixinInfo) {
        this.registerLoadable(mixinInfo.getClassName());
        this.accessorMixins.put(mixinInfo.getClassName(), mixinInfo);
    }

    boolean canTransform(String string) {
        return (this.syntheticInnerClasses.contains(string) || this.loadable.contains(string) ? 0xF0F35851 ^ 0xF0F35850 : 0x5417906 ^ 0x5417906) != 0;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean isDelegationExcluded() {
        return (0xB2684FE9 ^ 0xB2684FE8) != 0;
    }

    @Override
    public byte[] transformClassBytes(String string, String string2, byte[] byArray) {
        if (this.syntheticInnerClasses.contains(string2)) {
            return this.processSyntheticInner(byArray);
        }
        if (this.accessorMixins.containsKey(string2)) {
            MixinInfo mixinInfo = this.accessorMixins.get(string2);
            return this.processAccessor(byArray, mixinInfo);
        }
        return byArray;
    }

    private byte[] processSyntheticInner(byte[] byArray) {
        ClassReader classReader = new ClassReader(byArray);
        MixinClassWriter mixinClassWriter = new MixinClassWriter(classReader, 0x5ADAFA90 ^ 0x5ADAFA90);
        ClassVisitor classVisitor = new ClassVisitor(0xCDBB914C ^ 0xCDBE914C, mixinClassWriter){

            @Override
            public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
                super.visit(n, n2 | 0x9BA9C31C ^ 0x9BA9C31D, string, string2, string3, stringArray);
            }

            @Override
            public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
                if ((n & (0x637CE74D ^ 0x637CE74B)) == 0) {
                    n |= 0xCAEFD864 ^ 0xCAEFD865;
                }
                return super.visitField(n, string, string2, string3, object);
            }

            @Override
            public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
                if ((n & (0xE16A79BB ^ 0xE16A79BD)) == 0) {
                    n |= 0x741CD08A ^ 0x741CD08B;
                }
                return super.visitMethod(n, string, string2, string3, stringArray);
            }
        };
        classReader.accept(classVisitor, 0x9165115 ^ 0x916511D);
        return mixinClassWriter.toByteArray();
    }

    private byte[] processAccessor(byte[] byArray, MixinInfo mixinInfo) {
        if (!MixinEnvironment.getCompatibilityLevel().isAtLeast(MixinEnvironment.CompatibilityLevel.JAVA_8)) {
            return byArray;
        }
        int n = 0x6B305BD8 ^ 0x6B305BD8;
        MixinInfo.MixinClassNode mixinClassNode = mixinInfo.getClassNode(0x91EDF59E ^ 0x91EDF59E);
        ClassInfo classInfo = mixinInfo.getTargets().get(0xEB355CDF ^ 0xEB355CDF);
        for (MixinInfo.MixinMethodNode mixinMethodNode : mixinClassNode.mixinMethods) {
            if (!Bytecode.hasFlag(mixinMethodNode, 0xDCC62B3 ^ 0xDCC62BB)) continue;
            AnnotationNode annotationNode = mixinMethodNode.getVisibleAnnotation(Accessor.class);
            AnnotationNode annotationNode2 = mixinMethodNode.getVisibleAnnotation(Invoker.class);
            if (annotationNode == null && annotationNode2 == null) continue;
            ClassInfo.Method method = MixinPostProcessor.getAccessorMethod(mixinInfo, mixinMethodNode, classInfo);
            MixinPostProcessor.createProxy(mixinMethodNode, classInfo, method);
            n = 0x6E485CCF ^ 0x6E485CCE;
        }
        if (n != 0) {
            return this.writeClass(mixinClassNode);
        }
        return byArray;
    }

    private static ClassInfo.Method getAccessorMethod(MixinInfo mixinInfo, MethodNode methodNode, ClassInfo classInfo) throws MixinTransformerError {
        ClassInfo.Method method = mixinInfo.getClassInfo().findMethod(methodNode, 0x4908DDF4 ^ 0x4908DDFE);
        if (!method.isRenamed()) {
            throw new MixinTransformerError(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("G\ua7e8\ua4b0\ua069\ua915\u7d73\u8e49\u246e\u8b32\u34732\ua7f5\ua4a1\ua070\ua911\u7d73\u8e10\u243a") + mixinInfo + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ea\ua4ba\ua070\ua901\u7d73\u8e4e\u243a\u8b35\u3472t\ua7e9\ua4a7\ua074\ua945") + classInfo + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7f1\ua4b4\ua062\ua945\u7d75\u8e45\u2474\u8b31\u3478`\ua7eb\ua4b0\ua075"));
        }
        return method;
    }

    private static void createProxy(MethodNode methodNode, ClassInfo classInfo, ClassInfo.Method method) {
        methodNode.instructions.clear();
        Type[] typeArray = Type.getArgumentTypes(methodNode.desc);
        Type type = Type.getReturnType(methodNode.desc);
        Bytecode.loadArgs(typeArray, methodNode.instructions, 0x83B9E97 ^ 0x83B9E97);
        methodNode.instructions.add(new MethodInsnNode(0xBBC3328 ^ 0xBBC3390, classInfo.getName(), method.getName(), methodNode.desc, (0x98A3BD9 ^ 0x98A3BD9) != 0));
        methodNode.instructions.add(new InsnNode(type.getOpcode(0x36F502C ^ 0x36F5080)));
        methodNode.maxStack = Bytecode.getFirstNonArgLocalIndex(typeArray, (0x1B3E772D ^ 0x1B3E772D) != 0);
        methodNode.maxLocals = 0xFCD97F7F ^ 0xFCD97F7F;
    }
}

