/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.gen.throwables.InvalidAccessorException;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.InterfaceInfo;
import org.spongepowered.asm.mixin.transformer.MethodMapper;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.meta.MixinRenamed;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.perf.Profiler;
import org.spongepowered.asm.util.throwables.SyntheticBridgeException;

class MixinPreProcessorStandard {
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    protected final MixinInfo mixin;
    protected final MixinInfo.MixinClassNode classNode;
    protected final MixinEnvironment env;
    protected final Profiler profiler = MixinEnvironment.getProfiler();
    private final boolean verboseLogging;
    private final boolean strictUnique;
    private boolean prepared;
    private boolean attached;

    MixinPreProcessorStandard(MixinInfo mixinInfo, MixinInfo.MixinClassNode mixinClassNode) {
        this.mixin = mixinInfo;
        this.classNode = mixinClassNode;
        this.env = mixinInfo.getParent().getEnvironment();
        this.verboseLogging = this.env.getOption(MixinEnvironment.Option.DEBUG_VERBOSE);
        this.strictUnique = this.env.getOption(MixinEnvironment.Option.DEBUG_UNIQUE);
    }

    final MixinPreProcessorStandard prepare() {
        if (this.prepared) {
            return this;
        }
        this.prepared = 0xEBA58BD ^ 0xEBA58BC;
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("b\ua7f4\ua4b0\ua061\ua904\u7d64\u8e4f"));
        for (MixinInfo.MixinMethodNode object : this.classNode.mixinMethods) {
            ClassInfo.Method method = this.mixin.getClassInfo().findMethod(object);
            this.prepareMethod(object, method);
        }
        for (FieldNode fieldNode : this.classNode.fields) {
            this.prepareField(fieldNode);
        }
        section.end();
        return this;
    }

    protected void prepareMethod(MixinInfo.MixinMethodNode mixinMethodNode, ClassInfo.Method method) {
        this.prepareShadow(mixinMethodNode, method);
        this.prepareSoftImplements(mixinMethodNode, method);
    }

    protected void prepareShadow(MixinInfo.MixinMethodNode mixinMethodNode, ClassInfo.Method method) {
        AnnotationNode annotationNode = Annotations.getVisible(mixinMethodNode, Shadow.class);
        if (annotationNode == null) {
            return;
        }
        String string = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("b\ua7f4\ua4b0\ua077\ua90c\u7d6e"), Shadow.class);
        if (mixinMethodNode.name.startsWith(string)) {
            Object[] objectArray = new Object[0x395A6918 ^ 0x395A691A];
            objectArray[0xBB773CAB ^ 0xBB773CAB] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("}\ua7f4\ua4bc\ua076\ua90c\u7d78\u8e4b\u2476\u8b19\u3476\u007f\ua7e3");
            objectArray[0xDDAAA260 ^ 0xDDAAA261] = mixinMethodNode.name;
            Annotations.setVisible(mixinMethodNode, MixinRenamed.class, objectArray);
            String string2 = mixinMethodNode.name.substring(string.length());
            mixinMethodNode.name = method.renameTo(string2);
        }
    }

    protected void prepareSoftImplements(MixinInfo.MixinMethodNode mixinMethodNode, ClassInfo.Method method) {
        for (InterfaceInfo interfaceInfo : this.mixin.getSoftImplements()) {
            if (!interfaceInfo.renameMethod(mixinMethodNode)) continue;
            method.renameTo(mixinMethodNode.name);
        }
    }

    protected void prepareField(FieldNode fieldNode) {
    }

    final MixinPreProcessorStandard conform(TargetClassContext targetClassContext) {
        return this.conform(targetClassContext.getClassInfo());
    }

    final MixinPreProcessorStandard conform(ClassInfo classInfo) {
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("q\ua7e9\ua4bb\ua077\ua90a\u7d64\u8e47"));
        for (MixinInfo.MixinMethodNode mixinMethodNode : this.classNode.mixinMethods) {
            if (!mixinMethodNode.isInjector()) continue;
            ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethodNode, 0x772DD303 ^ 0x772DD309);
            this.conformInjector(classInfo, mixinMethodNode, method);
        }
        section.end();
        return this;
    }

    private void conformInjector(ClassInfo classInfo, MixinInfo.MixinMethodNode mixinMethodNode, ClassInfo.Method method) {
        MethodMapper methodMapper = classInfo.getMethodMapper();
        methodMapper.remapHandlerMethod(this.mixin, mixinMethodNode, method);
    }

    MixinTargetContext createContextFor(TargetClassContext targetClassContext) {
        MixinTargetContext mixinTargetContext = new MixinTargetContext(this.mixin, this.classNode, targetClassContext);
        this.conform(targetClassContext);
        this.attach(mixinTargetContext);
        return mixinTargetContext;
    }

    final MixinPreProcessorStandard attach(MixinTargetContext mixinTargetContext) {
        if (this.attached) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("B\ua7f4\ua4b0\ua061\ua917\u7d79\u8e49\u247f\u8b24\u3464}\ua7f4\ua4f5\ua066\ua904\u7d65\u8e0a\u247b\u8b3b\u3465w\ua7e7\ua4b1\ua068\ua945\u7d77\u8e5e\u246e\u8b36\u3474z\ua7e3\ua4b1"));
        }
        this.attached = 0x6CB1177 ^ 0x6CB1176;
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("s\ua7f2\ua4a1\ua070\ua906\u7d7e"));
        Profiler.Section section2 = this.profiler.begin(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e59"));
        this.attachMethods(mixinTargetContext);
        section2 = section2.next(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("t\ua7ef\ua4b0\ua07d\ua901\u7d65"));
        this.attachFields(mixinTargetContext);
        section2 = section2.next(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("f\ua7f4\ua4b4\ua07f\ua916\u7d70\u8e45\u2468\u8b3a"));
        this.transform(mixinTargetContext);
        section2.end();
        section.end();
        return this;
    }

    protected void attachMethods(MixinTargetContext mixinTargetContext) {
        Iterator<MixinInfo.MixinMethodNode> iterator = this.classNode.mixinMethods.iterator();
        while (iterator.hasNext()) {
            MixinInfo.MixinMethodNode mixinMethodNode = iterator.next();
            if (!this.validateMethod(mixinTargetContext, mixinMethodNode)) {
                iterator.remove();
                continue;
            }
            if (this.attachInjectorMethod(mixinTargetContext, mixinMethodNode)) {
                mixinTargetContext.addMixinMethod(mixinMethodNode);
                continue;
            }
            if (this.attachAccessorMethod(mixinTargetContext, mixinMethodNode)) {
                iterator.remove();
                continue;
            }
            if (this.attachShadowMethod(mixinTargetContext, mixinMethodNode)) {
                mixinTargetContext.addShadowMethod(mixinMethodNode);
                iterator.remove();
                continue;
            }
            if (this.attachOverwriteMethod(mixinTargetContext, mixinMethodNode)) {
                mixinTargetContext.addMixinMethod(mixinMethodNode);
                continue;
            }
            if (this.attachUniqueMethod(mixinTargetContext, mixinMethodNode)) {
                iterator.remove();
                continue;
            }
            this.attachMethod(mixinTargetContext, mixinMethodNode);
            mixinTargetContext.addMixinMethod(mixinMethodNode);
        }
    }

    protected boolean validateMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return (0x7963C246 ^ 0x7963C247) != 0;
    }

    protected boolean attachInjectorMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return mixinMethodNode.isInjector();
    }

    protected boolean attachAccessorMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return (this.attachAccessorMethod(mixinTargetContext, mixinMethodNode, SpecialMethod.ACCESSOR) || this.attachAccessorMethod(mixinTargetContext, mixinMethodNode, SpecialMethod.INVOKER) ? 0xF62EA7E1 ^ 0xF62EA7E0 : 0x9A62101C ^ 0x9A62101C) != 0;
    }

    protected boolean attachAccessorMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod) {
        AnnotationNode annotationNode = mixinMethodNode.getVisibleAnnotation(specialMethod.annotation);
        if (annotationNode == null) {
            return (0x349F4CE0 ^ 0x349F4CE0) != 0;
        }
        String string = (Object)((Object)specialMethod) + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7eb\ua4b0\ua065\ua90d\u7d79\u8e4e\u243a") + mixinMethodNode.name;
        ClassInfo.Method method = this.getSpecialMethod(mixinMethodNode, specialMethod);
        if (MixinEnvironment.getCompatibilityLevel().isAtLeast(MixinEnvironment.CompatibilityLevel.JAVA_8) && method.isStatic()) {
            if (this.mixin.getTargets().size() > (0x261C919C ^ 0x261C919D)) {
                throw new InvalidAccessorException((IMixinContext)mixinTargetContext, string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ef\ua4bb\ua031\ua908\u7d63\u8e46\u246e\u8b3e\u343af\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2477\u8b3e\u346f{\ua7e8\ua4f5\ua078\ua916\u7d36\u8e43\u2474\u8b21\u3476~\ua7ef\ua4b1\ua03f\ua945\u7d5b\u8e43\u2462\u8b3e\u34792\ua7eb\ua4a0\ua062\ua911\u7d36\u8e42\u247b\u8b21\u34722\ua7e3\ua4ad\ua070\ua906\u7d62\u8e46\u2463\u8b77\u34262\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u2434"));
            }
            String string2 = mixinTargetContext.getUniqueName(mixinMethodNode, (0x61250F0A ^ 0x61250F0B) != 0);
            Object[] objectArray = new Object[0x29E1EEBA ^ 0x29E1EEBE];
            objectArray[0x4B61106A ^ 0x4B61106A] = mixinMethodNode.name;
            objectArray[0xDE00F2CF ^ 0xDE00F2CE] = mixinMethodNode.desc;
            objectArray[0xC62D6DF9 ^ 0xC62D6DFB] = string2;
            objectArray[0x31ADAFAF ^ 0x31ADAFAC] = this.mixin;
            logger.log(this.mixin.getLoggingLevel(), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7e3\ua4bb\ua070\ua908\u7d7f\u8e44\u247d\u8b77\u3457G\ua7e8\ua4bc\ua060\ua910\u7d73\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua91e\u7d6b\u8e51\u2467\u8b77\u3463}\ua7a6\ua4ae\ua06c\ua945\u7d7f\u8e44\u243a\u8b2c\u346a"), objectArray);
            mixinMethodNode.name = method.renameTo(string2);
        } else {
            if (!method.isAbstract()) {
                throw new InvalidAccessorException((IMixinContext)mixinTargetContext, string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ef\ua4a6\ua031\ua90b\u7d79\u8e5e\u243a\u8b36\u3475a\ua7f2\ua4a7\ua070\ua906\u7d62"));
            }
            if (method.isStatic()) {
                throw new InvalidAccessorException((IMixinContext)mixinTargetContext, string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e5\ua4b4\ua07f\ua90b\u7d79\u8e5e\u243a\u8b35\u34722\ua7f5\ua4a1\ua070\ua911\u7d7f\u8e49"));
            }
        }
        mixinTargetContext.addAccessorMethod(mixinMethodNode, specialMethod.annotation);
        return (0xA588D0C8 ^ 0xA588D0C9) != 0;
    }

    protected boolean attachShadowMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return this.attachSpecialMethod(mixinTargetContext, mixinMethodNode, SpecialMethod.SHADOW);
    }

    protected boolean attachOverwriteMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return this.attachSpecialMethod(mixinTargetContext, mixinMethodNode, SpecialMethod.OVERWRITE);
    }

    protected boolean attachSpecialMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod) {
        AnnotationNode annotationNode = mixinMethodNode.getVisibleAnnotation(specialMethod.annotation);
        if (annotationNode == null) {
            return (0x2FAA1EBA ^ 0x2FAA1EBA) != 0;
        }
        if (specialMethod.isOverwrite) {
            this.checkMixinNotUnique(mixinMethodNode, specialMethod);
        }
        ClassInfo.Method method = this.getSpecialMethod(mixinMethodNode, specialMethod);
        MethodNode methodNode = mixinTargetContext.findMethod(mixinMethodNode, annotationNode);
        if (methodNode == null) {
            if (specialMethod.isOverwrite) {
                return (0x28974BD9 ^ 0x28974BD9) != 0;
            }
            methodNode = mixinTargetContext.findRemappedMethod(mixinMethodNode);
            if (methodNode == null) {
                Object[] objectArray = new Object[0xC5204B80 ^ 0xC5204B86];
                objectArray[0x9B00E5E0 ^ 0x9B00E5E0] = specialMethod;
                objectArray[0x8FB90C12 ^ 0x8FB90C13] = mixinMethodNode.name;
                objectArray[0xDE775123 ^ 0xDE775121] = this.mixin;
                objectArray[0xAC36024A ^ 0xAC360249] = mixinTargetContext.getTarget();
                objectArray[0xE43FCD1B ^ 0xE43FCD1F] = mixinTargetContext.getReferenceMapper().getStatus();
                objectArray[0xFB78190D ^ 0xFB781908] = MixinPreProcessorStandard.getDynamicInfo(mixinMethodNode);
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f5\ua07c\ua900\u7d62\u8e42\u2475\u8b33\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3460s\ua7f5\ua4f5\ua07f\ua90a\u7d62\u8e0a\u2476\u8b38\u3474s\ua7f2\ua4b0\ua075\ua945\u7d7f\u8e44\u243a\u8b23\u347fw\ua7a6\ua4a1\ua070\ua917\u7d71\u8e4f\u246e\u8b77\u3474~\ua7e7\ua4a6\ua062\ua945\u7d33\u8e59\u2434\u8b77\u3432a\ua7a3\ua4a6"), objectArray));
            }
            mixinMethodNode.name = method.renameTo(methodNode.name);
        }
        if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode.name)) {
            Object[] objectArray = new Object[0xAE4D587A ^ 0xAE4D5878];
            objectArray[0x577FA697 ^ 0x577FA697] = mixinMethodNode.name;
            objectArray[0x31D7C73 ^ 0x31D7C72] = this.mixin;
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\\\ua7ef\ua4b6\ua074\ua945\u7d62\u8e58\u2463\u8b76\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474s\ua7e8\ua4bb\ua07e\ua911\u7d36\u8e4b\u2476\u8b3e\u3476a\ua7a6\ua4b4\ua031\ua906\u7d79\u8e44\u2469\u8b23\u3465g\ua7e5\ua4a1\ua07e\ua917"), objectArray));
        }
        if (!Bytecode.compareFlags(mixinMethodNode, methodNode, 0xB2000D6A ^ 0xB2000D62)) {
            Object[] objectArray = new Object[0x62D46B6E ^ 0x62D46B6D];
            objectArray[0x33082CC0 ^ 0x33082CC0] = specialMethod;
            objectArray[0x8A895551 ^ 0x8A895550] = mixinMethodNode.name;
            objectArray[0x18AED814 ^ 0x18AED816] = this.mixin;
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7d2\ua494\ua045\ua92c\u7d55\u8e0a\u2477\u8b38\u3473{\ua7e0\ua4bc\ua074\ua917\u7d36\u8e45\u247c\u8b77\u3432a\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u3432a\ua7a6\ua4bc\ua07f\ua945\u7d33\u8e59\u243a\u8b33\u3478w\ua7f5\ua4f5\ua07f\ua90a\u7d62\u8e0a\u2477\u8b36\u3463q\ua7ee\ua4f5\ua065\ua90d\u7d73\u8e0a\u246e\u8b36\u3465u\ua7e3\ua4a1"), objectArray));
        }
        this.conformVisibility(mixinTargetContext, mixinMethodNode, specialMethod, methodNode);
        if (!methodNode.name.equals(mixinMethodNode.name)) {
            if (specialMethod.isOverwrite) {
                if ((methodNode.access & (0x197AC344 ^ 0x197AC346)) == 0) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\\\ua7e9\ua4bb\ua03c\ua915\u7d64\u8e43\u246c\u8b36\u3463w\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u3474s\ua7e8\ua4bb\ua07e\ua911\u7d36\u8e48\u247f\u8b77\u3476~\ua7ef\ua4b4\ua062\ua900\u7d72\u8e04\u243a\u8b11\u3478g\ua7e8\ua4b1\ua031") + methodNode.name);
                }
            }
            mixinMethodNode.name = method.renameTo(methodNode.name);
        }
        return (0xA3758C77 ^ 0xA3758C76) != 0;
    }

    private void conformVisibility(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod, MethodNode methodNode) {
        Bytecode.Visibility visibility = Bytecode.getVisibility(methodNode);
        Bytecode.Visibility visibility2 = Bytecode.getVisibility(mixinMethodNode);
        if (visibility2.ordinal() >= visibility.ordinal()) {
            if (visibility == Bytecode.Visibility.PRIVATE && visibility2.ordinal() > Bytecode.Visibility.PRIVATE.ordinal()) {
                mixinTargetContext.getTarget().addUpgradedMethod(methodNode);
            }
            return;
        }
        Object[] objectArray = new Object[0x24504ABF ^ 0x24504ABA];
        objectArray[0x6BA4C303 ^ 0x6BA4C303] = visibility2;
        objectArray[0xA1F92284 ^ 0xA1F92285] = specialMethod;
        objectArray[0x9CB1894F ^ 0x9CB1894D] = mixinMethodNode.name;
        objectArray[0xD5FFB48F ^ 0xD5FFB48C] = this.mixin;
        objectArray[0xD597E44B ^ 0xD597E44F] = visibility;
        String string = String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f5\ua034\ua916\u7d36\u8e47\u247f\u8b23\u347f}\ua7e2\ua4f5\ua034\ua916\u7d36\u8e43\u2474\u8b77\u3432a\ua7a6\ua4b6\ua070\ua90b\u7d78\u8e45\u246e\u8b77\u3465w\ua7e2\ua4a0\ua072\ua900\u7d36\u8e5c\u2473\u8b24\u347ep\ua7ef\ua4b9\ua078\ua91c\u7d36\u8e45\u247c\u8b77\u3432a\ua7a6\ua4a1\ua070\ua917\u7d71\u8e4f\u246e\u8b77\u347aw\ua7f2\ua4bd\ua07e\ua901"), objectArray);
        if (specialMethod.isOverwrite && !this.mixin.getParent().conformOverwriteVisibility()) {
            throw new InvalidMixinException((IMixinInfo)this.mixin, string);
        }
        if (visibility2 == Bytecode.Visibility.PRIVATE) {
            if (specialMethod.isOverwrite) {
                Object[] objectArray2 = new Object[0x1BEEA8E1 ^ 0x1BEEA8E0];
                objectArray2[0x81B0CBCC ^ 0x81B0CBCC] = string;
                logger.warn(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7f2\ua4b4\ua065\ua90c\u7d75\u8e0a\u2478\u8b3e\u3479v\ua7ef\ua4bb\ua076\ua945\u7d60\u8e43\u2475\u8b3b\u3476f\ua7ef\ua4ba\ua07f\ua95f\u7d36\u8e51\u2467\u8b7b\u3437d\ua7ef\ua4a6\ua078\ua907\u7d7f\u8e46\u2473\u8b23\u346e2\ua7f1\ua4bc\ua07d\ua909\u7d36\u8e48\u247f\u8b77\u3462b\ua7e1\ua4a7\ua070\ua901\u7d73\u8e4e\u2434"), objectArray2);
            }
            mixinTargetContext.addUpgradedMethod(mixinMethodNode);
            Bytecode.setVisibility((MethodNode)mixinMethodNode, visibility);
        }
    }

    protected ClassInfo.Method getSpecialMethod(MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod) {
        ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethodNode, 0x105D907A ^ 0x105D9070);
        this.checkMethodNotUnique(method, specialMethod);
        return method;
    }

    protected void checkMethodNotUnique(ClassInfo.Method method, SpecialMethod specialMethod) {
        if (method.isUnique()) {
            Object[] objectArray = new Object[0xECFE91B3 ^ 0xECFE91B0];
            objectArray[0x73D44281 ^ 0x73D44281] = specialMethod;
            objectArray[0xC06758C6 ^ 0xC06758C7] = method.getName();
            objectArray[0xAED08C5E ^ 0xAED08C5C] = this.mixin;
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f5\ua07c\ua900\u7d62\u8e42\u2475\u8b33\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474s\ua7e8\ua4bb\ua07e\ua911\u7d36\u8e48\u247f\u8b77\u3457G\ua7e8\ua4bc\ua060\ua910\u7d73"), objectArray));
        }
    }

    protected void checkMixinNotUnique(MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod) {
        if (this.mixin.isUnique()) {
            Object[] objectArray = new Object[0x82D95C53 ^ 0x82D95C50];
            objectArray[0xF5F778A4 ^ 0xF5F778A4] = specialMethod;
            objectArray[0xD0081756 ^ 0xD0081757] = mixinMethodNode.name;
            objectArray[0x4D97A57F ^ 0x4D97A57D] = this.mixin;
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f5\ua07c\ua900\u7d62\u8e42\u2475\u8b33\u34377\ua7f5\ua4f5\ua077\ua90a\u7d63\u8e44\u247e\u8b77\u347e|\ua7a6\ua4b4\ua031\ua925\u7d43\u8e44\u2473\u8b26\u3462w\ua7a6\ua4b8\ua078\ua91d\u7d7f\u8e44\u243a\u8b72\u3464"), objectArray));
        }
    }

    protected boolean attachUniqueMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        String string;
        MethodNode methodNode;
        ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethodNode, 0xF08DB54 ^ 0xF08DB5E);
        if (method == null || !method.isUnique() && !this.mixin.isUnique() && !method.isSynthetic()) {
            return (0x839FA3BF ^ 0x839FA3BF) != 0;
        }
        if (method.isSynthetic()) {
            mixinTargetContext.transformDescriptor(mixinMethodNode);
            method.remapTo(mixinMethodNode.desc);
        }
        if ((methodNode = mixinTargetContext.findMethod(mixinMethodNode, null)) == null) {
            return (0x9075C244 ^ 0x9075C244) != 0;
        }
        String string2 = string = method.isSynthetic() ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a\ua7ff\ua4bb\ua065\ua90d\u7d73\u8e5e\u2473\u8b34") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("R\ua7d3\ua4bb\ua078\ua914\u7d63\u8e4f");
        if (Bytecode.getVisibility(mixinMethodNode).ordinal() < Bytecode.Visibility.PUBLIC.ordinal()) {
            String string3 = mixinTargetContext.getUniqueName(mixinMethodNode, (0x28CED717 ^ 0x28CED717) != 0);
            Object[] objectArray = new Object[0xF12F06FE ^ 0xF12F06FB];
            objectArray[0xA5E3E0E8 ^ 0xA5E3E0E8] = string;
            objectArray[0xB229AF24 ^ 0xB229AF25] = mixinMethodNode.name;
            objectArray[0x9049522D ^ 0x9049522F] = mixinMethodNode.desc;
            objectArray[0x239F5A89 ^ 0x239F5A8A] = string3;
            objectArray[0xCD97ABEF ^ 0xCD97ABEB] = this.mixin;
            logger.log(this.mixin.getLoggingLevel(), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7e3\ua4bb\ua070\ua908\u7d7f\u8e44\u247d\u8b77\u346co\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u346co\ua7fd\ua4a8\ua031\ua911\u7d79\u8e0a\u2461\u8b2a\u3437{\ua7e8\ua4f5\ua06a\ua918"), objectArray);
            mixinMethodNode.name = method.renameTo(string3);
            return (0xBF28F77C ^ 0xBF28F77C) != 0;
        }
        if (this.strictUnique) {
            Object[] objectArray = new Object[0x9E0074FA ^ 0x9E0074FC];
            objectArray[0x44E4DB5 ^ 0x44E4DB5] = string;
            objectArray[0xCC910876 ^ 0xCC910877] = mixinMethodNode.name;
            objectArray[0xE906C0C7 ^ 0xE906C0C5] = this.mixin;
            objectArray[0xF240A371 ^ 0xF240A372] = methodNode.name;
            objectArray[0x8E8948E0 ^ 0x8E8948E4] = methodNode.desc;
            objectArray[0x1EFE091B ^ 0x1EFE091E] = mixinTargetContext.getTarget();
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("_\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2479\u8b38\u3479t\ua7ea\ua4bc\ua072\ua911\u7d3a\u8e0a\u243f\u8b24\u3437\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u243f\u8b24\u3437{\ua7e8\ua4f5\ua034\ua916\u7d36\u8e49\u247b\u8b39\u3479}\ua7f2\ua4f5\ua07e\ua913\u7d73\u8e58\u246d\u8b25\u347ef\ua7e3\ua4f5\ua034\ua916\u7d33\u8e59\u243a\u8b3e\u34792\ua7a3\ua4a6"), objectArray));
        }
        AnnotationNode annotationNode = Annotations.getVisible(mixinMethodNode, Unique.class);
        if (annotationNode == null || !Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a\ua7ef\ua4b9\ua074\ua90b\u7d62"), Boolean.FALSE).booleanValue()) {
            if (Bytecode.hasFlag(mixinMethodNode, 0xCF3C4E32 ^ 0xCF3C4E72)) {
                try {
                    Bytecode.compareBridgeMethods(methodNode, mixinMethodNode);
                    Object[] objectArray = new Object[0x12DAD9B0 ^ 0x12DAD9B4];
                    objectArray[0x40FD848A ^ 0x40FD848A] = string;
                    objectArray[0xAE6D0D31 ^ 0xAE6D0D30] = mixinMethodNode.name;
                    objectArray[0xFAC2BAC5 ^ 0xFAC2BAC7] = this.mixin;
                    objectArray[0xCF1607A0 ^ 0xCF1607A3] = mixinTargetContext.getTarget();
                    logger.debug(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("V\ua7ef\ua4a6\ua072\ua904\u7d64\u8e4e\u2473\u8b39\u34702\ua7f5\ua4ac\ua065\ua90d\u7d73\u8e5e\u2473\u8b34\u3437p\ua7f4\ua4bc\ua075\ua902\u7d73\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua91e\u7d6b\u8e0a\u2473\u8b39\u3437i\ua7fb\ua4f5\ua073\ua900\u7d75\u8e4b\u246f\u8b24\u34722\ua7e3\ua4ad\ua078\ua916\u7d62\u8e43\u2474\u8b30\u3437\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2473\u8b39\u3437i\ua7fb\ua4f5\ua078\ua916\u7d36\u8e49\u2475\u8b3a\u3467s\ua7f2\ua4bc\ua073\ua909\u7d73"), objectArray);
                    return (0x853F7070 ^ 0x853F7071) != 0;
                }
                catch (SyntheticBridgeException syntheticBridgeException) {
                    if (this.verboseLogging || this.env.getOption(MixinEnvironment.Option.DEBUG_VERIFY)) {
                        syntheticBridgeException.printAnalysis(mixinTargetContext, methodNode, mixinMethodNode);
                    }
                    throw new InvalidMixinException((IMixinInfo)this.mixin, syntheticBridgeException.getMessage());
                }
            }
            Object[] objectArray = new Object[0x8604DCE8 ^ 0x8604DCEC];
            objectArray[0x2559A3B1 ^ 0x2559A3B1] = string;
            objectArray[0xDFA55797 ^ 0xDFA55796] = mixinMethodNode.name;
            objectArray[0x46947624 ^ 0x46947626] = this.mixin;
            objectArray[0x95EAC48C ^ 0x95EAC48F] = mixinTargetContext.getTarget();
            logger.warn(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("V\ua7ef\ua4a6\ua072\ua904\u7d64\u8e4e\u2473\u8b39\u34702\ua7fd\ua4a8\ua031\ua915\u7d63\u8e48\u2476\u8b3e\u34742\ua7eb\ua4b0\ua065\ua90d\u7d79\u8e4e\u243a\u8b2c\u346a2\ua7ef\ua4bb\ua031\ua91e\u7d6b\u8e0a\u2478\u8b32\u3474s\ua7f3\ua4a6\ua074\ua945\u7d7f\u8e5e\u243a\u8b36\u347b`\ua7e3\ua4b4\ua075\ua91c\u7d36\u8e4f\u2462\u8b3e\u3464f\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e51\u2467"), objectArray);
            return (0x5E7E35F0 ^ 0x5E7E35F1) != 0;
        }
        mixinTargetContext.addMixinMethod(mixinMethodNode);
        return (0x278BF5D5 ^ 0x278BF5D4) != 0;
    }

    protected void attachMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        MethodNode methodNode;
        ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethodNode);
        if (method == null) {
            return;
        }
        ClassInfo.Method method2 = this.mixin.getClassInfo().findMethodInHierarchy(mixinMethodNode, ClassInfo.SearchType.SUPER_CLASSES_ONLY);
        if (method2 != null && method2.isRenamed()) {
            mixinMethodNode.name = method.renameTo(method2.getName());
        }
        if ((methodNode = mixinTargetContext.findMethod(mixinMethodNode, null)) != null) {
            this.conformVisibility(mixinTargetContext, mixinMethodNode, SpecialMethod.MERGE, methodNode);
        }
    }

    protected void attachFields(MixinTargetContext mixinTargetContext) {
        Iterator iterator = this.classNode.fields.iterator();
        while (iterator.hasNext()) {
            int n;
            FieldNode fieldNode = (FieldNode)iterator.next();
            AnnotationNode annotationNode = Annotations.getVisible(fieldNode, Shadow.class);
            int n2 = annotationNode != null ? 0x451A93E2 ^ 0x451A93E3 : (n = 0xBAEA2C3B ^ 0xBAEA2C3B);
            if (!this.validateField(mixinTargetContext, fieldNode, annotationNode)) {
                iterator.remove();
                continue;
            }
            ClassInfo.Field field = this.mixin.getClassInfo().findField(fieldNode);
            mixinTargetContext.transformDescriptor(fieldNode);
            field.remapTo(fieldNode.desc);
            if (field.isUnique() && n != 0) {
                Object[] objectArray = new Object[0xD6790B8A ^ 0xD6790B8B];
                objectArray[0x43F6409C ^ 0x43F6409C] = fieldNode.name;
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("R\ua7d5\ua4bd\ua070\ua901\u7d79\u8e5d\u243a\u8b31\u347ew\ua7ea\ua4b1\ua031\ua940\u7d65\u8e0a\u2479\u8b36\u3479|\ua7e9\ua4a1\ua031\ua907\u7d73\u8e0a\u245a\u8b02\u3479{\ua7f7\ua4a0\ua074"), objectArray));
            }
            FieldNode fieldNode2 = mixinTargetContext.findField(fieldNode, annotationNode);
            if (fieldNode2 == null) {
                if (annotationNode == null) continue;
                fieldNode2 = mixinTargetContext.findRemappedField(fieldNode);
                if (fieldNode2 == null) {
                    Object[] objectArray = new Object[0xDE5BE5B8 ^ 0xDE5BE5BC];
                    objectArray[0xB09787A9 ^ 0xB09787A9] = fieldNode.name;
                    objectArray[0xDEF30E2E ^ 0xDEF30E2F] = mixinTargetContext.getTarget();
                    objectArray[0x5C496DC ^ 0x5C496DE] = mixinTargetContext.getReferenceMapper().getStatus();
                    objectArray[0xB617016C ^ 0xB617016F] = MixinPreProcessorStandard.getDynamicInfo(fieldNode);
                    throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7ee\ua4b4\ua075\ua90a\u7d61\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5\ua034\ua916\u7d36\u8e5d\u247b\u8b24\u3437|\ua7e9\ua4a1\ua031\ua909\u7d79\u8e49\u247b\u8b23\u3472v\ua7a6\ua4bc\ua07f\ua945\u7d62\u8e42\u247f\u8b77\u3463s\ua7f4\ua4b2\ua074\ua911\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4f0\ua062\ua94b\u7d36\u8e0f\u2469\u8b72\u3464"), objectArray));
                }
                fieldNode.name = field.renameTo(fieldNode2.name);
            }
            if (!Bytecode.compareFlags(fieldNode, fieldNode2, 0x3FAB30E2 ^ 0x3FAB30EA)) {
                Object[] objectArray = new Object[0x7EF775A4 ^ 0x7EF775A6];
                objectArray[0x7EB35701 ^ 0x7EB35701] = fieldNode.name;
                objectArray[0x1F813A8F ^ 0x1F813A8E] = this.mixin;
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7d2\ua494\ua045\ua92c\u7d55\u8e0a\u2477\u8b38\u3473{\ua7e0\ua4bc\ua074\ua917\u7d36\u8e45\u247c\u8b77\u3457A\ua7ee\ua4b4\ua075\ua90a\u7d61\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5\ua034\ua916\u7d36\u8e43\u2474\u8b77\u3432a\ua7a6\ua4b1\ua07e\ua900\u7d65\u8e0a\u2474\u8b38\u34632\ua7eb\ua4b4\ua065\ua906\u7d7e\u8e0a\u246e\u8b3f\u34722\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e"), objectArray));
            }
            if (field.isUnique()) {
                if ((fieldNode.access & (0x6EA689A8 ^ 0x6EA689AE)) != 0) {
                    String string = mixinTargetContext.getUniqueName(fieldNode);
                    Object[] objectArray = new Object[0x869AA317 ^ 0x869AA313];
                    objectArray[0x8CB35537 ^ 0x8CB35537] = fieldNode.name;
                    objectArray[0xAED341C5 ^ 0xAED341C4] = fieldNode.desc;
                    objectArray[0x32862E7E ^ 0x32862E7C] = string;
                    objectArray[0xE16D9D29 ^ 0xE16D9D2A] = this.mixin;
                    logger.log(this.mixin.getLoggingLevel(), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7e3\ua4bb\ua070\ua908\u7d7f\u8e44\u247d\u8b77\u3457G\ua7e8\ua4bc\ua060\ua910\u7d73\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5\ua06a\ua918\u7d6d\u8e57\u243a\u8b23\u34782\ua7fd\ua4a8\ua031\ua90c\u7d78\u8e0a\u2461\u8b2a"), objectArray);
                    fieldNode.name = field.renameTo(string);
                    continue;
                }
                if (this.strictUnique) {
                    Object[] objectArray = new Object[0x4F9236A4 ^ 0x4F9236A1];
                    objectArray[0x572DEB9D ^ 0x572DEB9D] = fieldNode.name;
                    objectArray[0xDFD1CF79 ^ 0xDFD1CF78] = this.mixin;
                    objectArray[0xEA77B56C ^ 0xEA77B56E] = fieldNode2.name;
                    objectArray[0x4E3C859E ^ 0x4E3C859D] = fieldNode2.desc;
                    objectArray[0x4C053978 ^ 0x4C05397C] = mixinTargetContext.getTarget();
                    throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("T\ua7ef\ua4b0\ua07d\ua901\u7d36\u8e49\u2475\u8b39\u3471~\ua7ef\ua4b6\ua065\ua949\u7d36\u8e6a\u244f\u8b39\u347ec\ua7f3\ua4b0\ua031\ua903\u7d7f\u8e4f\u2476\u8b33\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474s\ua7e8\ua4bb\ua07e\ua911\u7d36\u8e45\u246c\u8b32\u3465e\ua7f4\ua4bc\ua065\ua900\u7d36\u8e0f\u2469\u8b72\u34642\ua7ef\ua4bb\ua031\ua940\u7d65"), objectArray));
                }
                Object[] objectArray = new Object[0x1707FD15 ^ 0x1707FD16];
                objectArray[0xBE219726 ^ 0xBE219726] = fieldNode.name;
                objectArray[0x2E1F31F6 ^ 0x2E1F31F7] = this.mixin;
                objectArray[0x1D0FFC4 ^ 0x1D0FFC6] = mixinTargetContext.getTarget();
                logger.warn(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("V\ua7ef\ua4a6\ua072\ua904\u7d64\u8e4e\u2473\u8b39\u34702\ua7c6\ua480\ua07f\ua90c\u7d67\u8e5f\u247f\u8b77\u3467g\ua7e4\ua4b9\ua078\ua906\u7d36\u8e4c\u2473\u8b32\u347bv\ua7a6\ua4ae\ua06c\ua945\u7d7f\u8e44\u243a\u8b2c\u346a2\ua7e4\ua4b0\ua072\ua904\u7d63\u8e59\u247f\u8b77\u347ef\ua7a6\ua4b4\ua07d\ua917\u7d73\u8e4b\u247e\u8b2e\u3437w\ua7fe\ua4bc\ua062\ua911\u7d65\u8e0a\u2473\u8b39\u3437i\ua7fb\ua4fb\ua031\ua92b\u7d79\u8e5e\u247f\u8b77\u3463z\ua7e7\ua4a1\ua031\ua901\u7d73\u8e49\u2476\u8b36\u3465w\ua7e2\ua4f5\ua057\ua92c\u7d53\u8e66\u245e\u8b77\u345e\\\ua7cf\ua481\ua058\ua924\u7d5a\u8e63\u2449\u8b12\u3445A\ua7a6\ua4a2\ua078\ua909\u7d7a\u8e0a\u2454\u8b18\u34432\ua7e4\ua4b0\ua031\ua917\u7d73\u8e47\u2475\u8b21\u3472v\ua7a7"), objectArray);
                iterator.remove();
                continue;
            }
            if (!fieldNode2.desc.equals(fieldNode.desc)) {
                Object[] objectArray = new Object[0x7B54453A ^ 0x7B54453B];
                objectArray[0x84B2F5FF ^ 0x84B2F5FF] = fieldNode.name;
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F\ua7ee\ua4b0\ua031\ua903\u7d7f\u8e4f\u2476\u8b33\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e5e\u2472\u8b32\u3437f\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2479\u8b3b\u3476a\ua7f5\ua4f5\ua079\ua904\u7d65\u8e0a\u247b\u8b77\u3474}\ua7e8\ua4b3\ua07d\ua90c\u7d75\u8e5e\u2473\u8b39\u34702\ua7f5\ua4bc\ua076\ua90b\u7d77\u8e5e\u246f\u8b25\u3472"), objectArray));
            }
            if (!fieldNode2.name.equals(fieldNode.name)) {
                if ((fieldNode2.access & (0x4B666290 ^ 0x4B666292)) == 0) {
                    if ((fieldNode2.access & (0x76AA028E ^ 0x76AA128E)) == 0) {
                        throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\\\ua7e9\ua4bb\ua03c\ua915\u7d64\u8e43\u246c\u8b36\u3463w\ua7a6\ua4b3\ua078\ua900\u7d7a\u8e4e\u243a\u8b34\u3476|\ua7e8\ua4ba\ua065\ua945\u7d74\u8e4f\u243a\u8b36\u347b{\ua7e7\ua4a6\ua074\ua901\u7d38\u8e0a\u245c\u8b38\u3462|\ua7e2\ua4f5") + fieldNode2.name);
                    }
                }
                fieldNode.name = field.renameTo(fieldNode2.name);
            }
            iterator.remove();
            if (n == 0) continue;
            boolean bl = field.isDecoratedFinal();
            if (this.verboseLogging) {
                if (Bytecode.hasFlag(fieldNode2, 0xD5A412B7 ^ 0xD5A412A7) != bl) {
                    String string = bl ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("R\ua7d5\ua4bd\ua070\ua901\u7d79\u8e5d\u243a\u8b31\u347ew\ua7ea\ua4b1\ua031\ua91e\u7d6b\u8e10\u2420\u8b2c\u346a2\ua7ef\ua4a6\ua031\ua901\u7d73\u8e49\u2475\u8b25\u3476f\ua7e3\ua4b1\ua031\ua912\u7d7f\u8e5e\u2472\u8b77\u3457T\ua7ef\ua4bb\ua070\ua909\u7d36\u8e48\u246f\u8b23\u3437f\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2473\u8b24\u3437|\ua7e9\ua4a1\ua031\ua903\u7d7f\u8e44\u247b\u8b3b") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("R\ua7d5\ua4bd\ua070\ua901\u7d79\u8e5d\u243a\u8b23\u3476`\ua7e1\ua4b0\ua065\ua945\u7d6d\u8e57\u2420\u8b6d\u346co\ua7a6\ua4bc\ua062\ua945\u7d70\u8e43\u2474\u8b36\u347b2\ua7e4\ua4a0\ua065\ua945\u7d65\u8e42\u247b\u8b33\u3478e\ua7a6\ua4bc\ua062\ua945\u7d78\u8e45\u246e\u8b77\u3473w\ua7e5\ua4ba\ua063\ua904\u7d62\u8e4f\u247e\u8b77\u3460{\ua7f2\ua4bd\ua031\ua925\u7d50\u8e43\u2474\u8b36\u347b");
                    Object[] objectArray = new Object[0xB34004D ^ 0xB34004F];
                    objectArray[0x483DA2B5 ^ 0x483DA2B5] = this.mixin;
                    objectArray[0xB4CDE8B ^ 0xB4CDE8A] = fieldNode.name;
                    logger.warn(string, objectArray);
                }
            }
            mixinTargetContext.addShadowField(fieldNode, field);
        }
    }

    protected boolean validateField(MixinTargetContext mixinTargetContext, FieldNode fieldNode, AnnotationNode annotationNode) {
        String string;
        if (Bytecode.hasFlag(fieldNode, 0x7090FB2 ^ 0x7090FBA)) {
            if (!Bytecode.hasFlag(fieldNode, 0x883D4F29 ^ 0x883D4F2B)) {
                if (!Bytecode.hasFlag(fieldNode, 0x847B9754 ^ 0x847B8754) && annotationNode == null) {
                    Object[] objectArray = new Object[0x9862ACAF ^ 0x9862ACAC];
                    objectArray[0xE5175DA5 ^ 0xE5175DA5] = mixinTargetContext;
                    objectArray[0x9BAE89F2 ^ 0x9BAE89F3] = fieldNode.name;
                    objectArray[0x535C45BA ^ 0x535C45B8] = fieldNode.desc;
                    throw new InvalidMixinException((IMixinContext)mixinTargetContext, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474}\ua7e8\ua4a1\ua070\ua90c\u7d78\u8e59\u243a\u8b39\u3478|\ua7ab\ua4a5\ua063\ua90c\u7d60\u8e4b\u246e\u8b32\u3437a\ua7f2\ua4b4\ua065\ua90c\u7d75\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5\ua034\ua916\u7d2c\u8e0f\u2469"), objectArray));
                }
            }
        }
        if (fieldNode.name.startsWith(string = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("b\ua7f4\ua4b0\ua077\ua90c\u7d6e"), Shadow.class))) {
            Object[] objectArray = new Object[0x31AECC6E ^ 0x31AECC6C];
            objectArray[0x61BD5B5B ^ 0x61BD5B5B] = mixinTargetContext;
            objectArray[0xC339D74F ^ 0xC339D74E] = fieldNode.name;
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("R\ua7d5\ua4bd\ua070\ua901\u7d79\u8e5d\u243a\u8b31\u347ew\ua7ea\ua4b1\ua031\ua940\u7d65\u8e04\u243f\u8b24\u3437z\ua7e7\ua4a6\ua031\ua904\u7d36\u8e59\u2472\u8b36\u3473}\ua7f1\ua4f5\ua061\ua917\u7d73\u8e4c\u2473\u8b2f\u34392\ua7d2\ua4bd\ua078\ua916\u7d36\u8e43\u2469\u8b77\u3479}\ua7f2\ua4f5\ua070\ua909\u7d7a\u8e45\u246d\u8b32\u3473<"), objectArray));
        }
        if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a\ua7f3\ua4a5\ua074\ua917\u7d32").equals(fieldNode.name)) {
            if (fieldNode.access != (0x6348AC46 ^ 0x6348AC44)) {
                Object[] objectArray = new Object[0xE53871D3 ^ 0xE53871D1];
                objectArray[0x7915A966 ^ 0x7915A966] = mixinTargetContext;
                objectArray[0x5448B6F ^ 0x5448B6E] = fieldNode.name;
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7eb\ua4b4\ua076\ua90c\u7d78\u8e4b\u2468\u8b2e\u3437a\ua7f3\ua4a5\ua074\ua917\u7d36\u8e4c\u2473\u8b32\u347bv\ua7a6\ua4f0\ua062\ua94b\u7d33\u8e59\u243a\u8b3a\u3462a\ua7f2\ua4f5\ua073\ua900\u7d36\u8e5a\u2468\u8b3e\u3461s\ua7f2\ua4b0\ua031\ua904\u7d78\u8e4e\u243a\u8b39\u3478|\ua7ab\ua4b3\ua078\ua90b\u7d77\u8e46"), objectArray));
            }
            if (!fieldNode.desc.equals(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^") + this.mixin.getClassRef() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(")"))) {
                Object[] objectArray = new Object[0x5ECFA14F ^ 0x5ECFA14C];
                objectArray[0xC7EFAA04 ^ 0xC7EFAA04] = mixinTargetContext;
                objectArray[0x3E5AE70C ^ 0x3E5AE70D] = fieldNode.name;
                objectArray[0xFC2B8E57 ^ 0xFC2B8E55] = this.mixin.getClassName();
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7eb\ua4b4\ua076\ua90c\u7d78\u8e4b\u2468\u8b2e\u3437a\ua7f3\ua4a5\ua074\ua917\u7d36\u8e4c\u2473\u8b32\u347bv\ua7a6\ua4f0\ua062\ua94b\u7d33\u8e59\u243a\u8b3a\u3462a\ua7f2\ua4f5\ua079\ua904\u7d60\u8e4f\u243a\u8b23\u347fw\ua7a6\ua4a6\ua070\ua908\u7d73\u8e0a\u246e\u8b2e\u3467w\ua7a6\ua4b4\ua062\ua945\u7d62\u8e42\u247f\u8b77\u3467s\ua7f4\ua4b0\ua07f\ua911\u7d36\u8e47\u2473\u8b2f\u347e|\ua7a6\ua4fd\ua034\ua916\u7d3f"), objectArray));
            }
            return (0x9DD37394 ^ 0x9DD37394) != 0;
        }
        return (0x532BE07 ^ 0x532BE06) != 0;
    }

    protected void transform(MixinTargetContext mixinTargetContext) {
        for (MethodNode methodNode : this.classNode.methods) {
            ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
            while (listIterator.hasNext()) {
                AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
                if (abstractInsnNode instanceof MethodInsnNode) {
                    this.transformMethod((MethodInsnNode)abstractInsnNode);
                    continue;
                }
                if (!(abstractInsnNode instanceof FieldInsnNode)) continue;
                this.transformField((FieldInsnNode)abstractInsnNode);
            }
        }
    }

    protected void transformMethod(MethodInsnNode methodInsnNode) {
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7e3\ua4a1\ua070"));
        ClassInfo classInfo = ClassInfo.forName(methodInsnNode.owner);
        if (classInfo == null) {
            throw new RuntimeException(new ClassNotFoundException(methodInsnNode.owner.replace((char)(0xADE855A2 ^ 0xADE8558D), (char)(0x804E0DB9 ^ 0x804E0D97))));
        }
        ClassInfo.Method method = classInfo.findMethodInHierarchy(methodInsnNode, ClassInfo.SearchType.ALL_CLASSES, 0x96EF1847 ^ 0x96EF1845);
        section.end();
        if (method != null && method.isRenamed()) {
            methodInsnNode.name = method.getName();
        }
    }

    protected void transformField(FieldInsnNode fieldInsnNode) {
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7e3\ua4a1\ua070"));
        ClassInfo classInfo = ClassInfo.forName(fieldInsnNode.owner);
        if (classInfo == null) {
            throw new RuntimeException(new ClassNotFoundException(fieldInsnNode.owner.replace((char)(0x2CFD68F9 ^ 0x2CFD68D6), (char)(0x7CA3CD30 ^ 0x7CA3CD1E))));
        }
        ClassInfo.Field field = classInfo.findField(fieldInsnNode, 0x15F973F2 ^ 0x15F973F0);
        section.end();
        if (field != null && field.isRenamed()) {
            fieldInsnNode.name = field.getName();
        }
    }

    protected static String getDynamicInfo(MethodNode methodNode) {
        return MixinPreProcessorStandard.getDynamicInfo(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("_\ua7e3\ua4a1\ua079\ua90a\u7d72"), Annotations.getInvisible(methodNode, Dynamic.class));
    }

    protected static String getDynamicInfo(FieldNode fieldNode) {
        return MixinPreProcessorStandard.getDynamicInfo(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("T\ua7ef\ua4b0\ua07d\ua901"), Annotations.getInvisible(fieldNode, Dynamic.class));
    }

    private static String getDynamicInfo(String string, AnnotationNode annotationNode) {
        String string2;
        String string3 = Strings.nullToEmpty((String)((String)Annotations.getValue(annotationNode)));
        Type type = (Type)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b"));
        if (type != null) {
            Object[] objectArray = new Object[0x9285149C ^ 0x9285149E];
            objectArray[0xCA59731A ^ 0xCA59731A] = type.getClassName();
            objectArray[0xB9C230D9 ^ 0xB9C230D8] = string3;
            string3 = String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("i\ua7a3\ua4a6\ua06c\ua945\u7d33\u8e59"), objectArray).trim();
        }
        if (string3.length() > 0) {
            Object[] objectArray = new Object[0x1CBB029E ^ 0x1CBB029C];
            objectArray[0x34A27B7 ^ 0x34A27B7] = string;
            objectArray[0x408DD9FA ^ 0x408DD9FB] = string3;
            string2 = String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7a3\ua4a6\ua031\ua90c\u7d65\u8e0a\u245a\u8b13\u346e|\ua7e7\ua4b8\ua078\ua906\u7d3e\u8e0f\u2469\u8b7e"), objectArray);
        } else {
            string2 = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("");
        }
        return string2;
    }

    static final class SpecialMethod
    extends Enum<SpecialMethod> {
        public static final /* enum */ SpecialMethod MERGE = new SpecialMethod((0x3CBF9CAC ^ 0x3CBF9CAD) != 0);
        public static final /* enum */ SpecialMethod OVERWRITE = new SpecialMethod((0x9388A6A9 ^ 0x9388A6A8) != 0, Overwrite.class);
        public static final /* enum */ SpecialMethod SHADOW = new SpecialMethod((0x76ABBF1D ^ 0x76ABBF1D) != 0, Shadow.class);
        public static final /* enum */ SpecialMethod ACCESSOR = new SpecialMethod((0x8B6CEED9 ^ 0x8B6CEED9) != 0, Accessor.class);
        public static final /* enum */ SpecialMethod INVOKER = new SpecialMethod((0x9BA3239D ^ 0x9BA3239D) != 0, Invoker.class);
        final boolean isOverwrite;
        final Class<? extends Annotation> annotation;
        final String description;
        private static final /* synthetic */ SpecialMethod[] $VALUES;

        public static SpecialMethod[] values() {
            return (SpecialMethod[])$VALUES.clone();
        }

        public static SpecialMethod valueOf(String string) {
            return Enum.valueOf(SpecialMethod.class, string);
        }

        private SpecialMethod(boolean bl, Class<? extends Annotation> clazz) {
            this.isOverwrite = bl;
            this.annotation = clazz;
            this.description = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("R") + Bytecode.getSimpleName(clazz);
        }

        private SpecialMethod(boolean bl) {
            this.isOverwrite = bl;
            this.annotation = null;
            this.description = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("}\ua7f0\ua4b0\ua063\ua912\u7d64\u8e43\u246e\u8b32");
        }

        public String toString() {
            return this.description;
        }

        static {
            SpecialMethod[] specialMethodArray = new SpecialMethod[0x2C3429A7 ^ 0x2C3429A2];
            specialMethodArray[0x8456168B ^ 0x8456168B] = MERGE;
            specialMethodArray[0x871CACF ^ 0x871CACE] = OVERWRITE;
            specialMethodArray[0x4455EB32 ^ 0x4455EB30] = SHADOW;
            specialMethodArray[0x2D9BC8C9 ^ 0x2D9BC8CA] = ACCESSOR;
            specialMethodArray[0x7474DECD ^ 0x7474DEC9] = INVOKER;
            $VALUES = specialMethodArray;
        }
    }
}

