/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.io.OutputStream;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.struct.SourceMap;
import org.spongepowered.asm.mixin.transformer.ClassContext;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinApplicatorInterface;
import org.spongepowered.asm.mixin.transformer.MixinApplicatorStandard;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.ClassSignature;

class TargetClassContext
extends ClassContext
implements ITargetClassContext {
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    private final MixinEnvironment env;
    private final Extensions extensions;
    private final String sessionId;
    private final String className;
    private final ClassNode classNode;
    private final ClassInfo classInfo;
    private final SourceMap sourceMap;
    private final ClassSignature signature;
    private final SortedSet<MixinInfo> mixins;
    private final Map<String, Target> targetMethods = new HashMap<String, Target>();
    private final Set<MethodNode> mixinMethods = new HashSet<MethodNode>();
    private int nextUniqueMethodIndex;
    private int nextUniqueFieldIndex;
    private boolean applied;
    private boolean forceExport;

    TargetClassContext(MixinEnvironment mixinEnvironment, Extensions extensions, String string, String string2, ClassNode classNode, SortedSet<MixinInfo> sortedSet) {
        this.env = mixinEnvironment;
        this.extensions = extensions;
        this.sessionId = string;
        this.className = string2;
        this.classNode = classNode;
        this.classInfo = ClassInfo.fromClassNode(classNode);
        this.signature = this.classInfo.getSignature();
        this.mixins = sortedSet;
        this.sourceMap = new SourceMap(classNode.sourceFile);
        this.sourceMap.addFile(this.classNode);
    }

    public String toString() {
        return this.className;
    }

    boolean isApplied() {
        return this.applied;
    }

    boolean isExportForced() {
        return this.forceExport;
    }

    Extensions getExtensions() {
        return this.extensions;
    }

    String getSessionId() {
        return this.sessionId;
    }

    @Override
    String getClassRef() {
        return this.classNode.name;
    }

    String getClassName() {
        return this.className;
    }

    @Override
    public ClassNode getClassNode() {
        return this.classNode;
    }

    List<MethodNode> getMethods() {
        return this.classNode.methods;
    }

    List<FieldNode> getFields() {
        return this.classNode.fields;
    }

    @Override
    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    SortedSet<MixinInfo> getMixins() {
        return this.mixins;
    }

    SourceMap getSourceMap() {
        return this.sourceMap;
    }

    void mergeSignature(ClassSignature classSignature) {
        this.signature.merge(classSignature);
    }

    void addMixinMethod(MethodNode methodNode) {
        this.mixinMethods.add(methodNode);
    }

    void methodMerged(MethodNode methodNode) {
        if (!this.mixinMethods.remove(methodNode)) {
            Object[] objectArray = new Object[0x7F1BC83 ^ 0x7F1BC80];
            objectArray[0x64661586 ^ 0x64661586] = methodNode.name;
            objectArray[0xA7944587 ^ 0xA7944586] = methodNode.desc;
            objectArray[0xD40BE5D6 ^ 0xD40BE5D4] = this;
            logger.debug(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("G\ua7e8\ua4b0\ua069\ua915\u7d73\u8e49\u246e\u8b32\u3473(\ua7a6\ua498\ua074\ua917\u7d71\u8e4f\u247e\u8b77\u3462|\ua7f4\ua4b0\ua076\ua90c\u7d65\u8e5e\u247f\u8b25\u3472v\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u346co\ua7fd\ua4a8\ua031\ua90c\u7d78\u8e0a\u2461\u8b2a"), objectArray);
        }
    }

    MethodNode findMethod(Deque<String> deque, String string) {
        return this.findAliasedMethod(deque, string, (0x605AC027 ^ 0x605AC026) != 0);
    }

    MethodNode findAliasedMethod(Deque<String> deque, String string) {
        return this.findAliasedMethod(deque, string, (0xBEEEB673 ^ 0xBEEEB673) != 0);
    }

    private MethodNode findAliasedMethod(Deque<String> deque, String string, boolean bl) {
        String string2 = deque.poll();
        if (string2 == null) {
            return null;
        }
        for (MethodNode methodNode : this.classNode.methods) {
            if (!methodNode.name.equals(string2) || !methodNode.desc.equals(string)) continue;
            return methodNode;
        }
        if (bl) {
            for (MethodNode methodNode : this.mixinMethods) {
                if (!methodNode.name.equals(string2) || !methodNode.desc.equals(string)) continue;
                return methodNode;
            }
        }
        return this.findAliasedMethod(deque, string);
    }

    FieldNode findAliasedField(Deque<String> deque, String string) {
        String string2 = deque.poll();
        if (string2 == null) {
            return null;
        }
        for (FieldNode fieldNode : this.classNode.fields) {
            if (!fieldNode.name.equals(string2) || !fieldNode.desc.equals(string)) continue;
            return fieldNode;
        }
        return this.findAliasedField(deque, string);
    }

    Target getTargetMethod(MethodNode methodNode) {
        if (!this.classNode.methods.contains(methodNode)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u3476`\ua7e1\ua4b0\ua065\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a6\ua4a6\ua064\ua915\u7d66\u8e46\u2473\u8b32\u34732\ua7f2\ua4ba\ua031\ua902\u7d73\u8e5e\u244e\u8b36\u3465u\ua7e3\ua4a1\ua05c\ua900\u7d62\u8e42\u2475\u8b33\u343f;"));
        }
        String string = methodNode.name + methodNode.desc;
        Target target = this.targetMethods.get(string);
        if (target == null) {
            target = new Target(this.classNode, methodNode);
            this.targetMethods.put(string, target);
        }
        return target;
    }

    String getUniqueName(MethodNode methodNode, boolean bl) {
        int n = this.nextUniqueMethodIndex;
        this.nextUniqueMethodIndex = n + (0xFBAA6A87 ^ 0xFBAA6A86);
        String string = Integer.toHexString(n);
        String string2 = bl ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7b4\ua4f1\ua062\ua93a\u7d32\u8e47\u247e\u8b73\u3432#\ua7a2\ua4a6\ua035\ua940\u7d25\u8e0e\u2469") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7e2\ua4f0\ua062\ua941\u7d33\u8e59\u243e\u8b72\u3464");
        Object[] objectArray = new Object[0x7BEFCB4F ^ 0x7BEFCB4C];
        objectArray[0x798EF0C4 ^ 0x798EF0C4] = this.sessionId.substring(0xB19EFCC4 ^ 0xB19EFCDA);
        objectArray[0x9E4E6273 ^ 0x9E4E6272] = methodNode.name;
        objectArray[0xE96D79D6 ^ 0xE96D79D4] = string;
        return String.format(string2, objectArray);
    }

    String getUniqueName(FieldNode fieldNode) {
        int n = this.nextUniqueFieldIndex;
        this.nextUniqueFieldIndex = n + (0xA451050 ^ 0xA451051);
        String string = Integer.toHexString(n);
        Object[] objectArray = new Object[0x3AB430C0 ^ 0x3AB430C3];
        objectArray[0xBDE74FCF ^ 0xBDE74FCF] = this.sessionId.substring(0x68597961 ^ 0x6859797F);
        objectArray[0xD420DA2E ^ 0xD420DA2F] = fieldNode.name;
        objectArray[0x7283859F ^ 0x7283859D] = string;
        return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("t\ua7e2\ua4f0\ua062\ua941\u7d33\u8e59\u243e\u8b72\u3464"), objectArray);
    }

    void applyMixins() {
        if (this.applied) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("_\ua7ef\ua4ad\ua078\ua90b\u7d65\u8e0a\u247b\u8b3b\u3465w\ua7e7\ua4b1\ua068\ua945\u7d77\u8e5a\u246a\u8b3b\u347ew\ua7e2\ua4f5\ua065\ua90a\u7d36\u8e5e\u247b\u8b25\u3470w\ua7f2\ua4f5\ua072\ua909\u7d77\u8e59\u2469\u8b77") + this.className);
        }
        this.applied = 0x27AB7680 ^ 0x27AB7681;
        MixinApplicatorStandard mixinApplicatorStandard = this.createApplicator();
        mixinApplicatorStandard.apply(this.mixins);
        this.applySignature();
        this.upgradeMethods();
        this.checkMerges();
    }

    private MixinApplicatorStandard createApplicator() {
        if (this.classInfo.isInterface()) {
            return new MixinApplicatorInterface(this);
        }
        return new MixinApplicatorStandard(this);
    }

    private void applySignature() {
        this.getClassNode().signature = this.signature.toString();
    }

    private void checkMerges() {
        for (MethodNode methodNode : this.mixinMethods) {
            if (methodNode.name.startsWith(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("."))) continue;
            Object[] objectArray = new Object[0x21E4CF7A ^ 0x21E4CF79];
            objectArray[0x5EF38E12 ^ 0x5EF38E12] = methodNode.name;
            objectArray[0xD3B6EA64 ^ 0xD3B6EA65] = methodNode.desc;
            objectArray[0x8A21ACBC ^ 0x8A21ACBE] = this;
            logger.debug(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("G\ua7e8\ua4b0\ua069\ua915\u7d73\u8e49\u246e\u8b32\u3473(\ua7a6\ua487\ua074\ua902\u7d7f\u8e59\u246e\u8b32\u3465w\ua7e2\ua4f5\ua07c\ua900\u7d62\u8e42\u2475\u8b33\u3437i\ua7fb\ua4ae\ua06c\ua945\u7d7f\u8e44\u243a\u8b2c\u346a2\ua7f1\ua4b4\ua062\ua945\u7d78\u8e45\u246e\u8b77\u347aw\ua7f4\ua4b2\ua074\ua901"), objectArray);
        }
    }

    void processDebugTasks() {
        if (!this.env.getOption(MixinEnvironment.Option.DEBUG_VERBOSE)) {
            return;
        }
        AnnotationNode annotationNode = Annotations.getVisible(this.classNode, Debug.class);
        if (annotationNode != null) {
            this.forceExport = Boolean.TRUE.equals(Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("w\ua7fe\ua4a5\ua07e\ua917\u7d62")));
            if (Boolean.TRUE.equals(Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("b\ua7f4\ua4bc\ua07f\ua911")))) {
                Bytecode.textify(this.classNode, (OutputStream)System.err);
            }
        }
        for (MethodNode methodNode : this.classNode.methods) {
            AnnotationNode annotationNode2 = Annotations.getVisible(methodNode, Debug.class);
            if (annotationNode2 == null || !Boolean.TRUE.equals(Annotations.getValue(annotationNode2, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("b\ua7f4\ua4bc\ua07f\ua911")))) continue;
            Bytecode.textify(methodNode, (OutputStream)System.err);
        }
    }
}

