/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer.debug;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.java.decompiler.main.Fernflower;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.spongepowered.asm.mixin.transformer.ext.IDecompiler;

public class RuntimeDecompiler
extends IFernflowerLogger
implements IResultSaver,
IDecompiler {
    private static final Level[] SEVERITY_LEVELS;
    private final Map<String, Object> options = ImmutableMap.builder().put((Object)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("v\ua7ef\ua4bb"), (Object)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\"")).put((Object)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("`\ua7e4\ua4a7"), (Object)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\"")).put((Object)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("v\ua7e1\ua4a6"), (Object)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("#")).put((Object)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("s\ua7f5\ua4b6"), (Object)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("#")).put((Object)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("v\ua7e3\ua4bb"), (Object)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("#")).put((Object)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("z\ua7e2\ua4b6"), (Object)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("#")).put((Object)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("{\ua7e8\ua4b1"), (Object)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7a6\ua4f5\ua031")).build();
    private final File outputPath;
    protected final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("t\ua7e3\ua4a7\ua07f\ua903\u7d7a\u8e45\u246d\u8b32\u3465"));

    public RuntimeDecompiler(File file) {
        this.outputPath = file;
        if (this.outputPath.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.outputPath);
            }
            catch (IOException iOException) {
                Object[] objectArray = new Object[0x780B52B1 ^ 0x780B52B0];
                objectArray[0x2BF55593 ^ 0x2BF55593] = iOException.getMessage();
                this.logger.warn(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("W\ua7f4\ua4a7\ua07e\ua917\u7d36\u8e49\u2476\u8b32\u3476|\ua7ef\ua4bb\ua076\ua945\u7d79\u8e5f\u246e\u8b27\u3462f\ua7a6\ua4b1\ua078\ua917\u7d73\u8e49\u246e\u8b38\u3465k\ua7bc\ua4f5\ua06a\ua918"), objectArray);
            }
        }
    }

    @Override
    public void decompile(File file) {
        try {
            Fernflower fernflower = new Fernflower(new IBytecodeProvider(){
                private byte[] byteCode;

                public byte[] getBytecode(String string, String string2) throws IOException {
                    if (this.byteCode == null) {
                        this.byteCode = InterpreterUtil.getBytes((File)new File(string));
                    }
                    return this.byteCode;
                }
            }, (IResultSaver)this, this.options, (IFernflowerLogger)this);
            fernflower.getStructContext().addSpace(file, (0x9D4D6FF8 ^ 0x9D4D6FF9) != 0);
            fernflower.decompileContext();
        }
        catch (Throwable throwable) {
            Object[] objectArray = new Object[0xD0204705 ^ 0xD0204704];
            objectArray[0xEC7A7F1B ^ 0xEC7A7F1B] = file.getName();
            this.logger.warn(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("V\ua7e3\ua4b6\ua07e\ua908\u7d66\u8e43\u2476\u8b36\u3463{\ua7e9\ua4bb\ua031\ua900\u7d64\u8e58\u2475\u8b25\u3437e\ua7ee\ua4bc\ua07d\ua900\u7d36\u8e5a\u2468\u8b38\u3474w\ua7f5\ua4a6\ua078\ua90b\u7d71\u8e0a\u2461\u8b2a"), objectArray);
        }
    }

    public void saveFolder(String string) {
    }

    public void saveClassFile(String string, String string2, String string3, String string4, int[] nArray) {
        File file = new File(this.outputPath, string2 + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("<\ua7ec\ua4b4\ua067\ua904"));
        file.getParentFile().mkdirs();
        try {
            Object[] objectArray = new Object[0x5923563C ^ 0x5923563D];
            objectArray[0xF965BFEF ^ 0xF965BFEF] = file.getAbsolutePath();
            this.logger.info(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("E\ua7f4\ua4bc\ua065\ua90c\u7d78\u8e4d\u243a\u8b2c\u346a"), objectArray);
            Files.write((CharSequence)string4, (File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException iOException) {
            this.writeMessage(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u246d\u8b25\u347ef\ua7e3\ua4f5\ua062\ua90a\u7d63\u8e58\u2479\u8b32\u3437t\ua7ef\ua4b9\ua074\ua945") + file, iOException);
        }
    }

    public void startReadingClass(String string) {
        Object[] objectArray = new Object[0xCACB5FE0 ^ 0xCACB5FE1];
        objectArray[0xE7101146 ^ 0xE7101146] = string;
        this.logger.info(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("V\ua7e3\ua4b6\ua07e\ua908\u7d66\u8e43\u2476\u8b3e\u3479u\ua7a6\ua4ae\ua06c"), objectArray);
    }

    public void writeMessage(String string, IFernflowerLogger.Severity severity) {
        this.logger.log(SEVERITY_LEVELS[severity.ordinal()], string);
    }

    public void writeMessage(String string, Throwable throwable) {
        Object[] objectArray = new Object[0x973484B7 ^ 0x973484B4];
        objectArray[0x2386363B ^ 0x2386363B] = string;
        objectArray[0x1CCF53EC ^ 0x1CCF53ED] = throwable.getClass().getSimpleName();
        objectArray[0x502EE4AE ^ 0x502EE4AC] = throwable.getMessage();
        this.logger.warn(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("i\ua7fb\ua4f5\ua06a\ua918\u7d2c\u8e0a\u2461\u8b2a"), objectArray);
    }

    public void writeMessage(String string, IFernflowerLogger.Severity severity, Throwable throwable) {
        this.logger.log(SEVERITY_LEVELS[severity.ordinal()], string, throwable);
    }

    public void copyFile(String string, String string2, String string3) {
    }

    public void createArchive(String string, String string2, Manifest manifest) {
    }

    public void saveDirEntry(String string, String string2, String string3) {
    }

    public void copyEntry(String string, String string2, String string3, String string4) {
    }

    public void saveClassEntry(String string, String string2, String string3, String string4, String string5) {
    }

    public void closeArchive(String string, String string2) {
    }

    static {
        Level[] levelArray = new Level[0x36D5A11 ^ 0x36D5A15];
        levelArray[0x27E6482C ^ 0x27E6482C] = Level.TRACE;
        levelArray[0x6A10BCA5 ^ 0x6A10BCA4] = Level.INFO;
        levelArray[0xC701EE1D ^ 0xC701EE1F] = Level.WARN;
        levelArray[0x2DA4DCA ^ 0x2DA4DC9] = Level.ERROR;
        SEVERITY_LEVELS = levelArray;
    }
}

