/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer.ext.extensions;

import com.google.common.base.Charsets;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import org.spongepowered.asm.util.Constants;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.asm.util.SignaturePrinter;

public class ExtensionCheckInterfaces
implements IExtension {
    private static final String AUDIT_DIR = "audit";
    private static final String IMPL_REPORT_FILENAME = "mixin_implementation_report";
    private static final String IMPL_REPORT_CSV_FILENAME = "mixin_implementation_report.csv";
    private static final String IMPL_REPORT_TXT_FILENAME = "mixin_implementation_report.txt";
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    private final File csv;
    private final File report;
    private final Multimap<ClassInfo, ClassInfo.Method> interfaceMethods = HashMultimap.create();
    private boolean strict;

    public ExtensionCheckInterfaces() {
        File file = new File(Constants.DEBUG_OUTPUT_DIR, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("s\ua7f3\ua4b1\ua078\ua911"));
        file.mkdirs();
        this.csv = new File(file, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b\u7d49\u8e43\u2477\u8b27\u347bw\ua7eb\ua4b0\ua07f\ua911\u7d77\u8e5e\u2473\u8b38\u3479M\ua7f4\ua4b0\ua061\ua90a\u7d64\u8e5e\u2434\u8b34\u3464d"));
        this.report = new File(file, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b\u7d49\u8e43\u2477\u8b27\u347bw\ua7eb\ua4b0\ua07f\ua911\u7d77\u8e5e\u2473\u8b38\u3479M\ua7f4\ua4b0\ua061\ua90a\u7d64\u8e5e\u2434\u8b23\u346ff"));
        try {
            Files.write((CharSequence)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7ea\ua4b4\ua062\ua916\u7d3a\u8e67\u247f\u8b23\u347f}\ua7e2\ua4f9\ua042\ua90c\u7d71\u8e44\u247b\u8b23\u3462`\ua7e3\ua4f9\ua058\ua90b\u7d62\u8e4f\u2468\u8b31\u3476q\ua7e3\ua4df"), (File)this.csv, (Charset)Charsets.ISO_8859_1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            String string = new SimpleDateFormat(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("k\ua7ff\ua4ac\ua068\ua948\u7d5b\u8e67\u2437\u8b33\u34732\ua7ce\ua49d\ua02b\ua908\u7d7b\u8e10\u2469\u8b24")).format(new Date());
            Files.write((CharSequence)(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e63\u2477\u8b27\u347bw\ua7eb\ua4b0\ua07f\ua911\u7d77\u8e5e\u2473\u8b38\u34792\ua7d4\ua4b0\ua061\ua90a\u7d64\u8e5e\u243a\u8b30\u3472|\ua7e3\ua4a7\ua070\ua911\u7d73\u8e4e\u243a\u8b38\u34792") + string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u0018")), (File)this.report, (Charset)Charsets.ISO_8859_1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean checkActive(MixinEnvironment mixinEnvironment) {
        this.strict = mixinEnvironment.getOption(MixinEnvironment.Option.CHECK_IMPLEMENTS_STRICT);
        return mixinEnvironment.getOption(MixinEnvironment.Option.CHECK_IMPLEMENTS);
    }

    @Override
    public void preApply(ITargetClassContext iTargetClassContext) {
        ClassInfo classInfo = iTargetClassContext.getClassInfo();
        for (ClassInfo.Method method : classInfo.getInterfaceMethods((0xB837D15E ^ 0xB837D15E) != 0)) {
            this.interfaceMethods.put((Object)classInfo, (Object)method);
        }
    }

    @Override
    public void postApply(ITargetClassContext iTargetClassContext) {
        ClassInfo classInfo = iTargetClassContext.getClassInfo();
        if (classInfo.isAbstract() && !this.strict) {
            Object[] objectArray = new Object[0x38461B25 ^ 0x38461B27];
            objectArray[0xBC0C6934 ^ 0xBC0C6934] = this.getClass().getSimpleName();
            objectArray[0xBDE880D8 ^ 0xBDE880D9] = iTargetClassContext;
            logger.info(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("i\ua7fb\ua4f5\ua078\ua916\u7d36\u8e59\u2471\u8b3e\u3467b\ua7ef\ua4bb\ua076\ua945\u7d77\u8e48\u2469\u8b23\u3465s\ua7e5\ua4a1\ua031\ua911\u7d77\u8e58\u247d\u8b32\u34632\ua7fd\ua4a8"), objectArray);
            return;
        }
        String string = classInfo.getName().replace((char)(0xBCCE9830 ^ 0xBCCE981F), (char)(0x1712FD96 ^ 0x1712FDB8));
        int n = 0xDA076AAD ^ 0xDA076AAD;
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        Object[] objectArray = new Object[0xEB532063 ^ 0xEB532062];
        objectArray[0xC641D621 ^ 0xC641D621] = string;
        prettyPrinter.add(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7ea\ua4b4\ua062\ua916\u7d2c\u8e0a\u243f\u8b24"), objectArray).hr();
        Object[] objectArray2 = new Object[0x9EE9D09C ^ 0x9EE9D09F];
        objectArray2[0xC49B782B ^ 0xC49B782B] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7e3\ua4a1\ua064\ua917\u7d78\u8e0a\u244e\u8b2e\u3467w");
        objectArray2[0x1633EF10 ^ 0x1633EF11] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("_\ua7ef\ua4a6\ua062\ua90c\u7d78\u8e4d\u243a\u8b1a\u3472f\ua7ee\ua4ba\ua075");
        objectArray2[0xA33E7924 ^ 0xA33E7926] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("T\ua7f4\ua4ba\ua07c\ua945\u7d5f\u8e44\u246e\u8b32\u3465t\ua7e7\ua4b6\ua074");
        prettyPrinter.add(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7ab\ua4e6\ua023\ua916\u7d36\u8e0f\u2437\u8b63\u3420a\ua7a6\ua4f5\ua034\ua916"), objectArray2).hr();
        Set<ClassInfo.Method> set = classInfo.getInterfaceMethods((0x3FFBA71E ^ 0x3FFBA71F) != 0);
        HashSet<ClassInfo.Method> hashSet = new HashSet<ClassInfo.Method>(classInfo.getSuperClass().getInterfaceMethods((0xC6E34111 ^ 0xC6E34110) != 0));
        hashSet.addAll(this.interfaceMethods.removeAll((Object)classInfo));
        for (ClassInfo.Method method : set) {
            ClassInfo.Method method2 = classInfo.findMethodInHierarchy(method.getName(), method.getDesc(), ClassInfo.SearchType.ALL_CLASSES, ClassInfo.Traversal.ALL);
            if (method2 != null && !method2.isAbstract() || hashSet.contains(method)) continue;
            if (n > 0) {
                prettyPrinter.add();
            }
            SignaturePrinter signaturePrinter = new SignaturePrinter(method.getName(), method.getDesc()).setModifiers(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(""));
            String string2 = method.getOwner().getName().replace((char)(0xECD66ED5 ^ 0xECD66EFA), (char)(0x89835363 ^ 0x8983534D));
            ++n;
            Object[] objectArray3 = new Object[0x264A5DEC ^ 0x264A5DEE];
            objectArray3[0xD047C9A2 ^ 0xD047C9A2] = signaturePrinter.getReturnType();
            objectArray3[0x400FBCE2 ^ 0x400FBCE3] = signaturePrinter;
            prettyPrinter.add(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7ab\ua4e6\ua023\ua916\u7d33\u8e59"), objectArray3);
            Object[] objectArray4 = new Object[0x1B96BAFD ^ 0x1B96BAFF];
            objectArray4[0x210FC1B2 ^ 0x210FC1B2] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("");
            objectArray4[0x957F3931 ^ 0x957F3930] = string2;
            prettyPrinter.add(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7ab\ua4ed\ua021\ua916\u7d36\u8e0a\u243f\u8b24"), objectArray4);
            this.appendToCSVReport(string, method, string2);
        }
        if (n > 0) {
            Object[] objectArray5 = new Object[0x982288AC ^ 0x982288AF];
            objectArray5[0x2923B3B5 ^ 0x2923B3B5] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("");
            objectArray5[0x139AFC26 ^ 0x139AFC27] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F\ua7e9\ua4a1\ua070\ua909\u7d36\u8e5f\u2474\u8b3e\u347ab\ua7ea\ua4b0\ua07c\ua900\u7d78\u8e5e\u247f\u8b33");
            objectArray5[0xE6882541 ^ 0xE6882543] = n;
            prettyPrinter.hr().add(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7be\ua4e7\ua062\ua940\u7d65\u8e10\u243a\u8b72\u3473"), objectArray5);
            prettyPrinter.print(System.err);
            this.appendToTextReport(prettyPrinter);
        }
    }

    @Override
    public void export(MixinEnvironment mixinEnvironment, String string, boolean bl, byte[] byArray) {
    }

    private void appendToCSVReport(String string, ClassInfo.Method method, String string2) {
        try {
            Object[] objectArray = new Object[0xDC2FEE7E ^ 0xDC2FEE7A];
            objectArray[0xDD64B36 ^ 0xDD64B36] = string;
            objectArray[0xED74C203 ^ 0xED74C202] = method.getName();
            objectArray[0x6AFD42A4 ^ 0x6AFD42A6] = method.getDesc();
            objectArray[0x5E35A15F ^ 0x5E35A15C] = string2;
            Files.append((CharSequence)String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f9\ua034\ua916\u7d3a\u8e0f\u2469\u8b7b\u3432a\ua78c"), objectArray), (File)this.csv, (Charset)Charsets.ISO_8859_1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendToTextReport(PrettyPrinter prettyPrinter) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.report, (0x7B1F4C08 ^ 0x7B1F4C09) != 0);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.print(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u0018"));
            prettyPrinter.print(printStream);
        }
        catch (Exception exception) {
            IOUtils.closeQuietly(fileOutputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
    }
}

