/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.MethodNode;

public final class Annotations {
    private Annotations() {
    }

    public static void setVisible(FieldNode fieldNode, Class<? extends Annotation> clazz, Object ... objectArray) {
        AnnotationNode annotationNode = Annotations.createNode(Type.getDescriptor(clazz), objectArray);
        fieldNode.visibleAnnotations = Annotations.add(fieldNode.visibleAnnotations, annotationNode);
    }

    public static void setInvisible(FieldNode fieldNode, Class<? extends Annotation> clazz, Object ... objectArray) {
        AnnotationNode annotationNode = Annotations.createNode(Type.getDescriptor(clazz), objectArray);
        fieldNode.invisibleAnnotations = Annotations.add(fieldNode.invisibleAnnotations, annotationNode);
    }

    public static void setVisible(MethodNode methodNode, Class<? extends Annotation> clazz, Object ... objectArray) {
        AnnotationNode annotationNode = Annotations.createNode(Type.getDescriptor(clazz), objectArray);
        methodNode.visibleAnnotations = Annotations.add(methodNode.visibleAnnotations, annotationNode);
    }

    public static void setInvisible(MethodNode methodNode, Class<? extends Annotation> clazz, Object ... objectArray) {
        AnnotationNode annotationNode = Annotations.createNode(Type.getDescriptor(clazz), objectArray);
        methodNode.invisibleAnnotations = Annotations.add(methodNode.invisibleAnnotations, annotationNode);
    }

    private static AnnotationNode createNode(String string, Object ... objectArray) {
        AnnotationNode annotationNode = new AnnotationNode(string);
        int n = 0x25148695 ^ 0x25148695;
        while (true) {
            if (n >= objectArray.length - (0xAB6CE0E8 ^ 0xAB6CE0E9)) break;
            if (!(objectArray[n] instanceof String)) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("S\ua7e8\ua4bb\ua07e\ua911\u7d77\u8e5e\u2473\u8b38\u34792\ua7ed\ua4b0\ua068\ua916\u7d36\u8e47\u246f\u8b24\u34632\ua7e4\ua4b0\ua031\ua916\u7d62\u8e58\u2473\u8b39\u3470a\ua7aa\ua4f5\ua077\ua90a\u7d63\u8e44\u247e\u8b77") + objectArray[n].getClass().getSimpleName() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7f1\ua4bc\ua065\ua90d\u7d36") + objectArray[n].toString() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e7\ua4a1\ua031\ua90c\u7d78\u8e4e\u247f\u8b2f\u3437") + n + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e5\ua4a7\ua074\ua904\u7d62\u8e43\u2474\u8b30\u3437") + string);
            }
            annotationNode.visit((String)objectArray[n], objectArray[n + (0x4A913C1 ^ 0x4A913C0)]);
            n += 2;
        }
        return annotationNode;
    }

    private static List<AnnotationNode> add(List<AnnotationNode> list, AnnotationNode annotationNode) {
        if (list == null) {
            list = new ArrayList<AnnotationNode>(0x47590B15 ^ 0x47590B14);
        } else {
            list.remove(Annotations.get(list, annotationNode.desc));
        }
        list.add(annotationNode);
        return list;
    }

    public static AnnotationNode getVisible(FieldNode fieldNode, Class<? extends Annotation> clazz) {
        return Annotations.get(fieldNode.visibleAnnotations, Type.getDescriptor(clazz));
    }

    public static AnnotationNode getInvisible(FieldNode fieldNode, Class<? extends Annotation> clazz) {
        return Annotations.get(fieldNode.invisibleAnnotations, Type.getDescriptor(clazz));
    }

    public static AnnotationNode getVisible(MethodNode methodNode, Class<? extends Annotation> clazz) {
        return Annotations.get(methodNode.visibleAnnotations, Type.getDescriptor(clazz));
    }

    public static AnnotationNode getInvisible(MethodNode methodNode, Class<? extends Annotation> clazz) {
        return Annotations.get(methodNode.invisibleAnnotations, Type.getDescriptor(clazz));
    }

    public static AnnotationNode getSingleVisible(MethodNode methodNode, Class<? extends Annotation> ... classArray) {
        return Annotations.getSingle(methodNode.visibleAnnotations, classArray);
    }

    public static AnnotationNode getSingleInvisible(MethodNode methodNode, Class<? extends Annotation> ... classArray) {
        return Annotations.getSingle(methodNode.invisibleAnnotations, classArray);
    }

    public static AnnotationNode getVisible(ClassNode classNode, Class<? extends Annotation> clazz) {
        return Annotations.get(classNode.visibleAnnotations, Type.getDescriptor(clazz));
    }

    public static AnnotationNode getInvisible(ClassNode classNode, Class<? extends Annotation> clazz) {
        return Annotations.get(classNode.invisibleAnnotations, Type.getDescriptor(clazz));
    }

    public static AnnotationNode getVisibleParameter(MethodNode methodNode, Class<? extends Annotation> clazz, int n) {
        return Annotations.getParameter(methodNode.visibleParameterAnnotations, Type.getDescriptor(clazz), n);
    }

    public static AnnotationNode getInvisibleParameter(MethodNode methodNode, Class<? extends Annotation> clazz, int n) {
        return Annotations.getParameter(methodNode.invisibleParameterAnnotations, Type.getDescriptor(clazz), n);
    }

    public static AnnotationNode getParameter(List<AnnotationNode>[] listArray, String string, int n) {
        if (listArray == null || n < 0 || n >= listArray.length) {
            return null;
        }
        return Annotations.get(listArray[n], string);
    }

    public static AnnotationNode get(List<AnnotationNode> list, String string) {
        if (list == null) {
            return null;
        }
        for (AnnotationNode annotationNode : list) {
            if (!string.equals(annotationNode.desc)) continue;
            return annotationNode;
        }
        return null;
    }

    private static AnnotationNode getSingle(List<AnnotationNode> list, Class<? extends Annotation>[] classArray) {
        ArrayList<AnnotationNode> arrayList = new ArrayList<AnnotationNode>();
        Class<? extends Annotation>[] classArray2 = classArray;
        int n = classArray2.length;
        for (int i = 0x1B643DB5 ^ 0x1B643DB5; i < n; ++i) {
            Class<? extends Annotation> clazz = classArray2[i];
            AnnotationNode annotationNode = Annotations.get(list, Type.getDescriptor(clazz));
            if (annotationNode == null) continue;
            arrayList.add(annotationNode);
        }
        int n2 = arrayList.size();
        if (n2 > (0x69CDB5E9 ^ 0x69CDB5E8)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e9\ua4bb\ua077\ua909\u7d7f\u8e49\u246e\u8b3e\u3479u\ua7a6\ua4b4\ua07f\ua90b\u7d79\u8e5e\u247b\u8b23\u347e}\ua7e8\ua4a6\ua031\ua903\u7d79\u8e5f\u2474\u8b33\u342d2") + Lists.transform(arrayList, (Function)new Function<AnnotationNode, String>(){

                public String apply(AnnotationNode annotationNode) {
                    return annotationNode.desc;
                }
            }));
        }
        return n2 == 0 ? null : (AnnotationNode)arrayList.get(0xBC263EA0 ^ 0xBC263EA0);
    }

    public static <T> T getValue(AnnotationNode annotationNode) {
        return Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("d\ua7e7\ua4b9\ua064\ua900"));
    }

    public static <T> T getValue(AnnotationNode annotationNode, String string, T t) {
        T t2 = Annotations.getValue(annotationNode, string);
        return t2 != null ? t2 : t;
    }

    public static <T> T getValue(AnnotationNode annotationNode, String string, Class<?> clazz) {
        Preconditions.checkNotNull(clazz, (Object)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("s\ua7e8\ua4bb\ua07e\ua911\u7d77\u8e5e\u2473\u8b38\u3479Q\ua7ea\ua4b4\ua062\ua916\u7d36\u8e49\u247b\u8b39\u3479}\ua7f2\ua4f5\ua073\ua900\u7d36\u8e44\u246f\u8b3b\u347b"));
        Object object = Annotations.getValue(annotationNode, string);
        if (object == null) {
            try {
                object = clazz.getDeclaredMethod(string, new Class[0x4FE31FA8 ^ 0x4FE31FA8]).getDefaultValue();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return object;
    }

    public static <T> T getValue(AnnotationNode annotationNode, String string) {
        int n = 0x2643417B ^ 0x2643417B;
        if (annotationNode == null || annotationNode.values == null) {
            return null;
        }
        for (Object object : annotationNode.values) {
            if (n != 0) {
                return (T)object;
            }
            if (!object.equals(string)) continue;
            n = 0xED49C7F1 ^ 0xED49C7F0;
        }
        return null;
    }

    public static <T extends Enum<T>> T getValue(AnnotationNode annotationNode, String string, Class<T> clazz, T t) {
        String[] stringArray = (String[])Annotations.getValue(annotationNode, string);
        if (stringArray == null) {
            return t;
        }
        return Annotations.toEnumValue(clazz, stringArray);
    }

    public static <T> List<T> getValue(AnnotationNode annotationNode, String string, boolean bl) {
        T t = Annotations.getValue(annotationNode, string);
        if (t instanceof List) {
            return (List)t;
        }
        if (t != null) {
            ArrayList<T> arrayList = new ArrayList<T>();
            arrayList.add(t);
            return arrayList;
        }
        return Collections.emptyList();
    }

    public static <T extends Enum<T>> List<T> getValue(AnnotationNode annotationNode, String string, boolean bl, Class<T> clazz) {
        T t = Annotations.getValue(annotationNode, string);
        if (t instanceof List) {
            ListIterator<T> listIterator = ((List)t).listIterator();
            while (listIterator.hasNext()) {
                listIterator.set(Annotations.toEnumValue(clazz, (String[])listIterator.next()));
            }
            return (List)t;
        }
        if (t instanceof String[]) {
            ArrayList<T> arrayList = new ArrayList<T>();
            arrayList.add(Annotations.toEnumValue(clazz, (String[])t));
            return arrayList;
        }
        return Collections.emptyList();
    }

    private static <T extends Enum<T>> T toEnumValue(Class<T> clazz, String[] stringArray) {
        if (!clazz.getName().equals(Type.getType(stringArray[0xF8A967A1 ^ 0xF8A967A1]).getClassName())) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F\ua7ee\ua4b0\ua031\ua916\u7d63\u8e5a\u246a\u8b3b\u347ew\ua7e2\ua4f5\ua074\ua90b\u7d63\u8e47\u243a\u8b34\u347bs\ua7f5\ua4a6\ua031\ua901\u7d79\u8e4f\u2469\u8b77\u3479}\ua7f2\ua4f5\ua07c\ua904\u7d62\u8e49\u2472\u8b77\u3463z\ua7e3\ua4f5\ua062\ua911\u7d79\u8e58\u247f\u8b33\u3437w\ua7e8\ua4a0\ua07c\ua945\u7d60\u8e4b\u2476\u8b22\u3472"));
        }
        return Enum.valueOf(clazz, stringArray[0xDA8F7678 ^ 0xDA8F7679]);
    }
}

