/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import com.google.common.base.Joiner;
import com.google.common.primitives.Ints;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassWriter;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Opcodes;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.FrameNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.IntInsnNode;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.LineNumberNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.lib.util.CheckClassAdapter;
import org.spongepowered.asm.lib.util.TraceClassVisitor;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.util.Constants;
import org.spongepowered.asm.util.throwables.SyntheticBridgeException;

public final class Bytecode {
    public static final int[] CONSTANTS_INT;
    public static final int[] CONSTANTS_FLOAT;
    public static final int[] CONSTANTS_DOUBLE;
    public static final int[] CONSTANTS_LONG;
    public static final int[] CONSTANTS_ALL;
    private static final Object[] CONSTANTS_VALUES;
    private static final String[] CONSTANTS_TYPES;
    private static final String[] BOXING_TYPES;
    private static final String[] UNBOXING_METHODS;
    private static final Class<?>[] MERGEABLE_MIXIN_ANNOTATIONS;
    private static Pattern mergeableAnnotationPattern;
    private static final Logger logger;

    private Bytecode() {
    }

    public static MethodNode findMethod(ClassNode classNode, String string, String string2) {
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(string) || !methodNode.desc.equals(string2)) continue;
            return methodNode;
        }
        return null;
    }

    public static AbstractInsnNode findInsn(MethodNode methodNode, int n) {
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (abstractInsnNode.getOpcode() != n) continue;
            return abstractInsnNode;
        }
        return null;
    }

    public static MethodInsnNode findSuperInit(MethodNode methodNode, String string) {
        if (!\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode.name)) {
            return null;
        }
        int n = 0xC43EF5B8 ^ 0xC43EF5B8;
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (abstractInsnNode instanceof TypeInsnNode) {
                if (abstractInsnNode.getOpcode() == (0x1C123ABC ^ 0x1C123A07)) {
                    ++n;
                    continue;
                }
            }
            if (!(abstractInsnNode instanceof MethodInsnNode)) continue;
            if (abstractInsnNode.getOpcode() != (0xC523F9ED ^ 0xC523F95A)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            if (!\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodInsnNode.name)) continue;
            if (n > 0) {
                --n;
                continue;
            }
            if (!methodInsnNode.owner.equals(string)) continue;
            return methodInsnNode;
        }
        return null;
    }

    public static void textify(ClassNode classNode, OutputStream outputStream) {
        classNode.accept(new TraceClassVisitor(new PrintWriter(outputStream)));
    }

    public static void textify(MethodNode methodNode, OutputStream outputStream) {
        TraceClassVisitor traceClassVisitor = new TraceClassVisitor(new PrintWriter(outputStream));
        MethodVisitor methodVisitor = traceClassVisitor.visitMethod(methodNode.access, methodNode.name, methodNode.desc, methodNode.signature, methodNode.exceptions.toArray(new String[0x60DE7CB7 ^ 0x60DE7CB7]));
        methodNode.accept(methodVisitor);
        traceClassVisitor.visitEnd();
    }

    public static void dumpClass(ClassNode classNode) {
        ClassWriter classWriter = new ClassWriter(0x77AD4073 ^ 0x77AD4070);
        classNode.accept(classWriter);
        Bytecode.dumpClass(classWriter.toByteArray());
    }

    public static void dumpClass(byte[] byArray) {
        ClassReader classReader = new ClassReader(byArray);
        CheckClassAdapter.verify(classReader, (0x9D664165 ^ 0x9D664164) != 0, new PrintWriter(System.out));
    }

    public static void printMethodWithOpcodeIndices(MethodNode methodNode) {
        Object[] objectArray = new Object[0xC845E581 ^ 0xC845E583];
        objectArray[0x49C21F1A ^ 0x49C21F1A] = methodNode.name;
        objectArray[0xA8965A2E ^ 0xA8965A2F] = methodNode.desc;
        System.err.printf(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f0\ua062\ua96f"), objectArray);
        int n = 0xB69B2F1 ^ 0xB69B2F1;
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            Object[] objectArray2 = new Object[0xDB4A49E7 ^ 0xDB4A49E5];
            objectArray2[0x94EBB319 ^ 0x94EBB319] = n++;
            objectArray2[0x7227323E ^ 0x7227323F] = Bytecode.describeNode((AbstractInsnNode)listIterator.next());
            System.err.printf(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("I\ua7a3\ua4e1\ua075\ua938\u7d36\u8e0f\u2469\u8b5d"), objectArray2);
        }
    }

    public static void printMethod(MethodNode methodNode) {
        Object[] objectArray = new Object[0x21A622DD ^ 0x21A622DF];
        objectArray[0x58A56E4D ^ 0x58A56E4D] = methodNode.name;
        objectArray[0x75AD34E1 ^ 0x75AD34E0] = methodNode.desc;
        System.err.printf(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f0\ua062\ua96f"), objectArray);
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            System.err.print(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7a6"));
            Bytecode.printNode((AbstractInsnNode)listIterator.next());
        }
    }

    public static void printNode(AbstractInsnNode abstractInsnNode) {
        Object[] objectArray = new Object[0xCD92C432 ^ 0xCD92C433];
        objectArray[0xD0F259DB ^ 0xD0F259DB] = Bytecode.describeNode(abstractInsnNode);
        System.err.printf(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4df"), objectArray);
    }

    public static String describeNode(AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            Object[] objectArray = new Object[0xB13F07E4 ^ 0xB13F07E5];
            objectArray[0x71CD7F2C ^ 0x71CD7F2C] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("|\ua7f3\ua4b9\ua07d");
            return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7a6\ua4f5\ua034\ua948\u7d27\u8e1e\u2469\u8b77"), objectArray);
        }
        if (abstractInsnNode instanceof LabelNode) {
            Object[] objectArray = new Object[0x899033C3 ^ 0x899033C2];
            objectArray[0x2A4305C1 ^ 0x2A4305C1] = ((LabelNode)abstractInsnNode).getLabel();
            return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("I\ua7a3\ua4a6\ua04c"), objectArray);
        }
        Object[] objectArray = new Object[0xDB6E00F3 ^ 0xDB6E00F2];
        objectArray[0xA12D7C52 ^ 0xA12D7C52] = abstractInsnNode.getClass().getSimpleName().replace(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\\\ua7e9\ua4b1\ua074"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(""));
        String string = String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7a6\ua4f5\ua034\ua948\u7d27\u8e1e\u2469\u8b77"), objectArray);
        if (abstractInsnNode instanceof JumpInsnNode) {
            Object[] objectArray2 = new Object[0x5EAFFF8 ^ 0x5EAFFFA];
            objectArray2[0xCAC00FAB ^ 0xCAC00FAB] = Bytecode.getOpcodeName(abstractInsnNode);
            objectArray2[0x29FC4192 ^ 0x29FC4193] = ((JumpInsnNode)abstractInsnNode).label.getLabel();
            string = string + String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("I\ua7a3\ua4a6\ua04c\ua945\u7d4d\u8e0f\u2469\u8b0a"), objectArray2);
        } else if (abstractInsnNode instanceof VarInsnNode) {
            Object[] objectArray3 = new Object[0xAFB9148B ^ 0xAFB91489];
            objectArray3[0x4DFE5453 ^ 0x4DFE5453] = Bytecode.getOpcodeName(abstractInsnNode);
            objectArray3[0xA6158BC0 ^ 0xA6158BC1] = ((VarInsnNode)abstractInsnNode).var;
            string = string + String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("I\ua7a3\ua4a6\ua04c\ua945\u7d33\u8e4e"), objectArray3);
        } else if (abstractInsnNode instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            Object[] objectArray4 = new Object[0x20663BD1 ^ 0x20663BD5];
            objectArray4[0xBD733F3C ^ 0xBD733F3C] = Bytecode.getOpcodeName(abstractInsnNode);
            objectArray4[0x2FA7ACE1 ^ 0x2FA7ACE0] = methodInsnNode.owner;
            objectArray4[0xAE24AC2E ^ 0xAE24AC2C] = methodInsnNode.name;
            objectArray4[0x3FD3ECB7 ^ 0x3FD3ECB4] = methodInsnNode.desc;
            string = string + String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("I\ua7a3\ua4a6\ua04c\ua945\u7d33\u8e59\u243a\u8b72\u34642\ua7a3\ua4a6"), objectArray4);
        } else if (abstractInsnNode instanceof FieldInsnNode) {
            FieldInsnNode fieldInsnNode = (FieldInsnNode)abstractInsnNode;
            Object[] objectArray5 = new Object[0xBF5C6734 ^ 0xBF5C6730];
            objectArray5[0xAD0D6272 ^ 0xAD0D6272] = Bytecode.getOpcodeName(abstractInsnNode);
            objectArray5[0xBAD45725 ^ 0xBAD45724] = fieldInsnNode.owner;
            objectArray5[0x61D84783 ^ 0x61D84781] = fieldInsnNode.name;
            objectArray5[0x79447AB1 ^ 0x79447AB2] = fieldInsnNode.desc;
            string = string + String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("I\ua7a3\ua4a6\ua04c\ua945\u7d33\u8e59\u243a\u8b72\u34642\ua7a3\ua4a6"), objectArray5);
        } else if (abstractInsnNode instanceof LineNumberNode) {
            LineNumberNode lineNumberNode = (LineNumberNode)abstractInsnNode;
            Object[] objectArray6 = new Object[0x17C9DBDF ^ 0x17C9DBDD];
            objectArray6[0xBEADE722 ^ 0xBEADE722] = lineNumberNode.line;
            objectArray6[0x42F7984B ^ 0x42F7984A] = lineNumberNode.start.getLabel();
            string = string + String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^\ua7cf\ua49b\ua054\ua958\u7d4d\u8e0f\u247e\u8b0a\u3437^\ua7c7\ua497\ua054\ua929\u7d2b\u8e71\u243f\u8b24\u344a"), objectArray6);
        } else if (abstractInsnNode instanceof LdcInsnNode) {
            string = string + ((LdcInsnNode)abstractInsnNode).cst;
        } else if (abstractInsnNode instanceof IntInsnNode) {
            string = string + ((IntInsnNode)abstractInsnNode).operand;
        } else if (abstractInsnNode instanceof FrameNode) {
            Object[] objectArray7 = new Object[0x6BF01A64 ^ 0x6BF01A65];
            objectArray7[0xF6FB3112 ^ 0xF6FB3112] = Bytecode.getOpcodeName(((FrameNode)abstractInsnNode).type, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Z\ua7d9\ua49c\ua05f\ua933\u7d59\u8e61\u245f\u8b1e\u3459F\ua7c3\ua487\ua057\ua924\u7d55\u8e6f"), 0x2FC47801 ^ 0xD03B87FE);
            string = string + String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("I\ua7a3\ua4a6\ua04c\ua945"), objectArray7);
        } else {
            Object[] objectArray8 = new Object[0xE753D335 ^ 0xE753D334];
            objectArray8[0x920A2928 ^ 0x920A2928] = Bytecode.getOpcodeName(abstractInsnNode);
            string = string + String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("I\ua7a3\ua4a6\ua04c\ua945"), objectArray8);
        }
        return string;
    }

    public static String getOpcodeName(AbstractInsnNode abstractInsnNode) {
        return abstractInsnNode != null ? Bytecode.getOpcodeName(abstractInsnNode.getOpcode()) : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("");
    }

    public static String getOpcodeName(int n) {
        return Bytecode.getOpcodeName(n, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("G\ua7c8\ua49c\ua05f\ua92c\u7d42\u8e63\u245b\u8b1b\u345eH\ua7c3\ua491\ua04e\ua931\u7d5e\u8e63\u2449"), 0xF12048A6 ^ 0xF12048A7);
    }

    private static String getOpcodeName(int n, String string, int n2) {
        if (n >= n2) {
            int n3 = 0x88C157CE ^ 0x88C157CE;
            try {
                Field[] fieldArray = Opcodes.class.getDeclaredFields();
                int n4 = fieldArray.length;
                for (int i = 0x40C4CEAF ^ 0x40C4CEAF; i < n4; ++i) {
                    Field field = fieldArray[i];
                    if (n3 == 0 && !field.getName().equals(string)) continue;
                    n3 = 0x1F6362FE ^ 0x1F6362FF;
                    if (field.getType() != Integer.TYPE || field.getInt(null) != n) continue;
                    return field.getName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n >= 0 ? String.valueOf(n) : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("G\ua7c8\ua49e\ua05f\ua92a\u7d41\u8e64");
    }

    public static boolean methodHasLineNumbers(MethodNode methodNode) {
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            if (!(listIterator.next() instanceof LineNumberNode)) continue;
            return (0x8179E53D ^ 0x8179E53C) != 0;
        }
        return (0xB9A2B67B ^ 0xB9A2B67B) != 0;
    }

    public static boolean methodIsStatic(MethodNode methodNode) {
        return ((methodNode.access & (0xB5659299 ^ 0xB5659291)) == (0x99A8DEC5 ^ 0x99A8DECD) ? 0x628661E4 ^ 0x628661E5 : 0xA4845C12 ^ 0xA4845C12) != 0;
    }

    public static boolean fieldIsStatic(FieldNode fieldNode) {
        return ((fieldNode.access & (0xBB97545C ^ 0xBB975454)) == (0xE4A8155 ^ 0xE4A815D) ? 0x73E75737 ^ 0x73E75736 : 0xDB4F76C3 ^ 0xDB4F76C3) != 0;
    }

    public static int getFirstNonArgLocalIndex(MethodNode methodNode) {
        return Bytecode.getFirstNonArgLocalIndex(Type.getArgumentTypes(methodNode.desc), ((methodNode.access & (0xCE80F1BD ^ 0xCE80F1B5)) == 0 ? 0xE91DF4AF ^ 0xE91DF4AE : 0x15568EAE ^ 0x15568EAE) != 0);
    }

    public static int getFirstNonArgLocalIndex(Type[] typeArray, boolean bl) {
        return Bytecode.getArgsSize(typeArray) + (bl ? 0x99A564AA ^ 0x99A564AB : 0xD514683A ^ 0xD514683A);
    }

    public static int getArgsSize(Type[] typeArray) {
        int n = 0x41F22381 ^ 0x41F22381;
        Type[] typeArray2 = typeArray;
        int n2 = typeArray2.length;
        for (int i = 0x19B2998A ^ 0x19B2998A; i < n2; ++i) {
            Type type = typeArray2[i];
            n += type.getSize();
        }
        return n;
    }

    public static void loadArgs(Type[] typeArray, InsnList insnList, int n) {
        Bytecode.loadArgs(typeArray, insnList, n, 0xD0BA31E ^ 0xF2F45CE1);
    }

    public static void loadArgs(Type[] typeArray, InsnList insnList, int n, int n2) {
        Bytecode.loadArgs(typeArray, insnList, n, n2, null);
    }

    public static void loadArgs(Type[] typeArray, InsnList insnList, int n, int n2, Type[] typeArray2) {
        int n3 = n;
        int n4 = 0xB5A45316 ^ 0xB5A45316;
        Type[] typeArray3 = typeArray;
        int n5 = typeArray3.length;
        for (int i = 0xBC8A8724 ^ 0xBC8A8724; i < n5; ++i) {
            Type type = typeArray3[i];
            insnList.add(new VarInsnNode(type.getOpcode(0x3EF6DEB5 ^ 0x3EF6DEA0), n3));
            if (typeArray2 != null && n4 < typeArray2.length && typeArray2[n4] != null) {
                insnList.add(new TypeInsnNode(0x4835AA0D ^ 0x4835AACD, typeArray2[n4].getInternalName()));
            }
            if (n2 >= n && (n3 += type.getSize()) >= n2) {
                return;
            }
            ++n4;
        }
    }

    public static Map<LabelNode, LabelNode> cloneLabels(InsnList insnList) {
        HashMap<LabelNode, LabelNode> hashMap = new HashMap<LabelNode, LabelNode>();
        ListIterator<AbstractInsnNode> listIterator = insnList.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (!(abstractInsnNode instanceof LabelNode)) continue;
            hashMap.put((LabelNode)abstractInsnNode, new LabelNode(((LabelNode)abstractInsnNode).getLabel()));
        }
        return hashMap;
    }

    public static String generateDescriptor(Object object, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder().append((char)(0x2199012D ^ 0x21990105));
        Object[] objectArray2 = objectArray;
        int n = objectArray2.length;
        for (int i = 0x33BCCAA ^ 0x33BCCAA; i < n; ++i) {
            Object object2 = objectArray2[i];
            stringBuilder.append(Bytecode.toDescriptor(object2));
        }
        return stringBuilder.append((char)(0xA0F3F10D ^ 0xA0F3F124)).append(object != null ? Bytecode.toDescriptor(object) : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("D")).toString();
    }

    private static String toDescriptor(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Type) {
            return object.toString();
        }
        if (object instanceof Class) {
            return Type.getDescriptor((Class)object);
        }
        return object == null ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("") : object.toString();
    }

    public static String getDescriptor(Type[] typeArray) {
        return \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(":") + Joiner.on((String)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("")).join((Object[])typeArray) + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(";");
    }

    public static String getDescriptor(Type[] typeArray, Type type) {
        return Bytecode.getDescriptor(typeArray) + type.toString();
    }

    public static String changeDescriptorReturnType(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        return string.substring(0x75472D59 ^ 0x75472D59, string.lastIndexOf(0x7412AD0F ^ 0x7412AD26) + (0x19E5A318 ^ 0x19E5A319)) + string2;
    }

    public static String getSimpleName(Class<? extends Annotation> clazz) {
        return clazz.getSimpleName();
    }

    public static String getSimpleName(AnnotationNode annotationNode) {
        return Bytecode.getSimpleName(annotationNode.desc);
    }

    public static String getSimpleName(String string) {
        int n = Math.max(string.lastIndexOf(0xCB552089 ^ 0xCB5520A6), 0x6FDD303C ^ 0x6FDD303C);
        return string.substring(n + (0x617628C7 ^ 0x617628C6)).replace(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(")"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(""));
    }

    public static boolean isConstant(AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            return (0xB9E192BB ^ 0xB9E192BB) != 0;
        }
        return Ints.contains((int[])CONSTANTS_ALL, (int)abstractInsnNode.getOpcode());
    }

    public static Object getConstant(AbstractInsnNode abstractInsnNode) {
        block5: {
            block7: {
                int n;
                block6: {
                    if (abstractInsnNode == null) {
                        return null;
                    }
                    if (abstractInsnNode instanceof LdcInsnNode) {
                        return ((LdcInsnNode)abstractInsnNode).cst;
                    }
                    if (!(abstractInsnNode instanceof IntInsnNode)) break block5;
                    n = ((IntInsnNode)abstractInsnNode).operand;
                    if (abstractInsnNode.getOpcode() == (0xF83017B ^ 0xF83016B)) break block6;
                    if (abstractInsnNode.getOpcode() != (0xD1F5CB6A ^ 0xD1F5CB7B)) break block7;
                }
                return n;
            }
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a1\ua058\ua90b\u7d65\u8e44\u2454\u8b38\u3473w\ua7a6\ua4a2\ua078\ua911\u7d7e\u8e0a\u2473\u8b39\u3461s\ua7ea\ua4bc\ua075\ua945\u7d79\u8e5a\u2479\u8b38\u3473w\ua7a6") + abstractInsnNode.getOpcode() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ef\ua4bb\ua031\ua902\u7d73\u8e5e\u2459\u8b38\u3479a\ua7f2\ua4b4\ua07f\ua911"));
        }
        int n = Ints.indexOf((int[])CONSTANTS_ALL, (int)abstractInsnNode.getOpcode());
        return n < 0 ? null : CONSTANTS_VALUES[n];
    }

    public static Type getConstantType(AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            return null;
        }
        if (abstractInsnNode instanceof LdcInsnNode) {
            Object object = ((LdcInsnNode)abstractInsnNode).cst;
            if (object instanceof Integer) {
                return Type.getType(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("["));
            }
            if (object instanceof Float) {
                return Type.getType(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("T"));
            }
            if (object instanceof Long) {
                return Type.getType(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("X"));
            }
            if (object instanceof Double) {
                return Type.getType(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("V"));
            }
            if (object instanceof String) {
                return Type.getType(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^\ua7ec\ua4b4\ua067\ua904\u7d39\u8e46\u247b\u8b39\u3470=\ua7d5\ua4a1\ua063\ua90c\u7d78\u8e4d\u2421"));
            }
            if (object instanceof Type) {
                return Type.getType(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^\ua7ec\ua4b4\ua067\ua904\u7d39\u8e46\u247b\u8b39\u3470=\ua7c5\ua4b9\ua070\ua916\u7d65\u8e11"));
            }
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^\ua7e2\ua4b6\ua058\ua90b\u7d65\u8e44\u2454\u8b38\u3473w\ua7a6\ua4a2\ua078\ua911\u7d7e\u8e0a\u2473\u8b39\u3461s\ua7ea\ua4bc\ua075\ua945\u7d66\u8e4b\u2463\u8b3b\u3478s\ua7e2\ua4f5\ua065\ua91c\u7d66\u8e4f\u243a") + object.getClass() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ef\ua4bb\ua031\ua902\u7d73\u8e5e\u2459\u8b38\u3479a\ua7f2\ua4b4\ua07f\ua911"));
        }
        int n = Ints.indexOf((int[])CONSTANTS_ALL, (int)abstractInsnNode.getOpcode());
        return n < 0 ? null : Type.getType(CONSTANTS_TYPES[n]);
    }

    public static boolean hasFlag(ClassNode classNode, int n) {
        return ((classNode.access & n) == n ? 0xC4CB868B ^ 0xC4CB868A : 0x4A516835 ^ 0x4A516835) != 0;
    }

    public static boolean hasFlag(MethodNode methodNode, int n) {
        return ((methodNode.access & n) == n ? 0xE5775118 ^ 0xE5775119 : 0x47E5670C ^ 0x47E5670C) != 0;
    }

    public static boolean hasFlag(FieldNode fieldNode, int n) {
        return ((fieldNode.access & n) == n ? 0xBD1AFE08 ^ 0xBD1AFE09 : 0xC86DBD84 ^ 0xC86DBD84) != 0;
    }

    public static boolean compareFlags(MethodNode methodNode, MethodNode methodNode2, int n) {
        return (Bytecode.hasFlag(methodNode, n) == Bytecode.hasFlag(methodNode2, n) ? 0xD3486CE ^ 0xD3486CF : 0x6453977F ^ 0x6453977F) != 0;
    }

    public static boolean compareFlags(FieldNode fieldNode, FieldNode fieldNode2, int n) {
        return (Bytecode.hasFlag(fieldNode, n) == Bytecode.hasFlag(fieldNode2, n) ? 0x7992227B ^ 0x7992227A : 0x9BB582B6 ^ 0x9BB582B6) != 0;
    }

    public static Visibility getVisibility(MethodNode methodNode) {
        return Bytecode.getVisibility(methodNode.access & (0xA745529A ^ 0xA745529D));
    }

    public static Visibility getVisibility(FieldNode fieldNode) {
        return Bytecode.getVisibility(fieldNode.access & (0xAC2CC818 ^ 0xAC2CC81F));
    }

    private static Visibility getVisibility(int n) {
        if ((n & (0x6B0B187D ^ 0x6B0B1879)) != 0) {
            return Visibility.PROTECTED;
        }
        if ((n & (0x8B662AFF ^ 0x8B662AFD)) != 0) {
            return Visibility.PRIVATE;
        }
        if ((n & (0x931FFBB0 ^ 0x931FFBB1)) != 0) {
            return Visibility.PUBLIC;
        }
        return Visibility.PACKAGE;
    }

    public static void setVisibility(MethodNode methodNode, Visibility visibility) {
        methodNode.access = Bytecode.setVisibility(methodNode.access, visibility.access);
    }

    public static void setVisibility(FieldNode fieldNode, Visibility visibility) {
        fieldNode.access = Bytecode.setVisibility(fieldNode.access, visibility.access);
    }

    public static void setVisibility(MethodNode methodNode, int n) {
        methodNode.access = Bytecode.setVisibility(methodNode.access, n);
    }

    public static void setVisibility(FieldNode fieldNode, int n) {
        fieldNode.access = Bytecode.setVisibility(fieldNode.access, n);
    }

    private static int setVisibility(int n, int n2) {
        return n & (0x6DDB8DFE ^ 0x92247206) | n2 & (0x6BE433DC ^ 0x6BE433DB);
    }

    public static int getMaxLineNumber(ClassNode classNode, int n, int n2) {
        int n3 = 0xD120C329 ^ 0xD120C329;
        for (MethodNode methodNode : classNode.methods) {
            ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
            while (listIterator.hasNext()) {
                AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
                if (!(abstractInsnNode instanceof LineNumberNode)) continue;
                n3 = Math.max(n3, ((LineNumberNode)abstractInsnNode).line);
            }
        }
        return Math.max(n, n3 + n2);
    }

    public static String getBoxingType(Type type) {
        return type == null ? null : BOXING_TYPES[type.getSort()];
    }

    public static String getUnboxingMethod(Type type) {
        return type == null ? null : UNBOXING_METHODS[type.getSort()];
    }

    public static void mergeAnnotations(ClassNode classNode, ClassNode classNode2) {
        classNode2.visibleAnnotations = Bytecode.mergeAnnotations(classNode.visibleAnnotations, classNode2.visibleAnnotations, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("q\ua7ea\ua4b4\ua062\ua916"), classNode.name);
        classNode2.invisibleAnnotations = Bytecode.mergeAnnotations(classNode.invisibleAnnotations, classNode2.invisibleAnnotations, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("q\ua7ea\ua4b4\ua062\ua916"), classNode.name);
    }

    public static void mergeAnnotations(MethodNode methodNode, MethodNode methodNode2) {
        methodNode2.visibleAnnotations = Bytecode.mergeAnnotations(methodNode.visibleAnnotations, methodNode2.visibleAnnotations, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72"), methodNode.name);
        methodNode2.invisibleAnnotations = Bytecode.mergeAnnotations(methodNode.invisibleAnnotations, methodNode2.invisibleAnnotations, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72"), methodNode.name);
    }

    public static void mergeAnnotations(FieldNode fieldNode, FieldNode fieldNode2) {
        fieldNode2.visibleAnnotations = Bytecode.mergeAnnotations(fieldNode.visibleAnnotations, fieldNode2.visibleAnnotations, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("t\ua7ef\ua4b0\ua07d\ua901"), fieldNode.name);
        fieldNode2.invisibleAnnotations = Bytecode.mergeAnnotations(fieldNode.invisibleAnnotations, fieldNode2.invisibleAnnotations, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("t\ua7ef\ua4b0\ua07d\ua901"), fieldNode.name);
    }

    private static List<AnnotationNode> mergeAnnotations(List<AnnotationNode> list, List<AnnotationNode> list2, String string, String string2) {
        try {
            if (list == null) {
                return list2;
            }
            if (list2 == null) {
                list2 = new ArrayList<AnnotationNode>();
            }
            for (AnnotationNode annotationNode : list) {
                if (!Bytecode.isMergeableAnnotation(annotationNode)) continue;
                Iterator<AnnotationNode> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().desc.equals(annotationNode.desc)) continue;
                    iterator.remove();
                    break;
                }
                list2.add(annotationNode);
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[0xCCF7035D ^ 0xCCF7035F];
            objectArray[0x40C15003 ^ 0x40C15003] = string;
            objectArray[0xC3011786 ^ 0xC3011787] = string2;
            logger.warn(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("W\ua7fe\ua4b6\ua074\ua915\u7d62\u8e43\u2475\u8b39\u3437w\ua7e8\ua4b6\ua07e\ua910\u7d78\u8e5e\u247f\u8b25\u3472v\ua7a6\ua4a2\ua079\ua90c\u7d7a\u8e59\u246e\u8b77\u347aw\ua7f4\ua4b2\ua078\ua90b\u7d71\u8e0a\u247b\u8b39\u3479}\ua7f2\ua4b4\ua065\ua90c\u7d79\u8e44\u2469\u8b77\u3471}\ua7f4\ua4f5\ua06a\ua918\u7d36\u8e51\u2467"), objectArray);
        }
        return list2;
    }

    private static boolean isMergeableAnnotation(AnnotationNode annotationNode) {
        if (annotationNode.desc.startsWith(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^") + Constants.MIXIN_PACKAGE_REF)) {
            return mergeableAnnotationPattern.matcher(annotationNode.desc).matches();
        }
        return (0x66663A45 ^ 0x66663A44) != 0;
    }

    private static Pattern getMergeableAnnotationPattern() {
        StringBuilder stringBuilder = new StringBuilder(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("L\ua7ca\ua4fd"));
        for (int i = 0x55F79B2D ^ 0x55F79B2D; i < MERGEABLE_MIXIN_ANNOTATIONS.length; ++i) {
            if (i > 0) {
                stringBuilder.append((char)(0x7CAAA704 ^ 0x7CAAA778));
            }
            stringBuilder.append(MERGEABLE_MIXIN_ANNOTATIONS[i].getName().replace((char)(0x5EAD6FFF ^ 0x5EAD6FD1), (char)(0x8214BFB7 ^ 0x8214BF98)));
        }
        return Pattern.compile(stringBuilder.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(";\ua7bd\ua4f1")).toString());
    }

    public static void compareBridgeMethods(MethodNode methodNode, MethodNode methodNode2) {
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        ListIterator<AbstractInsnNode> listIterator2 = methodNode2.instructions.iterator();
        int n = 0x427C0726 ^ 0x427C0726;
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            AbstractInsnNode abstractInsnNode = listIterator.next();
            AbstractInsnNode abstractInsnNode2 = listIterator2.next();
            if (!(abstractInsnNode instanceof LabelNode)) {
                AbstractInsnNode abstractInsnNode3;
                AbstractInsnNode abstractInsnNode4;
                if (abstractInsnNode instanceof MethodInsnNode) {
                    abstractInsnNode4 = (MethodInsnNode)abstractInsnNode;
                    abstractInsnNode3 = (MethodInsnNode)abstractInsnNode2;
                    if (!((MethodInsnNode)abstractInsnNode4).name.equals(abstractInsnNode3.name)) {
                        throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_INVOKE_NAME, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                    }
                    if (!((MethodInsnNode)abstractInsnNode4).desc.equals(abstractInsnNode3.desc)) {
                        throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_INVOKE_DESC, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                    }
                } else {
                    if (abstractInsnNode.getOpcode() != abstractInsnNode2.getOpcode()) {
                        throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_INSN, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                    }
                    if (abstractInsnNode instanceof VarInsnNode) {
                        abstractInsnNode4 = (VarInsnNode)abstractInsnNode;
                        abstractInsnNode3 = (VarInsnNode)abstractInsnNode2;
                        if (((VarInsnNode)abstractInsnNode4).var != ((VarInsnNode)abstractInsnNode3).var) {
                            throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_LOAD, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                        }
                    } else if (abstractInsnNode instanceof TypeInsnNode) {
                        abstractInsnNode4 = (TypeInsnNode)abstractInsnNode;
                        abstractInsnNode3 = (TypeInsnNode)abstractInsnNode2;
                        if (abstractInsnNode4.getOpcode() == (0xAD9E52A1 ^ 0xAD9E5261) && !((TypeInsnNode)abstractInsnNode4).desc.equals(((TypeInsnNode)abstractInsnNode3).desc)) {
                            throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_CAST, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                        }
                    }
                }
            }
            ++n;
        }
        if (listIterator.hasNext() || listIterator2.hasNext()) {
            throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_LENGTH, methodNode.name, methodNode.desc, n, null, null);
        }
    }

    static {
        int[] nArray = new int[0x5CBA2A37 ^ 0x5CBA2A30];
        nArray[0x7E75A31D ^ 0x7E75A31D] = 0x5A72610B ^ 0x5A726109;
        nArray[0x23A3D047 ^ 0x23A3D046] = 0x3DB2B92 ^ 0x3DB2B91;
        nArray[0x7B1221C5 ^ 0x7B1221C7] = 0x45B70ED4 ^ 0x45B70ED0;
        nArray[0x2134EFE8 ^ 0x2134EFEB] = 0x71D1F376 ^ 0x71D1F373;
        nArray[0x2DE4315F ^ 0x2DE4315B] = 0xBFB80972 ^ 0xBFB80974;
        nArray[0x9CBC4903 ^ 0x9CBC4906] = 0x2961A45B ^ 0x2961A45C;
        nArray[0xF2D81FA8 ^ 0xF2D81FAE] = 0xC34FE54C ^ 0xC34FE544;
        CONSTANTS_INT = nArray;
        int[] nArray2 = new int[0xB267C6D ^ 0xB267C6E];
        nArray2[0xDA915C88 ^ 0xDA915C88] = 0x90AFE311 ^ 0x90AFE31A;
        nArray2[0x28D7CE23 ^ 0x28D7CE22] = 0xE9A786E9 ^ 0xE9A786E5;
        nArray2[0x99DB9241 ^ 0x99DB9243] = 0x7C261116 ^ 0x7C26111B;
        CONSTANTS_FLOAT = nArray2;
        int[] nArray3 = new int[0xB07FAEB ^ 0xB07FAE9];
        nArray3[0xCEC96CA7 ^ 0xCEC96CA7] = 0xFBC1A8C ^ 0xFBC1A82;
        nArray3[0x4B2916A1 ^ 0x4B2916A0] = 0x427571F7 ^ 0x427571F8;
        CONSTANTS_DOUBLE = nArray3;
        int[] nArray4 = new int[0xF77F98D5 ^ 0xF77F98D7];
        nArray4[0xDDE559AD ^ 0xDDE559AD] = 0xDAC0874D ^ 0xDAC08744;
        nArray4[0x89502CF6 ^ 0x89502CF7] = 0xF5EAAD0A ^ 0xF5EAAD00;
        CONSTANTS_LONG = nArray4;
        int[] nArray5 = new int[0x8F1BB650 ^ 0x8F1BB642];
        nArray5[0x1B5E070E ^ 0x1B5E070E] = 0x244F8597 ^ 0x244F8596;
        nArray5[0x85D33B35 ^ 0x85D33B34] = 0x53A31153 ^ 0x53A31151;
        nArray5[0x7DE1525 ^ 0x7DE1527] = 0xE0F9AEAE ^ 0xE0F9AEAD;
        nArray5[0x946F5661 ^ 0x946F5662] = 0x87D5A54 ^ 0x87D5A50;
        nArray5[0xF9E22776 ^ 0xF9E22772] = 0x87D1AFD7 ^ 0x87D1AFD2;
        nArray5[0xC4CF520D ^ 0xC4CF5208] = 0xAF40DD67 ^ 0xAF40DD61;
        nArray5[0x55BE8FF7 ^ 0x55BE8FF1] = 0x8D0B1A1F ^ 0x8D0B1A18;
        nArray5[0x421460FF ^ 0x421460F8] = 0x51DC0726 ^ 0x51DC072E;
        nArray5[0xAE06742A ^ 0xAE067422] = 0x840A6932 ^ 0x840A693B;
        nArray5[0x5BBCD85A ^ 0x5BBCD853] = 0x8DD4A81D ^ 0x8DD4A817;
        nArray5[0x7A18E9A ^ 0x7A18E90] = 0x8B2C8B2C ^ 0x8B2C8B27;
        nArray5[0x1DB304E9 ^ 0x1DB304E2] = 0x80A5D1D0 ^ 0x80A5D1DC;
        nArray5[0x3605A6D3 ^ 0x3605A6DF] = 0xF8B38FCD ^ 0xF8B38FC0;
        nArray5[0x7AD3BADA ^ 0x7AD3BAD7] = 0xC593D74B ^ 0xC593D745;
        nArray5[0x7BA331DC ^ 0x7BA331D2] = 0x2813F3A3 ^ 0x2813F3AC;
        nArray5[0x3D63B138 ^ 0x3D63B137] = 0x49EF40BA ^ 0x49EF40AA;
        nArray5[0xFED0F62 ^ 0xFED0F72] = 0xA681C0E7 ^ 0xA681C0F6;
        nArray5[0xB9A8D5B0 ^ 0xB9A8D5A1] = 0x11B51302 ^ 0x11B51310;
        CONSTANTS_ALL = nArray5;
        Object[] objectArray = new Object[0x22F2BAAB ^ 0x22F2BAA4];
        objectArray[0x8A67105C ^ 0x8A67105C] = null;
        objectArray[0x94BECB4B ^ 0x94BECB4A] = 0xF6C2BC7A ^ 0x93D4385;
        objectArray[0x66B73151 ^ 0x66B73153] = 0x3FF998E4 ^ 0x3FF998E4;
        objectArray[0xC463B391 ^ 0xC463B392] = 0x8970AB5F ^ 0x8970AB5E;
        objectArray[0xD574906A ^ 0xD574906E] = 0x4270937B ^ 0x42709379;
        objectArray[0x432753A2 ^ 0x432753A7] = 0xD596084F ^ 0xD596084C;
        objectArray[0x64DE3E18 ^ 0x64DE3E1E] = 0x8112B9E7 ^ 0x8112B9E3;
        objectArray[0xD684B7C5 ^ 0xD684B7C2] = 0x81382668 ^ 0x8138266D;
        objectArray[0xA58EE8D2 ^ 0xA58EE8DA] = 0x3C73A43F5469C2C5L ^ 0x3C73A43F5469C2C5L;
        objectArray[0xE89E9023 ^ 0xE89E902A] = 0x44E8F87593803A7DL ^ 0x44E8F87593803A7CL;
        objectArray[0x6FFFDFC ^ 0x6FFFDF6] = Float.valueOf(0.0f);
        objectArray[0xA414457C ^ 0xA4144577] = Float.valueOf(1.0f);
        objectArray[0x8BD03F91 ^ 0x8BD03F9D] = Float.valueOf(2.0f);
        objectArray[0x183C7F8E ^ 0x183C7F83] = 0.0;
        objectArray[0xB24D3C94 ^ 0xB24D3C9A] = 1.0;
        CONSTANTS_VALUES = objectArray;
        String[] stringArray = new String[0x637CA72D ^ 0x637CA73C];
        stringArray[0x30A984D9 ^ 0x30A984D9] = null;
        stringArray[0xA26A9C29 ^ 0xA26A9C28] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[");
        stringArray[0xC0F7A8EE ^ 0xC0F7A8EC] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[");
        stringArray[0x68CF6EFD ^ 0x68CF6EFE] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[");
        stringArray[0x8C8EE150 ^ 0x8C8EE154] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[");
        stringArray[0xFEED63B ^ 0xFEED63E] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[");
        stringArray[0xF34EF974 ^ 0xF34EF972] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[");
        stringArray[0x49C3410 ^ 0x49C3417] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[");
        stringArray[0xF48F9064 ^ 0xF48F906C] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("X");
        stringArray[0x6F013358 ^ 0x6F013351] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("X");
        stringArray[0x3DAB055F ^ 0x3DAB0555] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("T");
        stringArray[0x8AA5FB2B ^ 0x8AA5FB20] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("T");
        stringArray[0xA90427FB ^ 0xA90427F7] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("T");
        stringArray[0xE4E62916 ^ 0xE4E6291B] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("V");
        stringArray[0xCBE5D879 ^ 0xCBE5D877] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("V");
        stringArray[0x42C056C2 ^ 0x42C056CD] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[");
        stringArray[0x1BA515C7 ^ 0x1BA515D7] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[");
        CONSTANTS_TYPES = stringArray;
        String[] stringArray2 = new String[0xA1A03E50 ^ 0xA1A03E5C];
        stringArray2[0x1296B125 ^ 0x1296B125] = null;
        stringArray2[0x8B613BCA ^ 0x8B613BCB] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438P\ua7e9\ua4ba\ua07d\ua900\u7d77\u8e44");
        stringArray2[0xF8019001 ^ 0xF8019003] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438Q\ua7ee\ua4b4\ua063\ua904\u7d75\u8e5e\u247f\u8b25");
        stringArray2[0x4F772952 ^ 0x4F772951] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438P\ua7ff\ua4a1\ua074");
        stringArray2[0x7D1132CC ^ 0x7D1132C8] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438A\ua7ee\ua4ba\ua063\ua911");
        stringArray2[0xC6749F30 ^ 0xC6749F35] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438[\ua7e8\ua4a1\ua074\ua902\u7d73\u8e58");
        stringArray2[0xEF7091AE ^ 0xEF7091A8] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438T\ua7ea\ua4ba\ua070\ua911");
        stringArray2[0xBF748765 ^ 0xBF748762] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438^\ua7e9\ua4bb\ua076");
        stringArray2[0xC8FE8900 ^ 0xC8FE8908] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438V\ua7e9\ua4a0\ua073\ua909\u7d73");
        stringArray2[0x82961464 ^ 0x8296146D] = null;
        stringArray2[0xF217DD06 ^ 0xF217DD0C] = null;
        stringArray2[0x6733F0F5 ^ 0x6733F0FE] = null;
        BOXING_TYPES = stringArray2;
        String[] stringArray3 = new String[0x6247B0EC ^ 0x6247B0E0];
        stringArray3[0xB51985FD ^ 0xB51985FD] = null;
        stringArray3[0xB319AF4E ^ 0xB319AF4F] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("p\ua7e9\ua4ba\ua07d\ua900\u7d77\u8e44\u244c\u8b36\u347bg\ua7e3");
        stringArray3[0xA552AE52 ^ 0xA552AE50] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("q\ua7ee\ua4b4\ua063\ua933\u7d77\u8e46\u246f\u8b32");
        stringArray3[0xEB9E7777 ^ 0xEB9E7774] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("p\ua7ff\ua4a1\ua074\ua933\u7d77\u8e46\u246f\u8b32");
        stringArray3[0xBEC20B72 ^ 0xBEC20B76] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a\ua7ee\ua4ba\ua063\ua911\u7d40\u8e4b\u2476\u8b22\u3472");
        stringArray3[0x905A1011 ^ 0x905A1014] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("{\ua7e8\ua4a1\ua047\ua904\u7d7a\u8e5f\u247f");
        stringArray3[0xFB99ABDA ^ 0xFB99ABDC] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("t\ua7ea\ua4ba\ua070\ua911\u7d40\u8e4b\u2476\u8b22\u3472");
        stringArray3[0xC936D85E ^ 0xC936D859] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("~\ua7e9\ua4bb\ua076\ua933\u7d77\u8e46\u246f\u8b32");
        stringArray3[0x138BAA15 ^ 0x138BAA1D] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("v\ua7e9\ua4a0\ua073\ua909\u7d73\u8e7c\u247b\u8b3b\u3462w");
        stringArray3[0x91DFA7BE ^ 0x91DFA7B7] = null;
        stringArray3[0x5D3A3096 ^ 0x5D3A309C] = null;
        stringArray3[0x4AC452C4 ^ 0x4AC452CF] = null;
        UNBOXING_METHODS = stringArray3;
        Class[] classArray = new Class[0x48991C2C ^ 0x48991C28];
        classArray[0x1BA311CE ^ 0x1BA311CE] = Overwrite.class;
        classArray[0x60EF4F96 ^ 0x60EF4F97] = Intrinsic.class;
        classArray[0x7E03E320 ^ 0x7E03E322] = Final.class;
        classArray[0xD1BF8F92 ^ 0xD1BF8F91] = Debug.class;
        MERGEABLE_MIXIN_ANNOTATIONS = classArray;
        mergeableAnnotationPattern = Bytecode.getMergeableAnnotationPattern();
        logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    }

    public static final class Visibility
    extends Enum<Visibility> {
        public static final /* enum */ Visibility PRIVATE = new Visibility(0x2EFC699 ^ 0x2EFC69B);
        public static final /* enum */ Visibility PROTECTED = new Visibility(0xCBE9D90A ^ 0xCBE9D90E);
        public static final /* enum */ Visibility PACKAGE = new Visibility(0x4D14B704 ^ 0x4D14B704);
        public static final /* enum */ Visibility PUBLIC = new Visibility(0x576626D7 ^ 0x576626D6);
        static final int MASK = 7;
        final int access;
        private static final /* synthetic */ Visibility[] $VALUES;

        public static Visibility[] values() {
            return (Visibility[])$VALUES.clone();
        }

        public static Visibility valueOf(String string) {
            return Enum.valueOf(Visibility.class, string);
        }

        private Visibility(int n2) {
            this.access = n2;
        }

        static {
            Visibility[] visibilityArray = new Visibility[0x83527310 ^ 0x83527314];
            visibilityArray[0xCD631CBD ^ 0xCD631CBD] = PRIVATE;
            visibilityArray[0xCF902034 ^ 0xCF902035] = PROTECTED;
            visibilityArray[0xA40034AF ^ 0xA40034AD] = PACKAGE;
            visibilityArray[0x59E3320C ^ 0x59E3320F] = PUBLIC;
            $VALUES = visibilityArray;
        }
    }
}

