/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.spongepowered.asm.lib.signature.SignatureReader;
import org.spongepowered.asm.lib.signature.SignatureVisitor;
import org.spongepowered.asm.lib.signature.SignatureWriter;
import org.spongepowered.asm.lib.tree.ClassNode;

public class ClassSignature {
    protected static final String OBJECT = "java/lang/Object";
    private final Map<TypeVar, TokenHandle> types = new LinkedHashMap<TypeVar, TokenHandle>();
    private Token superClass = new Token(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62"));
    private final List<Token> interfaces = new ArrayList<Token>();
    private final Deque<String> rawInterfaces = new LinkedList<String>();

    ClassSignature() {
    }

    private ClassSignature read(String string) {
        if (string != null) {
            try {
                new SignatureReader(string).accept(new SignatureParser());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this;
    }

    protected TypeVar getTypeVar(String string) {
        for (TypeVar typeVar : this.types.keySet()) {
            if (!typeVar.matches(string)) continue;
            return typeVar;
        }
        return null;
    }

    protected TokenHandle getType(String string) {
        for (TypeVar typeVar : this.types.keySet()) {
            if (!typeVar.matches(string)) continue;
            return this.types.get(typeVar);
        }
        TokenHandle tokenHandle = new TokenHandle();
        this.types.put(new TypeVar(string), tokenHandle);
        return tokenHandle;
    }

    protected String getTypeVar(TokenHandle tokenHandle) {
        for (Map.Entry<TypeVar, TokenHandle> entry : this.types.entrySet()) {
            TypeVar typeVar = entry.getKey();
            TokenHandle tokenHandle2 = entry.getValue();
            if (tokenHandle != tokenHandle2 && tokenHandle.asToken() != tokenHandle2.asToken()) continue;
            return \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F") + typeVar + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(")");
        }
        return tokenHandle.token.asType();
    }

    protected void addTypeVar(TypeVar typeVar, TokenHandle tokenHandle) throws IllegalArgumentException {
        if (this.types.containsKey(typeVar)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F\ua7ff\ua4a5\ua074\ua933\u7d77\u8e58\u243a") + typeVar + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ef\ua4a6\ua031\ua904\u7d7a\u8e58\u247f\u8b36\u3473k\ua7a6\ua4a5\ua063\ua900\u7d65\u8e4f\u2474\u8b23\u3437}\ua7e8\ua4f5") + this);
        }
        this.types.put(typeVar, tokenHandle);
    }

    protected void setSuperClass(Token token) {
        this.superClass = token;
    }

    public String getSuperClass() {
        return this.superClass.asType((0x9A7C6B17 ^ 0x9A7C6B16) != 0);
    }

    protected void addInterface(Token token) {
        if (!token.isRaw()) {
            String string = token.asType((0xBD381483 ^ 0xBD381482) != 0);
            ListIterator<Token> listIterator = this.interfaces.listIterator();
            while (listIterator.hasNext()) {
                Token token2 = listIterator.next();
                if (!token2.isRaw()) continue;
                if (!token2.asType((0xCEEC92 ^ 0xCEEC93) != 0).equals(string)) continue;
                listIterator.set(token);
                return;
            }
        }
        this.interfaces.add(token);
    }

    public void addInterface(String string) {
        this.rawInterfaces.add(string);
    }

    protected void addRawInterface(String string) {
        Token token = new Token(string);
        String string2 = token.asType((0xEAEB56EB ^ 0xEAEB56EA) != 0);
        for (Token token2 : this.interfaces) {
            if (!token2.asType((0xFE15E0C0 ^ 0xFE15E0C1) != 0).equals(string2)) continue;
            return;
        }
        this.interfaces.add(token);
    }

    public void merge(ClassSignature classSignature) {
        try {
            Iterator<Token> iterator = new HashSet<String>();
            for (TypeVar typeVar : this.types.keySet()) {
                iterator.add((Token)((Object)typeVar.toString()));
            }
            classSignature.conform((Set<String>)((Object)iterator));
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            return;
        }
        for (Map.Entry entry : classSignature.types.entrySet()) {
            this.addTypeVar((TypeVar)entry.getKey(), (TokenHandle)entry.getValue());
        }
        for (Token token : classSignature.interfaces) {
            this.addInterface(token);
        }
    }

    private void conform(Set<String> set) {
        for (TypeVar typeVar : this.types.keySet()) {
            String string = this.findUniqueName(typeVar.getOriginalName(), set);
            typeVar.rename(string);
            set.add(string);
        }
    }

    private String findUniqueName(String string, Set<String> set) {
        String string2;
        if (!set.contains(string)) {
            return string;
        }
        if (string.length() == (0xC0C2E91C ^ 0xC0C2E91D)) {
            string2 = this.findOffsetName(string.charAt(0x13463BCF ^ 0x13463BCF), set);
            if (string2 != null) {
                return string2;
            }
        }
        if ((string2 = this.findOffsetName((char)(0xD289ABA2 ^ 0xD289ABF6), set, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(""), string)) != null) {
            return string2;
        }
        string2 = this.findOffsetName((char)(0x2EF45187 ^ 0x2EF451D3), set, string, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(""));
        if (string2 != null) {
            return string2;
        }
        string2 = this.findOffsetName((char)(0x8201FA26 ^ 0x8201FA72), set, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F"), string);
        if (string2 != null) {
            return string2;
        }
        string2 = this.findOffsetName((char)(0xE7883ACD ^ 0xE7883A99), set, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(""), string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F\ua7ff\ua4a5\ua074"));
        if (string2 != null) {
            return string2;
        }
        throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("T\ua7e7\ua4bc\ua07d\ua900\u7d72\u8e0a\u246e\u8b38\u3437q\ua7e9\ua4bb\ua077\ua90a\u7d64\u8e47\u243a\u8b23\u346eb\ua7e3\ua4f5\ua067\ua904\u7d64\u8e10\u243a") + string);
    }

    private String findOffsetName(char c, Set<String> set) {
        return this.findOffsetName(c, set, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(""), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(""));
    }

    private String findOffsetName(char c, Set<String> set, String string, String string2) {
        Object[] objectArray = new Object[0x56C3DCB6 ^ 0x56C3DCB5];
        objectArray[0x9462D50C ^ 0x9462D50C] = string;
        objectArray[0x84A5A1EB ^ 0x84A5A1EA] = Character.valueOf(c);
        objectArray[0x4DAB521 ^ 0x4DAB523] = string2;
        String string3 = String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f0\ua062\ua940\u7d65"), objectArray);
        if (!set.contains(string3)) {
            return string3;
        }
        if (c > (0xBC30AA42 ^ 0xBC30AA02)) {
            if (c < (0xA4167551 ^ 0xA416750A)) {
                int n = c - (0x785DE3F3 ^ 0x785DE3B3);
                while (true) {
                    if (n + (0xC0AEF565 ^ 0xC0AEF524) == c) break;
                    Object[] objectArray2 = new Object[0x849FF3B ^ 0x849FF38];
                    objectArray2[0x9BC34958 ^ 0x9BC34958] = string;
                    objectArray2[0xDCD3805D ^ 0xDCD3805C] = Character.valueOf((char)(n + (0xB1A67E24 ^ 0xB1A67E65)));
                    objectArray2[0xADC6DD ^ 0xADC6DF] = string2;
                    string3 = String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f0\ua062\ua940\u7d65"), objectArray2);
                    if (!set.contains(string3)) {
                        return string3;
                    }
                    ++n;
                    n %= 0x1668558C ^ 0x16685596;
                }
            }
        }
        return null;
    }

    public SignatureVisitor getRemapper() {
        return new SignatureRemapper();
    }

    public String toString() {
        while (this.rawInterfaces.size() > 0) {
            this.addRawInterface(this.rawInterfaces.remove());
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.types.size() > 0) {
            int n = 0xEE65501C ^ 0xEE65501C;
            StringBuilder object = new StringBuilder();
            for (Map.Entry<TypeVar, TokenHandle> entry : this.types.entrySet()) {
                String string = entry.getValue().asBound();
                if (string.isEmpty()) continue;
                object.append(entry.getKey()).append((char)(0x924A34FA ^ 0x924A34C0)).append(string);
                n = 0xEC330E60 ^ 0xEC330E61;
            }
            if (n != 0) {
                stringBuilder.append((char)(0xCB0DEC9A ^ 0xCB0DECA6)).append((CharSequence)object).append((char)(0x82D5FD03 ^ 0x82D5FD3D));
            }
        }
        stringBuilder.append(this.superClass.asType());
        for (Token token : this.interfaces) {
            stringBuilder.append(token.asType());
        }
        return stringBuilder.toString();
    }

    public ClassSignature wake() {
        return this;
    }

    public static ClassSignature of(String string) {
        return new ClassSignature().read(string);
    }

    public static ClassSignature of(ClassNode classNode) {
        if (classNode.signature != null) {
            return ClassSignature.of(classNode.signature);
        }
        return ClassSignature.generate(classNode);
    }

    public static ClassSignature ofLazy(ClassNode classNode) {
        if (classNode.signature != null) {
            return new Lazy(classNode.signature);
        }
        return ClassSignature.generate(classNode);
    }

    private static ClassSignature generate(ClassNode classNode) {
        ClassSignature classSignature = new ClassSignature();
        classSignature.setSuperClass(new Token(classNode.superName != null ? classNode.superName : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62")));
        for (String string : classNode.interfaces) {
            classSignature.addInterface(new Token(string));
        }
        return classSignature;
    }

    class SignatureRemapper
    extends SignatureWriter {
        private final Set<String> localTypeVars = new HashSet<String>();

        SignatureRemapper() {
        }

        @Override
        public void visitFormalTypeParameter(String string) {
            this.localTypeVars.add(string);
            super.visitFormalTypeParameter(string);
        }

        @Override
        public void visitTypeVariable(String string) {
            TypeVar typeVar;
            if (!this.localTypeVars.contains(string) && (typeVar = ClassSignature.this.getTypeVar(string)) != null) {
                super.visitTypeVariable(typeVar.toString());
                return;
            }
            super.visitTypeVariable(string);
        }
    }

    class SignatureParser
    extends SignatureVisitor {
        private FormalParamElement param;

        SignatureParser() {
            super(0xF988F9D4 ^ 0xF98DF9D4);
        }

        @Override
        public void visitFormalTypeParameter(String string) {
            this.param = new FormalParamElement(string);
        }

        @Override
        public SignatureVisitor visitClassBound() {
            return this.param.visitClassBound();
        }

        @Override
        public SignatureVisitor visitInterfaceBound() {
            return this.param.visitInterfaceBound();
        }

        @Override
        public SignatureVisitor visitSuperclass() {
            return new SuperClassElement();
        }

        @Override
        public SignatureVisitor visitInterface() {
            return new InterfaceElement();
        }

        class InterfaceElement
        extends TokenElement {
            InterfaceElement() {
            }

            @Override
            public void visitEnd() {
                ClassSignature.this.addInterface(this.token);
            }
        }

        class SuperClassElement
        extends TokenElement {
            SuperClassElement() {
            }

            @Override
            public void visitEnd() {
                ClassSignature.this.setSuperClass(this.token);
            }
        }

        class BoundElement
        extends TokenElement {
            private final TokenElement type;
            private final boolean classBound;

            BoundElement(TokenElement tokenElement, boolean bl) {
                this.type = tokenElement;
                this.classBound = bl;
            }

            @Override
            public void visitClassType(String string) {
                this.token = this.type.token.addBound(string, this.classBound);
            }

            @Override
            public void visitTypeArgument() {
                this.token.addTypeArgument((char)(0xD5AEC240 ^ 0xD5AEC26A));
            }

            @Override
            public SignatureVisitor visitTypeArgument(char c) {
                return new TypeArgElement(this, c);
            }
        }

        class TypeArgElement
        extends TokenElement {
            private final TokenElement type;
            private final char wildcard;

            TypeArgElement(TokenElement tokenElement, char c) {
                this.type = tokenElement;
                this.wildcard = c;
            }

            @Override
            public SignatureVisitor visitArrayType() {
                this.type.setArray();
                return this;
            }

            @Override
            public void visitBaseType(char c) {
                this.token = this.type.addTypeArgument(c).asToken();
            }

            @Override
            public void visitTypeVariable(String string) {
                TokenHandle tokenHandle = ClassSignature.this.getType(string);
                this.token = this.type.addTypeArgument(tokenHandle).setWildcard(this.wildcard).asToken();
            }

            @Override
            public void visitClassType(String string) {
                this.token = this.type.addTypeArgument(string).setWildcard(this.wildcard).asToken();
            }

            @Override
            public void visitTypeArgument() {
                this.token.addTypeArgument((char)(0xB1FF5617 ^ 0xB1FF563D));
            }

            @Override
            public SignatureVisitor visitTypeArgument(char c) {
                return new TypeArgElement(this, c);
            }

            @Override
            public void visitEnd() {
            }
        }

        class FormalParamElement
        extends TokenElement {
            private final TokenHandle handle;

            FormalParamElement(String string) {
                this.handle = ClassSignature.this.getType(string);
                this.token = this.handle.asToken();
            }
        }

        abstract class TokenElement
        extends SignatureElement {
            protected Token token;
            private boolean array;

            TokenElement() {
            }

            public Token getToken() {
                if (this.token == null) {
                    this.token = new Token();
                }
                return this.token;
            }

            protected void setArray() {
                this.array = 0x3DB7053C ^ 0x3DB7053D;
            }

            private boolean getArray() {
                boolean bl = this.array;
                this.array = 0xE07F1252 ^ 0xE07F1252;
                return bl;
            }

            @Override
            public void visitClassType(String string) {
                this.getToken().setType(string);
            }

            @Override
            public SignatureVisitor visitClassBound() {
                this.getToken();
                return new BoundElement(this, (0xF447C7F4 ^ 0xF447C7F5) != 0);
            }

            @Override
            public SignatureVisitor visitInterfaceBound() {
                this.getToken();
                return new BoundElement(this, (0x5440AA9A ^ 0x5440AA9A) != 0);
            }

            @Override
            public void visitInnerClassType(String string) {
                this.token.addInnerClass(string);
            }

            @Override
            public SignatureVisitor visitArrayType() {
                this.setArray();
                return this;
            }

            @Override
            public SignatureVisitor visitTypeArgument(char c) {
                return new TypeArgElement(this, c);
            }

            Token addTypeArgument() {
                return this.token.addTypeArgument((char)(0x4242C1D5 ^ 0x4242C1FF)).asToken();
            }

            IToken addTypeArgument(char c) {
                return this.token.addTypeArgument(c).setArray(this.getArray());
            }

            IToken addTypeArgument(String string) {
                return this.token.addTypeArgument(string).setArray(this.getArray());
            }

            IToken addTypeArgument(Token token) {
                return this.token.addTypeArgument(token).setArray(this.getArray());
            }

            IToken addTypeArgument(TokenHandle tokenHandle) {
                return this.token.addTypeArgument(tokenHandle).setArray(this.getArray());
            }
        }

        abstract class SignatureElement
        extends SignatureVisitor {
            public SignatureElement() {
                super(0xE041DC56 ^ 0xE044DC56);
            }
        }
    }

    class TokenHandle
    implements IToken {
        final Token token;
        boolean array;
        char wildcard;

        TokenHandle() {
            this(new Token());
        }

        TokenHandle(Token token) {
            this.token = token;
        }

        @Override
        public IToken setArray(boolean bl) {
            this.array |= bl;
            return this;
        }

        @Override
        public IToken setWildcard(char c) {
            if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("9\ua7ab").indexOf(c) > (0x6AF28810 ^ 0x950D77EF)) {
                this.wildcard = c;
            }
            return this;
        }

        @Override
        public String asBound() {
            return this.token.asBound();
        }

        @Override
        public String asType() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.wildcard > '\u0000') {
                stringBuilder.append(this.wildcard);
            }
            if (this.array) {
                stringBuilder.append((char)(0xE190DDF5 ^ 0xE190DDAE));
            }
            return stringBuilder.append(ClassSignature.this.getTypeVar(this)).toString();
        }

        @Override
        public Token asToken() {
            return this.token;
        }

        public String toString() {
            return this.token.toString();
        }

        public TokenHandle clone() {
            return new TokenHandle(this.token);
        }
    }

    static class Token
    implements IToken {
        static final String SYMBOLS = "+-*";
        private final boolean inner;
        private boolean array;
        private char symbol = (char)(0x12F109A6 ^ 0x12F109A6);
        private String type;
        private List<Token> classBound;
        private List<Token> ifaceBound;
        private List<IToken> signature;
        private List<IToken> suffix;
        private Token tail;

        Token() {
            this((0xB20B884F ^ 0xB20B884F) != 0);
        }

        Token(String string) {
            this(string, (0xBE1A3540 ^ 0xBE1A3540) != 0);
        }

        Token(char c) {
            this();
            this.symbol = c;
        }

        Token(boolean bl) {
            this(null, bl);
        }

        Token(String string, boolean bl) {
            this.inner = bl;
            this.type = string;
        }

        Token setSymbol(char c) {
            if (this.symbol == '\u0000') {
                if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("9\ua7ab\ua4ff").indexOf(c) > (0x58079014 ^ 0xA7F86FEB)) {
                    this.symbol = c;
                }
            }
            return this;
        }

        Token setType(String string) {
            if (this.type == null) {
                this.type = string;
            }
            return this;
        }

        boolean hasClassBound() {
            return (this.classBound != null ? 0xA34567B9 ^ 0xA34567B8 : 0x39AAAEDA ^ 0x39AAAEDA) != 0;
        }

        boolean hasInterfaceBound() {
            return (this.ifaceBound != null ? 0x93E21A17 ^ 0x93E21A16 : 0x3F77AB8F ^ 0x3F77AB8F) != 0;
        }

        @Override
        public IToken setArray(boolean bl) {
            this.array |= bl;
            return this;
        }

        @Override
        public IToken setWildcard(char c) {
            if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("9\ua7ab").indexOf(c) == (0x8BBAC1C2 ^ 0x74453E3D)) {
                return this;
            }
            return this.setSymbol(c);
        }

        private List<Token> getClassBound() {
            if (this.classBound == null) {
                this.classBound = new ArrayList<Token>();
            }
            return this.classBound;
        }

        private List<Token> getIfaceBound() {
            if (this.ifaceBound == null) {
                this.ifaceBound = new ArrayList<Token>();
            }
            return this.ifaceBound;
        }

        private List<IToken> getSignature() {
            if (this.signature == null) {
                this.signature = new ArrayList<IToken>();
            }
            return this.signature;
        }

        private List<IToken> getSuffix() {
            if (this.suffix == null) {
                this.suffix = new ArrayList<IToken>();
            }
            return this.suffix;
        }

        IToken addTypeArgument(char c) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(c);
            }
            Token token = new Token(c);
            this.getSignature().add(token);
            return token;
        }

        IToken addTypeArgument(String string) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(string);
            }
            Token token = new Token(string);
            this.getSignature().add(token);
            return token;
        }

        IToken addTypeArgument(Token token) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(token);
            }
            this.getSignature().add(token);
            return token;
        }

        IToken addTypeArgument(TokenHandle tokenHandle) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(tokenHandle);
            }
            TokenHandle tokenHandle2 = tokenHandle.clone();
            this.getSignature().add(tokenHandle2);
            return tokenHandle2;
        }

        Token addBound(String string, boolean bl) {
            if (bl) {
                return this.addClassBound(string);
            }
            return this.addInterfaceBound(string);
        }

        Token addClassBound(String string) {
            Token token = new Token(string);
            this.getClassBound().add(token);
            return token;
        }

        Token addInterfaceBound(String string) {
            Token token = new Token(string);
            this.getIfaceBound().add(token);
            return token;
        }

        Token addInnerClass(String string) {
            this.tail = new Token(string, (0x5ABBE43B ^ 0x5ABBE43A) != 0);
            this.getSuffix().add(this.tail);
            return this.tail;
        }

        public String toString() {
            return this.asType();
        }

        @Override
        public String asBound() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.type != null) {
                stringBuilder.append(this.type);
            }
            if (this.classBound != null) {
                for (Token token : this.classBound) {
                    stringBuilder.append(token.asType());
                }
            }
            if (this.ifaceBound != null) {
                for (Token token : this.ifaceBound) {
                    stringBuilder.append((char)(0xCA08A0FE ^ 0xCA08A0C4)).append(token.asType());
                }
            }
            return stringBuilder.toString();
        }

        @Override
        public String asType() {
            return this.asType((0xB0C1B27A ^ 0xB0C1B27A) != 0);
        }

        public String asType(boolean bl) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.array) {
                stringBuilder.append((char)(0x44C24A02 ^ 0x44C24A59));
            }
            if (this.symbol != '\u0000') {
                stringBuilder.append(this.symbol);
            }
            if (this.type == null) {
                return stringBuilder.toString();
            }
            if (!this.inner) {
                stringBuilder.append((char)(0x50DB9A56 ^ 0x50DB9A1A));
            }
            stringBuilder.append(this.type);
            if (!bl) {
                if (this.signature != null) {
                    stringBuilder.append((char)(0x3C358EEB ^ 0x3C358ED7));
                    for (IToken iToken : this.signature) {
                        stringBuilder.append(iToken.asType());
                    }
                    stringBuilder.append((char)(0xAA0E477A ^ 0xAA0E4744));
                }
                if (this.suffix != null) {
                    for (IToken iToken : this.suffix) {
                        stringBuilder.append((char)(0x1385100A ^ 0x13851024)).append(iToken.asType());
                    }
                }
            }
            if (!this.inner) {
                stringBuilder.append((char)(0xC5FEFE3C ^ 0xC5FEFE07));
            }
            return stringBuilder.toString();
        }

        boolean isRaw() {
            return (this.signature == null ? 0xB3BFF197 ^ 0xB3BFF196 : 0xF9E0794F ^ 0xF9E0794F) != 0;
        }

        String getClassType() {
            return this.type != null ? this.type : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62");
        }

        @Override
        public Token asToken() {
            return this;
        }
    }

    static interface IToken {
        public static final String WILDCARDS = "+-";

        public String asType();

        public String asBound();

        public Token asToken();

        public IToken setArray(boolean var1);

        public IToken setWildcard(char var1);
    }

    static class TypeVar
    implements Comparable<TypeVar> {
        private final String originalName;
        private String currentName;

        TypeVar(String string) {
            this.currentName = this.originalName = string;
        }

        @Override
        public int compareTo(TypeVar typeVar) {
            return this.currentName.compareTo(typeVar.currentName);
        }

        public String toString() {
            return this.currentName;
        }

        String getOriginalName() {
            return this.originalName;
        }

        void rename(String string) {
            this.currentName = string;
        }

        public boolean matches(String string) {
            return this.originalName.equals(string);
        }

        public boolean equals(Object object) {
            return this.currentName.equals(object);
        }

        public int hashCode() {
            return this.currentName.hashCode();
        }
    }

    static class Lazy
    extends ClassSignature {
        private final String sig;
        private ClassSignature generated;

        Lazy(String string) {
            this.sig = string;
        }

        @Override
        public ClassSignature wake() {
            if (this.generated == null) {
                this.generated = ClassSignature.of(this.sig);
            }
            return this.generated;
        }
    }
}

