/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.ITokenProvider;
import org.spongepowered.asm.util.throwables.ConstraintViolationException;
import org.spongepowered.asm.util.throwables.InvalidConstraintException;

public final class ConstraintParser {
    private ConstraintParser() {
    }

    public static Constraint parse(String string) {
        if (string == null || string.length() == 0) {
            return Constraint.NONE;
        }
        String[] stringArray = string.replaceAll(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("N\ua7f5"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("")).toUpperCase().split(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(")"));
        Constraint constraint = null;
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0x1053CDBF ^ 0x1053CDBF; i < n; ++i) {
            String string2 = stringArray2[i];
            Constraint constraint2 = new Constraint(string2);
            if (constraint == null) {
                constraint = constraint2;
                continue;
            }
            constraint.append(constraint2);
        }
        return constraint != null ? constraint : Constraint.NONE;
    }

    public static Constraint parse(AnnotationNode annotationNode) {
        String string = Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("q\ua7e9\ua4bb\ua062\ua911\u7d64\u8e4b\u2473\u8b39\u3463a"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(""));
        return ConstraintParser.parse(string);
    }

    public static class Constraint {
        public static final Constraint NONE = new Constraint();
        private static final Pattern pattern = Pattern.compile(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("L\ua7ae\ua48e\ua050\ua948\u7d4c\u8e1a\u2437\u8b6e\u344b?\ua7d9\ua489\ua03f\ua938\u7d3d\u8e03\u2446\u8b7f\u343f-\ua7bc\ua4fd\ua02d\ua919\u7d2a\u8e17\u2466\u8b69\u346b,\ua7bb\ua4a9\ua02c\ua94c\u7d29\u8e02\u2441\u8b67\u343a+\ua7db\ua4fe\ua038\ua94d\u7d2a\u8e56\u2432\u8b7a\u343e:\ua7dd\ua4e5\ua03c\ua95c\u7d4b\u8e01\u2433\u8b68\u346b,\ua7fa\ua4fd\ua04d\ua94e\u7d3f\u8e02\u2441\u8b67\u343a+\ua7db\ua4fe\ua038\ua95a\u7d3f\u8e15\u2433\u8b68\u344b;\ua7a2"));
        private final String expr;
        private String token;
        private String[] constraint;
        private int min;
        private int max;
        private Constraint next;

        Constraint(String string) {
            this.min = 0xA48468D0 ^ 0x248468D0;
            this.max = 0x6F3196CA ^ 0x10CE6935;
            this.expr = string;
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) {
                throw new InvalidConstraintException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e9\ua4bb\ua062\ua911\u7d64\u8e4b\u2473\u8b39\u34632\ua7f5\ua4ac\ua07f\ua911\u7d77\u8e52\u243a\u8b20\u3476a\ua7a6\ua4bc\ua07f\ua913\u7d77\u8e46\u2473\u8b33\u3437b\ua7e7\ua4a7\ua062\ua90c\u7d78\u8e4d\u2420\u8b77") + this.expr);
            }
            this.token = matcher.group(0x838D86FA ^ 0x838D86FB);
            String[] stringArray = new String[0xD9588EE8 ^ 0xD9588EEF];
            stringArray[0x9CA31D82 ^ 0x9CA31D82] = matcher.group(0xDAF4904C ^ 0xDAF4904E);
            stringArray[0x50E31FCA ^ 0x50E31FCB] = matcher.group(0x97A420D4 ^ 0x97A420D7);
            stringArray[0x1D96683B ^ 0x1D966839] = matcher.group(0xEFEC419 ^ 0xEFEC41D);
            stringArray[0x6D97FA0 ^ 0x6D97FA3] = matcher.group(0x4CE591B0 ^ 0x4CE591B5);
            stringArray[0x60C1C8A4 ^ 0x60C1C8A0] = matcher.group(0x8DB8F064 ^ 0x8DB8F062);
            stringArray[0x2B62A218 ^ 0x2B62A21D] = matcher.group(0x41E95C2D ^ 0x41E95C2A);
            stringArray[0x112D647F ^ 0x112D6479] = matcher.group(0xBA76809D ^ 0xBA768095);
            this.constraint = stringArray;
            this.parse();
        }

        private Constraint() {
            this.min = 0x50743C42 ^ 0xD0743C42;
            this.max = 0x44D770DC ^ 0x3B288F23;
            this.expr = null;
            this.token = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("8");
            this.constraint = new String[0x884CFB55 ^ 0x884CFB55];
        }

        private void parse() {
            if (!this.has(0x62AB5FC1 ^ 0x62AB5FC0)) {
                return;
            }
            this.max = this.min = this.val(0x30536853 ^ 0x30536852);
            boolean bl = this.has(0x6806FF23 ^ 0x6806FF23);
            if (this.has(0xD209DCA0 ^ 0xD209DCA4)) {
                if (bl) {
                    throw new InvalidConstraintException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("G\ua7e8\ua4b0\ua069\ua915\u7d73\u8e49\u246e\u8b32\u34732\ua7eb\ua4ba\ua075\ua90c\u7d70\u8e43\u247f\u8b25\u34375") + this.elem(0xF39A440A ^ 0xF39A440A) + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("5\ua7a6\ua4bc\ua07f\ua945") + this.expr + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7f6\ua4b4\ua063\ua916\u7d7f\u8e44\u247d\u8b77\u3465s\ua7e8\ua4b2\ua074"));
                }
                this.max = this.val(0x5CBF6851 ^ 0x5CBF6855);
                if (this.max < this.min) {
                    throw new InvalidConstraintException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b25\u3476|\ua7e1\ua4b0\ua031\ua916\u7d66\u8e4f\u2479\u8b3e\u3471{\ua7e3\ua4b1\ua031\ua942") + this.max + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("5\ua7a6\ua4bc\ua062\ua945\u7d7a\u8e4f\u2469\u8b24\u3437f\ua7ee\ua4b4\ua07f\ua945") + this.min + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ef\ua4bb\ua031") + this.expr);
                }
                return;
            }
            if (this.has(0x37E9564B ^ 0x37E9564D)) {
                if (bl) {
                    throw new InvalidConstraintException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("G\ua7e8\ua4b0\ua069\ua915\u7d73\u8e49\u246e\u8b32\u34732\ua7eb\ua4ba\ua075\ua90c\u7d70\u8e43\u247f\u8b25\u34375") + this.elem(0xA8F971AA ^ 0xA8F971AA) + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("5\ua7a6\ua4bc\ua07f\ua945") + this.expr + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7f6\ua4b4\ua063\ua916\u7d7f\u8e44\u247d\u8b77\u3465s\ua7e8\ua4b2\ua074"));
                }
                this.max = this.min + this.val(0xF136D0 ^ 0xF136D6);
                return;
            }
            if (bl) {
                if (this.has(0x707C0787 ^ 0x707C0784)) {
                    throw new InvalidConstraintException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("G\ua7e8\ua4b0\ua069\ua915\u7d73\u8e49\u246e\u8b32\u34732\ua7f2\ua4a7\ua070\ua90c\u7d7a\u8e43\u2474\u8b30\u3437\u007f\ua7e9\ua4b1\ua078\ua903\u7d7f\u8e4f\u2468\u8b77\u3430") + this.elem(0xF7EFF4A6 ^ 0xF7EFF4A5) + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("5\ua7a6\ua4bc\ua07f\ua945") + this.expr);
                }
                String string = this.elem(0x666686F1 ^ 0x666686F1);
                if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(",").equals(string)) {
                    this.min += 0x8E669E2 ^ 0x8E669E3;
                    this.max = 0x8B9B4039 ^ 0xF464BFC6;
                } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(",\ua7bb").equals(string)) {
                    this.max = 0xE89C59E2 ^ 0x9763A61D;
                } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(".").equals(string)) {
                    this.max = this.min -= 0x3B7373BF ^ 0x3B7373BE;
                    this.min = 0x89D28FFB ^ 0x9D28FFB;
                } else if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(".\ua7bb").equals(string)) {
                    this.max = this.min;
                    this.min = 0x5E0784D0 ^ 0xDE0784D0;
                }
            } else if (this.has(0x1D1410B ^ 0x1D14109)) {
                String string = this.elem(0xA11E8447 ^ 0xA11E8445);
                if (\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(".").equals(string)) {
                    this.max = this.min;
                    this.min = 0xF07112A7 ^ 0x707112A7;
                } else {
                    this.max = 0xB701C4DB ^ 0xC8FE3B24;
                }
            }
        }

        private boolean has(int n) {
            return (this.constraint[n] != null ? 0xD7669FA3 ^ 0xD7669FA2 : 0xACE8991E ^ 0xACE8991E) != 0;
        }

        private String elem(int n) {
            return this.constraint[n];
        }

        private int val(int n) {
            return this.constraint[n] != null ? Integer.parseInt(this.constraint[n]) : 0x729215C5 ^ 0x729215C5;
        }

        void append(Constraint constraint) {
            if (this.next != null) {
                this.next.append(constraint);
                return;
            }
            this.next = constraint;
        }

        public String getToken() {
            return this.token;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public void check(ITokenProvider iTokenProvider) throws ConstraintViolationException {
            if (this != NONE) {
                Integer n = iTokenProvider.getToken(this.token);
                if (n == null) {
                    throw new ConstraintViolationException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F\ua7ee\ua4b0\ua031\ua911\u7d79\u8e41\u247f\u8b39\u34375") + this.token + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("5\ua7a6\ua4b6\ua07e\ua910\u7d7a\u8e4e\u243a\u8b39\u3478f\ua7a6\ua4b7\ua074\ua945\u7d64\u8e4f\u2469\u8b38\u347bd\ua7e3\ua4b1\ua031\ua90c\u7d78\u8e0a") + iTokenProvider, this);
                }
                if (n < this.min) {
                    throw new ConstraintViolationException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F\ua7e9\ua4be\ua074\ua90b\u7d36\u8e0d") + this.token + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("5\ua7a6\ua4bd\ua070\ua916\u7d36\u8e4b\u243a\u8b21\u3476~\ua7f3\ua4b0\ua031\ua94d") + n + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(";\ua7a6\ua4a2\ua079\ua90c\u7d75\u8e42\u243a\u8b3e\u34642\ua7ea\ua4b0\ua062\ua916\u7d36\u8e5e\u2472\u8b36\u34792\ua7f2\ua4bd\ua074\ua945\u7d7b\u8e43\u2474\u8b3e\u347ag\ua7eb\ua4f5\ua067\ua904\u7d7a\u8e5f\u247f\u8b77") + this.min + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ef\ua4bb\ua031") + iTokenProvider, this, (int)n);
                }
                if (n > this.max) {
                    throw new ConstraintViolationException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F\ua7e9\ua4be\ua074\ua90b\u7d36\u8e0d") + this.token + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("5\ua7a6\ua4bd\ua070\ua916\u7d36\u8e4b\u243a\u8b21\u3476~\ua7f3\ua4b0\ua031\ua94d") + n + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(";\ua7a6\ua4a2\ua079\ua90c\u7d75\u8e42\u243a\u8b3e\u34642\ua7e1\ua4a7\ua074\ua904\u7d62\u8e4f\u2468\u8b77\u3463z\ua7e7\ua4bb\ua031\ua911\u7d7e\u8e4f\u243a\u8b3a\u3476j\ua7ef\ua4b8\ua064\ua908\u7d36\u8e5c\u247b\u8b3b\u3462w\ua7a6") + this.max + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ef\ua4bb\ua031") + iTokenProvider, this, (int)n);
                }
            }
            if (this.next != null) {
                this.next.check(iTokenProvider);
            }
        }

        public String getRangeHumanReadable() {
            if (this.min == (0xC8C0E6EE ^ 0x48C0E6EE)) {
                if (this.max == (0x3CF55569 ^ 0x430AAA96)) {
                    return \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("S\ua7c8\ua48c\ua031\ua933\u7d57\u8e66\u244f\u8b12");
                }
            }
            if (this.min == (0x23BE5948 ^ 0xA3BE5948)) {
                Object[] objectArray = new Object[0x9BDD6D44 ^ 0x9BDD6D45];
                objectArray[0x49665F92 ^ 0x49665F92] = this.max;
                return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("~\ua7e3\ua4a6\ua062\ua945\u7d62\u8e42\u247b\u8b39\u3437}\ua7f4\ua4f5\ua074\ua914\u7d63\u8e4b\u2476\u8b77\u3463}\ua7a6\ua4f0\ua075"), objectArray);
            }
            if (this.max == (0xDB2B87B4 ^ 0xA4D4784B)) {
                Object[] objectArray = new Object[0xEF5A7E1F ^ 0xEF5A7E1E];
                objectArray[0xBE31CB5C ^ 0xBE31CB5C] = this.min;
                return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("u\ua7f4\ua4b0\ua070\ua911\u7d73\u8e58\u243a\u8b23\u347fs\ua7e8\ua4f5\ua07e\ua917\u7d36\u8e4f\u246b\u8b22\u3476~\ua7a6\ua4a1\ua07e\ua945\u7d33\u8e4e"), objectArray);
            }
            if (this.min == this.max) {
                Object[] objectArray = new Object[0xEBB9BBA5 ^ 0xEBB9BBA4];
                objectArray[0x51FC2C28 ^ 0x51FC2C28] = this.min;
                return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7e2"), objectArray);
            }
            Object[] objectArray = new Object[0x8D729780 ^ 0x8D729782];
            objectArray[0x1870FBC4 ^ 0x1870FBC4] = this.min;
            objectArray[0xB72E0D67 ^ 0xB72E0D66] = this.max;
            return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("p\ua7e3\ua4a1\ua066\ua900\u7d73\u8e44\u243a\u8b72\u34732\ua7e7\ua4bb\ua075\ua945\u7d33\u8e4e"), objectArray);
        }

        public String toString() {
            Object[] objectArray = new Object[0x3E417124 ^ 0x3E417127];
            objectArray[0xBCD0F8C4 ^ 0xBCD0F8C4] = this.token;
            objectArray[0x20745CC7 ^ 0x20745CC6] = this.min;
            objectArray[0xCB59B391 ^ 0xCB59B393] = this.max;
            return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e9\ua4bb\ua062\ua911\u7d64\u8e4b\u2473\u8b39\u3463:\ua7a3\ua4a6\ua031\ua93e\u7d33\u8e4e\u2437\u8b72\u3473O\ua7af"), objectArray);
        }
    }
}

