/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import com.google.common.base.Strings;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PrettyPrinter {
    private final HorizontalRule horizontalRule;
    private final List<Object> lines;
    private Table table;
    private boolean recalcWidth;
    protected int width;
    protected int wrapWidth;
    protected int kvKeyWidth;
    protected String kvFormat;

    public PrettyPrinter() {
        this(0x19FCBF37 ^ 0x19FCBF53);
    }

    public PrettyPrinter(int n) {
        char[] cArray = new char[0xA6C00BFC ^ 0xA6C00BFD];
        cArray[0xA233CA66 ^ 0xA233CA66] = 0x93D8E9DA ^ 0x93D8E9F0;
        this.horizontalRule = new HorizontalRule(cArray);
        this.lines = new ArrayList<Object>();
        this.recalcWidth = 0xCB166538 ^ 0xCB166538;
        this.width = 0xC6E2B0A3 ^ 0xC6E2B0C7;
        this.wrapWidth = 0x65643501 ^ 0x65643551;
        this.kvKeyWidth = 0x7D11777E ^ 0x7D117774;
        this.kvFormat = PrettyPrinter.makeKvFormat(this.kvKeyWidth);
        this.width = n;
    }

    public PrettyPrinter wrapTo(int n) {
        this.wrapWidth = n;
        return this;
    }

    public int wrapTo() {
        return this.wrapWidth;
    }

    public PrettyPrinter table() {
        this.table = new Table();
        return this;
    }

    public PrettyPrinter table(String ... stringArray) {
        this.table = new Table();
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0x62C7542 ^ 0x62C7542; i < n; ++i) {
            String string = stringArray2[i];
            this.table.addColumn(string);
        }
        return this;
    }

    public PrettyPrinter table(Object ... objectArray) {
        this.table = new Table();
        Column column = null;
        Object[] objectArray2 = objectArray;
        int n = objectArray2.length;
        for (int i = 0x64CBDC ^ 0x64CBDC; i < n; ++i) {
            Object object = objectArray2[i];
            if (object instanceof String) {
                column = this.table.addColumn((String)object);
                continue;
            }
            if (object instanceof Integer && column != null) {
                int n2 = (Integer)object;
                if (n2 > 0) {
                    column.setWidth(n2);
                    continue;
                }
                if (n2 >= 0) continue;
                column.setMaxWidth(-n2);
                continue;
            }
            if (object instanceof Alignment && column != null) {
                column.setAlignment((Alignment)((Object)object));
                continue;
            }
            if (object == null) continue;
            column = this.table.addColumn(object.toString());
        }
        return this;
    }

    public PrettyPrinter spacing(int n) {
        if (this.table == null) {
            this.table = new Table();
        }
        this.table.setColSpacing(n);
        return this;
    }

    public PrettyPrinter th() {
        return this.th((0x939ABE1C ^ 0x939ABE1C) != 0);
    }

    private PrettyPrinter th(boolean bl) {
        if (this.table == null) {
            this.table = new Table();
        }
        if (!bl || this.table.addHeader) {
            this.table.headerAdded();
            this.addLine(this.table);
        }
        return this;
    }

    public PrettyPrinter tr(Object ... objectArray) {
        this.th((0xC87748A9 ^ 0xC87748A8) != 0);
        this.addLine(this.table.addRow(objectArray));
        this.recalcWidth = 0xD68E8053 ^ 0xD68E8052;
        return this;
    }

    public PrettyPrinter add() {
        this.addLine(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(""));
        return this;
    }

    public PrettyPrinter add(String string) {
        this.addLine(string);
        this.width = Math.max(this.width, string.length());
        return this;
    }

    public PrettyPrinter add(String string, Object ... objectArray) {
        String string2 = String.format(string, objectArray);
        this.addLine(string2);
        this.width = Math.max(this.width, string2.length());
        return this;
    }

    public PrettyPrinter add(Object[] objectArray) {
        return this.add(objectArray, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5"));
    }

    public PrettyPrinter add(Object[] objectArray, String string) {
        Object[] objectArray2 = objectArray;
        int n = objectArray2.length;
        for (int i = 0xC219F1AF ^ 0xC219F1AF; i < n; ++i) {
            Object object = objectArray2[i];
            Object[] objectArray3 = new Object[0x1D83AFB8 ^ 0x1D83AFB9];
            objectArray3[0x74B21445 ^ 0x74B21445] = object;
            this.add(string, objectArray3);
        }
        return this;
    }

    public PrettyPrinter addIndexed(Object[] objectArray) {
        int n = String.valueOf(objectArray.length - (0xB733B8E4 ^ 0xB733B8E5)).length();
        String string = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("I\ua7a3") + n + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("v\ua7db\ua4f5\ua034\ua916");
        for (int i = 0xEB50519D ^ 0xEB50519D; i < objectArray.length; ++i) {
            Object[] objectArray2 = new Object[0xA9AA2C6A ^ 0xA9AA2C68];
            objectArray2[0x3C051615 ^ 0x3C051615] = i;
            objectArray2[0xF68705AF ^ 0xF68705AE] = objectArray[i];
            this.add(string, objectArray2);
        }
        return this;
    }

    public PrettyPrinter addWithIndices(Collection<?> collection) {
        return this.addIndexed(collection.toArray());
    }

    public PrettyPrinter add(IPrettyPrintable iPrettyPrintable) {
        if (iPrettyPrintable != null) {
            iPrettyPrintable.print(this);
        }
        return this;
    }

    public PrettyPrinter add(Throwable throwable) {
        return this.add(throwable, 0x1BF46E2F ^ 0x1BF46E2B);
    }

    public PrettyPrinter add(Throwable throwable, int n) {
        while (throwable != null) {
            Object[] objectArray = new Object[0x6C4EC83 ^ 0x6C4EC81];
            objectArray[0x2EE3C2AF ^ 0x2EE3C2AF] = throwable.getClass().getName();
            objectArray[0xC4BA31B0 ^ 0xC4BA31B1] = throwable.getMessage();
            this.add(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4ef\ua031\ua940\u7d65"), objectArray);
            this.add(throwable.getStackTrace(), n);
            throwable = throwable.getCause();
        }
        return this;
    }

    public PrettyPrinter add(StackTraceElement[] stackTraceElementArray, int n) {
        String string = Strings.repeat((String)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2"), (int)n);
        StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
        int n2 = stackTraceElementArray2.length;
        for (int i = 0xF1DAAEC6 ^ 0xF1DAAEC6; i < n2; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray2[i];
            Object[] objectArray = new Object[0xF41AA4DC ^ 0xF41AA4DE];
            objectArray[0xA1B3B3F5 ^ 0xA1B3B3F5] = string;
            objectArray[0x744A703A ^ 0x744A703B] = stackTraceElement;
            this.add(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f0\ua062"), objectArray);
        }
        return this;
    }

    public PrettyPrinter add(Object object) {
        return this.add(object, 0x4B2FAA56 ^ 0x4B2FAA56);
    }

    public PrettyPrinter add(Object object, int n) {
        String string = Strings.repeat((String)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2"), (int)n);
        return this.append(object, n, string);
    }

    private PrettyPrinter append(Object object, int n, String string) {
        if (object instanceof String) {
            Object[] objectArray = new Object[0x9E6346B7 ^ 0x9E6346B5];
            objectArray[0x7E3941DA ^ 0x7E3941DA] = string;
            objectArray[0xB44DD541 ^ 0xB44DD540] = object;
            return this.add(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f0\ua062"), objectArray);
        }
        if (object instanceof Iterable) {
            for (Object t : (Iterable)object) {
                this.append(t, n, string);
            }
            return this;
        }
        if (object instanceof Map) {
            this.kvWidth(n);
            return this.add((Map)object);
        }
        if (object instanceof IPrettyPrintable) {
            return this.add((IPrettyPrintable)object);
        }
        if (object instanceof Throwable) {
            return this.add((Throwable)object, n);
        }
        if (object.getClass().isArray()) {
            return this.add((Object[])object, n + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5"));
        }
        Object[] objectArray = new Object[0x542C5DEB ^ 0x542C5DE9];
        objectArray[0x914D7EC ^ 0x914D7EC] = string;
        objectArray[0x2C520291 ^ 0x2C520290] = object;
        return this.add(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5\ua4f0\ua062"), objectArray);
    }

    public PrettyPrinter addWrapped(String string, Object ... objectArray) {
        return this.addWrapped(this.wrapWidth, string, objectArray);
    }

    public PrettyPrinter addWrapped(int n, String string, Object ... objectArray) {
        String string2 = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("");
        String string3 = String.format(string, objectArray).replace(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("\u001b"), \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7a6\ua4f5\ua031"));
        Matcher matcher = Pattern.compile(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("L\ua7ae\ua489\ua062\ua94e\u7d3f\u8e02\u2434\u8b7d\u343e6")).matcher(string3);
        if (matcher.matches()) {
            string2 = matcher.group(0xAE39C74E ^ 0xAE39C74F);
        }
        try {
            for (String string4 : this.getWrapped(n, string3, string2)) {
                this.addLine(string4);
            }
        }
        catch (Exception exception) {
            this.add(string3);
        }
        return this;
    }

    private List<String> getWrapped(int n, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (string.length() > n) {
            int n2 = string.lastIndexOf(0xDF38683F ^ 0xDF38681F, n);
            if (n2 < (0xB3F97931 ^ 0xB3F9793B)) {
                n2 = n;
            }
            String string3 = string.substring(0x4D4135EA ^ 0x4D4135EA, n2);
            arrayList.add(string3);
            string = string2 + string.substring(n2 + (0x5C22B050 ^ 0x5C22B051));
        }
        if (string.length() > 0) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public PrettyPrinter kv(String string, String string2, Object ... objectArray) {
        return this.kv(string, String.format(string2, objectArray));
    }

    public PrettyPrinter kv(String string, Object object) {
        this.addLine(new KeyValue(string, object));
        return this.kvWidth(string.length());
    }

    public PrettyPrinter kvWidth(int n) {
        if (n > this.kvKeyWidth) {
            this.kvKeyWidth = n;
            this.kvFormat = PrettyPrinter.makeKvFormat(n);
        }
        this.recalcWidth = 0x6E84657 ^ 0x6E84656;
        return this;
    }

    public PrettyPrinter add(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String string = entry.getKey() == null ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("|\ua7f3\ua4b9\ua07d") : entry.getKey().toString();
            this.kv(string, entry.getValue());
        }
        return this;
    }

    public PrettyPrinter hr() {
        return this.hr((char)(0x9E2B22E9 ^ 0x9E2B22C3));
    }

    public PrettyPrinter hr(char c) {
        char[] cArray = new char[0x285D03D8 ^ 0x285D03D9];
        cArray[0xEE5C508D ^ 0xEE5C508D] = c;
        this.addLine(new HorizontalRule(cArray));
        return this;
    }

    public PrettyPrinter centre() {
        if (!this.lines.isEmpty()) {
            Object object = this.lines.get(this.lines.size() - (0xC226DCB ^ 0xC226DCA));
            if (object instanceof String) {
                this.addLine(new CentredText(this.lines.remove(this.lines.size() - (0x17C039C2 ^ 0x17C039C3))));
            }
        }
        return this;
    }

    private void addLine(Object object) {
        if (object == null) {
            return;
        }
        this.lines.add(object);
        this.recalcWidth |= object instanceof IVariableWidthEntry;
    }

    public PrettyPrinter trace() {
        return this.trace(PrettyPrinter.getDefaultLoggerName());
    }

    public PrettyPrinter trace(Level level) {
        return this.trace(PrettyPrinter.getDefaultLoggerName(), level);
    }

    public PrettyPrinter trace(String string) {
        return this.trace(System.err, LogManager.getLogger((String)string));
    }

    public PrettyPrinter trace(String string, Level level) {
        return this.trace(System.err, LogManager.getLogger((String)string), level);
    }

    public PrettyPrinter trace(Logger logger) {
        return this.trace(System.err, logger);
    }

    public PrettyPrinter trace(Logger logger, Level level) {
        return this.trace(System.err, logger, level);
    }

    public PrettyPrinter trace(PrintStream printStream) {
        return this.trace(printStream, PrettyPrinter.getDefaultLoggerName());
    }

    public PrettyPrinter trace(PrintStream printStream, Level level) {
        return this.trace(printStream, PrettyPrinter.getDefaultLoggerName(), level);
    }

    public PrettyPrinter trace(PrintStream printStream, String string) {
        return this.trace(printStream, LogManager.getLogger((String)string));
    }

    public PrettyPrinter trace(PrintStream printStream, String string, Level level) {
        return this.trace(printStream, LogManager.getLogger((String)string), level);
    }

    public PrettyPrinter trace(PrintStream printStream, Logger logger) {
        return this.trace(printStream, logger, Level.DEBUG);
    }

    public PrettyPrinter trace(PrintStream printStream, Logger logger, Level level) {
        this.log(logger, level);
        this.print(printStream);
        return this;
    }

    public PrettyPrinter print() {
        return this.print(System.err);
    }

    public PrettyPrinter print(PrintStream printStream) {
        this.updateWidth();
        this.printSpecial(printStream, this.horizontalRule);
        for (Object object : this.lines) {
            if (object instanceof ISpecialEntry) {
                this.printSpecial(printStream, (ISpecialEntry)object);
                continue;
            }
            this.printString(printStream, object.toString());
        }
        this.printSpecial(printStream, this.horizontalRule);
        return this;
    }

    private void printSpecial(PrintStream printStream, ISpecialEntry iSpecialEntry) {
        Object[] objectArray = new Object[0x4C5EF440 ^ 0x4C5EF441];
        objectArray[0xBCAEA9E7 ^ 0xBCAEA9E7] = iSpecialEntry.toString();
        printStream.printf(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("=\ua7ac\ua4f0\ua062\ua94f\u7d39\u8e20"), objectArray);
    }

    private void printString(PrintStream printStream, String string) {
        if (string != null) {
            Object[] objectArray = new Object[0x5558BCFA ^ 0x5558BCFB];
            objectArray[0x8EA586F3 ^ 0x8EA586F3] = string;
            printStream.printf(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("=\ua7ac\ua4f5\ua034\ua948") + this.width + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a\ua7a6\ua4ff\ua03e\ua96f"), objectArray);
        }
    }

    public PrettyPrinter log(Logger logger) {
        return this.log(logger, Level.INFO);
    }

    public PrettyPrinter log(Logger logger, Level level) {
        this.updateWidth();
        this.logSpecial(logger, level, this.horizontalRule);
        for (Object object : this.lines) {
            if (object instanceof ISpecialEntry) {
                this.logSpecial(logger, level, (ISpecialEntry)object);
                continue;
            }
            this.logString(logger, level, object.toString());
        }
        this.logSpecial(logger, level, this.horizontalRule);
        return this;
    }

    private void logSpecial(Logger logger, Level level, ISpecialEntry iSpecialEntry) {
        Object[] objectArray = new Object[0x4E598136 ^ 0x4E598137];
        objectArray[0x519B7348 ^ 0x519B7348] = iSpecialEntry.toString();
        logger.log(level, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("=\ua7ac\ua4ae\ua06c\ua94f\u7d39"), objectArray);
    }

    private void logString(Logger logger, Level level, String string) {
        if (string != null) {
            Object[] objectArray = new Object[0xF197BB0E ^ 0xF197BB0F];
            objectArray[0x2FDF0E91 ^ 0x2FDF0E91] = string;
            logger.log(level, String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("=\ua7ac\ua4f5\ua034\ua948") + this.width + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a\ua7a6\ua4ff\ua03e"), objectArray));
        }
    }

    private void updateWidth() {
        if (this.recalcWidth) {
            this.recalcWidth = 0x1299B6C0 ^ 0x1299B6C0;
            for (Object object : this.lines) {
                if (!(object instanceof IVariableWidthEntry)) continue;
                this.width = Math.min(0x2CA73885 ^ 0x2CA72885, Math.max(this.width, ((IVariableWidthEntry)object).getWidth()));
            }
        }
    }

    private static String makeKvFormat(int n) {
        Object[] objectArray = new Object[0xD6077DED ^ 0xD6077DEC];
        objectArray[0x125BE777 ^ 0x125BE777] = n;
        return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7a3\ua4f0\ua075\ua916\u7d36\u8e10\u243a\u8b72\u3432a"), objectArray);
    }

    private static String getDefaultLoggerName() {
        String string = new Throwable().getStackTrace()[0xC2401518 ^ 0xC240151A].getClassName();
        int n = string.lastIndexOf(0xE372CE53 ^ 0xE372CE7D);
        return n == (0xF0F4F5F0 ^ 0xF0B0A0F) ? string : string.substring(n + (0x8B1A89DD ^ 0x8B1A89DC));
    }

    public static void dumpStack() {
        new PrettyPrinter().add(new Exception(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7f2\ua4b4\ua072\ua90e\u7d36\u8e5e\u2468\u8b36\u3474w"))).print(System.err);
    }

    public static void print(Throwable throwable) {
        new PrettyPrinter().add(throwable).print(System.err);
    }

    static class Row
    implements IVariableWidthEntry {
        final Table table;
        final String[] args;

        public Row(Table table, Object ... objectArray) {
            this.table = table.grow(objectArray.length);
            this.args = new String[objectArray.length];
            for (int i = 0x59CEB419 ^ 0x59CEB419; i < objectArray.length; ++i) {
                this.args[i] = objectArray[i].toString();
                this.table.columns.get(i).setMinWidth(this.args[i].length());
            }
        }

        public String toString() {
            Object[] objectArray = new Object[this.table.columns.size()];
            for (int i = 0x4F15BD5C ^ 0x4F15BD5C; i < objectArray.length; ++i) {
                Column column = this.table.columns.get(i);
                if (i >= this.args.length) {
                    objectArray[i] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("");
                    continue;
                }
                objectArray[i] = this.args[i].length() > column.getMaxWidth() ? this.args[i].substring(0xB1E2D119 ^ 0xB1E2D119, column.getMaxWidth()) : this.args[i];
            }
            return String.format(this.table.format, objectArray);
        }

        @Override
        public int getWidth() {
            return this.toString().length();
        }
    }

    static class Column {
        private final Table table;
        private Alignment align = Alignment.LEFT;
        private int minWidth = 0x6C1E000F ^ 0x6C1E000E;
        private int maxWidth = 0x499E67CE ^ 0x36619831;
        private int size = 0x19A00C1A ^ 0x19A00C1A;
        private String title = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("");
        private String format = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5");

        Column(Table table) {
            this.table = table;
        }

        Column(Table table, String string) {
            this(table);
            this.title = string;
            this.minWidth = string.length();
            this.updateFormat();
        }

        Column(Table table, Alignment alignment, int n, String string) {
            this(table, string);
            this.align = alignment;
            this.size = n;
        }

        void setAlignment(Alignment alignment) {
            this.align = alignment;
            this.updateFormat();
        }

        void setWidth(int n) {
            if (n > this.size) {
                this.size = n;
                this.updateFormat();
            }
        }

        void setMinWidth(int n) {
            if (n > this.minWidth) {
                this.minWidth = n;
                this.updateFormat();
            }
        }

        void setMaxWidth(int n) {
            this.size = Math.min(this.size, this.maxWidth);
            this.maxWidth = Math.max(0xC34347D9 ^ 0xC34347D8, n);
            this.updateFormat();
        }

        void setTitle(String string) {
            this.title = string;
            this.setWidth(string.length());
        }

        private void updateFormat() {
            int n = Math.min(this.maxWidth, this.size == 0 ? this.minWidth : this.size);
            this.format = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7") + (this.align == Alignment.RIGHT ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("?")) + n + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a");
            this.table.updateFormat();
        }

        int getMaxWidth() {
            return this.maxWidth;
        }

        String getTitle() {
            return this.title;
        }

        String getFormat() {
            return this.format;
        }

        public String toString() {
            if (this.title.length() > this.maxWidth) {
                return this.title.substring(0xD32977C3 ^ 0xD32977C3, this.maxWidth);
            }
            return this.title;
        }
    }

    static class Table
    implements IVariableWidthEntry {
        final List<Column> columns = new ArrayList<Column>();
        final List<Row> rows = new ArrayList<Row>();
        String format = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7\ua7f5");
        int colSpacing = 0xCD4501D2 ^ 0xCD4501D0;
        boolean addHeader = 0x2F59D255 ^ 0x2F59D254;

        Table() {
        }

        void headerAdded() {
            this.addHeader = 0xBDE94A0D ^ 0xBDE94A0D;
        }

        void setColSpacing(int n) {
            this.colSpacing = Math.max(0x541BE615 ^ 0x541BE615, n);
            this.updateFormat();
        }

        Table grow(int n) {
            while (this.columns.size() < n) {
                this.columns.add(new Column(this));
            }
            this.updateFormat();
            return this;
        }

        Column add(Column column) {
            this.columns.add(column);
            return column;
        }

        Row add(Row row) {
            this.rows.add(row);
            return row;
        }

        Column addColumn(String string) {
            return this.add(new Column(this, string));
        }

        Column addColumn(Alignment alignment, int n, String string) {
            return this.add(new Column(this, alignment, n, string));
        }

        Row addRow(Object ... objectArray) {
            return this.add(new Row(this, objectArray));
        }

        void updateFormat() {
            String string = Strings.repeat((String)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2"), (int)this.colSpacing);
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0x158C181D ^ 0x158C181D;
            for (Column column : this.columns) {
                if (n != 0) {
                    stringBuilder.append(string);
                }
                n = 0x4D816AFE ^ 0x4D816AFF;
                stringBuilder.append(column.getFormat());
            }
            this.format = stringBuilder.toString();
        }

        String getFormat() {
            return this.format;
        }

        Object[] getTitles() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Column column : this.columns) {
                arrayList.add(column.getTitle());
            }
            return arrayList.toArray();
        }

        public String toString() {
            int n = 0x4D001017 ^ 0x4D001017;
            String[] stringArray = new String[this.columns.size()];
            for (int i = 0x895790C3 ^ 0x895790C3; i < this.columns.size(); ++i) {
                stringArray[i] = this.columns.get(i).toString();
                n |= !stringArray[i].isEmpty() ? 0x2C307E59 ^ 0x2C307E58 : 0x1B5AC439 ^ 0x1B5AC439;
            }
            return n != 0 ? String.format(this.format, stringArray) : null;
        }

        @Override
        public int getWidth() {
            String string = this.toString();
            return string != null ? string.length() : 0x48B8870B ^ 0x48B8870B;
        }
    }

    public static final class Alignment
    extends Enum<Alignment> {
        public static final /* enum */ Alignment LEFT = new Alignment();
        public static final /* enum */ Alignment RIGHT = new Alignment();
        private static final /* synthetic */ Alignment[] $VALUES;

        public static Alignment[] values() {
            return (Alignment[])$VALUES.clone();
        }

        public static Alignment valueOf(String string) {
            return Enum.valueOf(Alignment.class, string);
        }

        static {
            Alignment[] alignmentArray = new Alignment[0xA083BAB1 ^ 0xA083BAB3];
            alignmentArray[0x72008E85 ^ 0x72008E85] = LEFT;
            alignmentArray[0x94186A5 ^ 0x94186A4] = RIGHT;
            $VALUES = alignmentArray;
        }
    }

    class CentredText {
        private final Object centred;

        public CentredText(Object object) {
            this.centred = object;
        }

        public String toString() {
            String string = this.centred.toString();
            Object[] objectArray = new Object[0x79F63D5 ^ 0x79F63D4];
            objectArray[0xC0A0D44E ^ 0xC0A0D44E] = string;
            return String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("7") + ((PrettyPrinter.this.width - string.length()) / (0x9CD33F4 ^ 0x9CD33F6) + string.length()) + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a"), objectArray);
        }
    }

    class HorizontalRule
    implements ISpecialEntry {
        private final char[] hrChars;

        public HorizontalRule(char ... cArray) {
            this.hrChars = cArray;
        }

        public String toString() {
            return Strings.repeat((String)new String(this.hrChars), (int)(PrettyPrinter.this.width + (0x36ED30F2 ^ 0x36ED30F0)));
        }
    }

    class KeyValue
    implements IVariableWidthEntry {
        private final String key;
        private final Object value;

        public KeyValue(String string, Object object) {
            this.key = string;
            this.value = object;
        }

        public String toString() {
            Object[] objectArray = new Object[0x60940151 ^ 0x60940153];
            objectArray[0x2E1D70A1 ^ 0x2E1D70A1] = this.key;
            objectArray[0x40B85DF2 ^ 0x40B85DF3] = this.value;
            return String.format(PrettyPrinter.this.kvFormat, objectArray);
        }

        @Override
        public int getWidth() {
            return this.toString().length();
        }
    }

    static interface ISpecialEntry {
    }

    static interface IVariableWidthEntry {
        public int getWidth();
    }

    public static interface IPrettyPrintable {
        public void print(PrettyPrinter var1);
    }
}

