/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import com.google.common.base.Strings;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.LocalVariableNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;

public class SignaturePrinter {
    private final String name;
    private final Type returnType;
    private final Type[] argTypes;
    private final String[] argNames;
    private String modifiers = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("b\ua7f4\ua4bc\ua067\ua904\u7d62\u8e4f\u243a\u8b21\u3478{\ua7e2");
    private boolean fullyQualified;

    public SignaturePrinter(MethodNode methodNode) {
        this(methodNode.name, Type.VOID_TYPE, Type.getArgumentTypes(methodNode.desc));
        this.setModifiers(methodNode);
    }

    public SignaturePrinter(MethodNode methodNode, String[] stringArray) {
        this(methodNode.name, Type.VOID_TYPE, Type.getArgumentTypes(methodNode.desc), stringArray);
        this.setModifiers(methodNode);
    }

    public SignaturePrinter(MemberInfo memberInfo) {
        this(memberInfo.name, memberInfo.desc);
    }

    public SignaturePrinter(String string, String string2) {
        this(string, Type.getReturnType(string2), Type.getArgumentTypes(string2));
    }

    public SignaturePrinter(String string, Type type, Type[] typeArray) {
        this.name = string;
        this.returnType = type;
        this.argTypes = new Type[typeArray.length];
        this.argNames = new String[typeArray.length];
        int n = 0xAD49EC03 ^ 0xAD49EC03;
        for (int i = 0x79CCB2AD ^ 0x79CCB2AD; i < typeArray.length; ++i) {
            if (typeArray[i] == null) continue;
            this.argTypes[i] = typeArray[i];
            this.argNames[i] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("d\ua7e7\ua4a7") + n++;
        }
    }

    public SignaturePrinter(String string, Type type, LocalVariableNode[] localVariableNodeArray) {
        this.name = string;
        this.returnType = type;
        this.argTypes = new Type[localVariableNodeArray.length];
        this.argNames = new String[localVariableNodeArray.length];
        for (int i = 0x13B14BA ^ 0x13B14BA; i < localVariableNodeArray.length; ++i) {
            if (localVariableNodeArray[i] == null) continue;
            this.argTypes[i] = Type.getType(localVariableNodeArray[i].desc);
            this.argNames[i] = localVariableNodeArray[i].name;
        }
    }

    public SignaturePrinter(String string, Type type, Type[] typeArray, String[] stringArray) {
        this.name = string;
        this.returnType = type;
        this.argTypes = typeArray;
        this.argNames = stringArray;
        if (this.argTypes.length > this.argNames.length) {
            Object[] objectArray = new Object[0xAD1D127 ^ 0xAD1D125];
            objectArray[0x7CA21E9F ^ 0x7CA21E9F] = this.argNames.length;
            objectArray[0xCEC6CFA7 ^ 0xCEC6CFA6] = this.argTypes.length;
            throw new IllegalArgumentException(String.format(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("F\ua7ff\ua4a5\ua074\ua916\u7d36\u8e4b\u2468\u8b25\u3476k\ua7a6\ua4b9\ua074\ua90b\u7d71\u8e5e\u2472\u8b77\u347ag\ua7f5\ua4a1\ua031\ua90b\u7d79\u8e5e\u243a\u8b32\u346fq\ua7e3\ua4b0\ua075\ua945\u7d78\u8e4b\u2477\u8b32\u34642\ua7e7\ua4a7\ua063\ua904\u7d6f\u8e0a\u2476\u8b32\u3479u\ua7f2\ua4bd\ua030\ua945\u7d3e\u8e44\u247b\u8b3a\u3472a\ua7bb\ua4f0\ua075\ua949\u7d36\u8e5e\u2463\u8b27\u3472a\ua7bb\ua4f0\ua075\ua94c"), objectArray));
        }
    }

    public String getFormattedArgs() {
        return this.appendArgs(new StringBuilder(), (0x9A94DB71 ^ 0x9A94DB70) != 0, (0x21F0968 ^ 0x21F0969) != 0).toString();
    }

    public String getReturnType() {
        return SignaturePrinter.getTypeName(this.returnType, (0x32EFCD22 ^ 0x32EFCD22) != 0, this.fullyQualified);
    }

    public void setModifiers(MethodNode methodNode) {
        String string = SignaturePrinter.getTypeName(Type.getReturnType(methodNode.desc), (0x9BA76388 ^ 0x9BA76388) != 0, this.fullyQualified);
        if ((methodNode.access & (0xAB8ECA47 ^ 0xAB8ECA46)) != 0) {
            this.setModifiers(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("b\ua7f3\ua4b7\ua07d\ua90c\u7d75\u8e0a") + string);
        } else if ((methodNode.access & (0x500273AD ^ 0x500273A9)) != 0) {
            this.setModifiers(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("b\ua7f4\ua4ba\ua065\ua900\u7d75\u8e5e\u247f\u8b33\u3437") + string);
        } else if ((methodNode.access & (0xEACFB4F8 ^ 0xEACFB4FA)) != 0) {
            this.setModifiers(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("b\ua7f4\ua4bc\ua067\ua904\u7d62\u8e4f\u243a") + string);
        } else {
            this.setModifiers(string);
        }
    }

    public SignaturePrinter setModifiers(String string) {
        this.modifiers = string.replace(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("6\ua7fd\ua4a7\ua074\ua911\u7d63\u8e58\u2474\u8b03\u346eb\ua7e3\ua4a8"), this.getReturnType());
        return this;
    }

    public SignaturePrinter setFullyQualified(boolean bl) {
        this.fullyQualified = bl;
        return this;
    }

    public boolean isFullyQualified() {
        return this.fullyQualified;
    }

    public String toString() {
        return this.appendArgs(new StringBuilder().append(this.modifiers).append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2")).append(this.name), (0xE13B1A27 ^ 0xE13B1A27) != 0, (0xF7202DA0 ^ 0xF7202DA1) != 0).toString();
    }

    public String toDescriptor() {
        StringBuilder stringBuilder = this.appendArgs(new StringBuilder(), (0xA64D818C ^ 0xA64D818D) != 0, (0x4AC60E12 ^ 0x4AC60E12) != 0);
        return stringBuilder.append(SignaturePrinter.getTypeName(this.returnType, (0xE1B05611 ^ 0xE1B05611) != 0, this.fullyQualified)).toString();
    }

    private StringBuilder appendArgs(StringBuilder stringBuilder, boolean bl, boolean bl2) {
        stringBuilder.append((char)(0x4DCD3952 ^ 0x4DCD397A));
        for (int i = 0x79D2B65F ^ 0x79D2B65F; i < this.argTypes.length; ++i) {
            if (this.argTypes[i] == null) continue;
            if (i > 0) {
                stringBuilder.append((char)(0xEF3AFBC2 ^ 0xEF3AFBEE));
                if (bl2) {
                    stringBuilder.append((char)(0x6582033E ^ 0x6582031E));
                }
            }
            try {
                String string = bl ? null : (Strings.isNullOrEmpty((String)this.argNames[i]) ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("g\ua7e8\ua4bb\ua070\ua908\u7d73\u8e4e") + i : this.argNames[i]);
                this.appendType(stringBuilder, this.argTypes[i], string);
                continue;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return stringBuilder.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(";"));
    }

    private StringBuilder appendType(StringBuilder stringBuilder, Type type, String string) {
        switch (type.getSort()) {
            case 9: {
                return SignaturePrinter.appendArraySuffix(this.appendType(stringBuilder, type.getElementType(), string), type);
            }
            case 10: {
                return this.appendType(stringBuilder, type.getClassName(), string);
            }
        }
        stringBuilder.append(SignaturePrinter.getTypeName(type, (0x16997398 ^ 0x16997398) != 0, this.fullyQualified));
        if (string != null) {
            stringBuilder.append((char)(0x31D6A372 ^ 0x31D6A352)).append(string);
        }
        return stringBuilder;
    }

    private StringBuilder appendType(StringBuilder stringBuilder, String string, String string2) {
        if (!this.fullyQualified) {
            string = string.substring(string.lastIndexOf(0x1418C184 ^ 0x1418C1AA) + (0xB82EBAF4 ^ 0xB82EBAF5));
        }
        stringBuilder.append(string);
        if (string.endsWith(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7e7\ua4b9\ua07d\ua907\u7d77\u8e49\u2471\u8b1e\u3479t\ua7e9\ua487\ua074\ua911\u7d63\u8e58\u2474\u8b36\u3475~\ua7e3"))) {
            stringBuilder.append((char)(0x5EBAD48F ^ 0x5EBAD4B3)).append(SignaturePrinter.getTypeName(this.returnType, (0x8F8B165 ^ 0x8F8B164) != 0, this.fullyQualified)).append((char)(0xD9E4D461 ^ 0xD9E4D45F));
        }
        if (string2 != null) {
            stringBuilder.append((char)(0xF4466F42 ^ 0xF4466F62)).append(string2);
        }
        return stringBuilder;
    }

    public static String getTypeName(Type type, boolean bl) {
        return SignaturePrinter.getTypeName(type, bl, (0x5988BC81 ^ 0x5988BC81) != 0);
    }

    public static String getTypeName(Type type, boolean bl, boolean bl2) {
        switch (type.getSort()) {
            case 0: {
                return bl ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("D\ua7e9\ua4bc\ua075") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("d\ua7e9\ua4bc\ua075");
            }
            case 1: {
                return bl ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("P\ua7e9\ua4ba\ua07d\ua900\u7d77\u8e44") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("p\ua7e9\ua4ba\ua07d\ua900\u7d77\u8e44");
            }
            case 2: {
                return bl ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("Q\ua7ee\ua4b4\ua063\ua904\u7d75\u8e5e\u247f\u8b25") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("q\ua7ee\ua4b4\ua063");
            }
            case 3: {
                return bl ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("P\ua7ff\ua4a1\ua074") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("p\ua7ff\ua4a1\ua074");
            }
            case 4: {
                return bl ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7ee\ua4ba\ua063\ua911") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a\ua7ee\ua4ba\ua063\ua911");
            }
            case 5: {
                return bl ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4a1\ua074\ua902\u7d73\u8e58") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("{\ua7e8\ua4a1");
            }
            case 6: {
                return bl ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("T\ua7ea\ua4ba\ua070\ua911") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("t\ua7ea\ua4ba\ua070\ua911");
            }
            case 7: {
                return bl ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("^\ua7e9\ua4bb\ua076") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("~\ua7e9\ua4bb\ua076");
            }
            case 8: {
                return bl ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("V\ua7e9\ua4a0\ua073\ua909\u7d73") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("v\ua7e9\ua4a0\ua073\ua909\u7d73");
            }
            case 9: {
                return SignaturePrinter.getTypeName(type.getElementType(), bl, bl2) + SignaturePrinter.arraySuffix(type);
            }
            case 10: {
                String string = type.getClassName();
                if (!bl2) {
                    string = string.substring(string.lastIndexOf(0x3F433FC0 ^ 0x3F433FEE) + (0x70DF6252 ^ 0x70DF6253));
                }
                return string;
            }
        }
        return \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("]\ua7e4\ua4bf\ua074\ua906\u7d62");
    }

    private static String arraySuffix(Type type) {
        return Strings.repeat((String)\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("I\ua7db"), (int)type.getDimensions());
    }

    private static StringBuilder appendArraySuffix(StringBuilder stringBuilder, Type type) {
        for (int i = 0x1100178A ^ 0x1100178A; i < type.getDimensions(); ++i) {
            stringBuilder.append(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("I\ua7db"));
        }
        return stringBuilder;
    }
}

