/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util.perf;

import com.google.common.base.Joiner;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.spongepowered.asm.util.PrettyPrinter;

public final class Profiler {
    public static final int ROOT = 1;
    public static final int FINE = 2;
    private final Map<String, Section> sections = new TreeMap<String, Section>();
    private final List<String> phases = new ArrayList<String>();
    private final Deque<Section> stack = new LinkedList<Section>();
    private boolean active;

    public Profiler() {
        this.phases.add(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4bc\ua065\ua90c\u7d77\u8e46"));
    }

    public void setActive(boolean bl) {
        if (!this.active && bl || !bl) {
            this.reset();
        }
        this.active = bl;
    }

    public void reset() {
        for (Section section : this.sections.values()) {
            section.invalidate();
        }
        this.sections.clear();
        this.phases.clear();
        this.phases.add(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("[\ua7e8\ua4bc\ua065\ua90c\u7d77\u8e46"));
        this.stack.clear();
    }

    public Section get(String string) {
        Section section = this.sections.get(string);
        if (section == null) {
            section = this.active ? new LiveSection(string, this.phases.size() - (0xE435EBCE ^ 0xE435EBCF)) : new Section(string);
            this.sections.put(string, section);
        }
        return section;
    }

    private Section getSubSection(String string, String string2, Section section) {
        Section section2 = this.sections.get(string);
        if (section2 == null) {
            section2 = new SubSection(string, this.phases.size() - (0x2F087620 ^ 0x2F087621), string2, section);
            this.sections.put(string, section2);
        }
        return section2;
    }

    boolean isHead(Section section) {
        return (this.stack.peek() == section ? 0x66CBC5F4 ^ 0x66CBC5F5 : 0x2374AE5D ^ 0x2374AE5D) != 0;
    }

    public Section begin(String ... stringArray) {
        return this.begin(0x8E6E0BB ^ 0x8E6E0BB, stringArray);
    }

    public Section begin(int n, String ... stringArray) {
        return this.begin(n, Joiner.on((char)(0xB2B41CEC ^ 0xB2B41CC2)).join((Object[])stringArray));
    }

    public Section begin(String string) {
        return this.begin(0x979EAD4B ^ 0x979EAD4B, string);
    }

    public Section begin(int n, String string) {
        int n2 = (n & (0x5213A851 ^ 0x5213A850)) != 0 ? 0x686F1243 ^ 0x686F1242 : 0xF984928C ^ 0xF984928C;
        int n3 = (n & (0xBA4E7FC9 ^ 0xBA4E7FCB)) != 0 ? 0xD2B6C3F ^ 0xD2B6C3E : 0xCE49A2CA ^ 0xCE49A2CA;
        String string2 = string;
        Section section = this.stack.peek();
        if (section != null) {
            string2 = section.getName() + (n2 != 0 ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ab\ua4eb\ua031") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("<")) + string2;
            if (section.isRoot() && n2 == 0) {
                int n4 = section.getName().lastIndexOf(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7ab\ua4eb\ua031"));
                string = (n4 > (0xDA47A6D4 ^ 0x25B8592B) ? section.getName().substring(n4 + (0xFE8ED5A5 ^ 0xFE8ED5A1)) : section.getName()) + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("<") + string;
                n2 = 0xEDA105DF ^ 0xEDA105DE;
            }
        }
        Section section2 = this.get(n2 != 0 ? string : string2);
        if (n2 != 0 && section != null && this.active) {
            section2 = this.getSubSection(string2, section.getName(), section2);
        }
        section2.setFine(n3 != 0).setRoot(n2 != 0);
        this.stack.push(section2);
        return section2.start();
    }

    void end(Section section) {
        block5: {
            try {
                Section section2;
                Section section3 = section2 = this.stack.pop();
                while (section3 != section) {
                    if (section3 == null && this.active) {
                        if (section2 == null) {
                            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("S\ua7f2\ua4a1\ua074\ua908\u7d66\u8e5e\u247f\u8b33\u3437f\ua7e9\ua4f5\ua061\ua90a\u7d66\u8e0a") + section + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e4\ua4a0\ua065\ua945\u7d62\u8e42\u247f\u8b77\u3464f\ua7e7\ua4b6\ua07a\ua945\u7d7f\u8e59\u243a\u8b32\u347ab\ua7f2\ua4ac"));
                        }
                        throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("S\ua7f2\ua4a1\ua074\ua908\u7d66\u8e5e\u247f\u8b33\u3437f\ua7e9\ua4f5\ua061\ua90a\u7d66\u8e0a") + section + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7f1\ua4bd\ua078\ua906\u7d7e\u8e0a\u246d\u8b36\u34642\ua7e8\ua4ba\ua065\ua945\u7d7f\u8e44\u243a\u8b23\u347fw\ua7a6\ua4a6\ua065\ua904\u7d75\u8e41\u2436\u8b77\u347fw\ua7e7\ua4b1\ua031\ua912\u7d77\u8e59\u243a") + section2);
                    }
                    section3 = this.stack.pop();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                if (!this.active) break block5;
                throw new IllegalStateException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("S\ua7f2\ua4a1\ua074\ua908\u7d66\u8e5e\u247f\u8b33\u3437f\ua7e9\ua4f5\ua061\ua90a\u7d66\u8e0a") + section + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7e4\ua4a0\ua065\ua945\u7d62\u8e42\u247f\u8b77\u3464f\ua7e7\ua4b6\ua07a\ua945\u7d7f\u8e59\u243a\u8b32\u347ab\ua7f2\ua4ac"));
            }
        }
    }

    public void mark(String string) {
        long l = 0xEC70F83D2E339ECL ^ 0xEC70F83D2E339ECL;
        for (Section section : this.sections.values()) {
            l += section.getTime();
        }
        if (l == (0xDD37168DFB7D4438L ^ 0xDD37168DFB7D4438L)) {
            int n = this.phases.size();
            this.phases.set(n - (0x627F428 ^ 0x627F429), string);
            return;
        }
        this.phases.add(string);
        for (Section section : this.sections.values()) {
            section.mark();
        }
    }

    public Collection<Section> getSections() {
        return Collections.unmodifiableCollection(this.sections.values());
    }

    public PrettyPrinter printer(boolean bl, boolean bl2) {
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        int n = this.phases.size() + (0x4683CC73 ^ 0x4683CC77);
        int[] nArray = new int[0xDFC363F8 ^ 0xDFC363FD];
        nArray[0x7B65B5B8 ^ 0x7B65B5B8] = 0x8704A840 ^ 0x8704A840;
        nArray[0xC0EE801 ^ 0xC0EE800] = 0x27BC8DC0 ^ 0x27BC8DC1;
        nArray[0xFB120BB0 ^ 0xFB120BB2] = 0x384BBB93 ^ 0x384BBB91;
        nArray[0x82BD584F ^ 0x82BD584C] = n - (0xB23B803B ^ 0xB23B8039);
        nArray[0xF9555DC7 ^ 0xF9555DC3] = n - (0x1FAB1BF0 ^ 0x1FAB1BF1);
        int[] nArray2 = nArray;
        Object[] objectArray = new Object[n * (0xD5761B8C ^ 0xD5761B8E)];
        int n2 = 0x10EFE5CD ^ 0x10EFE5CD;
        int n3 = 0xC1BA5D98 ^ 0xC1BA5D98;
        while (n2 < n) {
            objectArray[n3 + (0xA15FB4BE ^ 0xA15FB4BF)] = PrettyPrinter.Alignment.RIGHT;
            if (n2 == nArray2[0x78CB9D3A ^ 0x78CB9D3A]) {
                objectArray[n3] = (bl2 ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7a6")) + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("A\ua7e3\ua4b6\ua065\ua90c\u7d79\u8e44");
                objectArray[n3 + (0xA0FDB89 ^ 0xA0FDB88)] = PrettyPrinter.Alignment.LEFT;
            } else {
                objectArray[n3] = n2 == nArray2[0xB951687 ^ 0xB951686] ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7a6\ua4f5\ua031\ua931\u7d59\u8e7e\u245b\u8b1b") : (n2 == nArray2[0x1D627E5D ^ 0x1D627E5E] ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7a6\ua4f5\ua031\ua926\u7d79\u8e5f\u2474\u8b23") : (n2 == nArray2[0x278C521E ^ 0x278C521A] ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("S\ua7f0\ua4b2\ua03f\ua945") : (n2 - nArray2[0x9CAFE53D ^ 0x9CAFE53F] < this.phases.size() ? this.phases.get(n2 - nArray2[0x2E995EBE ^ 0x2E995EBC]) : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(""))));
            }
            n3 = ++n2 * (0x10939A91 ^ 0x10939A93);
        }
        prettyPrinter.table(objectArray).th().hr().add();
        for (Section section : this.sections.values()) {
            if (section.isFine() && !bl || bl2 && section.getDelegate() != section) continue;
            this.printSectionRow(prettyPrinter, n, nArray2, section, bl2);
            if (!bl2) continue;
            for (Section section2 : this.sections.values()) {
                Section section3 = section2.getDelegate();
                if (section2.isFine() && !bl || section3 != section || section3 == section2) continue;
                this.printSectionRow(prettyPrinter, n, nArray2, section2, bl2);
            }
        }
        return prettyPrinter.add();
    }

    private void printSectionRow(PrettyPrinter prettyPrinter, int n, int[] nArray, Section section, boolean bl) {
        long[] lArray;
        int n2 = section.getDelegate() != section ? 0xF026548C ^ 0xF026548D : 0xAAAD9807 ^ 0xAAAD9807;
        Object[] objectArray = new Object[n];
        int n3 = 0xFF3DAB8F ^ 0xFF3DAB8E;
        if (bl) {
            objectArray[0xC48B6FBD ^ 0xC48B6FBD] = n2 != 0 ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7a6\ua4eb\ua031") + section.getBaseName() : section.getName();
        } else {
            objectArray[0x5FD9A5F6 ^ 0x5FD9A5F6] = (n2 != 0 ? \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("9\ua7a6") : \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7a6")) + section.getName();
        }
        long[] lArray2 = lArray = section.getTimes();
        int n4 = lArray2.length;
        for (int i = 0x1234BAE0 ^ 0x1234BAE0; i < n4; ++i) {
            long l = lArray2[i];
            if (n3 == nArray[0xA742EC9B ^ 0xA742EC9A]) {
                objectArray[n3++] = section.getTotalTime() + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7eb\ua4a6");
            }
            if (n3 < nArray[0xEECB0445 ^ 0xEECB0447] || n3 >= objectArray.length) continue;
            objectArray[n3++] = l + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7eb\ua4a6");
        }
        objectArray[nArray[0x8F88259A ^ 0x8F882599]] = section.getTotalCount();
        objectArray[nArray[0x57BD48EC ^ 0x57BD48E8]] = new DecimalFormat(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7a6\ua4f5\ua032\ua946\u7d35\u8e1a\u2434\u8b67\u3427\"\ua7a6\ua4b8\ua062")).format(section.getTotalAverageTime());
        for (int i = 0x1D0A8781 ^ 0x1D0A8781; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            objectArray[i] = \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("?");
        }
        prettyPrinter.tr(objectArray);
    }

    class SubSection
    extends LiveSection {
        private final String baseName;
        private final Section root;

        SubSection(String string, int n, String string2, Section section) {
            super(string, n);
            this.baseName = string2;
            this.root = section;
        }

        @Override
        Section invalidate() {
            this.root.invalidate();
            return super.invalidate();
        }

        @Override
        public String getBaseName() {
            return this.baseName;
        }

        @Override
        public void setInfo(String string) {
            this.root.setInfo(string);
            super.setInfo(string);
        }

        @Override
        Section getDelegate() {
            return this.root;
        }

        @Override
        Section start() {
            this.root.start();
            return super.start();
        }

        @Override
        public Section end() {
            this.root.stop();
            return super.end();
        }

        @Override
        public Section next(String string) {
            super.stop();
            return this.root.next(string);
        }
    }

    class LiveSection
    extends Section {
        private int cursor;
        private long[] times;
        private long start;
        private long time;
        private long markedTime;
        private int count;
        private int markedCount;

        LiveSection(String string, int n) {
            super(string);
            this.cursor = 0xF9902FDB ^ 0xF9902FDB;
            this.times = new long[0xBD0871A1 ^ 0xBD0871A1];
            this.start = 0xB26610B9931372EDL ^ 0xB26610B9931372EDL;
            this.cursor = n;
        }

        @Override
        Section start() {
            this.start = System.currentTimeMillis();
            return this;
        }

        @Override
        protected Section stop() {
            if (this.start > (0xB43B46FE7CA7AA9AL ^ 0xB43B46FE7CA7AA9AL)) {
                this.time += System.currentTimeMillis() - this.start;
            }
            this.start = 0x6E6C3C9E5FE84EB8L ^ 0x6E6C3C9E5FE84EB8L;
            this.count += 0xEB10476A ^ 0xEB10476B;
            return this;
        }

        @Override
        public Section end() {
            this.stop();
            if (!this.invalidated) {
                Profiler.this.end(this);
            }
            return this;
        }

        @Override
        void mark() {
            if (this.cursor >= this.times.length) {
                this.times = Arrays.copyOf(this.times, this.cursor + (0x9200C3FC ^ 0x9200C3F8));
            }
            this.times[this.cursor] = this.time;
            this.markedTime += this.time;
            this.markedCount += this.count;
            this.time = 0xE3991E9F140E72C1L ^ 0xE3991E9F140E72C1L;
            this.count = 0xB2B98522 ^ 0xB2B98522;
            this.cursor += 0xF0A15365 ^ 0xF0A15364;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public long getTotalTime() {
            return this.time + this.markedTime;
        }

        @Override
        public double getSeconds() {
            return (double)this.time * 0.001;
        }

        @Override
        public double getTotalSeconds() {
            return (double)(this.time + this.markedTime) * 0.001;
        }

        @Override
        public long[] getTimes() {
            long[] lArray = new long[this.cursor + (0x7D11FF0A ^ 0x7D11FF0B)];
            System.arraycopy(this.times, 0xED154D4D ^ 0xED154D4D, lArray, 0x390871D3 ^ 0x390871D3, Math.min(this.times.length, this.cursor));
            lArray[this.cursor] = this.time;
            return lArray;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public int getTotalCount() {
            return this.count + this.markedCount;
        }

        @Override
        public double getAverageTime() {
            return this.count > 0 ? (double)this.time / (double)this.count : 0.0;
        }

        @Override
        public double getTotalAverageTime() {
            return this.count > 0 ? (double)(this.time + this.markedTime) / (double)(this.count + this.markedCount) : 0.0;
        }
    }

    public class Section {
        static final String SEPARATOR_ROOT = " -> ";
        static final String SEPARATOR_CHILD = ".";
        private final String name;
        private boolean root;
        private boolean fine;
        protected boolean invalidated;
        private String info;

        Section(String string) {
            this.name = string;
            this.info = string;
        }

        Section getDelegate() {
            return this;
        }

        Section invalidate() {
            this.invalidated = 0x4E116968 ^ 0x4E116969;
            return this;
        }

        Section setRoot(boolean bl) {
            this.root = bl;
            return this;
        }

        public boolean isRoot() {
            return this.root;
        }

        Section setFine(boolean bl) {
            this.fine = bl;
            return this;
        }

        public boolean isFine() {
            return this.fine;
        }

        public String getName() {
            return this.name;
        }

        public String getBaseName() {
            return this.name;
        }

        public void setInfo(String string) {
            this.info = string;
        }

        public String getInfo() {
            return this.info;
        }

        Section start() {
            return this;
        }

        protected Section stop() {
            return this;
        }

        public Section end() {
            if (!this.invalidated) {
                Profiler.this.end(this);
            }
            return this;
        }

        public Section next(String string) {
            this.end();
            return Profiler.this.begin(string);
        }

        void mark() {
        }

        public long getTime() {
            return 0x7FBC8DE3250B144EL ^ 0x7FBC8DE3250B144EL;
        }

        public long getTotalTime() {
            return 0x26459EB449F3146BL ^ 0x26459EB449F3146BL;
        }

        public double getSeconds() {
            return 0.0;
        }

        public double getTotalSeconds() {
            return 0.0;
        }

        public long[] getTimes() {
            return new long[0x5E345C46 ^ 0x5E345C47];
        }

        public int getCount() {
            return 0x18D7F4ED ^ 0x18D7F4ED;
        }

        public int getTotalCount() {
            return 0xB86BA19B ^ 0xB86BA19B;
        }

        public double getAverageTime() {
            return 0.0;
        }

        public double getTotalAverageTime() {
            return 0.0;
        }

        public final String toString() {
            return this.name;
        }
    }
}

