/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.tools.obfuscation.AnnotatedMixins;
import org.spongepowered.tools.obfuscation.SupportedOptions;

public abstract class MixinObfuscationProcessor
extends AbstractProcessor {
    protected AnnotatedMixins mixins;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.mixins = AnnotatedMixins.getMixinsForEnvironment(processingEnvironment);
    }

    protected void processMixins(RoundEnvironment roundEnvironment) {
        this.mixins.onPassStarted();
        for (Element element : roundEnvironment.getElementsAnnotatedWith(Mixin.class)) {
            if (element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.INTERFACE) {
                this.mixins.registerMixin((TypeElement)element);
                continue;
            }
            this.mixins.printMessage(Diagnostic.Kind.ERROR, \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("T\ua7e9\ua4a0\ua07f\ua901\u7d36\u8e4b\u2474\u8b77\u3457_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e4b\u2474\u8b39\u3478f\ua7e7\ua4a1\ua078\ua90a\u7d78\u8e0a\u2475\u8b39\u3437s\ua7e8\ua4f5\ua074\ua909\u7d73\u8e47\u247f\u8b39\u34632\ua7f1\ua4bd\ua078\ua906\u7d7e\u8e0a\u2473\u8b24\u3437|\ua7e9\ua4a1\ua031\ua904\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4ba\ua063\ua945\u7d7f\u8e44\u246e\u8b32\u3465t\ua7e7\ua4b6\ua074"), element);
        }
    }

    protected void postProcess(RoundEnvironment roundEnvironment) {
        this.mixins.onPassCompleted(roundEnvironment);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        try {
            return SourceVersion.valueOf(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("@\ua7c3\ua499\ua054\ua924\u7d45\u8e6f\u2445\u8b6f"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.getSupportedSourceVersion();
        }
    }

    @Override
    public Set<String> getSupportedOptions() {
        return SupportedOptions.getAllOptions();
    }
}

