/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.tools.obfuscation.ObfuscationEnvironment;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IOptionProvider;
import org.spongepowered.tools.obfuscation.service.ObfuscationTypeDescriptor;

public final class ObfuscationType {
    private static final Map<String, ObfuscationType> types = new LinkedHashMap<String, ObfuscationType>();
    private final String key;
    private final ObfuscationTypeDescriptor descriptor;
    private final IMixinAnnotationProcessor ap;
    private final IOptionProvider options;

    private ObfuscationType(ObfuscationTypeDescriptor obfuscationTypeDescriptor, IMixinAnnotationProcessor iMixinAnnotationProcessor) {
        this.key = obfuscationTypeDescriptor.getKey();
        this.descriptor = obfuscationTypeDescriptor;
        this.ap = iMixinAnnotationProcessor;
        this.options = iMixinAnnotationProcessor;
    }

    public final ObfuscationEnvironment createEnvironment() {
        try {
            Class<? extends ObfuscationEnvironment> clazz = this.descriptor.getEnvironmentType();
            Class[] classArray = new Class[0x46587618 ^ 0x46587619];
            classArray[0xAE74F5E4 ^ 0xAE74F5E4] = ObfuscationType.class;
            Constructor<? extends ObfuscationEnvironment> constructor = clazz.getDeclaredConstructor(classArray);
            constructor.setAccessible((0x7F143CA1 ^ 0x7F143CA0) != 0);
            Object[] objectArray = new Object[0xE58EAEA6 ^ 0xE58EAEA7];
            objectArray[0x47E96F6A ^ 0x47E96F6A] = this;
            return constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String toString() {
        return this.key;
    }

    public String getKey() {
        return this.key;
    }

    public ObfuscationTypeDescriptor getConfig() {
        return this.descriptor;
    }

    public IMixinAnnotationProcessor getAnnotationProcessor() {
        return this.ap;
    }

    public boolean isDefault() {
        String string = this.options.getOption(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("v\ua7e3\ua4b3\ua070\ua910\u7d7a\u8e5e\u2455\u8b35\u3471g\ua7f5\ua4b6\ua070\ua911\u7d7f\u8e45\u2474\u8b12\u3479d"));
        return (string == null && this.key.equals(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("a\ua7e3\ua4b4\ua063\ua902\u7d73")) || string != null && this.key.equals(string.toLowerCase()) ? 0x87B22C50 ^ 0x87B22C51 : 0xC7D8A84B ^ 0xC7D8A84B) != 0;
    }

    public boolean isSupported() {
        return (this.getInputFileNames().size() > 0 ? 0xA18A1863 ^ 0xA18A1862 : 0xC5C80AF9 ^ 0xC5C80AF9) != 0;
    }

    public List<String> getInputFileNames() {
        String string;
        ImmutableList.Builder builder = ImmutableList.builder();
        String string2 = this.options.getOption(this.descriptor.getInputFileOption());
        if (string2 != null) {
            builder.add((Object)string2);
        }
        if ((string = this.options.getOption(this.descriptor.getExtraInputFilesOption())) != null) {
            String[] stringArray = string.split(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462(")"));
            int n = stringArray.length;
            for (int i = 0xE1E91042 ^ 0xE1E91042; i < n; ++i) {
                String string3 = stringArray[i];
                builder.add((Object)string3.trim());
            }
        }
        return builder.build();
    }

    public String getOutputFileName() {
        return this.options.getOption(this.descriptor.getOutputFileOption());
    }

    public static Iterable<ObfuscationType> types() {
        return types.values();
    }

    public static ObfuscationType create(ObfuscationTypeDescriptor obfuscationTypeDescriptor, IMixinAnnotationProcessor iMixinAnnotationProcessor) {
        String string = obfuscationTypeDescriptor.getKey();
        if (types.containsKey(string)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("]\ua7e4\ua4b3\ua064\ua916\u7d75\u8e4b\u246e\u8b3e\u3478|\ua7a6\ua4a1\ua068\ua915\u7d73\u8e0a\u246d\u8b3e\u3463z\ua7a6\ua4be\ua074\ua91c\u7d36") + string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7f1\ua4b4\ua062\ua945\u7d77\u8e46\u2468\u8b32\u3476v\ua7ff\ua4f5\ua063\ua900\u7d71\u8e43\u2469\u8b23\u3472`\ua7e3\ua4b1"));
        }
        ObfuscationType obfuscationType = new ObfuscationType(obfuscationTypeDescriptor, iMixinAnnotationProcessor);
        types.put(string, obfuscationType);
        return obfuscationType;
    }

    public static ObfuscationType get(String string) {
        ObfuscationType obfuscationType = types.get(string);
        if (obfuscationType == null) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("]\ua7e4\ua4b3\ua064\ua916\u7d75\u8e4b\u246e\u8b3e\u3478|\ua7a6\ua4a1\ua068\ua915\u7d73\u8e0a\u246d\u8b3e\u3463z\ua7a6\ua4be\ua074\ua91c\u7d36") + string + \u7eb3\u897f\u59b2.\u4ed6\u773c\u4e2d\u6240\u89c1\u7684\u7a76\u7adf\u662f\u6ee1\u8db3\u8fd8\u662f\u66f4\u5927\u7684\u7a7a\u865a\u5462("2\ua7f1\ua4b4\ua062\ua945\u7d78\u8e45\u246e\u8b77\u3465w\ua7e1\ua4bc\ua062\ua911\u7d73\u8e58\u247f\u8b33"));
        }
        return obfuscationType;
    }
}

