/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib;

final class Item {
    int index;
    int type;
    int intVal;
    long longVal;
    String strVal1;
    String strVal2;
    String strVal3;
    int hashCode;
    Item next;

    Item() {
    }

    Item(int n) {
        this.index = n;
    }

    Item(int n, Item item) {
        this.index = n;
        this.type = item.type;
        this.intVal = item.intVal;
        this.longVal = item.longVal;
        this.strVal1 = item.strVal1;
        this.strVal2 = item.strVal2;
        this.strVal3 = item.strVal3;
        this.hashCode = item.hashCode;
    }

    void set(int n) {
        this.type = 0x3390414F ^ 0x3390414C;
        this.intVal = n;
        this.hashCode = (0x80B63EE6 ^ 0xFF49C119) & this.type + n;
    }

    void set(long l) {
        this.type = 0xF1DE96CF ^ 0xF1DE96CA;
        this.longVal = l;
        this.hashCode = (0x7E515AB8 ^ 0x1AEA547) & this.type + (int)l;
    }

    void set(float f) {
        this.type = 0x7A49EEF9 ^ 0x7A49EEFD;
        this.intVal = Float.floatToRawIntBits(f);
        this.hashCode = (0x47CCE649 ^ 0x383319B6) & this.type + (int)f;
    }

    void set(double d) {
        this.type = 0x504E84F8 ^ 0x504E84FE;
        this.longVal = Double.doubleToRawLongBits(d);
        this.hashCode = (0x27234F04 ^ 0x58DCB0FB) & this.type + (int)d;
    }

    void set(int n, String string, String string2, String string3) {
        this.type = n;
        this.strVal1 = string;
        this.strVal2 = string2;
        this.strVal3 = string3;
        switch (n) {
            case 7: {
                this.intVal = 0xA928D872 ^ 0xA928D872;
            }
            case 1: 
            case 8: 
            case 16: 
            case 30: {
                this.hashCode = (0xE8178C16 ^ 0x97E873E9) & n + string.hashCode();
                return;
            }
            case 12: {
                this.hashCode = (0x224AF65F ^ 0x5DB509A0) & n + string.hashCode() * string2.hashCode();
                return;
            }
        }
        this.hashCode = (0x8CE4403D ^ 0xF31BBFC2) & n + string.hashCode() * string2.hashCode() * string3.hashCode();
    }

    void set(String string, String string2, int n) {
        this.type = 0x489C5E7B ^ 0x489C5E69;
        this.longVal = n;
        this.strVal1 = string;
        this.strVal2 = string2;
        this.hashCode = (0x202552AC ^ 0x5FDAAD53) & (0xC78EF3E7 ^ 0xC78EF3F5) + n * this.strVal1.hashCode() * this.strVal2.hashCode();
    }

    void set(int n, int n2) {
        this.type = 0x4CC1FF7 ^ 0x4CC1FD6;
        this.intVal = n;
        this.hashCode = n2;
    }

    boolean isEqualTo(Item item) {
        switch (this.type) {
            case 1: 
            case 7: 
            case 8: 
            case 16: 
            case 30: {
                return item.strVal1.equals(this.strVal1);
            }
            case 5: 
            case 6: 
            case 32: {
                return (item.longVal == this.longVal ? 0x379D3A57 ^ 0x379D3A56 : 0x6997258B ^ 0x6997258B) != 0;
            }
            case 3: 
            case 4: {
                return (item.intVal == this.intVal ? 0xFB0EC166 ^ 0xFB0EC167 : 0xFAE3D620 ^ 0xFAE3D620) != 0;
            }
            case 31: {
                return (item.intVal == this.intVal && item.strVal1.equals(this.strVal1) ? 0x1306ACFB ^ 0x1306ACFA : 0x43A38190 ^ 0x43A38190) != 0;
            }
            case 12: {
                return (item.strVal1.equals(this.strVal1) && item.strVal2.equals(this.strVal2) ? 0x2017DCA1 ^ 0x2017DCA0 : 0xFED02973 ^ 0xFED02973) != 0;
            }
            case 18: {
                return (item.longVal == this.longVal && item.strVal1.equals(this.strVal1) && item.strVal2.equals(this.strVal2) ? 0x39E16AC3 ^ 0x39E16AC2 : 0xA737B702 ^ 0xA737B702) != 0;
            }
        }
        return (item.strVal1.equals(this.strVal1) && item.strVal2.equals(this.strVal2) && item.strVal3.equals(this.strVal3) ? 0x917ABECA ^ 0x917ABECB : 0x6C3366C1 ^ 0x6C3366C1) != 0;
    }
}

