/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib;

import org.spongepowered.asm.lib.ByteVector;

public class TypePath {
    public static final int ARRAY_ELEMENT = 0;
    public static final int INNER_TYPE = 1;
    public static final int WILDCARD_BOUND = 2;
    public static final int TYPE_ARGUMENT = 3;
    byte[] b;
    int offset;

    TypePath(byte[] byArray, int n) {
        this.b = byArray;
        this.offset = n;
    }

    public int getLength() {
        return this.b[this.offset];
    }

    public int getStep(int n) {
        return this.b[this.offset + (0xE4502A30 ^ 0xE4502A32) * n + (0x8C7D91FA ^ 0x8C7D91FB)];
    }

    public int getStepArgument(int n) {
        return this.b[this.offset + (0xE6F95069 ^ 0xE6F9506B) * n + (0xFF9B70B5 ^ 0xFF9B70B7)];
    }

    public static TypePath fromString(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.length();
        ByteVector byteVector = new ByteVector(n);
        byteVector.putByte(0x14ED613A ^ 0x14ED613A);
        int n2 = 0xE94371DD ^ 0xE94371DD;
        while (n2 < n) {
            char c = string.charAt(n2++);
            if (c == (0x610AB189 ^ 0x610AB1D2)) {
                byteVector.put11(0xB16C2DFA ^ 0xB16C2DFA, 0xDCB5052 ^ 0xDCB5052);
                continue;
            }
            if (c == (0xF7AEF603 ^ 0xF7AEF62D)) {
                byteVector.put11(0x37718463 ^ 0x37718462, 0x3DF7922C ^ 0x3DF7922C);
                continue;
            }
            if (c == (0x692C8D62 ^ 0x692C8D48)) {
                byteVector.put11(0xE7BC8B71 ^ 0xE7BC8B73, 0xFC423FF0 ^ 0xFC423FF0);
                continue;
            }
            if (c < (0x66BE5C50 ^ 0x66BE5C60)) continue;
            if (c > (0xB890B3D4 ^ 0xB890B3ED)) continue;
            int n3 = c - (0xF247C54 ^ 0xF247C64);
            while (n2 < n) {
                c = string.charAt(n2);
                if (c < (0x9956F0B1 ^ 0x9956F081)) break;
                if (c > (0x20E6423A ^ 0x20E64203)) break;
                n3 = n3 * (0x6BC476C5 ^ 0x6BC476CF) + c - (0x10D9EA1B ^ 0x10D9EA2B);
                ++n2;
            }
            if (n2 < n) {
                if (string.charAt(n2) == (0xA7D182B ^ 0xA7D1810)) {
                    ++n2;
                }
            }
            byteVector.put11(0xF0C82C99 ^ 0xF0C82C9A, n3);
        }
        byteVector.data[0xD2BBF92E ^ 0xD2BBF92E] = (byte)(byteVector.length / (0xBC216299 ^ 0xBC21629B));
        return new TypePath(byteVector.data, 0xE354A265 ^ 0xE354A265);
    }

    public String toString() {
        int n = this.getLength();
        StringBuilder stringBuilder = new StringBuilder(n * (0x2BC012FA ^ 0x2BC012F8));
        block6: for (int i = 0x97C9F0E ^ 0x97C9F0E; i < n; ++i) {
            switch (this.getStep(i)) {
                case 0: {
                    stringBuilder.append((char)(0x7A737E83 ^ 0x7A737ED8));
                    continue block6;
                }
                case 1: {
                    stringBuilder.append((char)(0xAE603B16 ^ 0xAE603B38));
                    continue block6;
                }
                case 2: {
                    stringBuilder.append((char)(0x874B9171 ^ 0x874B915B));
                    continue block6;
                }
                case 3: {
                    stringBuilder.append(this.getStepArgument(i)).append((char)(0x9379355D ^ 0x93793566));
                    continue block6;
                }
                default: {
                    stringBuilder.append((char)(0x86774679 ^ 0x86774626));
                }
            }
        }
        return stringBuilder.toString();
    }
}

