/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.signature;

import org.spongepowered.asm.lib.signature.SignatureVisitor;

public class SignatureWriter
extends SignatureVisitor {
    private final StringBuilder buf = new StringBuilder();
    private boolean hasFormals;
    private boolean hasParameters;
    private int argumentStack;

    public SignatureWriter() {
        super(0x8C083799 ^ 0x8C0D3799);
    }

    public void visitFormalTypeParameter(String string) {
        if (!this.hasFormals) {
            this.hasFormals = 0xE252876C ^ 0xE252876D;
            this.buf.append((char)(0x7856A6C7 ^ 0x7856A6FB));
        }
        this.buf.append(string);
        this.buf.append((char)(0xD4000BEB ^ 0xD4000BD1));
    }

    public SignatureVisitor visitClassBound() {
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        this.buf.append((char)(0xC2CA8DE9 ^ 0xC2CA8DD3));
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        this.endFormals();
        return this;
    }

    public SignatureVisitor visitInterface() {
        return this;
    }

    public SignatureVisitor visitParameterType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.hasParameters = 0x2634C552 ^ 0x2634C553;
            this.buf.append((char)(0x67A5F151 ^ 0x67A5F179));
        }
        return this;
    }

    public SignatureVisitor visitReturnType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.buf.append((char)(0x2874AC43 ^ 0x2874AC6B));
        }
        this.buf.append((char)(0xACE1F2D5 ^ 0xACE1F2FC));
        return this;
    }

    public SignatureVisitor visitExceptionType() {
        this.buf.append((char)(0x391E588E ^ 0x391E58D0));
        return this;
    }

    public void visitBaseType(char c) {
        this.buf.append(c);
    }

    public void visitTypeVariable(String string) {
        this.buf.append((char)(0xD3BE39BF ^ 0xD3BE39EB));
        this.buf.append(string);
        this.buf.append((char)(0x67C83670 ^ 0x67C8364B));
    }

    public SignatureVisitor visitArrayType() {
        this.buf.append((char)(0x7433F82E ^ 0x7433F875));
        return this;
    }

    public void visitClassType(String string) {
        this.buf.append((char)(0x4AD08B3A ^ 0x4AD08B76));
        this.buf.append(string);
        this.argumentStack *= 0xA75B4591 ^ 0xA75B4593;
    }

    public void visitInnerClassType(String string) {
        this.endArguments();
        this.buf.append((char)(0xC0E2A170 ^ 0xC0E2A15E));
        this.buf.append(string);
        this.argumentStack *= 0xC2D38C81 ^ 0xC2D38C83;
    }

    public void visitTypeArgument() {
        if (this.argumentStack % (0xA9293A75 ^ 0xA9293A77) == 0) {
            this.argumentStack += 0x5C9C509A ^ 0x5C9C509B;
            this.buf.append((char)(0x99593794 ^ 0x995937A8));
        }
        this.buf.append((char)(0x4755F93C ^ 0x4755F916));
    }

    public SignatureVisitor visitTypeArgument(char c) {
        if (this.argumentStack % (0xF69A2859 ^ 0xF69A285B) == 0) {
            this.argumentStack += 0x5EDFADA1 ^ 0x5EDFADA0;
            this.buf.append((char)(0x573C7F6A ^ 0x573C7F56));
        }
        if (c != (0x654960E ^ 0x6549633)) {
            this.buf.append(c);
        }
        return this;
    }

    public void visitEnd() {
        this.endArguments();
        this.buf.append((char)(0x2A3E0AB3 ^ 0x2A3E0A88));
    }

    public String toString() {
        return this.buf.toString();
    }

    private void endFormals() {
        if (this.hasFormals) {
            this.hasFormals = 0x2B7C6C95 ^ 0x2B7C6C95;
            this.buf.append((char)(0x3D209741 ^ 0x3D20977F));
        }
    }

    private void endArguments() {
        if (this.argumentStack % (0x1D330D5B ^ 0x1D330D59) != 0) {
            this.buf.append((char)(0x9515988D ^ 0x951598B3));
        }
        this.argumentStack /= 0xBC5C6AD6 ^ 0xBC5C6AD4;
    }
}

