/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameNode
extends AbstractInsnNode {
    public int type;
    public List<Object> local;
    public List<Object> stack;

    private FrameNode() {
        super(0x81D9ED74 ^ 0x7E26128B);
    }

    public FrameNode(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        super(0x4BB0BF49 ^ 0xB44F40B6);
        this.type = n;
        switch (n) {
            case -1: 
            case 0: {
                this.local = FrameNode.asList(n2, objectArray);
                this.stack = FrameNode.asList(n3, objectArray2);
                break;
            }
            case 1: {
                this.local = FrameNode.asList(n2, objectArray);
                break;
            }
            case 2: {
                this.local = Arrays.asList(new Object[n2]);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.stack = FrameNode.asList(0xAC822F07 ^ 0xAC822F06, objectArray2);
            }
        }
    }

    @Override
    public int getType() {
        return 0x439D5659 ^ 0x439D5657;
    }

    @Override
    public void accept(MethodVisitor methodVisitor) {
        switch (this.type) {
            case -1: 
            case 0: {
                methodVisitor.visitFrame(this.type, this.local.size(), FrameNode.asArray(this.local), this.stack.size(), FrameNode.asArray(this.stack));
                break;
            }
            case 1: {
                methodVisitor.visitFrame(this.type, this.local.size(), FrameNode.asArray(this.local), 0xCA776A71 ^ 0xCA776A71, null);
                break;
            }
            case 2: {
                methodVisitor.visitFrame(this.type, this.local.size(), null, 0x574D9C49 ^ 0x574D9C49, null);
                break;
            }
            case 3: {
                methodVisitor.visitFrame(this.type, 0x4473F8FF ^ 0x4473F8FF, null, 0xAEF1F48A ^ 0xAEF1F48A, null);
                break;
            }
            case 4: {
                methodVisitor.visitFrame(this.type, 0xA41F1967 ^ 0xA41F1967, null, 0x1FB3B279 ^ 0x1FB3B278, FrameNode.asArray(this.stack));
            }
        }
    }

    @Override
    public AbstractInsnNode clone(Map<LabelNode, LabelNode> map) {
        Object object;
        int n;
        FrameNode frameNode = new FrameNode();
        frameNode.type = this.type;
        if (this.local != null) {
            frameNode.local = new ArrayList<Object>();
            for (n = 0x56E5A889 ^ 0x56E5A889; n < this.local.size(); ++n) {
                object = this.local.get(n);
                if (object instanceof LabelNode) {
                    object = map.get(object);
                }
                frameNode.local.add(object);
            }
        }
        if (this.stack != null) {
            frameNode.stack = new ArrayList<Object>();
            for (n = 0x3A3D7ED2 ^ 0x3A3D7ED2; n < this.stack.size(); ++n) {
                object = this.stack.get(n);
                if (object instanceof LabelNode) {
                    object = map.get(object);
                }
                frameNode.stack.add(object);
            }
        }
        return frameNode;
    }

    private static List<Object> asList(int n, Object[] objectArray) {
        return Arrays.asList(objectArray).subList(0x337B1890 ^ 0x337B1890, n);
    }

    private static Object[] asArray(List<Object> list) {
        Object[] objectArray = new Object[list.size()];
        for (int i = 0xE986C3D9 ^ 0xE986C3D9; i < objectArray.length; ++i) {
            Object object = list.get(i);
            if (object instanceof LabelNode) {
                object = ((LabelNode)object).getLabel();
            }
            objectArray[i] = object;
        }
        return objectArray;
    }
}

