/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.spongepowered.asm.lib.AnnotationVisitor;
import org.spongepowered.asm.lib.Attribute;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.Handle;
import org.spongepowered.asm.lib.Label;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.TypePath;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FrameNode;
import org.spongepowered.asm.lib.tree.IincInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.IntInsnNode;
import org.spongepowered.asm.lib.tree.InvokeDynamicInsnNode;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.LineNumberNode;
import org.spongepowered.asm.lib.tree.LocalVariableAnnotationNode;
import org.spongepowered.asm.lib.tree.LocalVariableNode;
import org.spongepowered.asm.lib.tree.LookupSwitchInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MultiANewArrayInsnNode;
import org.spongepowered.asm.lib.tree.ParameterNode;
import org.spongepowered.asm.lib.tree.TableSwitchInsnNode;
import org.spongepowered.asm.lib.tree.TryCatchBlockNode;
import org.spongepowered.asm.lib.tree.TypeAnnotationNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;

public class MethodNode
extends MethodVisitor {
    public int access;
    public String name;
    public String desc;
    public String signature;
    public List<String> exceptions;
    public List<ParameterNode> parameters;
    public List<AnnotationNode> visibleAnnotations;
    public List<AnnotationNode> invisibleAnnotations;
    public List<TypeAnnotationNode> visibleTypeAnnotations;
    public List<TypeAnnotationNode> invisibleTypeAnnotations;
    public List<Attribute> attrs;
    public Object annotationDefault;
    public List<AnnotationNode>[] visibleParameterAnnotations;
    public List<AnnotationNode>[] invisibleParameterAnnotations;
    public InsnList instructions;
    public List<TryCatchBlockNode> tryCatchBlocks;
    public int maxStack;
    public int maxLocals;
    public List<LocalVariableNode> localVariables;
    public List<LocalVariableAnnotationNode> visibleLocalVariableAnnotations;
    public List<LocalVariableAnnotationNode> invisibleLocalVariableAnnotations;
    private boolean visited;

    public MethodNode() {
        this(0x286F9AAC ^ 0x286A9AAC);
        if (this.getClass() != MethodNode.class) {
            throw new IllegalStateException();
        }
    }

    public MethodNode(int n) {
        super(n);
        this.instructions = new InsnList();
    }

    public MethodNode(int n, String string, String string2, String string3, String[] stringArray) {
        this(0xCC800223 ^ 0xCC850223, n, string, string2, string3, stringArray);
        if (this.getClass() != MethodNode.class) {
            throw new IllegalStateException();
        }
    }

    public MethodNode(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        super(n);
        int n3;
        this.access = n2;
        this.name = string;
        this.desc = string2;
        this.signature = string3;
        this.exceptions = new ArrayList<String>(stringArray == null ? 0x7EAC7419 ^ 0x7EAC7419 : stringArray.length);
        int n4 = (n2 & (0x4B1450B2 ^ 0x4B1454B2)) != 0 ? 0x1E5BADF5 ^ 0x1E5BADF4 : (n3 = 0xC457D153 ^ 0xC457D153);
        if (n3 == 0) {
            this.localVariables = new ArrayList<LocalVariableNode>(0x81BC817F ^ 0x81BC817A);
        }
        this.tryCatchBlocks = new ArrayList<TryCatchBlockNode>();
        if (stringArray != null) {
            this.exceptions.addAll(Arrays.asList(stringArray));
        }
        this.instructions = new InsnList();
    }

    public void visitParameter(String string, int n) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParameterNode>(0xB43E6688 ^ 0xB43E668D);
        }
        this.parameters.add(new ParameterNode(string, n));
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return new AnnotationNode((List<Object>)new ArrayList<Object>(0x983C64A0 ^ 0x983C64A0){

            @Override
            public boolean add(Object object) {
                MethodNode.this.annotationDefault = object;
                return super.add(object);
            }
        });
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        AnnotationNode annotationNode = new AnnotationNode(string);
        if (bl) {
            if (this.visibleAnnotations == null) {
                this.visibleAnnotations = new ArrayList<AnnotationNode>(0xC09FE6C0 ^ 0xC09FE6C1);
            }
            this.visibleAnnotations.add(annotationNode);
        } else {
            if (this.invisibleAnnotations == null) {
                this.invisibleAnnotations = new ArrayList<AnnotationNode>(0xF16BF8A3 ^ 0xF16BF8A2);
            }
            this.invisibleAnnotations.add(annotationNode);
        }
        return annotationNode;
    }

    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        TypeAnnotationNode typeAnnotationNode = new TypeAnnotationNode(n, typePath, string);
        if (bl) {
            if (this.visibleTypeAnnotations == null) {
                this.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0x5F478674 ^ 0x5F478675);
            }
            this.visibleTypeAnnotations.add(typeAnnotationNode);
        } else {
            if (this.invisibleTypeAnnotations == null) {
                this.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0xA96EBC92 ^ 0xA96EBC93);
            }
            this.invisibleTypeAnnotations.add(typeAnnotationNode);
        }
        return typeAnnotationNode;
    }

    public AnnotationVisitor visitParameterAnnotation(int n, String string, boolean bl) {
        AnnotationNode annotationNode = new AnnotationNode(string);
        if (bl) {
            if (this.visibleParameterAnnotations == null) {
                int n2 = Type.getArgumentTypes(this.desc).length;
                this.visibleParameterAnnotations = new List[n2];
            }
            if (this.visibleParameterAnnotations[n] == null) {
                this.visibleParameterAnnotations[n] = new ArrayList<AnnotationNode>(0x541D4F2E ^ 0x541D4F2F);
            }
            this.visibleParameterAnnotations[n].add(annotationNode);
        } else {
            if (this.invisibleParameterAnnotations == null) {
                int n3 = Type.getArgumentTypes(this.desc).length;
                this.invisibleParameterAnnotations = new List[n3];
            }
            if (this.invisibleParameterAnnotations[n] == null) {
                this.invisibleParameterAnnotations[n] = new ArrayList<AnnotationNode>(0x5BE011C7 ^ 0x5BE011C6);
            }
            this.invisibleParameterAnnotations[n].add(annotationNode);
        }
        return annotationNode;
    }

    public void visitAttribute(Attribute attribute) {
        if (this.attrs == null) {
            this.attrs = new ArrayList<Attribute>(0xF2CB4F68 ^ 0xF2CB4F69);
        }
        this.attrs.add(attribute);
    }

    public void visitCode() {
    }

    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        this.instructions.add(new FrameNode(n, n2, objectArray == null ? null : this.getLabelNodes(objectArray), n3, objectArray2 == null ? null : this.getLabelNodes(objectArray2)));
    }

    public void visitInsn(int n) {
        this.instructions.add(new InsnNode(n));
    }

    public void visitIntInsn(int n, int n2) {
        this.instructions.add(new IntInsnNode(n, n2));
    }

    public void visitVarInsn(int n, int n2) {
        this.instructions.add(new VarInsnNode(n, n2));
    }

    public void visitTypeInsn(int n, String string) {
        this.instructions.add(new TypeInsnNode(n, string));
    }

    public void visitFieldInsn(int n, String string, String string2, String string3) {
        this.instructions.add(new FieldInsnNode(n, string, string2, string3));
    }

    @Deprecated
    public void visitMethodInsn(int n, String string, String string2, String string3) {
        if (this.api >= (0xF288D209 ^ 0xF28DD209)) {
            super.visitMethodInsn(n, string, string2, string3);
            return;
        }
        this.instructions.add(new MethodInsnNode(n, string, string2, string3));
    }

    public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
        if (this.api < (0xDDF25228 ^ 0xDDF75228)) {
            super.visitMethodInsn(n, string, string2, string3, bl);
            return;
        }
        this.instructions.add(new MethodInsnNode(n, string, string2, string3, bl));
    }

    public void visitInvokeDynamicInsn(String string, String string2, Handle handle, Object ... objectArray) {
        this.instructions.add(new InvokeDynamicInsnNode(string, string2, handle, objectArray));
    }

    public void visitJumpInsn(int n, Label label) {
        this.instructions.add(new JumpInsnNode(n, this.getLabelNode(label)));
    }

    public void visitLabel(Label label) {
        this.instructions.add(this.getLabelNode(label));
    }

    public void visitLdcInsn(Object object) {
        this.instructions.add(new LdcInsnNode(object));
    }

    public void visitIincInsn(int n, int n2) {
        this.instructions.add(new IincInsnNode(n, n2));
    }

    public void visitTableSwitchInsn(int n, int n2, Label label, Label ... labelArray) {
        this.instructions.add(new TableSwitchInsnNode(n, n2, this.getLabelNode(label), this.getLabelNodes(labelArray)));
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.instructions.add(new LookupSwitchInsnNode(this.getLabelNode(label), nArray, this.getLabelNodes(labelArray)));
    }

    public void visitMultiANewArrayInsn(String string, int n) {
        this.instructions.add(new MultiANewArrayInsnNode(string, n));
    }

    public AnnotationVisitor visitInsnAnnotation(int n, TypePath typePath, String string, boolean bl) {
        AbstractInsnNode abstractInsnNode = this.instructions.getLast();
        while (true) {
            if (abstractInsnNode.getOpcode() != (0x7E07CF64 ^ 0x81F8309B)) break;
            abstractInsnNode = abstractInsnNode.getPrevious();
        }
        TypeAnnotationNode typeAnnotationNode = new TypeAnnotationNode(n, typePath, string);
        if (bl) {
            if (abstractInsnNode.visibleTypeAnnotations == null) {
                abstractInsnNode.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0x89117CA2 ^ 0x89117CA3);
            }
            abstractInsnNode.visibleTypeAnnotations.add(typeAnnotationNode);
        } else {
            if (abstractInsnNode.invisibleTypeAnnotations == null) {
                abstractInsnNode.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0xE063B19E ^ 0xE063B19F);
            }
            abstractInsnNode.invisibleTypeAnnotations.add(typeAnnotationNode);
        }
        return typeAnnotationNode;
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.tryCatchBlocks.add(new TryCatchBlockNode(this.getLabelNode(label), this.getLabelNode(label2), this.getLabelNode(label3), string));
    }

    public AnnotationVisitor visitTryCatchAnnotation(int n, TypePath typePath, String string, boolean bl) {
        TryCatchBlockNode tryCatchBlockNode = this.tryCatchBlocks.get((n & (0x403B2ACC ^ 0x40C4D5CC)) >> (0x1A490128 ^ 0x1A490120));
        TypeAnnotationNode typeAnnotationNode = new TypeAnnotationNode(n, typePath, string);
        if (bl) {
            if (tryCatchBlockNode.visibleTypeAnnotations == null) {
                tryCatchBlockNode.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0x6219C34D ^ 0x6219C34C);
            }
            tryCatchBlockNode.visibleTypeAnnotations.add(typeAnnotationNode);
        } else {
            if (tryCatchBlockNode.invisibleTypeAnnotations == null) {
                tryCatchBlockNode.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0x6840DAE4 ^ 0x6840DAE5);
            }
            tryCatchBlockNode.invisibleTypeAnnotations.add(typeAnnotationNode);
        }
        return typeAnnotationNode;
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        this.localVariables.add(new LocalVariableNode(string, string2, string3, this.getLabelNode(label), this.getLabelNode(label2), n));
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int n, TypePath typePath, Label[] labelArray, Label[] labelArray2, int[] nArray, String string, boolean bl) {
        LocalVariableAnnotationNode localVariableAnnotationNode = new LocalVariableAnnotationNode(n, typePath, this.getLabelNodes(labelArray), this.getLabelNodes(labelArray2), nArray, string);
        if (bl) {
            if (this.visibleLocalVariableAnnotations == null) {
                this.visibleLocalVariableAnnotations = new ArrayList<LocalVariableAnnotationNode>(0x4EB692F1 ^ 0x4EB692F0);
            }
            this.visibleLocalVariableAnnotations.add(localVariableAnnotationNode);
        } else {
            if (this.invisibleLocalVariableAnnotations == null) {
                this.invisibleLocalVariableAnnotations = new ArrayList<LocalVariableAnnotationNode>(0xB0980CC7 ^ 0xB0980CC6);
            }
            this.invisibleLocalVariableAnnotations.add(localVariableAnnotationNode);
        }
        return localVariableAnnotationNode;
    }

    public void visitLineNumber(int n, Label label) {
        this.instructions.add(new LineNumberNode(n, this.getLabelNode(label)));
    }

    public void visitMaxs(int n, int n2) {
        this.maxStack = n;
        this.maxLocals = n2;
    }

    public void visitEnd() {
    }

    protected LabelNode getLabelNode(Label label) {
        if (!(label.info instanceof LabelNode)) {
            label.info = new LabelNode();
        }
        return (LabelNode)label.info;
    }

    private LabelNode[] getLabelNodes(Label[] labelArray) {
        LabelNode[] labelNodeArray = new LabelNode[labelArray.length];
        for (int i = 0xA80EB426 ^ 0xA80EB426; i < labelArray.length; ++i) {
            labelNodeArray[i] = this.getLabelNode(labelArray[i]);
        }
        return labelNodeArray;
    }

    private Object[] getLabelNodes(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0x78B73246 ^ 0x78B73246; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof Label) {
                object = this.getLabelNode((Label)object);
            }
            objectArray2[i] = object;
        }
        return objectArray2;
    }

    public void check(int n) {
        if (n == (0x5227BA2D ^ 0x5223BA2D)) {
            Object object;
            int n2;
            if (this.visibleTypeAnnotations != null && this.visibleTypeAnnotations.size() > 0) {
                throw new RuntimeException();
            }
            if (this.invisibleTypeAnnotations != null && this.invisibleTypeAnnotations.size() > 0) {
                throw new RuntimeException();
            }
            int n3 = this.tryCatchBlocks == null ? 0x64BB399 ^ 0x64BB399 : this.tryCatchBlocks.size();
            for (n2 = 0x68E98134 ^ 0x68E98134; n2 < n3; ++n2) {
                object = this.tryCatchBlocks.get(n2);
                if (((TryCatchBlockNode)object).visibleTypeAnnotations != null && ((TryCatchBlockNode)object).visibleTypeAnnotations.size() > 0) {
                    throw new RuntimeException();
                }
                if (((TryCatchBlockNode)object).invisibleTypeAnnotations == null || ((TryCatchBlockNode)object).invisibleTypeAnnotations.size() <= 0) continue;
                throw new RuntimeException();
            }
            for (n2 = 0x4F9E038C ^ 0x4F9E038C; n2 < this.instructions.size(); ++n2) {
                object = this.instructions.get(n2);
                if (((AbstractInsnNode)object).visibleTypeAnnotations != null && ((AbstractInsnNode)object).visibleTypeAnnotations.size() > 0) {
                    throw new RuntimeException();
                }
                if (((AbstractInsnNode)object).invisibleTypeAnnotations != null && ((AbstractInsnNode)object).invisibleTypeAnnotations.size() > 0) {
                    throw new RuntimeException();
                }
                if (!(object instanceof MethodInsnNode)) continue;
                int n4 = ((MethodInsnNode)object).itf;
                if (n4 == (((AbstractInsnNode)object).opcode == (0x9C34D2D2 ^ 0x9C34D26B) ? 0xB6D33CB0 ^ 0xB6D33CB1 : 0xC64E8C3F ^ 0xC64E8C3F)) continue;
                throw new RuntimeException();
            }
            if (this.visibleLocalVariableAnnotations != null && this.visibleLocalVariableAnnotations.size() > 0) {
                throw new RuntimeException();
            }
            if (this.invisibleLocalVariableAnnotations != null && this.invisibleLocalVariableAnnotations.size() > 0) {
                throw new RuntimeException();
            }
        }
    }

    public void accept(ClassVisitor classVisitor) {
        String[] stringArray = new String[this.exceptions.size()];
        this.exceptions.toArray(stringArray);
        MethodVisitor methodVisitor = classVisitor.visitMethod(this.access, this.name, this.desc, this.signature, stringArray);
        if (methodVisitor != null) {
            this.accept(methodVisitor);
        }
    }

    public void accept(MethodVisitor methodVisitor) {
        AnnotationNode annotationNode;
        int n;
        List<AnnotationNode> list;
        int n2;
        int n3 = this.parameters == null ? 0xD1FD454F ^ 0xD1FD454F : this.parameters.size();
        for (n2 = 0x27A76B37 ^ 0x27A76B37; n2 < n3; ++n2) {
            list = this.parameters.get(n2);
            methodVisitor.visitParameter(((ParameterNode)((Object)list)).name, ((ParameterNode)((Object)list)).access);
        }
        if (this.annotationDefault != null) {
            list = methodVisitor.visitAnnotationDefault();
            AnnotationNode.accept((AnnotationVisitor)((Object)list), null, this.annotationDefault);
            if (list != null) {
                ((AnnotationVisitor)((Object)list)).visitEnd();
            }
        }
        n3 = this.visibleAnnotations == null ? 0x47126E73 ^ 0x47126E73 : this.visibleAnnotations.size();
        for (n2 = 0x181389B ^ 0x181389B; n2 < n3; ++n2) {
            list = this.visibleAnnotations.get(n2);
            ((AnnotationNode)((Object)list)).accept(methodVisitor.visitAnnotation(((AnnotationNode)((Object)list)).desc, (0xDA51775B ^ 0xDA51775A) != 0));
        }
        n3 = this.invisibleAnnotations == null ? 0x89DAEAA2 ^ 0x89DAEAA2 : this.invisibleAnnotations.size();
        for (n2 = 0x9A2117F8 ^ 0x9A2117F8; n2 < n3; ++n2) {
            list = this.invisibleAnnotations.get(n2);
            ((AnnotationNode)((Object)list)).accept(methodVisitor.visitAnnotation(((AnnotationNode)((Object)list)).desc, (0x24614367 ^ 0x24614367) != 0));
        }
        n3 = this.visibleTypeAnnotations == null ? 0xB548680B ^ 0xB548680B : this.visibleTypeAnnotations.size();
        for (n2 = 0x1D961B2 ^ 0x1D961B2; n2 < n3; ++n2) {
            list = this.visibleTypeAnnotations.get(n2);
            ((AnnotationNode)((Object)list)).accept(methodVisitor.visitTypeAnnotation(((TypeAnnotationNode)((Object)list)).typeRef, ((TypeAnnotationNode)((Object)list)).typePath, ((TypeAnnotationNode)((Object)list)).desc, (0x95E8DE84 ^ 0x95E8DE85) != 0));
        }
        n3 = this.invisibleTypeAnnotations == null ? 0xC79F67AB ^ 0xC79F67AB : this.invisibleTypeAnnotations.size();
        for (n2 = 0xC393CDBF ^ 0xC393CDBF; n2 < n3; ++n2) {
            list = this.invisibleTypeAnnotations.get(n2);
            ((AnnotationNode)((Object)list)).accept(methodVisitor.visitTypeAnnotation(((TypeAnnotationNode)((Object)list)).typeRef, ((TypeAnnotationNode)((Object)list)).typePath, ((TypeAnnotationNode)((Object)list)).desc, (0xB61C2B88 ^ 0xB61C2B88) != 0));
        }
        n3 = this.visibleParameterAnnotations == null ? 0xBD09D429 ^ 0xBD09D429 : this.visibleParameterAnnotations.length;
        for (n2 = 0x3AAED00D ^ 0x3AAED00D; n2 < n3; ++n2) {
            list = this.visibleParameterAnnotations[n2];
            if (list == null) continue;
            for (n = 0x12771CC5 ^ 0x12771CC5; n < list.size(); ++n) {
                annotationNode = list.get(n);
                annotationNode.accept(methodVisitor.visitParameterAnnotation(n2, annotationNode.desc, (0xE180B19 ^ 0xE180B18) != 0));
            }
        }
        n3 = this.invisibleParameterAnnotations == null ? 0x480CD727 ^ 0x480CD727 : this.invisibleParameterAnnotations.length;
        for (n2 = 0x81E5AC06 ^ 0x81E5AC06; n2 < n3; ++n2) {
            list = this.invisibleParameterAnnotations[n2];
            if (list == null) continue;
            for (n = 0xF6502DD5 ^ 0xF6502DD5; n < list.size(); ++n) {
                annotationNode = list.get(n);
                annotationNode.accept(methodVisitor.visitParameterAnnotation(n2, annotationNode.desc, (0x5DE6F192 ^ 0x5DE6F192) != 0));
            }
        }
        if (this.visited) {
            this.instructions.resetLabels();
        }
        n3 = this.attrs == null ? 0xF882B1EE ^ 0xF882B1EE : this.attrs.size();
        for (n2 = 0xCCB7B880 ^ 0xCCB7B880; n2 < n3; ++n2) {
            methodVisitor.visitAttribute(this.attrs.get(n2));
        }
        if (this.instructions.size() > 0) {
            methodVisitor.visitCode();
            n3 = this.tryCatchBlocks == null ? 0xBEAD0ED4 ^ 0xBEAD0ED4 : this.tryCatchBlocks.size();
            for (n2 = 0x5E9374C1 ^ 0x5E9374C1; n2 < n3; ++n2) {
                this.tryCatchBlocks.get(n2).updateIndex(n2);
                this.tryCatchBlocks.get(n2).accept(methodVisitor);
            }
            this.instructions.accept(methodVisitor);
            n3 = this.localVariables == null ? 0x242456EB ^ 0x242456EB : this.localVariables.size();
            for (n2 = 0x45437E98 ^ 0x45437E98; n2 < n3; ++n2) {
                this.localVariables.get(n2).accept(methodVisitor);
            }
            n3 = this.visibleLocalVariableAnnotations == null ? 0x6A8ACCB7 ^ 0x6A8ACCB7 : this.visibleLocalVariableAnnotations.size();
            for (n2 = 0x41B4D8B1 ^ 0x41B4D8B1; n2 < n3; ++n2) {
                this.visibleLocalVariableAnnotations.get(n2).accept(methodVisitor, (0x250FA2DA ^ 0x250FA2DB) != 0);
            }
            n3 = this.invisibleLocalVariableAnnotations == null ? 0xF119AD7 ^ 0xF119AD7 : this.invisibleLocalVariableAnnotations.size();
            for (n2 = 0xA8B16DAF ^ 0xA8B16DAF; n2 < n3; ++n2) {
                this.invisibleLocalVariableAnnotations.get(n2).accept(methodVisitor, (0xDEF02792 ^ 0xDEF02792) != 0);
            }
            methodVisitor.visitMaxs(this.maxStack, this.maxLocals);
            this.visited = 0x93D2BC55 ^ 0x93D2BC54;
        }
        methodVisitor.visitEnd();
    }
}

