/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.gen;

import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.gen.AccessorGenerator;
import org.spongepowered.asm.mixin.gen.AccessorInfo;
import org.spongepowered.asm.util.Bytecode;

public class AccessorGeneratorMethodProxy
extends AccessorGenerator {
    private final MethodNode targetMethod;
    private final Type[] argTypes;
    private final Type returnType;
    private final boolean isInstanceMethod;

    public AccessorGeneratorMethodProxy(AccessorInfo accessorInfo) {
        super(accessorInfo);
        this.targetMethod = accessorInfo.getTargetMethod();
        this.argTypes = accessorInfo.getArgTypes();
        this.returnType = accessorInfo.getReturnType();
        this.isInstanceMethod = !Bytecode.hasFlag(this.targetMethod, 0x730D3D7E ^ 0x730D3D76) ? 0x159DBC34 ^ 0x159DBC35 : 0x2EDAFA1D ^ 0x2EDAFA1D;
    }

    @Override
    public MethodNode generate() {
        int n = Bytecode.getArgsSize(this.argTypes) + this.returnType.getSize() + (this.isInstanceMethod ? 0x5D5BBE6A ^ 0x5D5BBE6B : 0x546775BD ^ 0x546775BD);
        MethodNode methodNode = this.createMethod(n, n);
        if (this.isInstanceMethod) {
            methodNode.instructions.add(new VarInsnNode(0xAF7DBD2D ^ 0xAF7DBD34, 0x2ECEA04D ^ 0x2ECEA04D));
        }
        Bytecode.loadArgs(this.argTypes, methodNode.instructions, this.isInstanceMethod ? 0x701DEBB5 ^ 0x701DEBB4 : 0xE36A2D6C ^ 0xE36A2D6C);
        boolean bl = Bytecode.hasFlag(this.targetMethod, 0x47727FD3 ^ 0x47727FD1);
        int n2 = this.isInstanceMethod ? (bl ? 0xE7FF4A1 ^ 0xE7FF416 : 0x9FE58373 ^ 0x9FE583C5) : 0x2C59430C ^ 0x2C5943B4;
        methodNode.instructions.add(new MethodInsnNode(n2, this.info.getClassNode().name, this.targetMethod.name, this.targetMethod.desc, (0xEA45CDA2 ^ 0xEA45CDA2) != 0));
        methodNode.instructions.add(new InsnNode(this.returnType.getOpcode(0xE2BE4BF ^ 0xE2BE413)));
        return methodNode;
    }
}

