/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.IInjectionPointContext;
import org.spongepowered.asm.mixin.injection.modify.AfterStoreLocal;
import org.spongepowered.asm.mixin.injection.modify.BeforeLoadLocal;
import org.spongepowered.asm.mixin.injection.points.AfterInvoke;
import org.spongepowered.asm.mixin.injection.points.BeforeConstant;
import org.spongepowered.asm.mixin.injection.points.BeforeFieldAccess;
import org.spongepowered.asm.mixin.injection.points.BeforeFinalReturn;
import org.spongepowered.asm.mixin.injection.points.BeforeInvoke;
import org.spongepowered.asm.mixin.injection.points.BeforeNew;
import org.spongepowered.asm.mixin.injection.points.BeforeReturn;
import org.spongepowered.asm.mixin.injection.points.BeforeStringInvoke;
import org.spongepowered.asm.mixin.injection.points.JumpInsnPoint;
import org.spongepowered.asm.mixin.injection.points.MethodHead;
import org.spongepowered.asm.mixin.injection.struct.InjectionPointData;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public abstract class InjectionPoint {
    public static final int DEFAULT_ALLOWED_SHIFT_BY = 0;
    public static final int MAX_ALLOWED_SHIFT_BY = 5;
    private static Map<String, Class<? extends InjectionPoint>> types = new HashMap<String, Class<? extends InjectionPoint>>();
    private final String slice;
    private final Selector selector;
    private final String id;

    protected InjectionPoint() {
        this(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(""), Selector.DEFAULT, null);
    }

    protected InjectionPoint(InjectionPointData injectionPointData) {
        this(injectionPointData.getSlice(), injectionPointData.getSelector(), injectionPointData.getId());
    }

    public InjectionPoint(String string, Selector selector, String string2) {
        this.slice = string;
        this.selector = selector;
        this.id = string2;
    }

    public String getSlice() {
        return this.slice;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public String getId() {
        return this.id;
    }

    public boolean checkPriority(int n, int n2) {
        return (n < n2 ? 0x5CB14D00 ^ 0x5CB14D01 : 0xCE4BCA4E ^ 0xCE4BCA4E) != 0;
    }

    public abstract boolean find(String var1, InsnList var2, Collection<AbstractInsnNode> var3);

    public String toString() {
        Object[] objectArray = new Object[0x5BE3064 ^ 0x5BE3065];
        objectArray[0xCAA5394A ^ 0xCAA5394A] = this.getAtCode();
        return String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("R\ua7c7\ua4a1\ua039\ua947\u7d33\u8e59\u2438\u8b7e"), objectArray);
    }

    protected static AbstractInsnNode nextNode(InsnList insnList, AbstractInsnNode abstractInsnNode) {
        int n = insnList.indexOf(abstractInsnNode) + (0x616DF1D6 ^ 0x616DF1D7);
        if (n > 0 && n < insnList.size()) {
            return insnList.get(n);
        }
        return abstractInsnNode;
    }

    public static InjectionPoint and(InjectionPoint ... injectionPointArray) {
        return new Intersection(injectionPointArray);
    }

    public static InjectionPoint or(InjectionPoint ... injectionPointArray) {
        return new Union(injectionPointArray);
    }

    public static InjectionPoint after(InjectionPoint injectionPoint) {
        return new Shift(injectionPoint, 0x9CD2C6B ^ 0x9CD2C6A);
    }

    public static InjectionPoint before(InjectionPoint injectionPoint) {
        return new Shift(injectionPoint, 0x4C035763 ^ 0xB3FCA89C);
    }

    public static InjectionPoint shift(InjectionPoint injectionPoint, int n) {
        return new Shift(injectionPoint, n);
    }

    public static List<InjectionPoint> parse(IInjectionPointContext iInjectionPointContext, List<AnnotationNode> list) {
        return InjectionPoint.parse(iInjectionPointContext.getContext(), iInjectionPointContext.getMethod(), iInjectionPointContext.getAnnotation(), list);
    }

    public static List<InjectionPoint> parse(IMixinContext iMixinContext, MethodNode methodNode, AnnotationNode annotationNode, List<AnnotationNode> list) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AnnotationNode annotationNode2 : list) {
            InjectionPoint injectionPoint = InjectionPoint.parse(iMixinContext, methodNode, annotationNode, annotationNode2);
            if (injectionPoint == null) continue;
            builder.add((Object)injectionPoint);
        }
        return builder.build();
    }

    public static InjectionPoint parse(IInjectionPointContext iInjectionPointContext, At at) {
        return InjectionPoint.parse(iInjectionPointContext.getContext(), iInjectionPointContext.getMethod(), iInjectionPointContext.getAnnotation(), at.value(), at.shift(), at.by(), Arrays.asList(at.args()), at.target(), at.slice(), at.ordinal(), at.opcode(), at.id());
    }

    public static InjectionPoint parse(IMixinContext iMixinContext, MethodNode methodNode, AnnotationNode annotationNode, At at) {
        return InjectionPoint.parse(iMixinContext, methodNode, annotationNode, at.value(), at.shift(), at.by(), Arrays.asList(at.args()), at.target(), at.slice(), at.ordinal(), at.opcode(), at.id());
    }

    public static InjectionPoint parse(IInjectionPointContext iInjectionPointContext, AnnotationNode annotationNode) {
        return InjectionPoint.parse(iInjectionPointContext.getContext(), iInjectionPointContext.getMethod(), iInjectionPointContext.getAnnotation(), annotationNode);
    }

    public static InjectionPoint parse(IMixinContext iMixinContext, MethodNode methodNode, AnnotationNode annotationNode, AnnotationNode annotationNode2) {
        String string = (String)Annotations.getValue(annotationNode2, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("d\ua7e7\ua4b9\ua064\ua900"));
        List list = (List)Annotations.getValue(annotationNode2, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("s\ua7f4\ua4b2\ua062"));
        String string2 = Annotations.getValue(annotationNode2, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("f\ua7e7\ua4a7\ua076\ua900\u7d62"), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(""));
        String string3 = Annotations.getValue(annotationNode2, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("a\ua7ea\ua4bc\ua072\ua900"), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(""));
        At.Shift shift = Annotations.getValue(annotationNode2, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("a\ua7ee\ua4bc\ua077\ua911"), At.Shift.class, At.Shift.NONE);
        int n = Annotations.getValue(annotationNode2, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("p\ua7ff"), 0xBAA8976E ^ 0xBAA8976E);
        int n2 = Annotations.getValue(annotationNode2, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("}\ua7f4\ua4b1\ua078\ua90b\u7d77\u8e46"), 0x9395D640 ^ 0x6C6A29BF);
        int n3 = Annotations.getValue(annotationNode2, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("}\ua7f6\ua4b6\ua07e\ua901\u7d73"), 0x766B2F3A ^ 0x766B2F3A);
        String string4 = (String)Annotations.getValue(annotationNode2, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("{\ua7e2"));
        if (list == null) {
            list = ImmutableList.of();
        }
        return InjectionPoint.parse(iMixinContext, methodNode, annotationNode, string, shift, n, list, string2, string3, n2, n3, string4);
    }

    public static InjectionPoint parse(IMixinContext iMixinContext, MethodNode methodNode, AnnotationNode annotationNode, String string, At.Shift shift, int n, List<String> list, String string2, String string3, int n2, int n3, String string4) {
        InjectionPointData injectionPointData = new InjectionPointData(iMixinContext, methodNode, annotationNode, string, list, string2, string3, n2, n3, string4);
        Class<? extends InjectionPoint> clazz = InjectionPoint.findClass(iMixinContext, injectionPointData);
        InjectionPoint injectionPoint = InjectionPoint.create(iMixinContext, injectionPointData, clazz);
        return InjectionPoint.shift(iMixinContext, methodNode, annotationNode, injectionPoint, shift, n);
    }

    private static Class<? extends InjectionPoint> findClass(IMixinContext iMixinContext, InjectionPointData injectionPointData) {
        String string = injectionPointData.getType();
        Class<InjectionPoint> clazz = types.get(string);
        if (clazz == null) {
            if (string.matches(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("L\ua7ae\ua48e\ua050\ua948\u7d4c\u8e4b\u2437\u8b2d\u3448O\ua7dd\ua494\ua03c\ua93f\u7d77\u8e07\u2460\u8b67\u343a+\ua7d9\ua488\ua03b\ua939\u7d38\u8e03\u2431\u8b0c\u3456?\ua7dc\ua4b4\ua03c\ua91f\u7d49\u8e77\u2441\u8b16\u343aH\ua7e7\ua4f8\ua06b\ua955\u7d3b\u8e13\u2445\u8b0a\u343d6"))) {
                try {
                    clazz = Class.forName(string);
                    types.put(string, clazz);
                }
                catch (Exception exception) {
                    throw new InvalidInjectionException(iMixinContext, injectionPointData + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7e5\ua4ba\ua064\ua909\u7d72\u8e0a\u2474\u8b38\u34632\ua7e4\ua4b0\ua031\ua909\u7d79\u8e4b\u247e\u8b32\u34732\ua7e9\ua4a7\ua031\ua90c\u7d65\u8e0a\u2474\u8b38\u34632\ua7e7\ua4f5\ua067\ua904\u7d7a\u8e43\u247e\u8b77\u345e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b07\u3478{\ua7e8\ua4a1"), (Throwable)exception);
                }
            } else {
                throw new InvalidInjectionException(iMixinContext, injectionPointData + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4a6\ua031\ua90b\u7d79\u8e5e\u243a\u8b36\u3437d\ua7e7\ua4b9\ua078\ua901\u7d36\u8e43\u2474\u8b3d\u3472q\ua7f2\ua4bc\ua07e\ua90b\u7d36\u8e5a\u2475\u8b3e\u3479f\ua7a6\ua4a6\ua061\ua900\u7d75\u8e43\u247c\u8b3e\u3472`"));
            }
        }
        return clazz;
    }

    private static InjectionPoint create(IMixinContext iMixinContext, InjectionPointData injectionPointData, Class<? extends InjectionPoint> clazz) {
        Constructor<? extends InjectionPoint> constructor = null;
        try {
            Class[] classArray = new Class[0x22CDF15D ^ 0x22CDF15C];
            classArray[0x34B70681 ^ 0x34B70681] = InjectionPointData.class;
            constructor = clazz.getDeclaredConstructor(classArray);
            constructor.setAccessible((0x1A5C90AC ^ 0x1A5C90AD) != 0);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InvalidInjectionException(iMixinContext, clazz.getName() + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7eb\ua4a0\ua062\ua911\u7d36\u8e49\u2475\u8b39\u3463s\ua7ef\ua4bb\ua031\ua904\u7d36\u8e49\u2475\u8b39\u3464f\ua7f4\ua4a0\ua072\ua911\u7d79\u8e58\u243a\u8b20\u347f{\ua7e5\ua4bd\ua031\ua904\u7d75\u8e49\u247f\u8b27\u3463a\ua7a6\ua4b4\ua07f\ua945\u7d5f\u8e44\u2470\u8b32\u3474f\ua7ef\ua4ba\ua07f\ua935\u7d79\u8e43\u2474\u8b23\u3453s\ua7f2\ua4b4"), (Throwable)noSuchMethodException);
        }
        InjectionPoint injectionPoint = null;
        try {
            Object[] objectArray = new Object[0xEDB07298 ^ 0xEDB07299];
            objectArray[0xF98DAB3B ^ 0xF98DAB3B] = injectionPointData;
            injectionPoint = constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new InvalidInjectionException(iMixinContext, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("W\ua7f4\ua4a7\ua07e\ua917\u7d36\u8e5d\u2472\u8b3e\u347ba\ua7f2\ua4f5\ua078\ua90b\u7d65\u8e5e\u247b\u8b39\u3474{\ua7e8\ua4b2\ua031\ua90c\u7d78\u8e40\u247f\u8b34\u3463{\ua7e9\ua4bb\ua031\ua915\u7d79\u8e43\u2474\u8b23\u3437") + clazz.getName() + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7e0\ua4ba\ua063\ua945") + injectionPointData.getAt(), (Throwable)exception);
        }
        return injectionPoint;
    }

    private static InjectionPoint shift(IMixinContext iMixinContext, MethodNode methodNode, AnnotationNode annotationNode, InjectionPoint injectionPoint, At.Shift shift, int n) {
        if (injectionPoint != null) {
            if (shift == At.Shift.BEFORE) {
                return InjectionPoint.before(injectionPoint);
            }
            if (shift == At.Shift.AFTER) {
                return InjectionPoint.after(injectionPoint);
            }
            if (shift == At.Shift.BY) {
                InjectionPoint.validateByValue(iMixinContext, methodNode, annotationNode, injectionPoint, n);
                return InjectionPoint.shift(injectionPoint, n);
            }
        }
        return injectionPoint;
    }

    private static void validateByValue(IMixinContext iMixinContext, MethodNode methodNode, AnnotationNode annotationNode, InjectionPoint injectionPoint, int n) {
        MixinEnvironment mixinEnvironment = iMixinContext.getMixin().getConfig().getEnvironment();
        ShiftByViolationBehaviour shiftByViolationBehaviour = mixinEnvironment.getOption(MixinEnvironment.Option.SHIFT_BY_VIOLATION_BEHAVIOUR, ShiftByViolationBehaviour.WARN);
        if (shiftByViolationBehaviour == ShiftByViolationBehaviour.IGNORE) {
            return;
        }
        String string = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("f\ua7ee\ua4b0\ua031\ua908\u7d77\u8e52\u2473\u8b3a\u3462\u007f\ua7a6\ua4b4\ua07d\ua909\u7d79\u8e5d\u247f\u8b33\u3437d\ua7e7\ua4b9\ua064\ua900\u7d2c\u8e0a");
        String string2 = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7e8\ua4b6\ua063\ua900\u7d77\u8e59\u247f\u8b77\u3463z\ua7e3\ua4f5\ua067\ua904\u7d7a\u8e5f\u247f\u8b77\u3478t\ua7a6\ua4b8\ua070\ua91d\u7d45\u8e42\u2473\u8b31\u3463P\ua7ff\ua4f5\ua065\ua90a\u7d36\u8e59\u246f\u8b27\u3467`\ua7e3\ua4a6\ua062\ua945\u7d62\u8e42\u2473\u8b24\u3437e\ua7e7\ua4a7\ua07f\ua90c\u7d78\u8e4d\u2434");
        int n2 = 0x9FE5A551 ^ 0x9FE5A551;
        if (iMixinContext instanceof MixinTargetContext) {
            n2 = ((MixinTargetContext)iMixinContext).getMaxShiftByValue();
        }
        if (n <= n2) {
            return;
        }
        if (n > (0xF5F1B015 ^ 0xF5F1B010)) {
            string = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("_\ua7c7\ua48d\ua04e\ua924\u7d5a\u8e66\u2455\u8b00\u3452V\ua7d9\ua486\ua059\ua92c\u7d50\u8e7e\u2445\u8b15\u344e/");
            string2 = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("K\ua7e9\ua4a0\ua031\ua908\u7d63\u8e59\u246e\u8b77\u3462a\ua7e3\ua4f5\ua070\ua90b\u7d36\u8e4b\u2476\u8b23\u3472`\ua7e8\ua4b4\ua065\ua900\u7d36\u8e5b\u246f\u8b32\u3465k\ua7a6\ua4ba\ua063\ua945\u7d77\u8e0a\u2479\u8b22\u3464f\ua7e9\ua4b8\ua031\ua90c\u7d78\u8e40\u247f\u8b34\u3463{\ua7e9\ua4bb\ua031\ua915\u7d79\u8e43\u2474\u8b23\u3439");
            n2 = 0x7C78F579 ^ 0x7C78F57C;
        }
        Object[] objectArray = new Object[0xC7139641 ^ 0xC7139649];
        objectArray[0xB55EABC ^ 0xB55EABC] = Bytecode.getSimpleName(annotationNode);
        objectArray[0x69CA7D3E ^ 0x69CA7D3F] = injectionPoint;
        objectArray[0xAF456301 ^ 0xAF456303] = n;
        objectArray[0x102F3C12 ^ 0x102F3C11] = iMixinContext;
        objectArray[0x847AE430 ^ 0x847AE434] = methodNode.name;
        objectArray[0x60535772 ^ 0x60535777] = string;
        objectArray[0xA668284A ^ 0xA668284C] = n2;
        objectArray[0x9693AF64 ^ 0x9693AF63] = string2;
        String string3 = String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("R\ua7a3\ua4a6\ua039\ua940\u7d65\u8e03\u243a\u8b04\u347f{\ua7e0\ua4a1\ua03f\ua927\u7d4f\u8e17\u243f\u8b33\u3437}\ua7e8\ua4f5\ua034\ua916\u7d2c\u8e10\u243f\u8b24\u3437w\ua7fe\ua4b6\ua074\ua900\u7d72\u8e59\u243a\u8b72\u34647\ua7e2\ua4fb\ua031\ua940\u7d65"), objectArray);
        if (shiftByViolationBehaviour == ShiftByViolationBehaviour.WARN) {
            if (n2 < (0x96FB88E8 ^ 0x96FB88ED)) {
                LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u007f\ua7ef\ua4ad\ua078\ua90b")).warn(string3);
                return;
            }
        }
        throw new InvalidInjectionException(iMixinContext, string3);
    }

    protected String getAtCode() {
        AtCode atCode = this.getClass().getAnnotation(AtCode.class);
        return atCode == null ? this.getClass().getName() : atCode.value();
    }

    public static void register(Class<? extends InjectionPoint> clazz) {
        AtCode atCode = clazz.getAnnotation(AtCode.class);
        if (atCode == null) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7e8\ua4bf\ua074\ua906\u7d62\u8e43\u2475\u8b39\u3437b\ua7e9\ua4bc\ua07f\ua911\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6") + clazz + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4a6\ua031\ua90b\u7d79\u8e5e\u243a\u8b36\u3479|\ua7e9\ua4a1\ua070\ua911\u7d73\u8e4e\u243a\u8b20\u347ef\ua7ee\ua4f5\ua051\ua924\u7d62\u8e69\u2475\u8b33\u3472"));
        }
        Class<? extends InjectionPoint> clazz2 = types.get(atCode.value());
        if (clazz2 != null && !clazz2.equals(clazz)) {
            Object[] objectArray = new Object[0x7615511F ^ 0x7615511C];
            objectArray[0x38443236 ^ 0x38443236] = atCode.value();
            objectArray[0xF2EC8B0F ^ 0xF2EC8B0E] = clazz.getName();
            objectArray[0x183925A1 ^ 0x183925A3] = clazz2.getName();
            LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u007f\ua7ef\ua4ad\ua078\ua90b")).debug(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("]\ua7f0\ua4b0\ua063\ua917\u7d7f\u8e4e\u2473\u8b39\u34702\ua7cf\ua4bb\ua07b\ua900\u7d75\u8e5e\u2473\u8b38\u3479B\ua7e9\ua4bc\ua07f\ua911\u7d36\u8e51\u2467\u8b77\u3460{\ua7f2\ua4bd\ua031\ua91e\u7d6b\u8e0a\u2432\u8b27\u3465w\ua7f0\ua4bc\ua07e\ua910\u7d65\u8e46\u2463\u8b77\u346co\ua7af"), objectArray);
        }
        types.put(atCode.value(), clazz);
    }

    static {
        InjectionPoint.register(BeforeFieldAccess.class);
        InjectionPoint.register(BeforeInvoke.class);
        InjectionPoint.register(BeforeNew.class);
        InjectionPoint.register(BeforeReturn.class);
        InjectionPoint.register(BeforeStringInvoke.class);
        InjectionPoint.register(JumpInsnPoint.class);
        InjectionPoint.register(MethodHead.class);
        InjectionPoint.register(AfterInvoke.class);
        InjectionPoint.register(BeforeLoadLocal.class);
        InjectionPoint.register(AfterStoreLocal.class);
        InjectionPoint.register(BeforeFinalReturn.class);
        InjectionPoint.register(BeforeConstant.class);
    }

    static final class Shift
    extends InjectionPoint {
        private final InjectionPoint input;
        private final int shift;

        public Shift(InjectionPoint injectionPoint, int n) {
            if (injectionPoint == null) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("_\ua7f3\ua4a6\ua065\ua945\u7d65\u8e5f\u246a\u8b27\u347bk\ua7a6\ua4b4\ua07f\ua945\u7d7f\u8e44\u246a\u8b22\u34632\ua7ef\ua4bb\ua07b\ua900\u7d75\u8e5e\u2473\u8b38\u34792\ua7f6\ua4ba\ua078\ua90b\u7d62\u8e0a\u247c\u8b38\u34652\ua7d5\ua49d\ua058\ua923\u7d42"));
            }
            this.input = injectionPoint;
            this.shift = n;
        }

        @Override
        public String toString() {
            return \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7e8\ua4bf\ua074\ua906\u7d62\u8e43\u2475\u8b39\u3447}\ua7ef\ua4bb\ua065\ua94d") + this.getClass().getSimpleName() + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(";\ua7dd") + this.input + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("O");
        }

        @Override
        public boolean find(String string, InsnList insnList, Collection<AbstractInsnNode> collection) {
            List<Object> list = collection instanceof List ? (List<Object>)collection : new ArrayList<AbstractInsnNode>(collection);
            this.input.find(string, insnList, collection);
            for (int i = 0xAA22DCFD ^ 0xAA22DCFD; i < list.size(); ++i) {
                list.set(i, insnList.get(insnList.indexOf((AbstractInsnNode)list.get(i)) + this.shift));
            }
            if (collection != list) {
                collection.clear();
                collection.addAll((Collection<AbstractInsnNode>)list);
            }
            return (collection.size() > 0 ? 0x73E0608D ^ 0x73E0608C : 0x7CBCA843 ^ 0x7CBCA843) != 0;
        }
    }

    static final class Union
    extends CompositeInjectionPoint {
        public Union(InjectionPoint ... injectionPointArray) {
            super(injectionPointArray);
        }

        @Override
        public boolean find(String string, InsnList insnList, Collection<AbstractInsnNode> collection) {
            LinkedHashSet<AbstractInsnNode> linkedHashSet = new LinkedHashSet<AbstractInsnNode>();
            for (int i = 0x19C22E7E ^ 0x19C22E7E; i < this.components.length; ++i) {
                this.components[i].find(string, insnList, linkedHashSet);
            }
            collection.addAll(linkedHashSet);
            return (linkedHashSet.size() > 0 ? 0x89DDB899 ^ 0x89DDB898 : 0xE4DB55AA ^ 0xE4DB55AA) != 0;
        }
    }

    static final class Intersection
    extends CompositeInjectionPoint {
        public Intersection(InjectionPoint ... injectionPointArray) {
            super(injectionPointArray);
        }

        @Override
        public boolean find(String string, InsnList insnList, Collection<AbstractInsnNode> collection) {
            int n = 0x93442A55 ^ 0x93442A55;
            ArrayList[] arrayListArray = (ArrayList[])Array.newInstance(ArrayList.class, this.components.length);
            for (int i = 0x2D385CC1 ^ 0x2D385CC1; i < this.components.length; ++i) {
                arrayListArray[i] = new ArrayList();
                this.components[i].find(string, insnList, arrayListArray[i]);
            }
            ArrayList arrayList = arrayListArray[0x1FDA6C4A ^ 0x1FDA6C4A];
            for (int i = 0x439ACD17 ^ 0x439ACD17; i < arrayList.size(); ++i) {
                AbstractInsnNode abstractInsnNode = (AbstractInsnNode)arrayList.get(i);
                int n2 = 0xC1E23127 ^ 0xC1E23126;
                for (int j = 0xDB3F4F6E ^ 0xDB3F4F6F; j < arrayListArray.length && arrayListArray[j].contains(abstractInsnNode); ++j) {
                }
                if (n2 == 0) continue;
                collection.add(abstractInsnNode);
                n = 0xE1B21F4D ^ 0xE1B21F4C;
            }
            return n != 0;
        }
    }

    static abstract class CompositeInjectionPoint
    extends InjectionPoint {
        protected final InjectionPoint[] components;

        protected CompositeInjectionPoint(InjectionPoint ... injectionPointArray) {
            block3: {
                block2: {
                    if (injectionPointArray == null) break block2;
                    if (injectionPointArray.length >= (0x53DE0842 ^ 0x53DE0840)) break block3;
                }
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("_\ua7f3\ua4a6\ua065\ua945\u7d65\u8e5f\u246a\u8b27\u347bk\ua7a6\ua4a1\ua066\ua90a\u7d36\u8e45\u2468\u8b77\u347a}\ua7f4\ua4b0\ua031\ua906\u7d79\u8e47\u246a\u8b38\u3479w\ua7e8\ua4a1\ua031\ua90c\u7d78\u8e40\u247f\u8b34\u3463{\ua7e9\ua4bb\ua031\ua915\u7d79\u8e43\u2474\u8b23\u34642\ua7e0\ua4ba\ua063\ua945\u7d75\u8e45\u2477\u8b27\u3478a\ua7ef\ua4a1\ua074\ua945\u7d66\u8e45\u2473\u8b39\u34633"));
            }
            this.components = injectionPointArray;
        }

        @Override
        public String toString() {
            return \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("Q\ua7e9\ua4b8\ua061\ua90a\u7d65\u8e43\u246e\u8b32\u345e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b07\u3478{\ua7e8\ua4a1\ua039") + this.getClass().getSimpleName() + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(";\ua7dd") + Joiner.on((char)(0x2BA60F82 ^ 0x2BA60FAE)).join((Object[])this.components) + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("O");
        }
    }

    static final class ShiftByViolationBehaviour
    extends Enum<ShiftByViolationBehaviour> {
        public static final /* enum */ ShiftByViolationBehaviour IGNORE = new ShiftByViolationBehaviour();
        public static final /* enum */ ShiftByViolationBehaviour WARN = new ShiftByViolationBehaviour();
        public static final /* enum */ ShiftByViolationBehaviour ERROR = new ShiftByViolationBehaviour();
        private static final /* synthetic */ ShiftByViolationBehaviour[] $VALUES;

        public static ShiftByViolationBehaviour[] values() {
            return (ShiftByViolationBehaviour[])$VALUES.clone();
        }

        public static ShiftByViolationBehaviour valueOf(String string) {
            return Enum.valueOf(ShiftByViolationBehaviour.class, string);
        }

        static {
            ShiftByViolationBehaviour[] shiftByViolationBehaviourArray = new ShiftByViolationBehaviour[0x17FB4107 ^ 0x17FB4104];
            shiftByViolationBehaviourArray[0xBEC68929 ^ 0xBEC68929] = IGNORE;
            shiftByViolationBehaviourArray[0x761B7F52 ^ 0x761B7F53] = WARN;
            shiftByViolationBehaviourArray[0xDFD2AAE2 ^ 0xDFD2AAE0] = ERROR;
            $VALUES = shiftByViolationBehaviourArray;
        }
    }

    public static final class Selector
    extends Enum<Selector> {
        public static final /* enum */ Selector FIRST = new Selector();
        public static final /* enum */ Selector LAST = new Selector();
        public static final /* enum */ Selector ONE = new Selector();
        public static final Selector DEFAULT;
        private static final /* synthetic */ Selector[] $VALUES;

        public static Selector[] values() {
            return (Selector[])$VALUES.clone();
        }

        public static Selector valueOf(String string) {
            return Enum.valueOf(Selector.class, string);
        }

        static {
            Selector[] selectorArray = new Selector[0x5285576F ^ 0x5285576C];
            selectorArray[0x33D29FC ^ 0x33D29FC] = FIRST;
            selectorArray[0x1923D5AA ^ 0x1923D5AB] = LAST;
            selectorArray[0x91C73E28 ^ 0x91C73E2A] = ONE;
            $VALUES = selectorArray;
            DEFAULT = FIRST;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface AtCode {
        public String value();
    }
}

