/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.code;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.code.InjectorTarget;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public abstract class Injector {
    protected static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    protected InjectionInfo info;
    protected final ClassNode classNode;
    protected final MethodNode methodNode;
    protected final Type[] methodArgs;
    protected final Type returnType;
    protected final boolean isStatic;

    public Injector(InjectionInfo injectionInfo) {
        this(injectionInfo.getClassNode(), injectionInfo.getMethod());
        this.info = injectionInfo;
    }

    private Injector(ClassNode classNode, MethodNode methodNode) {
        this.classNode = classNode;
        this.methodNode = methodNode;
        this.methodArgs = Type.getArgumentTypes(this.methodNode.desc);
        this.returnType = Type.getReturnType(this.methodNode.desc);
        this.isStatic = Bytecode.methodIsStatic(this.methodNode);
    }

    public String toString() {
        Object[] objectArray = new Object[0xB2197ECC ^ 0xB2197ECE];
        objectArray[0x28F7F9B1 ^ 0x28F7F9B1] = this.classNode.name;
        objectArray[0x8B448439 ^ 0x8B448438] = this.methodNode.name;
        return String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4ef\ua02b\ua940\u7d65"), objectArray);
    }

    public final List<InjectionNodes.InjectionNode> find(InjectorTarget injectorTarget, List<InjectionPoint> list) {
        this.sanityCheck(injectorTarget.getTarget(), list);
        ArrayList<InjectionNodes.InjectionNode> arrayList = new ArrayList<InjectionNodes.InjectionNode>();
        for (TargetNode targetNode : this.findTargetNodes(injectorTarget, list)) {
            this.addTargetNode(injectorTarget.getTarget(), arrayList, targetNode.insn, targetNode.nominators);
        }
        return arrayList;
    }

    protected void addTargetNode(Target target, List<InjectionNodes.InjectionNode> list, AbstractInsnNode abstractInsnNode, Set<InjectionPoint> set) {
        list.add(target.addInjectionNode(abstractInsnNode));
    }

    public final void inject(Target target, List<InjectionNodes.InjectionNode> list) {
        for (InjectionNodes.InjectionNode injectionNode : list) {
            if (injectionNode.isRemoved()) {
                if (!this.info.getContext().getOption(MixinEnvironment.Option.DEBUG_VERBOSE)) continue;
                Object[] objectArray = new Object[0x954CDFCF ^ 0x954CDFCD];
                objectArray[0x6F1E51A1 ^ 0x6F1E51A1] = this.info;
                objectArray[0xE9E4244E ^ 0xE9E4244F] = target;
                logger.warn(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("F\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2474\u8b38\u3473w\ua7a6\ua4b3\ua07e\ua917\u7d36\u8e51\u2467\u8b77\u3460s\ua7f5\ua4f5\ua063\ua900\u7d7b\u8e45\u246c\u8b32\u34732\ua7e4\ua4ac\ua031\ua904\u7d36\u8e5a\u2468\u8b32\u3461{\ua7e9\ua4a0\ua062\ua945\u7d7f\u8e44\u2470\u8b32\u3474f\ua7e9\ua4a7\ua031\ua90c\u7d78\u8e0a\u2461\u8b2a"), objectArray);
                continue;
            }
            this.inject(target, injectionNode);
        }
        for (InjectionNodes.InjectionNode injectionNode : list) {
            this.postInject(target, injectionNode);
        }
    }

    private Collection<TargetNode> findTargetNodes(InjectorTarget injectorTarget, List<InjectionPoint> list) {
        IMixinContext iMixinContext = this.info.getContext();
        MethodNode methodNode = injectorTarget.getMethod();
        TreeMap<Integer, TargetNode> treeMap = new TreeMap<Integer, TargetNode>();
        ArrayList<AbstractInsnNode> arrayList = new ArrayList<AbstractInsnNode>(0x77B99E27 ^ 0x77B99E07);
        for (InjectionPoint injectionPoint : list) {
            arrayList.clear();
            if (injectorTarget.isMerged() && !iMixinContext.getClassName().equals(injectorTarget.getMergedBy()) && !injectionPoint.checkPriority(injectorTarget.getMergedPriority(), iMixinContext.getPriority())) {
                Object[] objectArray = new Object[0xA3149E0D ^ 0xA3149E0B];
                objectArray[0x6A7B50E6 ^ 0x6A7B50E6] = injectionPoint;
                objectArray[0xE6F2A485 ^ 0xE6F2A484] = this;
                objectArray[0x1DB4D8EF ^ 0x1DB4D8ED] = iMixinContext.getPriority();
                objectArray[0x86762843 ^ 0x86762840] = injectorTarget;
                objectArray[0xB52ECC44 ^ 0xB52ECC40] = injectorTarget.getMergedBy();
                objectArray[0x483D1B95 ^ 0x483D1B90] = injectorTarget.getMergedPriority();
                throw new InvalidInjectionException(this.info, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4f5\ua07e\ua90b\u7d36\u8e0f\u2469\u8b77\u3460{\ua7f2\ua4bd\ua031\ua915\u7d64\u8e43\u2475\u8b25\u347ef\ua7ff\ua4f5\ua034\ua901\u7d36\u8e49\u247b\u8b39\u3479}\ua7f2\ua4f5\ua078\ua90b\u7d7c\u8e4f\u2479\u8b23\u3437{\ua7e8\ua4a1\ua07e\ua945\u7d33\u8e59\u243a\u8b3a\u3472`\ua7e1\ua4b0\ua075\ua945\u7d74\u8e53\u243a\u8b72\u34642\ua7f1\ua4bc\ua065\ua90d\u7d36\u8e5a\u2468\u8b3e\u3478`\ua7ef\ua4a1\ua068\ua945\u7d33\u8e4e"), objectArray));
            }
            if (!this.findTargetNodes(methodNode, injectionPoint, injectorTarget.getSlice(injectionPoint), arrayList)) continue;
            for (AbstractInsnNode abstractInsnNode : arrayList) {
                Integer n = methodNode.instructions.indexOf(abstractInsnNode);
                TargetNode targetNode = (TargetNode)treeMap.get(n);
                if (targetNode == null) {
                    targetNode = new TargetNode(abstractInsnNode);
                    treeMap.put(n, targetNode);
                }
                targetNode.nominators.add(injectionPoint);
            }
        }
        return treeMap.values();
    }

    protected boolean findTargetNodes(MethodNode methodNode, InjectionPoint injectionPoint, InsnList insnList, Collection<AbstractInsnNode> collection) {
        return injectionPoint.find(methodNode.desc, insnList, collection);
    }

    protected void sanityCheck(Target target, List<InjectionPoint> list) {
        if (target.classNode != this.classNode) {
            throw new InvalidInjectionException(this.info, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("F\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2479\u8b3b\u3476a\ua7f5\ua4f5\ua075\ua90a\u7d73\u8e59\u243a\u8b39\u3478f\ua7a6\ua4b8\ua070\ua911\u7d75\u8e42\u243a\u8b3e\u3479x\ua7e3\ua4b6\ua065\ua90a\u7d64\u8e0a\u2479\u8b3b\u3476a\ua7f5\ua4f5\ua078\ua90b\u7d36") + this);
        }
    }

    protected abstract void inject(Target var1, InjectionNodes.InjectionNode var2);

    protected void postInject(Target target, InjectionNodes.InjectionNode injectionNode) {
    }

    protected AbstractInsnNode invokeHandler(InsnList insnList) {
        return this.invokeHandler(insnList, this.methodNode);
    }

    protected AbstractInsnNode invokeHandler(InsnList insnList, MethodNode methodNode) {
        int n;
        int n2 = (methodNode.access & (0x85FD3A4E ^ 0x85FD3A4C)) != 0 ? 0x960A26F0 ^ 0x960A26F1 : (n = 0xB7363C5B ^ 0xB7363C5B);
        int n3 = this.isStatic ? 0x10CD1A48 ^ 0x10CD1AF0 : (n != 0 ? 0x333B07CE ^ 0x333B0779 : 0x4E8F6ABF ^ 0x4E8F6A09);
        MethodInsnNode methodInsnNode = new MethodInsnNode(n3, this.classNode.name, methodNode.name, methodNode.desc, (0x1970F041 ^ 0x1970F041) != 0);
        insnList.add(methodInsnNode);
        this.info.addCallbackInvocation(methodNode);
        return methodInsnNode;
    }

    protected void throwException(InsnList insnList, String string, String string2) {
        insnList.add(new TypeInsnNode(0x16F730B9 ^ 0x16F73002, string));
        insnList.add(new InsnNode(0xD7FBF745 ^ 0xD7FBF71C));
        insnList.add(new LdcInsnNode(string2));
        insnList.add(new MethodInsnNode(0xF92A70D1 ^ 0xF92A7066, string, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(".\ua7ef\ua4bb\ua078\ua911\u7d28"), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(":\ua7ca\ua4bf\ua070\ua913\u7d77\u8e05\u2476\u8b36\u3479u\ua7a9\ua486\ua065\ua917\u7d7f\u8e44\u247d\u8b6c\u343eD"), (0x48D28BD0 ^ 0x48D28BD0) != 0));
        insnList.add(new InsnNode(0x4F3C7532 ^ 0x4F3C758D));
    }

    public static boolean canCoerce(Type type, Type type2) {
        if (type.getSort() == (0xED49EB4D ^ 0xED49EB47)) {
            if (type2.getSort() == (0xD96C2140 ^ 0xD96C214A)) {
                return Injector.canCoerce(ClassInfo.forType(type), ClassInfo.forType(type2));
            }
        }
        return Injector.canCoerce(type.getDescriptor(), type2.getDescriptor());
    }

    public static boolean canCoerce(String string, String string2) {
        block3: {
            block2: {
                if (string.length() > (0x8B573A6A ^ 0x8B573A6B)) break block2;
                if (string2.length() <= (0xE87E834F ^ 0xE87E834E)) break block3;
            }
            return (0x2EE3BE6D ^ 0x2EE3BE6D) != 0;
        }
        return Injector.canCoerce(string.charAt(0xBC55EF39 ^ 0xBC55EF39), string2.charAt(0x86990592 ^ 0x86990592));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean canCoerce(char c, char c2) {
        int n;
        if (c2 == (0xE79A75CA ^ 0xE79A7583)) {
            if (\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7c4\ua486\ua052\ua93f").indexOf(c) > (0x6F1F58D3 ^ 0x90E0A72C)) {
                n = 0x92E4D21 ^ 0x92E4D20;
                return n != 0;
            }
        }
        n = 0xDAC64A4D ^ 0xDAC64A4D;
        return n != 0;
    }

    private static boolean canCoerce(ClassInfo classInfo, ClassInfo classInfo2) {
        return (classInfo != null && classInfo2 != null && (classInfo2 == classInfo || classInfo2.hasSuperClass(classInfo)) ? 0xEE97CC5C ^ 0xEE97CC5D : 0xF5F01650 ^ 0xF5F01650) != 0;
    }

    public static final class TargetNode {
        final AbstractInsnNode insn;
        final Set<InjectionPoint> nominators = new HashSet<InjectionPoint>();

        TargetNode(AbstractInsnNode abstractInsnNode) {
            this.insn = abstractInsnNode;
        }

        public AbstractInsnNode getNode() {
            return this.insn;
        }

        public Set<InjectionPoint> getNominators() {
            return Collections.unmodifiableSet(this.nominators);
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != TargetNode.class) {
                return (0xBF7B38D7 ^ 0xBF7B38D7) != 0;
            }
            return (((TargetNode)object).insn == this.insn ? 0xA680F4B5 ^ 0xA680F4B4 : 0x6A8209DB ^ 0x6A8209DB) != 0;
        }

        public int hashCode() {
            return this.insn.hashCode();
        }
    }
}

