/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.modify;

import java.util.Collection;
import java.util.ListIterator;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.modify.ModifyVariableInjector;
import org.spongepowered.asm.mixin.injection.struct.InjectionPointData;
import org.spongepowered.asm.mixin.injection.struct.Target;

@InjectionPoint.AtCode(value="LOAD")
public class BeforeLoadLocal
extends ModifyVariableInjector.ContextualInjectionPoint {
    private final Type returnType;
    private final LocalVariableDiscriminator discriminator;
    private final int opcode;
    private final int ordinal;
    private boolean opcodeAfter;

    protected BeforeLoadLocal(InjectionPointData injectionPointData) {
        this(injectionPointData, 0x213619E0 ^ 0x213619F5, (0xDCEC29E2 ^ 0xDCEC29E2) != 0);
    }

    protected BeforeLoadLocal(InjectionPointData injectionPointData, int n, boolean bl) {
        super(injectionPointData.getContext());
        this.returnType = injectionPointData.getMethodReturnType();
        this.discriminator = injectionPointData.getLocalVariableDiscriminator();
        this.opcode = injectionPointData.getOpcode(this.returnType.getOpcode(n));
        this.ordinal = injectionPointData.getOrdinal();
        this.opcodeAfter = bl;
    }

    @Override
    boolean find(Target target, Collection<AbstractInsnNode> collection) {
        SearchState searchState = new SearchState(this.ordinal, this.discriminator.printLVT());
        ListIterator<AbstractInsnNode> listIterator = target.method.instructions.iterator();
        while (listIterator.hasNext()) {
            int n;
            AbstractInsnNode abstractInsnNode = listIterator.next();
            if (searchState.isPendingCheck()) {
                n = this.discriminator.findLocal(this.returnType, this.discriminator.isArgsOnly(), target, abstractInsnNode);
                searchState.check(collection, abstractInsnNode, n);
                continue;
            }
            if (!(abstractInsnNode instanceof VarInsnNode) || abstractInsnNode.getOpcode() != this.opcode) continue;
            if (this.ordinal != (0xD4B4A3B1 ^ 0x2B4B5C4E) && searchState.success()) continue;
            searchState.register((VarInsnNode)abstractInsnNode);
            if (this.opcodeAfter) {
                searchState.setPendingCheck();
                continue;
            }
            n = this.discriminator.findLocal(this.returnType, this.discriminator.isArgsOnly(), target, abstractInsnNode);
            searchState.check(collection, abstractInsnNode, n);
        }
        return searchState.success();
    }

    static class SearchState {
        private final boolean print;
        private final int targetOrdinal;
        private int ordinal = 0x9CB545F3 ^ 0x9CB545F3;
        private boolean pendingCheck = 0x8F8F7CF4 ^ 0x8F8F7CF4;
        private boolean found = 0x138BE889 ^ 0x138BE889;
        private VarInsnNode varNode;

        SearchState(int n, boolean bl) {
            this.targetOrdinal = n;
            this.print = bl;
        }

        boolean success() {
            return this.found;
        }

        boolean isPendingCheck() {
            return this.pendingCheck;
        }

        void setPendingCheck() {
            this.pendingCheck = 0x3A788069 ^ 0x3A788068;
        }

        void register(VarInsnNode varInsnNode) {
            this.varNode = varInsnNode;
        }

        void check(Collection<AbstractInsnNode> collection, AbstractInsnNode abstractInsnNode, int n) {
            this.pendingCheck = 0x4C61F68F ^ 0x4C61F68F;
            if (n != this.varNode.var) {
                if (n > (0x71B5C705 ^ 0x8E4A38FB) || !this.print) {
                    return;
                }
            }
            if (this.targetOrdinal == (0xB8182E37 ^ 0x47E7D1C8) || this.targetOrdinal == this.ordinal) {
                collection.add(abstractInsnNode);
                this.found = 0x23B5EDB2 ^ 0x23B5EDB3;
            }
            this.ordinal += 0x96267F02 ^ 0x96267F03;
            this.varNode = null;
        }
    }
}

